(* ::Package:: *)

(* ::Input::Initialization:: *)
failedToLoadGroupMath[]:=(
Print[Style["Problem: failed to load the GroupMath package.",{Bold,Darker[Red],FontFamily->"Consolas"}],Style[" Please ensure that ",{GrayLevel[0.5],FontFamily->"Consolas"}],Style[Hyperlink["GroupMath","http://renatofonseca.net/groupmath.php",Appearance->"Palette"],{GrayLevel[0.5],FontFamily->"Consolas"}],Style[" is installed in any of the following paths:\n",{GrayLevel[0.5],FontFamily->"Consolas"}],Grid[{Style[#,{FontFamily->"Consolas",GrayLevel[0.5]}]}&/@$Path,Alignment->{Left,Baseline}]];
Print[Style["Alternatively, you may try first to load GroupMath manually, and then load Sym2Int.",{GrayLevel[0.5],FontFamily->"Consolas"}]];
);
GroupMathAlreadyLoadedQ=Or@@(!StringFreeQ[#,"GroupMath`"]&/@Contexts[]);
If[!GroupMathAlreadyLoadedQ,
Quiet[Check[Get["GroupMath`"],failedToLoadGroupMath[]]];
];


(* ::Input::Initialization:: *)
logoSym2Int=Image[Uncompress["1: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"],ColorSpace->"RGB"];
(* logoSym2Int=Image[logoSym2Int,ImageSize\[Rule]135]; *)


(* ::Input::Initialization:: *)
SMexample="(* ***** Standard Model ***** *)\ngaugeGroup[SM]^={SU3,SU2,U1};\n\nfld1={\"u\",{3,1,2/3},\"R\",\"C\",3};\nfld2={\"d\",{3,1,-1/3},\"R\",\"C\",3};\nfld3={\"Q\",{3,2,1/6},\"L\",\"C\",3};\nfld4={\"e\",{1,1,-1},\"R\",\"C\",3};\nfld5={\"L\",{1,2,-1/2},\"L\",\"C\",3};\nfld6={\"H\",{1,2,1/2},\"S\",\"C\",1};\nfields[SM]^={fld1,fld2,fld3,fld4,fld5,fld6};\n\nGenerateListOfCouplings[SM,MaxOrder\[Rule]4];";

THDMexample="(* ***** Two Higgs doublet model ***** *)\ngaugeGroup[THDM]^={SU3,SU2,U1};\n\nfld1={\"u\",{3,1,2/3},\"R\",\"C\",3};\nfld2={\"d\",{3,1,-1/3},\"R\",\"C\",3};\nfld3={\"Q\",{3,2,1/6},\"L\",\"C\",3};\nfld4={\"e\",{1,1,-1},\"R\",\"C\",3};\nfld5={\"L\",{1,2,-1/2},\"L\",\"C\",3};\nfld6={\"H1\",{1,2,1/2},\"S\",\"C\",1};\nfld7={\"H2\",{1,2,1/2},\"S\",\"C\",1};\nfields[THDM]^={fld1,fld2,fld3,fld4,fld5,fld6,fld7};\n\nGenerateListOfCouplings[THDM];";

SMSeesawIIexample="(* ***** Standard Model plus one complex scalar triplet ***** *)\ngaugeGroup[SMSeesawII]^={SU3,SU2,U1};\n\nfld1={\"u\",{3,1,2/3},\"R\",\"C\",3};\nfld2={\"d\",{3,1,-1/3},\"R\",\"C\",3};\nfld3={\"Q\",{3,2,1/6},\"L\",\"C\",3};\nfld4={\"e\",{1,1,-1},\"R\",\"C\",3};\nfld5={\"L\",{1,2,-1/2},\"L\",\"C\",3};\nfld6={\"H\",{1,2,1/2},\"S\",\"C\",1};\nfld7={\"\[CapitalDelta]\",{1,3,1},\"S\",\"C\",1};\nfields[SMSeesawII]^={fld1,fld2,fld3,fld4,fld5,fld6,fld7};\n\nGenerateListOfCouplings[SMSeesawII,MaxOrder\[Rule]4];";

SVSexample="gaugeGroup[SVS331Model] ^= {SU3, SU3, U1};\n\n\[Psi]l = {\"\[Psi]l\", {1, 3, -1/3}, \"L\", \"C\", 3};\nec = {\"ec\", {1, 1, 1}, \"L\", \"C\", 3};\nQ12 = {\"Q12\", {3, -3, 0}, \"L\", \"C\", 2};\nQ3 = {\"Q3\", {3, 3, 1/3}, \"L\", \"C\", 1};\nuc = {\"uc\", {-3, 1, -2/3}, \"L\", \"C\", 4};\ndc = {\"dc\", {-3, 1, 1/3}, \"L\", \"C\", 5};\n\n\[Phi]1 = {\"\[Phi]1\", {1, 3, 2/3}, \"S\", \"C\", 1};\n\[Phi]23 = {\"\[Phi]23\", {1, 3, -1/3}, \"S\", \"C\", 2}; (* Note that \[Phi]2 and \[Phi]3 are seems as two flavors of \[Phi]23 *)\n\nfields[SVS331Model] ^= {\[Psi]l, ec, Q12, Q3, uc, dc, \[Phi]1, \[Phi]23};\nGenerateListOfCouplings[SVS331Model];";

PPFexample="gaugeGroup[PPF331Model]^={SU3,SU3,U1};\n\n\[Psi]l={\"\[Psi]l\",{1,3,0},\"L\",\"C\",3};\nQ23L={\"Q23L\",{3,-3,-1/3},\"L\",\"C\",2};\nQ1L={\"Q1L\",{3,3,2/3},\"L\",\"C\",1};\nuc={\"uc\",{-3,1,-2/3},\"L\",\"C\",3};\ndc={\"dc\",{-3,1,1/3},\"L\",\"C\",3};\nJ12={\"J12\",{-3,1,4/3},\"L\",\"C\",1};\nJ3={\"J3\",{-3,1,-5/3},\"L\",\"C\",2};\n\n\[Chi]={\"\[Chi]\",{1,3,-1},\"S\",\"C\",1};\n\[Eta]={\"\[Eta]\",{1,3,0},\"S\",\"C\",1};\n\[Rho]={\"\[Rho]\",{1,3,1},\"S\",\"C\",1};\n\nfields[PPF331Model]^={\[Psi]l,Q23L,Q1L,uc,dc,J12,J3,\[Chi],\[Eta],\[Rho]};\n\nGenerateListOfCouplings[PPF331Model];";

SU5example="gaugeGroup[modelSU5]^={SU5};\n\nfld1={\"F\",{-5},\"L\",\"C\",3};\nfld2={\"T\",{10},\"L\",\"C\",3};\nfld3={\"5\",{5},\"S\",\"C\",1};\nfld4={\"24\",{24},\"S\",\"R\",1};\nfields[modelSU5]^={fld1,fld2,fld3,fld4};\n\nGenerateListOfCouplings[modelSU5];";

SMEFTExamplePart1="(* ***** Standard Model Effective Field Theory (SMEFT) up to dimension 10 ***** *)\ngaugeGroup[SM]^={SU3,SU2,U1};\n\nfld1={\"u\",{3,1,2/3},\"R\",\"C\",3};\nfld2={\"d\",{3,1,-1/3},\"R\",\"C\",3};\nfld3={\"Q\",{3,2,1/6},\"L\",\"C\",3};\nfld4={\"e\",{1,1,-1},\"R\",\"C\",3};\nfld5={\"L\",{1,2,-1/2},\"L\",\"C\",3};\nfld6={\"H\",{1,2,1/2},\"S\",\"C\",1};\nfields[SM]^={fld1,fld2,fld3,fld4,fld5,fld6};\n\nsavedResults=GenerateListOfCouplings[SM,MaxOrder\[Rule]10,Verbose\[Rule]\"OnlyStatistics\"];";

SMEFTExamplePart2="(* Convert result into the notation of the datafiles of JHEP 1708 (2017) 016, arXiv:1512.03433 [hep-ph] *)\nConvertSym2IntResult[termAll_]:=Module[{rule,aux,result},\nrule={-10\[Rule]Br,-9\[Rule]Wr,-8\[Rule]Gr,-6\[Rule]Hd,-5\[Rule]Ld,-4\[Rule]e,-3\[Rule]Qd,-2\[Rule]d,-1\[Rule]u,0\[Rule]t,1\[Rule]ud,2\[Rule]dd,3\[Rule]Q,4\[Rule]ed,5\[Rule]L,6\[Rule]H,8\[Rule]Gl,9\[Rule]Wl,10\[Rule]Bl};\n\naux=If[termAll[[4]],{termAll[[2]]},{termAll[[2]],-termAll[[2]]}];\nresult=Expand[termAll[[5]]Total[Times@@@(aux/.rule)]];\n\nReturn[result];\n]\n\nTotal[ConvertSym2IntResult/@savedResults]";

SMEFTExamplePart3="(* Select operators which violate baryon number by +-2 units *)\nBaryonNumber[term_]:=Module[{baryonNumber},\nbaryonNumber=Sign[term[[2]]].(Abs[term[[2]]]/.{0\[Rule]0,1\[Rule]1/3,2\[Rule]1/3,3\[Rule]1/3,4\[Rule]0,5\[Rule]0,6\[Rule]0,8\[Rule]0,9\[Rule]0,10\[Rule]0});\nReturn[baryonNumber];\n]\n\naux=Cases[savedResults,x_/;Abs[BaryonNumber[x]]\[Equal]2\[RuleDelayed]x[[1]]];\nPrintOperatorTable[SM,savedResults[[aux]]]";

textPickOperator1="(* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)(* ++++++++++++++++ Consider a model with a complex bi-doublet of SU(2)xSU(2)  +++++++++++++++++++++ *)\[IndentingNewLine](* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)\[IndentingNewLine]\[IndentingNewLine](* Apply EOMs redundancies? [default=True] *)\[IndentingNewLine]$Sym2IntUseEOM=True;\[IndentingNewLine](* Apply IBP redundancies? [default=True] *)\[IndentingNewLine]$Sym2IntUseIBP=True;\[IndentingNewLine]
gaugeGroup[scalarModel]^={SU2,SU2};\[IndentingNewLine]
bidoublet={\"\[CapitalPhi]\",{2,2},\"S\",\"C\",3};
fields[scalarModel]^={bidoublet};

outputData=GenerateListOfCouplings[scalarModel,MaxOrder\[Rule]8,Verbose\[Rule]False];\[IndentingNewLine]\[IndentingNewLine](* The results (cointaing many operators) were saved in 'outputData'. *)\[IndentingNewLine](* The function PickParticularOperators requires the model name (scalarModel), this output (outputData) and a string such as 'D D \[CapitalPhi] \[CapitalPhi] \[CapitalPhi] \[CapitalPhi]' identifying the desired operator(s): PickParticularOperators[<model>,<saved results>,<string>] *)\[IndentingNewLine](* For the string: 'D' stands for a covariant derivative; '*' after a field name denotes conjugation (inside parentesis it also mathcs the unconjugated field) *)";

textPickOperator2="(* Find operators with 2 derivatives and 4 \[CapitalPhi]'s where at exactly two of them are conjugated *)\[IndentingNewLine]PickParticularOperators[scalarModel,outputData,\"D D \[CapitalPhi] \[CapitalPhi]* \[CapitalPhi] \[CapitalPhi]*\"]\[IndentingNewLine]\[IndentingNewLine](* Find operators with 2 derivatives and 4 \[CapitalPhi]'s where at most two of them are conjugated *)\[IndentingNewLine]PickParticularOperators[scalarModel,outputData,\"D D \[CapitalPhi](*) \[CapitalPhi](*) \[CapitalPhi] \[CapitalPhi]\"]\[IndentingNewLine]\[IndentingNewLine](* F1=Field strength tensor of the first SU(2); F2=Field strength tensor of the second SU(2) *)\[IndentingNewLine](* Find operators with 2 \[CapitalPhi]'s and 3 F1's (maybe conjugated). Because F1 F1 F1 \[CapitalPhi]* \[CapitalPhi]* is complex, it is considered the same as F1* F1* F1* \[CapitalPhi] \[CapitalPhi] and therefore it will be matched.  *)\[IndentingNewLine]PickParticularOperators[scalarModel,outputData,\"F1(*) F1(*) F1(*) \[CapitalPhi] \[CapitalPhi]\"]";

textFlags="(* Don't apply EOMs redundancies *)\[IndentingNewLine]$Sym2IntUseEOM=False; (* [default=True] *)\[IndentingNewLine]\[IndentingNewLine](* Also don't apply IBP redundancies *)\[IndentingNewLine]$Sym2IntUseIBP=False;  (* [default=True] *)\[IndentingNewLine]\[IndentingNewLine](* ***** Let us take SMEFT up to dimension 6 as an example ***** *)
gaugeGroup[SM]^={SU3,SU2,U1};

fld1={\"u\",{3,1,2/3},\"R\",\"C\",3};
fld2={\"d\",{3,1,-1/3},\"R\",\"C\",3};
fld3={\"Q\",{3,2,1/6},\"L\",\"C\",3};
fld4={\"e\",{1,1,-1},\"R\",\"C\",3};
fld5={\"L\",{1,2,-1/2},\"L\",\"C\",3};
fld6={\"H\",{1,2,1/2},\"S\",\"C\",1};
fields[SM]^={fld1,fld2,fld3,fld4,fld5,fld6};

GenerateListOfCouplings[SM,MaxOrder\[Rule]6];";


Block[{result},result={};
AppendTo[result,Row[{Style["XXXXXXXXXXXXXXXXXXXXXXXXXXXX ",{GrayLevel[0.5]}],Hyperlink[Mouseover[Style["Sym2Int",{GrayLevel[0.5]}],Style["Sym2Int",{Darker[Blue,0.5],Bold}]],"http://renatofonseca.net/sym2int.php"],Style[" XXXXXXXXXXXXXXXXXXXXXXXXXXX",{GrayLevel[0.5]}]}]];
AppendTo[result,Row[{Style["Version: 2.4 (05/March/2024)\nAuthor: Renato Fonseca",{GrayLevel[0.5]}]}]];
(* AppendTo[result,Row[{Style["The Sym2Int program lists all possible interactions between a given set of fields. ",{GrayLevel[0.5]}]}]]; *)
AppendTo[result,Row[{Style["References: 1703.05221 [hep-ph], 1907.12584 [hep-ph]",{GrayLevel[0.5]}]}]];
AppendTo[result,Row[{Style["The Sym2Int program lists all possible interactions between a \ngiven set of fields. ",{GrayLevel[0.5]}],Hyperlink[Mouseover[Style["This",{GrayLevel[0.5],Bold,Underlined}],Style["This",{Darker[Blue,0.5],Bold,Underlined}]],"http://renatofonseca.net/sym2int.php"],Style[" webpage explains how to use it.",{GrayLevel[0.5]}]}]];
AppendTo[result,Style["XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",{GrayLevel[0.5]}]];
(* Print[Row[result,"\n",BaseStyle->(FontFamily->"Consolas")]]; *)
Print[Grid[{{Image[ImagePad[logoSym2Int,8,Transparent],ImageSize->131+8],Row[result,"\n",BaseStyle->(FontFamily->"Consolas")]}},Alignment->{Left,Center}]];

];

Print[Style["Get started quickly by considering some examples (click on one of the models below):",{GrayLevel[0.5],FontFamily->"Consolas"}]];


CDoc[x_]:=CreateDocument[x,WindowSize->{1000,600}]

buttonSM=Button[Style["Standard Model",{Darker[Red],Bold,FontFamily->"Consolas"}],CDoc[Cell[BoxData[SMexample],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"];
buttonTHDM=Button[Style["Two Higgs Doublet Model",{Darker[Red],Bold,FontFamily->"Consolas"}],CDoc[Cell[BoxData[THDMexample],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"];
buttonSMSeesawII=Button[Style["SM+scalar triplet",{Darker[Red],Bold,FontFamily->"Consolas"}],CDoc[Cell[BoxData[SMSeesawIIexample],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"];
buttonPPF=Button[Style[Column[{"Pisano-Pleitez-","-Frampton 331 Model"},Center],{Darker[Red],Bold,FontFamily->"Consolas"}],CDoc[Cell[BoxData[PPFexample],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"];
buttonSVS=Button[Style[Column[{"Singer-Valle-","-Schechter 331 Model"},Center],{Darker[Red],Bold,FontFamily->"Consolas"}],CDoc[Cell[BoxData[SVSexample],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"];
buttonSU5=Button[Style["SU(5) Model",{Darker[Red],Bold,FontFamily->"Consolas"}],CDoc[Cell[BoxData[SU5example],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"];
buttonSMEFT=Button[Style["SMEFT",{Darker[Red],Bold,FontFamily->"Consolas"}],CDoc[{Cell[BoxData[SMEFTExamplePart1],"Input",Background->Lighter[Orange,0.9],GeneratedCell->False,CellLabel->"PART1"],Cell[BoxData[SMEFTExamplePart2],"Input",Background->Lighter[Orange,0.9],GeneratedCell->False,CellLabel->"PART2"],Cell[BoxData[SMEFTExamplePart3],"Input",Background->Lighter[Orange,0.9],GeneratedCell->False,CellLabel->"PART3"]}],Appearance->"DialogBox"];
Print[Grid[{{buttonSM,buttonSMEFT,buttonTHDM,buttonSMSeesawII},{buttonPPF,buttonSVS,buttonSU5}}]];




Print[Style["The flags $Sym2IntUseEOM and $Sym2IntUseIBP control the usage of EOM and IBP \nredundancies (click below for an example). \nThe default value is True for both (all redundancies are taken into account). ",{GrayLevel[0.5],FontFamily->"Consolas"}]];
(*
Print[Button[Style["Turning on and off usage of IBP and EOM relations",Rule[LineColor,Darker[Blue]],Rule[FrontFaceColor,Darker[Blue]],Rule[BackFaceColor,Darker[Blue]],Rule[GraphicsColor,Darker[Blue]],Rule[FontFamily,"Consolas"],Rule[FontWeight,Bold],Rule[FontColor,Darker[Blue]]],CellPrint[Cell[BoxData[textFlags],"Input",Rule[Background,Lighter[Lighter[Blue],0.9`]]]],Rule[Appearance,"DialogBox"],Rule[Evaluator,Automatic],Rule[Method,"Preemptive"]]];
*)
Print[Button[Style["Turning on and off usage of IBP and EOM relations",Rule[LineColor,Darker[Blue]],Rule[FrontFaceColor,Darker[Blue]],Rule[GraphicsColor,Darker[Blue]],Rule[FontFamily,"Consolas"],Rule[FontWeight,Bold],Rule[FontColor,Darker[Blue]]],CreateDocument[Cell[BoxData[textFlags],"Input",Rule[Background,Lighter[Lighter[Blue],0.9`]]],WindowSize->{1000,600}],Rule[Appearance,"DialogBox"],Rule[Evaluator,Automatic],Rule[Method,"Preemptive"]]]

Print[Style["The function PickParticularOperators can be used to pick specific operators out from\nthe full list (click below for an example).",{GrayLevel[0.5],FontFamily->"Consolas"}]];
(*
Print[Button[Style["Easily picking particular operators out of the full result",Rule[LineColor,Darker[Blue]],Rule[FrontFaceColor,Darker[Blue]],Rule[BackFaceColor,Darker[Blue]],Rule[GraphicsColor,Darker[Blue]],Rule[FontFamily,"Consolas"],Rule[FontWeight,Bold],Rule[FontColor,Darker[Blue]]],CompoundExpression[CellPrint[Cell[BoxData[textPickOperator2],"Input",Rule[Background,Lighter[Lighter[Blue],0.9`]],Rule[GeneratedCell,False],Rule[CellLabel,"PART2"]]],CellPrint[Cell[BoxData[textPickOperator1],"Input",Rule[Background,Lighter[Lighter[Blue],0.9`]]]]],Rule[Appearance,"DialogBox"],Rule[Evaluator,Automatic],Rule[Method,"Preemptive"]]];
*)
Print[Button[Style["Easily picking particular operators out of the full result",Rule[LineColor,Darker[Blue]],Rule[FrontFaceColor,Darker[Blue]],Rule[GraphicsColor,Darker[Blue]],Rule[FontFamily,"Consolas"],Rule[FontWeight,Bold],Rule[FontColor,Darker[Blue]]],CreateDocument[{Cell[BoxData[textPickOperator1],"Input",Rule[GeneratedCell,True],Rule[Background,Lighter[Lighter[Blue],0.9`]],CellAutoOverwrite->False],Cell[BoxData[textPickOperator2],"Input",Rule[GeneratedCell,False],Rule[Background,Lighter[Lighter[Blue],0.9`]],CellAutoOverwrite->True]},WindowSize->{1000,600}],Rule[Appearance,"DialogBox"],Rule[Evaluator,Automatic],Rule[Method,"Preemptive"]]];


(* ::Input::Initialization:: *)
$Sym2IntUseEOM=True;

$Sym2IntUseIBP=True;

(* Can be used to change the number of F\[Mu]\[Nu]'s of each type considered. SM example: $GaugeBosonMultiplicity={nG,nW,nB}. *)
$GaugeBosonMultiplicity=1;


(* ::Input::Initialization:: *)
(* This funtion generates all terms up to some order allowed by gauge symmetry *)
Options[GenerateListOfCouplings]={Verbose->True,HCTerms->False,CalculateSnSymmetries->True,CalculateInvariants->False,SymExcludedOps->False,MaxOrder->4,MassDimensions->{},GrassmannCorrection->None,IncludeDerivatives->True,UseEOM->True};
GenerateListOfCouplings[model_,OptionsPattern[]]:=Module[{reps\[UnderBracket]lorentz,order,listOfInteractions,result,operatorTypes,outputData,toPrint,aux,vSpace},

(* .................................................................................... *)
(* ............................... Initialize variables ............................... *)
(* .................................................................................... *)

(* clear this variable *)
fieldsAUX[model]^={};

(* The extra symmetry charges (non-gauge); reps\[UnderBracket]discreteCharges is DEPRECATED  *)
If[Head[ungaugedGroup[model]]=!=ungaugedGroup&&ungaugedGroup[model]=!={},

ungaugedCharges[model]^=fields[model][[All,6]];
,
ungaugedGroup[model]^={};
ungaugedCharges[model]^=ConstantArray[{},Length[fields[model]]];
];

(* The mass dimensions *)
If[OptionValue[MassDimensions]==={},
reps\[UnderBracket]lorentz=SimpleLorentzInputConversion/@fields[model][[All,3]];
massDs[model]^=If[Mod[Total[reps\[UnderBracket]lorentz[[#]],2],2]==0,1,3/2]&/@Range[Length[fields[model]]];
,
massDs[model]^=OptionValue[MassDimensions];
];

(* Grassmann nature of the fields; True=anti-commutes; False=commutes *)
If[OptionValue[GrassmannCorrection]===None,
grassmannNature[model]^=Mod[Total[#,2],2]==1&/@reps\[UnderBracket]lorentz;
,
grassmannNature[model]^=OptionValue[GrassmannCorrection];
];

(* This is the index reserved to a pure derivative, which later on is added to the list of input fields *)
derivativeIndex[model]^=Length[fields[model]]+1;

order=OptionValue[MaxOrder];

(* .................................................................................... *)
(* ............. Find list of interactions - done by FindAllInteractions .............. *)
(* .................................................................................... *)

(* This step may change: fields[model], fieldsAUX[model] *)
listOfInteractions=FindAllInteractions[model,MaxOrder->order,HCTerms->OptionValue[HCTerms],IncludeDerivatives->OptionValue[IncludeDerivatives],UseEOM->OptionValue[UseEOM]];
 
If[!$Sym2IntUseIBP,
listOfInteractions=DeleteCases[listOfInteractions,x_/;MemberQ[x,derivativeIndex[model]]];
];

(* .................................................................................... *)
(* .............. Analize each interaction - done by AnalizeInteraction ............... *)
(* .................................................................................... *)

(* We would like to add more information to resultRaw. In particular, each entry of result, result[[i]], will be of the form  {resultRaw[[i]],<Sn information>, <invariants>}. The last two entries are only calculated if the user so wishes; otherwise their value is {} *)

(* For now only calculate explicit invariants if CalculateInvariants=True and IncludeDerivatives=False; *)

result=AnalizeInteraction[model,#,CalculateSnSymmetries->OptionValue[CalculateSnSymmetries],CalculateInvariants->(OptionValue[CalculateInvariants]&&!OptionValue[IncludeDerivatives])]&/@listOfInteractions;

If[!OptionValue[SymExcludedOps]&&(OptionValue[CalculateSnSymmetries]||OptionValue[CalculateInvariants]),
result=DeleteCases[result,x_/;!x[[4]]];
];
result=result[[All,1;;3]];

(* .................................................................................... *)
(* ..................... Condense the various operator types which .................... *)
(* .............. only differ by the field where derivatives are applied .............. *)
(* .................................................................................... *)


operatorTypes=OperatorsOfEachType[model,result,OptionValue[CalculateSnSymmetries]]//Transpose;

(* Delete those cases where the total number of operators is 0 *)
operatorTypes=DeleteCases[operatorTypes,x_/;x[[5]]===0];

outputData=Table[Prepend[ReorganizeOperatorData[model,operatorTypes[[i]],result[[operatorTypes[[i,2]]]]],i],{i,Length[operatorTypes]}];


(* Print["P6 ",TimeUsed[]-tmp]; *)

(* .................................................................................... *)
(* ...... Last part: make arrangements to produce a final list with all the data ...... *)
(* .................................................................................... *)

Sym2Int\[UnderBracket]Table=Null;
vSpace="";

If[OptionValue[Verbose]=!=False,
If[!$Sym2IntUseEOM,
Print[Style["NOTE:",{Bold,Underlined,FontFamily->"Consolas",Black}],Style["The flag $Sym2IntUseEOM is set to False, which mean that equations of motion are not being used to remove redundant operators. As a consequence Sym2Int will not distinguish the fields F1, F2, ... (the left-handed part of the field strenght tensors, transforming as (1,0) under the Lorentz group) from their conjugates F1*, F2*, ... (transforming as (0,1) under the Lorentz group). Furthermore, all operators with F1(*), F2(*), ... will be marked as being real (so the counting of such operators/terms refers to real ones). The reason: without the equations of motion, the Bianchi identities can be used to remove operators with Fi or Fi*, turning the counting ambiguous." ,{Bold,FontFamily->"Consolas",Black}]];
];
];

If[OptionValue[Verbose]=!=False&&OptionValue[Verbose]=!="OnlyStatistics",

If[Length[outputData]<=200,

toPrint=BuildTableToPrint[model,outputData,OptionValue[CalculateSnSymmetries],OptionValue[Verbose]];
Sym2Int\[UnderBracket]OperatorTable=toPrint;
Print[toPrint];
vSpace="\n";
,
Print[Style["WARNING: there are more than 200 types of operators. It is not a good idea to try to print them on Mathematica's front end. Use the raw data output of GenerateListOfCouplings instead.",{Bold,FontFamily->"Consolas",Darker[Red]}]];
vSpace="\n";
];
];

If[OptionValue[Verbose]=!=False,

aux=ModelStatistics[outputData,order];
Sym2Int\[UnderBracket]Statistics=aux[[1]];
Sym2Int\[UnderBracket]StatisticsTable=aux[[2]];
Print[Style[vSpace<>"***************************** Statistics ****************************",{Bold,FontFamily->"Consolas"}]];
Print[aux[[2]]];
];

(* Print["P7 ",TimeUsed[]-tmp]; *)

Return[outputData];
]


(* ::Input::Initialization:: *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX FindAllInteractions XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* FindAllInteractions generates list of interactions which are invariant under the gauge, lorentz, and discrete groups. The list is elaborated assuming infinite copies of each field. *)
(* Output of the function is a list {<int1>, <int2>,...} where each intN={<field1>,<field2>,...} gives the list of participating fields, given by their position in the model list (and a -1 sign means conjugation) *)
Options[FindAllInteractions]={HCTerms->False,MaxOrder->4,IncludeDerivatives->True,UseEOM->True};
FindAllInteractions[model_,OptionsPattern[]]:=Module[{nameOfTheFields,reps\[UnderBracket]gaugeIn,reps\[UnderBracket]lorentzIn,reps\[UnderBracket]RI,reps\[UnderBracket]copies,reps\[UnderBracket]gauge,reps\[UnderBracket]otherCharges,order,reps\[UnderBracket]lorentz,fullGroup,theFullReps,theFullRepsC,tableConjClasses,massDimensions,indicesForMod,U1pos,nonU1pos,U1charges,otherCharges,indicesForModOfNonU1s,maxF,aux,trueFieldIndicesRule,reps,result,rule,ruleForSelfConjFields,includeDerivatives,uniqueFields,gaugeBosonsIndices,gb,derBounded,derFree,aux2,replacementRule,realFieldsRule},


(* .................................................................................... *)
(* ............................... Initialize variables ............................... *)
(* .................................................................................... *)

order=OptionValue[MaxOrder];
includeDerivatives=OptionValue[IncludeDerivatives];
{nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,massDimensions,reps\[UnderBracket]otherCharges}=ExtractModelData[model][[1;;7]];
If[includeDerivatives,
AppendTo[nameOfTheFields,"D"];
AppendTo[reps\[UnderBracket]gauge,SimpleRepInputConversion[gaugeGroup[model],If[#===U1,0,1]&/@gaugeGroup[model]]];
AppendTo[reps\[UnderBracket]lorentz,SimpleLorentzInputConversion["V"]];
AppendTo[reps\[UnderBracket]RI,"R"];
AppendTo[reps\[UnderBracket]copies,1];
AppendTo[massDimensions,1];
AppendTo[reps\[UnderBracket]otherCharges,TrivialRep[ungaugedGroup[model]]]; 
];

(* .................................................................................... *)
(* .......... Prepare things for recursive function TryAllFieldCombinations ........... *)
(* .................................................................................... *)

fullGroup=Join[gaugeGroup[model],{SU2,SU2}];

theFullReps=Flatten[#,1]&/@Transpose[{reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz}];
theFullRepsC=Flatten[#,1]&/@Transpose[{ConjugateIrrep[gaugeGroup[model],#]&/@reps\[UnderBracket]gauge,Reverse/@reps\[UnderBracket]lorentz}];

tableConjClasses=Flatten/@Join[Table[Table[ConjugacyClass[fullGroup[[i]],theFullReps[[repI,i]]],{i,Length[fullGroup]}],{repI,Length[theFullReps]}],Table[Table[ConjugacyClass[fullGroup[[i]],theFullRepsC[[repI,i]]],{i,Length[fullGroup]}],{repI,Flatten[Position[reps\[UnderBracket]RI,"C"]]}]];
PrependTo[tableConjClasses,0tableConjClasses[[1]]];

(* NOTE: massDimensions is a special list at this point of the code; it includes an entry for the complex-conjugated fields and also for a dummny 'no field' *)
massDimensions=Join[massDimensions,massDimensions[[Flatten[Position[reps\[UnderBracket]RI,"C"]]]]];
PrependTo[massDimensions,1]; (* index 1 corresponds to no field; ie it is used to get the operators with less than MaxOrder *)

indicesForMod=Flatten[ConjugacyClassGroupModIndices/@fullGroup]; (* -1 means it is a U1 charge *)
U1pos=Flatten[Position[indicesForMod,-1]];
nonU1pos=Complement[Range[Length[indicesForMod]],U1pos];
U1charges=tableConjClasses[[All,U1pos]];
otherCharges=tableConjClasses[[All,nonU1pos]];
indicesForModOfNonU1s=indicesForMod[[nonU1pos]];

maxF=Length[massDimensions];

(* .................................................................................... *)
(* .................................................................................... *)
(* .................................................................................... *)
(* ............ Use conjugacy classes and U1 charges to get a reduced list ............ *)
(* .............. of POTENTIALLY gauge and lorentz invariant interactions ............. *)
(* .................................................................................... *)
(* .................................................................................... *)
(* .................................................................................... *)

(* TODO: Use also*)

ClearAll[massDData];
ClearAll[fieldsWhichCanBeAdded];
Do[massDData[i,j]=i+massDimensions[[j]];,{i,0,order,1/2},{j,Length[massDimensions]}];
Do[fieldsWhichCanBeAdded[i,minF]=DeleteCases[Flatten[Position[massDimensions,x_/;x<=i]],y_/;y<minF],{i,1/2,order,1/2},{minF,1,Length[massDimensions]}];

TryAllFieldCombinations[initCombination_,massD_,minF_]:=Block[{tmp},
If[massD==order,
aux=Total[U1charges[[initCombination]]];

If[(aux==0aux),
aux=Total[otherCharges[[initCombination]]];

If[And@@Divisible[aux,indicesForModOfNonU1s],Sow[initCombination]];
];
,
TryAllFieldCombinations[Append[initCombination,#],massDData[massD,#],#]&/@fieldsWhichCanBeAdded[order-massD,minF];
];
];
aux=Drop[Reap[TryAllFieldCombinations[{},0,1]][[2,1]],1];

(* .................................................................................... *)
(* ................ Some clean up and change of notation is necessary ................. *)
(* .................................................................................... *)

trueFieldIndicesRule=Join[Range[Length[theFullReps]],-Flatten[Position[reps\[UnderBracket]RI,"C"]]];
trueFieldIndicesRule=MapThread[Rule,{1+Range[Length[trueFieldIndicesRule]],trueFieldIndicesRule}];
aux=DeleteCases[aux,1,{2}]/.trueFieldIndicesRule;


(* POINT 1 *)

(* .................................................................................... *)
(* .... If derivatives are included, then the model to be evaluated must be changed ... *)
(* .................................................................................... *)

If[includeDerivatives,
aux=AddGaugeBosons[model,aux,massDimensions,order,1+Length[fields[model]]];


(* POINT 2 *)


aux=ApplyDerivativesToFields[aux,1+Length[fields[model]]];

(* POINT 3 *)


(* Print["P3-b ",TimeUsed[]-tmp]; *)

(* modify model reps *)
uniqueFields=Flatten[aux,1]//DeleteDuplicates;
uniqueFields=DeleteCases[DeleteDuplicates[Abs[uniqueFields]],x_/;x[[1]]==1+Length[fields[model]]];
uniqueFields=SortBy[uniqueFields,(2#[[2]]Length[uniqueFields]+#[[1]])&];

fieldsAUX[model]^=ModifyModelFieldsToIncludeDerivatives[model,uniqueFields,1+Length[fields[model]],massDimensions[[2;;-1]],reps\[UnderBracket]otherCharges];


(* POINT 4 *)

{nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,massDimensions,reps\[UnderBracket]otherCharges}=ExtractModelData[model][[1;;7]];
(* PrependTo[massDimensions,1]; (* because massDimensions[[1]] used to be a placeholder for a 'no field' *) *)


(* Change notation of the list of interactions obtained earlier *);
aux2=GatherBy[fieldsAUX[model],#[[2]]&];
replacementRule=Join[Table[aux2[[i,1,2]]->aux2[[i,All,1]],{i,Length[aux2]}],Table[{-1,1}aux2[[i,1,2]]->-aux2[[i,All,1]],{i,Length[aux2]}]];

(* realFieldsRule is necessary for some fields which consist on gauge bosons with derivatives: der^n[F+F*]. Since F is complex they might appear conjugated in the final result without this extra code *)
realFieldsRule=(-#->#&/@Flatten[Position[fieldsAUX[model][[All,6]],"R"]]);
replacementRule[[All,2]]=replacementRule[[All,2]]/.realFieldsRule;

aux=Flatten[Tuples/@(aux/.Dispatch[replacementRule]),1];
aux=DeleteDuplicates[aux]; (* Just to make sure ... due to the application of realFieldsRule *)

,
(* Even if no derivatives are to be considered, it is useful to populate fieldsAUX[model] as in the derivative case so that later on the same code can be used in all cases *)

aux2=Table[{fldI,{fldI,0},fields[model][[fldI,1]],SimpleRepInputConversion[gaugeGroup[model],fields[model][[fldI,2]]],SimpleLorentzInputConversion[fields[model][[fldI,3]]],fields[model][[fldI,4]],fields[model][[fldI,5]],massDimensions[[1+fldI]],reps\[UnderBracket]otherCharges[[fldI]],grassmannNature[model][[fldI]]},{fldI,Length[fields[model]]}];

fieldsAUX[model]^=AppendTo[aux2,{Length[fields[model]]+1,{Length[fields[model]]+1,0},"D",TrivialRep[gaugeGroup[model]],SimpleLorentzInputConversion["V"],"R",1,1,TrivialRep[ungaugedGroup[model]],True}];
];

(* .................................................................................... *)
(* ............. Now get the correct list of gauge-invariant interactions ............. *)
(* .................................................................................... *)
(* TODO: for speed the ungauged symmetries (reps\[UnderBracket]otherCharges) could already been taken partially into consideration with conjugacy classes above *)
reps=MapThread[List,{Range[Length[reps\[UnderBracket]gauge]],reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]otherCharges,reps\[UnderBracket]RI,reps\[UnderBracket]copies}];

rule=Join[Table[i->reps[[i]],{i,Length[reps\[UnderBracket]gauge]}],Table[-i->ConjugateRepSpecial[model,reps[[i]]],{i,1,Length[reps\[UnderBracket]gauge]}]];
rule=Dispatch[rule];

result=Cases[aux,x_/;ContainsSingletQ[model,x/.rule]];

(* .................................................................................... *)
(* ............................. Maybe cut down h.c. terms ............................ *)
(* .................................................................................... *)

If[!OptionValue[HCTerms],
ruleForSelfConjFields=MapThread[Rule,{-Flatten[Position[reps\[UnderBracket]RI,"R"]],Flatten[Position[reps\[UnderBracket]RI,"R"]]}];

(* Chosen terms are those with less conjugations: SortBy[#,(Count[#,x_/;x<0]&)]& *)
result=DeleteDuplicates[SortBy[#,(Count[#,x_/;x<0]&)]&/@MapThread[List,{Sort/@result,Sort/@((-result)/.ruleForSelfConjFields)}]][[All,1]];
];

(* .................................................................................... *)
(* .... Delete dim 4 or smaller interactions with derivatives and/or gauge bosons ..... *)
(* .................................................................................... *)

If[includeDerivatives,
gaugeBosonsIndices=Length[fields[model]]+1+Range[Length[gaugeGroup[model]]];
gb=If[MemberQ[gaugeBosonsIndices,#[[2,1]]],1,0]&/@fieldsAUX[model];
derBounded=fieldsAUX[model][[All,2,2]];
derFree=UnitVector[Length[fieldsAUX[model]],derivativeIndex[model]];
result=DeleteCases[result,x_/;Total[massDimensions[[Abs[x]]]]<=4&&(Total[gb[[Abs[x]]]]+Total[derBounded[[Abs[x]]]]+Total[derFree[[Abs[x]]]])>0,{1}];
];

(* .................................................................................... *)
(* .................................. Sort results .................................... *)
(* .................................................................................... *)

(* Sort results by operator dimension *)
result=SortBy[result,Total[massDimensions[[Abs[#]]]]&];

(* Now we would like to sort the fields in each interaction: this is done by Abs[<pos of the field given by user>] as the first criteria, and then conjugated fields last (second criteria) *)
result=SortBy[#,({Abs[#],-#}&)]&/@result;


Return[result];
]


(* ::Input::Initialization:: *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX AnalizeInteraction XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)


(* AnalizeInteraction considers more information about each interaction: (A) the permutation symmetry, (B) the explicit invariants, and  (C) if the operator exists at all for the given number of flavors [based on information (A)] *)
(* The interaction should have the form {<field1>,<field2>,...}, where each field is identified with its position in the model list (and a -1 sign means conjugation) *)

Options[AnalizeInteraction]={CalculateSnSymmetries->True,CalculateInvariants->False};
AnalizeInteraction[model_,fieldPositions_,OptionsPattern[]]:=Module[{nameOfTheFields,reps\[UnderBracket]gaugeIn,reps\[UnderBracket]RI,reps\[UnderBracket]copies,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,interaction,result,survivingInvariants,nameHeadsToUse,distinguishReps,gReps,lorentzRep,rep,aux,aux2,isFermionQ,needToConsiderGrassmannNature,fermionsPos,nFlavs,nFlavsMin,validInvsPos,reps,grassmannCorrection},

(* .................................................................................... *)
(* .................................. Initializations ................................. *)
(* .................................................................................... *)

{nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,reps\[UnderBracket]otherCharges,grassmannCorrection}=ExtractModelData[model][[{1,2,3,4,5,7,8}]];

(* Consider all non-abelian gauge symmetries (gauged or not). [Abelians ones have already played their role in forbidding some interactions]*)
pos1=Flatten[Position[ungaugedGroup[model],Z[_],-1]];
pos2=Flatten[Position[ungaugedGroup[model],U1,-1]];
pos1=Complement[Range[Length[ungaugedGroup[model]]],Join[pos1,pos2]];

pos2=Flatten[Position[gaugeGroup[model],U1,-1]];
pos2=Complement[Range[Length[gaugeGroup[model]]],pos2];

nonAbelianGroup=Join[gaugeGroup[model][[pos2]],ungaugedGroup[model][[pos1]]];
reps\[UnderBracket]nonAbelian=MapThread[Join,{reps\[UnderBracket]gauge[[All,pos2]],reps\[UnderBracket]otherCharges[[All,pos1]]}];

(* interaction has the format {# of the field,gauge + ungauged rep (maybe already conjugated),Lorentz rep (maybe already conjugated), is it conjugated?0=no,1=yes, # copies/flavours of the field} *)
interaction=Table[{Abs[el],If[el>0,reps\[UnderBracket]nonAbelian[[Abs[el]]],ConjugateIrrep[nonAbelianGroup,reps\[UnderBracket]nonAbelian[[Abs[el]]]]],If[el>0,reps\[UnderBracket]lorentz[[Abs[el]]],Reverse[reps\[UnderBracket]lorentz[[Abs[el]]]]],(*"DS",*)If[el>0,0,1],reps\[UnderBracket]copies[[Abs[el]]]},{el,fieldPositions}];

result={interaction,Null,Null,Null};

(* .................................................................................... *)
(* .......... Calculate the invariants (comes before permutation symmetry) ............ *)
(* .................................................................................... *)
(*
If[OptionValue[CalculateInvariants],

survivingInvariants=LorentzInvariants[gaugeGroup[model],reps\[UnderBracket]gauge[[interaction[[All,1]]]],reps\[UnderBracket]lorentz[[interaction[[All,1]]]],(interaction[[All,5]]/.{0\[Rule]False,1\[Rule]True}),DistinguishFields\[Rule](interaction[[All,1]](interaction[[All,5]]/.{0\[Rule]-1,1\[Rule]1}))];
(* Note that at this point, these are not really just the surviving invariants, since all invariants are being kept. Below, at the end of PART4, this is fixed. *)

nameHeadsToUse=Table[nameOfTheFields[[interaction[[i,1]]]]<>If[interaction[[i,5]]\[Equal]0,"","C"],{i,Length[interaction]}];
survivingInvariants[[2,All,All,0]]=Table[ConstantArray[nameHeadsToUse[[elI]],Length[survivingInvariants[[2,elI]]]],{elI,Length[survivingInvariants[[2]]]}];

result[[3]]=survivingInvariants;
];
*)

(* .................................................................................... *)
(* ................ Look at the permutation symmetry of the invariants ................ *)
(* .................................................................................... *)

If[OptionValue[CalculateSnSymmetries],
distinguishReps=interaction[[All,1]](1-2interaction[[All,4]]);
gReps=#[[2]]&/@interaction;
lorentzRep=#[[3]]&/@interaction;
reps=Flatten[#,1]&/@MapThread[List,{gReps,lorentzRep}];

If[OptionValue[CalculateInvariants],
aux=$GroupMath\[UnderBracket]Invariants\[UnderBracket]Symmetries;
,
aux=PermutationSymmetryOfInvariants[Join[nonAbelianGroup,{SU2,SU2}],reps,DistinguishFields->distinguishReps];
];

(* Correct Grassmann nature of fermions *)
isFermionQ=grassmannCorrection[[Abs[fieldPositions]]];

needToConsiderGrassmannNature=isFermionQ[[#[[1]]]]&&Length[#]>1&/@aux[[1]];
fermionsPos=Flatten[Position[needToConsiderGrassmannNature,True]];

aux[[2,All,1,fermionsPos]]=Map[SnRepTimesTotallyAntisymmetric,aux[[2,All,1,fermionsPos]],{2}];

nFlavs=interaction[[All,5]];
nFlavs=nFlavs[[#]]&/@aux[[1,All,1]];
(* nFlavsMin=If[NumericQ[#],#,1]&/@nFlavs; *)
aux[[2]]=Table[{aux[[2,i,1]],Times@@MapThread[HookContentFormula,{aux[[2,i,1]],nFlavs}],aux[[2,i,2]]},{i,Length[aux[[2]]]}];

(* Delete those cases which cannot be realized with the given number of flavors *)
aux[[2]]=DeleteCases[aux[[2]],x_/;x[[2]]===0];

(*
If[OptionValue[CalculateInvariants],
aux2=Table[{aux[[2,i,3]]Times@@(SnIrrepDim/@aux[[2,i,1]]),aux[[2,i,2]],aux[[2,i,3]]},{i,Length[aux[[2]]]}];
aux2=Range@@@Transpose[{Accumulate[aux2[[All,1]]]-aux2[[All,1]]+1,Accumulate[aux2[[All,1]]]}];
validInvsPos=Flatten[aux2[[Flatten[Position[aux[[2]],x_/;x[[2]]=!=0,{1},Heads\[Rule]False]]]]];
result[[3]]={survivingInvariants[[1,validInvsPos]],survivingInvariants[[2]]};
];
*)
result[[2]]=aux;
];

(* Can the interaction be realized with the given number of fields? *)
result[[4]]=!(Length[result[[2]]]==2&&result[[2,2]]==={});

(* simplify 1st entry of the output, which identifies the interaction (should be the same as result[[1,All,1]] (1-2result[[1,All,5]])) *)
result[[1]]=fieldPositions;

Return[result];

];


(* ::Input::Initialization:: *)
(* With derivatives the permutation information in outputData might refer to different permutation groups. ConvertToIrrepOfBiggestPermutationGroup converts it all to irreps of the same, maximal permutation group G which is dictated only by the repeated participating fields, ignoring derivatives. *)

ConvertToIrrepOfBiggestPermutationGroup[model_,result_]:=ConvertToIrrepOfBiggestPermutationGroup[model,result[[All,7]],result[[All,8,2]]]

ConvertToIrrepOfBiggestPermutationGroup[model_,repeatedfields_,symmetries_]:=Module[{newRes,aux2,res,aux4,repeatedFields,nFlavs,validCases},
newRes=Reap[Do[
aux2=symmetries[[opIdex]];

res={};
Do[
aux4=Reap[Do[

aux3=If[fldGroupIrrep==={}||Head[fldGroupIrrep[[1]]]=!=List,{{fldGroupIrrep,1}},LittlewoodRichardsonCoefficients[fldGroupIrrep]];
Sow[aux3];
,{fldGroupIrrep,irrep[[1]]}]][[2]];
aux4=TuplesWithMultiplicity[Flatten[aux4,1]];
aux4[[All,2]]=aux4[[All,2]]irrep[[2]];

res=Join[res,aux4];

,{irrep,aux2}];
res=TallyWithMultiplicity[res];
Sow[res];
,{opIdex,1,Length[symmetries]}]][[2,1]];

newRes=DeleteCases[newRes,x_/;x[[2]]===0,{2}];


(* Remove Sn reps which cannot be realized with the n-flavs of the fields. Symbolic number of flavors (such as 'n') are treated as being infinite. *)
newRes=Reap[Do[
repeatedFields=repeatedfields[[i]];
nFlavs=fieldsAUX[model][[Abs[repeatedFields],7]];
nFlavs=If[Head[#]===Symbol,\[Infinity],#]&/@nFlavs;

validCases=Cases[newRes[[i]],x_/;(nFlavs-Length/@x[[1]])==Abs[(nFlavs-Length/@x[[1]])]];
Sow[validCases];
,{i,Length[newRes]}]][[2,1]];


Return[newRes];
]


(* ::Input::Initialization:: *)

(* This function is to be applied right after AnalizeInteraction. It changes the output format, and in particular operators which only differ by where the derivatives are applied, are collapsed into a single 'term type'. *)

(* Ouptut is {<termType>, <selfConjTypeQ>,<symInformation>,<total number of operators (real if selfConjTypeQ=True, complex otherwise)>,{<min terms>,<max terms>},<explicitInvariants>}. If <min terms>=<max terms>, then only a single number is shown. *)

(* [27/Sep/2022] calculateSnDataQ option removed; assumed to be always True. *)

ReorganizeOperatorData[model_,operatorTypeData_,operatorsData_]:=Module[{derIndex,maxTerms,minTerms,data,fieldTypes,posGroupFields,symReGrouped,aux,aux2,res,output,termType,symInformation,totalOp,explicitInvariants,fldGroups,selfConjTypeValue,selfConjTermValues,nFlavs,posAlwaysValidSnIrreps,repeatedFields,massDimension,selfConjTypeQ,numberTerms,finalSymInformation,maxAllowedPerTerm,nIrreps,fieldTypesConj,transpositionToDo,symReGroupedExtra},

derIndex=derivativeIndex[model];

selfConjTypeValue=If[operatorTypeData[[6]],1,2];
selfConjTermValues=If[#,1,2]&/@operatorTypeData[[7]];

termType=Join[ConstantArray[derIndex,operatorTypeData[[1,2]]],operatorTypeData[[1,1]]];
massDimension=Total[fieldsAUX[model][[Abs[termType],8]]];
selfConjTypeQ=operatorTypeData[[6]];

(* Invariants are only calculated when CalculateSnSymmetries\[Rule]False, in which case there is just one element in the list operatorsData *)
explicitInvariants=operatorsData[[1,3]];

(* .................................................................................... *)
(* ..................... 1. Remove information about derivatives .....................  *)
(* .................................................................................... *)

data=RemoveDerivativeInfo[model,#]&/@operatorsData;

(* .................................................................................... *)
(* ........... 2. Conjugate terms if that is necessary to make it canonical ........... *)
(* ........... (i.e. with type as given by the function OperatorsOfEachType) .......... *)
(* .................................................................................... *)

Do[
If[!operatorTypeData[[4,i]],
data[[i,1]]=data[[i,1]](If[#==="C",-1,1]&/@fieldsAUX[model][[Abs[data[[i,1]]],6]]);
];
,{i,Length[operatorTypeData[[2]]]}];

(* .................................................................................... *)
(* ..... 3. Group symmetries according to the fields with the derivatives removed ..... *)
(* .................................................................................... *)

fieldTypes=DeleteDuplicates[operatorTypeData[[1,1]]];

res=Reap[Do[

aux=Flatten[Position[FieldToFieldType[model,data[[i,1]]],#]]&/@fieldTypes;
aux=Table[{j,Position[aux,data[[i,2,1,j,1]]][[1,1]]},{j,Length[data[[i,2,1]]]}];

posGroupFields=SortBy[GatherBy[aux,#[[2]]&],#[[1,2]]&][[All,All,1]];
(* posGroupFields contains the positions of the groups of fields associated to fieldTypes *)

symReGrouped=Table[el[[grp]],{el,data[[i,2,2,All,1]]},{grp,posGroupFields}];
symReGrouped=Transpose[{symReGrouped,(-1)^operatorTypeData[[3,i]]selfConjTermValues[[i]]/selfConjTypeValue data[[i,2,2,All,3]]}];

(* If the operator-type is real but a particular operator is not, it is not enought to count twice the operator (rather, one must add by hand a new operator with the fields conjugated). Imagine D(phi) phi phi*^2 with a symmetry ({1}x{1})x{2}: we must account for D( phi* ) phi* phi^2 also with symmetry {2}x({1}x{1}) *)


If[operatorTypeData[[6]]&&!operatorTypeData[[7,i]],

fieldTypesConj=If[fieldsAUX[model][[Abs[#],6]]=="R",#,-#]&/@fieldTypes;
(* With $Sym2IntUseEOM=False fieldTypes and FieldToFieldType (see above) with not distinguish an F from an F*. So, make sure that in fieldTypesConj -(index of F) \[Rule] (index of F) *)
If[!$Sym2IntUseEOM,
startFPos=Length[fields[model]]+2;
FmunuPos=Range[startFPos,startFPos-1+Length[gaugeGroup[model]]];
fieldTypesConj=fieldTypesConj/.(-#->#&/@FmunuPos);

];

transpositionToDo=Flatten[Position[fieldTypes,#]&/@fieldTypesConj];
(* Next line: If $Sym2IntUseEOM it is possible that it possible that fieldTypesConj is not a transposition of fieldTypes at all. For example,  psi psi F F and psi psi F* F* would be marked as a complex operators, but of real type; the If[...] above does solve the problem: in the case of psi psi F F, with fieldTypes={psi,F} we would get fieldTypesConj={psi*,F*} which the If[...] above converts to {psi*,F} which is still not a permutation of fieldTypes. In those cases where the operator-type is really a complex one (such as in this example), but it is marked as real because there is an F, we can avoid problems by simply setting  transpositionToDo to be trivial. *)
If[Length[transpositionToDo]<Length[fieldTypes],transpositionToDo=Range[Length[fieldTypes]]];


symReGroupedExtra=symReGrouped;
symReGroupedExtra[[All,1]]=symReGrouped[[All,1,transpositionToDo]];
symReGrouped=TallyWithMultiplicity[Join[symReGrouped,symReGroupedExtra]];
symReGrouped[[All,2]]=1/2symReGrouped[[All,2]]; (* Because previously a factor of 2 was added *)

];
Sow[symReGrouped];

,{i,Length[operatorTypeData[[2]]]}]][[2,1]];

(* .................................................................................... *)
(* ................................ 4. Build the output ............................... *)
(* .................................................................................... *)



fldGroups=operatorTypeData[[1,2]]+Flatten[Position[operatorTypeData[[1,1]],#]]&/@fieldTypes;
(* symInformation={fldGroups,TallyWithMultiplicity[Flatten[res,1]]}; *)
symInformation={fldGroups,Flatten[res,1]};


(* ++++++++++++++    keep only the non-trivial symmetry information, ie the one about truly repeated fields ++++++++++++++ *)
aux2=Flatten[Position[symInformation[[1]],x_/;Length[x]>1,{1}]];
symInformation[[2,All,1]]=symInformation[[2,All,1,aux2]];
symInformation[[1]]=symInformation[[1,aux2]];

repeatedFields=termType[[symInformation[[1,All,1]]]];

totalOp=operatorTypeData[[5]];

(* In operators with derivatives, the symInformation contains data related to potentially different Sn1xSn2x... groups. However, to count terms and indeed in the Lagrangian what matters is the bigger S_(n1+n2...)x.. permutation group, which ignores the placement of derivatives. ConvertToIrrepOfBiggestPermutationGroup converts symInformation *)
finalSymInformation={symInformation[[1]],ConvertToIrrepOfBiggestPermutationGroup[model,{repeatedFields},{symInformation[[2]]}][[1]]};


If[finalSymInformation[[2,1,1]]==={},
numberTerms=finalSymInformation[[2,1,2]];
,
{maxAllowedPerTerm,nIrreps}={Times@@@Map[SnIrrepDim,finalSymInformation[[2,All,1]],{2}],finalSymInformation[[2,All,2]]};
numberTerms=Ceiling[Max[nIrreps/maxAllowedPerTerm]];
];

output={termType/.derIndex->0,massDimension,selfConjTypeQ,totalOp,numberTerms,repeatedFields,finalSymInformation,explicitInvariants};

Return[output];
]


(* ::Input::Initialization:: *)
(* model=SM for example; interaction should be contain the field positions, with - signs eventually for conjugations example: {-5,-5,4,4,1,1,-3,-3,-2,-2,-2,-2} *)

DetailedInteractionInformation[model_,interaction_]:=Module[{aux,aux1,aux2,nCopies,fieldNames,inputMod,whichFields,fermionQ,productsOfFieldsAux,productsOfFields,result,dataToPresent,posTransition,divsV,divsH},

aux=Tally[interaction][[All,1]];
fieldNames=If[#>0,fields[model][[#,1]]<>"[R]",fields[model][[-#,1]]<>"[C]"]&/@aux;

inputMod=Tally[interaction];
inputMod[[All,1]]=Join@@@PositionToReps[model,inputMod[[All,1]]][[All,2;;3]];

productsOfFields={};
Do[
whichFields=el;
fermionQ=(Mod[whichFields[[1,4,1]]+whichFields[[1,5,1]],2]==1);
aux=PermutationSymmetryOfTensorProductParts[Join[gaugeGroup[model],{SU2,SU2}],ConstantArray[whichFields[[1]],whichFields[[2]]]];
aux=aux[[2]];

If[fermionQ,
aux[[All,1,2]]=SnRepTimesTotallyAntisymmetric[#[[1]]]&/@aux[[All,1,2]],
(* Just remove a parentesis *)
aux[[All,1,2]]=#[[1]]&/@aux[[All,1,2]]; 
];
(* productsOfFieldsAux=If[!fermionQ,Cases[aux[[2,All,1]],x_/;x[[2,1]]\[Equal]{whichFields[[2]]}\[RuleDelayed]x[[1]]],Cases[aux[[2,All,1]],x_/;x[[2,1]]\[Equal]ConstantArray[1,whichFields[[2]]]\[RuleDelayed]x[[1]]]]; *)
AppendTo[productsOfFields,aux];

,{el,inputMod}];

result={Cases[ReduceRepProduct[Join[gaugeGroup[model],{SU2,SU2}],#[[All,1,1]]],x_/;x[[1]]==0x[[1]]:>x[[2]]],#[[All,1,1]],#[[All,1,2]],Times@@#[[All,2]]}&/@Tuples[productsOfFields];
result={#[[2]],#[[3]],#[[1,1]]#[[4]]}&/@DeleteCases[result,x_/;x[[1]]==={}];
result=SortBy[result,#[[2]]&];

(* --- Get things ready to present the data ---- *)

If[Length[result]==0,Return[result]];

dataToPresent=Prepend[result,{Style[fieldNames,{Bold,Darker[Red]}],Style[Tally[interaction][[All,2]],{Bold,Darker[Red]}],Style["Number of invariants",{Bold,Darker[Red]}]}];
posTransition=Position[result[[All,2]],#][[1,1]]&/@(result[[All,2]]//DeleteDuplicates);

divsV={1->{Black,Thick},2->Lighter[Gray,0.8],3->Lighter[Gray,0.8],4->Lighter[Gray,0.8],5->{Black,Thick}};
divsH=Join[{1->{Black,Thick},2->Black,-1->{Black,Thick}},Table[i->{Black,Dashed},{i,Drop[posTransition,1]+1}],Table[i->Lighter[Gray,0.8],{i,Complement[Range[Length[posTransition]],posTransition]+1}]];

nCopies=fields[model][[Abs[Tally[interaction][[All,1]]],5]];
aux1=Times@@MapThread[HookContentFormula,{#,nCopies}]&/@Tally[result[[All,2]]][[All,1]];
aux2=ConstantArray[SpanFromAbove,#-1]&/@Tally[result[[All,2]]][[All,2]];
aux=Prepend[Flatten[MapThread[Prepend,{aux2,If[#==0,Item[#,Background->Lighter[Red,0.85]],Item[#,Background->Lighter[Green,0.85]]]&/@aux1}]],"# Parameters"];
Print[Grid[Transpose[Append[Transpose[dataToPresent],aux]],Frame->All,FrameStyle->LightGray,Spacings->{1,1},Dividers->{divsV,divsH},Background->{None,{None,{Lighter[Gray,0.95],None}}},Alignment->{Center,Center}]];

(* Add number of parameters information *)
result=Transpose[Append[Transpose[result],Times@@MapThread[HookContentFormula,{#,nCopies}]&/@result[[All,2]]]];
Return[result];
]


(* ::Input::Initialization:: *)
(* auxiliar function of DetailedInteractionInformation *)
PositionToReps[model_,fieldPositions_]:=Module[{nameOfTheFields,reps\[UnderBracket]gaugeIn,reps\[UnderBracket]lorentzIn,reps\[UnderBracket]RI,discreteSym,reps\[UnderBracket]copies,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,interaction},
{nameOfTheFields,reps\[UnderBracket]gaugeIn,reps\[UnderBracket]lorentzIn,reps\[UnderBracket]RI,reps\[UnderBracket]copies}=Transpose[fields[model]];

(* Just converts the simplified input into Dynkin coefficients *)
reps\[UnderBracket]gauge=SimpleRepInputConversion[gaugeGroup[model],#]&/@reps\[UnderBracket]gaugeIn;
reps\[UnderBracket]lorentz=SimpleLorentzInputConversion/@reps\[UnderBracket]lorentzIn;

(* interaction has the format{# of the field,gauge rep (maybe already conjugated),Lorentz rep (maybe already conjugated),discreteSym, is it conjugated?0=no,1=yes, # copies/flavours of the field} *)
interaction=Table[{Abs[el],If[el>0,reps\[UnderBracket]gauge[[Abs[el]]],ConjugateIrrep[gaugeGroup[model],reps\[UnderBracket]gauge[[Abs[el]]]]],If[el>0,reps\[UnderBracket]lorentz[[Abs[el]]],Reverse[reps\[UnderBracket]lorentz[[Abs[el]]]]],"DS",If[el>0,0,1],reps\[UnderBracket]copies[[Abs[el]]]},{el,fieldPositions}];
Return[interaction];
]


(* ::Input::Initialization:: *)
(* Use it to get {nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,massDimensions,reps\[UnderBracket]otherCharges,reps\[UnderBracket]grassmannNature} of a model *)
ExtractModelData[model_]:=Module[{nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,massDimensions,reps\[UnderBracket]otherCharges,data,reps\[UnderBracket]grassmannNature},
If[!ValueQ[fieldsAUX[model]]||(ValueQ[fieldsAUX[model]]&&fieldsAUX[model]==={}),
{nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies}=Transpose[fields[model][[All,1;;5]]]; (* exclude #6 slot, which may contain other changes *)
massDimensions=massDs[model];
reps\[UnderBracket]otherCharges=ungaugedCharges[model];
reps\[UnderBracket]grassmannNature=grassmannNature[model];

(* Just converts the simplified input into Dynkin coefficients *)
reps\[UnderBracket]gauge=SimpleRepInputConversion[gaugeGroup[model],#]&/@reps\[UnderBracket]gauge;
reps\[UnderBracket]lorentz=SimpleLorentzInputConversion/@reps\[UnderBracket]lorentz;
,
{nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,massDimensions,reps\[UnderBracket]otherCharges,reps\[UnderBracket]grassmannNature}=Transpose[fieldsAUX[model]][[{3,4,5,6,7,8,9,10}]];
];

data={nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,massDimensions,reps\[UnderBracket]otherCharges,reps\[UnderBracket]grassmannNature};

Return[data];
]


(* ::Input::Initialization:: *)
(* Converts dim -dim to the Dynkin coefficients of the rep, anti-rep with that dimension (and no primes). If the input, for a given factor group, are already the Dynkin coefficients, that is fine too (no processing is done). *)
SimpleRepInputConversion[group_,rep_]:=SimpleRepInputConversion[group,rep]=Module[{dim,reps,result},
If[!IsSimpleGroupQ[group],Return[SimpleRepInputConversion@@@Transpose[{group,rep}]]];
If[group==U1,Return[rep]];
If[Head[rep]===List,Return[rep]];

dim=Abs[rep];
reps=RepsUpToDimNNoConjugates[group,dim];
reps=DeleteCases[reps,x_/;DimR[group,x]!=dim];
reps=Sort[reps,OrderedQ[{Join[{DimR[group,#1],RepresentationIndex[group,#1]},ConjugacyClass[group,#1],-#1],Join[{DimR[group,#2],RepresentationIndex[group,#2]},ConjugacyClass[group,#2],-#2]}]&];

result=If[rep>0,reps[[1]],ConjugateIrrep[group,reps[[1]]]];
Return[result];
]

(* One can give a Lorentz rep by name ("S","L","R","V"), {jL,jR}, or with Dynkin coeffiecients *)
SimpleLorentzInputConversion[rep_]:=SimpleLorentzInputConversion[rep]=Module[{},
If[Head[rep]===String,
Return[rep/.{"R"->{{0},{1}},"L"->{{1},{0}},"S"->{{0},{0}},"V"->{{1},{1}}}];
,
If[Depth[rep]==2,Return[2{{rep[[1]]},{rep[[2]]}}];,Return[rep];];
];
];


(* ::Input::Initialization:: *)
(* Auxiliar function to LorentzInvariants. Try nToMod[{2,3,4}] *)
nToMod[bIs_]:=Module[{ns,ii,res},
ns=Range[1,(Times@@bIs)]-1;
res={};
Do[
ii=Mod[ns,el];
ns=(ns-ii)/el;
PrependTo[res,ii];
,{el,Reverse[bIs]}];
Return[Transpose[res]+1];
]

(* Converts a Sn rep given by a partition of n into a formated name [specifically for use with GenerateListOfCouplings] *)
SnRepNameTemp[\[Lambda]_]:=Which[Length[\[Lambda]]==1,Style["S",{Bold,Orange}],Total[\[Lambda]]==Length[\[Lambda]],Style["A",{Bold,Blue}],True,Style[\[Lambda],{Bold,Purple}]]

SnRepNameTemp2[\[Lambda]_]:=Which[Length[\[Lambda]]==1,Style[\[Lambda],{Bold,Orange}],Total[\[Lambda]]==Length[\[Lambda]],Style[\[Lambda],{Bold,Blue}],True,Style[\[Lambda],{Bold,Purple}]]

(* OLD, used in the past when the non-gauged groups were Zn with multiplicative charges *)
ConjugateRepSpecial[model_,rep_]:={rep[[1]],ConjugateIrrep[gaugeGroup[model],rep[[2]]],Reverse[rep[[3]]],ConjugateIrrepIncludingZns[ungaugedGroup[model],rep[[4]]],rep[[5]],rep[[6]]}


(* ::Input::Initialization:: *)
(* Assumes that group is a list of factors! TODO - make it more robust *)
TrivialRep[group_]:=Module[{trivialRep,pos1,pos2,pos3},
trivialRep=ConstantArray[Null,Length[group]];

pos1=Flatten[Position[group,Z[_],-1]];
pos2=Flatten[Position[group,U1,-1]];
trivialRep[[pos1]]=ConstantArray[0,Length[pos1]];
trivialRep[[pos2]]=ConstantArray[0,Length[pos2]];

pos3=Complement[Range[Length[group]],Join[pos1,pos2]];
trivialRep[[pos3]]=ConstantArray[0,Length[#]]&/@group[[pos3]];

Return[trivialRep];
]

(* DONE: Works well for simple non-simple groups. Note: no group cannot be {} because this represents a U1 *)
IsSimpleGroupIncldingZnsQ[group_]:=Module[{},
(* If there are Z[n] discrete factor groups ... *)
If[Head[group]===Z,Return[True]];
If[MemberQ[group,Z[_]],Return[False]];

(* ... otherwise use IsSimpleGroupQ *)
Return[IsSimpleGroupQ[group]];
]

(* DONE: Works well for simple non-simple groups *)
ConjugateIrrepIncludingZns[groupIn_,repIn_]:=Module[{group,rep,conjRep},
If[IsSimpleGroupIncldingZnsQ[groupIn],
group={groupIn};rep={repIn};
,
group=groupIn;rep=repIn;
];
conjRep=Table[If[Head[group[[i]]]===Z,Mod[-rep[[i]],group[[i,1]]],ConjugateIrrep[group[[i]],rep[[i]]]],{i,Length[group]}];
If[IsSimpleGroupIncldingZnsQ[groupIn],conjRep=conjRep[[1]]];
Return[conjRep];
]

ConjugateRepSpecial[model_,rep_]:={rep[[1]],ConjugateIrrep[gaugeGroup[model],rep[[2]]],Reverse[rep[[3]]],ConjugateIrrepIncludingZns[ungaugedGroup[model],rep[[4]]],rep[[5]],rep[[6]]}


(* ASSUME FOR NOW that ungaugedGroup[model] is a list of simple factors *)
ContainsSingletQ[model_,reps_]:=Module[{testLorentz,testGauge,znTest,testContinuous,znPositions,znCharges,continuousPositions,continuousGroupNonGauged},
znPositions=Flatten[Position[Head/@ungaugedGroup[model],Z]];
znCharges=reps[[All,4,znPositions]];
znTest=(Mod[Total[znCharges],ungaugedGroup[model][[znPositions,1]]]==ConstantArray[0,Length[znPositions]]);

If[!znTest,Return[False,Module]];

continuousPositions=Complement[Range[Length[ungaugedGroup[model]]],znPositions];
continuousGroupNonGauged=ungaugedGroup[model][[continuousPositions]];

testContinuous=True; (* this line is important for the case when continuousGroupNonGauged={} *)
Do[testContinuous=MemberQ[ReduceRepProduct[continuousGroupNonGauged[[i]],Sort[reps[[All,4,continuousPositions[[i]]]]]],x_/;x[[1]]0==x[[1]]];If[!testContinuous,Return[False,Module]];,{i,Length[continuousGroupNonGauged]}];


Do[testLorentz=MemberQ[ReduceRepProduct[SU2,Sort[reps[[All,3,i]]]],x_/;x[[1]]0==x[[1]]];If[!testLorentz,Return[False,Module]];,{i,2}];

testGauge=True; (* this line is important for the case when gaugeGroup={} *)
Do[testGauge=MemberQ[ReduceRepProduct[gaugeGroup[model][[i]],Sort[reps[[All,2,i]]]],x_/;x[[1]]0==x[[1]]];If[!testGauge,Return[False,Module]];,{i,Length[gaugeGroup[model]]}];
Return[znTest&&testContinuous&&testLorentz&&testGauge];
]


(* ::Input::Initialization:: *)
(* Return the Sn rep which equals the product of \[Lambda] times the totally antisymmetric representation of Sn *)

(* The result is obtained by transposing the Yound diagram. See for example theorem TheoremIII.62 of https://www.physik.uni-bielefeld.de/~borghini/Teaching/Symmetries/12_01b.pdf *)
SnRepTimesTotallyAntisymmetric[\[Lambda]_]:=TransposePartition[\[Lambda]]


(* ::Input::Initialization:: *)
(* Returns list of elements corresponding to the model fields, with the format {<new field index>,{<original field index>,<n derivatives>},<name>,<gauge q.n.>,<lorentz q.n.>,<"R" or "C">,<# flavors>,<mass dimension>,<other quantum numbers>,<is Grassmann?>} *)

ModifyModelFieldsToIncludeDerivatives[model_,listOfFieldsAppearing_,derIdx_,massDimensions_,reps\[UnderBracket]otherCharges_]:=Module[{n,counter,result,fullName,fullNameR,gaugeQN,lorentzQN,realQ,nF,nameOfTheFields,reps\[UnderBracket]gaugeIn,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentzIn,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,rootName,rootLorentzQN,FmunuQN,massD,otherQN,grassmann,derivative, aux,derivativeReps,isFmunuQ,realFmunuReps,complexFmunuReps},

n=Length[fields[model]];

{nameOfTheFields,reps\[UnderBracket]gaugeIn,reps\[UnderBracket]lorentzIn,reps\[UnderBracket]RI,reps\[UnderBracket]copies}=Transpose[fields[model][[All,1;;5]]];


(* Just converts the simplified input into Dynkin coefficients *)
reps\[UnderBracket]gauge=SimpleRepInputConversion[gaugeGroup[model],#]&/@reps\[UnderBracket]gaugeIn;

reps\[UnderBracket]lorentz=SimpleLorentzInputConversion/@reps\[UnderBracket]lorentzIn;

FmunuQN=Table[Adjoint[gaugeGroup[model]]UnitVector[Length[gaugeGroup[model]],gI],{gI,Length[gaugeGroup[model]]}];
counter=0;
result=Reap[Do[

(* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)
(* +++++++++++++++++++++++++++ Place the "derivative field" exactly at position n (counter=n) and move on +++++++++++++++++++++++++++ *)
(* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)

If[counter==n,
 (* jump one step to give space for the derivative *)
counter++;
derivative={counter,{derIdx,0},"D",SimpleRepInputConversion[gaugeGroup[model],If[#===U1,0,1]&/@gaugeGroup[model]],SimpleLorentzInputConversion["V"],"R",1,1,TrivialRep[ungaugedGroup[model]],True};
Sow[derivative];
];

(* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)
(* ++++++++++++++++++++++++ Handle the expected properties of the fields (some changes might be made later) +++++++++++++++++++++++++ *)
(* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)

rootName=If[el[[1]]<=n,nameOfTheFields[[el[[1]]]],If[PropertySetQ[model,gaugeBosonNames],gaugeBosonNames[model][[el[[1]]-n-1]],"F"<>ToString[el[[1]]-n-1]]<>If[$Sym2IntUseEOM,"","(*)"]];


gaugeQN=If[el[[1]]<=n,reps\[UnderBracket]gauge[[el[[1]]]],FmunuQN[[el[[1]]-n-1]]];
rootLorentzQN=If[el[[1]]<=n,reps\[UnderBracket]lorentz[[el[[1]]]],{{2},{0}}];
realQ=If[el[[1]]<=n,reps\[UnderBracket]RI[[el[[1]]]],"C"];
nF=If[el[[1]]<=n,reps\[UnderBracket]copies[[el[[1]]]],If[Head[$GaugeBosonMultiplicity]=!=List,$GaugeBosonMultiplicity,$GaugeBosonMultiplicity[[el[[1]]-n-1]]]];
massD=If[el[[1]]<=n,massDimensions[[el[[1]]]],2]+el[[2]];
otherQN=If[el[[1]]<=n,reps\[UnderBracket]otherCharges[[el[[1]]]],TrivialRep[ungaugedGroup[model]]];
grassmann=If[el[[1]]<=n,grassmannNature[model][[el[[1]]]],False];

(* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)
(* +++++++++ At this point, to make the final decisions on the properties of the fields (name, Lorentz quantum numbers, realQ) +++++++++++++ *)
(* +++++ we must consider (1) are there derivatives? (2) is the EOM flag on? (3) is the root field (with the derivatives) an Fmunu? +++++ *)
(* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)

If[el[[2]]===0,

(* ++++++++++++++++ No derivatives ++++++++++++++++ *)
fullName=rootName;
lorentzQN=rootLorentzQN;
,
(* +++++++++++++++ With derivatives +++++++++++++++ *)
fullName=\!\(\*
TagBox[
StyleBox["\"\<D\>\"",
ShowSpecialCharacters->False,
ShowStringCharacters->True,
NumberMarks->True],
FullForm]\)<>ToString[el[[2]]]<>"("<>rootName<>")";

(* If EOM are not used, then there are more Lorentz irreps to consider *)
If[$Sym2IntUseEOM,
(* ++++++++++++++++ Use EOMs ++++++++++++++++ *)
lorentzQN=rootLorentzQN+el[[2]];
,
(* ++++++++++++++ Don't use EOMs +++++++++++++ *)
isFmunuQ=If[el[[1]]<=n,False,True];

If[!isFmunuQ,
(* ++++++++++++++ Not an Fmunu +++++++++++++ *)
(* The symmetric contraction of n derivatives contains the reps {{n},{n}}, {{n-2},{n-2}}, .... Use those. *)
derivativeReps=Table[{{i},{i}},{i,el[[2]],0,-2}];
aux=ReduceRepProduct[{SU2,SU2},{rootLorentzQN,#}]&/@derivativeReps;
lorentzQN={#[[1,1]],Total[#[[All,2]]]}&/@GatherBy[Flatten[aux,1],#[[1]]&];

,
(* +++++++++++++++ Is an Fmunu +++++++++++++ *)
(* Need to consider the Bianchi identities. They remove all repeated Lorentz irreps, so all for irreps in {der}^x Fmunu do survive, but only one of each. For example {der}^1 Fmunu contains {{3},{1}},{{1},{1}} and {{1},{3}}. The problem then is how to make the result look self-conjugate: in this example, the {{3},{1}} is the conjugate of {{1},{3}} but {{1},{1}} must be real, so does it come from  der F or der F*? It must be from der[F+F*], while {{3},{1}} comes from der F and  {{1},{3}} from der F* (no confusion in these cases). So in the case of the real irrep one must better add a new variable name 'F+F*' to be clear *)
complexFmunuReps=Table[{{i+2},{i}},{i,el[[2]],0,-2}];
realFmunuReps=Table[{{i},{i}},{i,el[[2]],1,-2}];


(* fullNameR="D"<>ToString[el[[2]]]<>"("<>rootName<>"+"<>rootName<>"*"<>")"; *)

(* In this specific case (el[[2]]>0 && !$Sym2IntUseEOM && isFmunuQ) add here already the fields *)
Do[
counter++;
Sow[{counter,el,fullName,gaugeQN,lQN,"C",If[Head[$GaugeBosonMultiplicity]=!=List,$GaugeBosonMultiplicity,$GaugeBosonMultiplicity[[el[[1]]-n-1]]],massD,otherQN,grassmann}];
,{lQN,complexFmunuReps}];


(* Check in the rest of the code: even though these fields are marked as real ("R"), does the code still try to conjugate them because of the information in position #2 (el)? *)
Do[
counter++;
Sow[{counter,el,fullName,gaugeQN,lQN,"R",If[Head[$GaugeBosonMultiplicity]=!=List,$GaugeBosonMultiplicity,$GaugeBosonMultiplicity[[el[[1]]-n-1]]],massD,otherQN,grassmann}];
,{lQN,realFmunuReps}];

];
];
];

(* If EOM are not used (or # derivatives = 0), then there are more Lorentz irreps to consider *)
If[$Sym2IntUseEOM||el[[2]]===0,
counter++;
Sow[{counter,el,fullName,gaugeQN,lorentzQN,realQ,nF,massD,otherQN,grassmann}];
,
(* The case el[[2]]>0 && !$Sym2IntUseEOM && isFmunuQ was already taken care of above *)
If[!isFmunuQ,
Do[
counter++;
Sow[{counter,el,fullName,gaugeQN,lQN[[1]],realQ,lQN[[2]]nF,massD,otherQN,grassmann}];

,{lQN,lorentzQN}];
];

];
,{el,listOfFieldsAppearing}]][[2,1]];

Return[result];
]


(* ::Input::Initialization:: *)
AddGaugeBosons[model_,initListOfInteractionsIn_,massDimensions_,maxOrder_,derIndex_]:=Module[{initListOfInteractions,startFPos,FmunuPos,aux,aux2,FmunuListOfAdditions,massDimsOfTerms,result},
initListOfInteractions=Prepend[initListOfInteractionsIn,{}];

startFPos=Length[fields[model]]+2;
FmunuPos=Range[startFPos,startFPos-1+Length[gaugeGroup[model]]];
FmunuPos=Sort[Join[-FmunuPos,FmunuPos]];

aux=Table[DeleteDuplicates[Sort/@Tuples[FmunuPos,i]],{i,0,maxOrder/2}];
FmunuListOfAdditions=Table[Flatten[aux[[1;;i]],1],{i,1,Length[aux]}];


massDimsOfTerms=Total/@(massDimensions[[#]]&/@(1+Abs[initListOfInteractions]));
aux=Floor[(maxOrder-massDimsOfTerms)/2];
aux2=FmunuListOfAdditions[[aux+1]]; (* combinations of Fmunu which can be added to each term *)

result=Flatten[Table[Join[initListOfInteractions[[i]],el],{i,Length[initListOfInteractions]},{el,aux2[[i]]}],1];
result=Drop[result,1];
result=DeleteCases[result,x_/;Length[x]==Count[x,derIndex]];
Return[result];
]


(* ::Input::Initialization:: *)
ApplyDerivativesToFields[initListOfInteractions_,derIndex_]:=Module[{fieldList1,result,nDers,aux,aux2,aux3,groupPartitions},
fieldList1=DeleteCases[initListOfInteractions,x_/;Length[x]==Count[x,derIndex]];
result=Reap[Do[
nDers=Count[initInteraction,derIndex];
aux=Tally[DeleteCases[initInteraction,derIndex]];
Do[
groupPartitions=Flatten[Permutations/@IntegerPartitionsMOD[nDi,Length[aux]],1];
aux2=Flatten[Table[Tuples[IntegerPartitionsMOD[#1,#2]&@@@Transpose[{gp,aux[[All,2]]}]],{gp,groupPartitions}],1];
aux2=Transpose[aux2];
aux3=Flatten[#,1]&/@Transpose[Table[Thread[List[ConstantArray[aux[[i,1]],aux[[i,2]]],#]]&/@aux2[[i]],{i,Length[aux]}]];
(* If[nDi\[NotEqual]nDers,aux3=Prepend[#,{derIndex,nDers-nDi}]&/@aux3]; *)
If[nDi!=nDers,aux3=Join[ConstantArray[{derIndex,0},nDers-nDi],#]&/@aux3];
Sow[aux3];
,{nDi,0,nDers}];
,{initInteraction,fieldList1}]][[2]];
If[Length[result]>0,result=Flatten[result[[1]],1]];
Return[result];
]

(* Used by ApplyDerivativesToFields *)
IntegerPartitionsMOD[n_,parts_]:=PadRight[#,parts]&/@IntegerPartitions[n,parts]


(* ::Input::Initialization:: *)
Options[LorentzInvariants]={DistinguishFields->False};
LorentzInvariants[gaugeG_,gaugeReps_,lorentzReps_,conjs_,OptionsPattern[]]:=Module[{fullGroup,lorentzRepsDI,pConj,fullReps,pConjs,indicesOriginal,indicesConjugated,indicesConjugatedMod,repOriginal,rep,invariants,invariantsAr,rule},
fullGroup=Join[gaugeG,{SU2,SU2}];
lorentzRepsDI=SimpleLorentzInputConversion/@lorentzReps;
pConj=Flatten[Position[conjs,True]];
If[pConj!={},
lorentzRepsDI[[pConj]]=Reverse/@lorentzRepsDI[[pConj]];
];

fullReps=Join@@@Transpose[{gaugeReps,lorentzRepsDI}];

invariants=Invariants[fullGroup,fullReps,Conjugations->conjs,TensorForm->True,DistinguishFields->OptionValue[DistinguishFields]];

(* There is still a problem to be solved at this stage. Conjugation switches the Lorentz L < - > R groups, so we get the result in invariants. But then the component ordereing needs to be fixed. For example (L,R)={{2},{1}} gets treated as having components {11,12,13,21,22,23} in invariants, when in reality we would like the ordering {11,12,21,22,31,32}. This issue is fixed in the following code. *)
pConjs=Flatten[Position[conjs,True]];
If[pConjs!={},
invariantsAr=ArrayRules[invariants[[1]]][[1;;-2]];
];
Do[
rep=fullReps[[pos]];
repOriginal=rep;repOriginal[[-2]]=rep[[-1]];repOriginal[[-1]]=rep[[-2]];

indicesOriginal=nToMod[DimR[fullGroup,repOriginal]];
indicesConjugated=nToMod[DimR[fullGroup,rep]];
indicesConjugatedMod=indicesConjugated;indicesConjugatedMod[[All,-1]]=indicesConjugated[[All,-2]];indicesConjugatedMod[[All,-2]]=indicesConjugated[[All,-1]];

rule=MapThread[Rule,{Range[Length[indicesConjugatedMod]],Flatten[Position[indicesOriginal,#]&/@indicesConjugatedMod]}];
invariantsAr[[All,1,pos+1]]=invariantsAr[[All,1,pos+1]]/.rule;

,{pos,pConjs}];

If[pConjs!={},
invariants[[1]]=SparseArray[invariantsAr,Dimensions[invariants[[1]]]];
];


Return[invariants];
]


(* ::Input::Initialization:: *)
(* Instead of ValueQ[property[model]], which seems to always output True, use PropertySetQ[model,property] (if property[model]={}, Null or simply has no value set, this function will output False) *)

PropertySetQ[model_,property_]:=MemberQ[UpValues[model][[All,1]],HoldPattern[property[x_]],-1]&&(property[model]=!={})&&(property[model]=!=Null)


(* ::Input::Initialization:: *)
(* Input 'term' is the list of field numbers, as it appears in fieldsAUX[model]. Output is {<operator type>, <total derivatives>,<total dummy derivatives>,<interaction was conjugated (False) or not (True)>}. <operator type> is a list of field numbers, as ordered in fields[model], with all derivatives removed, and possibly conjugated *)
OperatorType[model_,term_]:=Block[{termMod,freeDs,appliedDs,formA,formAConj,operatorType,orderedQ,totalDs,startFPos,FmunuPos,ruleEOM},
(* Get rid of pure derivatives *)
termMod=DeleteCases[term,derivativeIndex[model]];

freeDs=Count[term,derivativeIndex[model]];
appliedDs=Total[fieldsAUX[model][[Abs[termMod],2,2]]];
totalDs=freeDs+appliedDs;

formA=Sign[termMod]fieldsAUX[model][[Abs[termMod],2,1]];
formAConj=formA(If[#==="C",-1,1]&/@fieldsAUX[model][[Abs[termMod],6]]);

(* If EOM's are not used, the Bianchi identities are such that the number of operators with F_munu=F + i F* and those with Ftilde_munu=F - i F* is different. Counting operators with F and F* becomes missleading, so it is best to STOP distinguishing F and F* in the final result *)
If[!$Sym2IntUseEOM,
startFPos=Length[fields[model]]+2;
FmunuPos=Range[startFPos,startFPos-1+Length[gaugeGroup[model]]];
ruleEOM=(-#->#)&/@FmunuPos;
{formA,formAConj}={formA,formAConj}/.ruleEOM;
];

formA=Sort[formA];
formAConj=Sort[formAConj];

If[OrderedQ[{{Count[formA,x_/;x<0],formA},{Count[formAConj,x_/;x<0],formAConj}}],
operatorType=Sort[formA];
orderedQ=True;
,
operatorType=Sort[formAConj];
orderedQ=False;
];

Return[{operatorType,totalDs,freeDs,orderedQ}];
]


(* ::Input::Initialization:: *)
OperatorsOfEachType[model_,data_,calculateSnDataQ_]:=Module[{selfConjQ,operatorTypes,operatorTypeGroups,aux,numberOfOperators,groupedUpTerms,numberOfFreeDs,noNeedToConjugateQ,selfConjTypeQ,startFPos,FmunuPos},

selfConjQ=Table[Sort[resultI[[1]]]==Sort[If[fieldsAUX[model][[Abs[#],6]]=="R",#,-#]&/@resultI[[1]]],{resultI,data}];
operatorTypeGroups=GatherBy[Table[{i,OperatorType[model,data[[i,1]]]},{i,Length[data]}],#[[2,1;;2]]&];

operatorTypes=operatorTypeGroups[[All,1,2,1;;2]];

groupedUpTerms=operatorTypeGroups[[All,All,1]];
numberOfFreeDs=operatorTypeGroups[[All,All,2,3]];
noNeedToConjugateQ=operatorTypeGroups[[All,All,2,4]];

selfConjTypeQ=Table[Sort[resultI[[1]]]==Sort[If[fieldsAUX[model][[Abs[#],6]]=="R",#,-#]&/@resultI[[1]]],{resultI,operatorTypes}];

(* If EOMs are not used, assume that all operator classes with Fmunu's are real (even those which due to the other fields cannot be real), so that the counting of operators and terms is for real ones *)
If[!$Sym2IntUseEOM,
startFPos=Length[fields[model]]+2;
FmunuPos=Range[startFPos,startFPos-1+Length[gaugeGroup[model]]];
aux=Flatten[Position[operatorTypes[[All,1]],x_/;Intersection[x,FmunuPos]=!={},{1},Heads->False]];
selfConjTypeQ[[aux]]=ConstantArray[True,Length[aux]];
];

(* selfConjTypeQ=True; *)

If[calculateSnDataQ,
aux=Table[data[[el[[i,1]],2,2,All,2]] . data[[el[[i,1]],2,2,All,3]](-1)^el[[i,2,3]]If[selfConjQ[[el[[i,1]]]],1,2],{el,operatorTypeGroups},{i,Length[el]}];
numberOfOperators=Simplify[Total/@aux];
numberOfOperators=numberOfOperators/(selfConjTypeQ/.{True->1,False->2});
,
numberOfOperators=ConstantArray[Null,Length[operatorTypeGroups]];
];

Return[{operatorTypes,groupedUpTerms,numberOfFreeDs,noNeedToConjugateQ,numberOfOperators,selfConjTypeQ,selfConjQ[[#]]&/@groupedUpTerms}];
]


(* ::Input::Initialization:: *)
DropElementsFromList[list_,elPos_]:=list[[Sort[Complement[Range[Length[list]],elPos]]]]
DropElementsFromLists[lists_,elPos_]:=lists[[All,Sort[Complement[Range[Length[lists[[1]]]],elPos]]]]

(* 1. Delete derivative symmetry information *)
(* Example: derIndex=59; termInfo={{4,4,-4,-4,59,59},{{{1,2},{3,4},{5,6}},{{{{2},{1,1},{2}},(1/4) (-1+nn) nn^2 (1+nn),1},{{{1,1},{2},{2}},(1/4) (-1+nn) nn^2 (1+nn),1}}},Null} *)
RemoveDerivativeInfo[model_,termInfo_]:=Module[{aux,aux2,convertIndicesRule,result},
aux=Sort[Flatten[Position[termInfo[[1]],derivativeIndex[model]]]];
If[aux==={},Return[termInfo]];

result=termInfo;
result[[1]]=DropElementsFromList[result[[1]],aux];

(* If is not activated if CalculateSnSymmetries\[Rule]False *)
If[result[[2]]=!=Null,

aux2=Flatten[Position[termInfo[[2,1]],aux]];
result[[2,1]]=DropElementsFromList[result[[2,1]],aux2];

result[[2,2,All,1]]=DropElementsFromLists[result[[2,2,All,1]],aux2];

(* sym info grouping at result[[2,1]] may still be incorrect if derivatives we dropped from the middle of result[[1]]. For example, if the fields were {A,Der,B,B}, the groups were {{1},{2},{3,4}} and at this point they would be converted to {{1},{3,4}}. But with the field in positin 2 dropped, it show read {{1},{2,3}}. Correct it now. *)
convertIndicesRule=DropElementsFromList[Range[Length[termInfo[[1]]]],aux];
convertIndicesRule=Table[convertIndicesRule[[i]]->i,{i,Length[convertIndicesRule]}];
result[[2,1]]=result[[2,1]]/.convertIndicesRule;
];

Return[result];
]

FieldToFieldType[model_,field_]:=Module[{result,aux,startFPos,FmunuPos,ruleEOM},
result=Sign[field]fieldsAUX[model][[Abs[field],2,1]];

If[!$Sym2IntUseEOM,
startFPos=Length[fields[model]]+2;
FmunuPos=Range[startFPos,startFPos-1+Length[gaugeGroup[model]]];
ruleEOM=(-#->#)&/@FmunuPos;
result=result/.ruleEOM;
];
Return[result];
]


(* ::Input::Initialization:: *)
SConsolas[expr_]:=Style[expr,FontFamily->"Consolas"]

DYT[\[Lambda]_,style_]:=If[style==="NoTableaux",SnRepNameTemp2[\[Lambda]],DrawYoungDiagramRaster[\[Lambda],9]]


(* ::Input::Initialization:: *)
BuildTableToPrint[model_,data_,calculateSnDataQ_,style_]:=Module[{tableToPrint,item,row,fieldsInInteraction,repeatedFieldsInInteraction,input,output,aux,divsH,divsV,fieldNames,table},

fieldNames=Join[{"\[ScriptCapitalD]"},fields[model][[All,1]],{"DER-PLACEHOLDER"},Table[If[PropertySetQ[model,gaugeBosonNames],gaugeBosonNames[model][[i]],"F"<>ToString[i]]<>If[$Sym2IntUseEOM,"","(*)"],{i,1,Length[gaugeGroup[model]]}]];
tableToPrint=Reap[Do[
item=data[[i]];

(* If CalculateSnSymmetries\[Rule]False  (item[[5]] is the number of op and it is not calculated in this case) *)
If[!calculateSnDataQ,
row=item[[1;;4]];

fieldsInInteraction=fieldNames[[1+Abs[#]]]<>If[#>=0,"","*"]&/@item[[2]];
row[[2]]=Row[fieldsInInteraction,"  "];
,

row=ConstantArray[Null,8];

row[[{1,3,4,5,6}]]=item[[{1,3,4,5,6}]];

fieldsInInteraction=fieldNames[[1+Abs[#]]]<>If[#>=0,"","*"]&/@item[[2]];
row[[2]]=Row[fieldsInInteraction,"  "];

repeatedFieldsInInteraction=fieldNames[[1+Abs[#]]]<>If[#>=0,"","*"]&/@item[[7]];
repeatedFieldsInInteraction=If[repeatedFieldsInInteraction==={},Null,repeatedFieldsInInteraction];
If[Length[repeatedFieldsInInteraction]==1,repeatedFieldsInInteraction=repeatedFieldsInInteraction[[1]]];
row[[7]]=repeatedFieldsInInteraction;

(* ++++++++++ symmetry information ++++++++++ *)
input=item[[8,2]];
If[item[[8,1]]==={},
output=Null;,
aux=Transpose[{input[[All,2]],Map[DYT[#,style]&,input[[All,1]],{2}]}];

aux[[2;;-1,1]]=Which[#==1,"+",#==-1,"-",#>0,"+"<>ToString[#],#<0,"-"<>ToString[Abs[#]]]&/@aux[[2;;-1,1]];
aux[[1,1]]=Which[aux[[1,1]]==1,"",aux[[1,1]]==-1,"-",aux[[1,1]]>0,ToString[aux[[1,1]]],aux[[1,1]]<0,ToString[aux[[1,1]]]];

(* If there is only one group of repeated fields, remove one set of parentesis *)
If[Length[item[[8,1]]]==1,aux[[All,2]]=aux[[All,2,1]]];

output=Row[DeleteCases[Flatten[aux,1],"",{1}]," "];
];
row[[8]]=output;
];
Sow[row];
,{i,0+ Length[data]}]][[2,1]];

divsH=Join[{1->{Black,Thick},2->Black,-1->{Black,Thick}},Table[i->Lighter[Gray,0.8],{i,3,Length[data]+1}]];

If[calculateSnDataQ,
divsV={1->{Black,Thick},2->Lighter[Gray,0.8],3->Lighter[Gray,0.8],4->Lighter[Gray,0.8],5->Lighter[Gray,0.8],6->Lighter[Gray,0.8],7->Lighter[Gray,0.8],8->Lighter[Gray,0.8],9->{Black,Thick}};

table=Grid[Prepend[tableToPrint,Style[#,{Bold,Darker[Red],FontFamily->"Consolas"}]&/@{"#",Column[{"Operator","type"},Center],"Dim.",Column[{"Self","conj.?"},Center],Column[{"Number of","operators"},Center],Column[{"Number of","terms"},Center],Column[{"Repeated","fields"},Center],Column[{"Permutation","symmetry"},Center]}],Dividers->{divsV,divsH},Spacings->{1,1},Background->{None,{None,{Lighter[Gray,0.95],None}}}];

,
divsV={1->{Black,Thick},2->Lighter[Gray,0.8],3->Lighter[Gray,0.8],4->Lighter[Gray,0.8],5->{Black,Thick}};

table=Grid[Prepend[tableToPrint,Style[#,{Bold,Darker[Red],FontFamily->"Consolas"}]&/@{"#",Column[{"Operator","type"},Center],"Dim.",Column[{"Self","conj.?"},Center]}],Dividers->{divsV,divsH},Spacings->{1,1},Background->{None,{None,{Lighter[Gray,0.95],None}}}]

];

Return[table];
]


(* ::Input::Initialization:: *)
ModelStatistics[data_,maxOrder_]:=Module[{opDimensions,nRealOperators,nRealTermsMin,nRealTermsMax,nRealTypes,aux,nOps,nTs,nTTs,statistics,divsH,divsV,tableWithStatistics,frameColor},

nRealOperators={};
nRealTermsMin={};
nRealTermsMax={};
nRealTypes={};
opDimensions={};
Do[
aux=Cases[data,x_/;x[[3]]==dimOp];
nOps=Simplify[aux[[All,5]] . (aux[[All,4]]/.{True->1,False->2})];
nTs=Total[aux[[All,6]](aux[[All,4]]/.{True->1,False->2})];
nTTs=Total[aux[[All,4]]/.{True->1,False->2}];
If[NumericQ[nTs],nTs={nTs,nTs}];

AppendTo[opDimensions,dimOp];
AppendTo[nRealOperators,nOps];
AppendTo[nRealTermsMin,nTs[[1]]];
AppendTo[nRealTermsMax,nTs[[-1]]];
AppendTo[nRealTypes,nTTs];
,{dimOp,Min[data[[All,3]]],maxOrder}];

statistics=Transpose[{opDimensions,nRealOperators,nRealTermsMin,nRealTermsMax,nRealTypes}];

aux=Table[{el[[1]],el[[2]],If[el[[3]]==el[[4]],el[[3]],Row[{el[[3]]," to ",el[[4]]}]],el[[5]]},{el,statistics}];
PrependTo[aux,Style[#,{Bold,Darker[Green],FontFamily->"Consolas"}]&/@{"Dimension","# real operators","# real terms", "# types of real operators"}];

frameColor=Black;
divsH=Join[{1->{frameColor,Thick},2->frameColor,-1->{frameColor,Thick}},Table[i->Lighter[Gray,0.8],{i,3,Length[statistics]+1}]];
divsV={1->{frameColor,Thick},2->Lighter[Gray,0.8],3->Lighter[Gray,0.8],4->Lighter[Gray,0.8],5->{frameColor,Thick}};

tableWithStatistics=Grid[aux,Dividers->{divsV,divsH},Spacings->{1,1},Background->{None,{None,{Lighter[Gray,0.95],None}}}];

Return[{statistics,tableWithStatistics}];
]


(* ::Input::Initialization:: *)
(* Prints data obtained with GenerateListOfCouplings in a table. The advantage is that one can select only part of the full data *)
PrintOperatorTable[model_,data_]:=If[data=!={},BuildTableToPrint[model,data,True,True]]


(* ::Input::Initialization:: *)
(* Prints data obtained with GenerateListOfCouplings in a table. The advantage is that one can select only part of the full data *)
PickParticularOperators[model_,output_,form_]:=Module[{fields,type1,type2,type3,aux,fieldStrings,ruleAux,fieldAbsNumbers,signs,realFieldsRule,search,slct},

fields=StringSplit[form];

type1=StringContainsQ[#,"(*)"]&/@fields;
type2=StringContainsQ[#,"*"]&/@fields;
type2=MapThread[And,{Not/@type1,type2}];
type3=MapThread[And,{Not/@type1,Not/@type2}];

fieldStrings=Table[If[type3[[elI]],fields[[elI]],StringReplace[fields[[elI]],{"(*)"->"","*"->""}]],{elI,Length[fields]}];
aux=Range[derivativeIndex[model]+Length[gaugeGroup[model]]];
ruleAux=Join[fieldsAUX[model][[#,3]]->#&/@Range[derivativeIndex[model]+Length[gaugeGroup[model]]],Table["F"<>ToString[i]->derivativeIndex[model]+i,{i,Length[gaugeGroup[model]]}]];

fieldAbsNumbers=fieldStrings/.ruleAux/.derivativeIndex[model]->0;
signs=Table[If[type1[[elI]],{-1,1},If[type2[[elI]],{-1},{1}]],{elI,Length[fields]}];

(*
realFieldsRule=Join[Table[If[fieldsAUX[model][[i,6]]\[Equal]"R",-i\[Rule]i,Nothing],{i,derivativeIndex[model]}],If[!$Sym2IntUseEOM,Table[-i\[Rule]i,{i,derivativeIndex[model]+1,derivativeIndex[model]+Length[gaugeGroup[model]]}],{}]];
*)
realFieldsRule=Join[Table[If[fieldsAUX[model][[i,6]]=="R",-i->i,Nothing],{i,derivativeIndex[model]}],If[Length[gaugeGroup[model]]>0&&StringContainsQ[fieldsAUX[model][[derivativeIndex[model]+1,3]],"(*)"],Table[-i->i,{i,derivativeIndex[model]+1,derivativeIndex[model]+Length[gaugeGroup[model]]}],{}]];

search=DeleteDuplicates[Sort[fieldAbsNumbers #/.realFieldsRule]&/@Tuples[signs]];
search=DeleteDuplicates[Join[search,Sort/@(-search/.realFieldsRule)]];

slct=Cases[output,x_/;MemberQ[search,Sort[x[[2]]]]];

Print[PrintOperatorTable[model,slct]];
]


(* ::Input::Initialization:: *)
(* contracts the i-th index of tensor with matrix  *)
ContractAt[tensor_,matrix_,i_]:=Module[{indices,result,n},
n=Length[Dimensions[tensor]];
indices=Range[n];
indices[[{i,n}]]={n,i};
result=Transpose[Transpose[tensor,indices] . matrix,indices];
Return[result];
]


(* ::Input::Initialization:: *)
(* The output eqs are equations which should equal 0. The position of each equation follows the results of GenerateListOfCouplings *)
CheckConservationOfAGlobalU1[result_,nameOfTheFields_]:=Module[{eqs,symMats,aux,tensors},
eqs={};
Do[
tensors=result[[elI,7,1]];

If[Length[tensors]>0,
symMats=Table[Sign[result[[elI,2,i]]]DiagonalMatrix[Array[nameOfTheFields[[Abs[result[[elI,2,i]]]]],Dimensions[tensors][[i+1]]]],{i,Length[result[[elI,2]]]}];
aux=Table[Sum[ContractAt[tensor,symMats[[j]],j],{j,Length[result[[elI,2]]]}],{tensor,tensors}];
,aux={}];
AppendTo[eqs,aux];
,{elI,Length[result]}];

Return[eqs];
]
