(* ::Package:: *)

(* ::Input::Initialization:: *)
failedToLoadGroupMath[]:=(
Print[Style["Problem: failed to load the GroupMath package.",{Bold,Darker[Red],FontFamily->"Consolas"}],Style[" Please ensure that ",{GrayLevel[0.5],FontFamily->"Consolas"}],Style[Hyperlink["GroupMath","http://renatofonseca.net/groupmath.php",Appearance->"Palette"],{GrayLevel[0.5],FontFamily->"Consolas"}],Style[" is installed in any of the following paths:\n",{GrayLevel[0.5],FontFamily->"Consolas"}],Grid[{Style[#,{FontFamily->"Consolas",GrayLevel[0.5]}]}&/@$Path,Alignment->{Left,Baseline}]];
Print[Style["Alternatively, you may try first to load GroupMath manually, and then load Sym2Int.",{GrayLevel[0.5],FontFamily->"Consolas"}]];
);
GroupMathAlreadyLoadedQ=Or@@(!StringFreeQ[#,"GroupMath`"]&/@Contexts[]);
If[!GroupMathAlreadyLoadedQ,
Quiet[Check[Get["GroupMath`"],failedToLoadGroupMath[]]];
];


(* ::Input::Initialization:: *)
logoSym2Int=Image[Uncompress["1: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"],ColorSpace->"RGB"];
(* logoSym2Int=Image[logoSym2Int,ImageSize\[Rule]135]; *)


(* ::Input::Initialization:: *)
SMexample="(* ***** Standard Model ***** *)\ngaugeGroup[SM]^={SU3,SU2,U1};\n\nfld1={\"u\",{3,1,2/3},\"R\",\"C\",3};\nfld2={\"d\",{3,1,-1/3},\"R\",\"C\",3};\nfld3={\"Q\",{3,2,1/6},\"L\",\"C\",3};\nfld4={\"e\",{1,1,-1},\"R\",\"C\",3};\nfld5={\"L\",{1,2,-1/2},\"L\",\"C\",3};\nfld6={\"H\",{1,2,1/2},\"S\",\"C\",1};\nfields[SM]^={fld1,fld2,fld3,fld4,fld5,fld6};\n\nGenerateListOfCouplings[SM,MaxOrder\[Rule]4];";

THDMexample="(* ***** Two Higgs doublet model ***** *)\ngaugeGroup[THDM]^={SU3,SU2,U1};\n\nfld1={\"u\",{3,1,2/3},\"R\",\"C\",3};\nfld2={\"d\",{3,1,-1/3},\"R\",\"C\",3};\nfld3={\"Q\",{3,2,1/6},\"L\",\"C\",3};\nfld4={\"e\",{1,1,-1},\"R\",\"C\",3};\nfld5={\"L\",{1,2,-1/2},\"L\",\"C\",3};\nfld6={\"H1\",{1,2,1/2},\"S\",\"C\",1};\nfld7={\"H2\",{1,2,1/2},\"S\",\"C\",1};\nfields[THDM]^={fld1,fld2,fld3,fld4,fld5,fld6,fld7};\n\nGenerateListOfCouplings[THDM];";

SMSeesawIIexample="(* ***** Standard Model plus one complex scalar triplet ***** *)\ngaugeGroup[SMSeesawII]^={SU3,SU2,U1};\n\nfld1={\"u\",{3,1,2/3},\"R\",\"C\",3};\nfld2={\"d\",{3,1,-1/3},\"R\",\"C\",3};\nfld3={\"Q\",{3,2,1/6},\"L\",\"C\",3};\nfld4={\"e\",{1,1,-1},\"R\",\"C\",3};\nfld5={\"L\",{1,2,-1/2},\"L\",\"C\",3};\nfld6={\"H\",{1,2,1/2},\"S\",\"C\",1};\nfld7={\"\[CapitalDelta]\",{1,3,1},\"S\",\"C\",1};\nfields[SMSeesawII]^={fld1,fld2,fld3,fld4,fld5,fld6,fld7};\n\nGenerateListOfCouplings[SMSeesawII,MaxOrder\[Rule]4];";

SVSexample="gaugeGroup[SVS331Model] ^= {SU3, SU3, U1};\n\n\[Psi]l = {\"\[Psi]l\", {1, 3, -1/3}, \"L\", \"C\", 3};\nec = {\"ec\", {1, 1, 1}, \"L\", \"C\", 3};\nQ12 = {\"Q12\", {3, -3, 0}, \"L\", \"C\", 2};\nQ3 = {\"Q3\", {3, 3, 1/3}, \"L\", \"C\", 1};\nuc = {\"uc\", {-3, 1, -2/3}, \"L\", \"C\", 4};\ndc = {\"dc\", {-3, 1, 1/3}, \"L\", \"C\", 5};\n\n\[Phi]1 = {\"\[Phi]1\", {1, 3, 2/3}, \"S\", \"C\", 1};\n\[Phi]23 = {\"\[Phi]23\", {1, 3, -1/3}, \"S\", \"C\", 2}; (* Note that \[Phi]2 and \[Phi]3 are seems as two flavors of \[Phi]23 *)\n\nfields[SVS331Model] ^= {\[Psi]l, ec, Q12, Q3, uc, dc, \[Phi]1, \[Phi]23};\nGenerateListOfCouplings[SVS331Model];";

PPFexample="gaugeGroup[PPF331Model]^={SU3,SU3,U1};\n\n\[Psi]l={\"\[Psi]l\",{1,3,0},\"L\",\"C\",3};\nQ23L={\"Q23L\",{3,-3,-1/3},\"L\",\"C\",2};\nQ1L={\"Q1L\",{3,3,2/3},\"L\",\"C\",1};\nuc={\"uc\",{-3,1,-2/3},\"L\",\"C\",3};\ndc={\"dc\",{-3,1,1/3},\"L\",\"C\",3};\nJ12={\"J12\",{-3,1,4/3},\"L\",\"C\",1};\nJ3={\"J3\",{-3,1,-5/3},\"L\",\"C\",2};\n\n\[Chi]={\"\[Chi]\",{1,3,-1},\"S\",\"C\",1};\n\[Eta]={\"\[Eta]\",{1,3,0},\"S\",\"C\",1};\n\[Rho]={\"\[Rho]\",{1,3,1},\"S\",\"C\",1};\n\nfields[PPF331Model]^={\[Psi]l,Q23L,Q1L,uc,dc,J12,J3,\[Chi],\[Eta],\[Rho]};\n\nGenerateListOfCouplings[PPF331Model];";

SU5example="gaugeGroup[modelSU5]^={SU5};\n\nfld1={\"F\",{-5},\"L\",\"C\",3};\nfld2={\"T\",{10},\"L\",\"C\",3};\nfld3={\"5\",{5},\"S\",\"C\",1};\nfld4={\"24\",{24},\"S\",\"R\",1};\nfields[modelSU5]^={fld1,fld2,fld3,fld4};\n\nGenerateListOfCouplings[modelSU5];";

SMEFTExamplePart1="(* ***** Standard Model Effective Field Theory (SMEFT) up to dimension 10 ***** *)\ngaugeGroup[SM]^={SU3,SU2,U1};\n\nfld1={\"u\",{3,1,2/3},\"R\",\"C\",3};\nfld2={\"d\",{3,1,-1/3},\"R\",\"C\",3};\nfld3={\"Q\",{3,2,1/6},\"L\",\"C\",3};\nfld4={\"e\",{1,1,-1},\"R\",\"C\",3};\nfld5={\"L\",{1,2,-1/2},\"L\",\"C\",3};\nfld6={\"H\",{1,2,1/2},\"S\",\"C\",1};\nfields[SM]^={fld1,fld2,fld3,fld4,fld5,fld6};\n\nsavedResults=GenerateListOfCouplings[SM,MaxOrder\[Rule]10,Verbose\[Rule]\"OnlyStatistics\"];";

SMEFTExamplePart2="(* Convert result into the notation of the datafiles of JHEP 1708 (2017) 016, arXiv:1512.03433 [hep-ph] *)\nConvertSym2IntResult[termAll_]:=Module[{rule,aux,result},\nrule={-10\[Rule]Br,-9\[Rule]Wr,-8\[Rule]Gr,-6\[Rule]Hd,-5\[Rule]Ld,-4\[Rule]e,-3\[Rule]Qd,-2\[Rule]d,-1\[Rule]u,0\[Rule]t,1\[Rule]ud,2\[Rule]dd,3\[Rule]Q,4\[Rule]ed,5\[Rule]L,6\[Rule]H,8\[Rule]Gl,9\[Rule]Wl,10\[Rule]Bl};\n\naux=If[termAll[[4]],{termAll[[2]]},{termAll[[2]],-termAll[[2]]}];\nresult=Expand[termAll[[5]]Total[Times@@@(aux/.rule)]];\n\nReturn[result];\n]\n\nTotal[ConvertSym2IntResult/@savedResults]";

SMEFTExamplePart3="(* Select operators which violate baryon number by +-2 units *)\nBaryonNumber[term_]:=Module[{baryonNumber},\nbaryonNumber=Sign[term[[2]]].(Abs[term[[2]]]/.{0\[Rule]0,1\[Rule]1/3,2\[Rule]1/3,3\[Rule]1/3,4\[Rule]0,5\[Rule]0,6\[Rule]0,8\[Rule]0,9\[Rule]0,10\[Rule]0});\nReturn[baryonNumber];\n]\n\naux=Cases[savedResults,x_/;Abs[BaryonNumber[x]]\[Equal]2\[RuleDelayed]x[[1]]];\nPrintOperatorTable[SM,savedResults[[aux]]]";

textPickOperator1="(* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)(* ++++++++++++++++ Consider a model with a complex bi-doublet of SU(2)xSU(2)  +++++++++++++++++++++ *)\[IndentingNewLine](* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)\[IndentingNewLine]\[IndentingNewLine](* Apply EOMs redundancies? [default=True] *)\[IndentingNewLine]$Sym2IntUseEOM=True;\[IndentingNewLine](* Apply IBP redundancies? [default=True] *)\[IndentingNewLine]$Sym2IntUseIBP=True;\[IndentingNewLine]
gaugeGroup[scalarModel]^={SU2,SU2};\[IndentingNewLine]
bidoublet={\"\[CapitalPhi]\",{2,2},\"S\",\"C\",3};
fields[scalarModel]^={bidoublet};

outputData=GenerateListOfCouplings[scalarModel,MaxOrder\[Rule]8,Verbose\[Rule]False];\[IndentingNewLine]\[IndentingNewLine](* The results (cointaing many operators) were saved in 'outputData'. *)\[IndentingNewLine](* The function PickParticularOperators requires the model name (scalarModel), this output (outputData) and a string such as 'D D \[CapitalPhi] \[CapitalPhi] \[CapitalPhi] \[CapitalPhi]' identifying the desired operator(s): PickParticularOperators[<model>,<saved results>,<string>] *)\[IndentingNewLine](* For the string: 'D' stands for a covariant derivative; '*' after a field name denotes conjugation (inside parentesis it also mathcs the unconjugated field) *)";

textPickOperator2="(* Find operators with 2 derivatives and 4 \[CapitalPhi]'s where at exactly two of them are conjugated *)\[IndentingNewLine]PickParticularOperators[scalarModel,outputData,\"D D \[CapitalPhi] \[CapitalPhi]* \[CapitalPhi] \[CapitalPhi]*\"]\[IndentingNewLine]\[IndentingNewLine](* Find operators with 2 derivatives and 4 \[CapitalPhi]'s where at most two of them are conjugated *)\[IndentingNewLine]PickParticularOperators[scalarModel,outputData,\"D D \[CapitalPhi](*) \[CapitalPhi](*) \[CapitalPhi] \[CapitalPhi]\"]\[IndentingNewLine]\[IndentingNewLine](* F1=Field strength tensor of the first SU(2); F2=Field strength tensor of the second SU(2) *)\[IndentingNewLine](* Find operators with 2 \[CapitalPhi]'s and 3 F1's (maybe conjugated). Because F1 F1 F1 \[CapitalPhi]* \[CapitalPhi]* is complex, it is considered the same as F1* F1* F1* \[CapitalPhi] \[CapitalPhi] and therefore it will be matched.  *)\[IndentingNewLine]PickParticularOperators[scalarModel,outputData,\"F1(*) F1(*) F1(*) \[CapitalPhi] \[CapitalPhi]\"]";

textFlags="(* Don't apply EOMs redundancies *)\[IndentingNewLine]$Sym2IntUseEOM=False; (* [default=True] *)\[IndentingNewLine]\[IndentingNewLine](* Also don't apply IBP redundancies *)\[IndentingNewLine]$Sym2IntUseIBP=False;  (* [default=True] *)\[IndentingNewLine]\[IndentingNewLine](* ***** Let us take SMEFT up to dimension 6 as an example ***** *)
gaugeGroup[SM]^={SU3,SU2,U1};

fld1={\"u\",{3,1,2/3},\"R\",\"C\",3};
fld2={\"d\",{3,1,-1/3},\"R\",\"C\",3};
fld3={\"Q\",{3,2,1/6},\"L\",\"C\",3};
fld4={\"e\",{1,1,-1},\"R\",\"C\",3};
fld5={\"L\",{1,2,-1/2},\"L\",\"C\",3};
fld6={\"H\",{1,2,1/2},\"S\",\"C\",1};
fields[SM]^={fld1,fld2,fld3,fld4,fld5,fld6};

GenerateListOfCouplings[SM,MaxOrder\[Rule]6];";


Block[{result},result={};
AppendTo[result,Row[{Style["XXXXXXXXXXXXXXXXXXXXXXXXXXXX ",{GrayLevel[0.5]}],Hyperlink[Mouseover[Style["Sym2Int",{GrayLevel[0.5]}],Style["Sym2Int",{Darker[Blue,0.5],Bold}]],"http://renatofonseca.net/sym2int.php"],Style[" XXXXXXXXXXXXXXXXXXXXXXXXXXX",{GrayLevel[0.5]}]}]];
AppendTo[result,Row[{Style["Version: 2.3 (06/October/2023)\nAuthor: Renato Fonseca",{GrayLevel[0.5]}]}]];
(* AppendTo[result,Row[{Style["The Sym2Int program lists all possible interactions between a given set of fields. ",{GrayLevel[0.5]}]}]]; *)
AppendTo[result,Row[{Style["References: 1703.05221 [hep-ph], 1907.12584 [hep-ph]",{GrayLevel[0.5]}]}]];
AppendTo[result,Row[{Style["The Sym2Int program lists all possible interactions between a \ngiven set of fields. ",{GrayLevel[0.5]}],Hyperlink[Mouseover[Style["This",{GrayLevel[0.5],Bold,Underlined}],Style["This",{Darker[Blue,0.5],Bold,Underlined}]],"http://renatofonseca.net/sym2int.php"],Style[" webpage explains how to use it.",{GrayLevel[0.5]}]}]];
AppendTo[result,Style["XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",{GrayLevel[0.5]}]];
(* Print[Row[result,"\n",BaseStyle->(FontFamily->"Consolas")]]; *)
Print[Grid[{{Image[ImagePad[logoSym2Int,8,Transparent],ImageSize->131+8],Row[result,"\n",BaseStyle->(FontFamily->"Consolas")]}},Alignment->{Left,Center}]];

];

Print[Style["Get started quickly by considering some examples (click on one of the models below):",{GrayLevel[0.5],FontFamily->"Consolas"}]];


CDoc[x_]:=CreateDocument[x,WindowSize->{1000,600}]

buttonSM=Button[Style["Standard Model",{Darker[Red],Bold,FontFamily->"Consolas"}],CDoc[Cell[BoxData[SMexample],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"];
buttonTHDM=Button[Style["Two Higgs Doublet Model",{Darker[Red],Bold,FontFamily->"Consolas"}],CDoc[Cell[BoxData[THDMexample],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"];
buttonSMSeesawII=Button[Style["SM+scalar triplet",{Darker[Red],Bold,FontFamily->"Consolas"}],CDoc[Cell[BoxData[SMSeesawIIexample],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"];
buttonPPF=Button[Style[Column[{"Pisano-Pleitez-","-Frampton 331 Model"},Center],{Darker[Red],Bold,FontFamily->"Consolas"}],CDoc[Cell[BoxData[PPFexample],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"];
buttonSVS=Button[Style[Column[{"Singer-Valle-","-Schechter 331 Model"},Center],{Darker[Red],Bold,FontFamily->"Consolas"}],CDoc[Cell[BoxData[SVSexample],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"];
buttonSU5=Button[Style["SU(5) Model",{Darker[Red],Bold,FontFamily->"Consolas"}],CDoc[Cell[BoxData[SU5example],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"];
buttonSMEFT=Button[Style["SMEFT",{Darker[Red],Bold,FontFamily->"Consolas"}],CDoc[{Cell[BoxData[SMEFTExamplePart1],"Input",Background->Lighter[Orange,0.9],GeneratedCell->False,CellLabel->"PART1"],Cell[BoxData[SMEFTExamplePart2],"Input",Background->Lighter[Orange,0.9],GeneratedCell->False,CellLabel->"PART2"],Cell[BoxData[SMEFTExamplePart3],"Input",Background->Lighter[Orange,0.9],GeneratedCell->False,CellLabel->"PART3"]}],Appearance->"DialogBox"];
Print[Grid[{{buttonSM,buttonSMEFT,buttonTHDM,buttonSMSeesawII},{buttonPPF,buttonSVS,buttonSU5}}]];




Print[Style["The flags $Sym2IntUseEOM and $Sym2IntUseIBP control the usage of EOM and IBP \nredundancies (click below for an example). \nThe default value is True for both (all redundancies are taken into account). ",{GrayLevel[0.5],FontFamily->"Consolas"}]];
(*
Print[Button[Style["Turning on and off usage of IBP and EOM relations",Rule[LineColor,Darker[Blue]],Rule[FrontFaceColor,Darker[Blue]],Rule[BackFaceColor,Darker[Blue]],Rule[GraphicsColor,Darker[Blue]],Rule[FontFamily,"Consolas"],Rule[FontWeight,Bold],Rule[FontColor,Darker[Blue]]],CellPrint[Cell[BoxData[textFlags],"Input",Rule[Background,Lighter[Lighter[Blue],0.9`]]]],Rule[Appearance,"DialogBox"],Rule[Evaluator,Automatic],Rule[Method,"Preemptive"]]];
*)
Print[Button[Style["Turning on and off usage of IBP and EOM relations",Rule[LineColor,Darker[Blue]],Rule[FrontFaceColor,Darker[Blue]],Rule[GraphicsColor,Darker[Blue]],Rule[FontFamily,"Consolas"],Rule[FontWeight,Bold],Rule[FontColor,Darker[Blue]]],CreateDocument[Cell[BoxData[textFlags],"Input",Rule[Background,Lighter[Lighter[Blue],0.9`]]],WindowSize->{1000,600}],Rule[Appearance,"DialogBox"],Rule[Evaluator,Automatic],Rule[Method,"Preemptive"]]]

Print[Style["The function PickParticularOperators can be used to pick specific operators out from\nthe full list (click below for an example).",{GrayLevel[0.5],FontFamily->"Consolas"}]];
(*
Print[Button[Style["Easily picking particular operators out of the full result",Rule[LineColor,Darker[Blue]],Rule[FrontFaceColor,Darker[Blue]],Rule[BackFaceColor,Darker[Blue]],Rule[GraphicsColor,Darker[Blue]],Rule[FontFamily,"Consolas"],Rule[FontWeight,Bold],Rule[FontColor,Darker[Blue]]],CompoundExpression[CellPrint[Cell[BoxData[textPickOperator2],"Input",Rule[Background,Lighter[Lighter[Blue],0.9`]],Rule[GeneratedCell,False],Rule[CellLabel,"PART2"]]],CellPrint[Cell[BoxData[textPickOperator1],"Input",Rule[Background,Lighter[Lighter[Blue],0.9`]]]]],Rule[Appearance,"DialogBox"],Rule[Evaluator,Automatic],Rule[Method,"Preemptive"]]];
*)
Print[Button[Style["Easily picking particular operators out of the full result",Rule[LineColor,Darker[Blue]],Rule[FrontFaceColor,Darker[Blue]],Rule[GraphicsColor,Darker[Blue]],Rule[FontFamily,"Consolas"],Rule[FontWeight,Bold],Rule[FontColor,Darker[Blue]]],CreateDocument[{Cell[BoxData[textPickOperator1],"Input",Rule[GeneratedCell,True],Rule[Background,Lighter[Lighter[Blue],0.9`]],CellAutoOverwrite->False],Cell[BoxData[textPickOperator2],"Input",Rule[GeneratedCell,False],Rule[Background,Lighter[Lighter[Blue],0.9`]],CellAutoOverwrite->True]},WindowSize->{1000,600}],Rule[Appearance,"DialogBox"],Rule[Evaluator,Automatic],Rule[Method,"Preemptive"]]];


(* ::Input::Initialization:: *)
$Sym2IntUseEOM=True;

$Sym2IntUseIBP=True;

(* Can be used to change the number of F\[Mu]\[Nu]'s of each type considered. SM example: $GaugeBosonMultiplicity={nG,nW,nB}. *)
$GaugeBosonMultiplicity=1;


(* ::Input::Initialization:: *)
(* This funtion generates all terms up to some order allowed by gauge symmetry *)
Options[GenerateListOfCouplings]={Verbose->True,HCTerms->False,CalculateSnSymmetries->True,CalculateInvariants->False,DiscreteSym->{},SymExcludedOps->False,MaxOrder->4,MassDimensions->{},GrassmannCorrection->None,IncludeDerivatives->True,UseEOM->True};
GenerateListOfCouplings[model_,OptionsPattern[]]:=Module[{reps\[UnderBracket]discreteCharges,reps\[UnderBracket]lorentz,order,listOfInteractions,result,operatorTypes,outputData,toPrint,aux,vSpace},

(* .................................................................................... *)
(* ............................... Initialize variables ............................... *)
(* .................................................................................... *)

(* clear this variable *)
fieldsAUX[model]^={};

(* The extra symmetry charges (non-gauge); reps\[UnderBracket]discreteCharges is DEPRECATED  *)
If[Head[ungaugedGroup[model]]=!=ungaugedGroup&&ungaugedGroup[model]=!={},

ungaugedCharges[model]^=fields[model][[All,6]];
,
ungaugedGroup[model]^={};
ungaugedCharges[model]^=ConstantArray[{},Length[fields[model]]];
];

(* The mass dimensions *)
If[OptionValue[MassDimensions]==={},
reps\[UnderBracket]lorentz=SimpleLorentzInputConversion/@fields[model][[All,3]];
massDs[model]^=If[Mod[Total[reps\[UnderBracket]lorentz[[#]],2],2]==0,1,3/2]&/@Range[Length[fields[model]]];
,
massDs[model]^=OptionValue[MassDimensions];
];

(* Grassmann nature of the fields; True=anti-commutes; False=commutes *)
If[OptionValue[GrassmannCorrection]===None,
grassmannNature[model]^=Mod[Total[#,2],2]==1&/@reps\[UnderBracket]lorentz;
,
grassmannNature[model]^=OptionValue[GrassmannCorrection];
];

(* This is the index reserved to a pure derivative, which later on is added to the list of input fields *)
derivativeIndex[model]^=Length[fields[model]]+1;

order=OptionValue[MaxOrder];

(* .................................................................................... *)
(* ............. Find list of interactions - done by FindAllInteractions .............. *)
(* .................................................................................... *)

(* This step may change: fields[model], fieldsAUX[model] *)
listOfInteractions=FindAllInteractions[model,MaxOrder->order,HCTerms->OptionValue[HCTerms],IncludeDerivatives->OptionValue[IncludeDerivatives],UseEOM->OptionValue[UseEOM]];
 
If[!$Sym2IntUseIBP,
listOfInteractions=DeleteCases[listOfInteractions,x_/;MemberQ[x,derivativeIndex[model]]];
];

(* .................................................................................... *)
(* .............. Analize each interaction - done by AnalizeInteraction ............... *)
(* .................................................................................... *)

(* We would like to add more information to resultRaw. In particular, each entry of result, result[[i]], will be of the form  {resultRaw[[i]],<Sn information>, <invariants>}. The last two entries are only calculated if the user so wishes; otherwise their value is {} *)

(* For now only calculate explicit invariants if CalculateInvariants=True and IncludeDerivatives=False; UseFieldsAUX is doing nothing right now *)

result=AnalizeInteraction[model,#,CalculateSnSymmetries->OptionValue[CalculateSnSymmetries],CalculateInvariants->(OptionValue[CalculateInvariants]&&!OptionValue[IncludeDerivatives]),UseFieldsAUX->True]&/@listOfInteractions;

If[!OptionValue[SymExcludedOps]&&(OptionValue[CalculateSnSymmetries]||OptionValue[CalculateInvariants]),
result=DeleteCases[result,x_/;!x[[4]]];
];
result=result[[All,1;;3]];

(* .................................................................................... *)
(* ..................... Condense the various operator types which .................... *)
(* .............. only differ by the field where derivatives are applied .............. *)
(* .................................................................................... *)


operatorTypes=OperatorsOfEachType[model,result,OptionValue[CalculateSnSymmetries]]//Transpose;

(* Delete those cases where the total number of operators is 0 *)
operatorTypes=DeleteCases[operatorTypes,x_/;x[[5]]===0];

outputData=Table[Prepend[ReorganizeOperatorData[model,operatorTypes[[i]],result[[operatorTypes[[i,2]]]]],i],{i,Length[operatorTypes]}];


(* SAVE4=ConvertToIrrepOfBiggestPermutationGroup[model,outputData]; *)
(* SAVE5=outputData[[All,8,2]]; *)
(*  outputData[[All,8,2]]=SAVE4; *)
(* outputData[[All,8,2]]=aux; *)


(* Print["P6 ",TimeUsed[]-tmp]; *)

(* .................................................................................... *)
(* ...... Last part: make arrangements to produce a final list with all the data ...... *)
(* .................................................................................... *)

Sym2Int\[UnderBracket]Table=Null;
vSpace="";

If[OptionValue[Verbose]=!=False,
If[!$Sym2IntUseEOM,
Print[Style["NOTE:",{Bold,Underlined,FontFamily->"Consolas",Black}],Style["The flag $Sym2IntUseEOM is set to False, which mean that equations of motion are not being used to remove redundant operators. As a consequence Sym2Int will not distinguish the fields F1, F2, ... (the left-handed part of the field strenght tensors, transforming as (1,0) under the Lorentz group) from their conjugates F1*, F2*, ... (transforming as (0,1) under the Lorentz group). Furthermore, all operators with F1(*), F2(*), ... will be marked as being real (so the counting of such operators/terms refers to real ones). The reason: without the equations of motion, the Bianchi identities can be used to remove operators with Fi or Fi*, turning the counting ambiguous." ,{Bold,FontFamily->"Consolas",Black}]];
];
];

If[OptionValue[Verbose]=!=False&&OptionValue[Verbose]=!="OnlyStatistics",

If[Length[outputData]<=200,

toPrint=BuildTableToPrint[model,outputData,OptionValue[CalculateSnSymmetries],OptionValue[Verbose]];
Sym2Int\[UnderBracket]OperatorTable=toPrint;
Print[toPrint];
vSpace="\n";
,
Print[Style["WARNING: there are more than 200 types of operators. It is not a good idea to try to print them on Mathematica's front end. Use the raw data output of GenerateListOfCouplings instead.",{Bold,FontFamily->"Consolas",Darker[Red]}]];
vSpace="\n";
];
];

If[OptionValue[Verbose]=!=False,

aux=ModelStatistics[outputData,order];
Sym2Int\[UnderBracket]Statistics=aux[[1]];
Sym2Int\[UnderBracket]StatisticsTable=aux[[2]];
Print[Style[vSpace<>"***************************** Statistics ****************************",{Bold,FontFamily->"Consolas"}]];
Print[aux[[2]]];
];

(* Print["P7 ",TimeUsed[]-tmp]; *)

Return[outputData];
]


(* ::Input::Initialization:: *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX FindAllInteractions XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* FindAllInteractions generates list of interactions which are invariant under the gauge, lorentz, and discrete groups. The list is elaborated assuming infinite copies of each field. *)
(* Output of the function is a list {<int1>, <int2>,...} where each intN={<field1>,<field2>,...} gives the list of participating fields, given by their position in the model list (and a -1 sign means conjugation) *)
Options[FindAllInteractions]={HCTerms->False,MaxOrder->4,IncludeDerivatives->True,UseEOM->True};
FindAllInteractions[model_,OptionsPattern[]]:=Module[{nameOfTheFields,reps\[UnderBracket]gaugeIn,reps\[UnderBracket]lorentzIn,reps\[UnderBracket]RI,reps\[UnderBracket]copies,reps\[UnderBracket]gauge,reps\[UnderBracket]otherCharges,order,reps\[UnderBracket]lorentz,fullGroup,theFullReps,theFullRepsC,tableConjClasses,massDimensions,indicesForMod,U1pos,nonU1pos,U1charges,otherCharges,indicesForModOfNonU1s,maxF,aux,trueFieldIndicesRule,reps,result,rule,ruleForSelfConjFields,includeDerivatives,uniqueFields,gaugeBosonsIndices,gb,derBounded,derFree,aux2,replacementRule,realFieldsRule},


(* .................................................................................... *)
(* ............................... Initialize variables ............................... *)
(* .................................................................................... *)

order=OptionValue[MaxOrder];
includeDerivatives=OptionValue[IncludeDerivatives];
{nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,massDimensions,reps\[UnderBracket]otherCharges}=ExtractModelData[model][[1;;7]];
If[includeDerivatives,
AppendTo[nameOfTheFields,"D"];
AppendTo[reps\[UnderBracket]gauge,SimpleRepInputConversion[gaugeGroup[model],If[#===U1,0,1]&/@gaugeGroup[model]]];
AppendTo[reps\[UnderBracket]lorentz,SimpleLorentzInputConversion["V"]];
AppendTo[reps\[UnderBracket]RI,"R"];
AppendTo[reps\[UnderBracket]copies,1];
AppendTo[massDimensions,1];
AppendTo[reps\[UnderBracket]otherCharges,TrivialRep[ungaugedGroup[model]]]; 
];

(* .................................................................................... *)
(* .......... Prepare things for recursive function TryAllFieldCombinations ........... *)
(* .................................................................................... *)

fullGroup=Join[gaugeGroup[model],{SU2,SU2}];

theFullReps=Flatten[#,1]&/@Transpose[{reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz}];
theFullRepsC=Flatten[#,1]&/@Transpose[{ConjugateIrrep[gaugeGroup[model],#]&/@reps\[UnderBracket]gauge,Reverse/@reps\[UnderBracket]lorentz}];

tableConjClasses=Flatten/@Join[Table[Table[ConjugacyClass[fullGroup[[i]],theFullReps[[repI,i]]],{i,Length[fullGroup]}],{repI,Length[theFullReps]}],Table[Table[ConjugacyClass[fullGroup[[i]],theFullRepsC[[repI,i]]],{i,Length[fullGroup]}],{repI,Flatten[Position[reps\[UnderBracket]RI,"C"]]}]];
PrependTo[tableConjClasses,0tableConjClasses[[1]]];

(* NOTE: massDimensions is a special list at this point of the code; it includes an entry for the complex-conjugated fields and also for a dummny 'no field' *)
massDimensions=Join[massDimensions,massDimensions[[Flatten[Position[reps\[UnderBracket]RI,"C"]]]]];
PrependTo[massDimensions,1]; (* index 1 corresponds to no field; ie it is used to get the operators with less than MaxOrder *)

indicesForMod=Flatten[ConjugacyClassGroupModIndices/@fullGroup]; (* -1 means it is a U1 charge *)
U1pos=Flatten[Position[indicesForMod,-1]];
nonU1pos=Complement[Range[Length[indicesForMod]],U1pos];
U1charges=tableConjClasses[[All,U1pos]];
otherCharges=tableConjClasses[[All,nonU1pos]];
indicesForModOfNonU1s=indicesForMod[[nonU1pos]];

maxF=Length[massDimensions];

(* .................................................................................... *)
(* .................................................................................... *)
(* .................................................................................... *)
(* ............ Use conjugacy classes and U1 charges to get a reduced list ............ *)
(* .............. of POTENTIALLY gauge and lorentz invariant interactions ............. *)
(* .................................................................................... *)
(* .................................................................................... *)
(* .................................................................................... *)

(* TODO: Use also*)

ClearAll[massDData];
ClearAll[fieldsWhichCanBeAdded];
Do[massDData[i,j]=i+massDimensions[[j]];,{i,0,order,1/2},{j,Length[massDimensions]}];
Do[fieldsWhichCanBeAdded[i,minF]=DeleteCases[Flatten[Position[massDimensions,x_/;x<=i]],y_/;y<minF],{i,1/2,order,1/2},{minF,1,Length[massDimensions]}];

TryAllFieldCombinations[initCombination_,massD_,minF_]:=Block[{tmp},
If[massD==order,
aux=Total[U1charges[[initCombination]]];

If[(aux==0aux),
aux=Total[otherCharges[[initCombination]]];

If[And@@Divisible[aux,indicesForModOfNonU1s],Sow[initCombination]];
];
,
TryAllFieldCombinations[Append[initCombination,#],massDData[massD,#],#]&/@fieldsWhichCanBeAdded[order-massD,minF];
];
];
aux=Drop[Reap[TryAllFieldCombinations[{},0,1]][[2,1]],1];

(* .................................................................................... *)
(* ................ Some clean up and change of notation is necessary ................. *)
(* .................................................................................... *)

trueFieldIndicesRule=Join[Range[Length[theFullReps]],-Flatten[Position[reps\[UnderBracket]RI,"C"]]];
trueFieldIndicesRule=MapThread[Rule,{1+Range[Length[trueFieldIndicesRule]],trueFieldIndicesRule}];
aux=DeleteCases[aux,1,{2}]/.trueFieldIndicesRule;


(* POINT 1 *)

(* .................................................................................... *)
(* .... If derivatives are included, then the model to be evaluated must be changed ... *)
(* .................................................................................... *)

If[includeDerivatives,
aux=AddGaugeBosons[model,aux,massDimensions,order,1+Length[fields[model]]];


(* POINT 2 *)


aux=ApplyDerivativesToFields[aux,1+Length[fields[model]]];

(* POINT 3 *)


(* Print["P3-b ",TimeUsed[]-tmp]; *)

(* modify model reps *)
uniqueFields=Flatten[aux,1]//DeleteDuplicates;
uniqueFields=DeleteCases[DeleteDuplicates[Abs[uniqueFields]],x_/;x[[1]]==1+Length[fields[model]]];
uniqueFields=SortBy[uniqueFields,(2#[[2]]Length[uniqueFields]+#[[1]])&];

fieldsAUX[model]^=ModifyModelFieldsToIncludeDerivatives[model,uniqueFields,1+Length[fields[model]],massDimensions[[2;;-1]],reps\[UnderBracket]otherCharges];


(* POINT 4 *)

{nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,massDimensions,reps\[UnderBracket]otherCharges}=ExtractModelData[model][[1;;7]];
(* PrependTo[massDimensions,1]; (* because massDimensions[[1]] used to be a placeholder for a 'no field' *) *)


(* Change notation of the list of interactions obtained earlier *);
aux2=GatherBy[fieldsAUX[model],#[[2]]&];
replacementRule=Join[Table[aux2[[i,1,2]]->aux2[[i,All,1]],{i,Length[aux2]}],Table[{-1,1}aux2[[i,1,2]]->-aux2[[i,All,1]],{i,Length[aux2]}]];

(* realFieldsRule is necessary for some fields which consist on gauge bosons with derivatives: der^n[F+F*]. Since F is complex they might appear conjugated in the final result without this extra code *)
realFieldsRule=(-#->#&/@Flatten[Position[fieldsAUX[model][[All,6]],"R"]]);
replacementRule[[All,2]]=replacementRule[[All,2]]/.realFieldsRule;

aux=Flatten[Tuples/@(aux/.Dispatch[replacementRule]),1];
aux=DeleteDuplicates[aux]; (* Just to make sure ... due to the application of realFieldsRule *)

,
(* Even if no derivatives are to be considered, it is useful to populate fieldsAUX[model] as in the derivative case so that later on the same code can be used in all cases *)

aux2=Table[{fldI,{fldI,0},fields[model][[fldI,1]],SimpleRepInputConversion[gaugeGroup[model],fields[model][[fldI,2]]],SimpleLorentzInputConversion[fields[model][[fldI,3]]],fields[model][[fldI,4]],fields[model][[fldI,5]],massDimensions[[1+fldI]],reps\[UnderBracket]otherCharges[[fldI]],grassmannNature[model][[fldI]]},{fldI,Length[fields[model]]}];

fieldsAUX[model]^=AppendTo[aux2,{Length[fields[model]]+1,{Length[fields[model]]+1,0},"D",Null,Null,Null,Null,Null,Null,Null}];
];

(* .................................................................................... *)
(* ............. Now get the correct list of gauge-invariant interactions ............. *)
(* .................................................................................... *)

reps=MapThread[List,{Range[Length[reps\[UnderBracket]gauge]],reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]otherCharges,reps\[UnderBracket]RI,reps\[UnderBracket]copies}];

rule=Join[Table[i->reps[[i]],{i,Length[reps\[UnderBracket]gauge]}],Table[-i->ConjugateRepSpecial[model,reps[[i]]],{i,1,Length[reps\[UnderBracket]gauge]}]];
rule=Dispatch[rule];

result=Cases[aux,x_/;ContainsSingletQ[model,x/.rule]];

(* .................................................................................... *)
(* ............................. Maybe cut down h.c. terms ............................ *)
(* .................................................................................... *)

If[!OptionValue[HCTerms],
ruleForSelfConjFields=MapThread[Rule,{-Flatten[Position[reps\[UnderBracket]RI,"R"]],Flatten[Position[reps\[UnderBracket]RI,"R"]]}];

(* Chosen terms are those with less conjugations: SortBy[#,(Count[#,x_/;x<0]&)]& *)
result=DeleteDuplicates[SortBy[#,(Count[#,x_/;x<0]&)]&/@MapThread[List,{Sort/@result,Sort/@((-result)/.ruleForSelfConjFields)}]][[All,1]];
];

(* .................................................................................... *)
(* .... Delete dim 4 or smaller interactions with derivatives and/or gauge bosons ..... *)
(* .................................................................................... *)

If[includeDerivatives,
gaugeBosonsIndices=Length[fields[model]]+1+Range[Length[gaugeGroup[model]]];
gb=If[MemberQ[gaugeBosonsIndices,#[[2,1]]],1,0]&/@fieldsAUX[model];
derBounded=fieldsAUX[model][[All,2,2]];
derFree=UnitVector[Length[fieldsAUX[model]],derivativeIndex[model]];
result=DeleteCases[result,x_/;Total[massDimensions[[Abs[x]]]]<=4&&(Total[gb[[Abs[x]]]]+Total[derBounded[[Abs[x]]]]+Total[derFree[[Abs[x]]]])>0,{1}];
];

(* .................................................................................... *)
(* .................................. Sort results .................................... *)
(* .................................................................................... *)

(* Sort results by operator dimension *)
result=SortBy[result,Total[massDimensions[[Abs[#]]]]&];

(* Now we would like to sort the fields in each interaction: this is done by Abs[<pos of the field given by user>] as the first criteria, and then conjugated fields last (second criteria) *)
result=SortBy[#,({Abs[#],-#}&)]&/@result;


Return[result];
]


(* ::Input::Initialization:: *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX AnalizeInteraction XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)


(* AnalizeInteraction considers more information about each interaction: (A) the permutation symmetry, (B) the explicit invariants, and  (C) if the operator exists at all for the given number of flavors [based on information (A)] *)
(* The interaction should have the form {<field1>,<field2>,...}, where each field is identified with its position in the model list (and a -1 sign means conjugation) *)

Options[AnalizeInteraction]={CalculateSnSymmetries->True,CalculateInvariants->False,UseFieldsAUX->False};
AnalizeInteraction[model_,fieldPositions_,OptionsPattern[]]:=Module[{nameOfTheFields,reps\[UnderBracket]gaugeIn,reps\[UnderBracket]RI,reps\[UnderBracket]copies,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,interaction,result,survivingInvariants,nameHeadsToUse,distinguishReps,gReps,lorentzRep,rep,aux,aux2,isFermionQ,needToConsiderGrassmannNature,fermionsPos,nFlavs,nFlavsMin,validInvsPos,reps,grassmannCorrection},

(* .................................................................................... *)
(* .................................. Initializations ................................. *)
(* .................................................................................... *)

{nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,reps\[UnderBracket]otherCharges,grassmannCorrection}=ExtractModelData[model][[{1,2,3,4,5,7,8}]];

(* Consider all non-abelian gauge symmetries (gauged or not). [Abelians ones have already played their role in forbidding some interactions]*)
pos1=Flatten[Position[ungaugedGroup[model],Z[_],-1]];
pos2=Flatten[Position[ungaugedGroup[model],U1,-1]];
pos1=Complement[Range[Length[ungaugedGroup[model]]],Join[pos1,pos2]];

pos2=Flatten[Position[gaugeGroup[model],U1,-1]];
pos2=Complement[Range[Length[gaugeGroup[model]]],pos2];

nonAbelianGroup=Join[gaugeGroup[model][[pos2]],ungaugedGroup[model][[pos1]]];
reps\[UnderBracket]nonAbelian=MapThread[Join,{reps\[UnderBracket]gauge[[All,pos2]],reps\[UnderBracket]otherCharges[[All,pos1]]}];

(* interaction has the format {# of the field,gauge rep (maybe already conjugated),Lorentz rep (maybe already conjugated),discreteSym, is it conjugated?0=no,1=yes, # copies/flavours of the field} *)
interaction=Table[{Abs[el],If[el>0,reps\[UnderBracket]nonAbelian[[Abs[el]]],ConjugateIrrep[nonAbelianGroup,reps\[UnderBracket]nonAbelian[[Abs[el]]]]],If[el>0,reps\[UnderBracket]lorentz[[Abs[el]]],Reverse[reps\[UnderBracket]lorentz[[Abs[el]]]]],"DS",If[el>0,0,1],reps\[UnderBracket]copies[[Abs[el]]]},{el,fieldPositions}];
result={interaction,Null,Null,Null};

(* .................................................................................... *)
(* .......... Calculate the invariants (comes before permutation symmetry) ............ *)
(* .................................................................................... *)
(*
If[OptionValue[CalculateInvariants],

survivingInvariants=LorentzInvariants[gaugeGroup[model],reps\[UnderBracket]gauge[[interaction[[All,1]]]],reps\[UnderBracket]lorentz[[interaction[[All,1]]]],(interaction[[All,5]]/.{0\[Rule]False,1\[Rule]True}),DistinguishFields\[Rule](interaction[[All,1]](interaction[[All,5]]/.{0\[Rule]-1,1\[Rule]1}))];
(* Note that at this point, these are not really just the surviving invariants, since all invariants are being kept. Below, at the end of PART4, this is fixed. *)

nameHeadsToUse=Table[nameOfTheFields[[interaction[[i,1]]]]<>If[interaction[[i,5]]\[Equal]0,"","C"],{i,Length[interaction]}];
survivingInvariants[[2,All,All,0]]=Table[ConstantArray[nameHeadsToUse[[elI]],Length[survivingInvariants[[2,elI]]]],{elI,Length[survivingInvariants[[2]]]}];

result[[3]]=survivingInvariants;
];
*)

(* .................................................................................... *)
(* ................ Look at the permutation symmetry of the invariants ................ *)
(* .................................................................................... *)

If[OptionValue[CalculateSnSymmetries],
distinguishReps=interaction[[All,1]](1-2interaction[[All,5]]);
(* gReps=If[#[[5]]\[Equal]0,#[[2]],ConjugateIrrep[gaugeGroup,#[[2]]]]&/@interaction; *)
gReps=#[[2]]&/@interaction;
(* lorentzRep=If[#[[5]]\[Equal]0,#[[3]],Reverse[#[[3]]]]&/@interaction; *)
lorentzRep=#[[3]]&/@interaction;
reps=Flatten[#,1]&/@MapThread[List,{gReps,lorentzRep}];

If[OptionValue[CalculateInvariants],
aux=$GroupMath\[UnderBracket]Invariants\[UnderBracket]Symmetries;
,
aux=PermutationSymmetryOfInvariants[Join[nonAbelianGroup,{SU2,SU2}],reps,DistinguishFields->distinguishReps];
];

(* Correct Grassmann nature of fermions *)
isFermionQ=grassmannCorrection[[Abs[fieldPositions]]];

needToConsiderGrassmannNature=isFermionQ[[#[[1]]]]&&Length[#]>1&/@aux[[1]];
fermionsPos=Flatten[Position[needToConsiderGrassmannNature,True]];

aux[[2,All,1,fermionsPos]]=Map[SnRepTimesTotallyAntisymmetric,aux[[2,All,1,fermionsPos]],{2}];

nFlavs=interaction[[All,6]];
nFlavs=nFlavs[[#]]&/@aux[[1,All,1]];
(* nFlavsMin=If[NumericQ[#],#,1]&/@nFlavs; *)
aux[[2]]=Table[{aux[[2,i,1]],Times@@MapThread[HookContentFormula,{aux[[2,i,1]],nFlavs}],aux[[2,i,2]]},{i,Length[aux[[2]]]}];

(* Delete those cases which cannot be realized with the given number of flavors *)
aux[[2]]=DeleteCases[aux[[2]],x_/;x[[2]]===0];

(*
If[OptionValue[CalculateInvariants],
aux2=Table[{aux[[2,i,3]]Times@@(SnIrrepDim/@aux[[2,i,1]]),aux[[2,i,2]],aux[[2,i,3]]},{i,Length[aux[[2]]]}];
aux2=Range@@@Transpose[{Accumulate[aux2[[All,1]]]-aux2[[All,1]]+1,Accumulate[aux2[[All,1]]]}];
validInvsPos=Flatten[aux2[[Flatten[Position[aux[[2]],x_/;x[[2]]=!=0,{1},Heads\[Rule]False]]]]];
result[[3]]={survivingInvariants[[1,validInvsPos]],survivingInvariants[[2]]};
];
*)
result[[2]]=aux;
];

(* Can the interaction be realized with the given number of fields? *)
result[[4]]=!(Length[result[[2]]]==2&&result[[2,2]]==={});

(* simplify 1st entry of the output, which identifies the interaction (should be the same as result[[1,All,1]] (1-2result[[1,All,5]])) *)
result[[1]]=fieldPositions;
Return[result];

];


(* ::Input::Initialization:: *)
(* With derivatives the permutation information in outputData might refer to different permutation groups. ConvertToIrrepOfBiggestPermutationGroup converts it all to irreps of the same, maximal permutation group G which is dictated only by the repeated participating fields, ignoring derivatives. *)

ConvertToIrrepOfBiggestPermutationGroup[model_,result_]:=ConvertToIrrepOfBiggestPermutationGroup[model,result[[All,7]],result[[All,8,2]]]

ConvertToIrrepOfBiggestPermutationGroup[model_,repeatedfields_,symmetries_]:=Module[{newRes,aux2,res,aux4,repeatedFields,nFlavs,validCases},
newRes=Reap[Do[
aux2=symmetries[[opIdex]];

res={};
Do[
aux4=Reap[Do[

aux3=If[fldGroupIrrep==={}||Head[fldGroupIrrep[[1]]]=!=List,{{fldGroupIrrep,1}},LittlewoodRichardsonCoefficients[fldGroupIrrep]];
Sow[aux3];
,{fldGroupIrrep,irrep[[1]]}]][[2]];
aux4=TuplesWithMultiplicity[Flatten[aux4,1]];
aux4[[All,2]]=aux4[[All,2]]irrep[[2]];

res=Join[res,aux4];

,{irrep,aux2}];
res=TallyWithMultiplicity[res];
Sow[res];
,{opIdex,1,Length[symmetries]}]][[2,1]];

newRes=DeleteCases[newRes,x_/;x[[2]]===0,{2}];


(* Remove Sn reps which cannot be realized with the n-flavs of the fields. Symbolic number of flavors (such as 'n') are treated as being infinite. *)
newRes=Reap[Do[
repeatedFields=repeatedfields[[i]];
nFlavs=fieldsAUX[model][[Abs[repeatedFields],7]];
nFlavs=If[Head[#]===Symbol,\[Infinity],#]&/@nFlavs;

validCases=Cases[newRes[[i]],x_/;(nFlavs-Length/@x[[1]])==Abs[(nFlavs-Length/@x[[1]])]];
Sow[validCases];
,{i,Length[newRes]}]][[2,1]];


Return[newRes];
]


(* ::Input::Initialization:: *)

(* This function is to be applied right after AnalizeInteraction. It changes the output format, and in particular operators which only differ by where the derivatives are applied, are collapsed into a single 'term type'. *)

(* Ouptut is {<termType>, <selfConjTypeQ>,<symInformation>,<total number of operators (real if selfConjTypeQ=True, complex otherwise)>,{<min terms>,<max terms>},<explicitInvariants>}. If <min terms>=<max terms>, then only a single number is shown. *)

(* [27/Sep/2022] calculateSnDataQ option removed; assumed to be always True. *)

ReorganizeOperatorData[model_,operatorTypeData_,operatorsData_]:=Module[{derIndex,maxTerms,minTerms,data,fieldTypes,posGroupFields,symReGrouped,aux,aux2,res,output,termType,symInformation,totalOp,explicitInvariants,fldGroups,selfConjTypeValue,selfConjTermValues,nFlavs,posAlwaysValidSnIrreps,repeatedFields,massDimension,selfConjTypeQ,numberTerms,finalSymInformation,maxAllowedPerTerm,nIrreps,fieldTypesConj,transpositionToDo,symReGroupedExtra},

derIndex=derivativeIndex[model];

selfConjTypeValue=If[operatorTypeData[[6]],1,2];
selfConjTermValues=If[#,1,2]&/@operatorTypeData[[7]];

termType=Join[ConstantArray[derIndex,operatorTypeData[[1,2]]],operatorTypeData[[1,1]]];
massDimension=Total[fieldsAUX[model][[Abs[termType],8]]];
selfConjTypeQ=operatorTypeData[[6]];

(* Invariants are only calculated when CalculateSnSymmetries\[Rule]False, in which case there is just one element in the list operatorsData *)
explicitInvariants=operatorsData[[1,3]];

(* .................................................................................... *)
(* ..................... 1. Remove information about derivatives .....................  *)
(* .................................................................................... *)

data=RemoveDerivativeInfo[model,#]&/@operatorsData;

(* .................................................................................... *)
(* ........... 2. Conjugate terms if that is necessary to make it canonical ........... *)
(* ........... (i.e. with type as given by the function OperatorsOfEachType) .......... *)
(* .................................................................................... *)

Do[
If[!operatorTypeData[[4,i]],
data[[i,1]]=data[[i,1]](If[#==="C",-1,1]&/@fieldsAUX[model][[Abs[data[[i,1]]],6]]);
];
,{i,Length[operatorTypeData[[2]]]}];

(* .................................................................................... *)
(* ..... 3. Group symmetries according to the fields with the derivatives removed ..... *)
(* .................................................................................... *)

fieldTypes=DeleteDuplicates[operatorTypeData[[1,1]]];

res=Reap[Do[

aux=Flatten[Position[FieldToFieldType[model,data[[i,1]]],#]]&/@fieldTypes;
aux=Table[{j,Position[aux,data[[i,2,1,j,1]]][[1,1]]},{j,Length[data[[i,2,1]]]}];

posGroupFields=SortBy[GatherBy[aux,#[[2]]&],#[[1,2]]&][[All,All,1]];
(* posGroupFields contains the positions of the groups of fields associated to fieldTypes *)

symReGrouped=Table[el[[grp]],{el,data[[i,2,2,All,1]]},{grp,posGroupFields}];
symReGrouped=Transpose[{symReGrouped,(-1)^operatorTypeData[[3,i]]selfConjTermValues[[i]]/selfConjTypeValue data[[i,2,2,All,3]]}];

(* If the operator-type is real but a particular operator is not, it is not enought to count twice the operator (rather, one must add by hand a new operator with the fields conjugated). Imagine D(phi) phi phi*^2 with a symmetry ({1}x{1})x{2}: we must account for D( phi* ) phi* phi^2 also with symmetry {2}x({1}x{1}) *)


If[operatorTypeData[[6]]&&!operatorTypeData[[7,i]],

fieldTypesConj=If[fieldsAUX[model][[Abs[#],6]]=="R",#,-#]&/@fieldTypes;
(* With $Sym2IntUseEOM=False fieldTypes and FieldToFieldType (see above) with not distinguish an F from an F*. So, make sure that in fieldTypesConj -(index of F) \[Rule] (index of F) *)
If[!$Sym2IntUseEOM,
startFPos=Length[fields[model]]+2;
FmunuPos=Range[startFPos,startFPos-1+Length[gaugeGroup[model]]];
fieldTypesConj=fieldTypesConj/.(-#->#&/@FmunuPos);

];

transpositionToDo=Flatten[Position[fieldTypes,#]&/@fieldTypesConj];
(* Next line: If $Sym2IntUseEOM it is possible that it possible that fieldTypesConj is not a transposition of fieldTypes at all. For example,  psi psi F F and psi psi F* F* would be marked as a complex operators, but of real type; the If[...] above does solve the problem: in the case of psi psi F F, with fieldTypes={psi,F} we would get fieldTypesConj={psi*,F*} which the If[...] above converts to {psi*,F} which is still not a permutation of fieldTypes. In those cases where the operator-type is really a complex one (such as in this example), but it is marked as real because there is an F, we can avoid problems by simply setting  transpositionToDo to be trivial. *)
If[Length[transpositionToDo]<Length[fieldTypes],transpositionToDo=Range[Length[fieldTypes]]];


symReGroupedExtra=symReGrouped;
symReGroupedExtra[[All,1]]=symReGrouped[[All,1,transpositionToDo]];
symReGrouped=TallyWithMultiplicity[Join[symReGrouped,symReGroupedExtra]];
symReGrouped[[All,2]]=1/2symReGrouped[[All,2]]; (* Because previously a factor of 2 was added *)

];
Sow[symReGrouped];

,{i,Length[operatorTypeData[[2]]]}]][[2,1]];

(* .................................................................................... *)
(* ................................ 4. Build the output ............................... *)
(* .................................................................................... *)



fldGroups=operatorTypeData[[1,2]]+Flatten[Position[operatorTypeData[[1,1]],#]]&/@fieldTypes;
(* symInformation={fldGroups,TallyWithMultiplicity[Flatten[res,1]]}; *)
symInformation={fldGroups,Flatten[res,1]};


(* ++++++++++++++    keep only the non-trivial symmetry information, ie the one about truly repeated fields ++++++++++++++ *)
aux2=Flatten[Position[symInformation[[1]],x_/;Length[x]>1,{1}]];
symInformation[[2,All,1]]=symInformation[[2,All,1,aux2]];
symInformation[[1]]=symInformation[[1,aux2]];

repeatedFields=termType[[symInformation[[1,All,1]]]];

totalOp=operatorTypeData[[5]];

(* In operators with derivatives, the symInformation contains data related to potentially different Sn1xSn2x... groups. However, to count terms and indeed in the Lagrangian what matters is the bigger S_(n1+n2...)x.. permutation group, which ignores the placement of derivatives. ConvertToIrrepOfBiggestPermutationGroup converts symInformation *)
finalSymInformation={symInformation[[1]],ConvertToIrrepOfBiggestPermutationGroup[model,{repeatedFields},{symInformation[[2]]}][[1]]};


If[finalSymInformation[[2,1,1]]==={},
numberTerms=finalSymInformation[[2,1,2]];
,
{maxAllowedPerTerm,nIrreps}={Times@@@Map[SnIrrepDim,finalSymInformation[[2,All,1]],{2}],finalSymInformation[[2,All,2]]};
numberTerms=Ceiling[Max[nIrreps/maxAllowedPerTerm]];
];

output={termType/.derIndex->0,massDimension,selfConjTypeQ,totalOp,numberTerms,repeatedFields,finalSymInformation,explicitInvariants};

Return[output];
]


(* ::Input::Initialization:: *)
(* model=SM for example; interaction should be contain the field positions, with - signs eventually for conjugations example: {-5,-5,4,4,1,1,-3,-3,-2,-2,-2,-2} *)

DetailedInteractionInformation[model_,interaction_]:=Module[{aux,aux1,aux2,nCopies,fieldNames,inputMod,whichFields,fermionQ,productsOfFieldsAux,productsOfFields,result,dataToPresent,posTransition,divsV,divsH},

aux=Tally[interaction][[All,1]];
fieldNames=If[#>0,fields[model][[#,1]]<>"[R]",fields[model][[-#,1]]<>"[C]"]&/@aux;

inputMod=Tally[interaction];
inputMod[[All,1]]=Join@@@PositionToReps[model,inputMod[[All,1]]][[All,2;;3]];

productsOfFields={};
Do[
whichFields=el;
fermionQ=(Mod[whichFields[[1,4,1]]+whichFields[[1,5,1]],2]==1);
aux=PermutationSymmetryOfTensorProductParts[Join[gaugeGroup[model],{SU2,SU2}],ConstantArray[whichFields[[1]],whichFields[[2]]]];
aux=aux[[2]];

If[fermionQ,
aux[[All,1,2]]=SnRepTimesTotallyAntisymmetric[#[[1]]]&/@aux[[All,1,2]],
(* Just remove a parentesis *)
aux[[All,1,2]]=#[[1]]&/@aux[[All,1,2]]; 
];
(* productsOfFieldsAux=If[!fermionQ,Cases[aux[[2,All,1]],x_/;x[[2,1]]\[Equal]{whichFields[[2]]}\[RuleDelayed]x[[1]]],Cases[aux[[2,All,1]],x_/;x[[2,1]]\[Equal]ConstantArray[1,whichFields[[2]]]\[RuleDelayed]x[[1]]]]; *)
AppendTo[productsOfFields,aux];

,{el,inputMod}];

result={Cases[ReduceRepProduct[Join[gaugeGroup[model],{SU2,SU2}],#[[All,1,1]]],x_/;x[[1]]==0x[[1]]:>x[[2]]],#[[All,1,1]],#[[All,1,2]],Times@@#[[All,2]]}&/@Tuples[productsOfFields];
result={#[[2]],#[[3]],#[[1,1]]#[[4]]}&/@DeleteCases[result,x_/;x[[1]]==={}];
result=SortBy[result,#[[2]]&];

(* --- Get things ready to present the data ---- *)

If[Length[result]==0,Return[result]];

dataToPresent=Prepend[result,{Style[fieldNames,{Bold,Darker[Red]}],Style[Tally[interaction][[All,2]],{Bold,Darker[Red]}],Style["Number of invariants",{Bold,Darker[Red]}]}];
posTransition=Position[result[[All,2]],#][[1,1]]&/@(result[[All,2]]//DeleteDuplicates);

divsV={1->{Black,Thick},2->Lighter[Gray,0.8],3->Lighter[Gray,0.8],4->Lighter[Gray,0.8],5->{Black,Thick}};
divsH=Join[{1->{Black,Thick},2->Black,-1->{Black,Thick}},Table[i->{Black,Dashed},{i,Drop[posTransition,1]+1}],Table[i->Lighter[Gray,0.8],{i,Complement[Range[Length[posTransition]],posTransition]+1}]];

nCopies=fields[model][[Abs[Tally[interaction][[All,1]]],5]];
aux1=Times@@MapThread[HookContentFormula,{#,nCopies}]&/@Tally[result[[All,2]]][[All,1]];
aux2=ConstantArray[SpanFromAbove,#-1]&/@Tally[result[[All,2]]][[All,2]];
aux=Prepend[Flatten[MapThread[Prepend,{aux2,If[#==0,Item[#,Background->Lighter[Red,0.85]],Item[#,Background->Lighter[Green,0.85]]]&/@aux1}]],"# Parameters"];
Print[Grid[Transpose[Append[Transpose[dataToPresent],aux]],Frame->All,FrameStyle->LightGray,Spacings->{1,1},Dividers->{divsV,divsH},Background->{None,{None,{Lighter[Gray,0.95],None}}},Alignment->{Center,Center}]];

(* Add number of parameters information *)
result=Transpose[Append[Transpose[result],Times@@MapThread[HookContentFormula,{#,nCopies}]&/@result[[All,2]]]];
Return[result];
]


(* ::Input::Initialization:: *)
(* auxiliar function of DetailedInteractionInformation *)
PositionToReps[model_,fieldPositions_]:=Module[{nameOfTheFields,reps\[UnderBracket]gaugeIn,reps\[UnderBracket]lorentzIn,reps\[UnderBracket]RI,discreteSym,reps\[UnderBracket]copies,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,interaction},
{nameOfTheFields,reps\[UnderBracket]gaugeIn,reps\[UnderBracket]lorentzIn,reps\[UnderBracket]RI,reps\[UnderBracket]copies}=Transpose[fields[model]];

(* Just converts the simplified input into Dynkin coefficients *)
reps\[UnderBracket]gauge=SimpleRepInputConversion[gaugeGroup[model],#]&/@reps\[UnderBracket]gaugeIn;
reps\[UnderBracket]lorentz=SimpleLorentzInputConversion/@reps\[UnderBracket]lorentzIn;

(* interaction has the format{# of the field,gauge rep (maybe already conjugated),Lorentz rep (maybe already conjugated),discreteSym, is it conjugated?0=no,1=yes, # copies/flavours of the field} *)
interaction=Table[{Abs[el],If[el>0,reps\[UnderBracket]gauge[[Abs[el]]],ConjugateIrrep[gaugeGroup[model],reps\[UnderBracket]gauge[[Abs[el]]]]],If[el>0,reps\[UnderBracket]lorentz[[Abs[el]]],Reverse[reps\[UnderBracket]lorentz[[Abs[el]]]]],"DS",If[el>0,0,1],reps\[UnderBracket]copies[[Abs[el]]]},{el,fieldPositions}];
Return[interaction];
]


(* ::Input::Initialization:: *)
(* Use it to get {nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,massDimensions,reps\[UnderBracket]otherCharges,reps\[UnderBracket]grassmannNature} of a model *)
ExtractModelData[model_]:=Module[{nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,massDimensions,reps\[UnderBracket]otherCharges,data,reps\[UnderBracket]grassmannNature},
If[!ValueQ[fieldsAUX[model]]||(ValueQ[fieldsAUX[model]]&&fieldsAUX[model]==={}),
{nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies}=Transpose[fields[model][[All,1;;5]]]; (* exclude #6 slot, which may contain other changes *)
massDimensions=massDs[model];
reps\[UnderBracket]otherCharges=ungaugedCharges[model];
reps\[UnderBracket]grassmannNature=grassmannNature[model];

(* Just converts the simplified input into Dynkin coefficients *)
reps\[UnderBracket]gauge=SimpleRepInputConversion[gaugeGroup[model],#]&/@reps\[UnderBracket]gauge;
reps\[UnderBracket]lorentz=SimpleLorentzInputConversion/@reps\[UnderBracket]lorentz;
,
{nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,massDimensions,reps\[UnderBracket]otherCharges,reps\[UnderBracket]grassmannNature}=Transpose[fieldsAUX[model]][[{3,4,5,6,7,8,9,10}]];
];

data={nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,massDimensions,reps\[UnderBracket]otherCharges,reps\[UnderBracket]grassmannNature};

Return[data];
]


(* ::Input::Initialization:: *)
(* Converts dim -dim to the Dynkin coefficients of the rep, anti-rep with that dimension (and no primes). If the input, for a given factor group, are already the Dynkin coefficients, that is fine too (no processing is done). *)
SimpleRepInputConversion[group_,rep_]:=SimpleRepInputConversion[group,rep]=Module[{dim,reps,result},
If[!IsSimpleGroupQ[group],Return[SimpleRepInputConversion@@@Transpose[{group,rep}]]];
If[group==U1,Return[rep]];
If[Head[rep]===List,Return[rep]];

dim=Abs[rep];
reps=RepsUpToDimNNoConjugates[group,dim];
reps=DeleteCases[reps,x_/;DimR[group,x]!=dim];
reps=Sort[reps,OrderedQ[{Join[{DimR[group,#1],RepresentationIndex[group,#1]},ConjugacyClass[group,#1],-#1],Join[{DimR[group,#2],RepresentationIndex[group,#2]},ConjugacyClass[group,#2],-#2]}]&];

result=If[rep>0,reps[[1]],ConjugateIrrep[group,reps[[1]]]];
Return[result];
]

(* One can give a Lorentz rep by name ("S","L","R","V"), {jL,jR}, or with Dynkin coeffiecients *)
SimpleLorentzInputConversion[rep_]:=SimpleLorentzInputConversion[rep]=Module[{},
If[Head[rep]===String,
Return[rep/.{"R"->{{0},{1}},"L"->{{1},{0}},"S"->{{0},{0}},"V"->{{1},{1}}}];
,
If[Depth[rep]==2,Return[2{{rep[[1]]},{rep[[2]]}}];,Return[rep];];
];
];


(* ::Input::Initialization:: *)
(* Auxiliar function to LorentzInvariants. Try nToMod[{2,3,4}] *)
nToMod[bIs_]:=Module[{ns,ii,res},
ns=Range[1,(Times@@bIs)]-1;
res={};
Do[
ii=Mod[ns,el];
ns=(ns-ii)/el;
PrependTo[res,ii];
,{el,Reverse[bIs]}];
Return[Transpose[res]+1];
]

(* Converts a Sn rep given by a partition of n into a formated name [specifically for use with GenerateListOfCouplings] *)
SnRepNameTemp[\[Lambda]_]:=Which[Length[\[Lambda]]==1,Style["S",{Bold,Orange}],Total[\[Lambda]]==Length[\[Lambda]],Style["A",{Bold,Blue}],True,Style[\[Lambda],{Bold,Purple}]]

SnRepNameTemp2[\[Lambda]_]:=Which[Length[\[Lambda]]==1,Style[\[Lambda],{Bold,Orange}],Total[\[Lambda]]==Length[\[Lambda]],Style[\[Lambda],{Bold,Blue}],True,Style[\[Lambda],{Bold,Purple}]]

(* OLD, used in the past when the non-gauged groups were Zn with multiplicative charges *)
ConjugateRepSpecial[model_,rep_]:={rep[[1]],ConjugateIrrep[gaugeGroup[model],rep[[2]]],Reverse[rep[[3]]],ConjugateIrrepIncludingZns[ungaugedGroup[model],rep[[4]]],rep[[5]],rep[[6]]}


(* ::Input::Initialization:: *)
(* Assumes that group is a list of factors! TODO - make it more robust *)
TrivialRep[group_]:=Module[{trivialRep,pos1,pos2,pos3},
trivialRep=ConstantArray[Null,Length[group]];

pos1=Flatten[Position[group,Z[_],-1]];
pos2=Flatten[Position[group,U1,-1]];
trivialRep[[pos1]]=ConstantArray[0,Length[pos1]];
trivialRep[[pos2]]=ConstantArray[0,Length[pos2]];

pos3=Complement[Range[Length[group]],Join[pos1,pos2]];
trivialRep[[pos3]]=ConstantArray[0,Length[#]]&/@group[[pos3]];

Return[trivialRep];
]

(* DONE: Works well for simple non-simple groups. Note: no group cannot be {} because this represents a U1 *)
IsSimpleGroupIncldingZnsQ[group_]:=Module[{},
(* If there are Z[n] discrete factor groups ... *)
If[Head[group]===Z,Return[True]];
If[MemberQ[group,Z[_]],Return[False]];

(* ... otherwise use IsSimpleGroupQ *)
Return[IsSimpleGroupQ[group]];
]

(* DONE: Works well for simple non-simple groups *)
ConjugateIrrepIncludingZns[groupIn_,repIn_]:=Module[{group,rep,conjRep},
If[IsSimpleGroupIncldingZnsQ[groupIn],
group={groupIn};rep={repIn};
,
group=groupIn;rep=repIn;
];
conjRep=Table[If[Head[group[[i]]]===Z,Mod[-rep[[i]],group[[i,1]]],ConjugateIrrep[group[[i]],rep[[i]]]],{i,Length[group]}];
If[IsSimpleGroupIncldingZnsQ[groupIn],conjRep=conjRep[[1]]];
Return[conjRep];
]

ConjugateRepSpecial[model_,rep_]:={rep[[1]],ConjugateIrrep[gaugeGroup[model],rep[[2]]],Reverse[rep[[3]]],ConjugateIrrepIncludingZns[ungaugedGroup[model],rep[[4]]],rep[[5]],rep[[6]]}


(* ASSUME FOR NOW that ungaugedGroup[model] is a list of simple factors *)
ContainsSingletQ[model_,reps_]:=Module[{testLorentz,testGauge,znTest,testContinuous,znPositions,znCharges,continuousPositions,continuousGroupNonGauged},
znPositions=Flatten[Position[Head/@ungaugedGroup[model],Z]];
znCharges=reps[[All,4,znPositions]];
znTest=(Mod[Total[znCharges],ungaugedGroup[model][[znPositions,1]]]==ConstantArray[0,Length[znPositions]]);

If[!znTest,Return[False,Module]];

continuousPositions=Complement[Range[Length[ungaugedGroup[model]]],znPositions];
continuousGroupNonGauged=ungaugedGroup[model][[continuousPositions]];

testContinuous=True; (* this line is important for the case when continuousGroupNonGauged={} *)
Do[testContinuous=MemberQ[ReduceRepProduct[continuousGroupNonGauged[[i]],Sort[reps[[All,4,continuousPositions[[i]]]]]],x_/;x[[1]]0==x[[1]]];If[!testContinuous,Return[False,Module]];,{i,Length[continuousGroupNonGauged]}];


Do[testLorentz=MemberQ[ReduceRepProduct[SU2,Sort[reps[[All,3,i]]]],x_/;x[[1]]0==x[[1]]];If[!testLorentz,Return[False,Module]];,{i,2}];

testGauge=True; (* this line is important for the case when gaugeGroup={} *)
Do[testGauge=MemberQ[ReduceRepProduct[gaugeGroup[model][[i]],Sort[reps[[All,2,i]]]],x_/;x[[1]]0==x[[1]]];If[!testGauge,Return[False,Module]];,{i,Length[gaugeGroup[model]]}];
Return[znTest&&testContinuous&&testLorentz&&testGauge];
]


(* ::Input::Initialization:: *)
(* Return the Sn rep which equals the product of \[Lambda] times the totally antisymmetric representation of Sn *)

(* The result is obtained by transposing the Yound diagram. See for example theorem TheoremIII.62 of https://www.physik.uni-bielefeld.de/~borghini/Teaching/Symmetries/12_01b.pdf *)
SnRepTimesTotallyAntisymmetric[\[Lambda]_]:=TransposePartition[\[Lambda]]


(* ::Input::Initialization:: *)
(* Returns list of elements corresponding to the model fields, with the format {<new field index>,{<original field index>,<n derivatives>},<name>,<gauge q.n.>,<lorentz q.n.>,<"R" or "C">,<# flavors>,<mass dimension>,<discrete charges>,<is Grassmann?>} *)

ModifyModelFieldsToIncludeDerivatives[model_,listOfFieldsAppearing_,derIdx_,massDimensions_,reps\[UnderBracket]otherCharges_]:=Module[{n,counter,result,fullName,fullNameR,gaugeQN,lorentzQN,realQ,nF,nameOfTheFields,reps\[UnderBracket]gaugeIn,reps\[UnderBracket]gauge,reps\[UnderBracket]lorentzIn,reps\[UnderBracket]lorentz,reps\[UnderBracket]RI,reps\[UnderBracket]copies,rootName,rootLorentzQN,FmunuQN,massD,otherQN,grassmann,derivative, aux,derivativeReps,isFmunuQ,realFmunuReps,complexFmunuReps},

n=Length[fields[model]];

{nameOfTheFields,reps\[UnderBracket]gaugeIn,reps\[UnderBracket]lorentzIn,reps\[UnderBracket]RI,reps\[UnderBracket]copies}=Transpose[fields[model][[All,1;;5]]];


(* Just converts the simplified input into Dynkin coefficients *)
reps\[UnderBracket]gauge=SimpleRepInputConversion[gaugeGroup[model],#]&/@reps\[UnderBracket]gaugeIn;

reps\[UnderBracket]lorentz=SimpleLorentzInputConversion/@reps\[UnderBracket]lorentzIn;

FmunuQN=Table[Adjoint[gaugeGroup[model]]UnitVector[Length[gaugeGroup[model]],gI],{gI,Length[gaugeGroup[model]]}];
counter=0;
result=Reap[Do[

(* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)
(* +++++++++++++++++++++++++++ Place the "derivative field" exactly at position n (counter=n) and move on +++++++++++++++++++++++++++ *)
(* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)

If[counter==n,
 (* jump one step to give space for the derivative *)
counter++;
derivative={counter,{derIdx,0},"D",SimpleRepInputConversion[gaugeGroup[model],If[#===U1,0,1]&/@gaugeGroup[model]],SimpleLorentzInputConversion["V"],"R",1,1,TrivialRep[ungaugedGroup[model]],True};
Sow[derivative];
];

(* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)
(* ++++++++++++++++++++++++ Handle the expected properties of the fields (some changes might be made later) +++++++++++++++++++++++++ *)
(* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)

rootName=If[el[[1]]<=n,nameOfTheFields[[el[[1]]]],If[PropertySetQ[model,gaugeBosonNames],gaugeBosonNames[model][[el[[1]]-n-1]],"F"<>ToString[el[[1]]-n-1]]<>If[$Sym2IntUseEOM,"","(*)"]];


gaugeQN=If[el[[1]]<=n,reps\[UnderBracket]gauge[[el[[1]]]],FmunuQN[[el[[1]]-n-1]]];
rootLorentzQN=If[el[[1]]<=n,reps\[UnderBracket]lorentz[[el[[1]]]],{{2},{0}}];
realQ=If[el[[1]]<=n,reps\[UnderBracket]RI[[el[[1]]]],"C"];
nF=If[el[[1]]<=n,reps\[UnderBracket]copies[[el[[1]]]],If[Head[$GaugeBosonMultiplicity]=!=List,$GaugeBosonMultiplicity,$GaugeBosonMultiplicity[[el[[1]]-n-1]]]];
massD=If[el[[1]]<=n,massDimensions[[el[[1]]]],2]+el[[2]];
otherQN=If[el[[1]]<=n,reps\[UnderBracket]otherCharges[[el[[1]]]],TrivialRep[ungaugedGroup[model]]];
grassmann=If[el[[1]]<=n,grassmannNature[model][[el[[1]]]],False];

(* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)
(* +++++++++ At this point, to make the final decisions on the properties of the fields (name, Lorentz quantum numbers, realQ) +++++++++++++ *)
(* +++++ we must consider (1) are there derivatives? (2) is the EOM flag on? (3) is the root field (with the derivatives) an Fmunu? +++++ *)
(* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)

If[el[[2]]===0,

(* ++++++++++++++++ No derivatives ++++++++++++++++ *)
fullName=rootName;
lorentzQN=rootLorentzQN;
,
(* +++++++++++++++ With derivatives +++++++++++++++ *)
fullName=\!\(\*
TagBox[
StyleBox["\"\<D\>\"",
ShowSpecialCharacters->False,
ShowStringCharacters->True,
NumberMarks->True],
FullForm]\)<>ToString[el[[2]]]<>"("<>rootName<>")";

(* If EOM are not used, then there are more Lorentz irreps to consider *)
If[$Sym2IntUseEOM,
(* ++++++++++++++++ Use EOMs ++++++++++++++++ *)
lorentzQN=rootLorentzQN+el[[2]];
,
(* ++++++++++++++ Don't use EOMs +++++++++++++ *)
isFmunuQ=If[el[[1]]<=n,False,True];

If[!isFmunuQ,
(* ++++++++++++++ Not an Fmunu +++++++++++++ *)
(* The symmetric contraction of n derivatives contains the reps {{n},{n}}, {{n-2},{n-2}}, .... Use those. *)
derivativeReps=Table[{{i},{i}},{i,el[[2]],0,-2}];
aux=ReduceRepProduct[{SU2,SU2},{rootLorentzQN,#}]&/@derivativeReps;
lorentzQN={#[[1,1]],Total[#[[All,2]]]}&/@GatherBy[Flatten[aux,1],#[[1]]&];

,
(* +++++++++++++++ Is an Fmunu +++++++++++++ *)
(* Need to consider the Bianchi identities. They remove all repeated Lorentz irreps, so all for irreps in {der}^x Fmunu do survive, but only one of each. For example {der}^1 Fmunu contains {{3},{1}},{{1},{1}} and {{1},{3}}. The problem then is how to make the result look self-conjugate: in this example, the {{3},{1}} is the conjugate of {{1},{3}} but {{1},{1}} must be real, so does it come from  der F or der F*? It must be from der[F+F*], while {{3},{1}} comes from der F and  {{1},{3}} from der F* (no confusion in these cases). So in the case of the real irrep one must better add a new variable name 'F+F*' to be clear *)
complexFmunuReps=Table[{{i+2},{i}},{i,el[[2]],0,-2}];
realFmunuReps=Table[{{i},{i}},{i,el[[2]],1,-2}];


(* fullNameR="D"<>ToString[el[[2]]]<>"("<>rootName<>"+"<>rootName<>"*"<>")"; *)

(* In this specific case (el[[2]]>0 && !$Sym2IntUseEOM && isFmunuQ) add here already the fields *)
Do[
counter++;
Sow[{counter,el,fullName,gaugeQN,lQN,"C",If[Head[$GaugeBosonMultiplicity]=!=List,$GaugeBosonMultiplicity,$GaugeBosonMultiplicity[[el[[1]]-n-1]]],massD,otherQN,grassmann}];
,{lQN,complexFmunuReps}];


(* Check in the rest of the code: even though these fields are marked as real ("R"), does the code still try to conjugate them because of the information in position #2 (el)? *)
Do[
counter++;
Sow[{counter,el,fullName,gaugeQN,lQN,"R",If[Head[$GaugeBosonMultiplicity]=!=List,$GaugeBosonMultiplicity,$GaugeBosonMultiplicity[[el[[1]]-n-1]]],massD,otherQN,grassmann}];
,{lQN,realFmunuReps}];

];
];
];

(* If EOM are not used (or # derivatives = 0), then there are more Lorentz irreps to consider *)
If[$Sym2IntUseEOM||el[[2]]===0,
counter++;
Sow[{counter,el,fullName,gaugeQN,lorentzQN,realQ,nF,massD,otherQN,grassmann}];
,
(* The case el[[2]]>0 && !$Sym2IntUseEOM && isFmunuQ was already taken care of above *)
If[!isFmunuQ,
Do[
counter++;
Sow[{counter,el,fullName,gaugeQN,lQN[[1]],realQ,lQN[[2]]nF,massD,otherQN,grassmann}];

,{lQN,lorentzQN}];
];

];
,{el,listOfFieldsAppearing}]][[2,1]];

Return[result];
]


(* ::Input::Initialization:: *)
AddGaugeBosons[model_,initListOfInteractionsIn_,massDimensions_,maxOrder_,derIndex_]:=Module[{initListOfInteractions,startFPos,FmunuPos,aux,aux2,FmunuListOfAdditions,massDimsOfTerms,result},
initListOfInteractions=Prepend[initListOfInteractionsIn,{}];

startFPos=Length[fields[model]]+2;
FmunuPos=Range[startFPos,startFPos-1+Length[gaugeGroup[model]]];
FmunuPos=Sort[Join[-FmunuPos,FmunuPos]];

aux=Table[DeleteDuplicates[Sort/@Tuples[FmunuPos,i]],{i,0,maxOrder/2}];
FmunuListOfAdditions=Table[Flatten[aux[[1;;i]],1],{i,1,Length[aux]}];


massDimsOfTerms=Total/@(massDimensions[[#]]&/@(1+Abs[initListOfInteractions]));
aux=Floor[(maxOrder-massDimsOfTerms)/2];
aux2=FmunuListOfAdditions[[aux+1]]; (* combinations of Fmunu which can be added to each term *)

result=Flatten[Table[Join[initListOfInteractions[[i]],el],{i,Length[initListOfInteractions]},{el,aux2[[i]]}],1];
result=Drop[result,1];
result=DeleteCases[result,x_/;Length[x]==Count[x,derIndex]];
Return[result];
]


(* ::Input::Initialization:: *)
ApplyDerivativesToFields[initListOfInteractions_,derIndex_]:=Module[{fieldList1,result,nDers,aux,aux2,aux3,groupPartitions},
fieldList1=DeleteCases[initListOfInteractions,x_/;Length[x]==Count[x,derIndex]];
result=Reap[Do[
nDers=Count[initInteraction,derIndex];
aux=Tally[DeleteCases[initInteraction,derIndex]];
Do[
groupPartitions=Flatten[Permutations/@IntegerPartitionsMOD[nDi,Length[aux]],1];
aux2=Flatten[Table[Tuples[IntegerPartitionsMOD[#1,#2]&@@@Transpose[{gp,aux[[All,2]]}]],{gp,groupPartitions}],1];
aux2=Transpose[aux2];
aux3=Flatten[#,1]&/@Transpose[Table[Thread[List[ConstantArray[aux[[i,1]],aux[[i,2]]],#]]&/@aux2[[i]],{i,Length[aux]}]];
(* If[nDi\[NotEqual]nDers,aux3=Prepend[#,{derIndex,nDers-nDi}]&/@aux3]; *)
If[nDi!=nDers,aux3=Join[ConstantArray[{derIndex,0},nDers-nDi],#]&/@aux3];
Sow[aux3];
,{nDi,0,nDers}];
,{initInteraction,fieldList1}]][[2]];
If[Length[result]>0,result=Flatten[result[[1]],1]];
Return[result];
]

(* Used by ApplyDerivativesToFields *)
IntegerPartitionsMOD[n_,parts_]:=PadRight[#,parts]&/@IntegerPartitions[n,parts]


(* ::Input::Initialization:: *)
Options[LorentzInvariants]={DistinguishFields->False};
LorentzInvariants[gaugeG_,gaugeReps_,lorentzReps_,conjs_,OptionsPattern[]]:=Module[{fullGroup,lorentzRepsDI,pConj,fullReps,pConjs,indicesOriginal,indicesConjugated,indicesConjugatedMod,repOriginal,rep,invariants,invariantsAr,rule},
fullGroup=Join[gaugeG,{SU2,SU2}];
lorentzRepsDI=SimpleLorentzInputConversion/@lorentzReps;
pConj=Flatten[Position[conjs,True]];
If[pConj!={},
lorentzRepsDI[[pConj]]=Reverse/@lorentzRepsDI[[pConj]];
];

fullReps=Join@@@Transpose[{gaugeReps,lorentzRepsDI}];

invariants=Invariants[fullGroup,fullReps,Conjugations->conjs,TensorForm->True,DistinguishFields->OptionValue[DistinguishFields]];

(* There is still a problem to be solved at this stage. Conjugation switches the Lorentz L < - > R groups, so we get the result in invariants. But then the component ordereing needs to be fixed. For example (L,R)={{2},{1}} gets treated as having components {11,12,13,21,22,23} in invariants, when in reality we would like the ordering {11,12,21,22,31,32}. This issue is fixed in the following code. *)
pConjs=Flatten[Position[conjs,True]];
If[pConjs!={},
invariantsAr=ArrayRules[invariants[[1]]][[1;;-2]];
];
Do[
rep=fullReps[[pos]];
repOriginal=rep;repOriginal[[-2]]=rep[[-1]];repOriginal[[-1]]=rep[[-2]];

indicesOriginal=nToMod[DimR[fullGroup,repOriginal]];
indicesConjugated=nToMod[DimR[fullGroup,rep]];
indicesConjugatedMod=indicesConjugated;indicesConjugatedMod[[All,-1]]=indicesConjugated[[All,-2]];indicesConjugatedMod[[All,-2]]=indicesConjugated[[All,-1]];

rule=MapThread[Rule,{Range[Length[indicesConjugatedMod]],Flatten[Position[indicesOriginal,#]&/@indicesConjugatedMod]}];
invariantsAr[[All,1,pos+1]]=invariantsAr[[All,1,pos+1]]/.rule;

,{pos,pConjs}];

If[pConjs!={},
invariants[[1]]=SparseArray[invariantsAr,Dimensions[invariants[[1]]]];
];


Return[invariants];
]


(* ::Input::Initialization:: *)
(* Instead of ValueQ[property[model]], which seems to always output True, use PropertySetQ[model,property] (if property[model]={}, Null or simply has no value set, this function will output False) *)

PropertySetQ[model_,property_]:=MemberQ[UpValues[model][[All,1]],HoldPattern[property[x_]],-1]&&(property[model]=!={})&&(property[model]=!=Null)


(* ::Input::Initialization:: *)
(* Input 'term' is the list of field numbers, as it appears in fieldsAUX[model]. Output is {<operator type>, <total derivatives>,<total dummy derivatives>,<interaction was conjugated (False) or not (True)>}. <operator type> is a list of field numbers, as ordered in fields[model], with all derivatives removed, and possibly conjugated *)
OperatorType[model_,term_]:=Block[{termMod,freeDs,appliedDs,formA,formAConj,operatorType,orderedQ,totalDs,startFPos,FmunuPos,ruleEOM},
(* Get rid of pure derivatives *)
termMod=DeleteCases[term,derivativeIndex[model]];

freeDs=Count[term,derivativeIndex[model]];
appliedDs=Total[fieldsAUX[model][[Abs[termMod],2,2]]];
totalDs=freeDs+appliedDs;

formA=Sign[termMod]fieldsAUX[model][[Abs[termMod],2,1]];
formAConj=formA(If[#==="C",-1,1]&/@fieldsAUX[model][[Abs[termMod],6]]);

(* If EOM's are not used, the Bianchi identities are such that the number of operators with F_munu=F + i F* and those with Ftilde_munu=F - i F* is different. Counting operators with F and F* becomes missleading, so it is best to STOP distinguishing F and F* in the final result *)
If[!$Sym2IntUseEOM,
startFPos=Length[fields[model]]+2;
FmunuPos=Range[startFPos,startFPos-1+Length[gaugeGroup[model]]];
ruleEOM=(-#->#)&/@FmunuPos;
{formA,formAConj}={formA,formAConj}/.ruleEOM;
];

formA=Sort[formA];
formAConj=Sort[formAConj];

If[OrderedQ[{{Count[formA,x_/;x<0],formA},{Count[formAConj,x_/;x<0],formAConj}}],
operatorType=Sort[formA];
orderedQ=True;
,
operatorType=Sort[formAConj];
orderedQ=False;
];

Return[{operatorType,totalDs,freeDs,orderedQ}];
]


(* ::Input::Initialization:: *)
OperatorsOfEachType[model_,data_,calculateSnDataQ_]:=Module[{selfConjQ,operatorTypes,operatorTypeGroups,aux,numberOfOperators,groupedUpTerms,numberOfFreeDs,noNeedToConjugateQ,selfConjTypeQ,startFPos,FmunuPos},

selfConjQ=Table[Sort[resultI[[1]]]==Sort[If[fieldsAUX[model][[Abs[#],6]]=="R",#,-#]&/@resultI[[1]]],{resultI,data}];
operatorTypeGroups=GatherBy[Table[{i,OperatorType[model,data[[i,1]]]},{i,Length[data]}],#[[2,1;;2]]&];

operatorTypes=operatorTypeGroups[[All,1,2,1;;2]];

groupedUpTerms=operatorTypeGroups[[All,All,1]];
numberOfFreeDs=operatorTypeGroups[[All,All,2,3]];
noNeedToConjugateQ=operatorTypeGroups[[All,All,2,4]];

selfConjTypeQ=Table[Sort[resultI[[1]]]==Sort[If[fieldsAUX[model][[Abs[#],6]]=="R",#,-#]&/@resultI[[1]]],{resultI,operatorTypes}];

(* If EOMs are not used, assume that all operator classes with Fmunu's are real (even those which due to the other fields cannot be real), so that the counting of operators and terms is for real ones *)
If[!$Sym2IntUseEOM,
startFPos=Length[fields[model]]+2;
FmunuPos=Range[startFPos,startFPos-1+Length[gaugeGroup[model]]];
aux=Flatten[Position[operatorTypes[[All,1]],x_/;Intersection[x,FmunuPos]=!={},{1},Heads->False]];
selfConjTypeQ[[aux]]=ConstantArray[True,Length[aux]];
];

(* selfConjTypeQ=True; *)

If[calculateSnDataQ,
aux=Table[data[[el[[i,1]],2,2,All,2]] . data[[el[[i,1]],2,2,All,3]](-1)^el[[i,2,3]]If[selfConjQ[[el[[i,1]]]],1,2],{el,operatorTypeGroups},{i,Length[el]}];
numberOfOperators=Simplify[Total/@aux];
numberOfOperators=numberOfOperators/(selfConjTypeQ/.{True->1,False->2});
,
numberOfOperators=ConstantArray[Null,Length[operatorTypeGroups]];
];

Return[{operatorTypes,groupedUpTerms,numberOfFreeDs,noNeedToConjugateQ,numberOfOperators,selfConjTypeQ,selfConjQ[[#]]&/@groupedUpTerms}];
]


(* ::Input::Initialization:: *)
DropElementsFromList[list_,elPos_]:=list[[Sort[Complement[Range[Length[list]],elPos]]]]
DropElementsFromLists[lists_,elPos_]:=lists[[All,Sort[Complement[Range[Length[lists[[1]]]],elPos]]]]

(* 1. Delete derivative symmetry information *)
(* Example: derIndex=59; termInfo={{4,4,-4,-4,59,59},{{{1,2},{3,4},{5,6}},{{{{2},{1,1},{2}},(1/4) (-1+nn) nn^2 (1+nn),1},{{{1,1},{2},{2}},(1/4) (-1+nn) nn^2 (1+nn),1}}},Null} *)
RemoveDerivativeInfo[model_,termInfo_]:=Module[{aux,aux2,convertIndicesRule,result},
aux=Sort[Flatten[Position[termInfo[[1]],derivativeIndex[model]]]];
If[aux==={},Return[termInfo]];

result=termInfo;
result[[1]]=DropElementsFromList[result[[1]],aux];

(* If is not activated if CalculateSnSymmetries\[Rule]False *)
If[result[[2]]=!=Null,

aux2=Flatten[Position[termInfo[[2,1]],aux]];
result[[2,1]]=DropElementsFromList[result[[2,1]],aux2];

result[[2,2,All,1]]=DropElementsFromLists[result[[2,2,All,1]],aux2];

(* sym info grouping at result[[2,1]] may still be incorrect if derivatives we dropped from the middle of result[[1]]. For example, if the fields were {A,Der,B,B}, the groups were {{1},{2},{3,4}} and at this point they would be converted to {{1},{3,4}}. But with the field in positin 2 dropped, it show read {{1},{2,3}}. Correct it now. *)
convertIndicesRule=DropElementsFromList[Range[Length[termInfo[[1]]]],aux];
convertIndicesRule=Table[convertIndicesRule[[i]]->i,{i,Length[convertIndicesRule]}];
result[[2,1]]=result[[2,1]]/.convertIndicesRule;
];

Return[result];
]

FieldToFieldType[model_,field_]:=Module[{result,aux,startFPos,FmunuPos,ruleEOM},
result=Sign[field]fieldsAUX[model][[Abs[field],2,1]];

If[!$Sym2IntUseEOM,
startFPos=Length[fields[model]]+2;
FmunuPos=Range[startFPos,startFPos-1+Length[gaugeGroup[model]]];
ruleEOM=(-#->#)&/@FmunuPos;
result=result/.ruleEOM;
];
Return[result];
]


(* ::Input::Initialization:: *)
SConsolas[expr_]:=Style[expr,FontFamily->"Consolas"]

DYT[\[Lambda]_,style_]:=If[style==="NoTableaux",SnRepNameTemp2[\[Lambda]],DrawYoungDiagramRaster[\[Lambda],9]]


(* ::Input::Initialization:: *)
BuildTableToPrint[model_,data_,calculateSnDataQ_,style_]:=Module[{tableToPrint,item,row,fieldsInInteraction,repeatedFieldsInInteraction,input,output,aux,divsH,divsV,fieldNames,table},

fieldNames=Join[{"\[ScriptCapitalD]"},fields[model][[All,1]],{"DER-PLACEHOLDER"},Table[If[PropertySetQ[model,gaugeBosonNames],gaugeBosonNames[model][[i]],"F"<>ToString[i]]<>If[$Sym2IntUseEOM,"","(*)"],{i,1,Length[gaugeGroup[model]]}]];
tableToPrint=Reap[Do[
item=data[[i]];

(* If CalculateSnSymmetries\[Rule]False  (item[[5]] is the number of op and it is not calculated in this case) *)
If[!calculateSnDataQ,
row=item[[1;;4]];

fieldsInInteraction=fieldNames[[1+Abs[#]]]<>If[#>=0,"","*"]&/@item[[2]];
row[[2]]=Row[fieldsInInteraction,"  "];
,

row=ConstantArray[Null,8];

row[[{1,3,4,5,6}]]=item[[{1,3,4,5,6}]];

fieldsInInteraction=fieldNames[[1+Abs[#]]]<>If[#>=0,"","*"]&/@item[[2]];
row[[2]]=Row[fieldsInInteraction,"  "];

repeatedFieldsInInteraction=fieldNames[[1+Abs[#]]]<>If[#>=0,"","*"]&/@item[[7]];
repeatedFieldsInInteraction=If[repeatedFieldsInInteraction==={},Null,repeatedFieldsInInteraction];
If[Length[repeatedFieldsInInteraction]==1,repeatedFieldsInInteraction=repeatedFieldsInInteraction[[1]]];
row[[7]]=repeatedFieldsInInteraction;

(* ++++++++++ symmetry information ++++++++++ *)
input=item[[8,2]];
If[item[[8,1]]==={},
output=Null;,
aux=Transpose[{input[[All,2]],Map[DYT[#,style]&,input[[All,1]],{2}]}];

aux[[2;;-1,1]]=Which[#==1,"+",#==-1,"-",#>0,"+"<>ToString[#],#<0,"-"<>ToString[Abs[#]]]&/@aux[[2;;-1,1]];
aux[[1,1]]=Which[aux[[1,1]]==1,"",aux[[1,1]]==-1,"-",aux[[1,1]]>0,ToString[aux[[1,1]]],aux[[1,1]]<0,ToString[aux[[1,1]]]];

(* If there is only one group of repeated fields, remove one set of parentesis *)
If[Length[item[[8,1]]]==1,aux[[All,2]]=aux[[All,2,1]]];

output=Row[DeleteCases[Flatten[aux,1],"",{1}]," "];
];
row[[8]]=output;
];
Sow[row];
,{i,0+ Length[data]}]][[2,1]];

divsH=Join[{1->{Black,Thick},2->Black,-1->{Black,Thick}},Table[i->Lighter[Gray,0.8],{i,3,Length[data]+1}]];

If[calculateSnDataQ,
divsV={1->{Black,Thick},2->Lighter[Gray,0.8],3->Lighter[Gray,0.8],4->Lighter[Gray,0.8],5->Lighter[Gray,0.8],6->Lighter[Gray,0.8],7->Lighter[Gray,0.8],8->Lighter[Gray,0.8],9->{Black,Thick}};

table=Grid[Prepend[tableToPrint,Style[#,{Bold,Darker[Red],FontFamily->"Consolas"}]&/@{"#",Column[{"Operator","type"},Center],"Dim.",Column[{"Self","conj.?"},Center],Column[{"Number of","operators"},Center],Column[{"Number of","terms"},Center],Column[{"Repeated","fields"},Center],Column[{"Permutation","symmetry"},Center]}],Dividers->{divsV,divsH},Spacings->{1,1},Background->{None,{None,{Lighter[Gray,0.95],None}}}];

,
divsV={1->{Black,Thick},2->Lighter[Gray,0.8],3->Lighter[Gray,0.8],4->Lighter[Gray,0.8],5->{Black,Thick}};

table=Grid[Prepend[tableToPrint,Style[#,{Bold,Darker[Red],FontFamily->"Consolas"}]&/@{"#",Column[{"Operator","type"},Center],"Dim.",Column[{"Self","conj.?"},Center]}],Dividers->{divsV,divsH},Spacings->{1,1},Background->{None,{None,{Lighter[Gray,0.95],None}}}]

];

Return[table];
]


(* ::Input::Initialization:: *)
ModelStatistics[data_,maxOrder_]:=Module[{opDimensions,nRealOperators,nRealTermsMin,nRealTermsMax,nRealTypes,aux,nOps,nTs,nTTs,statistics,divsH,divsV,tableWithStatistics,frameColor},

nRealOperators={};
nRealTermsMin={};
nRealTermsMax={};
nRealTypes={};
opDimensions={};
Do[
aux=Cases[data,x_/;x[[3]]==dimOp];
nOps=Simplify[aux[[All,5]] . (aux[[All,4]]/.{True->1,False->2})];
nTs=Total[aux[[All,6]](aux[[All,4]]/.{True->1,False->2})];
nTTs=Total[aux[[All,4]]/.{True->1,False->2}];
If[NumericQ[nTs],nTs={nTs,nTs}];

AppendTo[opDimensions,dimOp];
AppendTo[nRealOperators,nOps];
AppendTo[nRealTermsMin,nTs[[1]]];
AppendTo[nRealTermsMax,nTs[[-1]]];
AppendTo[nRealTypes,nTTs];
,{dimOp,Min[data[[All,3]]],maxOrder}];

statistics=Transpose[{opDimensions,nRealOperators,nRealTermsMin,nRealTermsMax,nRealTypes}];

aux=Table[{el[[1]],el[[2]],If[el[[3]]==el[[4]],el[[3]],Row[{el[[3]]," to ",el[[4]]}]],el[[5]]},{el,statistics}];
PrependTo[aux,Style[#,{Bold,Darker[Green],FontFamily->"Consolas"}]&/@{"Dimension","# real operators","# real terms", "# types of real operators"}];

frameColor=Black;
divsH=Join[{1->{frameColor,Thick},2->frameColor,-1->{frameColor,Thick}},Table[i->Lighter[Gray,0.8],{i,3,Length[statistics]+1}]];
divsV={1->{frameColor,Thick},2->Lighter[Gray,0.8],3->Lighter[Gray,0.8],4->Lighter[Gray,0.8],5->{frameColor,Thick}};

tableWithStatistics=Grid[aux,Dividers->{divsV,divsH},Spacings->{1,1},Background->{None,{None,{Lighter[Gray,0.95],None}}}];

Return[{statistics,tableWithStatistics}];
]


(* ::Input::Initialization:: *)
(* Prints data obtained with GenerateListOfCouplings in a table. The advantage is that one can select only part of the full data *)
PrintOperatorTable[model_,data_]:=If[data=!={},BuildTableToPrint[model,data,True,True]]


(* ::Input::Initialization:: *)
(* Prints data obtained with GenerateListOfCouplings in a table. The advantage is that one can select only part of the full data *)
PickParticularOperators[model_,output_,form_]:=Module[{fields,type1,type2,type3,aux,fieldStrings,ruleAux,fieldAbsNumbers,signs,realFieldsRule,search,slct},

fields=StringSplit[form];

type1=StringContainsQ[#,"(*)"]&/@fields;
type2=StringContainsQ[#,"*"]&/@fields;
type2=MapThread[And,{Not/@type1,type2}];
type3=MapThread[And,{Not/@type1,Not/@type2}];

fieldStrings=Table[If[type3[[elI]],fields[[elI]],StringReplace[fields[[elI]],{"(*)"->"","*"->""}]],{elI,Length[fields]}];
aux=Range[derivativeIndex[model]+Length[gaugeGroup[model]]];
ruleAux=Join[fieldsAUX[model][[#,3]]->#&/@Range[derivativeIndex[model]+Length[gaugeGroup[model]]],Table["F"<>ToString[i]->derivativeIndex[model]+i,{i,Length[gaugeGroup[model]]}]];

fieldAbsNumbers=fieldStrings/.ruleAux/.derivativeIndex[model]->0;
signs=Table[If[type1[[elI]],{-1,1},If[type2[[elI]],{-1},{1}]],{elI,Length[fields]}];

(*
realFieldsRule=Join[Table[If[fieldsAUX[model][[i,6]]\[Equal]"R",-i\[Rule]i,Nothing],{i,derivativeIndex[model]}],If[!$Sym2IntUseEOM,Table[-i\[Rule]i,{i,derivativeIndex[model]+1,derivativeIndex[model]+Length[gaugeGroup[model]]}],{}]];
*)
realFieldsRule=Join[Table[If[fieldsAUX[model][[i,6]]=="R",-i->i,Nothing],{i,derivativeIndex[model]}],If[Length[gaugeGroup[model]]>0&&StringContainsQ[fieldsAUX[model][[derivativeIndex[model]+1,3]],"(*)"],Table[-i->i,{i,derivativeIndex[model]+1,derivativeIndex[model]+Length[gaugeGroup[model]]}],{}]];

search=DeleteDuplicates[Sort[fieldAbsNumbers #/.realFieldsRule]&/@Tuples[signs]];
search=DeleteDuplicates[Join[search,Sort/@(-search/.realFieldsRule)]];

slct=Cases[output,x_/;MemberQ[search,Sort[x[[2]]]]];

Print[PrintOperatorTable[model,slct]];
]


(* ::Input::Initialization:: *)
(* contracts the i-th index of tensor with matrix  *)
ContractAt[tensor_,matrix_,i_]:=Module[{indices,result,n},
n=Length[Dimensions[tensor]];
indices=Range[n];
indices[[{i,n}]]={n,i};
result=Transpose[Transpose[tensor,indices] . matrix,indices];
Return[result];
]


(* ::Input::Initialization:: *)
(* The output eqs are equations which should equal 0. The position of each equation follows the results of GenerateListOfCouplings *)
CheckConservationOfAGlobalU1[result_,nameOfTheFields_]:=Module[{eqs,symMats,aux,tensors},
eqs={};
Do[
tensors=result[[elI,7,1]];

If[Length[tensors]>0,
symMats=Table[Sign[result[[elI,2,i]]]DiagonalMatrix[Array[nameOfTheFields[[Abs[result[[elI,2,i]]]]],Dimensions[tensors][[i+1]]]],{i,Length[result[[elI,2]]]}];
aux=Table[Sum[ContractAt[tensor,symMats[[j]],j],{j,Length[result[[elI,2]]]}],{tensor,tensors}];
,aux={}];
AppendTo[eqs,aux];
,{elI,Length[result]}];

Return[eqs];
]
