(* ::Package:: *)

(* ::MyStyle - H1 Framed:: *)
(*1 - Load Susyno, if necessary*)


failedToLoadSusyno[]:=(
Print[Style["Problem: failed to load the Susyno package.",{Bold,Darker[Red],FontFamily->"Consolas"}],Style[" Please ensure that ",{GrayLevel[0.5],FontFamily->"Consolas"}],Style[Hyperlink["Susyno","http://renatofonseca.net/susyno.php",Appearance->"Palette"],{GrayLevel[0.5],FontFamily->"Consolas"}],Style[" is installed in any of the following paths:\n",{GrayLevel[0.5],FontFamily->"Consolas"}],Grid[{Style[#,{FontFamily->"Consolas",GrayLevel[0.5]}]}&/@$Path,Alignment->{Left,Baseline}]];
Print[Style["Alternatively, you may try first to load Susyno manually, and then load Sym2Int.",{GrayLevel[0.5],FontFamily->"Consolas"}]];
);
susynoAlreadyLoadedQ=Or@@(!StringFreeQ[#,"Susyno`"]&/@Contexts[]);
If[!susynoAlreadyLoadedQ,
Quiet[Check[Get["Susyno`"],failedToLoadSusyno[]]];
];


(* ::MyStyle - H1 Framed:: *)
(*2 - Sym2Int loading information*)


SMexample="(* ***** Standard Model ***** *)\ngaugeGroup[SM]^={SU3,SU2,U1};\n\nfld1={\"u\",{3,1,2/3},\"R\",\"C\",3};\nfld2={\"d\",{3,1,-1/3},\"R\",\"C\",3};\nfld3={\"Q\",{3,2,1/6},\"L\",\"C\",3};\nfld4={\"e\",{1,1,-1},\"R\",\"C\",3};\nfld5={\"L\",{1,2,-1/2},\"L\",\"C\",3};\nfld6={\"H\",{1,2,1/2},\"S\",\"C\",1};\nfields[SM]^={fld1,fld2,fld3,fld4,fld5,fld6};\n\nGenerateListOfCouplings[SM,MaxOrder\[Rule]4];";

THDMexample="(* ***** Two Higgs doublet model ***** *)\ngaugeGroup[THDM]^={SU3,SU2,U1};\n\nfld1={\"u\",{3,1,2/3},\"R\",\"C\",3};\nfld2={\"d\",{3,1,-1/3},\"R\",\"C\",3};\nfld3={\"Q\",{3,2,1/6},\"L\",\"C\",3};\nfld4={\"e\",{1,1,-1},\"R\",\"C\",3};\nfld5={\"L\",{1,2,-1/2},\"L\",\"C\",3};\nfld6={\"H1\",{1,2,1/2},\"S\",\"C\",1};\nfld7={\"H2\",{1,2,1/2},\"S\",\"C\",1};\nfields[THDM]^={fld1,fld2,fld3,fld4,fld5,fld6,fld7};\n\nGenerateListOfCouplings[THDM];";

SMSeesawIIexample="(* ***** Standard Model plus one complex scalar triplet ***** *)\ngaugeGroup[SMSeesawII]^={SU3,SU2,U1};\n\nfld1={\"u\",{3,1,2/3},\"R\",\"C\",3};\nfld2={\"d\",{3,1,-1/3},\"R\",\"C\",3};\nfld3={\"Q\",{3,2,1/6},\"L\",\"C\",3};\nfld4={\"e\",{1,1,-1},\"R\",\"C\",3};\nfld5={\"L\",{1,2,-1/2},\"L\",\"C\",3};\nfld6={\"H\",{1,2,1/2},\"S\",\"C\",1};\nfld7={\"\[CapitalDelta]\",{1,3,1},\"S\",\"C\",1};\nfields[SMSeesawII]^={fld1,fld2,fld3,fld4,fld5,fld6,fld7};\n\nGenerateListOfCouplings[SMSeesawII,MaxOrder\[Rule]4];";

PPFexample="gaugeGroup[PPF331Model]^={SU3,SU3,U1};\n\n\[Psi]l={\"\[Psi]l\",{1,3,0},\"L\",\"C\",3};\nQ23L={\"Q23L\",{3,-3,-1/3},\"L\",\"C\",2};\nQ1L={\"Q1L\",{3,3,2/3},\"L\",\"C\",1};\nuc={\"uc\",{-3,1,-2/3},\"L\",\"C\",3};\ndc={\"dc\",{-3,1,1/3},\"L\",\"C\",3};\nJ12={\"J12\",{-3,1,4/3},\"L\",\"C\",1};\nJ3={\"J3\",{-3,1,-5/3},\"L\",\"C\",2};\n\n\[Chi]={\"\[Chi]\",{1,3,-1},\"S\",\"C\",1};\n\[Eta]={\"\[Eta]\",{1,3,0},\"S\",\"C\",1};\n\[Rho]={\"\[Rho]\",{1,3,1},\"S\",\"C\",1};\n\nfields[PPF331Model]^={\[Psi]l,Q23L,Q1L,uc,dc,J12,J3,\[Chi],\[Eta],\[Rho]};\n\nGenerateListOfCouplings[PPF331Model];";

SU5example="gaugeGroup[modelSU5]^={SU5};\n\nfld1={\"F\",{-5},\"L\",\"C\",3};\nfld2={\"T\",{10},\"L\",\"C\",3};\nfld3={\"5\",{5},\"S\",\"C\",1};\nfld4={\"24\",{24},\"S\",\"R\",1};\nfields[modelSU5]^={fld1,fld2,fld3,fld4};\n\nGenerateListOfCouplings[modelSU5];";


Block[{result},
result={};
AppendTo[result,Row[{Style["XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX ",{GrayLevel[0.5]}],Hyperlink[Mouseover[Style["Sym2Int",{GrayLevel[0.5]}],Style["Sym2Int",{Darker[Blue,0.5],Bold}]],"http://renatofonseca.net/sym2int.php"],Style[" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",{GrayLevel[0.5]}]}]];
AppendTo[result,Row[{Style["Version: 1.0; Author: Renato Fonseca.",{GrayLevel[0.5]}]}]];
AppendTo[result,Row[{Style["The Sym2Int program list all possible interactions with a given list of fields. ",{GrayLevel[0.5]}],Style[Hyperlink["This","http://renatofonseca.net/LINK.php"],{GrayLevel[0.5]}],Style[" webpage explains how to use it.",{GrayLevel[0.5]}]}]];
AppendTo[result,Style["XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",{GrayLevel[0.5]}]];

Print[Row[result,"\n",BaseStyle->(FontFamily->"Consolas")]];
];

Print[Style["Get started quickly by considering some examples (click on one of the models below):",{GrayLevel[0.5],FontFamily->"Consolas"}]];

Print[Grid[{{Button[Style["Standard Model",{Darker[Red],Bold,FontFamily->"Consolas"}],CellPrint[Cell[BoxData[SMexample],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"],Button[Style["Two Higgs Doublet Model",{Darker[Red],Bold,FontFamily->"Consolas"}],CellPrint[Cell[BoxData[THDMexample],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"],Button[Style["SM+scalar triplet",{Darker[Red],Bold,FontFamily->"Consolas"}],CellPrint[Cell[BoxData[SMSeesawIIexample],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"],Button[Style["Pisano-Pleitez-Frampton 331 Model",{Darker[Red],Bold,FontFamily->"Consolas"}],CellPrint[Cell[BoxData[PPFexample],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"],Button[Style["SU(5) Model",{Darker[Red],Bold,FontFamily->"Consolas"}],CellPrint[Cell[BoxData[SU5example],"Input",Background->Lighter[Orange,0.9]]],Appearance->"DialogBox"]}}]];


(* ::MyStyle - H2:: *)
(*TODO still:*)
(*1- Implement derivative terms;*)
(*2- Introduce the possibility of adding (any) discrete symmetry*)


(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX LorentzInvariants XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Converts dim -dim to the Dynkin coefficients of the rep, anti-rep with that dimension (and no primes). If the input, for a given factor group, are already the Dynkin coefficients, that is fine too (no processing is done). *)
SimpleRepInputConversion[group_,rep_]:=Module[{dim,reps,result},
If[!IsSimpleGroupQ[group],Return[SimpleRepInputConversion@@@Transpose[{group,rep}]]];
If[group==U1,Return[rep]];
If[Head[rep]===List,Return[rep]];

dim=Abs[rep];
reps=RepsUpToDimNNoConjugates[group,dim];
reps=DeleteCases[reps,x_/;DimR[group,x]!=dim];
reps=Sort[reps,OrderedQ[{Join[{DimR[group,#1],RepresentationIndex[group,#1]},ConjugacyClass[group,#1],-#1],Join[{DimR[group,#2],RepresentationIndex[group,#2]},ConjugacyClass[group,#2],-#2]}]&];

result=If[rep>0,reps[[1]],ConjugateIrrep[group,reps[[1]]]];
Return[result];
]

(* One can give a Lorentz rep by name ("S","L","R","V"), {jL,jR}, or with Dynkin coeffiecients *)
SimpleLorentzInputConversion[rep_]:=Module[{},
If[Head[rep]===String,
Return[rep/.{"R"->{{0},{1}},"L"->{{1},{0}},"S"->{{0},{0}},"V"->{{1},{1}}}];
,
If[Depth[rep]==2,Return[2{{rep[[1]]},{rep[[2]]}}];,Return[rep];];
];
];

(* Auxiliar function to LorentzInvariants. Try nToMod[{2,3,4}] *)
nToMod[bIs_]:=Module[{ns,ii,res},
ns=Range[1,(Times@@bIs)]-1;
res={};
Do[
ii=Mod[ns,el];
ns=(ns-ii)/el;
PrependTo[res,ii];
,{el,Reverse[bIs]}];
Return[Transpose[res]+1];
]

LorentzInvariants[gaugeG_,gaugeReps_,lorentzReps_,conjs_]:=Module[{fullGroup,lorentzRepsDI,pConj,fullReps,pConjs,indicesOriginal,indicesConjugated,indicesConjugatedMod,repOriginal,rep,invariants,invariantsAr,rule},
fullGroup=Join[gaugeG,{SU2,SU2}];
lorentzRepsDI=SimpleLorentzInputConversion/@lorentzReps;
pConj=Flatten[Position[conjs,True]];
If[pConj!={},
lorentzRepsDI[[pConj]]=Reverse/@lorentzRepsDI[[pConj]];
];

fullReps=Join@@@Transpose[{gaugeReps,lorentzRepsDI}];

invariants=Invariants[fullGroup,fullReps,Conjugations->conjs,TensorForm->True];


pConjs=Flatten[Position[conjs,True]];
If[pConjs!={},
invariantsAr=ArrayRules[invariants[[1]]][[1;;-2]];
];
Do[
rep=fullReps[[pos]];
repOriginal=rep;repOriginal[[-2]]=rep[[-1]];repOriginal[[-1]]=rep[[-2]];

indicesOriginal=nToMod[DimR[fullGroup,repOriginal]];
indicesConjugated=nToMod[DimR[fullGroup,rep]];
indicesConjugatedMod=indicesConjugated;indicesConjugatedMod[[All,-1]]=indicesConjugated[[All,-2]];indicesConjugatedMod[[All,-2]]=indicesConjugated[[All,-1]];

rule=MapThread[Rule,{Range[Length[indicesConjugatedMod]],Flatten[Position[indicesOriginal,#]&/@indicesConjugatedMod]}];
invariantsAr[[All,1,pos+1]]=invariantsAr[[All,1,pos+1]]/.rule;

,{pos,pConjs}];

If[pConjs!={},
invariants[[1]]=SparseArray[invariantsAr,Dimensions[invariants[[1]]]];
];


Return[invariants];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX GenerateListOfCouplings XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Converts a Sn rep given by a partition of n into a formated name [specifically for use with GenerateListOfCouplings] *)
SnRepNameTemp[\[Lambda]_]:=Which[Length[\[Lambda]]==1,Style["S",{Bold,Orange}],Total[\[Lambda]]==Length[\[Lambda]],Style["A",{Bold,Blue}],True,Style[\[Lambda],{Bold,Purple}]]

ConjugateRepSpecial[gaugeGroup_,rep_]:={rep[[1]],ConjugateIrrep[gaugeGroup,rep[[2]]],Reverse[rep[[3]]],Conjugate[rep[[4]]],rep[[5]],rep[[6]]};

ContainsSingletQ[gaugeGroup_,reps_]:=Module[{auxG,auxL,auxDiscrete},
auxG=MemberQ[ReduceRepProduct[gaugeGroup,reps[[All,2]]],x_/;x[[1]]0==x[[1]]];
auxL=MemberQ[ReduceRepProduct[{SU2,SU2},reps[[All,3]]],x_/;x[[1]]0==x[[1]]];
auxDiscrete=((Times@@reps[[All,4]])==1+0(Times@@reps[[All,4]]));
Return[auxG&&auxL&&auxDiscrete];
];

(* Return the Sn rep which equals the product of \[Lambda] times the totally antisymmetric representation of Sn *)
SnRepTimesTotallyAntisymmetric[\[Lambda]_]:=Module[{n,antiS,result},
n=Total[\[Lambda]];
antiS=ConstantArray[1,n];
result=IntegerPartitions[n][[Position[DecomposeSnProduct[{\[Lambda],antiS}],1][[1,1]]]];
Return[result];
]

(* This funtion generates all terms up to some order allowed by gauge symmetry *)
Options[GenerateListOfCouplings]={Verbose->True,HCTerms->False,CalculateSnSymmetries->True,CalculateInvariants->False,DiscreteSym->{},SymExcludedOps->False,MaxOrder->4};
GenerateListOfCouplings[model_,OptionsPattern[]]:=Module[{reps\[UnderBracket]gaugeIn,reps\[UnderBracket]lorentzIn,reps\[UnderBracket]RI,reps\[UnderBracket]copies,nameOfTheFields,reps\[UnderBracket]gauge,reps\[UnderBracket]discreteCharges,order,reps,reps\[UnderBracket]lorentz,nB\[UnderBracket]nF,bosons,fermions,aux,aux2,resultRaw,resultRaw2,distinguishReps,gReps,lorentzRep,isFermionQ,needToConsiderGrassmannNature,fermionsPos,nFlavs,presentData,index,operador,orderN,selfConj,repeatedFields,posRepeatedFields,symInfo,divsH,divsV,toPrint,res,auxOther,survivingInvariants,result,outputData,repeatedFieldsOutput,symInfoOutput,validInvsPos,nameHeadsToUse},

{nameOfTheFields,reps\[UnderBracket]gaugeIn,reps\[UnderBracket]lorentzIn,reps\[UnderBracket]RI,reps\[UnderBracket]copies}=Transpose[fields[model]];

(* Just converts the simplified input into Dynkin coefficients *)
reps\[UnderBracket]gauge=SimpleRepInputConversion[gaugeGroup[model],#]&/@reps\[UnderBracket]gaugeIn;

reps\[UnderBracket]discreteCharges=If[OptionValue[DiscreteSym]==={},ConstantArray[1,Length[reps\[UnderBracket]gaugeIn]],OptionValue[DiscreteSym]];
order=OptionValue[MaxOrder];

nB\[UnderBracket]nF=DeleteCases[Flatten[Table[If[iB+iFPairs 2 3/2<=order,{iB,2iFPairs},Null],{iB,0,order},{iFPairs,0,Floor[order /(3/2)/2]}],1],x_/;x==Null||x=={0,0}];
reps\[UnderBracket]lorentz=SimpleLorentzInputConversion/@reps\[UnderBracket]lorentzIn;

(* PART 1 *)
reps=MapThread[List,{Range[Length[reps\[UnderBracket]gauge]],reps\[UnderBracket]gauge,reps\[UnderBracket]lorentz,reps\[UnderBracket]discreteCharges,reps\[UnderBracket]RI,reps\[UnderBracket]copies}];
bosons=Cases[reps,x_/;Mod[Total[x[[3]],2],2]==0];
fermions=Cases[reps,x_/;Mod[Total[x[[3]],2],2]==1];

aux={Sort[DeleteDuplicates[Sort/@Tuples[bosons,{#[[1]]}]]],Sort[DeleteDuplicates[Sort/@Tuples[fermions,{#[[2]]}]]]}&/@nB\[UnderBracket]nF;
aux=Flatten[Map[Flatten[#,1]&,Tuples/@aux,{2}],1];
aux2=Flatten[Tuples/@Map[If[#[[5]]==="R",{#/."R"->0},{#/."C"->0,ConjugateRepSpecial[gaugeGroup[model],#/."C"->1]}]&,aux,{2}],1];
aux2=DeleteDuplicates[Sort/@aux2];
resultRaw=Cases[aux2,x_/;ContainsSingletQ[gaugeGroup[model],x]];

(* Sort results by operator dimension *)
aux=Count[#[[All,3]],x_/;Mod[Total[x,2],2]==0]+3/2Count[#[[All,3]],x_/;Mod[Total[x,2],2]==1]&/@resultRaw;
resultRaw=Sort[MapThread[List,{aux,resultRaw}]][[All,2]];

(* IMPORTANT *)
(* IMPORTANT *)
(* At this point, resultRaw is a list of the form {term1,term2,...} with termI={fieldA,fieldB,...}.Finally,each field follows the format {# of the field,gauge rep (maybe already conjugated),Lorentz rep (maybe already conjugated),discreteSym, is it conjugated?0=no,1=yes, # copies/flavours of the field} *)
(* IMPORTANT *)
(* IMPORTANT *)

(* PART 2 *)
(* Cut down Hermitian conjugated terms, if the user so wishes *)

If[!OptionValue[HCTerms],
resultRaw=DeleteDuplicates[resultRaw,Sort[#1[[All,{1,5}]]]==Sort[#2[[All,{1,5}]]]||Sort[#1[[All,{1,5}]]]==Sort[({#[[1]],If[reps\[UnderBracket]RI[[#[[1]]]]=="R",#[[2]],1-#[[2]]]}&)/@#2[[All,{1,5}]]]&]];
(* The "If[reps\[UnderBracket]RI[[#[[1]]]]\[Equal]"R",#[[2]],1-#[[2]]]" piece ensures that the code takes into account that the conjugated of real fields are themselves. *)


(* Now we would like to add more information to resultRaw. In particular, each entry of result, result[[i]], will be of the form  {resultRaw[[i]],<Sn information>, <invariants>}. The last two entries are only calculated if the user so wishes; otherwise their value is {} *)
result={#,{},{}}&/@resultRaw;



Do[
res=resultRaw[[resI]];

(* PART 3 *)
(* Calculate the invariants (comes before permutation symmetry) *)
If[OptionValue[CalculateInvariants],
survivingInvariants=LorentzInvariants[gaugeGroup[model],reps\[UnderBracket]gauge[[res[[All,1]]]],reps\[UnderBracket]lorentzIn[[res[[All,1]]]],(res[[All,5]]/.{0->False,1->True})];
(* TODO: These are not really the surviving invariants! All of them are being kept. Remove dead invariants. *)

nameHeadsToUse=Table[nameOfTheFields[[res[[i,1]]]]<>If[res[[i,5]]==0,"","C"],{i,Length[res]}];
survivingInvariants[[2,All,All,0]]=Table[ConstantArray[nameHeadsToUse[[elI]],Length[survivingInvariants[[2,elI]]]],{elI,Length[survivingInvariants[[2]]]}];

result[[resI,3]]=survivingInvariants;
];

(* PART 4 *)
(* Look at the permutation symmetry of the invariants *)
If[OptionValue[CalculateSnSymmetries],
distinguishReps=res[[All,1]](1-2res[[All,5]]);
(* gReps=If[#[[5]]\[Equal]0,#[[2]],ConjugateIrrep[gaugeGroup,#[[2]]]]&/@res; *)
gReps=#[[2]]&/@res;
(* lorentzRep=If[#[[5]]\[Equal]0,#[[3]],Reverse[#[[3]]]]&/@res; *)
lorentzRep=#[[3]]&/@res;
reps=Flatten[#,1]&/@MapThread[List,{gReps,lorentzRep}];

If[OptionValue[CalculateInvariants],
aux=Susyno\[UnderBracket]Invariants\[UnderBracket]Symmetries;
,
aux=PermutationSymmetryOfInvariants[Join[gaugeGroup[model],{SU2,SU2}],reps,DistinguishFields->distinguishReps];
];

(* Correct Grassmann nature of fermions *)
isFermionQ=Mod[Total[#,2],2]==1&/@lorentzRep;
needToConsiderGrassmannNature=isFermionQ[[#[[1]]]]&&Length[#]>1&/@aux[[1]];
fermionsPos=Flatten[Position[needToConsiderGrassmannNature,True]];
aux[[2,All,1,fermionsPos]]=Map[SnRepTimesTotallyAntisymmetric,aux[[2,All,1,fermionsPos]],{2}];

nFlavs=res[[All,6]];
nFlavs=nFlavs[[#]]&/@aux[[1,All,1]];
aux[[2]]=Table[{aux[[2,i,1]],Times@@MapThread[HookContentFormula,{aux[[2,i,1]],nFlavs}],aux[[2,i,2]]},{i,Length[aux[[2]]]}];

(* Delete those cases which cannot be realized with the given number of flavors *)
aux[[2]]=DeleteCases[aux[[2]],x_/;x[[2]]===0];

If[OptionValue[CalculateInvariants],
aux2=Table[{aux[[2,i,3]]Times@@(SnIrrepDim/@aux[[2,i,1]]),aux[[2,i,2]],aux[[2,i,3]]},{i,Length[aux[[2]]]}];
aux2=Range@@@Transpose[{Accumulate[aux2[[All,1]]]-aux2[[All,1]]+1,Accumulate[aux2[[All,1]]]}];
validInvsPos=Flatten[aux2[[Flatten[Position[aux[[2]],x_/;x[[2]]=!=0,{1},Heads->False]]]]];
result[[resI,3]]={survivingInvariants[[1,validInvsPos]],survivingInvariants[[2]]};
];

result[[resI,2]]=aux;
];

,{resI,Length[resultRaw]}];

If[!OptionValue[SymExcludedOps]&&(OptionValue[CalculateSnSymmetries]||OptionValue[CalculateInvariants]),
result=DeleteCases[result,x_/;Length[x[[2]]]==2&&x[[2,2]]==={}];
];

(* PART 5 *)
(* Make arrangements to produce a final list with all the data *)
outputData=ConstantArray[Null,{Length[result],8}];
Do[
aux=nameOfTheFields[[result[[i,1,All,1]]]];
aux2={"R","C"}[[#]]&/@(1+result[[i,1,All,5]]);
aux=MapThread[(#1<>"["<>#2<>"]")&,{aux,aux2}];

result[[i]]={aux,result[[i,1]],result[[i,2]],result[[i,3]]};
,{i,Length[result]}];

presentData=Reap[Do[
index=i;
operador=Row[result[[i,1]],"  "];
orderN=Count[result[[i,2,All,3]],x_/;Mod[Total[x,2],2]==0]+3/2Count[result[[i,2,All,3]],x_/;Mod[Total[x,2],2]==1];
selfConj=Sort[result[[i,2,All,{1,5}]]]==Sort[{#[[1]],If[reps\[UnderBracket]RI[[#[[1]]]]=="R",#[[2]],1-#[[2]]]}&/@result[[i,2,All,{1,5}]]];


If[OptionValue[CalculateSnSymmetries],
repeatedFields=result[[i,1]][[DeleteCases[result[[i,3,1]],x_/;Length[x]==1][[All,1]]]]/.{}->Style["None",Lighter[Gray,0.8]];
posRepeatedFields=Flatten[Position[result[[i,3,1]],x_/;Length[x]>1,{1}]];

symInfo={#[[1,posRepeatedFields]],#[[2]],#[[3]]}&/@result[[i,3,2]];
symInfo=Which[symInfo==={},{Style["WARNING:",Darker[Red]],Style["Operator cannot be built with the given number of field flavours",Gray]},posRepeatedFields=={},symInfo[[All,{2,3}]],
Length[posRepeatedFields]==1,{SnRepNameTemp[#[[1,1]]],#[[2]],#[[3]]}&/@symInfo,
Length[posRepeatedFields]>1,{SnRepNameTemp/@#[[1]],#[[2]],#[[3]]}&/@symInfo
];
symInfo=If[result[[i,3,2]]=!={},Row[symInfo,Style[" | ",Gray]],Row[symInfo,"   "]];

repeatedFields=result[[i,1]][[result[[i,3,1,posRepeatedFields,1]]]];
repeatedFields=Which[Length[repeatedFields]==0,Style["-",Lighter[Gray,0.8]],Length[repeatedFields]==1,repeatedFields[[1]],True,repeatedFields];

(*Sow[{index,operador,order,selfConj,repeatedFields,symInfo}];*)
Sow[{Style[index,FontFamily->"Consolas"],Style[operador,FontFamily->"Consolas"],Style[orderN,FontFamily->"Consolas"],Style[selfConj,FontFamily->"Consolas"],Style[repeatedFields,FontFamily->"Consolas"],Style[symInfo,FontFamily->"Consolas"]}];


repeatedFieldsOutput=(#[[1]](-1)^#[[2]]&/@result[[i,2,All,{1,5}]])[[DeleteCases[result[[i,3,1]],x_/;Length[x]==1][[All,1]]]];
symInfoOutput={#[[1,posRepeatedFields]],#[[2]],#[[3]]}&/@result[[i,3,2]];
outputData[[i,{5,6}]]={repeatedFieldsOutput,symInfoOutput};
,
Sow[{Style[index,FontFamily->"Consolas"],Style[operador,FontFamily->"Consolas"],Style[orderN,FontFamily->"Consolas"],Style[selfConj,FontFamily->"Consolas"]}];
];


If[OptionValue[CalculateInvariants],
outputData[[i,7]]=result[[i,4]];
];

outputData[[i,2]]=#[[1]](-1)^#[[2]]&/@result[[i,2,All,{1,5}]];
outputData[[i,{1,3,4}]]={index,orderN,selfConj};

,{i,Length[result]}]][[2,1]];

outputData[[All,8]]=presentData;

divsH=Join[{1->{Black,Thick},2->Black,-1->{Black,Thick}},Table[i->Lighter[Gray,0.8],{i,3,Length[presentData]+1}]];
;

toPrint=If[OptionValue[CalculateSnSymmetries],divsV={1->{Black,Thick},2->Lighter[Gray,0.8],3->Lighter[Gray,0.8],4->Lighter[Gray,0.8],5->Lighter[Gray,0.8],6->Lighter[Gray,0.8],7->{Black,Thick}};Grid[Prepend[presentData,Style[#,{Bold,Darker[Red],FontFamily->"Consolas"}]&/@{"#","Operator","Dim.",Column[{"Self","conj.?"},Center],Column[{"Repeated","fields"},Center],Column[{"Symmetry and","number of parameters"},Center]}],(* Frame\[Rule]All,*) Dividers->{divsV,divsH},Spacings->{1,1},Background->{None,{None,{Lighter[Gray,0.95],None}}}],divsV={1->{Black,Thick},2->Lighter[Gray,0.8],3->Lighter[Gray,0.8],4->Lighter[Gray,0.8],5->{Black,Thick}};Grid[Prepend[presentData,Style[#,{Bold,Darker[Red],FontFamily->"Consolas"}]&/@{"#","Operator","Dimension","Self conj.?"}],(* Frame\[Rule]All,*) Dividers->{divsV,divsH},Spacings->{1,1},Background->{None,{None,{Lighter[Gray,0.95],None}}}]];

Sym2Int\[UnderBracket]GenerateListOfCouplings\[UnderBracket]Table=toPrint;
If[OptionValue[Verbose],Print[toPrint]];


Return[outputData];
]

SellectLines[sellectedLines_]:=Module[{aux},
aux=Sym2Int\[UnderBracket]GenerateListOfCouplings\[UnderBracket]Table;
aux[[1]]=aux[[1,Join[{1},sellectedLines+1]]];
aux[[2,2,2]]=aux[[2,2,2,1;;(Length[sellectedLines]+2)]];
Print[aux];
]

(* Code to check the conservation of a global U1: CheckConservationOfAGlobalU1 and the auxiliar function ContractAt *)
(* Code to check the conservation of a global U1: CheckConservationOfAGlobalU1 and the auxiliar function ContractAt *)
(* Code to check the conservation of a global U1: CheckConservationOfAGlobalU1 and the auxiliar function ContractAt *)


(* contracts the i-th index of tensor with matrix  *)
ContractAt[tensor_,matrix_,i_]:=Module[{indices,result,n},
n=Length[Dimensions[tensor]];
indices=Range[n];
indices[[{i,n}]]={n,i};
result=Transpose[Transpose[tensor,indices].matrix,indices];
Return[result];
]

(* The output eqs are equations which should equal 0. The position of each equation follows the results of GenerateListOfCouplings *)
CheckConservationOfAGlobalU1[result_,nameOfTheFields_]:=Module[{eqs,symMats,aux,tensors},
eqs={};
Do[
tensors=result[[elI,7,1]];

If[Length[tensors]>0,
symMats=Table[Sign[result[[elI,2,i]]]DiagonalMatrix[Array[nameOfTheFields[[Abs[result[[elI,2,i]]]]],Dimensions[tensors][[i+1]]]],{i,Length[result[[elI,2]]]}];
aux=Table[Sum[ContractAt[tensor,symMats[[j]],j],{j,Length[result[[elI,2]]]}],{tensor,tensors}];
,aux={}];
AppendTo[eqs,aux];
,{elI,Length[result]}];

Return[eqs];
]
