(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* Do not forget: we have Susyno`Models`NFlavours, Susyno`Models`DiscreteSym *)
BeginPackage["Susyno`IO`",{"Susyno`LieGroups`","Susyno`ModelBuilding`"}]
{CheckModel};

Begin["`Private`"];

CheckModel[model_]:=Module[{cm,listRepsWithY,fNames,discreteCharges,numberOfFlavours,n,cmSize,check,cmOk,finalOk, representationsOk,aux,nU1s,auxCounter,hypercharges,listReps},

If[!(ValueQ[group[model]]&&ValueQ[reps[model]]&&ValueQ[fieldNames[model]]&&ValueQ[nFlavs[model]]&&ValueQ[discreteSym[model]]),
Print["Invalid model: something was not defined (group, reps, fieldNames, nFlavs, and/or discreteSym)."];
Return[False];
];

{cmOk,cm,listRepsWithY,fNames,numberOfFlavours,discreteCharges}={True,group[model],reps[model],fieldNames[model],nFlavs[model],discreteSym[model]};
finalOk=True;

(* --------------------------------------------- cm --------------------------------------------- *)
n=Length[cm];

Do[
check=False;
cmSize=Length[cm[[i]]];

If[cmSize>0||cm[[i]]==={},
If[cm[[i]]===U1||cm[[i]]=== CartanMatrix["A",cmSize]||cm[[i]]=== CartanMatrix["B",cmSize]||cm[[i]]=== CartanMatrix["C",cmSize]||cm[[i]]=== CartanMatrix["D",cmSize],check=True];

If[cmSize==2&&cm[[i]]=== CartanMatrix["G",cmSize],check=True];
If[cmSize==4&&cm[[i]]=== CartanMatrix["F",cmSize],check=True];
If[6<=cmSize<=8&&cm[[i]]=== CartanMatrix["E",cmSize],check=True];
];
If[!check,
Print["The gauge factor group ",Style[cm[[i]],Bold]," is not valid. Try something like U1, SU2, SU3, SO10, E6 ..."];
cmOk=False;
finalOk=False;
];
,{i,n}];

aux=Flatten[Position[cm,{}]];
nU1s=Length[aux];
If[aux!=Range[nU1s],
Print["The U1 factor groups must be the first ones."];cmOk=False;
];

If[!cmOk,
Print["*** There might be more problems with this input. Susyno will check it once the above problems are solved. ***"];
Return[False];];

(* -------------------------------------- size of each field and cm --------------------------------------- *)

If[Length[DeleteDuplicates[Length/@Append[reps[model],group[model]]]]>1,
Print["Make sure that each field contains a representation of each of the gauge factor groups."];
Return[False];];


(* --------------------------------------------- listRepsWithY --------------------------------------------- *)

n=Length[listRepsWithY];
Do[
hypercharges=listRepsWithY[[i,1;;nU1s]];
listReps=listRepsWithY[[i,nU1s+1;;-1]];

If[!(And@@NumericQ/@hypercharges),
Print["Some of the hypercharges of ",Style["field #",Bold],Style[i,Bold], " are not correct. Make sure that they are all numbers."];
finalOk=False;
];

Do[
If[Length[listReps[[j]]]!=Length[cm[[nU1s+j]]]||!(And@@IntegerQ/@ listReps[[j]]&&And@@NonNegative/@ listReps[[j]]),
Print["\"",listReps[[j]] ,"\" of ",Style["field #",Bold],Style[i,Bold], " is not a valid representation of simple group #",j,"."];finalOk=False;]
,{j,Length[listReps]}];

,{i,n}];

(* --------------------------------------------- discreteCharges --------------------------------------------- *)

If[Length[DeleteDuplicates[Length[#]&/@discreteCharges]]>1&&!(And@@(NumericQ/@discreteCharges)),Print["Different fields have a different number of ",Style["discrete symmetries",Bold]];
finalOk=False;];

If[!And@@(Abs[#]===1&/@Flatten[discreteCharges]),
Print["All ",Style["discrete charges",Bold]," should have modulus equal to 1."];
finalOk=False;
];

(* ------------------------------ Size of reps, fieldNames, nFlavs, discreteSym ------------------------------ *)

If[!(Length[reps[model]]==Length[fieldNames[model]]==Length[nFlavs[model]]==Length[discreteSym[model]]),
Print["Make sure that ",Style["reps["<>ToString[model]<>"]",Bold],", " ,Style["fieldNames["<>ToString[model]<>"]",Bold],", ",Style["nFlavs["<>ToString[model]<>"]",Bold],", and ",Style["discreteSym["<>ToString[model]<>"]",Bold]," all have the same size."];
finalOk=False;
];

Return[finalOk];
];

End[]
EndPackage[]
