(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"ReduceRepProduct\"\>":>
       Documentation`HelpLookup["paclet:Susyno/ref/ReduceRepProduct"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/DimR\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/DimR"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/DimR.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", "Susyno/ref/DimR", 
             ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["DimR", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DimR", "[", 
       RowBox[{"group", ",", "rep"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]Computes the dimension of the representation ",
     Cell[BoxData["rep"], "InlineFormula"],
     " of ",
     Cell[BoxData["group"], "InlineFormula"]
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DimR", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"group1", ",", "group2", ",", "..."}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"rep_group1", ",", "rep_group2", ",", "..."}], "}"}]}], 
       "]"}]], "InlineFormula"],
     " \[LineSeparator]Computes the dimensions of the representations ",
     Cell[BoxData["rep_group1"], "InlineFormula"],
     " of ",
     Cell[BoxData["group1"], "InlineFormula"],
     ",  ",
     Cell[BoxData["rep_group2"], "InlineFormula"],
     " of ",
     Cell[BoxData["group2"], "InlineFormula"],
     ", ..."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->106657207],

Cell[TextData[{
 "The ",
 Cell[BoxData["group"], "InlineFormula"],
 "s should be ",
 ButtonBox["Cartan matrices",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 " of the intended groups."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Each representation ",
 Cell[BoxData["rep"], "InlineFormula"],
 " should be a list of non-negative integers (Dynkin coefficients)."
}], "Notes",
 CellID->41030773]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->277037584],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->117384705],

Cell["\<\
Dimension of the fundamental representation of SU(3) (which is {1,0}):\
\>", "ExampleText",
 CellID->513681956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DimR", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196926373],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->265264917]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->319977768],

Cell["\<\
Dimensions of {1,1} of SU(3), {2} of SU(2) and {1,1,1,7} of F4:\
\>", "ExampleText",
 CellID->45311829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DimR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"SU3", ",", "SU2", ",", "F4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "7"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1978605],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", "3", ",", "44493176832"}], "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188023740]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->137345166],

Cell["\<\
Calculate the dimensions of a list of representations of SU(3):\
\>", "ExampleText",
 CellID->788],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Print", "[", "\"\<Some representations of SU(3):\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"listOfSU3Reps", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", ",", "j"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "0", ",", "2"}], "}"}]}], "]"}], ",", "1"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<Dimensions:\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DimR", "[", 
    RowBox[{"SU3", ",", "#"}], "]"}], "&"}], " ", "/@", " ", 
  "listOfSU3Reps"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->189750059],

Cell[BoxData["\<\"Some representations of SU(3):\"\>"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->17160686],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{457, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->465491409],

Cell[BoxData["\<\"Dimensions:\"\>"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->118004457],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3", ",", "6", ",", "3", ",", "8", ",", "15", ",", "6", ",", "15",
    ",", "27"}], "}"}]], "Output",
 ImageSize->{190, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->896634029]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Any list of non-negative integers will define a representation of a group \
provided that the size of the list is equal to the group's rank. In practice \
the group's rank is equal to the size of the Cartan matrix of the group:\
\>", "ExampleText",
 CellID->328620293],

Cell[CellGroupData[{

Cell["\<\
Print[\"Rank of SU(5):\"];
Length[SU5]\
\>", "Input",
 CellLabel->"In[1]:=",
 CellID->174115121],

Cell[BoxData["\<\"Rank of SU(5):\"\>"], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->333135850],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->279975601]
}, Open  ]],

Cell["\<\
In this last example, since rank=4, {1,2,3,4} and {10,0,0,1} are examples of \
representations of SU(5):\
\>", "ExampleText",
 CellID->103860211],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DimR", "[", 
  RowBox[{"SU5", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DimR", "[", 
  RowBox[{"SU5", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "0", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->842154],

Cell[BoxData["198450"], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->409330106],

Cell[BoxData["4290"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->530684626]
}, Open  ]],

Cell["\<\
On the other hand {2} and {0,0,1,2,3} are not SU(5) representations so the \
following code is meaningless:\
\>", "ExampleText",
 CellID->3898682],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DimR", "[", 
  RowBox[{"SU5", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DimR", "[", 
  RowBox[{"SU5", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "2", ",", "3"}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->237063641],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tdlen\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Objects of unequal length in \\\\\\\
\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(\\(\\({2}\\)\\) + \\(\
\\({1, 1, 1, 1}\\)\\)\\), \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" cannot be \
combined.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Thread/tdlen\\\", ButtonNote -> \
\\\"Thread::tdlen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->50169809],

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "::", "\<\"nmtx\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The first two levels of the \
one-dimensional list \\\\\\\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\
\\!\\({\\(\\({2}\\)\\) + \\(\\({1, 1, 1, 1}\\)\\)}\\), \\\"MT\\\"]\\)\
\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" cannot be transposed.\\\\\\\"\\\", \
\\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Transpose/nmtx\\\", ButtonNote -> \
\\\"Transpose::nmtx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->277741204],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tdlen\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Objects of unequal length in \\\\\\\
\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(\\(\\({2}\\)\\) + \\(\
\\({1, 1, 1, 1}\\)\\)\\), \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" cannot be \
combined.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Thread/tdlen\\\", ButtonNote -> \
\\\"Thread::tdlen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->343927668],

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "::", "\<\"nmtx\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The first two levels of the \
one-dimensional list \\\\\\\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\
\\!\\({\\(\\({2}\\)\\) + \\(\\({1, 1, 1, 1}\\)\\)}\\), \\\"MT\\\"]\\)\
\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" cannot be transposed.\\\\\\\"\\\", \
\\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Transpose/nmtx\\\", ButtonNote -> \
\\\"Transpose::nmtx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->448644427],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tdlen\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Objects of unequal length in \\\\\\\
\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(\\(\\({2}\\)\\) + \\(\
\\({1, 1, 1, 1}\\)\\)\\), \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" cannot be \
combined.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Thread/tdlen\\\", ButtonNote -> \
\\\"Thread::tdlen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->374813420],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Further output of \\\\\\\"\\\", \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(Thread :: \\\"tdlen\\\"\\), \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" will be suppressed \
during this calculation.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->334500110],

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "::", "\<\"nmtx\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The first two levels of the \
one-dimensional list \\\\\\\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\
\\!\\({\\(\\({2}\\)\\) + \\(\\({1, 1, 1, 1}\\)\\)}\\), \\\"MT\\\"]\\)\
\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" cannot be transposed.\\\\\\\"\\\", \
\\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Transpose/nmtx\\\", ButtonNote -> \
\\\"Transpose::nmtx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->68899028],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Further output of \\\\\\\"\\\", \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(Transpose :: \\\"nmtx\\\"\\), \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" will be suppressed \
during this calculation.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->135005804],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->395105808],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tdlen\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Objects of unequal length in \\\\\\\
\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(\\(\\({0, 0, 1, 2, 3}\
\\)\\) + \\(\\({1, 1, 1, 1}\\)\\)\\), \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" cannot be \
combined.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Thread/tdlen\\\", ButtonNote -> \
\\\"Thread::tdlen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->10180411],

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "::", "\<\"nmtx\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The first two levels of the \
one-dimensional list \\\\\\\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\
\\!\\({\\(\\({1, 1, 1, 1}\\)\\) + \\(\\({0, 0, 1, 2, 3}\\)\\)}\\), \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" cannot be \
transposed.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Transpose/nmtx\\\", ButtonNote -> \
\\\"Transpose::nmtx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->179636364],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tdlen\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Objects of unequal length in \\\\\\\
\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(\\(\\({0, 0, 1, 2, 3}\
\\)\\) + \\(\\({1, 1, 1, 1}\\)\\)\\), \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" cannot be \
combined.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Thread/tdlen\\\", ButtonNote -> \
\\\"Thread::tdlen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->435358098],

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "::", "\<\"nmtx\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The first two levels of the \
one-dimensional list \\\\\\\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\
\\!\\({\\(\\({1, 1, 1, 1}\\)\\) + \\(\\({0, 0, 1, 2, 3}\\)\\)}\\), \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" cannot be \
transposed.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Transpose/nmtx\\\", ButtonNote -> \
\\\"Transpose::nmtx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->328508462],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tdlen\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Objects of unequal length in \\\\\\\
\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(\\(\\({0, 0, 1, 2, 3}\
\\)\\) + \\(\\({1, 1, 1, 1}\\)\\)\\), \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" cannot be \
combined.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Thread/tdlen\\\", ButtonNote -> \
\\\"Thread::tdlen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->90264973],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Further output of \\\\\\\"\\\", \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(Thread :: \\\"tdlen\\\"\\), \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" will be suppressed \
during this calculation.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->258132930],

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "::", "\<\"nmtx\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The first two levels of the \
one-dimensional list \\\\\\\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\
\\!\\({\\(\\({1, 1, 1, 1}\\)\\) + \\(\\({0, 0, 1, 2, 3}\\)\\)}\\), \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" cannot be \
transposed.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Transpose/nmtx\\\", ButtonNote -> \
\\\"Transpose::nmtx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->312092742],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Further output of \\\\\\\"\\\", \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(Transpose :: \\\"nmtx\\\"\\), \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" will be suppressed \
during this calculation.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->257357445],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->295066618]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ReduceRepProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/ReduceRepProduct"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 729},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DimR - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2014, 12, 18, 10, 47, 17.4771059}", "context" -> "Susyno`", 
    "keywords" -> {"Representation", "Dimension"}, "index" -> True, "label" -> 
    "Susyno Paclet Symbol", "language" -> "en", "paclet" -> "Susyno", 
    "status" -> "None", "summary" -> 
    "DimR[group, rep] Computes the dimension of the representation rep of \
groupDimR[{group1, group2, ...}, {rep_group1, rep_group2, ...}] Computes the \
dimensions of the representations rep_group1 of group1, rep_group2 of group2, \
...", "synonyms" -> {}, "title" -> "DimR", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/DimR"}, "LinkTrails" -> "", "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "9.0 for Microsoft Windows (64-bit) (January 25, 2013)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5697, 176, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->277037584]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26524, 774}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[597, 21, 76, 1, 70, "SymbolColorBar"],
Cell[676, 24, 178, 5, 70, "LinkTrail"],
Cell[857, 31, 2524, 59, 70, "AnchorBarGrid",
 CellID->1],
Cell[3384, 92, 47, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[CellGroupData[{
Cell[3456, 97, 1155, 34, 70, "Usage",
 CellID->982511436],
Cell[CellGroupData[{
Cell[4636, 135, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->106657207],
Cell[5219, 154, 245, 9, 70, "Notes",
 CellID->1067943069],
Cell[5467, 165, 181, 5, 70, "Notes",
 CellID->41030773]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5697, 176, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->277037584],
Cell[CellGroupData[{
Cell[6183, 193, 148, 5, 70, "ExampleSection",
 CellID->117384705],
Cell[6334, 200, 121, 3, 70, "ExampleText",
 CellID->513681956],
Cell[CellGroupData[{
Cell[6480, 207, 174, 6, 70, "Input",
 CellID->196926373],
Cell[6657, 215, 158, 5, 36, "Output",
 CellID->265264917]
}, Open  ]],
Cell[CellGroupData[{
Cell[6852, 225, 125, 3, 70, "ExampleDelimiter",
 CellID->319977768],
Cell[6980, 230, 113, 3, 70, "ExampleText",
 CellID->45311829],
Cell[CellGroupData[{
Cell[7118, 237, 399, 14, 70, "Input",
 CellID->1978605],
Cell[7520, 253, 224, 7, 36, "Output",
 CellID->188023740]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7793, 266, 125, 3, 70, "ExampleDelimiter",
 CellID->137345166],
Cell[7921, 271, 108, 3, 70, "ExampleText",
 CellID->788],
Cell[CellGroupData[{
Cell[8054, 278, 752, 22, 70, "Input",
 CellID->189750059],
Cell[8809, 302, 127, 2, 70, "Print",
 CellID->17160686],
Cell[8939, 306, 715, 25, 36, "Output",
 CellID->465491409],
Cell[9657, 333, 109, 2, 70, "Print",
 CellID->118004457],
Cell[9769, 337, 284, 9, 36, "Output",
 CellID->896634029]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10114, 353, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[10348, 362, 278, 5, 70, "ExampleText",
 CellID->328620293],
Cell[CellGroupData[{
Cell[10651, 371, 106, 5, 70, "Input",
 CellID->174115121],
Cell[10760, 378, 112, 2, 70, "Print",
 CellID->333135850],
Cell[10875, 382, 158, 5, 36, "Output",
 CellID->279975601]
}, Open  ]],
Cell[11048, 390, 155, 4, 70, "ExampleText",
 CellID->103860211],
Cell[CellGroupData[{
Cell[11228, 398, 349, 11, 70, "Input",
 CellID->842154],
Cell[11580, 411, 163, 5, 36, "Output",
 CellID->409330106],
Cell[11746, 418, 161, 5, 36, "Output",
 CellID->530684626]
}, Open  ]],
Cell[11922, 426, 156, 4, 70, "ExampleText",
 CellID->3898682],
Cell[CellGroupData[{
Cell[12103, 434, 316, 10, 70, "Input",
 CellID->237063641],
Cell[12422, 446, 645, 12, 70, "Message",
 CellID->50169809],
Cell[13070, 460, 676, 12, 70, "Message",
 CellID->277741204],
Cell[13749, 474, 646, 12, 70, "Message",
 CellID->343927668],
Cell[14398, 488, 676, 12, 70, "Message",
 CellID->448644427],
Cell[15077, 502, 646, 12, 70, "Message",
 CellID->374813420],
Cell[15726, 516, 638, 11, 70, "Message",
 CellID->334500110],
Cell[16367, 529, 675, 12, 70, "Message",
 CellID->68899028],
Cell[17045, 543, 640, 11, 70, "Message",
 CellID->135005804],
Cell[17688, 556, 223, 7, 36, "Output",
 CellID->395105808],
Cell[17914, 565, 657, 12, 70, "Message",
 CellID->10180411],
Cell[18574, 579, 688, 12, 70, "Message",
 CellID->179636364],
Cell[19265, 593, 658, 12, 70, "Message",
 CellID->435358098],
Cell[19926, 607, 688, 12, 70, "Message",
 CellID->328508462],
Cell[20617, 621, 657, 12, 70, "Message",
 CellID->90264973],
Cell[21277, 635, 638, 11, 70, "Message",
 CellID->258132930],
Cell[21918, 648, 688, 12, 70, "Message",
 CellID->312092742],
Cell[22609, 662, 640, 11, 70, "Message",
 CellID->257357445],
Cell[23252, 675, 223, 7, 36, "Output",
 CellID->295066618]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23536, 689, 417, 12, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[23956, 703, 223, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[24216, 714, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[24638, 728, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[24804, 734, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

