(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/Casimir\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/Casimir"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/Casimir.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", "Susyno/ref/Casimir",
              ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["Casimir", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Casimir", "[", 
       RowBox[{"group", ",", " ", "rep"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]Computes the quadratic Casimir of representation ",
     Cell[BoxData["rep"], "InlineFormula"],
     " of ",
     Cell[BoxData["group"], "InlineFormula"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->80678709],

Cell[TextData[{
 Cell[BoxData["group"], "InlineFormula"],
 " should be a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Each representation ",
 Cell[BoxData["rep"], "InlineFormula"],
 " should be a list of non-negative integers (Dynkin coefficients)."
}], "Notes",
 CellID->125196071]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->366704385],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->650712886],

Cell[TextData[{
 "The usual convention of having the fundamental of SU(n) with a Casimir ",
 Cell[BoxData[
  FractionBox[
   RowBox[{
    SuperscriptBox["n", "2"], "-", "1"}], 
   RowBox[{"2", "n"}]]], "InlineFormula"],
 " is respected by this method:"
}], "ExampleText",
 CellID->32979335],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Casimir of the fundamental of SU(2): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"SU2", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Casimir of the fundamental of SU(3): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"SU3", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Casimir of the fundamental of SU(4): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"SU4", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Casimir of the fundamental of SU(5): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"SU5", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "]"}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->280814282],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Casimir of the fundamental of SU(2): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["3", "4"]}],
  SequenceForm["Casimir of the fundamental of SU(2): ", 
   Rational[3, 4]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->388455122],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Casimir of the fundamental of SU(3): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["4", "3"]}],
  SequenceForm["Casimir of the fundamental of SU(3): ", 
   Rational[4, 3]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->77229672],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Casimir of the fundamental of SU(4): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["15", "8"]}],
  SequenceForm["Casimir of the fundamental of SU(4): ", 
   Rational[15, 8]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->198312426],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Casimir of the fundamental of SU(5): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["12", "5"]}],
  SequenceForm["Casimir of the fundamental of SU(5): ", 
   Rational[12, 5]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->313375776]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->254396624],

Cell["\<\
C(G), the Casimir of the adjoint representation, can be found using the \
Adjoint method:\
\>", "ExampleText",
 CellID->6164437],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<C(G) of SU(2): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"SU2", ",", 
      RowBox[{"Adjoint", "[", "SU2", "]"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<C(G) of SU(5): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"SU5", ",", 
      RowBox[{"Adjoint", "[", "SU5", "]"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<C(G) of SO(10): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"SO10", ",", 
      RowBox[{"Adjoint", "[", "SO10", "]"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<C(G) of E(6): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"E6", ",", 
      RowBox[{"Adjoint", "[", "E6", "]"}]}], "]"}]}], "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->194792086],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C(G) of SU(2): \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["C(G) of SU(2): ", 2],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->105455773],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C(G) of SU(5): \"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm["C(G) of SU(5): ", 5],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->364457345],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C(G) of SO(10): \"\>", "\[InvisibleSpace]", "8"}],
  SequenceForm["C(G) of SO(10): ", 8],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->28356634],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C(G) of E(6): \"\>", "\[InvisibleSpace]", "12"}],
  SequenceForm["C(G) of E(6): ", 12],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->887157113]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Adjoint",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/Adjoint"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["DynkinIndex",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/DynkinIndex"]], "InlineFormula"]
}], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 729},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Casimir - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2014, 12, 18, 10, 47, 10.9167275}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "Casimir[group, rep] Computes the quadratic Casimir of representation rep \
of group", "synonyms" -> {}, "title" -> "Casimir", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/Casimir"}, "LinkTrails" -> "", "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "9.0 for Microsoft Windows (64-bit) (January 25, 2013)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4808, 150, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->366704385]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13547, 446}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[600, 21, 76, 1, 70, "SymbolColorBar"],
Cell[679, 24, 178, 5, 70, "LinkTrail"],
Cell[860, 31, 2293, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[3156, 86, 50, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[CellGroupData[{
Cell[3231, 91, 524, 15, 70, "Usage",
 CellID->982511436],
Cell[CellGroupData[{
Cell[3780, 110, 579, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->80678709],
Cell[4362, 129, 212, 8, 70, "Notes",
 CellID->1067943069],
Cell[4577, 139, 182, 5, 70, "Notes",
 CellID->125196071]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4808, 150, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->366704385],
Cell[CellGroupData[{
Cell[5294, 167, 148, 5, 70, "ExampleSection",
 CellID->650712886],
Cell[5445, 174, 290, 9, 70, "ExampleText",
 CellID->32979335],
Cell[CellGroupData[{
Cell[5760, 187, 1111, 32, 70, "Input",
 CellID->280814282],
Cell[CellGroupData[{
Cell[6896, 223, 317, 9, 70, "Print",
 CellID->388455122],
Cell[7216, 234, 316, 9, 70, "Print",
 CellID->77229672],
Cell[7535, 245, 319, 9, 70, "Print",
 CellID->198312426],
Cell[7857, 256, 319, 9, 70, "Print",
 CellID->313375776]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8225, 271, 125, 3, 70, "ExampleDelimiter",
 CellID->254396624],
Cell[8353, 276, 138, 4, 70, "ExampleText",
 CellID->6164437],
Cell[CellGroupData[{
Cell[8516, 284, 961, 29, 70, "Input",
 CellID->194792086],
Cell[CellGroupData[{
Cell[9502, 317, 230, 6, 70, "Print",
 CellID->105455773],
Cell[9735, 325, 230, 6, 70, "Print",
 CellID->364457345],
Cell[9968, 333, 231, 6, 70, "Print",
 CellID->28356634],
Cell[10202, 341, 230, 6, 70, "Print",
 CellID->887157113]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10517, 356, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[10939, 370, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[11127, 378, 427, 12, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[11557, 392, 430, 14, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[12002, 409, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

