(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[Cell[BoxData[
     ActionMenuBox[
      FrameBox["\<\"URL \[RightGuillemet]\"\>",
       StripOnInput->False], {"\<\"Susyno/ref/IrrepInProduct\"\>":>
      None, "\<\"Copy Mathematica url\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell["Susyno/ref/IrrepInProduct"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; Null], 
      Delimiter, "\<\"Copy web url\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell[
             BoxData[
              MakeBoxes[
               Hyperlink[
               "http://reference.wolfram.com/mathematica/Susyno/ref/\
IrrepInProduct.html"], StandardForm]], "Input", TextClipboardType -> 
             "PlainText"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; 
       Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
        NotebookLocate[{
          URL[
           StringJoin[
           "http://reference.wolfram.com/mathematica/", 
            "Susyno/ref/IrrepInProduct", ".html"]], None}]}]},
      Appearance->None,
      MenuAppearance->Automatic]],
     LineSpacing->{1.4, 0}]], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["IrrepInProduct", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"IrrepInProduct", "[", 
       RowBox[{"group", ",", " ", 
        RowBox[{"{", 
         RowBox[{"rep1", ",", " ", "rep2", ",", " ", "rep3"}], "}"}]}], 
       "]"}]], "InlineFormula"],
     " \[LineSeparator]Computes generalized Clebsch-Gordon coefficients; it \
computes the combinations of ",
     Cell[BoxData["rep1"], "InlineFormula"],
     " x ",
     Cell[BoxData["rep2"], "InlineFormula"],
     " which transform as a ",
     Cell[BoxData["rep3"], "InlineFormula"],
     " of the gauge group."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->486636237],

Cell[TextData[{
 Cell[BoxData["group"], "InlineFormula"],
 " should be the ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 " of the intended group."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Each representation ",
 Cell[BoxData["rep"], "InlineFormula"],
 " should be a list of non-negative integers (Dynkin coefficients)."
}], "Notes",
 CellID->41030773],

Cell["\<\
There is no limit to the number of representations being multiplied, although \
the calculation becomes slower as their number increases.\
\>", "Notes",
 CellID->221237370],

Cell[TextData[{
 "The optional input ",
 Cell[BoxData[
  RowBox[{"Conjugations", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"conjugate", " ", "rep1"}], ",", " ", 
     RowBox[{"conjugate", " ", "rep2"}], ",", " ", 
     RowBox[{"conjugate", " ", "rep3"}]}], "}"}]}]], "InlineFormula"],
 "  can be passed to this function, where ",
 Cell[BoxData[
  RowBox[{"conjugate", " ", "repI"}]], "InlineFormula"],
 " can be either ",
 Cell[BoxData["True"], "InlineFormula"],
 " or ",
 Cell[BoxData["False"], "InlineFormula"],
 ". If ",
 Cell[BoxData["True"], "InlineFormula"],
 ", the conjugate representation of ",
 Cell[BoxData["repI"], "InlineFormula"],
 " will be considered instead of ",
 Cell[BoxData["repI"], "InlineFormula"],
 "."
}], "Notes",
 CellID->400920173],

Cell[TextData[{
 "There is also the possibility of ",
 Cell[BoxData["group"], "InlineFormula"],
 " being a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"group1", ",", "group2", ",", "..."}], "}"}]], "InlineFormula"],
 " and each ",
 Cell[BoxData["rep"], "InlineFormula"],
 " a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"rep_group1", ",", "rep_group2", ",", "..."}], "}"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->75953507],

Cell[TextData[{
 "The output of this method is a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"combination1", ",", "combination2", ",", "..."}], "}"}]], 
  "InlineFormula"],
 " where it is assumed that ",
 Cell[BoxData["a"], "InlineFormula"],
 " is a field transforming as ",
 Cell[BoxData["rep1"], "InlineFormula"],
 ",  ",
 Cell[BoxData["b"], "InlineFormula"],
 " as ",
 Cell[BoxData["rep2"], "InlineFormula"],
 ". Each of the ",
 Cell[BoxData["combinationI"], "InlineFormula"],
 " transforms as ",
 Cell[BoxData["rep3"], "InlineFormula"],
 ". The fields  ",
 Cell[BoxData["a"], "InlineFormula"],
 "  and  ",
 Cell[BoxData["b"], "InlineFormula"],
 " have group indices: ",
 Cell[BoxData[
  RowBox[{"a", "[", 
   RowBox[{"ind_group1", ",", " ", "ind_group2", ",", "..."}], "]"}]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"b", "[", 
   RowBox[{"ind_group1", ",", " ", "ind_group2", ",", "..."}], "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->10758554],

Cell[TextData[{
 "If  ",
 Cell[BoxData["rep1"], "InlineFormula"],
 " x ",
 Cell[BoxData["rep2"], "InlineFormula"],
 " does not contain any copy of ",
 Cell[BoxData["rep3"], "InlineFormula"],
 ",  ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 " is returned."
}], "Notes",
 CellID->335181877],

Cell["\<\
Clearly this method must assume a particular basis for each representation so \
the results are basis dependent.\
\>", "Notes",
 CellID->898809850],

Cell[TextData[{
 "This method is similar to ",
 Cell[BoxData[
  ButtonBox["Invariants",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/Invariants"]], "InlineFormula"],
 ": it gives generalized Clebsch-Gordon coefficients, as it works for any \
gauge group (not just SU(2))."
}], "Notes",
 CellID->329977022]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->625561808],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->329731734],

Cell["\<\
Two SU(2) doublets (={1}) contain a singlet (={0}) and a triplet (={2}). The \
explicit form of these combinations can be checked with this method:\
\>", "Notes",
 CellID->315923061],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "\"\<Gauge singlet in {1}x{1}:\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IrrepInProduct", "[", 
    RowBox[{"SU2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "0", "}"}]}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", 
  "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<\>\"", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<Gauge triplet in {1}x{1}:\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"IrrepInProduct", "[", 
     RowBox[{"SU2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "2", "}"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "//", "MatrixForm"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\< ... or (multiply by \!\(\*SuperscriptBox[\(3\), \(1/4\)]\)) ...\>\"",
    "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{"Normal", "[", 
    RowBox[{
     SuperscriptBox["3", 
      RowBox[{"1", "/", "4"}]], 
     RowBox[{
      RowBox[{"IrrepInProduct", "[", 
       RowBox[{"SU2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "1", "}"}], ",", 
          RowBox[{"{", "1", "}"}], ",", 
          RowBox[{"{", "2", "}"}]}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}], "//", 
  "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->275367989],

Cell[BoxData["\<\"Gauge singlet in {1}x{1}:\"\>"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->51510509],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        RowBox[{
         RowBox[{"a", "[", "2", "]"}], " ", 
         RowBox[{"b", "[", "1", "]"}]}], "-", 
        RowBox[{
         RowBox[{"a", "[", "1", "]"}], " ", 
         RowBox[{"b", "[", "2", "]"}]}]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
    SparseArray[
    Automatic, {1}, 0, {
     1, {{0, 1}, {{1}}}, {
      Susyno`LieGroups`a[2] Susyno`LieGroups`b[1] - Susyno`LieGroups`a[1] 
       Susyno`LieGroups`b[2]}}]]]]], "Output",
 ImageSize->{155, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->292519076],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->501595322],

Cell[BoxData["\<\"Gauge triplet in {1}x{1}:\"\>"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->75520894]
}, Open  ]],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", 
         RowBox[{"a", "[", "2", "]"}], " ", 
         RowBox[{"b", "[", "2", "]"}]}], 
        SuperscriptBox["3", 
         RowBox[{"1", "/", "4"}]]]},
      {
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"a", "[", "2", "]"}], " ", 
           RowBox[{"b", "[", "1", "]"}]}], 
          SuperscriptBox["3", 
           RowBox[{"1", "/", "4"}]]]}], "-", 
        FractionBox[
         RowBox[{
          RowBox[{"a", "[", "1", "]"}], " ", 
          RowBox[{"b", "[", "2", "]"}]}], 
         SuperscriptBox["3", 
          RowBox[{"1", "/", "4"}]]]}]},
      {
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", 
         RowBox[{"a", "[", "1", "]"}], " ", 
         RowBox[{"b", "[", "1", "]"}]}], 
        SuperscriptBox["3", 
         RowBox[{"1", "/", "4"}]]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
    SparseArray[
    Automatic, {3}, 0, {
     1, {{0, 3}, {{3}, {2}, {1}}}, {
      2^Rational[1, 2] 3^Rational[-1, 4] Susyno`LieGroups`a[1] 
       Susyno`LieGroups`b[1], -3^Rational[-1, 4] Susyno`LieGroups`a[2] 
        Susyno`LieGroups`b[1] - 3^Rational[-1, 4] Susyno`LieGroups`a[1] 
       Susyno`LieGroups`b[2], 2^Rational[1, 2] 3^Rational[-1, 4] 
       Susyno`LieGroups`a[2] Susyno`LieGroups`b[2]}}]]]]], "Output",
 ImageSize->{138, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->557594027],

Cell[BoxData["\<\" ... or (multiply by \\!\\(\\*SuperscriptBox[\\(3\\), \
\\(1/4\\)]\\)) ...\"\>"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->407396728],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        SqrtBox["2"], " ", 
        RowBox[{"a", "[", "2", "]"}], " ", 
        RowBox[{"b", "[", "2", "]"}]}]},
      {
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"a", "[", "2", "]"}]}], " ", 
         RowBox[{"b", "[", "1", "]"}]}], "-", 
        RowBox[{
         RowBox[{"a", "[", "1", "]"}], " ", 
         RowBox[{"b", "[", "2", "]"}]}]}]},
      {
       RowBox[{
        SqrtBox["2"], " ", 
        RowBox[{"a", "[", "1", "]"}], " ", 
        RowBox[{"b", "[", "1", "]"}]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{163, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->114383041]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[Cell[BoxData[
 ButtonBox["Invariants",
  BaseStyle->"Link",
  ButtonData->
   "paclet:Susyno/ref/Invariants"]], "InlineFormula"]], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 729},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IrrepInProduct - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2014, 12, 18, 10, 47, 25.4744409}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "IrrepInProduct[group, {rep1, rep2, rep3}] Computes generalized \
Clebsch-Gordon coefficients; it computes the combinations of rep1 x rep2 \
which transform as a rep3 of the gauge group.", "synonyms" -> {}, "title" -> 
    "IrrepInProduct", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/IrrepInProduct"}, "LinkTrails" -> "", "SearchTextTranslated" -> 
  ""},
CellContext->"Global`",
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "9.0 for Microsoft Windows (64-bit) (January 25, 2013)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7830, 262, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->625561808]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17814, 580}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[607, 21, 76, 1, 70, "SymbolColorBar"],
Cell[686, 24, 178, 5, 70, "LinkTrail"],
Cell[867, 31, 1867, 41, 70, "AnchorBarGrid",
 CellID->1],
Cell[2737, 74, 57, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[CellGroupData[{
Cell[2819, 79, 764, 22, 70, "Usage",
 CellID->982511436],
Cell[CellGroupData[{
Cell[3608, 105, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->486636237],
Cell[4191, 124, 236, 8, 70, "Notes",
 CellID->1067943069],
Cell[4430, 134, 181, 5, 70, "Notes",
 CellID->41030773],
Cell[4614, 141, 182, 4, 70, "Notes",
 CellID->221237370],
Cell[4799, 147, 767, 24, 70, "Notes",
 CellID->400920173],
Cell[5569, 173, 444, 16, 70, "Notes",
 CellID->75953507],
Cell[6016, 191, 979, 34, 70, "Notes",
 CellID->10758554],
Cell[6998, 227, 304, 12, 70, "Notes",
 CellID->335181877],
Cell[7305, 241, 157, 4, 70, "Notes",
 CellID->898809850],
Cell[7465, 247, 316, 9, 70, "Notes",
 CellID->329977022]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7830, 262, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->625561808],
Cell[CellGroupData[{
Cell[8316, 279, 148, 5, 70, "ExampleSection",
 CellID->329731734],
Cell[8467, 286, 192, 4, 70, "Notes",
 CellID->315923061],
Cell[CellGroupData[{
Cell[8684, 294, 1717, 54, 70, "Input",
 CellID->275367989],
Cell[10404, 350, 122, 2, 70, "Print",
 CellID->51510509],
Cell[10529, 354, 1149, 35, 50, "Output",
 CellID->292519076],
Cell[CellGroupData[{
Cell[11703, 393, 98, 2, 70, "Print",
 CellID->501595322],
Cell[11804, 397, 122, 2, 70, "Print",
 CellID->75520894]
}, Open  ]],
Cell[11941, 402, 2049, 61, 126, "Output",
 CellID->557594027],
Cell[13993, 465, 172, 3, 70, "Print",
 CellID->407396728],
Cell[14168, 470, 1283, 41, 87, "Output",
 CellID->114383041]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15512, 518, 427, 12, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[15942, 532, 181, 5, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[16138, 540, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

