(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/DynkinIndex\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/DynkinIndex"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
DynkinIndex.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/DynkinIndex", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["DynkinIndex", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DynkinIndex", "[", 
       RowBox[{"group", ",", " ", "rep"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]",
     "Computes the quadratic Casimir of representation ",
     Cell[BoxData["rep"], "InlineFormula"],
     " of ",
     Cell[BoxData["group"], "InlineFormula"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->200303879],

Cell[TextData[{
 Cell[BoxData["group"], "InlineFormula"],
 " should be a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 "."
}], "Notes",
 CellID->28210228],

Cell[TextData[{
 "Each representation ",
 Cell[BoxData["rep"], "InlineFormula"],
 " should be a list of non-negative integers (Dynkin coefficients)."
}], "Notes",
 CellID->125196071],

Cell[TextData[{
 "This the same as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Casimir", "[", 
    RowBox[{"group", ",", " ", "rep"}], "]"}], " ", 
   RowBox[{
    RowBox[{"DimR", "[", 
     RowBox[{"group", ",", " ", "rep"}], "]"}], "/", 
    RowBox[{"DimR", "[", 
     RowBox[{"group", ",", " ", 
      RowBox[{"Adjoint", "[", "group", "]"}]}], "]"}]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Assuming that ",
 Cell[BoxData[
  SuperscriptBox["T", "a"]], "InlineFormula"],
 " are the representation matrices, then ",
 Cell[BoxData[
  RowBox[{
   UnderscriptBox["\[Sum]", "a"], 
   RowBox[{
    SuperscriptBox["T", "a"], 
    SuperscriptBox["T", "a"]}]}]], "InlineFormula"],
 "= (Dynkin index)\[Times](Identity matrix)."
}], "Notes",
 CellID->231395224]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7999192],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->252236125],

Cell[TextData[{
 "The usual convention of having the fundamental of SU(n) with a Dynkin index \
",
 Cell[BoxData[
  FractionBox["1", "2"]], "InlineFormula"],
 " is respected by this method:"
}], "ExampleText",
 CellID->32979335],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Dynkin index of the fundamental of SU(2): \>\"", ",", 
    RowBox[{"DynkinIndex", "[", 
     RowBox[{"SU2", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Dynkin index of the fundamental of SU(3): \>\"", ",", 
    RowBox[{"DynkinIndex", "[", 
     RowBox[{"SU3", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Dynkin index of the fundamental of SU(4): \>\"", ",", 
    RowBox[{"DynkinIndex", "[", 
     RowBox[{"SU4", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Dynkin index of the fundamental of SU(5): \>\"", ",", 
    RowBox[{"DynkinIndex", "[", 
     RowBox[{"SU5", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "]"}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->280814282],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dynkin index of the fundamental of SU(2): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "2"]}],
  SequenceForm["Dynkin index of the fundamental of SU(2): ", 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->56210016],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dynkin index of the fundamental of SU(3): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "2"]}],
  SequenceForm["Dynkin index of the fundamental of SU(3): ", 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->608590538],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dynkin index of the fundamental of SU(4): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "2"]}],
  SequenceForm["Dynkin index of the fundamental of SU(4): ", 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->70810851],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dynkin index of the fundamental of SU(5): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "2"]}],
  SequenceForm["Dynkin index of the fundamental of SU(5): ", 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->59339524]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Adjoint",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/Adjoint"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Casimir",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/Casimir"]], "InlineFormula"]
}], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 729},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DynkinIndex - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2014, 12, 18, 10, 47, 18.7399486}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "DynkinIndex[group, rep] Computes the quadratic Casimir of representation \
rep of group", "synonyms" -> {}, "title" -> "DynkinIndex", "type" -> "Symbol",
     "uri" -> "Susyno/ref/DynkinIndex"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "9.0 for Microsoft Windows (64-bit) (January 25, 2013)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5639, 182, 459, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->7999192]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12127, 394}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[604, 21, 76, 1, 70, "SymbolColorBar"],
Cell[683, 24, 178, 5, 70, "LinkTrail"],
Cell[864, 31, 2310, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[3177, 86, 54, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[CellGroupData[{
Cell[3256, 91, 537, 16, 70, "Usage",
 CellID->982511436],
Cell[CellGroupData[{
Cell[3818, 111, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->200303879],
Cell[4401, 130, 210, 8, 70, "Notes",
 CellID->28210228],
Cell[4614, 140, 182, 5, 70, "Notes",
 CellID->125196071],
Cell[4799, 147, 412, 14, 70, "Notes",
 CellID->1067943069],
Cell[5214, 163, 376, 13, 70, "Notes",
 CellID->231395224]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5639, 182, 459, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7999192],
Cell[CellGroupData[{
Cell[6123, 199, 148, 5, 70, "ExampleSection",
 CellID->252236125],
Cell[6274, 206, 228, 7, 70, "ExampleText",
 CellID->32979335],
Cell[CellGroupData[{
Cell[6527, 217, 1147, 32, 70, "Input",
 CellID->280814282],
Cell[CellGroupData[{
Cell[7699, 253, 326, 9, 70, "Print",
 CellID->56210016],
Cell[8028, 264, 327, 9, 70, "Print",
 CellID->608590538],
Cell[8358, 275, 326, 9, 70, "Print",
 CellID->70810851],
Cell[8687, 286, 326, 9, 70, "Print",
 CellID->59339524]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9086, 303, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[9508, 317, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[9696, 325, 427, 12, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[10126, 339, 422, 14, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[10563, 356, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

