(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



BeginPackage["Susyno`SymmetryBreaking`",{"Susyno`LieGroups`"}];

{DecomposeRep};

{RegularSubgroupInfo,RegularSubgroupProjectionMatrix,BreakRepIntoSubgroupIrreps,GetAllNLinearInvariantsCombinations,SubgroupEmbeddingCoefficients};

{cbToTensor,invertOrdering,locateFieldCombinations,addVevs,effectiveInteractionContributionAfterVEVs};

{v,p};
Begin["`Private`"]



(* ***************************************************************************************************** *)
(* ***************************** This contains the SO10 projection matrices ************************* *)

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* Auxiliar method. Input: list o matrices. Output: big matrix with the given matrices as diagonal blocks *)
(* Taken from SSB module *)
BlockDiagonalMatrix[blocks_]:=Module[{dims,result,i,pos},
dims=Dimensions/@blocks;
result=ConstantArray[0,Plus@@dims];
pos={1,1};
Do[
result[[pos[[1]];;(pos+dims[[i]])[[1]]-1,pos[[2]];;(pos+dims[[i]])[[2]]-1]]=blocks[[i]];
pos+=dims[[i]];
,{i,Length[blocks]}];

Return[result];
]

Quiet[Needs["GraphUtilities`"]];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* U(1) in non-canonical form *)
breakingRelations={{{SO10},{SU4,SU2,SU2},{{1,1,1,0,1},{0,1,1,1,0},{-1,-1,-1,-1,0},{0,0,1,1,1},{0,0,1,0,0}}},{{SU4,SU2,SU2},{SU4,SU2,U1},{{1,0,0,0,0},{0,1,0,0,0},{0,0,1,0,0},{0,0,0,1,0},{0,0,0,0,1/2}}},{{SU4,SU2,SU2},{SU3,SU2,SU2,U1},{{1,0,0,0,0},{0,1,0,0,0},{0,0,0,1,0},{0,0,0,0,1},{1/3,2/3,1,0,0}}},{{SU4,SU2,U1},{SU3,SU2,U1,U1},{{1,0,0,0,0},{0,1,0,0,0},{0,0,0,1,0},{0,0,0,0,1},{1/3,2/3,1,0,0}}},{{SU3,SU2,SU2,U1},{SU3,SU2,U1,U1},{{1,0,0,0,0},{0,1,0,0,0},{0,0,1,0,0},{0,0,0,1/2,0},{0,0,0,0,1}}},{{SU3,SU2,U1,U1},{SU3,SU2,U1},{{1,0,0,0,0},{0,1,0,0,0},{0,0,1,0,0},{0,0,0,-1,1/2}}},{{SO10},{SU5,U1},{{1,1,0,0,0},{0,0,1,0,1},{0,0,0,1,0},{0,1,1,0,0},{2,0,2,1,-1}}} ,{{SU5,U1},{SU3,SU2,U1,U1},{{1,1,0,0,0},{0,0,1,1,0},{0,1,1,0,0},{-(1/5),1/10,-(1/10),1/5,1/10},{-(4/15),2/15,-(2/15),4/15,-(1/5)}}},{{SU5},{SU3,SU2,U1},{{1,1,0,0},{0,0,1,1},{0,1,1,0},{-2,1,-1,2}}},{{SU5,U1},{SU5},{{1,0,0,0,0},{0,1,0,0,0},{0,0,1,0,0},{0,0,0,1,0}}}};

(* Use these: U(1)'s in the canonical normalization (except ElectroMagnetic one) *)
breakingRelations={{{SO10},{SU4,SU2,SU2},{{1,1,1,0,1},{0,1,1,1,0},{-1,-1,-1,-1,0},{0,0,1,1,1},{0,0,1,0,0}}},{{SU4,SU2,SU2},{SU4,SU2,U1},{{1,0,0,0,0},{0,1,0,0,0},{0,0,1,0,0},{0,0,0,1,0},{0,0,0,0,1/2}}},{{SU4,SU2,SU2},{SU3,SU2,SU2,U1},{{1,0,0,0,0},{0,1,0,0,0},{0,0,0,1,0},{0,0,0,0,1},Sqrt[3/8]{1/3,2/3,1,0,0}}},{{SU4,SU2,U1},{SU3,SU2,U1,U1},{{1,0,0,0,0},{0,1,0,0,0},{0,0,0,1,0},{0,0,0,0,1},Sqrt[3/8]{1/3,2/3,1,0,0}}},{{SU3,SU2,SU2,U1},{SU3,SU2,U1,U1},{{1,0,0,0,0},{0,1,0,0,0},{0,0,1,0,0},{0,0,0,1/2,0},{0,0,0,0,1}}},{{SU3,SU2,U1,U1},{SU3,SU2,U1},{{1,0,0,0,0},{0,1,0,0,0},{0,0,1,0,0},{0,0,0,Sqrt[3/5],Sqrt[2/5]}}},{{SO10},{SU5,U1},{{1,1,0,0,0},{0,0,1,0,1},{0,0,0,1,0},{0,1,1,0,0},Sqrt[1/40]{2,0,2,1,-1}}} ,{{SU5,U1},{SU3,SU2,U1,U1},{{1,1,0,0,0},{0,0,1,1,0},{0,1,1,0,0},{-(1/5),1/10,-(1/10),1/5,Sqrt[2/5]},{-(Sqrt[(2/3)]/5),1/(5 Sqrt[6]),-(1/(5 Sqrt[6])),Sqrt[2/3]/5,-Sqrt[(3/5)]}}},{{SU5},{SU3,SU2,U1},{{1,1,0,0},{0,0,1,1},{0,1,1,0},Sqrt[1/60]{-2,1,-1,2}}},{{SU5,U1},{SU5},{{1,0,0,0,0},{0,1,0,0,0},{0,0,1,0,0},{0,0,0,1,0}}},{{SU3,SU2,U1},{SU3,U1},{{1,0,0,0},{0,1,0,0},{0,0,1/2,Sqrt[5/3]}}}};



groupsInBreakingChain=DeleteDuplicates[Flatten[breakingRelations[[All,1;;2]],1]];

graphOfGroups={};

Do[
aux1=Position[groupsInBreakingChain,breakingRelations[[i,1]]];
aux2=Position[groupsInBreakingChain,breakingRelations[[i,2]]];

If[Length[aux1]Length[aux2]>0,
AppendTo[graphOfGroups,{aux1[[1,1]],aux2[[1,1]]}];

];

,{i,Length[breakingRelations]}];

(* This comment-out and the next one below allow the code to run on Mathematica 9 *)
(* graphOfGroups=FromOrderedPairs[graphOfGroups]; *)
graphOfGroupsRaw=graphOfGroups;
graphOfGroups=Graph[Rule@@@graphOfGroups];

(* Some info *)
(*
Print[Style["XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX WeightProjectionModule XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",{GrayLevel[0.5],FontFamily\[Rule]"Consolas"}]];
Print[GraphPlot[Rule@@@graphOfGroupsRaw(*ToOrderedPairs[graphOfGroups]*)/.{i_Integer\[RuleDelayed]Row[Style[CMtoName[#],FontSize\[Rule]10]&/@groupsInBreakingChain[[i]],"x"]},VertexLabeling\[Rule]True,DirectedEdges\[Rule]True,Method\[Rule]Automatic,PlotRangePadding\[Rule]Automatic]];

result={};

AppendTo[result,Style["The breaking chains above are the ones for which projection matrices have already been supplied. For these cases, just use ",{GrayLevel[0.5]}]];
AppendTo[result,Style["DecomposeRep[group -> subgroup, representation of big group]",{Bold,Darker[Red]}]];
AppendTo[result,""];
AppendTo[result,Style["For example:",{GrayLevel[0.5]}]];

AppendTo[result,Row[{"DecomposeRep[{SO10}->{SU4,SU2,U1},{{1,0,0,0,0}}] ",Button[Style["(copy-paste this)",{Darker[Red],FontFamily\[Rule]"Consolas"}],CellPrint[Cell["DecomposeRep[{SO10}->{SU4,SU2,U1},{{1,0,0,0,0}}]","Input"]],Appearance\[Rule]None,Background\[Rule]GrayLevel[1],FrameMargins\[Rule]2]},BaseStyle\[Rule]{GrayLevel[0.5]}]];

AppendTo[result,Row[{"DecomposeRep[{SU5,U1}->{SU3,SU2,U1},{{0,0,0,2},1/(2 Sqrt[10])}] ",Button[Style["(copy-paste this)",{Darker[Red],FontFamily\[Rule]"Consolas"}],CellPrint[Cell["DecomposeRep[{SU5,U1}->{SU3,SU2,U1},{{0,0,0,2},1/(2Sqrt[10])}]","Input"]],Appearance\[Rule]None,Background\[Rule]GrayLevel[1],FrameMargins\[Rule]2]},BaseStyle\[Rule]{GrayLevel[0.5]}]];

AppendTo[result,Row[{"DecomposeRep[{SU4,SU2,SU2}->{SU3,SU2,U1,U1},{{1,0,1},{2},{0}}] ",Button[Style["(copy-paste this)",{Darker[Red],FontFamily\[Rule]"Consolas"}],CellPrint[Cell["DecomposeRep[{SU4,SU2,SU2}->{SU3,SU2,U1,U1},{{1,0,1},{2},{0}}]","Input"]],Appearance\[Rule]None,Background\[Rule]GrayLevel[1],FrameMargins\[Rule]2]},BaseStyle\[Rule]{GrayLevel[0.5]}]];
AppendTo[result,""];
AppendTo[result,Style["In principle, other cases are also possible with DecomposeRep[group,representation of ",{GrayLevel[0.5]}]];
AppendTo[result,Style["big group,subgroup, projection matrix from group to subgroup] but in this case a projection matrix must be supplied",{GrayLevel[0.5]}]];
AppendTo[result,Style["(see Slansky's chapter 6 for details).",{GrayLevel[0.5]}]];
AppendTo[result,""];
AppendTo[result,Style["To display tallied decomposition in a table use MakeTableWithRepDecomposition[<group>,<resultsData>,<nColumns>].",{GrayLevel[0.5]}]];
AppendTo[result,Style["XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",{GrayLevel[0.5]}]];
Print[Row[result,"\n",BaseStyle\[Rule](FontFamily\[Rule]"Consolas")]];
*)



prjMatrix[g1_,g2_]:=Module[{aux1,aux2,path,projections},

aux1=Position[groupsInBreakingChain,g1];
aux2=Position[groupsInBreakingChain,g2];
If[Length[aux1]Length[aux2]==0,Return[Null]];(* groups not found *)
aux1=aux1[[1,1]];aux2=aux2[[1,1]];

path=GraphPath[graphOfGroups,aux1,aux2];

If[path[[{1,-1}]]!={aux1,aux2},Return[Null]];(* path not found *)

projections={};
Do[
aux1=Position[breakingRelations[[All,1;;2]],{groupsInBreakingChain[[path[[i]]]],groupsInBreakingChain[[path[[i+1]]]]}];
If[Length[aux1]!=0, aux1=breakingRelations[[aux1[[1,1]],3]],
aux1=Position[breakingRelations[[All,1;;2]],{groupsInBreakingChain[[path[[i+1]]]],groupsInBreakingChain[[path[[i]]]]}];
aux1=Inverse[breakingRelations[[aux1[[1,1]],3]]];
];
PrependTo[projections,aux1];
,{i,Length[path]-1}];

Return[Dot@@projections];
]


(* ***************************************************************************************************** *)
(* ***************************************************************************************************** *)







pSO10ToSU4SU2SU2={{1,1,1,0,1},{0,1,1,1,0},{-1,-1,-1,-1,0},{0,0,1,1,1},{0,0,1,0,0}};
pSU4SU2SU2ToSU3SU2SU2U1={{1,0,0,0,0},{0,1,0,0,0},{0,0,0,1,0},{0,0,0,0,1},{1/3,2/3,1,0,0}};
pSO10ToSU3SU2SU2U1={{1,1,1,0,1},{0,1,1,1,0},{0,0,1,1,1},{0,0,1,0,0},{-(2/3),0,0,-(1/3),1/3}};


(* This method is even simpler to use, if the projection matrix prtMatrix for a particular breaking is already set up *)
(* But there is a problem: in some cases there are multiple SSB chains/paths that lead to different results. Use chains in this case. E.g.: *)
DecomposeRep[chain_,rep_]:=Module[{projectionMatrix,chainMod},
chainMod=Flatten[{chain},\[Infinity],Rule];
projectionMatrix=Table[prjMatrix[chainMod[[i]],chainMod[[i+1]]],{i,Length[chainMod]-1}];
projectionMatrix=If[Length[chainMod]>2,Dot@@Reverse[projectionMatrix],projectionMatrix[[1]]];
Return[DecomposeRep[chainMod[[1]],rep,chainMod[[-1]],projectionMatrix]];
]

(* Use this method - it is more user friendly *)
(* Will it work if the new groups are all U1s? *)
(* oG can be a list of groups *)
Options[DecomposeRep]={UseName->False};
DecomposeRep[oG_,oRep_,newGs_,projectionMatrix_,OptionsPattern[]]:=DecomposeRep[oG,oRep,newGs,projectionMatrix,UseName->OptionValue[UseName]]=Module[{posU1s,posNonU1s,limits,projectionMatrixApart,aux,result},
posU1s=Position[newGs,{},{1}]//Flatten;
posNonU1s=Complement[Range[Length[newGs]],posU1s];

limits=Prepend[1+Accumulate[Max[Length[#],1]&/@newGs],1];
projectionMatrixApart=Table[projectionMatrix[[limits[[i]];;limits[[i+1]]-1]],{i,Length[newGs]}];


aux=DecomposeRep\[UnderBracket]Aux[oG,oRep,newGs[[posNonU1s]],newGs[[posU1s]],Join@@projectionMatrixApart[[posNonU1s]],Join@@projectionMatrixApart[[posU1s]]];

(* initialize the result variable *)
result=ConstantArray[0,{Length[aux],Length[newGs]}];

(* Put the U1s in the right position *)
result[[All,posU1s]]=aux[[All,2]];

(* Put the rest of things in the right postion *)
result[[All,posNonU1s]]=aux[[All,1]];

If[OptionValue[UseName],Return[RepName[newGs,#]&/@result],Return[result]];
]

(* Less user frindly *)
(* Will it work if the new groups are all U1s? *)
(* oG can be a list of groups *)

(* UPDATE: assume that oGin is a list of groups. *)
DecomposeRep\[UnderBracket]Aux[oGIn_,oRepIn_,newGNonU1s_,newGU1s_,projectionMatrixNonU1sIn_,projectionMatrixU1sIn_]:=Module[{aux,aux2,oRepU1s,oRepNonU1s,limits,limitsAc,weights,result,posOGU1s,posOGNonU1s,oG,oRep,projectionMatrixNonU1s,projectionMatrixU1s,conjugacyClassFunction,idx,res,genericRepresentation,resTemp,completeResult,weightsGroups},

(* [OPERATION REV] In the original group, U1s may not come last. However, in the following it is useful that they do, therefore this is changed here *)
posOGU1s=Flatten[Position[oGIn,{},{1},Heads->False]];
posOGNonU1s=Flatten[Position[oGIn,x_/;!(x==={}),{1},Heads->False]];

limits=Max[1,Length[#]]&/@oGIn;
limitsAc=Table[Range@@(Accumulate[limits][[i]]-limits[[i]]+{1,limits[[i]]}),{i,Length[limits]}];

projectionMatrixNonU1s=projectionMatrixNonU1sIn[[All,Flatten[Join[limitsAc[[posOGNonU1s]],limitsAc[[posOGU1s]]]]]];
projectionMatrixU1s=projectionMatrixU1sIn[[All,Flatten[Join[limitsAc[[posOGNonU1s]],limitsAc[[posOGU1s]]]]]];

oG=Join[oGIn[[Flatten[Position[oGIn,x_/;!(x==={}),{1},Heads->False]]]],oGIn[[Flatten[Position[oGIn,{},{1},Heads->False]]]]];
oRep=Join[oRepIn[[Flatten[Position[oGIn,x_/;!(x==={}),{1},Heads->False]]]],oRepIn[[Flatten[Position[oGIn,{},{1},Heads->False]]]]];
(* [OPERATION REV] Ends here *)

oRepU1s=Flatten[oRep[[Flatten[Position[oG,{},{1},Heads->False]]]]];
oRepNonU1s=Flatten[oRep[[Flatten[Position[oG,x_/;!(x==={}),{1},Heads->False]]]]];

(* If there are only U1's in the subgroup *)
If[newGNonU1s==={},
aux=ConstantArray[{{},(projectionMatrixU1s.#[[2]])},#[[3]]]&/@If[oRepU1s==={},WeightsMod[oG,{oRepNonU1s,1}],WeightsMod[oG[[Flatten[Position[oG,x_/;x=!={},{1},Heads->False]]]],{oRepNonU1s,oRepU1s,1}]];
aux=Flatten[aux,1];
Return[aux];
];

limits=Prepend[1+Accumulate[Length/@newGNonU1s],1];

(* [--------------------OPERATION SPEED UP 1--------------------] Start *)
If[Length[oG]==1&&Length[newGNonU1s]==1&&Length[newGU1s]==0&&Length[oG[[1]]]==Length[newGNonU1s[[1]]],
(* Speed up happens for this case: original group=simple group; new group= simple group with same rank *)

weights=SpeedUp1\[UnderBracket]DecomposeReps[oG[[1]],newGNonU1s[[1]],oRepNonU1s,Inverse[projectionMatrixNonU1s]];

,
(* No speed up *)

(* TODO: seems unnecessary to consider that oG might not be a list of groups [Depth[oG]\[Equal]3] *)
aux2=If[Depth[oG]==3,Weights[oG,oRep],If[oRepU1s==={},WeightsMod[oG,{oRepNonU1s,1}],WeightsMod[oG[[Flatten[Position[oG,x_/;!(x==={}),{1},Heads->False]]]],{oRepNonU1s,oRepU1s,1}]]];

If[newGU1s==={},
weights={(projectionMatrixNonU1s.Flatten[#[[1;;-2]]]),{},#[[-1]]}&/@aux2;
,
weights={(projectionMatrixNonU1s.Flatten[#[[1;;-2]]]),(projectionMatrixU1s.Flatten[#[[1;;-2]]]),#[[-1]]}&/@aux2;
];

(* Work only with weights with no negative coefficients [only these can be Dynkin indices] *)
weights=DeleteCases[weights,x_/;x[[1]]=!=Abs[x[[1]]]];

];
(* [--------------------OPERATION SPEED UP 1--------------------] End *)

result={};

 (* [START] This code computes a function [conjugacyClassFunction] which allows to separate the weights in different classes, speeding up the calculation *) 
idx=1;
res={};
Do[
If[g=!=U1,
genericRepresentation=vr\[UnderBracket]aux[#]&/@Range[idx,idx+Length[g]-1];
idx=idx+Length[g];
resTemp=ConjugacyClass[g,genericRepresentation];
,
resTemp={vr\[UnderBracket]aux[idx]};
idx=idx+1;
];
res=Join[res,resTemp];

,{g,Join[newGNonU1s,newGU1s]}];

conjugacyClassFunction=(res/.vr\[UnderBracket]aux[iii_]:>#[[iii]])&;
 (* [END] This code computes a function [conjugacyClassFunction] which allows to separate the weights in different classes, speeding up the calculation *)


(* Separate the weights according to their conjugacy class to speed up the calculation *)
weightsGroups=Gather[weights,conjugacyClassFunction[Join[#1[[1]],#1[[2]]]]==conjugacyClassFunction[Join[#2[[1]],#2[[2]]]]&]; 

(* Sort weights in a descending fashion *)
weightsGroups=SortWeights[newGNonU1s,#]&/@weightsGroups;

completeResult={};
Do[

While[Length[weights]>0,
aux=Table[weights[[1,1,limits[[i]];;limits[[i+1]]-1]],{i,Length[newGNonU1s]}];
result=Join[result,ConstantArray[{aux,weights[[1,2]]},weights[[1,-1]]]];
weights=RemoveWeights[Simplify[weights],Simplify[WeightsModDominants[newGNonU1s,weights[[1]]]]];
weights=SortWeights[newGNonU1s,weights];
];
,{weights,weightsGroups}];

completeResult=Join[completeResult,Simplify[result]];


Return[completeResult];

]

(* This is a function that speeds up the calculation of Decompose reps when a) there are no U(1)s in the group and subgroup and b) there is no rank reduction between group and subgroup. So, to simplify, for now this speed up is triggered only when both group and subgroup are simple groups with the same rank. *)
(*
First, a list of all subgroup representations smaller or equal in size to the originalRepresentation are computed. With the inverse projection matrix one finds the corresponding weights of group. Then, with the DominantConjugate conjugate method one can find the multiplicity of those weight in the original representation of group.
*)
SpeedUp1\[UnderBracket]DecomposeReps[groupSimple_,subgroupSimple_,repOfGroup_,inverseProjectionMatrix_]:=Module[{aux,groupDominantWeights,subgroupDomWeightsOfInterest,result,weightMultiplicity},

aux=RepsUpToDimN[subgroupSimple,DimR[groupSimple,repOfGroup],SortResult->False];
subgroupDomWeightsOfInterest=DeleteCases[aux,x_/;!ArrayQ[Simplify[inverseProjectionMatrix.x],_,IntegerQ]];

aux=DominantConjugate[groupSimple,#][[1]]&/@(Simplify[inverseProjectionMatrix.#]&/@subgroupDomWeightsOfInterest);
groupDominantWeights=DominantWeights[groupSimple,repOfGroup];
weightMultiplicity=Cases[groupDominantWeights,x_/;x[[1]]==#:>x[[2]],1,1]&/@aux;

aux=DeleteCases[MapThread[List,{subgroupDomWeightsOfInterest,weightMultiplicity}],x_/;Length[x[[2]]]==0];
result={#[[1]],{},#[[2,1]]}&/@aux;

Return[result];
]

(* Input to this method: cms={cm1,cm2,...}; repTogether={simpleRepsMerged,<U1repsmerged if any>,degeneracy} *)
(* This method outputs the weights of such a group/rep *)
WeightsMod[cms_,repTogether_]:=Module[{aux,aux1,aux2,aux3,dims},
dims=Length/@cms;
aux1={};
aux2=1;
Do[
AppendTo[aux1,repTogether[[1,aux2;;aux2+dims[[i]]-1]]];
aux2=aux2+dims[[i]];
,{i,Length[cms]}];

aux3={};
Do[

AppendTo[aux3,Weights[cms[[i]],aux1[[i]]]];
,{i,Length[cms]}];

aux3=Tuples[aux3];

(* "Repair" elements *)
Do[
If[Length[repTogether]==2,
aux3[[i]]={aux3[[i,All,1]]//Flatten,repTogether[[-1]]Times@@aux3[[i,All,2]]},
aux3[[i]]={aux3[[i,All,1]]//Flatten,repTogether[[2]],repTogether[[-1]]Times@@aux3[[i,All,2]]}
];
,{i,Length[aux3]}];


Return[aux3];
]

WeightsModDominants[cms_,repTogether_]:=Module[{aux,aux1,aux2,aux3,dims},
dims=Length/@cms;
aux1={};
aux2=1;
Do[
AppendTo[aux1,repTogether[[1,aux2;;aux2+dims[[i]]-1]]];
aux2=aux2+dims[[i]];
,{i,Length[cms]}];

aux3={};
Do[

AppendTo[aux3,DominantWeights[cms[[i]],aux1[[i]]]];
,{i,Length[cms]}];

aux3=Tuples[aux3];

(* "Repair" elements *)
Do[
If[Length[repTogether]==2,
aux3[[i]]={aux3[[i,All,1]]//Flatten,repTogether[[-1]]Times@@aux3[[i,All,2]]},
aux3[[i]]={aux3[[i,All,1]]//Flatten,repTogether[[2]],repTogether[[-1]]Times@@aux3[[i,All,2]]}
];
,{i,Length[aux3]}];


Return[aux3];
]

DimRMod[cms_,repTogether_]:=Module[{aux,aux1,aux2,aux3,dims},
dims=Length/@cms;
aux1={};
aux2=1;
Do[
AppendTo[aux1,DimR[cms[[i]],repTogether[[aux2;;aux2+dims[[i]]-1]]]];
aux2=aux2+dims[[i]];
,{i,Length[cms]}];

Return[Times@@aux1];
]



SortWeights[cms_,weights_]:=Module[{bigCmInv,condensedWeights,aux,aux2},
bigCmInv=Transpose[Inverse[BlockDiagonalMatrix[cms]]];
condensedWeights=Gather[weights,#1[[{1,2}]]===#2[[{1,2}]]&];
condensedWeights=Table[{condensedWeights[[i,1,1]],condensedWeights[[i,1,2]],Total[condensedWeights[[i,All,-1]]]},{i,Length[condensedWeights]}];

condensedWeights={#,bigCmInv.(#[[1]])}&/@condensedWeights;
aux=Sort[condensedWeights,OrderedQ[{#2[[2]],#1[[2]]}]&][[All,1]];
Return[aux];
];

RemoveWeights[mainList_,toRemoveList_]:=Module[{aux,nU1s,nNonU1s,mainListMod,toRemoveListMod,pos},
aux=mainList;
mainListMod=mainList;
toRemoveListMod=toRemoveList;

(* There are U1's mixed in ... merge the U1 information with the simple groups part *)
nU1s=Length[aux[[1,2]]];
nNonU1s=Length[aux[[1,1]]];
If[Length[aux[[1]]]==3,
aux={Join[#[[1]],#[[2]]],#[[3]]}&/@aux;
mainListMod={Join[#[[1]],#[[2]]],#[[3]]}&/@mainListMod;
toRemoveListMod={Join[#[[1]],#[[2]]],#[[3]]}&/@toRemoveListMod;
];

Do[
pos=Position[mainListMod,toRemoveListMod[[i,1]]][[1,1]];
aux[[pos,2]]=aux[[pos,2]]-toRemoveListMod[[i,2]];
,{i,Length[toRemoveListMod]}];

aux=DeleteCases[aux,x_/;x[[2]]==0];

(* If there are U1s ... unmerge the U1/simple group data *)
aux={#[[1,1;;nNonU1s]],#[[1,nNonU1s+1;;-1]],#[[2]]}&/@aux;

Return[aux];
]


(* display tallied decomposition results in a table with nColumns *)
MakeTableWithRepDecomposition[group_,resultsData_,nColumns_]:=Module[{list,thickness,result},
list=Tally[RepName[group,#]&/@resultsData];
list[[All,2]]=Style[#,GrayLevel[0.5],FontFamily->"LM Roman 12"]&/@list[[All,2]];
list[[All,1]]=Style[#,FontFamily->"LM Roman 12"]&/@list[[All,1]];
list=Flatten[list];
list=InverseFlatten[PadRight[list,2nColumns Ceiling[Length[list]/(2nColumns)],""],{Ceiling[Length[list]/(2nColumns)],2nColumns}];
thickness=1.5;
result=Grid[list,Dividers->{{1->{GrayLevel[0.5],Thickness[thickness]},3->{GrayLevel[0.5]},5->{GrayLevel[0.5]},7->{GrayLevel[0.5]},9->{GrayLevel[0.5]},11->{GrayLevel[0.5]},-1->{GrayLevel[0.5],Thickness[thickness]}},{1->{GrayLevel[0.5],Thickness[thickness]},-1->{GrayLevel[0.5],Thickness[thickness]}}},Background->{{{None,GrayLevel[0.9]}},None}];
Return[result];
];



EFH\[UnderBracket]OfExtraDotOfRegularSubAlgebra[simpleGroup_,repMatrices_]:=Module[{mE,mF,mH,combination,weight,cmInv,matD,cmID,newRootSize,posNonZero},

combination=findAdjointDecompositionInSimpleRoots[simpleGroup];

(* Get mE, mF up to a normalization factor to be fixed at the end *)
mE=repMatrices[[combination[[1]],2]];

Do[
mE=SimplifySA[repMatrices[[el,2]].mE-mE.repMatrices[[el,2]]];
,{el,combination[[2;;-1]]}];

mF=Transpose[mE];


(* Get mH *)
weight=-Adjoint[simpleGroup];
cmInv=Inverse[simpleGroup];matD=MatrixD[simpleGroup];cmID=cmInv.matD;
newRootSize=SimpleProduct[weight,weight,cmID]/SimpleProduct[simpleGroup[[1]],simpleGroup[[1]],cmID](MatrixD[\!\(\*
TagBox["simpleGroup",
Function[BoxForm`e$, MatrixForm[BoxForm`e$]]]\)][[1,1]]);
mH=-Diagonal[MatrixD[simpleGroup]][[combination]].repMatrices[[combination,3]]/newRootSize;

(* Finaly, normalize correctly mE and mF *)
posNonZero=Cases[ArrayRules[mE.mF-mF.mE][[1;;-2]],x_/;x[[2]]!=0,{1},1];
If[Length[posNonZero]>0, (* otherwise ... the mE.mF-mF.mE is null and nothing else needs to be done *)
posNonZero=posNonZero[[1,1]];
mE=Sqrt[Extract[mH,posNonZero]/Extract[mE.mF-mF.mE,posNonZero]]mE;
mF=Transpose[mE];
];

Return[SimplifySA/@{mE,mF,mH}];
]

(* Finds the sequence of simple roots needed to add to form the adjoint weight \[CapitalLambda]. The output is {s(1), s(2),...,s(n)} such that the series Subscript[\[Alpha], s(1)],Subscript[\[Alpha], s(1)]+Subscript[\[Alpha], s(2)],Subscript[\[Alpha], s(1)]+Subscript[\[Alpha], s(2)]+Subscript[\[Alpha], s(3)],... is some sequence of weights which ends with \[CapitalLambda]. *)
findAdjointDecompositionInSimpleRoots[group_]:=Module[{weights,weightNow,idx,sequence,continue,i,pos},
weights=Weights[group,Adjoint[group]][[All,1]];
idx=1;
weightNow=0group[[1]];
sequence={};

While[idx=!=Length[weights],
continue=True;
i=1;
pos={};
While[Length[pos]==0,
pos=Position[weights[[1;;-1]],weightNow-group[[i]]];
(* Print[i,"  ",weightNow,"  ",weightNow-group[[i]],"  ",pos]; *)
i++;
];
idx=pos[[1,1]];
weightNow=weightNow-group[[i-1]];
AppendTo[sequence,i-1];
];
Return[sequence];

];

(*
Input example: RegularSubgroupInfo[{U1,SO10,U1},{X1,{1,0,0,0,0},X2},{SU4,SU2,U1},{{2,{-3,2,1}},{2,{4}},{C1,C2,C3}}];
The function computes the U1's that correspond to dots that were excluded [this is essentially the maximum list of U1s that could survive symmetry breaking for the given simple subgroups], and so for each surviving U1 the linear combinations of those U1s must be given.
*)

regularsubgroupinfo::numberOfU1s="There is a total of `1` remnant U(1)'s inside the original group (in addition to the provided simple subgroups).
Make sure that all user-defined unbroken U(1) gauge factors are  a linear combination of these U(1)'s (in other words, each must be specified as an `1`-dimensional list/vector).";

RegularSubgroupInfo[group_,rep_,subgroup_,dotsComposition_]:=Module[{positionU1s,positionNonU1s,matricesGroup,matricesGroupPositions,matricesSubgroup,tempMatrices,dot,extractMatricesPos,u1Combination,aux,aux2,aux3,aux4,missingDots,discardedGenerators,projectionMatrix,dotPositions,nO,tempProjection,availableU1GeneratorsLC,availableU1Generators,extDots,groupMod},
positionU1s=Flatten[Position[subgroup,U1]];
positionNonU1s=Complement[Range[Length[subgroup]],positionU1s];

matricesGroup=Flatten[RepMinimalMatrices[group,rep],2];
(* matricesGroup=InverseFlatten[matricesGroup,{Length[matricesGroup]/3,3}]; *)

matricesGroupPositions=If[Length[#]==0,1,3Length[#]]&/@group;
matricesGroupPositions=Accumulate[matricesGroupPositions]-matricesGroupPositions;

dotPositions=If[Length[#]==0,1,Length[#]]&/@group;
dotPositions=Accumulate[dotPositions]-dotPositions;

nO=Total[Max[Length[#],1]&/@group];

(* ------------- Compute the available U(1)'s generators ------------- *)
aux=Flatten[Table[{dotsComposition[[el,1]],#}&/@dotsComposition[[el,2]],{el,positionNonU1s}],1];
(* aux=DeleteDuplicates[DeleteCases[aux,x_/;x[[2]]<0]]; *)

(* aux=Join[dotsCompletelyRemoved,aux];Print[aux]; *)
missingDots=Complement[Flatten[Table[{i,j},{i,Length[group]},{j,Length[group[[i]]]}],1],Abs[aux]];


aux={#[[1,1]],Sort[#[[All,2]]]}&/@Gather[aux,#1[[1]]==#2[[1]]&];
aux=Sort[Join[aux,{#,{}}&/@Complement[Range[Length[group]],aux[[All,1]],Flatten[Position[group,U1]]]]];

(* [START] This code computes the potential linear combinations of U(1)s which can be factored out of the original group and are not part of the simple subgroups *)
aux2={};
Do[
If[el[[2]]=!={},

extDots=Abs[Cases[el[[2]],x_/;x<0]];
groupMod=group[[el[[1]]]];

If[Length[extDots]>0, (* If the diagram is extended, find the nullspace of the extended diagram *)
groupMod[[extDots[[1]]]]=-Adjoint[group[[el[[1]]]]];
];
aux3=NullSpace[groupMod[[Abs[el[[2]]]]]];
,
aux3=IdentityMatrix[Length[group[[el[[1]]]]]];
];

If[Length[aux3]>0,
AppendTo[aux2,PadRight[Join[ConstantArray[0,dotPositions[[el[[1]]]]],#],nO]&/@(aux3)];
];
,{el,aux}];

aux2=Join[Flatten[aux2,1],UnitVector[nO,#]&/@(dotPositions[[Flatten[Position[group,U1]]]]+1)];
(* [END] This code computes the potential linear combinations of U(1)s which can be factored out of the original group and are not part of the simple subgroups *)


(* At this point, aux2 contains the linear combinations of the roots which yield valid U(1)s that will commute with the {e,f,h} triples of the preserved dots *)

aux3=Table[If[group[[gI]]===U1,matricesGroup[[{matricesGroupPositions[[gI]]+1}]],matricesGroup[[matricesGroupPositions[[gI]]+3Range[Length[group[[gI]]]]]]],{gI,Length[group]}];
aux3=Flatten[aux3,1];

availableU1GeneratorsLC=aux2;
availableU1Generators=If[aux2=!={},SimplifySA/@(aux2.aux3),{}];

matricesSubgroup={};
projectionMatrix={};
Do[
tempMatrices={};
If[subgroup[[elI]]=!=U1,
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX non U1s XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

Do[
dot=dotsComposition[[elI,2,dotI]];

If[dot>0,
extractMatricesPos=matricesGroupPositions[[dotsComposition[[elI,1]]]]+3(dot-1)+{1,2,3};

AppendTo[tempMatrices,matricesGroup[[extractMatricesPos]]];
AppendTo[projectionMatrix,UnitVector[nO,dotPositions[[dotsComposition[[elI,1]]]]+dot]];
,
extractMatricesPos=matricesGroupPositions[[dotsComposition[[elI,1]]]];
aux=matricesGroup[[1+extractMatricesPos;;extractMatricesPos+3Length[group[[dotsComposition[[elI,1]]]]]]];
aux=InverseFlatten[aux,{Length[group[[dotsComposition[[elI,1]]]]],3}];

AppendTo[tempMatrices,EFH\[UnderBracket]OfExtraDotOfRegularSubAlgebra[group[[dotsComposition[[elI,1]]]],aux]];
aux=Table[-Count[dotPositions[[dotsComposition[[elI,1]]]]+findAdjointDecompositionInSimpleRoots[group[[dotsComposition[[elI,1]]]]],i],{i,nO}];
AppendTo[projectionMatrix,aux];
];

,{dotI,Length[dotsComposition[[elI,2]]]}];
AppendTo[matricesSubgroup,tempMatrices];

,
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX U1s XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
If[Length[availableU1GeneratorsLC]!=Length[dotsComposition[[elI]]],
Message[regularsubgroupinfo::numberOfU1s,Length[availableU1GeneratorsLC]];
];
AppendTo[matricesSubgroup,{{SimplifySA[dotsComposition[[elI]].availableU1Generators]}}];
AppendTo[projectionMatrix,dotsComposition[[elI]].availableU1GeneratorsLC]; 
];

,{elI,Length[dotsComposition]}];

(* XXXXXXXXXXXXXXXXXXXXXXXXXX What were the discarded generators? XXXXXXXXXXXXXXXXXXXXXXXXXX *)
aux=Flatten[Table[{dotsComposition[[el,1]],#}&/@dotsComposition[[el,2]],{el,positionNonU1s}],1];
aux=DeleteDuplicates[DeleteCases[aux,x_/;x[[2]]==0]];
missingDots=Complement[Flatten[Table[{i,j},{i,Length[group]},{j,Length[group[[i]]]}],1],aux];

aux={#[[1,1]],Sort[#[[All,2]]]}&/@Gather[aux,#1[[1]]==#2[[1]]&];

(* Out of caution, assume that that there are no U(1)'s and so these correspond to missing generators as well *)
discardedGenerators=Table[If[group[[el[[1]]]]===U1,{},matricesGroup[[matricesGroupPositions[[el[[1]]]]+3(el[[2]]-1)+{1}]]],{el,missingDots}];
discardedGenerators=Join[availableU1Generators,Flatten[discardedGenerators,1]];

Return[{matricesSubgroup,discardedGenerators,projectionMatrix}];
]


(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

GroupsWithRankN2[n_]:=Module[{res},
res={};
If[n>0,AppendTo[res,{"A",n}]];
If[n>2,AppendTo[res,{"D",n}]];
If[n>1,AppendTo[res,{"B",n}]];
If[n>2,AppendTo[res,{"C",n}]];

If[n==2,AppendTo[res,{"G",2}]];
If[n==4,AppendTo[res,{"F",4}]];
If[n==6,AppendTo[res,{"E",6}]];
If[n==7,AppendTo[res,{"E",7}]];
If[n==8,AppendTo[res,{"E",8}]];

Return[res];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

CMtoFamilyAndSeries[cm_]:=Module[{aux,result},
aux=GroupsWithRankN2[Length[cm]];
result=aux[[Position[CartanMatrix@@@aux,cm][[1,1]]]];
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* This function is used to speed up the calculation of invariants, by breaking the original group into smaller ones. *)

(* Given a simple group cm, this function will output a {subgroup, <info>}, where subgroup is a regular subalgebra of cm obtained by converting dots of its Dynkin diagram to U(1)s. <info> provides information on the surviving generators: <info>'s element i is of the form  {False,{i1,i2,...,iN}} (for non-U1 dots) or {True,{i1,i2,...,iN}} for U1 dots, such that the generators {i1,i2,...,iN}.(RepMinimalMatrices[group,rep][[All,3]]) (U1s) or {i1,i2,...,iN}.RepMinimalMatrices[group,rep] are generators of the subgroup associated with its dot i *)

(* It is important latter on that in subgroup the U1s appear in the position from which they were taken from group *)
(*
AuxiliarRegularDecompositionOfGroup\[UnderBracket]InvariantsSpeedUp[cm_]:=Module[{aux,group,subgroup,u1sPosition,hypercharges,minimalGeneratorsOfSubgroup,reorderNonU1Roots},

reorderNonU1Roots={};

group=CMtoFamilyAndSeries[cm];
If[group[[1]]==="A",
subgroup=Flatten[ConstantArray[{SU3,U1},Quotient[group[[2]],3]],1];
u1sPosition=3Range[Quotient[group[[2]],3]];
Switch[Mod[group[[2]],3],1,AppendTo[subgroup,SU2],2,AppendTo[subgroup,SU3]];
];

If[group[[1]]==="B",
If[group[[2]]\[Equal]2,
subgroup={SO5};
u1sPosition={};
,
subgroup=Join[Flatten[ConstantArray[{U1,SU3},Quotient[group[[2]],3]-1],1],{U1,SO5}];
u1sPosition=(1+Length[cm])-3Range[Quotient[group[[2]],3]];
Switch[Mod[group[[2]],3],1,PrependTo[subgroup,SU2],2,PrependTo[subgroup,SU3]];
];

];
(* Same as with B family actually *)
If[group[[1]]==="C",
If[group[[2]]\[Equal]2,
subgroup={SP4};
u1sPosition={};
,
subgroup=Join[Flatten[ConstantArray[{U1,SU3},Quotient[group[[2]],3]-1],1],{U1,SP4}];
u1sPosition=(1+Length[cm])-3Range[Quotient[group[[2]],3]];
Switch[Mod[group[[2]],3],1,PrependTo[subgroup,SU2],2,PrependTo[subgroup,SU3]];
];

];

If[group[[1]]==="D",
subgroup=Join[Flatten[ConstantArray[{U1,SU3},Quotient[group[[2]],3]-1],1],{U1,SU2,SU2}];
u1sPosition=(1+Length[cm])-3Range[Quotient[group[[2]],3]];
Switch[Mod[group[[2]],3],1,PrependTo[subgroup,SU2],2,PrependTo[subgroup,SU3]];
];

(* Test this exception *)
(*
If[group==={"D",5},subgroup={SU2,U1,SU4};u1sPosition={2};reorderNonU1Roots={1,2,4,3,5}];
*)

If[group==={"E",6},subgroup={SU3,U1,SU3,SU2};u1sPosition={3}];
If[group==={"E",7},subgroup={SU3,U1,SU3,U1,SU2};u1sPosition={3,6}];
If[group==={"E",8},subgroup={SU3,U1,SU3,U1,SU2,SU2};u1sPosition={3,6}];
If[group==={"F",4},subgroup={SU3,U1,SU2};u1sPosition={3}];
If[group==={"G",2},subgroup={SU2,U1;u1sPosition={2}}];

(* How this works: *)
(* Looking at the Serre relations ([Ei,Fj]=\[Delta]ij Hi, [Hi,Ej]=Aji Ej, [Hi,Fj]=-Aji Fj), we see that the conversion of a dot in a Dynkin diagram to a U1 results in discarding the associated Ei,Fi but not the Hi. All other generators remain the same. As for the Hi associated to the U1s, by the second and third Serre relations, they must be such that they commute with the surviving Ej and Fj. In practice, this means finding the nullspace of the Cartan matrix of the original group, with the rows corresponding to the U1 dots/roots removed. *)
hypercharges={True,#}&/@NullSpace[cm[[Complement[Range[Length[cm]],u1sPosition]]]];

(* minimalGeneratorsOfSubgroup={<item 1>,...} where <item I> = {False,{i1,i2,...,iN}} means that {i1,i2,...,iN}.RepMinimalMatrices[group,rep] are to be extracted (non-U1 group), and <item I> = {True,{i1,i2,...,iN}} means that {i1,i2,...,iN}.(RepMinimalMatrices[group,rep][[All,3]]) should be extracted (U1 factor) *)
If[reorderNonU1Roots==={},
minimalGeneratorsOfSubgroup=Table[If[MemberQ[u1sPosition,i],Null,{False,UnitVector[Length[cm],i]}],{i,Length[cm]}];,
minimalGeneratorsOfSubgroup=Table[If[MemberQ[u1sPosition,i],Null,{False,UnitVector[Length[cm],reorderNonU1Roots[[i]]]}],{i,Length[cm]}];
];
minimalGeneratorsOfSubgroup[[u1sPosition]]=hypercharges;


(* 
(* Embedding 1/2 *)
If[group==={"D",5},subgroup={SU2,U1,SU3,U1};minimalGeneratorsOfSubgroup={{False,{1,0,0,0,0}},{True,{-1,-2,0,0,2}},{False,{0,0,1,0,0}},{False,{0,0,0,1,0}},{True,{3,6,4,2,0}}}];

(* Embedding 3/4 *)
If[group==={"D",5},subgroup={SU3,U1,SU2,U1};minimalGeneratorsOfSubgroup={{False,{1,0,0,0,0}},{False,{0,1,0,0,0}},{True,{0,0,0,0,1}},{False,{0,0,0,1,0}},{True,{2,4,6,3,0}}}];
*)

(* Embedding 3/4 *)
If[group==={"D",5},subgroup={SU3,U1,SU2,U1};minimalGeneratorsOfSubgroup={{False,{1,0,0,0,0}},{False,{0,1,0,0,0}},{True,{0,0,0,0,1}},{False,{0,0,0,1,0}},{True,{2,4,6,3,0}}}];

Return[{subgroup,minimalGeneratorsOfSubgroup}];
]
*)

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

InvariantsSuperFreeFormMod[repMat1_,repMat2_,conj_Symbol:False]:=Module[{r1,r2,dimR1,dimR2,Id1,Id2,bigMatrix,result,aux1,delColumns,usefulLines,usefulColumns,chunkSize, nChunks,limits},

Off[Solve::"svars"];

r1=SparseArray[#,Dimensions[#]]&/@repMat1;
r2=SparseArray[#,Dimensions[#]]&/@repMat2;
dimR1=Length[repMat1[[1]]];
dimR2=Length[repMat2[[1]]];
Id1=SparseArray[IdentityMatrix[dimR1]];
Id2=SparseArray[IdentityMatrix[dimR2]];

If[conj,
Do[
r2[[i]]=-Transpose[r2[[i]]];
,{i,Length[r2]}];];

bigMatrix={};

Do[
bigMatrix=Join[bigMatrix,SparseArray[KroneckerProduct[r1[[i]],Id2]+KroneckerProduct[Id1,r2[[i]]]]];
,{i,Length[r1]}];

(*Simplify things by deleting columns corresponding to single entrie in rows. Delete also null rows. *)

chunkSize=50000; (*With this value, this method should not use more than about 100 MB of memory *)
nChunks=Ceiling[Length[bigMatrix]/chunkSize];
limits=Table[{(i-1) chunkSize+1,i chunkSize},{i,nChunks}];
limits[[-1,2]]=Length[bigMatrix];

delColumns={};

Do[
aux1=Drop[ArrayRules[bigMatrix[[limits[[i,1]];;limits[[i,2]]]]],-1];

aux1=DeleteCases[Simplify[aux1],x_/;x[[2]]==0];

aux1={#[[1,1]],#[[2]]}&/@Tally[aux1,#1[[1,1]]==#2[[1,1]]&];
delColumns=Join[delColumns,Cases[aux1,x_/;x[[2]]==1:>x[[1,2]]]];
,{i,nChunks}];

delColumns=DeleteDuplicates[delColumns];
usefulColumns=Complement[Range[Length[bigMatrix[[1]]]],delColumns];
If[usefulColumns=={},Return[{}]];

bigMatrix=bigMatrix[[1;;-1,usefulColumns]];

delColumns={};
usefulLines={};

Do[
aux1=Drop[ArrayRules[bigMatrix[[limits[[i,1]];;limits[[i,2]]]]],-1];

aux1=DeleteCases[Simplify[aux1],x_/;x[[2]]==0];

aux1={#[[1,1]],#[[2]]}&/@Tally[aux1,#1[[1,1]]==#2[[1,1]]&];
usefulLines=Join[usefulLines,(i-1) chunkSize+Tally[Cases[aux1,x_/;x[[2]]>1:>x[[1,1]]]][[All,1]]];
delColumns=Join[delColumns,Cases[aux1,x_/;x[[2]]==1:>x[[1,2]]]];
,{i,nChunks}];

delColumns=Tally[delColumns][[All,1]];
usefulLines=Tally[usefulLines][[All,1]];
aux1=Complement[Range[Length[bigMatrix[[1]]]],delColumns];
If[aux1=={},Return[{}]];

usefulColumns=usefulColumns[[aux1]];

If[usefulLines=={},bigMatrix={ConstantArray[0,Length[usefulColumns]]},bigMatrix=bigMatrix[[usefulLines,aux1]]];


result=NullSpace2[SimplifySA[bigMatrix],100];
result=(Flatten[Array[a[#1]b[#2]&,{dimR1,dimR2}]][[usefulColumns]]. #&)/@ result;

Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* This is inspired on BreakRep from SSB.m. The difference is that the subreps are known. Also, this function is to be used to speed up the Invariants function *)
(* The output is {list of irreps of the subgroup,W} such that Inverse[W].<original group matrices combination I>.W=<subgroup matrix I>. Note that W is not unitary in general. The invariants Inv^abc obtained with <subgroup matrices> can be corrected to <original group matrices> as Inv^abc \[Rule] Inv^a'b'c' Inverse[W]a'a Inverse[W]b'b Inverse[W]c'c  *)
(* UPDATE: W in the output is now unitary *)

(* Input is the original 'group', the 'subgroup', the 'projectionMatrix', the group's rep to break 'repToBreak', and a list 'preservedGenerators' of the unbroken generators of 'group' corresponding to the ***minimal generators*** of 'subgroup'. As such, 'preservedGenerators'={sg1,sg2,...} where sgI={simpleRoot1gens,simpleRoot2gens, ...} for each factor group in 'subgroup', and with simpleRootJgens={Ej,Fj,Hj} for each simple root in the factor sgI. *)
BreakRepIntoSubgroupIrreps[group_,subgroup_,projectionMatrix_,repToBreak_,preservedGenerators_]:=Module[{repMatrices1, listOfIrreps,aux,aux2,aux3,nInvs,count,linearCombinations,irreps,timeU,counter,printedInfo,diagMatsPositions,relevantComponents,relevantRows,nAs,nBs,vrs,cfs,unitaringTransformation},

repMatrices1=SimplifySA/@Flatten[preservedGenerators,2];

diagMatsPositions=(Cases[ArrayRules[#][[1;;-2]],x_/;(x[[2]]=!=0&&x[[1,1]]=!=x[[1,2]])]==={})&/@repMatrices1;
diagMatsPositions=Flatten[Position[diagMatsPositions,True],1];

listOfIrreps=Tally[DecomposeRep[group,repToBreak,subgroup,projectionMatrix]][[All,1]];

count=0;
linearCombinations={};
irreps={};

counter=0;
(* printedInfo=PrintTemporary[Dynamic[Row[{"Total states rotated so far: ",count,"/",DimR[bigGroup,repToBreak]},""]]]; *)
Do[
aux=Flatten[RepMinimalMatrices[subgroup,listOfIrreps[[irrepIndex]]],2];
aux3=Transpose[Diagonal/@repMatrices1[[diagMatsPositions]]];
aux2=DeleteDuplicates[Transpose[Diagonal/@aux[[diagMatsPositions]]]];

relevantComponents=DeleteDuplicates[Flatten[Position[aux3,x_/;MemberQ[aux2,x]]]];
relevantRows=DeleteDuplicates[ArrayRules[repMatrices1[[All,All,relevantComponents]]][[1;;-2,1,2]]];
relevantComponents=DeleteDuplicates[Join[relevantComponents,relevantRows]];

aux2=InvariantsSuperFreeFormMod[repMatrices1[[All,relevantComponents,relevantComponents]],SimplifySA/@aux,True]; 
nInvs=Length[aux2];
(* There are for sure these irreps *)


(* START - Unitarization of invariants *)
(* The idea here is to make sure that the change of basis matrix will be unitary. To do this, if there is more than one subgroup irrep X (X, X',...) in the representation to be rotation, then the states corresponding to X, X', ... must be orthogonal. To make this precise, consider that {Subscript[v, \[Alpha]1],Subscript[v, \[Alpha]2],...,Subscript[v, \[Alpha]m]} \[Alpha]=1 to n are the n m-dimensional irreps. The Subscript[v, \[Alpha]i] encode the combinations of the components of the reducible representations which make up the i component of the \[Alpha] irreducible representation. We need to make a transformation B such that Subscript[w, i\[Alpha]]=Subscript[B, \[Alpha]\[Beta]]Subscript[v, i\[Beta]] are orthonormalized vectors, ie Subscript[w, i\[Alpha]].Subscript[w, j\[Beta]]=Subscript[\[Delta], ij]Subscript[\[Delta], \[Alpha]\[Beta]]. Given that B only operates on the \[Alpha] space, the orthonormality of the Subscript[w, i\[Alpha]] for a given \[Alpha] is taken care of automatically by the group/irrep structure under consideration. And as such, we can take i=1 (for example), and consider just the orthogonalization of the vectors {Subscript[v, 11],Subscript[v, 21],...,Subscript[v, n1]} and extract B from there *)
nAs=Count[Variables[aux2],a[_]];
nBs=Count[Variables[aux2],b[_]];
vrs=Sort[Variables[aux2]];
cfs=CoefficientArrays[aux2,vrs][[3,All,1;;nAs,nAs+1]]; (* only need to take one b column *)

unitaringTransformation=Orthogonalize[cfs,Simplify[Conjugate[#1]. #2]&].PseudoInverse[cfs];
aux2=Expand[unitaringTransformation.aux2];
(* END - Unitarization of invariants *)


(* Separate the direct product of groups correctly *)
aux2=aux2 /.a[j_]:>a[relevantComponents[[j]]];
Do[
aux2[[j]]=aux2[[j]]/.b[j_]:>b[j+counter];
counter+=Length[aux[[1]]];
,{j,nInvs}];

 aux2=CoefficientArrays[#,Join[Array[a,Dimensions[repMatrices1][[-1]]],Array[b,Dimensions[repMatrices1][[-1]]]]][[3]]&/@aux2;
aux2=#[[1;;Dimensions[repMatrices1][[-1]],Dimensions[repMatrices1][[-1]]+1;;-1]]&/@aux2;

 aux2=SimplifySA[Total[aux2]]; 
AppendTo[linearCombinations,aux2];
AppendTo[irreps,Table[listOfIrreps[[irrepIndex]],{j,nInvs}]];

count+=nInvs Length[aux[[1]]];
,{irrepIndex,Length[listOfIrreps]}];

(* NotebookDelete[printedInfo]; *)
If[count==DimR[group,repToBreak],Null,Print["ERROR (BreakRepMod): Dimensions of the subrepresentations don't add up."]];

irreps=Flatten[irreps,1];
 (* linearCombinations=Flatten[linearCombinations,1]; *)

(* The conjugation takes care of the fact that we got this result from coefficients a,b *)
(* N's and RootApproximant are meant to simplify the expressions in a quick and accurate way. If problems arrise, change to Simplify *)

(* linearCombinations=RootApproximant[Chop[Conjugate[Transpose[#]]]]&/@N[linearCombinations]; *)
(* Make sure that the norm of the new states is the same as the old ones *)
(* linearCombinations=RootApproximant[#/Norm[#]]&/@N[linearCombinations]; *)

If[Total[Abs[N[Total[linearCombinations]].ConjugateTranspose[N[Total[linearCombinations]]]-IdentityMatrix[Length[Total[linearCombinations]]]],{2}]>10^-8,Print["ERROR (BreakRepMod): Rotation matrix is not unitary."]];
Return[{irreps,linearCombinations}];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Uses RegularSubgroupInfo to provide the projection matrix of a regular embedding *)
RegularSubgroupProjectionMatrix[group_,subgroup_,dotsComposition_]:=Module[{aux,singlet},
singlet=If[IsSimpleGroupQ[group],ConstantArray[0,Length[group]],If[#===U1,0,ConstantArray[0,Length[#]]]&/@group];
Return[RegularSubgroupInfo[group,singlet,subgroup,dotsComposition][[3]]];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* This function outputs {<list>,<N-dimensional tensor>} where <list> = {<el1>,<el2>,...} where each <el> contains the positions of combinations of the representations which contain invariants. The resulting big N-dimensional tensor is the second ouput *)
GetAllNLinearInvariantsCombinations[group_,repsIn_,cjs_]:=Module[{n,singletState,reps,aux,aux2,aux3,invs,posNonU1s,resultTensor,dims,accDims,countInv},

n=Length[repsIn];

(* Conjugate the representations if necessary *)
reps=Table[If[cjs[[repsI]],ConjugateIrrep[group,#]&/@repsIn[[repsI]],repsIn[[repsI]]],{repsI,n}];

posNonU1s=Flatten[Position[group,x_/;x=!={},{1},Heads->False]];


If[Length[repsIn]===1,
singletState=If[#==={},0,#]&/@(ConstantArray[0,Length[#]]&/@group);
aux=Position[repsIn[[1]],singletState];
aux=Table[{auxI,{1,#}&/@auxI,1},{auxI,aux}];
,

aux=ReduceRepProduct[group,#]&/@Tuples[Map[ConjugateIrrep[group,#]&, reps[[1;;Ceiling[n/2]]],{2}]];
aux2=ReduceRepProduct[group,#]&/@Tuples[reps[[Ceiling[n/2]+1;;-1]]];

aux3=Intersection[DeleteDuplicates[Flatten[aux[[All,All,1]],1]],Flatten[aux2[[All,All,1]],1]];

(* This list is of the form {el_1,el_2,...} where each el_N={position in aux,position in aux2,multiplicity of invariant} *)
aux3={#[[1,1]],#[[2,1]],#[[1,2]]#[[2,2]]}&/@Flatten[Table[Tuples[{ {#[[1]],Extract[aux,(#+{0,0,1})]}&/@Position[aux,el],{#[[1]],Extract[aux2,(#+{0,0,1})]}&/@Position[aux2,el]}],{el,aux3}],1];
aux3=Sort[{#[[1,1;;2]],Total[#[[All,3]]]}&/@Gather[aux3,#1[[1;;2]]==#2[[1;;2]]&]];

aux=Tuples[Range[Length[#]]&/@reps[[1;;Ceiling[n/2]]]];
aux2=Tuples[Range[Length[#]]&/@reps[[Ceiling[n/2]+1;;-1]]];
aux={Join[aux[[#[[1,1]]]],aux2[[#[[1,2]]]]],#[[2]]}&/@aux3;
aux={#[[1]],Transpose[{Range[Length[reps]],#[[1]]}],#[[2]]}&/@aux;
];
(* At this point, aux={el_1,el_2,...} where el_N corresponds to a particular combination of fields which is/contains an invariant: el_N={pos_Format1,pos_Format2,nInvs} where pos_Format1={pos rep1, pos rep2, ...} contains the positions of the fields, os_Format2={{1,pos rep1}, {2, pos rep2}, ...} contains the positions of the fields in another formal [which is better for use with Extract], and nInvs is the number of invariants in that particular combination of fields *)

dims=Map[Times@@DimR[group,#]&,reps,{2}];
accDims=Accumulate[#]-#&/@dims;

(* ***************** *)
(* Work with the unconjugated representations from now on *)
reps=repsIn;
resultTensor={};
countInv=0;
Do[
invs=Invariants[group,Extract[reps,aux[[i,2]]],Conjugations->cjs,TensorForm->True][[1]];
aux2=ArrayRules[invs][[1;;-2]];
aux2[[All,1]]=(Join[{countInv},Extract[accDims,aux[[i,2]]]]+#)&/@aux2[[All,1]];
resultTensor=Join[resultTensor,aux2];
countInv+=Length[invs];
,{i,Length[aux]}];

resultTensor=If[countInv==0,{},SparseArray[resultTensor,Join[{countInv},Extract[accDims+dims,Table[{i,-1},{i,Length[reps]}]]]]];
Return[{aux,resultTensor}];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* For some reason, it is very important memory-wise that the second dimension of a sparse array is the largest one. So this function is the same as NullSpace2, but the input matrix is transposed *)
NullSpace2T[matrixInT_,dt_]:=Module[{matrix,preferredOrder,aux1,aux2,aux3,res,n,n2,v},
Off[Power::"indet"];

(* Remove Columns appearing in rows with a single entry *)
(*
aux1=Sort/@Sort[Gather[(matrixIn//ArrayRules)[[1;;-2]],#1[[1,1]]==#2[[1,1]]&]];
aux2=Complement[Range[Length[matrixIn[[1]]]],Cases[aux1,x_/;Length[x]==1\[RuleDelayed]x[[1,1,2]]]];
matrix=matrixIn[[All,aux2]];
*)

(* Organize the rows so that the easiest ones are solved first *)
aux1=Sort/@Sort[Gather[(matrixInT//ArrayRules)[[1;;-2]],#1[[1,2]]==#2[[1,2]]&]];
If[Length[aux1]==0,Return[IdentityMatrix[Length[matrixInT[[All,1]]]]]]; (* If the matrix is null, end this right here, by returning the identity matrix *)
preferredOrder=Flatten[Table[Cases[aux1,x_/;Length[x]==i:>x[[1,1,2]],{1}],{i,1,Max[Length/@aux1]}]];
matrix=matrixInT[[All,preferredOrder]];

n=Length[matrix[[1]]];
n2=Length[matrix];

aux1=Table[v[i],{i,n2}];

Do[
aux2=Solve[Transpose[matrix[[All,i;;Min[i+dt-1,n]]]].aux1==0][[1]];
aux1=Expand[aux1 /.aux2];
,{i,1,n,dt}];

aux3=Tally[Cases[aux1,v[i_]:>i,Infinity]][[All,1]];
res={};
Do[
res=Append[res,aux1/. v[x_]:>If[x!=aux3[[i]],0,1]];
,{i,Length[aux3]}];
Return[res];
];
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Matrix contracted with index n of a tensor - auxiliar function to SubgroupEmbeddingCoefficients. It contracts a matrix 'mat' with the index 'n' of 'tensor' *)
DotN[mat_,tensor_,n_]:=Module[{perm,permI,result},

perm=Insert[RotateLeft[1+Range[Length[Dimensions[tensor]]-1]],1,n];
permI=Flatten[Table[Position[perm,i],{i,Length[perm]}]];
result=Transpose[mat.Transpose[tensor,perm],permI];
Return[result];
]

(* Auxiliar function to print memory and time information. It is used by SubgroupEmbeddingCoefficients *)
ReportData[i_,dt_]:=Print[Style["["<>ToString[i]<>"] ",{Bold,Darker[Red]}],Style["Memory in use: ",Bold],MemoryInUse[]," B; ",Style["Time used so far: ",Bold],dt," s"];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* This is the end function which effective calculates trilinear invariants (and matching coefficients with particular subgroup embeddings which are determined in AuxiliarRegularDecompositionOfGroup) *)

Options[SubgroupEmbeddingCoefficients]={Conjugations->{},Verbose->False,StandardizeInvariants->True};

SubgroupEmbeddingCoefficients[group_,reps_,subgroup_,breakingInformation_,OptionsPattern[]]:=SubgroupEmbeddingCoefficients[group,reps,subgroup,breakingInformation]=Module[{regularSubgroupInfo,subreps,cjs,multilinearCombinations,gaugeRotInfo,aux,aux1,aux2,aux3,auxR1,auxR2,rotMatrices,rotatedInvariants,repM,validCombinationOfSubInvs,validCombinationsOfSubInvariants,finalResult,projectionMatrix,preservedGenerators,brokenGenerators,columnsOfInterest,counter,invariantsRotation,tmp},

If[OptionValue[Verbose],ReportData[0,0]];
tmp=TimeUsed[];

(* Option allows to conjugate the representations given as input. By default, no conjugation is done *)
cjs=If[OptionValue[Conjugations]==={},ConstantArray[False,Length[reps]],OptionValue[Conjugations]];

regularSubgroupInfo=RegularSubgroupInfo[group,#,subgroup,breakingInformation]&/@reps;
preservedGenerators=regularSubgroupInfo[[All,1]];
brokenGenerators=regularSubgroupInfo[[All,2]];
projectionMatrix=regularSubgroupInfo[[1,3]]; (* for output only *)

aux=Table[BreakRepIntoSubgroupIrreps[group,subgroup,projectionMatrix,reps[[i]],preservedGenerators[[i]]],{i,Length[reps]}];

subreps=aux[[All,1]];
aux2=GetAllNLinearInvariantsCombinations[subgroup,subreps,cjs];
multilinearCombinations=aux2[[1]]; (* for output only *)

If[OptionValue[Verbose],ReportData[1,TimeUsed[]-tmp]];
rotMatrices=Total/@aux[[All,2]];
rotMatrices=Table[If[cjs[[repI]],SimplifySA[-Conjugate[rotMatrices[[repI]]]],SimplifySA[rotMatrices[[repI]]]],{repI,Length[reps]}];


If[!MemberQ[ReduceRepProduct[group,Table[If[!cjs[[i]],reps[[i]],ConjugateIrrep[group,reps[[i]]]],{i,Length[reps]}]][[All,1]],reps[[1]]0,{1}],Return[{}]];
(* If[Length[aux2[[2]]]\[Equal]0,Return[{{},{subgroup,projectionMatrix,subreps,multilinearCombinations,{}}}]]; *)(* No invariants for sure --- TODO: add other output *)

(* ---------------- Rotate invariants ---------------- *)
rotatedInvariants=aux2[[2]];
Do[
rotatedInvariants=DotN[rotMatrices[[i]],rotatedInvariants,i+1];
,{i,Length[reps]}];
rotatedInvariants=SimplifySA[rotatedInvariants];
If[OptionValue[Verbose],ReportData[2,TimeUsed[]-tmp]];

(* ---------------- [END] Rotate invariants ---------------- *)

(* Get only the raising operators of the discarded dots in the Cartan diagram which were converted to U1s *)
repM=brokenGenerators;
repM=Table[If[cjs[[repI]],-Transpose/@repM[[repI]],repM[[repI]]],{repI,Length[reps]}];

If[OptionValue[Verbose],ReportData[3,TimeUsed[]-tmp]];

validCombinationsOfSubInvariants={};
Do[
AppendTo[validCombinationsOfSubInvariants,SimplifySA[Sum[DotN[repM[[j,i]],rotatedInvariants,j+1],{j,Length[reps]}]]];
,{i,Length[repM[[1]]]}]; 

If[OptionValue[Verbose],ReportData[4,TimeUsed[]-tmp]];
validCombinationsOfSubInvariants=SparseArray[validCombinationsOfSubInvariants];
If[OptionValue[Verbose],ReportData[5,TimeUsed[]-tmp]];
validCombinationsOfSubInvariants=Flatten[validCombinationsOfSubInvariants,{{2},Join[{1},2+Range[Length[reps]]]}];
If[OptionValue[Verbose],ReportData[6,TimeUsed[]-tmp]];
validCombinationsOfSubInvariants=NullSpace2T[validCombinationsOfSubInvariants,500];
If[OptionValue[Verbose],ReportData[7,TimeUsed[]-tmp]];


finalResult=SparseArray[validCombinationsOfSubInvariants,Dimensions[validCombinationsOfSubInvariants]].rotatedInvariants;
If[OptionValue[Verbose],ReportData[8,TimeUsed[]-tmp]];
aux=Sqrt[Sqrt[Times@@Flatten[DimR[group,#]&/@reps]]/Simplify[Total[#,Length[reps]]&/@SimplifySA[Abs[SimplifySA[finalResult^2]]]]];
finalResult=SimplifySA[aux finalResult];
validCombinationsOfSubInvariants=Simplify[aux validCombinationsOfSubInvariants];

If[OptionValue[Verbose],ReportData[9,TimeUsed[]-tmp]];

(* This block of code ensures that the implied invariants of the big/original group are as given by the Invariants function *)
If[OptionValue[StandardizeInvariants],

(* Look at the non-canonical invariants (only at a minimum of the full tensors) *)
aux1=Flatten[finalResult,{{1},Range[2,Length[reps]+1]}];
aux2=ArrayRules[aux1][[1;;-2]];

columnsOfInterest={};
counter=0;
While[Length[columnsOfInterest]<Length[aux1]&&counter<Length[aux1[[1]]],
counter++;
aux3=Append[columnsOfInterest,aux2[[counter,1,2]]];
If[MatrixRank[aux1[[All,aux3]]]>MatrixRank[aux1[[All,columnsOfInterest]]],
AppendTo[columnsOfInterest,aux2[[counter,1,2]]]];
];

auxR2=aux1[[All,columnsOfInterest]];
(* [END] Look at the non-canonical invariants (only at a minimum of the full tensors) *)

(* Extract the canonical invariants from the Invariants function *)
finalResult=Invariants[group,reps,Conjugations->cjs,TensorForm->True][[1]];
aux1=Flatten[finalResult,{{1},Range[2,Length[reps]+1]}];
auxR1=aux1[[All,columnsOfInterest]];
(* [END] Extract the invariants from the Invariants function *)

invariantsRotation=SimplifySA[auxR1.Inverse[auxR2]];
validCombinationsOfSubInvariants=Simplify[invariantsRotation.validCombinationsOfSubInvariants];
];


If[OptionValue[Verbose],ReportData[10,TimeUsed[]-tmp]];

Return[{{finalResult,rotMatrices},{{group,subgroup},projectionMatrix,subreps,multilinearCombinations,validCombinationsOfSubInvariants}}];
]


(* The functions below use SubgroupEmbeddingCoefficients and collect its results *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Convert to a tensor the Clebsch-Gordon coefficients as given by SMethod2 *)
Options[cbToTensor]={ArrayRules->False};
cbToTensor[cbsData_,OptionsPattern[]]:=Module[{dims,aux,result},
If[cbsData==={},Return[{}]];

dims=Prepend[Length/@cbsData[[2,3]],Length[cbsData[[2,5]]]];
aux=Flatten[Table[Prepend[cbsData[[2,4,i,1]],inv]->WrapFunction[cbsData[[2,5,inv,Total[cbsData[[2,4,1;;i-1,3]]]+Range[cbsData[[2,4,i,3]]]]]],{inv,Length[cbsData[[2,5]]]},{i,Length[cbsData[[2,4]]]}],1];

If[OptionValue[ArrayRules],Return[aux/.WrapFunction[x___]:>x]];

result=Normal[SparseArray[aux,dims]]/.WrapFunction[x___]:>x;

Return[result];
];

invertOrdering[o_]:=Table[Position[o,i][[1,1]],{i,Length[o]}];

(* Returns a list {el1,el2,...} where elI={<ind1>,<inds2>,<order>,<CB coefficients>} with <ind1> the position in the cbs input list of the relevant field combination, <inds2> is the position in the reference list 'pSubFields' of the relevant field combination, and (ref subfields)=(subfields found)[[<order>]]  *)

(* 
  **************** input ****************
originalFields - the representations from the bigger group used as input of SMethod2;

  allOriginalFields - the non-repeated list of representations of the bigger originial group from which 'originalFields' were sellected (possibly taking repetitions)

subFieldsOfInterest - list of representations of the subgroup which need to be found on the SMethod2 output


*)
locateFieldCombinations[cbs_,originalFields_,allOriginalFields_,subFieldsOfInterest_]:=Module[{group,subgroup,projectionMatrix,pFields,pSubFields,aux,aux2,pSubFieldsSorted,result,oR,oF},
If[cbs==={},Return[0]];

{group,subgroup}=cbs[[2,1]];
projectionMatrix=cbs[[2,2]];

aux=DecomposeRep[group,#,subgroup,projectionMatrix]&/@allOriginalFields;

pSubFields=Position[aux,#]&/@subFieldsOfInterest;
pSubFields=InverseFlatten[Tuples[pSubFields],Length/@pSubFields];
pSubFieldsSorted=Map[Sort,pSubFields,{Length[subFieldsOfInterest]}];

pFields=Flatten[Position[allOriginalFields,#]&/@originalFields];

aux=MapThread[List,{pFields,#}]&/@cbs[[2,4,All,1]];


result={};
Do[
aux2=Position[pSubFieldsSorted,Sort[aux[[i]]]];
If[Length[aux2]>0,
 aux2=Flatten[aux2[[1]]]; 
oR=Ordering[Extract[pSubFields,aux2]];
oF=Ordering[aux[[i]]];
AppendTo[result,{i,aux2,oF[[invertOrdering[oR]]],cbs[[2,5,All,Total[cbs[[2,4,1;;i-1,3]]]+Range[cbs[[2,4,i,3]]]]]}];

];
,{i,Length[aux]}];


Return[result];
]

(* returns {el1, el2,...} where elI={<pos>,<contribution>}. <pos> is the position of the subFields in originalFields; <contribution> is the cobtribution to their mass/coupling after all vevs have been inserted in the other fields. More than one elI can exist whenever some singlets remain which are not to be 'VEVed' *)
addVevs[locateFieldCombinations2Info_,originalFields_,allOriginalFields_,subGroup_,subFieldsOfInterest_,nVevs_]:=Module[{singletState,singletPositions,vevsPositions,oC,oPrime,n,flavors,pFields,vevsNames,effectiveCouplings,result},

n=Length[subFieldsOfInterest];
singletState=If[#==={},0,#]&/@(ConstantArray[0,Length[#]]&/@subGroup);
singletPositions=Flatten[Position[subFieldsOfInterest,singletState]];
vevsPositions=Subsets[singletPositions,{nVevs}];
oC=Join[Sort[Complement[Range[n],#]],#]&/@vevsPositions;

oPrime=locateFieldCombinations2Info[[3,#]]&/@oC;
flavors=Table[ToExpression["f\[UnderBracket]"<>ToString[i]],{i,n}];

pFields=Flatten[Position[allOriginalFields,#]&/@originalFields];

vevsNames=locateFieldCombinations2Info[[2,#[[-nVevs;;-1]]]]&/@oC;
effectiveCouplings=locateFieldCombinations2Info[[2,#[[1;;-nVevs-1]]]]&/@oC;
vevsNames=(Times@@(v@@@Transpose[{#,flavors[[-nVevs;;-1]]}]))&/@vevsNames;

result=(Sum[p[pFields,(*Append[pFields,inv],*)inv,flavors[[invertOrdering[#]]]]locateFieldCombinations2Info[[4,inv]],{inv,Length[locateFieldCombinations2Info[[4]]]}]&/@oPrime)vevsNames;
result=MapThread[List,{effectiveCouplings,result}];
result=Gather[result,#1[[1]]==#2[[1]]&];
result={#[[1,1]],Total[#[[All,2]]]}&/@result;

Return[result];
]


effectiveInteractionContributionAfterVEVs[group_,reps_,subgroup_,breakingInfo_,nMin_,nMax_,subReps_]:=Module[{iValues,result,aux,CBcoefficients,singletState,nVevs,subFieldsMod,projectionMatrix,pSubFields,effectiveCouplings,nInvs},
tmp=TimeUsed[];
result={};
singletState=If[#==={},0,#]&/@(ConstantArray[0,Length[#]]&/@subgroup);
nInvs=ReduceRepProduct[subgroup,subReps];
nInvs=Cases[nInvs,x_/;x[[1]]==singletState:>x[[2]]];
nInvs=If[Length[nInvs]>0,nInvs[[1]],0];

Do[
iValues=DeleteCases[Tuples[Range[Length[reps]],n],x_/;!OrderedQ[x]];

aux=MemberQ[ReduceRepProduct[group,reps[[#]]],x_/;x[[1]]==0x[[1]]]&/@iValues;
iValues=iValues[[Flatten[Position[aux,True]]]];

Do[
PrintVar[iEl];PrintVar[TimeUsed[]-tmp];

CBcoefficients=SubgroupEmbeddingCoefficients[group,reps[[iEl]],subgroup,breakingInfo];
If[Length[CBcoefficients]>0,

nVevs=n-Length[subReps];
subFieldsMod=Join[subReps,ConstantArray[singletState,nVevs]];

aux=locateFieldCombinations[CBcoefficients,reps[[iEl]],reps,subFieldsMod];(*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA*)

AppendTo[result,addVevs[#,reps[[iEl]],reps,subgroup,subFieldsMod,nVevs]&/@aux];

(* result+=aux; *)
];
,{iEl,iValues}];
,{n,nMin,nMax}];

result=Flatten[result,2];


If[subReps==={}, (* Just VEVs *)
Return[Total[result[[All,2,1]]]];
];


(* Generate the list of subfields with the given subrepresentations *)
aux=SubgroupEmbeddingCoefficients[group,{If[#==={},0,#]&/@(ConstantArray[0,Length[#]]&/@group)},subgroup,breakingInfo];
projectionMatrix=aux[[2,2]]; (* Projection matrix *)

aux=DecomposeRep[group,#,subgroup,projectionMatrix]&/@reps;

pSubFields=Position[aux,#]&/@subReps;


If[nInvs==1,
effectiveCouplings=ConstantArray[0,Length/@pSubFields];
Do[
effectiveCouplings=ReplacePart[effectiveCouplings,{el[[1]]->el[[2,1]]+((effectiveCouplings[[##]]&)@@el[[1]])}];
,{el,result}];

,
effectiveCouplings=ConstantArray[ConstantArray[0,nInvs],Length/@pSubFields];
Do[
effectiveCouplings=ReplacePart[effectiveCouplings,{el[[1]]->el[[2]]+((effectiveCouplings[[##]]&)@@el[[1]])}];
,{el,result}];
];

(*
PrintVar[pSubFields];
pSubFields=InverseFlatten[Tuples[pSubFields],Length/@pSubFields];
PrintVar[result];
PrintVar[pSubFields];
*)

Return[effectiveCouplings];
]


End[];
EndPackage[];
