(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     16420,        563]
NotebookOptionsPosition[     12505,        436]
NotebookOutlinePosition[     14245,        483]
CellTagsIndexPosition[     14160,        478]
WindowTitle->Weights - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/Weights\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/Weights"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/Weights.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", "Susyno/ref/Weights",
              ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["Weights", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Weights", "[", 
       RowBox[{"group", ",", " ", "rep"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]Computes the weights of the representation ",
     Cell[BoxData["rep"], "InlineFormula"],
     " of ",
     Cell[BoxData["group"], "InlineFormula"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->152580603],

Cell[TextData[{
 Cell[BoxData["group"], "InlineFormula"],
 " should be a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Just as in SU(2), where a representation with spin ",
 Cell[BoxData["s"], "InlineFormula"],
 " breaks down into subspaces, each with a quantum number ",
 Cell[BoxData["m"], "InlineFormula"],
 ", in general a representation ",
 Cell[BoxData["rep"], "InlineFormula"],
 " of ",
 Cell[BoxData["group"], "InlineFormula"],
 " breaks down into subspaces labelled by some integers {2",
 Cell[BoxData[
  SubscriptBox["m", "1"]], "InlineFormula"],
 ", 2",
 Cell[BoxData[
  SubscriptBox["m", "2"]], "InlineFormula"],
 ", \[CenterEllipsis]}. Each such list of numbers is a weight."
}], "Notes",
 CellID->527568177],

Cell[TextData[{
 "In contrast to SU(2), each subspace with weight {2",
 Cell[BoxData[
  SubscriptBox["m", "1"]], "InlineFormula"],
 ", 2",
 Cell[BoxData[
  SubscriptBox["m", "2"]], "InlineFormula"],
 ", \[CenterEllipsis]} may have more than one dimension (it can be \
degenerate). See a Lie Algebra book for more information."
}], "Notes",
 CellID->403473388],

Cell[TextData[{
 "Given the previous remarks, this function outputs a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["w", "1"], ",", 
      SubscriptBox["d", "1"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["w", "2"], ",", 
      SubscriptBox["d", "2"]}], "}"}], ",", "..."}], "}"}]], "InlineFormula"],
 " where the ",
 Cell[BoxData[
  RowBox[{"w", "'"}]], "InlineFormula"],
 "s are the weights and the ",
 Cell[BoxData["d"], "InlineFormula"],
 "'s are their degeneracy. "
}], "Notes",
 CellID->217674061]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->252419250],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->29734589],

Cell["Consider an SU(2) doublet [={1}],", "ExampleText",
 CellID->513681956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Weights", "[", 
  RowBox[{"SU2", ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196926373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"-", "1"}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433613712]
}, Open  ]],

Cell["\<\
This tells us that the representation {1} of SU(2) has weights {1} and {-1} \
with no degeneracy (each space is one dimensional). The pattern (for SU(2) \
only!) starts to show up. First, a representation traditionally labeled by a \
spin s is in this canonical formalism called {2s}. So there are \
representations {0}, {1}, {2}, ... Second, the traditional quantum number m \
is in this canonical formalism called weight {2m}. So instead of \
representation s=1/2 having m=-1/2, m=1/2 we have representation {1} having \
weights {-1} and {1}. Just to confirm, the weights of a triplet are...\
\>", "ExampleText",
 CellID->320563739],

Cell[CellGroupData[{

Cell["Weights[SU2, {2}]", "Input",
 CellLabel->"In[2]:=",
 CellID->184065572],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"-", "2"}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->227368614]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->372245671],

Cell["A more interesting example is the adjoint [={1,1}] of SU(3):", \
"ExampleText",
 CellID->288896476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Weights", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->381111280],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1430384]
}, Open  ]],

Cell["\<\
There are only 7 distinct weights and one of them, {0,0}, is a two \
dimensional space. So the dimensions add up: the dimension of the SU(3) \
adjoint representation is 1+1+1+2+1+1+1=8.\
\>", "ExampleText",
 CellID->303695508]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268928953],

Cell[TextData[{
 "Note that the Dynkin coefficients of a representation are equal to the \
highest weight of the representation\[LongDash]this might be the first one \
returned by the ",
 Cell[BoxData["Weights"], "InlineFormula"],
 " function, or the last one. In the following example, it is the first one:"
}], "ExampleText",
 CellID->26424378],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<Highest weight of representation {3,5} of the group G(2):\>\"", "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Weights", "[", 
   RowBox[{"G2", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5"}], "}"}]}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->503951977],

Cell[BoxData["\<\"Highest weight of representation {3,5} of the group G(2):\"\
\>"], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->45127434],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "5"}], "}"}]], "Output",
 ImageSize->{43, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->740701]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 729},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Weights - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2014, 12, 18, 10, 47, 56.3450395}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "Weights[group, rep] Computes the weights of the representation rep of \
group", "synonyms" -> {}, "title" -> "Weights", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/Weights"}, "LinkTrails" -> "", "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "9.0 for Microsoft Windows (64-bit) (January 25, 2013)", 
  StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "10.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion.nb", CharacterEncoding -> "WindowsANSI"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6189, 196, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->252419250]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14017, 471}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[600, 21, 76, 1, 70, "SymbolColorBar"],
Cell[679, 24, 178, 5, 70, "LinkTrail"],
Cell[860, 31, 2293, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[3156, 86, 50, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[CellGroupData[{
Cell[3231, 91, 518, 15, 70, "Usage",
 CellID->982511436],
Cell[CellGroupData[{
Cell[3774, 110, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->152580603],
Cell[4357, 129, 212, 8, 70, "Notes",
 CellID->1067943069],
Cell[4572, 139, 620, 17, 70, "Notes",
 CellID->527568177],
Cell[5195, 158, 359, 10, 70, "Notes",
 CellID->403473388],
Cell[5557, 170, 583, 20, 70, "Notes",
 CellID->217674061]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6189, 196, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->252419250],
Cell[CellGroupData[{
Cell[6675, 213, 147, 5, 70, "ExampleSection",
 CellID->29734589],
Cell[6825, 220, 76, 1, 70, "ExampleText",
 CellID->513681956],
Cell[CellGroupData[{
Cell[6926, 225, 152, 5, 70, "Input",
 CellID->196926373],
Cell[7081, 232, 376, 14, 36, "Output",
 CellID->433613712]
}, Open  ]],
Cell[7472, 249, 644, 10, 70, "ExampleText",
 CellID->320563739],
Cell[CellGroupData[{
Cell[8141, 263, 77, 2, 70, "Input",
 CellID->184065572],
Cell[8221, 267, 461, 17, 36, "Output",
 CellID->227368614]
}, Open  ]],
Cell[CellGroupData[{
Cell[8719, 289, 125, 3, 70, "ExampleDelimiter",
 CellID->372245671],
Cell[8847, 294, 105, 2, 70, "ExampleText",
 CellID->288896476],
Cell[CellGroupData[{
Cell[8977, 300, 177, 6, 70, "Input",
 CellID->381111280],
Cell[9157, 308, 1104, 41, 54, "Output",
 CellID->1430384]
}, Open  ]],
Cell[10276, 352, 236, 5, 70, "ExampleText",
 CellID->303695508]
}, Open  ]],
Cell[CellGroupData[{
Cell[10549, 362, 125, 3, 70, "ExampleDelimiter",
 CellID->268928953],
Cell[10677, 367, 346, 7, 70, "ExampleText",
 CellID->26424378],
Cell[CellGroupData[{
Cell[11048, 378, 407, 14, 70, "Input",
 CellID->503951977],
Cell[11458, 394, 156, 3, 70, "Print",
 CellID->45127434],
Cell[11617, 399, 200, 7, 36, "Output",
 CellID->740701]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11890, 414, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[12312, 428, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[12478, 434, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

