(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    243318,       5949]
NotebookOptionsPosition[    235227,       5700]
NotebookOutlinePosition[    237889,       5759]
CellTagsIndexPosition[    237802,       5754]
WindowTitle->SubgroupEmbeddingCoefficients - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->
         False], {"\<\"Susyno/ref/SubgroupEmbeddingCoefficients\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/SubgroupEmbeddingCoefficients"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
SubgroupEmbeddingCoefficients.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/SubgroupEmbeddingCoefficients", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["SubgroupEmbeddingCoefficients", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SubgroupEmbeddingCoefficients", "[", 
       RowBox[{
       "group", ",", " ", "representationsList", ",", "subgroup", ",", 
        "breakingInfo"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]For some ",
     Cell[BoxData["subgroup"], "InlineFormula"],
     " of ",
     Cell[BoxData["group"], "InlineFormula"],
     ", and for the product of representations of ",
     Cell[BoxData["group"], "InlineFormula"],
     " in ",
     Cell[BoxData["representationsList"], "InlineFormula"],
     ", this functions calculates the relation amongst the \
invariants/Clebsch-Gordon coefficients of ",
     Cell[BoxData["subgroup"], "InlineFormula"],
     " imposed by the remaining symmetry generators of ",
     Cell[BoxData["group"], "InlineFormula"],
     " which are not part of ",
     Cell[BoxData["subgroup"], "InlineFormula"],
     ".\[LineSeparator]\[LineSeparator]Quick example: the 16 and 10 of SO(10) \
form the a trilinear invariant (16 x 16 x 10). Under the subgroup ",
     Cell[BoxData[
      SubscriptBox["G", "SM"]], "InlineFormula"],
     "=SU(3)xSU(2)xU(1) of SO(10), these representations break into various \
irreducible representations of  ",
     Cell[BoxData[
      SubscriptBox["G", "SM"]], "InlineFormula"],
     ", and a total of 17 terms invariant only under  ",
     Cell[BoxData[
      SubscriptBox["G", "SM"]], "InlineFormula"],
     " can be written with these  ",
     Cell[BoxData[
      SubscriptBox["G", "SM"]], "InlineFormula"],
     "-representations. Since there is only one invariant under the full \
group, SO(10), the coefficients of these 17 ",
     Cell[BoxData[
      SubscriptBox["G", "SM"]], "InlineFormula"],
     "-invariant terms must be related in an SO(10)-symmetric scenario. ",
     Cell[BoxData["SubgroupEmbeddingCoefficients"], "InlineFormula"],
     " returns such relations."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->45508745],

Cell[TextData[{
 Cell[BoxData["group"], "InlineFormula"],
 " and ",
 Cell[BoxData["subgroup"], "InlineFormula"],
 " must be lists of simple/U(1) factor groups:   ",
 Cell[BoxData[
  RowBox[{"group", "=", 
   RowBox[{"{", 
    RowBox[{"G1", ",", "G2", ",", "..."}], "}"}]}]], "InlineFormula"],
 ",  ",
 Cell[BoxData[
  RowBox[{"subgroup", "=", 
   RowBox[{"{", 
    RowBox[{"H1", ",", "H2", ",", "..."}], "}"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->810218094],

Cell[TextData[{
 Cell[BoxData["representationsList"], "InlineFormula"],
 " must be a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"R1", ",", "R2", ",", "..."}], "}"}]], "InlineFormula"],
 " of representations of ",
 Cell[BoxData["group"], "InlineFormula"],
 ", such that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"R1", " ", "x", " ", "R2", " ", "x"}], " ", "..."}]], 
  "InlineFormula"],
 " contains one or more ",
 " ",
 Cell[BoxData["group"], "InlineFormula"],
 " singlets."
}], "Notes",
 CellID->31258817],

Cell[TextData[{
 Cell[BoxData["breakingInformation"], "InlineFormula"],
 " should contain the information about which dots of the Dynkin diagram of ",
 Cell[BoxData["group"], "InlineFormula"],
 " are to be dropped and if the diagram is to be extended or not. It is the \
same as in the function ",
 Cell[BoxData[
  ButtonBox["RegularSubgroupProjectionMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/RegularSubgroupProjectionMatrix"]], 
  "InlineFormula"],
 " \[LongDash] see the examples contained in its documentation.  "
}], "Notes",
 CellID->232483187],

Cell[TextData[{
 "The output of this function is complicated and is better explained by \
example \[LongDash] see below. However, the general picture is the following.\
\[LineSeparator]\[LineSeparator]For each representation R of ",
 Cell[BoxData["group"], "InlineFormula"],
 ", the representation matrices are known in an explicit basis (with ",
 Cell[BoxData[
  ButtonBox["RepMatrices",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/RepMatrices"]], "InlineFormula"],
 "). We can call them ",
 Cell[BoxData[
  SuperscriptBox["T", "a"]], "InlineFormula"],
 "(R). The decomposition of R into irreducible representations ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R", "'"}], ")"}], "i"]], "InlineFormula"],
 " of ",
 Cell[BoxData["subgroup"], "InlineFormula"],
 " is also know (with ",
 Cell[BoxData[
  ButtonBox["DecomposeRep",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/DecomposeRep"]], "InlineFormula"],
 ") and the explicit basis for these matrices can be obtained (again, with ",
 Cell[BoxData[
  ButtonBox["RepMatrices",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/RepMatrices"]], "InlineFormula"],
 "): we get the  ",
 Cell[BoxData[
  SuperscriptBox["T", "b"]], "InlineFormula"],
 "(",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R", "'"}], ")"}], "i"]], "InlineFormula"],
 ") matrices. We may place these  ",
 Cell[BoxData[
  SuperscriptBox["T", "b"]], "InlineFormula"],
 "(",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R", "'"}], ")"}], "1"]], "InlineFormula"],
 "), ",
 Cell[BoxData[
  SuperscriptBox["T", "b"]], "InlineFormula"],
 "(",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R", "'"}], ")"}], "2"]], "InlineFormula"],
 "), ... matrices as diagonal blocks of matrices ",
 Cell[BoxData[
  SuperscriptBox["T", "b"]], "InlineFormula"],
 "(R') which have the same dimensions as the ",
 Cell[BoxData[
  SuperscriptBox["T", "a"]], "InlineFormula"],
 "(R).\[LineSeparator]\[LineSeparator]How are the matrices  ",
 Cell[BoxData[
  SuperscriptBox["T", "a"]], "InlineFormula"],
 "(R) related to  ",
 Cell[BoxData[
  SuperscriptBox["T", "b"]], "InlineFormula"],
 "(R')? We need to a) take a linear combination ",
 Cell[BoxData[
  SubscriptBox["c", "ba"]], "InlineFormula"],
 " of the  ",
 Cell[BoxData[
  SuperscriptBox["T", "a"]], "InlineFormula"],
 "(R) matrices (the same for any representation R) and b) change the basis of \
the  ",
 Cell[BoxData[
  SuperscriptBox["T", "a"]], "InlineFormula"],
 "(R) with a unitary matrix ",
 Cell[BoxData[
  RowBox[{"B", 
   RowBox[{"(", "R", ")"}]}]], "InlineFormula"],
 " such that these matrices become block diagonal, with the blocks given by \
the ",
 Cell[BoxData[
  SuperscriptBox["T", "b"]], "InlineFormula"],
 "(",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R", "'"}], ")"}], "i"]], "InlineFormula"],
 "). In other words,\[LineSeparator]\[LineSeparator]",
 Cell[BoxData[
  SuperscriptBox["T", "b"]], "InlineFormula"],
 "(",
 Cell[BoxData[
  RowBox[{"R", "'"}]], "InlineFormula"],
 ")=",
 Cell[BoxData[
  SubscriptBox["c", "ba"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  RowBox[{"B", 
   SuperscriptBox[
    RowBox[{"(", "R", ")"}], "\[Dagger]"]}]], "InlineFormula"],
 ".",
 Cell[BoxData[
  SuperscriptBox["T", "a"]], "InlineFormula"],
 "(R).B(R)  (sum over b).\[LineSeparator]\[LineSeparator]Susyno can calculate \
both ",
 Cell[BoxData[
  SubscriptBox["c", "ba"]], "InlineFormula"],
 " for any regular group embedding, and the matrix B(R) for any \
representation. As such, the program is aware of how the sub-representations \
are exactly/explicitly embedded in each representation of ",
 Cell[BoxData["group"], "InlineFormula"],
 ". \[LineSeparator]\[LineSeparator]Thus, given a list of representations R1, \
R2, ... of  ",
 Cell[BoxData["group"], "InlineFormula"],
 " such that R1 x R2 x ... contains group invariants, it can compute all the ",
 Cell[BoxData["group"], "InlineFormula"],
 " invariants/Clebsch-Gordon coefficients ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox["c", "a"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula"],
 " such that\[LineSeparator]\[LineSeparator] ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox["c", "a"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula"],
 " R1[i1] R2[i2] ... (sum over the components i1, i2,...)\[LineSeparator]\
\[LineSeparator]are ",
 Cell[BoxData["group"], "InlineFormula"],
 "-invariants. Here, Rj[i] refers to the component i of the \
field/representation Rj. Also, because there might be more than one \
invariant, the index a=1,2,... was added.\[LineSeparator]\[LineSeparator]But \
Susyno can also calculate the ",
 Cell[BoxData["subgroup"], "InlineFormula"],
 " invariants/Clebsch-Gordon coefficients of the form \[LineSeparator]\
\[LineSeparator] ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox[
    RowBox[{"c", "'"}], "b"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula"],
 "(x1,x2,...) ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R1", "'"}], ")"}], "x1"]], "InlineFormula"],
 "[i1] ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R2", "'"}], ")"}], "x2"]], "InlineFormula"],
 "[i1]  ... (sum over the components i1, i2,...)\[LineSeparator]\
\[LineSeparator]in the basis where the fields ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"Ri", "'"}], ")"}], "xi"]], "InlineFormula"],
 " are rotated by the ",
 Cell[BoxData[
  RowBox[{"B", 
   SuperscriptBox[
    RowBox[{"(", "Ri", ")"}], "\[Dagger]"]}]], "InlineFormula"],
 " matrices (as opposed to rotating the Ri by  ",
 Cell[BoxData[
  RowBox[{"B", 
   RowBox[{"(", "Ri", ")"}]}]], "InlineFormula"],
 "). Note that we get in general many of these invariants ",
 Cell[BoxData[
  RowBox[{"c", "'"}]], "InlineFormula"],
 " because we have to consider all combinations of the x1, x2, ... which will \
form ",
 Cell[BoxData["subgroup"], "InlineFormula"],
 " invariants (in other words, the representations of ",
 Cell[BoxData["group"], "InlineFormula"],
 " break into many pieces/representations of ",
 Cell[BoxData["subgroup"], "InlineFormula"],
 ", and we have to look for all invariants formed from these pieces).\
\[LineSeparator]\[LineSeparator]So, for each  ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox["c", "a"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula"],
 " (symmetric under ",
 Cell[BoxData["group"], "InlineFormula"],
 "), there are many  ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox[
    RowBox[{"c", "'"}], "b"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula"],
 "(x1,x2,...)  (symmetric under just ",
 Cell[BoxData["subgroup"], "InlineFormula"],
 "). Clearly the coefficients  ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox["c", "a"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox[
    RowBox[{"c", "'"}], "b"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula"],
 "(x1,x2,...) are related by the group generators of ",
 Cell[BoxData["group"], "InlineFormula"],
 " which are not part of  ",
 Cell[BoxData["subgroup"], "InlineFormula"],
 ", and so we get:\[LineSeparator]\[LineSeparator]",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox["c", "a"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula"],
 "=",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox["k", "ab"], 
   RowBox[{
    RowBox[{"x1", " ", "x2"}], " ", "..."}]]], "InlineFormula"],
 " ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox[
    RowBox[{"c", "'"}], "b"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula"],
 "(x1,x2,...) (sum over x1,x2...)\[LineSeparator]\[LineSeparator]for some \
embedding coefficients ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox["k", "ab"], 
   RowBox[{
    RowBox[{"x1", " ", "x2"}], " ", "..."}]]], "InlineFormula"],
 ". These numbers ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox["k", "ab"], 
   RowBox[{
    RowBox[{"x1", " ", "x2"}], " ", "..."}]]], "InlineFormula"],
 " are the main output of this function ",
 Cell[BoxData["SubgroupEmbeddingCoefficients"], "InlineFormula"],
 ". Indeed the output of the function is of the form\[LineSeparator]\
\[LineSeparator]{{",
 Cell[BoxData["Inv"], "InlineFormula"],
 ",{",
 Cell[BoxData[
  RowBox[{"B", 
   RowBox[{"(", "R1", ")"}]}]], "InlineFormula"],
 ",",
 Cell[BoxData[
  RowBox[{"B", 
   RowBox[{"(", "R2", ")"}]}]], "InlineFormula"],
 ",...}},{group,projectionMatrix,{<list of ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R1", "'"}], ")"}], "i"]], "InlineFormula"],
 " in R1>, <list of ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R2", "'"}], ")"}], "i"]], "InlineFormula"],
 " in R2>, ...},<list with the information of which combinations of ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"Rj", "'"}], ")"}], "i"]], "InlineFormula"],
 " form ",
 Cell[BoxData["subgroup"], "InlineFormula"],
 " invariants>, ",
 Cell[BoxData[
  SubscriptBox["k", 
   RowBox[{"ij", "..."}]]], "InlineFormula"],
 "}."
}], "Notes",
 CellID->45496372],

Cell["Output format of this function may change in the future.", "Notes",
 CellID->421525536]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->158588049],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->5853172],

Cell["\<\
Consider how the product 16 x 16 x 10 in SO(10) looks under the subgroup \
SU(3)xSU(2)xU(1):\
\>", "ExampleText",
 CellID->19615827],

Cell[BoxData[{
 RowBox[{
  RowBox[{"group", "=", 
   RowBox[{"{", "SO10", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rep16", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rep10", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"subgroup", "=", 
   RowBox[{"{", 
    RowBox[{"SU3", ",", "SU2", ",", "U1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"breakInfo", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"{", "4", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "6"}]}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result", "=", 
   RowBox[{"SubgroupEmbeddingCoefficients", "[", 
    RowBox[{"group", ",", 
     RowBox[{"{", 
      RowBox[{"rep16", ",", "rep16", ",", "rep10"}], "}"}], ",", "subgroup", 
     ",", "breakInfo"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->85442412],

Cell[TextData[{
 "The output was saved to the variable ",
 Cell[BoxData["result"], "InlineFormula"],
 ". Let us look at its important parts:  ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]], "InlineFormula"],
 " contains just the invariants/Clebsch-Gordon coefficients (one in this \
case) of 16 x 16 x 10 in SO(10), exactly as given by the ",
 Cell[BoxData[
  ButtonBox["Invariants",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/Invariants"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->147360266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->276648439],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "80", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 80, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "16", ",", "16", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->95027590]
}, Open  ]],

Cell["Notice the normalization of the coefficients:", "ExampleText",
 CellID->240482480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"result", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1"}], "]"}], "]"}], ".", 
    RowBox[{"Array", "[", 
     RowBox[{"c", ",", "10"}], "]"}], ".", 
    RowBox[{"Array", "[", 
     RowBox[{"b", ",", "16"}], "]"}], ".", 
    RowBox[{"Array", "[", 
     RowBox[{"a", ",", "16"}], "]"}]}], "//", "Expand"}], "//", 
  RowBox[{
   RowBox[{"Short", "[", 
    RowBox[{"#", ",", "4"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->259293861],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"a", "[", "8", "]"}], " ", 
     RowBox[{"b", "[", "1", "]"}], " ", 
     RowBox[{"c", "[", "1", "]"}]}], "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"a", "[", "7", "]"}], " ", 
     RowBox[{"b", "[", "2", "]"}], " ", 
     RowBox[{"c", "[", "1", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"a", "[", "6", "]"}], " ", 
     RowBox[{"b", "[", "3", "]"}], " ", 
     RowBox[{"c", "[", "1", "]"}]}], "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"a", "[", "5", "]"}], " ", 
     RowBox[{"b", "[", "4", "]"}], " ", 
     RowBox[{"c", "[", "1", "]"}]}], "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"a", "[", "4", "]"}], " ", 
     RowBox[{"b", "[", "5", "]"}], " ", 
     RowBox[{"c", "[", "1", "]"}]}], "+", 
    RowBox[{"\[LeftSkeleton]", "108", "\[RightSkeleton]"}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"a", "[", "11", "]"}], " ", 
     RowBox[{"b", "[", "14", "]"}], " ", 
     RowBox[{"c", "[", "10", "]"}]}], "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"a", "[", "10", "]"}], " ", 
     RowBox[{"b", "[", "15", "]"}], " ", 
     RowBox[{"c", "[", "10", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"a", "[", "9", "]"}], " ", 
     RowBox[{"b", "[", "16", "]"}], " ", 
     RowBox[{"c", "[", "10", "]"}]}]}], "}"}],
  Short[#, 4]& ]], "Output",
 ImageSize->{519, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//Short=",
 CellID->394806322]
}, Open  ]],

Cell[TextData[{
 "Now, ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "2"}], "]"}], "]"}]], "InlineFormula"],
 " is more interesting: it contains the rotations matrices needed to block \
diagonalize the representations 16, 16, 10 of SO(10) (as given by ",
 Cell[BoxData[
  ButtonBox["RepMatrices",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/RepMatrices"]], "InlineFormula"],
 "), with the blocks being the representation matrices under SU(3)xSU(2)xU(1) \
(as given by ",
 Cell[BoxData[
  ButtonBox["RepMatrices",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/RepMatrices"]], "InlineFormula"],
 ") after suitable linear combinations of the SO(10) [not shown in the \
output] are taken:"
}], "ExampleText",
 CellID->490834723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->27134387],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        RowBox[{"-", "1"}], "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", 
        RowBox[{"-", "1"}], "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", 
        RowBox[{"-", "1"}], "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0"},
       {"0", 
        RowBox[{"-", "1"}], "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0"},
       {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[
     SparseArray[
      Automatic, {16, 16}, 0, {
       1, {{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {{
         14}, {13}, {7}, {10}, {8}, {11}, {6}, {5}, {9}, {12}, {4}, {3}, {
         2}, {1}, {15}, {16}}}, {-1, 1, 1, 1, 1, 1, -1, 1, 1, 1, 1, -1, -1, 1,
         1, 1}}]]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        RowBox[{"-", "1"}], "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", 
        RowBox[{"-", "1"}], "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", 
        RowBox[{"-", "1"}], "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0"},
       {"0", 
        RowBox[{"-", "1"}], "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0"},
       {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[
     SparseArray[
      Automatic, {16, 16}, 0, {
       1, {{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {{
         14}, {13}, {7}, {10}, {8}, {11}, {6}, {5}, {9}, {12}, {4}, {3}, {
         2}, {1}, {15}, {16}}}, {-1, 1, 1, 1, 1, 1, -1, 1, 1, 1, 1, -1, -1, 1,
         1, 1}}]]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0", "0", "1", "0", "0", "0", "0"},
       {"0", "0", "0", "0", 
        RowBox[{"-", "1"}], "0", "0", "0", "0", "0"},
       {"0", "0", "0", "1", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "1", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "1", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "1", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "1"},
       {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "1", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "1", "0", "0", "0", "0", "0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[
     SparseArray[
      Automatic, {10, 10}, 0, {
       1, {{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {{6}, {5}, {4}, {7}, {9}, {
         8}, {10}, {1}, {2}, {3}}}, {1, -1, 1, 1, 1, 1, 1, 1, 1, 1}}]]]]}], 
  "}"}]], "Output",
 ImageSize->{484, 489},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->847649793]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}]], "InlineFormula"],
 " just returns the group given as input, and ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "2"}], "]"}], "]"}]], "InlineFormula"],
 " is the projection matrix derived by the program (see ",
 Cell[BoxData[
  ButtonBox["RegularSubgroupProjectionMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/RegularSubgroupProjectionMatrix"]], 
  "InlineFormula"],
 "). So we move on to ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "3"}], "]"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->985435234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->148666411],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       FractionBox["1", "6"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", 
       RowBox[{"-", 
        FractionBox["2", "3"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", 
       FractionBox["1", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       FractionBox["1", "6"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", 
       RowBox[{"-", 
        FractionBox["2", "3"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", 
       FractionBox["1", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", 
       RowBox[{"-", 
        FractionBox["1", "3"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", 
       FractionBox["1", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{511, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->474393384]
}, Open  ]],

Cell[TextData[{
 "This is the list of representations of the subgroup found in the \
representations {16,16,10} of SO(10), respectively (see ",
 Cell[BoxData[
  ButtonBox["DecomposeRep",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/DecomposeRep"]], "InlineFormula"],
 " for details). To better see it, use ",
 Cell[BoxData[
  ButtonBox["RepName",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/RepName"]], "InlineFormula"]
}], "ExampleText",
 CellID->4552369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"RepName", "[", 
     RowBox[{"subgroup", ",", "#"}], "]"}], "&"}], ",", 
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->522541032],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      StyleBox["\<\"3\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", 
      StyleBox["\<\"2\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/6\\)\"\>"}], ",", 
     RowBox[{
      OverscriptBox[
       StyleBox["\<\"3\"\>",
        StripOnInput->False,
        FontWeight->Bold], "_"], "\[CircleTimes]", 
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], 
      "\[CircleTimes]", "\<\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\"\>"}], ",", 
     RowBox[{
      OverscriptBox[
       StyleBox["\<\"3\"\>",
        StripOnInput->False,
        FontWeight->Bold], "_"], "\[CircleTimes]", 
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/3\\)\"\>"}], ",", 
     RowBox[{
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", 
      StyleBox["\<\"2\"\>",
       StripOnInput->False,
       FontWeight->Bold], 
      "\[CircleTimes]", "\<\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\"\>"}], ",", 
     RowBox[{
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", 
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(0\\)\"\>"}], ",", 
     RowBox[{
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", 
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\)\"\>"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      StyleBox["\<\"3\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", 
      StyleBox["\<\"2\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/6\\)\"\>"}], ",", 
     RowBox[{
      OverscriptBox[
       StyleBox["\<\"3\"\>",
        StripOnInput->False,
        FontWeight->Bold], "_"], "\[CircleTimes]", 
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], 
      "\[CircleTimes]", "\<\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\"\>"}], ",", 
     RowBox[{
      OverscriptBox[
       StyleBox["\<\"3\"\>",
        StripOnInput->False,
        FontWeight->Bold], "_"], "\[CircleTimes]", 
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/3\\)\"\>"}], ",", 
     RowBox[{
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", 
      StyleBox["\<\"2\"\>",
       StripOnInput->False,
       FontWeight->Bold], 
      "\[CircleTimes]", "\<\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\"\>"}], ",", 
     RowBox[{
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", 
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(0\\)\"\>"}], ",", 
     RowBox[{
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", 
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\)\"\>"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      StyleBox["\<\"3\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", 
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], 
      "\[CircleTimes]", "\<\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\"\>"}], ",", 
     RowBox[{
      OverscriptBox[
       StyleBox["\<\"3\"\>",
        StripOnInput->False,
        FontWeight->Bold], "_"], "\[CircleTimes]", 
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/3\\)\"\>"}], ",", 
     RowBox[{
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", 
      StyleBox["\<\"2\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/2\\)\"\>"}], ",", 
     RowBox[{
      StyleBox["\<\"1\"\>",
       StripOnInput->False,
       FontWeight->Bold], "\[CircleTimes]", 
      StyleBox["\<\"2\"\>",
       StripOnInput->False,
       FontWeight->Bold], 
      "\[CircleTimes]", "\<\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\"\>"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{379, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->38959301]
}, Open  ]],

Cell[TextData[{
 "The position of the sub-representations shown is important in the \
following:\[LineSeparator]the #1 subrep of the 16 is 3x2x1/6, #2 is ",
 Cell[BoxData[
  OverscriptBox["3", "_"]], "InlineFormula"],
 "x1x-2/3, etc...\[LineSeparator]the #1 subrep of the 16 is 3x2x1/6, #2 is ",
 Cell[BoxData[
  OverscriptBox["3", "_"]], "InlineFormula"],
 "x1x-2/3, etc...\[LineSeparator]the #1 subrep of the 10 is 3x1x-1/3, #2 is ",
 Cell[BoxData[
  OverscriptBox["3", "_"]], "InlineFormula"],
 "x1x1/3, etc...\[LineSeparator]\[LineSeparator]Now, we look at ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "4"}], "]"}], "]"}]], "InlineFormula"],
 ", or, without loosing information, just at"
}], "ExampleText",
 Deletable->True,
 CellID->49186995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", "4", ",", "All", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->97988462],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "4"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "3"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "6", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "4"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "5", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "3"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "6", ",", "4"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "3", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "4", ",", "3"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "2", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "4", ",", "4"}], "}"}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{508, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->180110237]
}, Open  ]],

Cell[TextData[{
 "What this tells is that the ...\[LineSeparator]- (",
 StyleBox["#1",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the first rep [the 16]) x (",
 StyleBox["#1",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the second rep [the 16]) x (",
 StyleBox["#1",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the third rep [the 10]) contains ",
 StyleBox["one",
  FontColor->RGBColor[0.5, 0, 0.5]],
 " subgroup [SU3xSU2xU1] invariant\[LineSeparator]- (",
 StyleBox["#1",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the first rep [the 16]) x (",
 StyleBox["#2",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the second rep [the 16]) x (",
 StyleBox["#3",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the third rep [the 10]) contains ",
 StyleBox["one",
  FontColor->RGBColor[0.5, 0, 0.5]],
 " subgroup [SU3xSU2xU1] invariant\[LineSeparator]- (",
 StyleBox["#1",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the first rep [the 16]) x (",
 StyleBox["#3",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the second rep [the 16]) x (",
 StyleBox["#4",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the third rep [the 10]) contains ",
 StyleBox["one",
  FontColor->RGBColor[0.5, 0, 0.5]],
 " subgroup [SU3xSU2xU1] invariant\[LineSeparator]...\[LineSeparator]- (",
 StyleBox["#6",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the first rep [the 16]) x (",
 StyleBox["#4",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the second rep [the 16]) x (",
 StyleBox["#4",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the third rep [the 10]) contains ",
 StyleBox["one",
  FontColor->RGBColor[0.5, 0, 0.5]],
 " subgroup [SU3xSU2xU1] invariant\[LineSeparator]\[LineSeparator]In total \
then, there are 17 SU(3)xSU(2)xU(1) invariants in the 16 x 16 x 10 SO(10) \
invariant. To see more clearly the SU(3)xSU(2)xU(1) representations involved \
in each, we can write the following:"
}], "ExampleText",
 Deletable->True,
 CellID->137870151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"RepName", "[", 
     RowBox[{"subgroup", ",", "#"}], "]"}], "&"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Extract", "[", 
      RowBox[{
       RowBox[{"result", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", "#"}], "]"}], "&"}], "/@", 
    RowBox[{"result", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "4", ",", "All", ",", "2"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->55378935],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnUuO7Mxxha9sDbwET72NO7OWIK9AAlRTA7IBQaO7hZp43LvozdRiyrfI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    "], {{0, 280}, {405, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{405, 280},
  PlotRange->{{0, 405}, {0, 280}}]], "Output",
 ImageSize->{409, 280},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->3614242]
}, Open  ]],

Cell[TextData[{
 "All these 17 products provide just a single SU(3)xSU(2)xU(1) invariant (see \
",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "4"}], "]"}], "]"}]], "InlineFormula"],
 " above), but in general this is might not be the case. So the following, \
more complicated code is safer, as it will take into account this potential \
multiplicity:"
}], "ExampleText",
 Deletable->True,
 CellID->332102819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"RepName", "[", 
     RowBox[{"subgroup", ",", "#"}], "]"}], "&"}], ",", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"ConstantArray", "[", 
        RowBox[{
         RowBox[{"Extract", "[", 
          RowBox[{
           RowBox[{"result", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "&"}], "/@", 
      RowBox[{"result", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "4", ",", "All", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], ",", "1"}], "]"}],
    ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->52206020],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnUuO7Mxxha9sDbwET72NO7OWIK9AAlRTA7IBQaO7hZp43LvozdRiyrfI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    "], {{0, 280}, {405, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{405, 280},
  PlotRange->{{0, 405}, {0, 280}}]], "Output",
 ImageSize->{409, 280},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->47936239]
}, Open  ]],

Cell[TextData[{
 "Finally, we are in a position to interpret the main part of output we got: ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "5"}], "]"}], "]"}]], "InlineFormula"],
 ". Each SO(10) invariant of the form 16 x 16 x 10 [there is just one in this \
case], is a linear combination of the 17 invariants of SU(3)xSU(2)xU(1), and \
the coefficients are"
}], "ExampleText",
 Deletable->True,
 CellID->27014175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->49277989],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["2", 
       RowBox[{"3", "/", "4"}]], 
      SuperscriptBox["15", 
       RowBox[{"1", "/", "4"}]]]}], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["2", 
       RowBox[{"3", "/", "4"}]], 
      SuperscriptBox["15", 
       RowBox[{"1", "/", "4"}]]]}], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["2", 
       RowBox[{"3", "/", "4"}]], 
      SuperscriptBox["15", 
       RowBox[{"1", "/", "4"}]]]}], ",", 
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]]}], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]]}], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]]}], "}"}], "}"}]], "Output",
 ImageSize->{508, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->208815484]
}, Open  ]],

Cell[TextData[{
 "[Note: in the present case, we see from ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "4"}], "]"}], "]"}]], "InlineFormula"],
 " that all 17 products of representations provide just a single \
SU(3)xSU(2)xU(1) invariant each. If this is not the case, we would have more \
than 17 coefficients in  ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "5"}], "]"}], "]"}]], "InlineFormula"],
 ". For the sake of simplicity, consider this situation: if ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "4", ",", "All", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]], "InlineFormula"],
 " was {{{1,1,1},2},{{1,2,3},3},{{1,3,4},1}}, then  ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "5"}], "]"}], "]"}]], "InlineFormula"],
 " would be of the form {{c1,c2,c3,c4,c5,c6}} with c1,c2 corresponding to \
{{1,1,1},2}, c3,c4,c5 to {{1,2,3},3}, and c6 to {{1,3,4},1}}]."
}], "ExampleText",
 Deletable->True,
 CellID->377252352],

Cell["We can put it in a more readable form as follows", "ExampleText",
 Deletable->True,
 CellID->409441931],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"coefficients", "=", 
    RowBox[{"result", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"productFields", "=", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"RepName", "[", 
        RowBox[{"subgroup", ",", "#"}], "]"}], "&"}], ",", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ConstantArray", "[", 
           RowBox[{
            RowBox[{"Extract", "[", 
             RowBox[{
              RowBox[{"result", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", 
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "&"}], "/@", 
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "4", ",", "All", ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], ",", "1"}], 
       "]"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<The product of \>\"", ",", 
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"RepName", "[", 
          RowBox[{"group", ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{"rep16", ",", "rep16", ",", "rep10"}], "}"}]}], ",", 
       RowBox[{"Darker", "[", "Red", "]"}]}], "]"}], ",", 
     "\"\< of SO(1O) is the same as\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aux", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"coefficients", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"Darker", "[", "Gray", "]"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"productFields", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"Darker", "[", "Red", "]"}]}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "coefficients", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Row", "[", 
    RowBox[{"aux", ",", "\"\< + \>\""}], "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<in SU(3)xSU(2)xU(1)\>\"", "]"}], ";"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->325694542],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The product of \"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"{", 
     RowBox[{
      StyleBox["\<\"16\"\>",
       StripOnInput->False,
       FontWeight->Bold], ",", 
      StyleBox["\<\"16\"\>",
       StripOnInput->False,
       FontWeight->Bold], ",", 
      StyleBox["\<\"10\"\>",
       StripOnInput->False,
       FontWeight->Bold]}], "}"}],
    StripOnInput->False,
    LineColor->RGBColor[
      Rational[2, 3], 0, 0],
    FrontFaceColor->RGBColor[
      Rational[2, 3], 0, 0],
    BackFaceColor->RGBColor[
      Rational[2, 3], 0, 0],
    GraphicsColor->RGBColor[
      Rational[2, 3], 0, 0],
    FontColor->RGBColor[
      Rational[2, 3], 0, 0]], 
   "\[InvisibleSpace]", "\<\" of SO(1O) is the same as\"\>"}],
  SequenceForm["The product of ", 
   Style[{
     Style["16", Bold], 
     Style["16", Bold], 
     Style["10", Bold]}, 
    RGBColor[
     Rational[2, 3], 0, 0]], " of SO(1O) is the same as"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[210]:=",
 CellID->334833713],

Cell[BoxData[
 TemplateBox[{" + ","\" + \"",TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{"3", "/", "4"}]], 
         SuperscriptBox["15", 
          RowBox[{"1", "/", "4"}]]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/2\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/2\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{"3", "/", "4"}]], 
         SuperscriptBox["15", 
          RowBox[{"1", "/", "4"}]]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{"3", "/", "4"}]], 
         SuperscriptBox["15", 
          RowBox[{"1", "/", "4"}]]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "5"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/2\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "5"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/2\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"]},
  "RowWithSeparators"]], "Print",
 CellLabel->"During evaluation of In[210]:=",
 CellID->115287623],

Cell[BoxData["\<\"in SU(3)xSU(2)xU(1)\"\>"], "Print",
 CellLabel->"During evaluation of In[210]:=",
 CellID->192595932]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "These coefficients in gray have been computed by Susyno by explicitly \
embedding each and all sub-representations of SU(3)xSU(2)xU(1) in the \
corresponding representation of SO(10), computing the \
invariants/Clebsch-Gordon coefficients with both symmetry groups, and \
matching them. The fact that coefficients we returned at all (i.e., no error \
was produced) means that such matching was achieved successfully, and \
therefore is a very strong sign that the computation chain and the final \
output are correct.\[LineSeparator]\[LineSeparator]A potential question is: \
why are the coefficients so complicated (with quartic roots for example)? The \
answer is simple: it is due to the normalization convention of Susyno for all \
invariants/Clebsch-Gordon coefficients, which in this case affects both those \
at the SO(10) level as well as those at the SU(3)xSU(2)xU(1) level. These \
invariants are calculated with the ",
 Cell[BoxData[
  ButtonBox["Invariants",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/Invariants"]], "InlineFormula"],
 " function (see the normalization convention in the documentation of this \
function).\[LineSeparator]\[LineSeparator]Note however that at the \
SU(3)xSU(2)xU(1) level, most invariants are normalized as it is usually done. \
For example, the invariants/Clebsch-Gordon coefficients of the products"
}], "ExampleText",
 Deletable->True,
 CellID->40659380],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     StyleBox["\<\"3\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/6\\)\"\>"}], ",", 
    RowBox[{
     OverscriptBox[
      StyleBox["\<\"3\"\>",
       StripOnInput->False,
       FontWeight->Bold], "_"], "\[CircleTimes]", 
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], 
     "\[CircleTimes]", "\<\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\"\>"}], ",", 
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/2\\)\"\>"}]}], "}"}],
  StripOnInput->False,
  LineColor->RGBColor[
    Rational[2, 3], 0, 0],
  FrontFaceColor->RGBColor[
    Rational[2, 3], 0, 0],
  GraphicsColor->RGBColor[
    Rational[2, 3], 0, 0],
  FontColor->RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`BackFaceColor -> RGBColor[
    Rational[2, 3], 0, 0]]], "Output",
 ImageSize->{190, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->20401898],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     StyleBox["\<\"3\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/6\\)\"\>"}], ",", 
    RowBox[{
     OverscriptBox[
      StyleBox["\<\"3\"\>",
       StripOnInput->False,
       FontWeight->Bold], "_"], "\[CircleTimes]", 
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/3\\)\"\>"}], ",", 
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], 
     "\[CircleTimes]", "\<\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\"\>"}]}], "}"}],
  StripOnInput->False,
  LineColor->RGBColor[
    Rational[2, 3], 0, 0],
  FrontFaceColor->RGBColor[
    Rational[2, 3], 0, 0],
  GraphicsColor->RGBColor[
    Rational[2, 3], 0, 0],
  FontColor->RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`BackFaceColor -> RGBColor[
    Rational[2, 3], 0, 0]]], "Output",
 ImageSize->{190, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->201267126],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], 
     "\[CircleTimes]", "\<\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\"\>"}], ",", 
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\)\"\>"}], ",", 
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], 
     "\[CircleTimes]", "\<\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\"\>"}]}], "}"}],
  StripOnInput->False,
  LineColor->RGBColor[
    Rational[2, 3], 0, 0],
  FrontFaceColor->RGBColor[
    Rational[2, 3], 0, 0],
  GraphicsColor->RGBColor[
    Rational[2, 3], 0, 0],
  FontColor->RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`BackFaceColor -> RGBColor[
    Rational[2, 3], 0, 0]]], "Output",
 ImageSize->{194, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->99615333],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], 
     "\[CircleTimes]", "\<\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\"\>"}], ",", 
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(0\\)\"\>"}], ",", 
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/2\\)\"\>"}]}], "}"}],
  StripOnInput->False,
  LineColor->RGBColor[
    Rational[2, 3], 0, 0],
  FrontFaceColor->RGBColor[
    Rational[2, 3], 0, 0],
  GraphicsColor->RGBColor[
    Rational[2, 3], 0, 0],
  FontColor->RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`BackFaceColor -> RGBColor[
    Rational[2, 3], 0, 0]]], "Output",
 ImageSize->{186, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->238858373],

Cell["\<\
are as in the Minimal Supersymmetric Standard Model, so we can compare the \
coefficients of each without further worries. To factor out the normalization \
choice of the 16 x 16 x 10 SO(10) invariant we can look at the ratio of these \
coefficients. Above, we can see that in all 4 cases the coefficients are\
\>", "ExampleText",
 Deletable->True,
 CellID->83166596],

Cell[BoxData[
 StyleBox[
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox["2", "5"], ")"}], 
   RowBox[{"1", "/", "4"}]],
  StripOnInput->False,
  LineColor->RGBColor[
   0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`],
  FrontFaceColor->RGBColor[
   0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`],
  BackFaceColor->RGBColor[
   0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`],
  GraphicsColor->RGBColor[
   0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`],
  FontColor->RGBColor[
   0.33333333333333337`, 0.33333333333333337`, 
    0.33333333333333337`]]], "Input",
 CellLabel->"In[16]:=",
 CellID->897575960],

Cell["\<\
we conclude that the MSSM Yukawa couplings would have the relation Yu=Yd=Ye=Y\
\[Nu] in an SO(10) model where they come from an 16 x 16 x 10 coupling.\
\>", "ExampleText",
 Deletable->True,
 CellID->216184249],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197771987],

Cell["\<\
Let us repeat the previous example, but with the other possible Higgs H that \
couple in a term 16 x 16 x H, namely the 120 ({0,0,1,0,0}) and the 126 \
({0,0,0,2,0}):\
\>", "ExampleText",
 CellID->26134510],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ConjugateIrrep", "[", 
       RowBox[{"SO10", ",", "#1"}], "]"}], ",", "#2"}], "}"}], "&"}], "@@@", 
   RowBox[{"ReduceRepProduct", "[", 
    RowBox[{"SO10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
      "}"}]}], "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RepName", "[", 
      RowBox[{"SO10", ",", 
       RowBox[{"ConjugateIrrep", "[", 
        RowBox[{"SO10", ",", "#1"}], "]"}]}], "]"}], ",", "#2"}], "}"}], 
   "&"}], "@@@", 
  RowBox[{"ReduceRepProduct", "[", 
   RowBox[{"SO10", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
     "}"}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->691511790],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{415, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103080074],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["\<\"126\"\>",
      StripOnInput->False,
      FontWeight->Bold], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["\<\"120\"\>",
      StripOnInput->False,
      FontWeight->Bold], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["\<\"10\"\>",
      StripOnInput->False,
      FontWeight->Bold], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->326397141]
}, Open  ]],

Cell["Let us consider just H={0,0,0,2,0}:", "ExampleText",
 CellID->281445517],

Cell[BoxData[{
 RowBox[{
  RowBox[{"group", "=", 
   RowBox[{"{", "SO10", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rep16", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rep126", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "0"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"subgroup", "=", 
   RowBox[{"{", 
    RowBox[{"SU3", ",", "SU2", ",", "U1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"breakInfo", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"{", "4", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "6"}]}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result", "=", 
   RowBox[{"SubgroupEmbeddingCoefficients", "[", 
    RowBox[{"group", ",", 
     RowBox[{"{", 
      RowBox[{"rep16", ",", "rep16", ",", "rep126"}], "}"}], ",", "subgroup", 
     ",", "breakInfo"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1908845],

Cell["The result can be summarized as follows:", "ExampleText",
 CellID->154247179],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"coefficients", "=", 
    RowBox[{"result", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"productFields", "=", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"RepName", "[", 
        RowBox[{"subgroup", ",", "#"}], "]"}], "&"}], ",", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ConstantArray", "[", 
           RowBox[{
            RowBox[{"Extract", "[", 
             RowBox[{
              RowBox[{"result", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", 
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "&"}], "/@", 
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "4", ",", "All", ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], ",", "1"}], 
       "]"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<The product of \>\"", ",", 
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"RepName", "[", 
          RowBox[{"group", ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{"rep16", ",", "rep16", ",", "rep126"}], "}"}]}], ",", 
       RowBox[{"Darker", "[", "Red", "]"}]}], "]"}], ",", 
     "\"\< of SO(1O) is the same as\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aux", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"coefficients", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"Darker", "[", "Gray", "]"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"productFields", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"Darker", "[", "Red", "]"}]}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "coefficients", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Row", "[", 
    RowBox[{"aux", ",", "\"\< + \>\""}], "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<in SU(3)xSU(2)xU(1)\>\"", "]"}], ";"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->28459257],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The product of \"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"{", 
     RowBox[{
      StyleBox["\<\"16\"\>",
       StripOnInput->False,
       FontWeight->Bold], ",", 
      StyleBox["\<\"16\"\>",
       StripOnInput->False,
       FontWeight->Bold], ",", 
      StyleBox["\<\"126\"\>",
       StripOnInput->False,
       FontWeight->Bold]}], "}"}],
    StripOnInput->False,
    LineColor->RGBColor[
      Rational[2, 3], 0, 0],
    FrontFaceColor->RGBColor[
      Rational[2, 3], 0, 0],
    BackFaceColor->RGBColor[
      Rational[2, 3], 0, 0],
    GraphicsColor->RGBColor[
      Rational[2, 3], 0, 0],
    FontColor->RGBColor[
      Rational[2, 3], 0, 0]], 
   "\[InvisibleSpace]", "\<\" of SO(1O) is the same as\"\>"}],
  SequenceForm["The product of ", 
   Style[{
     Style["16", Bold], 
     Style["16", Bold], 
     Style["126", Bold]}, 
    RGBColor[
     Rational[2, 3], 0, 0]], " of SO(1O) is the same as"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[224]:=",
 CellID->50753169],

Cell[BoxData[
 TemplateBox[{" + ","\" + \"",TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
           SqrtBox[
            FractionBox["2", "3"]]}], 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"6\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox["2", "3"]}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "21"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       SuperscriptBox["2", 
        RowBox[{"3", "/", "4"}]], 
       RowBox[{"3", " ", 
         SuperscriptBox["21", 
          RowBox[{"1", "/", "4"}]]}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox["4", 
         RowBox[{"3", " ", 
           SuperscriptBox["7", 
            RowBox[{"1", "/", "4"}]]}]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"8\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/2\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox["1", "3"]}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "7"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/2\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox["4", 
         RowBox[{"3", " ", 
           SuperscriptBox["7", 
            RowBox[{"1", "/", "4"}]]}]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"8\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox["1", "3"]}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "7"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{"3", "/", "4"}]], 
         SuperscriptBox["21", 
          RowBox[{"1", "/", "4"}]]]}], StripOnInput -> False, LineColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]], 
         SqrtBox["3"]]}], StripOnInput -> False, LineColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
              FractionBox["2", "7"], ")"}], 
            RowBox[{"1", "/", "4"}]]}], 
         SqrtBox["3"]]}], StripOnInput -> False, LineColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/6\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
              FractionBox["2", "7"], ")"}], 
            RowBox[{"1", "/", "4"}]]}], 
         SqrtBox["3"]]}], StripOnInput -> False, LineColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(7\\/6\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox["4", 
         RowBox[{"3", " ", 
           SuperscriptBox["7", 
            RowBox[{"1", "/", "4"}]]}]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"8\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/2\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox["1", "3"]}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "7"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/2\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox["4", 
       RowBox[{
         SuperscriptBox["3", 
          RowBox[{"3", "/", "4"}]], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"6\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(4\\/3\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SqrtBox["2"]}], 
       RowBox[{
         SuperscriptBox["3", 
          RowBox[{"3", "/", "4"}]], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], StripOnInput -> False, LineColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"6\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "3"], ")"}], 
          RowBox[{"3", "/", "4"}]], 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(7\\/6\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(2\\/3\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
     "0", StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox["4", 
         RowBox[{"3", " ", 
           SuperscriptBox["7", 
            RowBox[{"1", "/", "4"}]]}]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"8\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox["1", "3"]}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "7"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SqrtBox["2"]}], 
       RowBox[{
         SuperscriptBox["3", 
          RowBox[{"3", "/", "4"}]], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"6\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "3"], ")"}], 
          RowBox[{"3", "/", "4"}]], 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox["4", 
       RowBox[{
         SuperscriptBox["3", 
          RowBox[{"3", "/", "4"}]], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], StripOnInput -> False, LineColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"6\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox["2", 
          RowBox[{"3", "/", "4"}]]}], 
       RowBox[{"3", " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{
        FractionBox["1", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "7"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], StripOnInput -> False, LineColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], StripOnInput -> False, LineColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(4\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{"3", "/", "4"}]], 
         SuperscriptBox["21", 
          RowBox[{"1", "/", "4"}]]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]], 
         SqrtBox["3"]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(7\\/6\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "21"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/2\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
              FractionBox["2", "7"], ")"}], 
            RowBox[{"1", "/", "4"}]]}], 
         SqrtBox["3"]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/6\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(2\\/3\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox["2", 
          RowBox[{"3", "/", "4"}]]}], 
       RowBox[{"3", " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{
        FractionBox["1", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "7"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/2\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox["2", 
          RowBox[{"3", "/", "4"}]]}], 
       RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-1\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
              FractionBox["2", "7"], ")"}], 
            RowBox[{"1", "/", "4"}]]}], 
         SqrtBox["3"]]}], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(7\\/6\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
     "0", StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
             "_"], "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(4\\/3\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}]}], "}"}], 
      StripOnInput -> False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-1\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"],TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox["2", 
          RowBox[{"3", "/", "4"}]]}], 
       RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], StripOnInput -> False, LineColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FrontFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], BackFaceColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], GraphicsColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`], FontColor -> 
      RGBColor[0.33333333333333337`, 0.33333333333333337`, 
        0.33333333333333337`]], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
            "\[CircleTimes]", "\"\\!\\(-2\\)\""}]}], "}"}], StripOnInput -> 
      False, LineColor -> RGBColor[
        Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], BackFaceColor -> RGBColor[
        Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
        Rational[2, 3], 0, 0], FontColor -> RGBColor[
        Rational[2, 3], 0, 0]]}, "RowDefault"]},
  "RowWithSeparators"]], "Print",
 CellLabel->"During evaluation of In[224]:=",
 CellID->358137782],

Cell[BoxData["\<\"in SU(3)xSU(2)xU(1)\"\>"], "Print",
 CellLabel->"During evaluation of In[224]:=",
 CellID->186059644]
}, Open  ]]
}, Open  ]],

Cell["The important terms are the following:", "ExampleText",
 CellID->16234398],

Cell[BoxData[
 TemplateBox[{StyleBox[
    RowBox[{
      RowBox[{"-", 
        FractionBox["1", "3"]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]]}], StripOnInput -> False, LineColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], FrontFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], GraphicsColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], FontColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`BackFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`]],StyleBox[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
        RowBox[{
          OverscriptBox[
           StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], "_"],
           "\[CircleTimes]", 
          StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", "\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\""}], ",", 
        RowBox[{
          StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", "\"\\!\\(1\\/2\\)\""}]}], "}"}], StripOnInput -> 
    False, LineColor -> RGBColor[
      Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
      Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
      Rational[2, 3], 0, 0], FontColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`BackFaceColor -> RGBColor[
      Rational[2, 3], 0, 0]]},
  "RowDefault"]], "Output",
 ImageSize->{253, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->796885683],

Cell[BoxData[
 TemplateBox[{StyleBox[
    RowBox[{
      RowBox[{"-", 
        FractionBox["1", "3"]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]]}], StripOnInput -> False, LineColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], FrontFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], GraphicsColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], FontColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`BackFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`]],StyleBox[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", "\"\\!\\(1\\/6\\)\""}], ",", 
        RowBox[{
          OverscriptBox[
           StyleBox["\"3\"", StripOnInput -> False, FontWeight -> Bold], "_"],
           "\[CircleTimes]", 
          StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", "\"\\!\\(1\\/3\\)\""}], ",", 
        RowBox[{
          StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}]}], "}"}], 
    StripOnInput -> False, LineColor -> RGBColor[
      Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
      Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
      Rational[2, 3], 0, 0], FontColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`BackFaceColor -> RGBColor[
      Rational[2, 3], 0, 0]]},
  "RowDefault"]], "Output",
 ImageSize->{253, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->136669058],

Cell[BoxData[
 TemplateBox[{StyleBox[
    SuperscriptBox[
     RowBox[{"(", 
       FractionBox["2", "7"], ")"}], 
     RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], FrontFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], GraphicsColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], FontColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`BackFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`]],StyleBox[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
        RowBox[{
          StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", 
          StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", "\"\\!\\(0\\)\""}], ",", 
        RowBox[{
          StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", "\"\\!\\(1\\/2\\)\""}]}], "}"}], StripOnInput -> 
    False, LineColor -> RGBColor[
      Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
      Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
      Rational[2, 3], 0, 0], FontColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`BackFaceColor -> RGBColor[
      Rational[2, 3], 0, 0]]},
  "RowDefault"]], "Output",
 ImageSize->{227, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->24468724],

Cell[BoxData[
 TemplateBox[{StyleBox[
    SuperscriptBox[
     RowBox[{"(", 
       FractionBox["2", "7"], ")"}], 
     RowBox[{"1", "/", "4"}]], StripOnInput -> False, LineColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], FrontFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], GraphicsColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], FontColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`BackFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`]],StyleBox[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}], ",", 
        RowBox[{
          StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", 
          StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", "\"\\!\\(1\\)\""}], ",", 
        RowBox[{
          StyleBox["\"1\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", StripOnInput -> False, FontWeight -> Bold], 
          "\[CircleTimes]", "\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\""}]}], "}"}], 
    StripOnInput -> False, LineColor -> RGBColor[
      Rational[2, 3], 0, 0], FrontFaceColor -> RGBColor[
      Rational[2, 3], 0, 0], GraphicsColor -> RGBColor[
      Rational[2, 3], 0, 0], FontColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`BackFaceColor -> RGBColor[
      Rational[2, 3], 0, 0]]},
  "RowDefault"]], "Output",
 ImageSize->{235, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->20462939],

Cell["\<\
Clearly, by looking at the ratio of the numerical coefficients in gray, we \
conclude that the MSSM Yukawa couplings would have the relation Yu=Yd=-1/3 \
Ye=-1/3 Y\[Nu] in an SO(10) model where they come from an 16 x 16 x 126 \
coupling.\
\>", "ExampleText",
 CellID->53541657]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 729},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SubgroupEmbeddingCoefficients - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2014, 12, 18, 10, 47, 52.7916685}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "SubgroupEmbeddingCoefficients[group, representationsList, subgroup, \\ \
breakingInfo] For some subgroup of group, and for the product of \
representations of group in representationsList, this functions calculates \
the relation amongst the invariants/Clebsch-Gordon coefficients of subgroup \
imposed by the remaining symmetry generators of group which are not part of \
subgroup. Quick example: the 16 and 10 of SO(10) form the a trilinear \
invariant (16 x 16 x 10). Under the subgroup G_SM=SU(3)xSU(2)xU(1) of SO(10), \
these representations break into various irreducible representations of G_SM, \
and a total of 17 terms invariant only under G_SM can be written with these \
G_SM-representations. Since there is only one invariant under the full group, \
SO(10), the coefficients of these 17 G_SM-invariant terms must be related in \
an SO(10)-symmetric scenario. SubgroupEmbeddingCoefficients returns such \
relations.", "synonyms" -> {}, "title" -> "SubgroupEmbeddingCoefficients", 
    "type" -> "Symbol", "uri" -> "Susyno/ref/SubgroupEmbeddingCoefficients"}, 
  "LinkTrails" -> "", "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "9.0 for Microsoft Windows (64-bit) (January 25, 2013)", 
  StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "10.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion.nb", CharacterEncoding -> "WindowsANSI"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16918, 503, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->158588049]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 237658, 5747}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[622, 21, 76, 1, 70, "SymbolColorBar"],
Cell[701, 24, 178, 5, 70, "LinkTrail"],
Cell[882, 31, 2406, 55, 70, "AnchorBarGrid",
 CellID->1],
Cell[3291, 88, 72, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[CellGroupData[{
Cell[3388, 93, 2095, 49, 70, "Usage",
 CellID->982511436],
Cell[CellGroupData[{
Cell[5508, 146, 579, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->45508745],
Cell[6090, 165, 469, 16, 70, "Notes",
 CellID->810218094],
Cell[6562, 183, 511, 18, 70, "Notes",
 CellID->31258817],
Cell[7076, 203, 572, 13, 70, "Notes",
 CellID->232483187],
Cell[7651, 218, 9122, 276, 70, "Notes",
 CellID->45496372],
Cell[16776, 496, 93, 1, 70, "Notes",
 CellID->421525536]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16918, 503, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->158588049],
Cell[CellGroupData[{
Cell[17404, 520, 146, 5, 70, "ExampleSection",
 CellID->5853172],
Cell[17553, 527, 142, 4, 70, "ExampleText",
 CellID->19615827],
Cell[17698, 533, 1378, 45, 70, "Input",
 CellID->85442412],
Cell[19079, 580, 582, 16, 70, "ExampleText",
 CellID->147360266],
Cell[CellGroupData[{
Cell[19686, 600, 149, 5, 70, "Input",
 CellID->276648439],
Cell[19838, 607, 503, 17, 36, "Output",
 CellID->95027590]
}, Open  ]],
Cell[20356, 627, 88, 1, 70, "ExampleText",
 CellID->240482480],
Cell[CellGroupData[{
Cell[20469, 632, 513, 17, 70, "Input",
 CellID->259293861],
Cell[20985, 651, 2334, 74, 119, "Output",
 CellID->394806322]
}, Open  ]],
Cell[23334, 728, 783, 21, 70, "ExampleText",
 CellID->490834723],
Cell[CellGroupData[{
Cell[24142, 753, 183, 6, 70, "Input",
 CellID->27134387],
Cell[24328, 761, 6538, 148, 510, "Output",
 CellID->847649793]
}, Open  ]],
Cell[30881, 912, 727, 23, 70, "ExampleText",
 CellID->985435234],
Cell[CellGroupData[{
Cell[31633, 939, 149, 5, 70, "Input",
 CellID->148666411],
Cell[31785, 946, 3286, 111, 146, "Output",
 CellID->474393384]
}, Open  ]],
Cell[35086, 1060, 479, 13, 70, "ExampleText",
 CellID->4552369],
Cell[CellGroupData[{
Cell[35590, 1077, 329, 11, 70, "Input",
 CellID->522541032],
Cell[35922, 1090, 4549, 139, 115, "Output",
 CellID->38959301]
}, Open  ]],
Cell[40486, 1232, 785, 19, 70, "ExampleText",
 CellID->49186995],
Cell[CellGroupData[{
Cell[41296, 1255, 221, 7, 70, "Input",
 CellID->97988462],
Cell[41520, 1264, 2261, 76, 88, "Output",
 CellID->180110237]
}, Open  ]],
Cell[43796, 1343, 1932, 55, 70, "ExampleText",
 CellID->137870151],
Cell[CellGroupData[{
Cell[45753, 1402, 559, 18, 47, "Input",
 CellID->55378935],
Cell[46315, 1422, 10689, 183, 301, "Output",
 CellID->3614242]
}, Open  ]],
Cell[57019, 1608, 445, 12, 70, "ExampleText",
 CellID->332102819],
Cell[CellGroupData[{
Cell[57489, 1624, 924, 29, 65, "Input",
 CellID->52206020],
Cell[58416, 1655, 10690, 183, 301, "Output",
 CellID->47936239]
}, Open  ]],
Cell[69121, 1841, 452, 11, 70, "ExampleText",
 CellID->27014175],
Cell[CellGroupData[{
Cell[69598, 1856, 149, 5, 70, "Input",
 CellID->49277989],
Cell[69750, 1863, 2340, 84, 91, "Output",
 CellID->208815484]
}, Open  ]],
Cell[72105, 1950, 1104, 29, 70, "ExampleText",
 CellID->377252352],
Cell[73212, 1981, 109, 2, 70, "ExampleText",
 CellID->409441931],
Cell[CellGroupData[{
Cell[73346, 1987, 2797, 83, 70, "Input",
 CellID->325694542],
Cell[CellGroupData[{
Cell[76168, 2074, 1071, 36, 70, "Print",
 CellID->334833713],
Cell[77242, 2112, 33020, 692, 70, "Print",
 CellID->115287623],
Cell[110265, 2806, 119, 2, 70, "Print",
 CellID->192595932]
}, Open  ]]
}, Open  ]],
Cell[110411, 2812, 1432, 24, 70, "ExampleText",
 CellID->40659380],
Cell[111846, 2838, 1273, 42, 53, "Output",
 CellID->20401898],
Cell[113122, 2882, 1274, 42, 53, "Output",
 CellID->201267126],
Cell[114399, 2926, 1259, 42, 53, "Output",
 CellID->99615333],
Cell[115661, 2970, 1241, 41, 53, "Output",
 CellID->238858373],
Cell[116905, 3013, 377, 7, 70, "ExampleText",
 CellID->83166596],
Cell[117285, 3022, 684, 19, 70, "Input",
 CellID->897575960],
Cell[117972, 3043, 219, 5, 70, "ExampleText",
 CellID->216184249],
Cell[CellGroupData[{
Cell[118216, 3052, 125, 3, 70, "ExampleDelimiter",
 CellID->197771987],
Cell[118344, 3057, 216, 5, 70, "ExampleText",
 CellID->26134510],
Cell[CellGroupData[{
Cell[118585, 3066, 1153, 36, 70, "Input",
 CellID->691511790],
Cell[119741, 3104, 628, 22, 36, "Output",
 CellID->103080074],
Cell[120372, 3128, 591, 22, 36, "Output",
 CellID->326397141]
}, Open  ]],
Cell[120978, 3153, 78, 1, 70, "ExampleText",
 CellID->281445517],
Cell[121059, 3156, 1379, 45, 70, "Input",
 CellID->1908845],
Cell[122441, 3203, 83, 1, 70, "ExampleText",
 CellID->154247179],
Cell[CellGroupData[{
Cell[122549, 3208, 2796, 83, 70, "Input",
 CellID->28459257],
Cell[CellGroupData[{
Cell[125370, 3295, 1072, 36, 70, "Print",
 CellID->50753169],
Cell[126445, 3333, 99412, 2129, 70, "Print",
 CellID->358137782],
Cell[225860, 5464, 119, 2, 70, "Print",
 CellID->186059644]
}, Open  ]]
}, Open  ]],
Cell[226006, 5470, 80, 1, 70, "ExampleText",
 CellID->16234398],
Cell[226089, 5473, 2097, 48, 53, "Output",
 CellID->796885683],
Cell[228189, 5523, 2097, 48, 53, "Output",
 CellID->136669058],
Cell[230289, 5573, 1978, 44, 53, "Output",
 CellID->24468724],
Cell[232270, 5619, 1991, 44, 53, "Output",
 CellID->20462939],
Cell[234264, 5665, 287, 6, 70, "ExampleText",
 CellID->53541657]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[234612, 5678, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[235034, 5692, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[235200, 5698, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

