(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     16011,        535]
NotebookOptionsPosition[     12747,        433]
NotebookOutlinePosition[     14535,        481]
CellTagsIndexPosition[     14450,        476]
WindowTitle->RepsUpToDimN - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/RepsUpToDimN\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/RepsUpToDimN"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
RepsUpToDimN.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/RepsUpToDimN", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["RepsUpToDimN", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RepsUpToDimN", "[", 
       RowBox[{"group", ",", " ", "maxDim"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]Lists all representations of ",
     Cell[BoxData["group"], "InlineFormula"],
     " with dimension smaller or equal to ",
     Cell[BoxData["maxDim"], "InlineFormula"],
     " "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->970403919],

Cell[TextData[{
 "Argument ",
 Cell[BoxData["group"], "InlineFormula"],
 " should be the ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 " of the group."
}], "Notes",
 CellID->416274567],

Cell[TextData[{
 "This method outputs a list o representations, each given by its Dynkin \
coefficients. The option ",
 Cell[BoxData[
  RowBox[{"UseName", "->", "True"}]], "InlineFormula"],
 " can be used to get the names of the representations instead (as given by \
the ",
 Cell[BoxData[
  ButtonBox["RepName",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/RepName"]], "InlineFormula"],
 " function)."
}], "Notes",
 CellID->1067943069]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->337016685],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->85970087],

Cell[TextData[{
 "List all representations of ",
 Cell[BoxData[
  SubscriptBox["E", "6"]], "InlineFormula"],
 " with dimensions smaller than or equal to 10000:"
}], "ExampleText",
 CellID->283112903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RepsUpToDimN", "[", 
  RowBox[{"E6", ",", "10000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->473091279],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "3", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "2", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{496, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16402979]
}, Open  ]],

Cell["Get the names instead:", "ExampleText",
 CellID->23985300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RepsUpToDimN", "[", 
  RowBox[{"E6", ",", "10000", ",", 
   RowBox[{"UseName", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->205549982],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["\<\"1\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"27\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"27\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"], ",", 
   StyleBox["\<\"78\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"351\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"351\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"], ",", 
   StyleBox["\<\"351'\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"351'\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"], ",", 
   StyleBox["\<\"650\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"1728\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"1728\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"], ",", 
   StyleBox["\<\"2430\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"2925\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"3003\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"3003\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"], ",", 
   StyleBox["\<\"5824\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"5824\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"], ",", 
   StyleBox["\<\"7371\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"7371\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"], ",", 
   StyleBox["\<\"7722\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"7722\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"]}], "}"}]], "Output",
 ImageSize->{398, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->388007747]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DimR",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/DimR"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["RepName",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/RepName"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["RepsUpToDimNNoConjugates",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/RepsUpToDimNNoConjugates"]], "InlineFormula"]
}], "RelatedLinks",
 CellID->56765791]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 729},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RepsUpToDimN - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2014, 12, 18, 10, 47, 42.4887947}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "RepsUpToDimN[group, maxDim] Lists all representations of group with \
dimension smaller or equal to maxDim ", "synonyms" -> {}, "title" -> 
    "RepsUpToDimN", "type" -> "Symbol", "uri" -> "Susyno/ref/RepsUpToDimN"}, 
  "LinkTrails" -> "", "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "9.0 for Microsoft Windows (64-bit) (January 25, 2013)", 
  StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "10.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion.nb", CharacterEncoding -> "WindowsANSI"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5166, 160, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->337016685]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14307, 469}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[605, 21, 76, 1, 70, "SymbolColorBar"],
Cell[684, 24, 178, 5, 70, "LinkTrail"],
Cell[865, 31, 2314, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[3182, 86, 55, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[CellGroupData[{
Cell[3262, 91, 557, 16, 70, "Usage",
 CellID->982511436],
Cell[CellGroupData[{
Cell[3844, 111, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->970403919],
Cell[4427, 130, 240, 9, 70, "Notes",
 CellID->416274567],
Cell[4670, 141, 447, 13, 70, "Notes",
 CellID->1067943069]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5166, 160, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->337016685],
Cell[CellGroupData[{
Cell[5652, 177, 147, 5, 70, "ExampleSection",
 CellID->85970087],
Cell[5802, 184, 199, 6, 70, "ExampleText",
 CellID->283112903],
Cell[CellGroupData[{
Cell[6026, 194, 136, 4, 70, "Input",
 CellID->473091279],
Cell[6165, 200, 2346, 70, 122, "Output",
 CellID->16402979]
}, Open  ]],
Cell[8526, 273, 64, 1, 70, "ExampleText",
 CellID->23985300],
Cell[CellGroupData[{
Cell[8615, 278, 185, 5, 70, "Input",
 CellID->205549982],
Cell[8803, 285, 2110, 78, 58, "Output",
 CellID->388007747]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10974, 370, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[11396, 384, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[11584, 392, 427, 12, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[12014, 406, 691, 22, 70, "RelatedLinks",
 CellID->56765791]
}, Open  ]],
Cell[12720, 431, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

