(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     56859,       1614]
NotebookOptionsPosition[     50287,       1404]
NotebookOutlinePosition[     52365,       1456]
CellTagsIndexPosition[     52279,       1451]
WindowTitle->PermutationSymmetryOfTensorProductParts - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {
       RowBox[{
        RowBox[{"{", "}"}], "\[LeftDoubleBracket]", "1", 
        "\[RightDoubleBracket]"}]:>Documentation`HelpLookup[
        If[
         StringMatchQ[
          Part[{}, 2], "paclet*"], 
         Part[
          Part[{{}, {"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE", 
             StringReplace[{
               URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None}, 
              "paclet:" :> ""]}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{}, {"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE", 
              StringReplace[{
                URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None},
                "paclet:" :> ""]}}, 1], 
           2]]]], "\<\"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE\"\>":>
       Documentation`HelpLookup[
        If[
         StringMatchQ[
          StringReplace[{
            URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None}, 
           "paclet:" :> ""], "paclet*"], 
         Part[
          Part[{{}, {"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE", 
             StringReplace[{
               URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None}, 
              "paclet:" :> ""]}}, 2], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{}, {"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE", 
              StringReplace[{
                URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None},
                "paclet:" :> ""]}}, 2], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->
         False], {"\<\"Susyno/ref/PermutationSymmetryOfTensorProductParts\"\>\
":>None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/PermutationSymmetryOfTensorProductParts"]}, 
            Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
PermutationSymmetryOfTensorProductParts.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/PermutationSymmetryOfTensorProductParts", ".html"]], 
           None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["PermutationSymmetryOfTensorProductParts", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PermutationSymmetryOfTensorProductParts", "[", 
       RowBox[{
        RowBox[{"gauge", " ", "group"}], ",", 
        RowBox[{"list", " ", "of", " ", "representations"}]}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]Computes the irreducible parts (irreps) in the product \
of the representations of the gauge group provided, together with the \
information on how these irreps change under a permutation of the \
representations being multiplied"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->219257745],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"gauge", " ", "group"}]], "InlineFormula"],
 " can be a list of simple/abelian groups (see ",
 ButtonBox["Cartan matrix)",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 "."
}], "Notes",
 CellID->149353492],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"list", " ", "of", " ", "representations"}]], "InlineFormula"],
 " must be a list of representations of the gauge group."
}], "Notes",
 CellID->190293714],

Cell[TextData[{
 "This function is a more complicated version of ",
 Cell[BoxData[
  ButtonBox["Plethysms",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/Plethysms"]], "InlineFormula"],
 ", which can handle gauge groups which are not simple, and also product of \
representations which need not be the same. This function can also be seen as \
a generalization of ",
 Cell[BoxData[
  ButtonBox["PermutationSymmetryOfInvariants",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/PermutationSymmetryOfInvariants"]], 
  "InlineFormula"],
 ": this latter function deals only with the gauge invariant parts of the \
product of the representations given as input. Also, this function gives more \
information that ",
 Cell[BoxData[
  ButtonBox["ReduceRepProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/ReduceRepProduct"]], "InlineFormula"],
 ", which completely ignores what happens under a permutation of equal \
representations."
}], "Notes",
 CellID->757085513],

Cell[TextData[{
 "The output is rather complex (see the examples below). It is made of two \
lists: {",
 Cell[BoxData["indices"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"gauge", " ", "group", "\[Times]", "permutation", " ", "group"}], 
    ")"}], " ", "representations"}]], "InlineFormula"],
 " }. The first one (",
 Cell[BoxData["indices"], "InlineFormula"],
 ") indicates the position of equal representations in the  input list. So ",
 Cell[BoxData["indices"], "InlineFormula"],
 "={",
 Cell[BoxData["G1"], "InlineFormula"],
 ", ",
 Cell[BoxData["G2"], "InlineFormula"],
 ", \[CenterEllipsis]} where each ",
 Cell[BoxData["GI"], "InlineFormula"],
 " lists the positions of a group of equal representations. For example, if \
the input list is {",
 Cell[BoxData[
  SubscriptBox["R", "1"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["R", "2"]], "InlineFormula"],
 ",",
 Cell[BoxData[
  SubscriptBox["R", "1"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["R", "2"]], "InlineFormula"],
 "} for some representation ",
 Cell[BoxData[
  SubscriptBox["R", "1"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["R", "2"]], "InlineFormula"],
 " of the gauge group, ",
 Cell[BoxData["indices"], "InlineFormula"],
 " will be {{1,3},{2,4}} (the representations in positions 1 and 3 are the \
same, as well as the ones in the positions 2 and 4). The second list (",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"gauge", " ", "group", "*", "Sn"}], ")"}], " ", 
   "representations"}]], "InlineFormula"],
 ") is itself a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"Rep1", ",", " ", "Rep2", ",", " ", "\[CenterEllipsis]"}], "}"}]], 
  "InlineFormula"],
 " with the break down of the representations being multiplied according to \
how they change under (a) the gauge group and (b) under permutations of equal \
representations. Specifically, each ",
 Cell[BoxData["RepI"], "InlineFormula"],
 " is of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"GaugeGroupIrrep", ",", 
      RowBox[{"{", 
       RowBox[{
       "SnRepIG1", ",", " ", "SnRepIG2", ",", " ", "\[CenterEllipsis]"}], 
       "}"}]}], "}"}], ",", " ", "multiplicity"}], "}"}]], "InlineFormula"],
 " where ",
 Cell[BoxData["GaugeGroupIrrep"], "InlineFormula"],
 " is the gauge group irrep, and each ",
 Cell[BoxData["SnRepIGJ"], "InlineFormula"],
 " is the irreducible representation of an ",
 Cell[BoxData[
  SubscriptBox["S", "n"]], "InlineFormula"],
 " induced when the same fields in the grouping ",
 Cell[BoxData["GJ"], "InlineFormula"],
 " are permuted. ",
 Cell[BoxData["multiplicity"], "InlineFormula"],
 " indicates how many times such an irrep of the (gauge ",
 "group",
 " \[Times] permutation group) is contained in the product of the \
representations of the gauge group provided."
}], "Notes",
 CellID->311445735],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PermutationSymmetryOfTensorProductParts",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/PermutationSymmetryOfTensorProductParts"]], 
  "InlineFormula"],
 " is related to the ",
 Cell[BoxData[
  ButtonBox["Plethysms",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/Plethysms"]], "InlineFormula"],
 " function, which follows the algorithm described in ",
 StyleBox["M. A. A. van Leeuwen, A. M. Cohen, and B. Lisser, LiE, A Package \
for Lie Group Computations. Computer Algebra Nederland, 1992",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->586435317]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->244639072],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->278269351],

Cell["\<\
Consider gauge groups with a single factor\[LongDash]for example {SU2}. We \
shall consider a product of two doublets (={{1}}) and two quadruplets \
(={{3}}).\
\>", "ExampleText",
 CellID->21576093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermutationSymmetryOfTensorProductParts", "[", 
  RowBox[{
   RowBox[{"{", "SU2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", "1", "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", "1", "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", "3", "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", "3", "}"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39678609],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnVuO20YQRYXEH9lGtqGfIFmCkw3YQPQbwA4QeBdajTbDxTCiNKL47tdt
stg8B0gwrhG7qrvusEU9eH/9+s/ny0+n0+n7L/f/ff7y3+/fvn358een+z/+
+PHv319/vv/w1/2/3+6PaX6uAQAAAAAAAAAAAAAAAEqhup5Pp/O1igjeLqc7
l1tYwudRp95Qj6FDB5or9ZVgWL/fUJ0qJquSlpoh+J69o+bsE8ndaO/xldOf
0rxFSWwu44K7L5sUpFFdL+NzvFfw3rN7y67nsL49j2q4C6F7gp1O6mR4VCOv
Z4L7T2Gl3S7n62g6/usTXGqOYDvp+59U//yy9kRyNzpwfM305zVvRxImZFxw
972TQm6q63V8hvcPBm9eHZq/st6/r1GqnqrqOXzQ5lU9ZjKezmRVulLFwWZN
q4/fDKayxUTeReVJGjC+bvrTmjciCUsy/khSWPf9k0JmNtu8RidXnaofF/Jh
l/KPC5V6ajr72rxec5941XSr01fGRoeMf4jNy5aMPyoqrPv+SSEz22xezSm2
/9Sl3vTKq71gsfFXHx/svH5xu8X+UbsIkEfuRvuPf4TNy5iMy+y+blKQwuiN
kbBgQ8Tm1bwtNer+YpI5HAf419Zergw/6jCXRFOqPtiZ8u0yet9j3Ylkb3TY
+JrpN0zryoAkLMm4zO7rJgXp6K+8Hp/Imd01Fj6aM372sjzUVFWPd1Kr948h
Qz3Li3zKGl5qlmBnxxpuXitPJHOjw8b3D/roxPPKayNJTFdI99Onr54UJBL/
l9J7mnfqnDMXmlb1D+o/biQAn/57vunjM9TUh8x9ZR9Vao5g+2HeUTmrTiR3
o8PG9w86KpnRvGhSmqABGRfZff2kIBH1J0ufrwjHXD+PxvcaavWqJoPxpeYI
JmQXT8TvcGGjw8qLq8Qv6WaSSEhE91ftPqSS+I3IIcHfrpof2m+otatSl5oj
aGciXkcKG524cDbUS/c9D42vzEb3AQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
osnxtZTXF9c7Xh5452mmb9058bUoOCeGB90Y737amihrpvtHQH9DgJkvouOd
J5i+cefEql2UtwlZ6Jiamum+B+LuK9ZEUzPdPwb6G/HNfWce7zzR9O36d/Ru
gB+7Ji7ovtHud8uh+3FBJ7ruF4DefOpyOU/c5nI7AVfFeeeZPX11CxsUSfeL
737nF/Fr4oLus3m1yP072l1reC8wvPPsCbjwzYvuL5Jl80pcExd0n83rid47
r2O+NfG+B955ydNvMOycOPuyId0vvvu1ZE00NdP9I6B+9vVYxuePA+tEvPNE
07frnPh+53j0HjLdL7776WtC91fsfgHoXzqoWoe3/uLhnZc+fevOie9lGV2S
0313cM/dF6wJ3V+z+wWAd15K0sTyNvfOo/t0XxtMSET38c0MJMeXlONz4J2H
c6KuZq8j6T7dj0oaX5mN7gMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgDVyfNfj
9WXwV1zpyOZfyTqGdKGDeTvKKRcNE0M0E5ZSvhQAajCjjEw67w23RKCjnE0b
O0wMI5PuTjMNmqUAkIMZZUrS4BPRwlH7MVPAxDAl6Z408zxUsRQAcjCjTEm6
pxOR/c3Ls1NoZrkq7eYlWgoAOZhRpiTd04nI+Obl3yk0s1yVUDO6pQDQojek
O5QZZS09EaV2Q5h0CUwMU5I27EUzuqUAyAFmlClJJ04pQkc5/yAmhmgmNLic
VL0UAHIwo4xMOuMNJ3SU8w9iYohmQoOLSfVLASAHQ7qUpBOPkjnK+QcxMUQz
oUGsD2H/YEinNKQTOsoZtrFDM2gmdSgAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AADok+M7O0PPOowF32BGOR20ZGCaraeRpaaZdZapGWsGpmimlk/KRY67JTR3
5B3dig1jweWjjmtGWRszMM3c0+BSFWadpWnGmoEpmqn1k3KS5d6Gk1PAWHD5
qONaohgzMM3dUxdZzDpL00ynHAsGpmimRTcpJ7nuKm9n88JYMDSpi8INTM2e
iFLMOgvTTOcXJgxM0UzLfjev9km0kc0LY8GIpC4KNzC1eSJKNOssTDOvqBUD
UzTTstbmpTcW7FkpDNYNY8Hlo45qRmnKwLReoadLKJR8AM3UkjXR1NyAZlpE
k/Ih1+V89JUXxoIRwV2bUbYvNT+yx1x5SWvO29OIUtPNOmMrsasZOwamr3rQ
TJtaNSknOTav16c0Y94oxFiwX1nxZpQfIQMGpmv0NLzUMCX7B/esGcGaoJl+
DouacYKxYErSiUcdwFjwYJoxsbz+j0QzaCb0kTY14zMuxoIYC4YNdSzN2Fhe
rwehGTQT+iDDmgEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOBo5vn8x9B9T+p35
V2LZJC5bVcqlNm5H2N7JBaVtUdUmSlP3F/ZM4WaUNk3isLBMD1at3974Zr4o
rWSlCfsLu6ZwM0qbVgUYqaQHO4VhR7hZVZsoTZgU9kzhZpScUpaDwqQu8m1e
wyJR2mpVsXnBdhRuRskpZTkoTOqCzWsClLZtUtgtepM4U2aUtUmTuDWqMmct
l0Npsy8borT1qtpEabqksGeKNaOcLWN7Dz4sLAXB9zv0o/fqUdo6VfkHN0kK
pVOoGaVNkzgsLIXBt+PeyG8BpRWrtLAgFA0mcZ5gYZk4FErzBKUpksIBwCTO
DRaWiqFQmhuUpkoKAAAAAAAAAB3+B54uQRE=
    "], {{0, 84}, {575, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{575, 84},
  PlotRange->{{0, 575}, {0, 84}}]], "Output",
 ImageSize->{579, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221337752]
}, Open  ]],

Cell[TextData[{
 "We now carefully look at the output. The first part of it is {{1, 2}, {3, \
4}}, and it tells us that there are two groups of equal representations in \
the product: representation #1 and #2 are equal (group1), and representations \
#3 and #4 are also the same (group2). This is manifestly true by looking at \
the input (the {SU2} representations are {{{1}}, {{1}}, {{2}}, {{2}}}). The \
next part of the output contains the following items:\[LineSeparator]\
\[LineSeparator]{{{{8}}, {{2}, {2}}}, 1}\[LineSeparator]{{{{4}}, {{2}, {2}}}, \
2}\[LineSeparator]{{{{6}}, {{2}, {2}}}, 1}\[LineSeparator]{{{{0}}, {{2}, \
{2}}}, 1}\[LineSeparator]{{{{2}}, {{2}, {2}}}, 1}\[LineSeparator]{{{{6}}, \
{{2}, {1, 1}}}, 1}\[LineSeparator]{{{{2}}, {{2}, {1, 1}}}, \
2}\[LineSeparator]{{{{4}}, {{2}, {1, 1}}}, 1}\[LineSeparator]{{{{6}}, {{1, \
1}, {2}}}, 1}\[LineSeparator]{{{{2}}, {{1, 1}, {2}}}, \
1}\[LineSeparator]{{{{4}}, {{1, 1}, {1, 1}}}, 1}\[LineSeparator]{{{{0}}, {{1, \
1}, {1, 1}}}, 1}\[LineSeparator]\[LineSeparator]They all follow the form \
{<{SU2} representation>, {<",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula"],
 " representation induced by a permutation of the fields in group1 (rep #1 \
and rep #2)>,<",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula"],
 " representation induced by a permutation of the fields in group2 (rep #3 \
and rep #4)>}, <multiplicity>}",
 StyleBox[". \[LineSeparator]\[LineSeparator]", "TR"],
 "For example, {{{{8}}, {{2}, {2}}}, 1} tells us that in the product \
{1}x{1}x{3}x{3} of SU2 representations there is an {8}, and it is in a \
symmetric combination of the {1}'s (i.e., it is in the  representation {2} of \
the permutation group ",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula"],
 "), and it is also in a symmetric combination of the {3}'s  (again, \
symbolically this is the same as saying that it is in the representation {2} \
of the permutation group ",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula"],
 ").\[LineSeparator]\[LineSeparator]Another example: {{{{6}}, {{2}, {1, 1}}}, \
1}. It means that in the product {1}x{1}x{3}x{3} of SU2 there is one \
representation {6} of SU2 (7-dimensional), which is symmetric under a \
permutation of the {1}'s (irrep {2} of ",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula"],
 ") and antisymmetric under a permutation of the {3}'s (irrep {1,1} of ",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula"],
 ")."
}], "ExampleText",
 CellID->151918977],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->87747050],

Cell["\<\
Consider now the product of 3 triplets of SU3 with a singlet:\
\>", "ExampleText",
 CellID->425739455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermutationSymmetryOfTensorProductParts", "[", 
  RowBox[{
   RowBox[{"{", "SU3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->631183171],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"3", ",", "0"}], "}"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "3", "}"}], ",", 
           RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2", ",", "1"}], "}"}], ",", 
           RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
           RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}], ",", "1"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{452, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->185989622]
}, Open  ]],

Cell[TextData[{
 "The output informs us that representations #1, #2, #4 are equal (group1), \
and then there is representation #3. The product {{1, 0}}x{{1, 0}}x{{0, \
0}}x{{1, 0}} of {SU3} representations breaks down in representations of \
{SU3}x",
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula"],
 "x",
 Cell[BoxData[
  SubscriptBox["S", "1"]], "InlineFormula"],
 " as follows:\[LineSeparator]{{{{3, 0}}, {{3}, {1}}}, \
1}\[LineSeparator]{{{{1, 1}}, {{2, 1}, {1}}}, 1}\[LineSeparator]{{{{0, 0}}, \
{{1, 1, 1}, {1}}}, 1}\[LineSeparator]\[LineSeparator]In words, there is one \
{{3, 0}}x{3}x{1}, one {{1, 1}}x{2,1}x{1}, and one {{0, 0}}x{1,1,1}x{1} \
representation of the {SU3}x",
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula"],
 "x",
 Cell[BoxData[
  SubscriptBox["S", "1"]], "InlineFormula"],
 " group. Note that it would be wrong to think that there is only one {{1,1}} \
representation of {SU3} in the product because the representation {2,1} of ",
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula"],
 " is 2-dimensinal:"
}], "ExampleText",
 CellID->651730668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SnIrrepDim", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->140558511],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53032437]
}, Open  ]],

Cell[TextData[{
 "Indeed, using the ",
 StyleBox[ButtonBox["ReduceRepProduct",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/ReduceRepProduct"], "Code"],
 " function which deals only with the decomposition into irreducible \
representations of the gauge group, we get"
}], "ExampleText",
 CellID->289351674],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->216308175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{253, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->76952409]
}, Open  ]],

Cell["The dimensions add up:", "ExampleText",
 CellID->176196727],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DimR", "[", 
    RowBox[{"SU3", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "]"}], "^", "3"}], " ", 
  RowBox[{"DimR", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DimR", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "0"}], "}"}]}], "]"}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"DimR", "[", 
    RowBox[{"SU3", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "+", 
  RowBox[{"DimR", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->100031268],

Cell[BoxData["27"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->590574086],

Cell[BoxData["27"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->84698464]
}, Open  ]],

Cell["\<\
Once the output format of the PermutationSymmetryOfTensorProductParts is \
understood, it can be parsed easily:\
\>", "ExampleText",
 CellID->544317391],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"result", "=", 
    RowBox[{"PermutationSymmetryOfTensorProductParts", "[", 
     RowBox[{
      RowBox[{"{", "SO10", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], "}"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], 
         "}"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"Style", "[", 
     RowBox[{
     "\"\<>>> The product of SO(10) representations 10x10x16x16 breaks as \
follows:\>\"", ",", "Bold"}], "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"irrep", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"irrep", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "1"}], ",", 
         "\"\< time\>\"", ",", "\"\< times\>\""}], "]"}], ",", 
       "\"\< the SO(10) representation \>\"", ",", 
       RowBox[{"irrep", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1", ",", "1"}], "]"}], "]"}], ",", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"irrep", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "2", ",", "1"}], "]"}], "]"}], "===", 
          RowBox[{"{", "2", "}"}]}], ",", "\"\< in a symmetric\>\"", ",", 
         "\"\< in an antisymmetric\>\""}], "]"}], ",", 
       "\"\< configuration of the 10's and \>\"", ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"irrep", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "2", ",", "2"}], "]"}], "]"}], "===", 
          RowBox[{"{", "2", "}"}]}], ",", "\"\< in a symmetric\>\"", ",", 
         "\"\< in an antisymmetric\>\""}], "]"}], ",", 
       "\"\< configuration of the 16's.\>\""}], "]"}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"irrep", ",", 
      RowBox[{"result", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellLabel->"In[5]:=",
 CellID->419989149],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\">>> The product of SO(10) representations 10x10x16x16 breaks \
as follows:\"\>",
  StripOnInput->False,
  FontWeight->Bold]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->466805490],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {2, 0, 0, 0, 2}, 
   " in a symmetric", " configuration of the 10's and ", " in a symmetric", 
   " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->774740358],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 0, 0, 2, 0}, 
   " in a symmetric", " configuration of the 10's and ", " in a symmetric", 
   " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->115388594],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 0, 0, 1, 1}, 
   " in a symmetric", " configuration of the 10's and ", " in a symmetric", 
   " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->71234362],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {3, 0, 0, 0, 0}, 
   " in a symmetric", " configuration of the 10's and ", " in a symmetric", 
   " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->28477018],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 1, 0, 0, 0}, 
   " in a symmetric", " configuration of the 10's and ", " in a symmetric", 
   " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->14324273],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\" times\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  2, " times", " the SO(10) representation ", {1, 0, 0, 0, 0}, 
   " in a symmetric", " configuration of the 10's and ", " in a symmetric", 
   " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->71060304],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {2, 0, 1, 0, 0}, 
   " in a symmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->139330917],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\" times\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  2, " times", " the SO(10) representation ", {0, 0, 1, 0, 0}, 
   " in a symmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->38371167],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 0, 0, 1, 1}, 
   " in a symmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->9303816],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 1, 0, 0, 0}, 
   " in a symmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->66794255],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 0, 0, 0, 2}, 
   " in a symmetric", " configuration of the 10's and ", " in a symmetric", 
   " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->846789555],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 1, 0, 0, 2}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in a symmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->200207895],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 0, 0, 1, 1}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in a symmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->281840598],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\" times\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  2, " times", " the SO(10) representation ", {0, 0, 1, 0, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in a symmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->6123158],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 0, 0, 0, 2}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in a symmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->6881588],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 1, 0, 0, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in a symmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->482982862],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 0, 0, 0, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in a symmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->386984469],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 1, 1, 0, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->67802601],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 0, 0, 1, 1}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->741917247],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 1, 0, 0, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->934711805],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 0, 0, 0, 2}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->81344691],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 0, 0, 2, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->520053330],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 0, 1, 0, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->514994521],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 0, 0, 0, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->713384163]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell["\<\
M. A. A. van Leeuwen, A. M. Cohen, and B. Lisser, LiE, A Package for Lie \
Group Computations. Computer Algebra Nederland, 1992\
\>", "MoreAbout",
 CellID->1665078683],

Cell[TextData[{
 "M. A. A. van Leeuwen, A. M. Cohen, and B. Lisser, \
\[OpenCurlyDoubleQuote]LiE - A Computer algebra package for Lie group \
computations.\[CloseCurlyDoubleQuote] ",
 ButtonBox["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None},
  ButtonNote->"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"],
 ", 2012. Retrieved March 17, 2013."
}], "MoreAbout",
 CellID->867725]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED DEMONSTRATIONS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedDemonstrationsSection",
 CellID->1268215905],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InvariantPlethysms",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/InvariantPlethysms"]], "InlineFormula"],
 " \[EmptyVerySmallSquare] ",
 Cell[BoxData[
  ButtonBox["PermutationSymmetryOfInvariants",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/PermutationSymmetryOfInvariants"]], 
  "InlineFormula"],
 " \[EmptyVerySmallSquare] ",
 Cell[BoxData[
  ButtonBox["Plethysms",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/Plethysms"]], "InlineFormula"],
 " \[EmptyVerySmallSquare] ",
 Cell[BoxData[
  ButtonBox["ReduceRepProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/ReduceRepProduct"]], "InlineFormula"]
}], "RelatedDemonstrations",
 CellID->1129518860]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 729},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PermutationSymmetryOfTensorProductParts - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2014, 12, 18, 10, 47, 30.2466257}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "PermutationSymmetryOfTensorProductParts[gauge group, list of \
representations] Computes the irreducible parts (irreps) in the product of \
the representations of the gauge group provided, together with the \
information on how these irreps change under a permutation of the \
representations being multiplied", "synonyms" -> {}, "title" -> 
    "PermutationSymmetryOfTensorProductParts", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/PermutationSymmetryOfTensorProductParts"}, "LinkTrails" -> "",
   "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "9.0 for Microsoft Windows (64-bit) (January 25, 2013)", 
  StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "10.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion.nb", CharacterEncoding -> "WindowsANSI"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11493, 327, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->244639072]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 52135, 1444}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[632, 21, 76, 1, 70, "SymbolColorBar"],
Cell[711, 24, 178, 5, 70, "LinkTrail"],
Cell[892, 31, 4116, 96, 70, "AnchorBarGrid",
 CellID->1],
Cell[5011, 129, 82, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[CellGroupData[{
Cell[5118, 134, 723, 18, 70, "Usage",
 CellID->982511436],
Cell[CellGroupData[{
Cell[5866, 156, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->219257745],
Cell[6449, 175, 271, 9, 70, "Notes",
 CellID->149353492],
Cell[6723, 186, 195, 5, 70, "Notes",
 CellID->190293714],
Cell[6921, 193, 993, 24, 70, "Notes",
 CellID->757085513],
Cell[7917, 219, 2906, 83, 70, "Notes",
 CellID->311445735],
Cell[10826, 304, 618, 17, 70, "Notes",
 CellID->586435317]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11493, 327, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->244639072],
Cell[CellGroupData[{
Cell[11979, 344, 148, 5, 70, "ExampleSection",
 CellID->278269351],
Cell[12130, 351, 208, 5, 70, "ExampleText",
 CellID->21576093],
Cell[CellGroupData[{
Cell[12363, 360, 464, 15, 28, "Input",
 CellID->39678609],
Cell[12830, 377, 3269, 61, 98, "Output",
 CellID->221337752]
}, Open  ]],
Cell[16114, 441, 2517, 47, 70, "ExampleText",
 CellID->151918977],
Cell[CellGroupData[{
Cell[18656, 492, 124, 3, 70, "ExampleDelimiter",
 CellID->87747050],
Cell[18783, 497, 112, 3, 70, "ExampleText",
 CellID->425739455],
Cell[CellGroupData[{
Cell[18920, 504, 577, 19, 70, "Input",
 CellID->631183171],
Cell[19500, 525, 1466, 50, 54, "Output",
 CellID->185989622]
}, Open  ]],
Cell[20981, 578, 1097, 26, 70, "ExampleText",
 CellID->651730668],
Cell[CellGroupData[{
Cell[22103, 608, 153, 5, 70, "Input",
 CellID->140558511],
Cell[22259, 615, 157, 5, 36, "Output",
 CellID->53032437]
}, Open  ]],
Cell[22431, 623, 315, 8, 70, "ExampleText",
 CellID->289351674],
Cell[CellGroupData[{
Cell[22771, 635, 418, 14, 70, "Input",
 CellID->216308175],
Cell[23192, 651, 519, 19, 36, "Output",
 CellID->76952409]
}, Open  ]],
Cell[23726, 673, 65, 1, 70, "ExampleText",
 CellID->176196727],
Cell[CellGroupData[{
Cell[23816, 678, 748, 26, 70, "Input",
 CellID->100031268],
Cell[24567, 706, 159, 5, 36, "Output",
 CellID->590574086],
Cell[24729, 713, 158, 5, 36, "Output",
 CellID->84698464]
}, Open  ]],
Cell[24902, 721, 162, 4, 70, "ExampleText",
 CellID->544317391],
Cell[CellGroupData[{
Cell[25089, 729, 2744, 77, 70, "Input",
 CellID->419989149],
Cell[CellGroupData[{
Cell[27858, 810, 227, 6, 70, "Print",
 CellID->466805490],
Cell[28088, 818, 785, 18, 70, "Print",
 CellID->774740358],
Cell[28876, 838, 785, 18, 70, "Print",
 CellID->115388594],
Cell[29664, 858, 784, 18, 70, "Print",
 CellID->71234362],
Cell[30451, 878, 784, 18, 70, "Print",
 CellID->28477018],
Cell[31238, 898, 784, 18, 70, "Print",
 CellID->14324273],
Cell[32025, 918, 786, 18, 70, "Print",
 CellID->71060304],
Cell[32814, 938, 795, 18, 70, "Print",
 CellID->139330917],
Cell[33612, 958, 796, 18, 70, "Print",
 CellID->38371167],
Cell[34411, 978, 793, 18, 70, "Print",
 CellID->9303816],
Cell[35207, 998, 794, 18, 70, "Print",
 CellID->66794255],
Cell[36004, 1018, 785, 18, 70, "Print",
 CellID->846789555],
Cell[36792, 1038, 795, 18, 70, "Print",
 CellID->200207895],
Cell[37590, 1058, 795, 18, 70, "Print",
 CellID->281840598],
Cell[38388, 1078, 795, 18, 70, "Print",
 CellID->6123158],
Cell[39186, 1098, 793, 18, 70, "Print",
 CellID->6881588],
Cell[39982, 1118, 795, 18, 70, "Print",
 CellID->482982862],
Cell[40780, 1138, 795, 18, 70, "Print",
 CellID->386984469],
Cell[41578, 1158, 804, 18, 70, "Print",
 CellID->67802601],
Cell[42385, 1178, 805, 18, 70, "Print",
 CellID->741917247],
Cell[43193, 1198, 805, 18, 70, "Print",
 CellID->934711805],
Cell[44001, 1218, 804, 18, 70, "Print",
 CellID->81344691],
Cell[44808, 1238, 805, 18, 70, "Print",
 CellID->520053330],
Cell[45616, 1258, 805, 18, 70, "Print",
 CellID->514994521],
Cell[46424, 1278, 805, 18, 70, "Print",
 CellID->713384163]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47314, 1305, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[47736, 1319, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[47924, 1327, 419, 12, 70, "MoreAboutSection",
 CellID->38303248],
Cell[48346, 1341, 177, 4, 70, "MoreAbout",
 CellID->1665078683],
Cell[48526, 1347, 489, 11, 70, "MoreAbout",
 CellID->867725]
}, Open  ]],
Cell[CellGroupData[{
Cell[49052, 1363, 445, 12, 70, "RelatedDemonstrationsSection",
 CellID->1268215905],
Cell[49500, 1377, 745, 22, 70, "RelatedDemonstrations",
 CellID->1129518860]
}, Open  ]],
Cell[50260, 1402, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

