(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     13854,        487]
NotebookOptionsPosition[      9943,        360]
NotebookOutlinePosition[     11763,        409]
CellTagsIndexPosition[     11678,        404]
WindowTitle->Adjoint - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/Adjoint\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/Adjoint"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/Adjoint.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", "Susyno/ref/Adjoint",
              ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["Adjoint", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Adjoint", "[", "group", "]"}]], "InlineFormula"],
     " \n\tReturns the adjoint representation of  ",
     Cell[BoxData["group"], "InlineFormula"]
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Adjoint", "[", 
       RowBox[{"{", 
        RowBox[{"group1", ",", "group2", ",", "..."}], "}"}], "]"}]], 
      "InlineFormula"],
     " \n\tReturns the adjoint representations of the ",
     Cell[BoxData["group1"], "InlineFormula"],
     ", ",
     Cell[BoxData["group2"], "InlineFormula"],
     ", ..."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->101244157],

Cell[TextData[{
 "Argument ",
 Cell[BoxData["group"], "InlineFormula"],
 " should be the ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 " of the group."
}], "Notes",
 CellID->416274567],

Cell[TextData[{
 "This method outputs the Dynkin coefficients of the adjoint representation \
of ",
 Cell[BoxData["group"], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "A list of Cartan matrices ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"group1", ",", " ", "group2", ",", "..."}], "}"}]], 
  "InlineFormula"],
 " can also be used as input. The output is the list of adjoint \
representations of the given groups."
}], "Notes",
 CellID->68145961]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->624311651],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->437218431],

Cell["\<\
The adjoint representation of SU(2) is the triplet representation [={2} in \
Dynkin coefficients]:\
\>", "ExampleText",
 CellID->283112903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Adjoint", "[", "SU2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->473091279],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191772224]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76102934],

Cell["Two more examples:", "ExampleText",
 CellID->753055023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Adjoint", "[", "SU5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->297272364],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "0", ",", "1"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155344506]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Adjoint", "[", "SO10", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->130136287],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134837845]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213248056],

Cell["\<\
If a list of simple groups is given, a list of representations is returned.\
\>", "ExampleText",
 CellID->167344756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Adjoint", "[", 
  RowBox[{"{", 
   RowBox[{"SU2", ",", "SU5", ",", "SO10"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72297960],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{229, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21508305]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CartanMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/CartanMatrix"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["PositiveRoots",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/PositiveRoots"]], "InlineFormula"]
}], "RelatedLinks",
 CellID->56765791]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 729},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Adjoint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2014, 12, 18, 10, 47, 7.8636904}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "Adjoint[group] Returns the adjoint representation of \
groupAdjoint[{group1, group2, ...}] Returns the adjoint representations of \
the group1, group2, ...", "synonyms" -> {}, "title" -> "Adjoint", "type" -> 
    "Symbol", "uri" -> "Susyno/ref/Adjoint"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "9.0 for Microsoft Windows (64-bit) (January 25, 2013)", 
  StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "10.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion.nb", CharacterEncoding -> "WindowsANSI"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5402, 172, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->624311651]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11535, 397}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[600, 21, 76, 1, 70, "SymbolColorBar"],
Cell[679, 24, 178, 5, 70, "LinkTrail"],
Cell[860, 31, 2293, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[3156, 86, 50, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[CellGroupData[{
Cell[3231, 91, 791, 24, 70, "Usage",
 CellID->982511436],
Cell[CellGroupData[{
Cell[4047, 119, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->101244157],
Cell[4630, 138, 240, 9, 70, "Notes",
 CellID->416274567],
Cell[4873, 149, 180, 6, 70, "Notes",
 CellID->1067943069],
Cell[5056, 157, 297, 9, 70, "Notes",
 CellID->68145961]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5402, 172, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->624311651],
Cell[CellGroupData[{
Cell[5888, 189, 148, 5, 70, "ExampleSection",
 CellID->437218431],
Cell[6039, 196, 149, 4, 70, "ExampleText",
 CellID->283112903],
Cell[CellGroupData[{
Cell[6213, 204, 105, 3, 70, "Input",
 CellID->473091279],
Cell[6321, 209, 180, 6, 36, "Output",
 CellID->191772224]
}, Open  ]],
Cell[CellGroupData[{
Cell[6538, 220, 124, 3, 70, "ExampleDelimiter",
 CellID->76102934],
Cell[6665, 225, 61, 1, 70, "ExampleText",
 CellID->753055023],
Cell[CellGroupData[{
Cell[6751, 230, 105, 3, 70, "Input",
 CellID->297272364],
Cell[6859, 235, 223, 7, 36, "Output",
 CellID->155344506]
}, Open  ]],
Cell[CellGroupData[{
Cell[7119, 247, 106, 3, 70, "Input",
 CellID->130136287],
Cell[7228, 252, 233, 7, 36, "Output",
 CellID->134837845]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7510, 265, 125, 3, 70, "ExampleDelimiter",
 CellID->213248056],
Cell[7638, 270, 126, 3, 70, "ExampleText",
 CellID->167344756],
Cell[CellGroupData[{
Cell[7789, 277, 166, 5, 70, "Input",
 CellID->72297960],
Cell[7958, 284, 388, 13, 36, "Output",
 CellID->21508305]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8419, 305, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[8841, 319, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[9029, 327, 427, 12, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[9459, 341, 442, 14, 70, "RelatedLinks",
 CellID->56765791]
}, Open  ]],
Cell[9916, 358, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

