(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     16810,        547]
NotebookOptionsPosition[     13643,        449]
NotebookOutlinePosition[     15395,        497]
CellTagsIndexPosition[     15310,        492]
WindowTitle->GenerateModel - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/GenerateModel\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/GenerateModel"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
GenerateModel.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/GenerateModel", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["GenerateModel", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GenerateModel", "[", "model", "]"}]], "InlineFormula"],
     " \[LineSeparator]Computes several properties of a given ",
     Cell[BoxData["model"], "InlineFormula"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->222362710],

Cell[TextData[{
 Cell[BoxData["model"], "InlineFormula"],
 " must be a variable with the properties ",
 Cell[BoxData["group"], "InlineFormula"],
 ", ",
 Cell[BoxData["reps"], "InlineFormula"],
 ", ",
 Cell[BoxData["fieldNames"], "InlineFormula"],
 ", ",
 Cell[BoxData["nFlavs"], "InlineFormula"],
 ", and ",
 Cell[BoxData["discreteSym"], "InlineFormula"],
 " assigned. These assignments can be made with the code ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"group", "[", "model", "]"}], "^=", "..."}]], "InlineFormula"],
 ",  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"reps", "[", "model", "]"}], "^=", "..."}]], "InlineFormula"],
 ",  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"fieldsNames", "[", "model", "]"}], "^=", "..."}]], 
  "InlineFormula"],
 ",  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"nFlavs", "[", "model", "]"}], "^=", "..."}]], "InlineFormula"],
 ",  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"discreteSym", "[", "model", "]"}], "^=", "..."}]], 
  "InlineFormula"],
 " (see the ",
 ButtonBox["Susyno tutorial",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"],
 ")."
}], "Notes",
 CellID->1067943069],

Cell["\<\
The output is printed on screen and includes: (a) reproduction of input \
information (model name, gauge group, representations in the model, number of \
flavors, discrete symmetries), (b) check of gauge anomalies, (c) Lagrangian \
parameters (one for each possible gauge invariant term), (d) two-loop \
renormalization group equations.\
\>", "Notes",
 CellID->22424971],

Cell[TextData[{
 "This function accepts two options: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Verbose", "->", "True"}], ",", " ", "False"}]], "InlineFormula"],
 " (default is ",
 Cell[BoxData["True"], "InlineFormula"],
 ") and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"CalculateEverything", "->", "True"}], ",", " ", "False"}]], 
  "InlineFormula"],
 " (default is ",
 Cell[BoxData["False"], "InlineFormula"],
 ")."
}], "Notes",
 CellID->394246396],

Cell[TextData[{
 "If  ",
 Cell[BoxData[
  RowBox[{"Verbose", "->", "False"}]], "InlineFormula"],
 ", results are not printed on screen\[LongDash]the user can still access the \
calculated information through the variables ",
 Cell[BoxData[
  RowBox[{"parameters", "[", "model", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"betaFunctions", "[", "model", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->303834471],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"parameters", "[", "model", "]"}]], "InlineFormula"],
 " is a list with the form {{<gauge couplings>},{<gaugino \
masses>},{<trilinear superpotential parameters>}, {<bilinear superpotential \
parameters>},{<linear superpotential parameters>}, {trilinear parameters in ",
 Cell[BoxData[
  RowBox[{"-", 
   SubscriptBox["\[GothicCapitalL]", "soft"]}]], "InlineFormula"],
 "}, {bilinear parameters in ",
 Cell[BoxData[
  RowBox[{"-", 
   SubscriptBox["\[GothicCapitalL]", "soft"]}]], "InlineFormula"],
 "}, {linear parameters in ",
 Cell[BoxData[
  RowBox[{"-", 
   SubscriptBox["\[GothicCapitalL]", "soft"]}]], "InlineFormula"],
 "}, {soft SUSY breaking masses}}."
}], "Notes",
 CellID->369147650],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"betaFunctions", "[", "model", "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"i", ",", "1", ",", "j"}], "]"}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"betaFunctions", "[", "model", "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"i", ",", "2", ",", "j"}], "]"}], "]"}]], "InlineFormula"],
 " contain the 1- and 2-loop \[Beta]-functions of the parameter ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"parameters", "[", "model", "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"i", ",", "j"}], "]"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->374087497],

Cell[TextData[{
 "The program by default will not compute the Lagrangian (superpotential and  \
",
 Cell[BoxData[
  RowBox[{"-", 
   SubscriptBox["\[GothicCapitalL]", "soft"]}]], "InlineFormula"],
 ") explicitly. However, this can be done with the option ",
 Cell[BoxData[
  RowBox[{"CalculateEverything", "->", "True"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->509768460]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->252912614],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->228719283],

Cell["The MSSM:", "ExampleText",
 CellID->283112903],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"group", "[", "myMSSM", "]"}], "^=", 
    RowBox[{"{", 
     RowBox[{"U1", ",", "SU2", ",", "SU3"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"normalization", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"3", "/", "5"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "/", "3"}], " ", "normalization"}], ",", 
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "/", "3"}], " ", "normalization"}], ",", 
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "/", "6"}], " ", "normalization"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"{", 
    RowBox[{"normalization", ",", 
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], " ", "normalization"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hu", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "/", "2"}], " ", "normalization"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Hd", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], " ", "normalization"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"reps", "[", "myMSSM", "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{
    "u", ",", "d", ",", "Q", ",", "e", ",", "L", ",", "Hu", ",", "Hd"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fieldNames", "[", "myMSSM", "]"}], "^=", 
    RowBox[{"{", 
     RowBox[{
     "\"\<u\>\"", ",", "\"\<d\>\"", ",", "\"\<Q\>\"", ",", "\"\<e\>\"", ",", 
      "\"\<L\>\"", ",", "\"\<Hu\>\"", ",", "\"\<Hd\>\""}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"nFlavs", "[", "myMSSM", "]"}], "^=", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "1", ",", "1"}], 
     "}"}]}], ";", 
   RowBox[{
    RowBox[{"discreteSym", "[", "myMSSM", "]"}], "^=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}], ",", "1", ",", "1"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"GenerateModel", "[", "myMSSM", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->239043150],

Cell["To compute the Lagrangian explicitly, ", "ExampleText",
 CellID->618185856],

Cell[BoxData[
 RowBox[{"GenerateModel", "[", 
  RowBox[{"myMSSM", ",", 
   RowBox[{"CalculateEverything", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->705999126]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 729},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GenerateModel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2014, 7, 24, 0, 39, 14.8851758}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "GenerateModel[model] Computes several properties of a given model", 
    "synonyms" -> {}, "title" -> "GenerateModel", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/GenerateModel"}, "LinkTrails" -> "", "SearchTextTranslated" -> 
  ""},
CellContext->"Global`",
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "9.0 for Microsoft Windows (64-bit) (January 25, 2013)", 
  StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "10.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion.nb", CharacterEncoding -> "WindowsANSI"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8504, 270, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->252912614]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15167, 485}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[606, 21, 76, 1, 70, "SymbolColorBar"],
Cell[685, 24, 178, 5, 70, "LinkTrail"],
Cell[866, 31, 2318, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[3187, 86, 56, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[CellGroupData[{
Cell[3268, 91, 428, 12, 70, "Usage",
 CellID->982511436],
Cell[CellGroupData[{
Cell[3721, 107, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->222362710],
Cell[4304, 126, 1132, 40, 70, "Notes",
 CellID->1067943069],
Cell[5439, 168, 380, 7, 70, "Notes",
 CellID->22424971],
Cell[5822, 177, 447, 16, 70, "Notes",
 CellID->394246396],
Cell[6272, 195, 433, 13, 70, "Notes",
 CellID->303834471],
Cell[6708, 210, 736, 19, 70, "Notes",
 CellID->369147650],
Cell[7447, 231, 627, 20, 70, "Notes",
 CellID->374087497],
Cell[8077, 253, 378, 11, 70, "Notes",
 CellID->509768460]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8504, 270, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->252912614],
Cell[CellGroupData[{
Cell[8990, 287, 148, 5, 70, "ExampleSection",
 CellID->228719283],
Cell[9141, 294, 52, 1, 70, "ExampleText",
 CellID->283112903],
Cell[9196, 297, 3508, 114, 70, "Input",
 CellID->239043150],
Cell[12707, 413, 81, 1, 70, "ExampleText",
 CellID->618185856],
Cell[12791, 416, 188, 5, 70, "Input",
 CellID->705999126]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13028, 427, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[13450, 441, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[13616, 447, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

