(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     21507,        692]
NotebookOptionsPosition[     17325,        559]
NotebookOutlinePosition[     19163,        608]
CellTagsIndexPosition[     19078,        603]
WindowTitle->DecomposeSnProduct - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/DecomposeSnProduct\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/DecomposeSnProduct"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
DecomposeSnProduct.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/DecomposeSnProduct", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["DecomposeSnProduct", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DecomposeSnProduct", "[", 
       RowBox[{"list", " ", "of", " ", "partitions", " ", "of", " ", "n"}], 
       "]"}]], "InlineFormula"],
     " \[LineSeparator]Decomposes the product of representations of the \
permutation group ",
     Cell[BoxData[
      SubscriptBox["S", "n"]], "InlineFormula"],
     " in irreducible parts"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->837063160],

Cell[TextData[{
 "The irreducible representations of the permutation group ",
 Cell[BoxData[
  SubscriptBox["S", "n"]], "InlineFormula"],
 " can be identified with the partitions of the integer number ",
 Cell[BoxData["n"], "InlineFormula"],
 ": they can be computed using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " built in function ",
 Cell[BoxData[
  ButtonBox["IntegerPartitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Therefore, given a list of partitions {",
 Cell[BoxData["\[Lambda]"], "InlineFormula"],
 ",",
 Cell[BoxData[
  RowBox[{"\[Lambda]", "'"}]], "InlineFormula"],
 ",...}, this method will output the irreducible representations of the group \
",
 Cell[BoxData[
  SubscriptBox["S", "n"]], "InlineFormula"],
 " (which are partitions of ",
 Cell[BoxData["n"], "InlineFormula"],
 ") in the product ",
 Cell[BoxData["\[Lambda]"], "InlineFormula"],
 "\[Times]",
 Cell[BoxData[
  RowBox[{"\[Lambda]", "'"}]], "InlineFormula"],
 "\[Times]\[CenterEllipsis]"
}], "Notes",
 CellID->582793822],

Cell[TextData[{
 "In fact, this method returns the multiplicity of each partition in this \
product: the output is a list {",
 Cell[BoxData[
  SubscriptBox["m", "1"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["m", "2"]], "InlineFormula"],
 ",\[CenterEllipsis]} where ",
 Cell[BoxData[
  SubscriptBox["m", "i"]], "InlineFormula"],
 " is the number of times the partition ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"IntegerPartitions", "[", "n", "]"}], "[", 
   RowBox[{"[", "i", "]"}], "]"}]], "InlineFormula"],
 " is contained in the product  ",
 Cell[BoxData["\[Lambda]"], "InlineFormula"],
 "\[Times]",
 Cell[BoxData[
  RowBox[{"\[Lambda]", "'"}]], "InlineFormula"],
 "\[Times]\[CenterEllipsis]"
}], "Notes",
 CellID->753473984]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20701137],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->320543007],

Cell[TextData[{
 "Consider ",
 Cell[BoxData[
  SubscriptBox["S", "6"]], "InlineFormula"],
 ", the permutation group of 6 elements. Its irreducible representations are \
identified with the partitions of 6:"
}], "ExampleText",
 CellID->32979335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", "6", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->474503469],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{411, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->427088958]
}, Open  ]],

Cell[TextData[{
 "So, there are 11 different irreducible representations of  ",
 Cell[BoxData[
  SubscriptBox["S", "6"]], "InlineFormula"],
 ". The product {4, 2}\[Times]{3, 2, 1}\[Times]{3, 2, 1} decomposes as \
follows:"
}], "ExampleText",
 CellID->763521970],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"multiplicities", "=", 
  RowBox[{"DecomposeSnProduct", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<{4, 2}\[Times]{3, 2, 1}\[Times]{3, 2, 1} contains ...\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<... \>\"", ",", 
       RowBox[{"multiplicities", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
       "\"\< times the representation \>\"", ",", 
       RowBox[{
        RowBox[{"IntegerPartitions", "[", "6", "]"}], "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], " ", "]"}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "multiplicities", "]"}]}], "}"}]}], "]"}], 
  ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->280814282],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "16", ",", "29", ",", "32", ",", "16", ",", "51", ",", "32", ",", 
   "16", ",", "29", ",", "16", ",", "3"}], "}"}]], "Output",
 ImageSize->{268, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->396550785],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->485296440],

Cell[BoxData["\<\"{4, 2}\[Times]{3, 2, 1}\[Times]{3, 2, 1} contains \
...\"\>"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->60279877],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"... \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" times the representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["... ", 3, " times the representation ", {6}],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->289199188],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"... \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" times the representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1"}], "}"}]}],
  SequenceForm["... ", 16, " times the representation ", {5, 1}],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->620085649],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"... \"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" times the representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}]}],
  SequenceForm["... ", 29, " times the representation ", {4, 2}],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->10435575],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"... \"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\" times the representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["... ", 32, " times the representation ", {4, 1, 1}],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->140446283],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"... \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" times the representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["... ", 16, " times the representation ", {3, 3}],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->38176322],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"... \"\>", "\[InvisibleSpace]", "51", 
   "\[InvisibleSpace]", "\<\" times the representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}]}],
  SequenceForm["... ", 51, " times the representation ", {3, 2, 1}],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->125189955],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"... \"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\" times the representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["... ", 32, " times the representation ", {3, 1, 1, 1}],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->75398702],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"... \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" times the representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["... ", 16, " times the representation ", {2, 2, 2}],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->371444477],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"... \"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" times the representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["... ", 29, " times the representation ", {2, 2, 1, 1}],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->596448161],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"... \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" times the representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["... ", 16, " times the representation ", {2, 1, 1, 1, 1}],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->598289927],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"... \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" times the representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["... ", 3, " times the representation ", {1, 1, 1, 1, 1, 1}],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->187172730]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HookContentFormula",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/HookContentFormula"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["SnClassCharacter",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/SnClassCharacter"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["SnClassOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/SnClassOrder"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["SnIrrepDim",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/SnIrrepDim"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["SnIrrepGenerators",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/SnIrrepGenerators"]], "InlineFormula"]
}], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 729},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DecomposeSnProduct - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2014, 7, 24, 0, 39, 11.7951122}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "DecomposeSnProduct[list of partitions of n] Decomposes the product of \
representations of the permutation group S_n in irreducible parts", 
    "synonyms" -> {}, "title" -> "DecomposeSnProduct", "type" -> "Symbol", 
    "uri" -> "Susyno/ref/DecomposeSnProduct"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "9.0 for Microsoft Windows (64-bit) (January 25, 2013)", 
  StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "10.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion.nb", CharacterEncoding -> "WindowsANSI"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6415, 199, 460, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->20701137]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18936, 596}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[611, 21, 76, 1, 70, "SymbolColorBar"],
Cell[690, 24, 178, 5, 70, "LinkTrail"],
Cell[871, 31, 2338, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[3212, 86, 61, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[CellGroupData[{
Cell[3298, 91, 591, 17, 70, "Usage",
 CellID->982511436],
Cell[CellGroupData[{
Cell[3914, 112, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->837063160],
Cell[4497, 131, 528, 16, 70, "Notes",
 CellID->1067943069],
Cell[5028, 149, 594, 19, 70, "Notes",
 CellID->582793822],
Cell[5625, 170, 741, 23, 70, "Notes",
 CellID->753473984]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6415, 199, 460, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20701137],
Cell[CellGroupData[{
Cell[6900, 216, 148, 5, 70, "ExampleSection",
 CellID->320543007],
Cell[7051, 223, 244, 7, 70, "ExampleText",
 CellID->32979335],
Cell[CellGroupData[{
Cell[7320, 234, 113, 3, 70, "Input",
 CellID->474503469],
Cell[7436, 239, 951, 29, 54, "Output",
 CellID->427088958]
}, Open  ]],
Cell[8402, 271, 261, 7, 70, "ExampleText",
 CellID->763521970],
Cell[CellGroupData[{
Cell[8688, 282, 1194, 37, 70, "Input",
 CellID->280814282],
Cell[9885, 321, 310, 9, 36, "Output",
 CellID->396550785],
Cell[CellGroupData[{
Cell[10220, 334, 98, 2, 70, "Print",
 CellID->485296440],
Cell[10321, 338, 152, 3, 70, "Print",
 CellID->60279877],
Cell[10476, 343, 360, 9, 70, "Print",
 CellID->289199188],
Cell[10839, 354, 390, 10, 70, "Print",
 CellID->620085649],
Cell[11232, 366, 389, 10, 70, "Print",
 CellID->10435575],
Cell[11624, 378, 403, 10, 70, "Print",
 CellID->140446283],
Cell[12030, 390, 389, 10, 70, "Print",
 CellID->38176322],
Cell[12422, 402, 403, 10, 70, "Print",
 CellID->125189955],
Cell[12828, 414, 415, 10, 70, "Print",
 CellID->75398702],
Cell[13246, 426, 403, 10, 70, "Print",
 CellID->371444477],
Cell[13652, 438, 416, 10, 70, "Print",
 CellID->596448161],
Cell[14071, 450, 429, 10, 70, "Print",
 CellID->598289927],
Cell[14503, 462, 440, 10, 70, "Print",
 CellID->187172730]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15016, 480, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[15438, 494, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[15626, 502, 427, 12, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[16056, 516, 1227, 38, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[17298, 557, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

