(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



BeginPackage["Susyno`SusyRGEs`",{"Susyno`LieGroups`","Susyno`ModelBuilding`","Susyno`SimplifyEinsteinNotation`"}];

{GenerateModelBetaFunctions,InitObjects,MasterFY,MergeSameReps,ReverseMergeReps,SearchForInvariants,YBConnection,YDDY,YDnoFDY,YDY,YDYnoF,YGcYc,YGYc,YMccYc,YMcYc,YMMcYc,YMYc,YToB,YYc};
{GaugeSectorU1;GaugeSectorNonU1;GaugeSector;GauginoSectorU1;GauginoSectorNonU1;GauginoSector;Y\[Mu]LSector;HSector;BSector;SSector;M2Sector,FindInvariantRep};

{NormalizeParameters,KillKroneckerDeltas};

Begin["`Private`"];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

 MasterFY[i_]:=Module[{aux,yPositions,indexPosition,otherIndices,otherIndicesPositions,result,pYAux,fI,fO,fT},

aux=DeleteDuplicates[Position[pY[[1;;-1,1]],i,{2}],#1[[1]]==#2[[1]]&];
yPositions=aux[[1;;-1,1]];
indexPosition=aux[[1;;-1,2]];
otherIndicesPositions=DeleteCases[Range[3],#]&/@indexPosition;
otherIndices=MapThread[Part,{pY[[yPositions,1]],otherIndicesPositions}];

fI=Table[pY[[yPositions[[j]]]][[3,indexPosition[[j]]]],{j,Length[yPositions]}];
fO=Table[pY[[yPositions[[j]]]][[3,otherIndicesPositions[[j]]]],{j,Length[yPositions]}];
fT=Table[{0,0,0},{j,Length[yPositions]}];

(* the refence field i is assumed to have flavour f[1] and the other fields get flavours f[2], f[3] *)
Do[
fT[[j,fI[[j,1]]]]=f[1];
fT[[j,fO[[j,1,1]]]]=f[2];
fT[[j,fO[[j,2,1]]]]=f[3];
,{j,Length[yPositions]}];


pYAux=Table[pY[[yPositions[[j]]]],{j,Length[yPositions]}];
Do[
pYAux[[j,3]]=fT[[j]];
,{j,Length[yPositions]}];

result=Table[{pYAux[[j]],yPositions[[j]],otherIndices[[j]]},{j,Length[yPositions]}];
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

FindInvariantRep[model_]:=Module[{aux,result},
aux=Position[MapThread[List,{reps[model],discreteSym[model]-1}],x_/;x==0x,{1}];
If[Length[aux]>0,result=aux[[1,1]],result=0];

Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* If there are no siglet fields, this method is unnecessary. If there are, it returns the correct y parameters that match the b parameters *)
YBConnection[model_]:=YBConnection[model]=Module[{aux,aux1,aux2,result},
result={};
If[FindInvariantRep[model]!=0,
(* from the b parameters make a list of the corresponding y parameters, with the correct flavours: f[1],f[2],f[3] (this last one for the singlet field) *)
aux=Append[#,FindInvariantRep[model]]&/@pB[[1;;-1,1]];
aux=Table[MapThread[List,{aux[[i]],{f[1],f[2],f[3]}}],{i,Length[aux]}];
aux=Sort[#,#1[[1]]<#2[[1]]&]&/@aux;

aux1=aux[[1;;-1,1;;-1,1]]; (* reps indices *)
aux2=aux[[1;;-1,1;;-1,2]]; (* flavours *)

result=Table[y[aux1[[i]],1,aux2[[i]]],{i,Length[aux]}];

];
Return[result];
];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Given expr, it assumes that 'b' is to be converted from a trilinear tensor to a bilinear tensor by deleting the field with flavour f[2] *)
YToB[model_,expr_,b_]:=Module[{aux1,aux2,aux3,result},
aux1=expr[[FindInvariantRep[model]]]/.b[x1_,x2_,x3_]:>b[x1,x3]; (* No need for the invariant index *)

(* Find the f[2] flavour and delete it together with the representation index (which is suppose to correspond to a singlet)*)
aux2=Position[aux1,f[2]];
aux3=aux2;
Do[
aux3[[i,-2]]=1;
,{i,Length[aux3]}];
aux3=Join[aux2,aux3];

result=Delete[aux1,aux3];
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* We need a standard: by default the free indices of a tensor are f[1], f[2], f[3] *)
YDDY[yHead_,dList_,dpList_,hHead_]:=Module[{n,aux,referenceList,yList,hList,yList1,hList1,yList2,hList2,dListAux,dpListAux,aux3},
n=Length[masterListY]; (*number of fields*)
referenceList=masterListY[[All,All,1]]; (* list of y's involving field i *)

(* get only the list of positions of the unique other fields entering the Yukawa interaction *)
aux=Map[DeleteDuplicates,masterListY[[All,All,3]],{2}];

yList2=referenceList/.{y->yHead,f[1]->f[1],f[2]->f[3],f[3]->f[4]};
hList2=referenceList/.{y->hHead,f[1]->f[2],f[2]->f[5],f[3]->f[6]};
yList1=yList2/.{f[3]->f[4],f[4]->f[3]};
hList1=hList2/.{f[5]->f[6],f[6]->f[5]};

yList=Table[If[Length[aux[[i1,i2]]]==2,{yList2[[i1,i2]],yList1[[i1,i2]]},yList2[[i1,i2]]],{i1,Length[yList1]},{i2,Length[yList1[[i1]]]}];
hList=Table[If[Length[aux[[i1,i2]]]==2,{hList2[[i1,i2]],hList1[[i1,i2]]},hList2[[i1,i2]]],{i1,Length[hList1]},{i2,Length[hList1[[i1]]]}];

dListAux=Map[dList[[#]]&,aux,{3}]/.{f[1]->f[3],f[2]->f[5]};
dpListAux=Map[dpList[[#]]&,aux,{3}]/.{f[1]->f[4],f[2]->f[6]};
dpListAux=Reverse[dpListAux,3];

Return[(Plus@@Flatten[#,1]&/@(yList Conjugate[hList] dListAux dpListAux))/dimRs];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* We need a standard: by default the free indices of a tensor are f[1], f[2], f[3] *)
YDY[yHead_,dList_,hHead_]:=Module[{n,aux,referenceList,yList,hList,yList1,hList1,yList2,hList2,dListAux,aux3},
n=Length[masterListY]; (*number of fields*)
referenceList=masterListY[[All,All,1]]; (* list of y's involving field i *)

(* get only the list of positions of the unique other fields entering the Yukawa interaction *)
aux=Map[DeleteDuplicates,masterListY[[All,All,3]],{2}];

yList2=referenceList/.{y->yHead,f[1]->f[1],f[2]->f[3],f[3]->f[4]};
hList2=referenceList/.{y->hHead,f[1]->f[2],f[2]->f[3],f[3]->f[5]};
yList1=yList2/.{f[3]->f[4],f[4]->f[3]};
hList1=hList2/.{f[3]->f[5],f[5]->f[3]};

yList=Table[If[Length[aux[[i1,i2]]]==2,{yList1[[i1,i2]],yList2[[i1,i2]]},yList1[[i1,i2]]],{i1,Length[yList1]},{i2,Length[yList1[[i1]]]}];
hList=Table[If[Length[aux[[i1,i2]]]==2,{hList1[[i1,i2]],hList2[[i1,i2]]},hList1[[i1,i2]]],{i1,Length[hList1]},{i2,Length[hList1[[i1]]]}];
dListAux=Map[dList[[#]]&,aux,{3}]/.{f[1]->f[4],f[2]->f[5]};

Return[(Plus@@Flatten[#,1]&/@(yList Conjugate[hList] dListAux))/dimRs];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

YDnoFDY[yHead_,dList_,dpList_,hHead_]:=Module[{n,aux,referenceList,yList,hList,yList1,hList1,yList2,hList2,dListAux,dpListAux,aux3},
n=Length[masterListY]; (*number of fields*)
referenceList=masterListY[[All,All,1]]; (* list of y's involving field i *)

(* get only the list of positions of the unique other fields entering the Yukawa interaction *)
aux=Map[DeleteDuplicates,masterListY[[All,All,3]],{2}];

yList2=referenceList/.{y->yHead,f[1]->f[1],f[2]->f[3],f[3]->f[4]};
hList2=referenceList/.{y->hHead,f[1]->f[2],f[2]->f[3],f[3]->f[5]};
yList1=yList2/.{f[3]->f[4],f[4]->f[3]};
hList1=hList2/.{f[3]->f[5],f[5]->f[3]};

yList=Table[If[Length[aux[[i1,i2]]]==2,{yList2[[i1,i2]],yList1[[i1,i2]]},yList2[[i1,i2]]],{i1,Length[yList1]},{i2,Length[yList1[[i1]]]}];
hList=Table[If[Length[aux[[i1,i2]]]==2,{hList2[[i1,i2]],hList1[[i1,i2]]},hList2[[i1,i2]]],{i1,Length[hList1]},{i2,Length[hList1[[i1]]]}];

dListAux=Map[dList[[#]]&,aux,{3}];
dpListAux=Map[dpList[[#]]&,aux,{3}]/.{f[1]->f[4],f[2]->f[5]};
dpListAux=Reverse[dpListAux,3];

Return[(Plus@@Flatten[#,1]&/@(yList Conjugate[hList] dListAux dpListAux))/dimRs];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Same as YDY but with a flavourless D tensor *)
YDYnoF[yHead_,dList_,hHead_]:=Module[{n,aux,referenceList,yList,hList,yList1,hList1,yList2,hList2,dListAux,aux3},
n=Length[masterListY]; (*number of fields*)
referenceList=masterListY[[All,All,1]]; (* list of y's involving field i *)

(* get only the list of positions of the unique other fields entering the Yukawa interaction *)
aux=Map[DeleteDuplicates,masterListY[[All,All,3]],{2}];

yList2=referenceList/.{y->yHead,f[1]->f[1],f[2]->f[3],f[3]->f[4]};
hList2=referenceList/.{y->hHead,f[1]->f[2],f[2]->f[3],f[3]->f[4]};
yList1=yList2;
hList1=hList2;

yList=Table[If[Length[aux[[i1,i2]]]==2,{yList1[[i1,i2]],yList2[[i1,i2]]},yList1[[i1,i2]]],{i1,Length[yList1]},{i2,Length[yList1[[i1]]]}];
hList=Table[If[Length[aux[[i1,i2]]]==2,{hList1[[i1,i2]],hList2[[i1,i2]]},hList1[[i1,i2]]],{i1,Length[hList1]},{i2,Length[hList1[[i1]]]}];
dListAux=Map[dList[[#]]&,aux,{3}];

Return[(Plus@@Flatten[#,1]&/@(yList Conjugate[hList] dListAux))/dimRs];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

CF[expr_,oldFlavIndices_,newFlavIndices_]:=Module[{aux},
aux=MapThread[Rule,Map[f,{oldFlavIndices,newFlavIndices},{2}]];
Return[expr/.aux];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

GenerateModelBetaFunctions[model_]:=Module[{modelMod},

(* Clear all the global variables used *)
Clear[pY,pH,p\[Mu],pB,pL,pS,pM2,nReps,conjugateReps,masterListY,nonU1sPositions,u1sPositions,nU1s,multipleU1s,gMatrix,mMatrix,vis,matrixVis2,dimRs,sR,cG,dG,arrayG,arrayM,casimirsRep,dynkinRep,g2Ci,g2MCi,g2McCi,g2MMcCi,g4CiCi,g4MCiCi,g4MMcCiCi,g4CiSR,g4MCiSR,g4CGCi,g4MCGCi,g4MMcCGCi,g4MMcCiSR,g2tTrtm2,g2ttm2YYc,g4tTrtCim2,g4CiTrSrm2,vYYc,vYGYc,vYGcYc,vYMYc,vYMcYc,vYMMcYc,vYcYYcY,vYMccYc];

(* Create parameters[model] and originalParameters[model] if they don't exist already *)
If[!ValueQ[parameters[model]],GenerateModelParameters[model]];

(* Deals with repeated input representations: defines a new model (modelMod) which is similar to the original one but with no repeated fields *)
modelMod=MergeSameReps[model];

InitObjects[modelMod];

betaFunctions[modelMod]^=Join[{GaugeSector[modelMod],GauginoSector[modelMod]},Y\[Mu]LSector[],{HSector[],BSector[modelMod],SSector[modelMod],M2Sector[]}];

(* Deals with repeated input representations - ReverseMergeReps will set betaFunctions[model] *)
ReverseMergeReps[model,modelMod];

(* Kill unwanted KroneckerDelta functions in the results *)
KillKroneckerDeltas[model];

(* The old Susyno normalization is being used for now*)
NormalizeParameters[model];

(* The beta functions are calculated in the original Susyno parameter notation so a convertion must be made here to the user notation *)
If[!(originalParameters[model]===parameters[model]),
betaFunctions[model]^=Fold[#1//.#2&,betaFunctions[model],parameterTransformationRule[model]]];

betaFunctions[model]^=SimplifyModelExpression[betaFunctions[model],model];

Return[];
]
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

KillKroneckerDeltas[model_]:=Module[{betas},
betas=betaFunctions[model];
Do[
If[Length[DeleteDuplicates[originalParameters[model][[9,i,1]]]]==2,
betas[[9,1,i]]=betas[[9,1,i]]/.KroneckerDelta[__]:>0;
betas[[9,2,i]]=betas[[9,2,i]]/.KroneckerDelta[__]:>0;
,
If[nFlavs[model][[originalParameters[model][[9,i,1,1]]]]===1,
betas[[9,1,i]]=betas[[9,1,i]]/.KroneckerDelta[__]:>1;
betas[[9,2,i]]=betas[[9,2,i]]/.KroneckerDelta[__]:>1;
];
]
,{i,Length[originalParameters[model][[9]]]}];
betaFunctions[model]^=betas;
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Correct the normalization of parameters *)
(* At the momment, the old (v1.x) Susyno convention is used *)
NormalizeParameters[model_]:=Module[{betas,parameter,combinatorialFactor,dimReps,finalFactor,rules},
betas=betaFunctions[model];
rules={};
Do[
parameter=originalParameters[model][[part,parameterPos]];
(* combinatorialFactor=Times@@(Factorial/@Tally[parameter[[1]]][[All,2]]);*)
 combinatorialFactor=1;
dimReps=(Times@@DimR[group[model],#])&/@reps[model][[parameter[[1]]]];
finalFactor=(Times@@dimReps)^(1/4) combinatorialFactor;

betas[[part,All,parameterPos]]=1/finalFactor betas[[part,All,parameterPos]];
AppendTo[rules,parameter[[0]][parameter[[1]],more__]->finalFactor parameter[[0]][parameter[[1]],more]];
,{part,{3,6}},{parameterPos,Length[originalParameters[model][[part]]]}];

(* If there is an invariant field, all bilinear invariants must also be normalized in a way that matches the trilinear terms where the invariant field appears. Linear terms are already Ok with this. *)
If[!(FindInvariantRep[model]===0),

Do[
parameter=originalParameters[model][[part,parameterPos]];
combinatorialFactor=Times@@(Factorial/@Tally[parameter[[1]]][[All,2]]);
dimReps=(Times@@DimR[group[model],#])&/@reps[model][[parameter[[1]]]];
finalFactor=(Times@@dimReps)^(1/4) combinatorialFactor;

betas[[part,All,parameterPos]]=1/finalFactor betas[[part,All,parameterPos]];
AppendTo[rules,parameter[[0]][parameter[[1]],more__]->finalFactor parameter[[0]][parameter[[1]],more]];
,{part,{4,7}},{parameterPos,Length[originalParameters[model][[part]]]}]

];

betaFunctions[model]^=betas/.rules;
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

InitObjects[model_]:=Module[{aux,aux1,aux2,aux3,aux4,result},

GenerateModelParameters[model];
{pY,p\[Mu],pL,pH,pB,pS,pM2}=originalParameters[model][[3;;-1]];

masterListY=Array[MasterFY,nReps[model]];

nonU1sPositions=Position[group[model],x_/;!(x==U1),{1}]//Flatten;
u1sPositions=Position[group[model],U1]//Flatten;
nU1s=Length[u1sPositions];

If[nU1s>0,
multipleU1s=True;
gMatrix=Array[g[u1sPositions[[#1]],u1sPositions[[#2]]]&,{nU1s,nU1s}];
mMatrix=Array[M[u1sPositions[[#1]],u1sPositions[[#2]]]&,{nU1s,nU1s}];
vis=(Transpose[gMatrix].#&/@reps[model][[1;;-1,u1sPositions]]) ;
,
multipleU1s=False;
(* trick the code by assuming that there is an U1 with everything set to 0 *)
gMatrix={{0}};
mMatrix={{0}};
vis=ConstantArray[{0},nReps[model]] ;

];
If[nU1s==1,
gMatrix=gMatrix/.g[1,1]:>g[1];
mMatrix=mMatrix/.M[1,1]:>M[1];
vis=vis/.g[1,1]:>g[1];
];

matrixVis2=Table[KroneckerProduct[vis[[i]],vis[[i]]],{i,nReps[model]}];


dimRs=Table[Times@@DimR[group[model],reps[model][[i]]],{i,nReps[model]}];
sR=Plus@@((DynkinIndex[group[model],#]&/@reps[model])/(DimR[group[model],#]&/@reps[model]) dimRs nFlavs[model]);
cG=Casimir[group[model],Adjoint[group[model]]];
dG=DimR[group[model],Adjoint[group[model]]];

arrayG=Array[g,Length[group[model]]];
arrayM=Array[M,Length[group[model]]];
casimirsRep=Casimir[group[model],#]&/@reps[model];
dynkinRep=DynkinIndex[group[model],#]&/@reps[model];

aux1=Table[vis[[i]].vis[[i]],{i,nReps[model]}];       (* U1 part *)
aux2=Plus@@(arrayG^2  #)[[nonU1sPositions]]&/@casimirsRep;    (* non-U1 part *)
g2Ci=aux1+aux2;

aux1=Table[vis[[i]].mMatrix.vis[[i]],{i,nReps[model]}];       (* U1 part *)
aux2=Plus@@(arrayM arrayG^2 #)[[nonU1sPositions]]&/@casimirsRep;    (* non-U1 part *)
g2MCi=aux1+aux2;

aux1=Table[vis[[i]].ConjugateTranspose[mMatrix].vis[[i]],{i,nReps[model]}];       (* U1 part *)
aux2=Plus@@(Conjugate[arrayM] arrayG^2 #)[[nonU1sPositions]]&/@casimirsRep;    (* non-U1 part *)
g2McCi=aux1+aux2;

aux1=Table[vis[[i]].mMatrix.ConjugateTranspose[mMatrix].vis[[i]],{i,nReps[model]}];       (* U1 part *)
aux2=Plus@@(arrayM Conjugate[arrayM] arrayG^2 #)[[nonU1sPositions]]&/@casimirsRep;    (* non-U1 part *)
g2MMcCi=aux1+aux2;

g4CiCi=g2Ci^2;
g4MCiCi=g2Ci g2MCi;
g4MMcCiCi=2/3 g2Ci g2MMcCi+1/3 g2MCi g2McCi;


aux1=(arrayG^4 sR)[[nonU1sPositions]].#[[nonU1sPositions]]&/@casimirsRep;
aux2=Table[Sum[(vis[[i]].vis[[j]])^2nFlavs[model][[j]]dimRs[[j]]//Expand,{j,nReps[model]}],{i,nReps[model]}];

g4CiSR=aux1+aux2;

aux1=(arrayG^4 arrayM sR)[[nonU1sPositions]].#[[nonU1sPositions]]&/@casimirsRep;
aux2=Table[Sum[(vis[[i]].mMatrix.vis[[j]])(vis[[i]].vis[[j]])nFlavs[model][[j]]dimRs[[j]]//Expand,{j,nReps[model]}],{i,nReps[model]}];

g4MCiSR=aux1+aux2;

g4CGCi=(arrayG^4cG)[[nonU1sPositions]].#[[nonU1sPositions]]&/@casimirsRep;
g4MCGCi=(arrayG^4arrayM cG)[[nonU1sPositions]].#[[nonU1sPositions]]&/@casimirsRep;
g4MMcCGCi=(arrayG^4arrayM Conjugate[arrayM] cG)[[nonU1sPositions]].#[[nonU1sPositions]]&/@casimirsRep;

aux1=(arrayG^4arrayM Conjugate[arrayM] sR)[[nonU1sPositions]].#[[nonU1sPositions]]&/@casimirsRep;
aux2=Table[Sum[(vis[[i]].mMatrix.vis[[j]])(vis[[i]].ConjugateTranspose[mMatrix].vis[[j]] nFlavs[model][[j]]dimRs[[j]]) //Expand,{j,nReps[model]}],{i,nReps[model]}];
aux3=Table[Sum[(vis[[i]].mMatrix.ConjugateTranspose[mMatrix].vis[[j]])(vis[[i]].vis[[j]] nFlavs[model][[j]]dimRs[[j]])//Expand,{j,nReps[model]}],{i,nReps[model]}];
aux4=Table[Sum[(vis[[i]].ConjugateTranspose[mMatrix].mMatrix.vis[[j]])(vis[[i]].vis[[j]] nFlavs[model][[j]]dimRs[[j]])//Expand,{j,nReps[model]}],{i,nReps[model]}];
g4MMcCiSR=aux1+1/3(aux2+aux3+aux4);

g2tTrtm2=Table[vis[[i]].(Plus@@(vis pM2 dimRs)) ,{i,nReps[model]}]/.f[2]->f[1];

aux1=Table[vis[[i]].vis[[j]] Conjugate[pM2[[i]]] ,{i,nReps[model]},{j,nReps[model]}];
g2ttm2YYc=Plus@@(YDY[y,aux1,y]dimRs) /.f[2]->f[1];

aux1=Table[Sum[vis[[i]].vis[[p]] g2Ci[[p]]pM2[[p]]dimRs[[p]],{p,nReps[model]}],{i,nReps[model]}]/.f[2]->f[1] //Expand;
g4tTrtCim2=aux1;

aux1=((arrayG^4  Plus@@(dynkinRep pM2 dimRs/(DimR[group[model],#]&/@reps[model])))[[nonU1sPositions]].#[[nonU1sPositions]]&/@casimirsRep)/.f[2]->f[1];
aux2=Table[Sum[(vis[[i]].vis[[j]])^2pM2[[j]] dimRs[[j]],{j,nReps[model]}],{i,nReps[model]}] /.f[2]->f[1];

g4CiTrSrm2=aux1+aux2 //Expand;

vYYc=YDYnoF[ya,ConstantArray[1,nReps[model]],yb];
vYGYc=YDYnoF[ya,g2Ci,yb];
vYGcYc=vYGYc/.g[i__]:>Conjugate[g[i]] ;
vYMYc=YDYnoF[ya,g2MCi,yb];
vYMcYc=vYMYc/.M[i__]:>Conjugate[M[i]];
vYMccYc=vYMYc/.{M[i__]:>Conjugate[M[i]],g[i__]:>Conjugate[g[i]]};
vYMMcYc=vYMYc/.M[i__]:>M[i]Conjugate[M[i]];

aux=CF[vYYc/.{ya->yb,yb->yc},{3,4},{6,7}];
vYcYYcY=Conjugate[YDY[ya,Conjugate[aux],yd]];

];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* Dealts with multiple equal reps *)

MergeSameReps[model_]:=Module[{fullRepInfo,originalReps,originalNFlavs,originalDiscreteSym,reverseMergeReps,aux,aux2,modelMod},
fullRepInfo=Thread[{reps[model],discreteSym[model]}];
aux=DeleteDuplicates[fullRepInfo];
reverseMergeReps=Flatten[Position[fullRepInfo,#]]&/@aux;


(* Define a new model - modelMod - where there are no repreated fields. The RGEs will be calculated for modelMod and then modified slightly in ReverseMergeReps *)
modelMod=Unique[model];
group[modelMod]^=group[model];
reps[modelMod]^=reps[model][[reverseMergeReps[[All,1]]]];
nFlavs[modelMod]^=Apply[Plus,nFlavs[model][[#]]&/@reverseMergeReps,{1}];
discreteSym[modelMod]^=discreteSym[model][[reverseMergeReps[[All,1]]]];

Return[modelMod];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* Dealts with multiple equal reps *)
ReverseMergeReps[model_,modelMod_]:=Module[{fullRepInfo,reverseMergeReps,changeNotation,revertNotation,deleteNullParametersRule,basicRule,reverseSignRule,orderingRule,finalRule,newParameters,uselessRules,aux,aux2,aux3,betaFunctionsModel},

(* If model did not contain repeated representations, there is no need for extra computations since model=modelMod *)
If[reps[model]===reps[modelMod],
betaFunctions[model]^=betaFunctions[modelMod];
Return[];
];



fullRepInfo=Thread[{reps[model],discreteSym[model]}];
aux=DeleteDuplicates[fullRepInfo];
reverseMergeReps=Flatten[Position[fullRepInfo,#]]&/@aux;

(* basicRule, reverseSignRule, orderingRule are auxiliar rules; *)
(* basicRule expands the compressed representation indices and gives all the new indices a minus sign to avoid an infinite loop *)
(* reverseSignRule corrects the minus sign trick used in basicRule *)
(* After using  basicRule and reverseSignRule some of the parameter's representation indices are out of order. This is corrected by orderingRule (permutations of the indices are done, and in m2's case, a conjugate is added) *)

basicRule=Flatten[Table[head[{x1___,i,x2___},x3___]->Sum[head[{x1,-reverseMergeReps[[i,j]],x2},x3],{j,Length[reverseMergeReps[[i]]]}],{head,{y,\[Mu],l,h,b,s,m2}},{i,Length[reverseMergeReps]}]];

reverseSignRule=Table[head[x1_,x3___]->head[-x1,x3],{head,{y,\[Mu],l,h,b,s,m2}}];

orderingRule={y[{x1__},x2___,{x3__}]:>y[Sort[{x1}],x2,{x3}[[Ordering[{x1}]]]],\[Mu][{x1__},x2___,{x3__}]:>\[Mu][Sort[{x1}],x2,{x3}[[Ordering[{x1}]]]],l[{x1__},x2___,{x3__}]:>l[Sort[{x1}],x2,{x3}[[Ordering[{x1}]]]],h[{x1__},x2___,{x3__}]:>h[Sort[{x1}],x2,{x3}[[Ordering[{x1}]]]],b[{x1__},x2___,{x3__}]:>b[Sort[{x1}],x2,{x3}[[Ordering[{x1}]]]],s[{x1__},x2___,{x3__}]:>s[Sort[{x1}],x2,{x3}[[Ordering[{x1}]]]],m2[{x1__},x2___,{x3__}]:>If[!(OrderedQ[{x1}]),Conjugate[m2[Sort[{x1}],x2,{x3}[[Ordering[{x1}]]]]],m2[Sort[{x1}],x2,{x3}[[Ordering[{x1}]]]]]};

(* finalRule is the true rule to be applied to the results *)
newParameters=((originalParameters[modelMod]//.basicRule)/.reverseSignRule)/.orderingRule;

(* ... but as a last step we need to delete parameters that are known to be null  *)
aux3=DeleteCases[Flatten[newParameters[[3;;9]]/.Plus->List/.f[x_]:>f[_]],Conjugate[_]];
aux3=DeleteCases[aux3,x_/;MemberQ[Flatten[originalParameters[model]],x]];
deleteNullParametersRule=MapThread[Rule,{aux3,ConstantArray[0,Length[aux3]]}];
newParameters=newParameters/.deleteNullParametersRule;


finalRule=Table[(originalParameters[modelMod][[i,j]]/.{f[1]->i1_,f[2]->i2_,f[3]:>i3_})->(newParameters[[i,j]]/.{f[1]->i1,f[2]->i2,f[3]:>i3}),{i,9},{j,Length[originalParameters[modelMod][[i]]]}];

(* no need to have trivial transormations rules *)
uselessRules={};
Do[
If[newParameters[[i,j]]===originalParameters[modelMod][[i,j]],AppendTo[uselessRules,{i,j}]];
,{i,Length[finalRule]},{j,Length[finalRule[[i]]]}];

finalRule=Flatten[Delete[finalRule,uselessRules]];
finalRule=finalRule/.orderingRule;

(* 'decompose' the parameters inside the betaFunctions[modelMod] and originalParameters[modelMod] 'variables' *)
aux=betaFunctions[modelMod]/.finalRule;

(* ------------------------------------------------------------------------------------------------------------------- *)
(* PART2: Things are not over yet because the representation indices coresponding to free fields have been expanded as a sum and they should have been expanded as a list (note:there are more parameters so there should be more betaFunctions). This list expansion must match the information on originalParameters[model] *)

(* First, change notation for now *)
changeNotation={y[x1_,x2___,x3_]:>y[MapThread[List,{x1,x3}],x2],\[Mu][x1_,x2___,x3_]:>\[Mu][MapThread[List,{x1,x3}],x2],l[x1_,x2___,x3_]:>l[MapThread[List,{x1,x3}],x2],h[x1_,x2___,x3_]:>h[MapThread[List,{x1,x3}],x2],b[x1_,x2___,x3_]:>b[MapThread[List,{x1,x3}],x2],s[x1_,x2___,x3_]:>s[MapThread[List,{x1,x3}],x2],m2[x1_,x2___,x3_]:>m2[MapThread[List,{x1,x3}],x2]};

aux=aux/.changeNotation;


(* Second, initialize the results variable *)
betaFunctionsModel=Table[0 ,{i,9},{j,Length[ originalParameters[model][[i]]]}];

(* Third, find where to place the aux=betaFunctions[modelMod]/.finalRule results in betaFunctions[model] *)
aux2=Table[Position[newParameters[[i]]/.f[x_]:>f[],(originalParameters[model][[i,j]]/.f[x_]:>f[])][[1,1]],{i,1,9},{j,Length[originalParameters[model][[i]]]}];

aux3=Table[Cases[newParameters[[i]],(originalParameters[model][[i,j]]/.f[x_]:>f[_]),-1][[1,-1]],{i,1,9},{j,Length[originalParameters[model][[i]]]}];
    aux3=Table[MapThread[Rule,{el2,Array[f,Length[el2]]}],{el1,aux3[[3;;9]]},{el2,el1}];

(* TODO: free indices might need to be permuted! *)
Do[
betaFunctionsModel[[i]]=aux[[i,1;;2,aux2[[i]]]];

If[i>2,
Do[
betaFunctionsModel[[i,All,j]]=betaFunctionsModel[[i,All,j]]/.aux3[[i-2,j]];
,{j,Length[aux3[[i-2]]]}];
];

,{i,9}];

(* Forth, look at the parameter and corresponding betaFunctions: only allow in the RGEs parameters where the free flavours (f[1],f[2],f[3] or subset) match the correct representation indices. All other cases should be zeroed out. *)
aux2=originalParameters[model]/.{y[x1_,x2___,x3_]:>MapThread[List,{x1,x3}],\[Mu][x1_,x2___,x3_]:>MapThread[List,{x1,x3}],l[x1_,x2___,x3_]:>MapThread[List,{x1,x3}],h[x1_,x2___,x3_]:>MapThread[List,{x1,x3}],b[x1_,x2___,x3_]:>MapThread[List,{x1,x3}],s[x1_,x2___,x3_]:>MapThread[List,{x1,x3}],m2[x1_,x2___,x3_]:>MapThread[List,{x1,x3}]};

Do[
aux3=Table[{x_,aux2[[i,j,k,2]]}->If[x==aux2[[i,j,k,1]],Evaluate[aux2[[i,j,k]]],ForRemoval],{k,Length[aux2[[i,j]]]}];
betaFunctionsModel[[i,1;;2,j]]=(betaFunctionsModel[[i,1;;2,j]]/.aux3)/.head_[{x1___,ForRemoval,x2___},x3___]:>0;
,{i,3,9},{j,Length[originalParameters[model][[i]]]}];

(* Fifth, revert to the usual notation *)
revertNotation={y[x1_,x2___]:>y[x1[[All,1]],x2,x1[[All,2]]],\[Mu][x1_,x2___]:>\[Mu][x1[[All,1]],x2,x1[[All,2]]],l[x1_,x2___]:>l[x1[[All,1]],x2,x1[[All,2]]],h[x1_,x2___]:>h[x1[[All,1]],x2,x1[[All,2]]],b[x1_,x2___]:>b[x1[[All,1]],x2,x1[[All,2]]],s[x1_,x2___]:>s[x1[[All,1]],x2,x1[[All,2]]],m2[x1_,x2___]:>m2[x1[[All,1]],x2,x1[[All,2]]]};

betaFunctionsModel=betaFunctionsModel/.revertNotation;

betaFunctions[model]^=betaFunctionsModel;
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

YYc[aHead_,bHead_,flavList_:{}]:=Module[{subsFlavs,result},
subsFlavs=Table[f[i]->f[flavList[[i]]],{i,Length[flavList]}];
result=(vYYc/.{ya->aHead,yb->bHead}) /.subsFlavs;
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

YGYc[aHead_,bHead_,flavList_:{}]:=Module[{subsFlavs,result},
subsFlavs=Table[f[i]->f[flavList[[i]]],{i,Length[flavList]}];
result=(vYGYc/.{ya->aHead,yb->bHead}) /.subsFlavs;
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

YGcYc[aHead_,bHead_,flavList_:{}]:=Module[{subsFlavs,result},
subsFlavs=Table[f[i]->f[flavList[[i]]],{i,Length[flavList]}];
result=(vYGcYc/.{ya->aHead,yb->bHead}) /.subsFlavs;
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

YMYc[aHead_,bHead_,flavList_:{}]:=Module[{subsFlavs,result},
subsFlavs=Table[f[i]->f[flavList[[i]]],{i,Length[flavList]}];
result=(vYMYc/.{ya->aHead,yb->bHead}) /.subsFlavs;
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

YMcYc[aHead_,bHead_,flavList_:{}]:=Module[{subsFlavs,result},
subsFlavs=Table[f[i]->f[flavList[[i]]],{i,Length[flavList]}];
result=(vYMcYc/.{ya->aHead,yb->bHead}) /.subsFlavs;
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

YMccYc[aHead_,bHead_,flavList_:{}]:=Module[{subsFlavs,result},
subsFlavs=Table[f[i]->f[flavList[[i]]],{i,Length[flavList]}];
result=(vYMccYc/.{ya->aHead,yb->bHead}) /.subsFlavs;
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

YMMcYc[aHead_,bHead_,flavList_:{}]:=Module[{subsFlavs,result},
subsFlavs=Table[f[i]->f[flavList[[i]]],{i,Length[flavList]}];
result=(vYMMcYc/.{ya->aHead,yb->bHead}) /.subsFlavs;
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

YcYYcY[aHead_,bHead_,cHead_,dHead_,flavList_:{}]:=Module[{subsFlavs,result},
subsFlavs=Table[f[i]->f[flavList[[i]]],{i,Length[flavList]}];
result=(vYcYYcY/.{ya->aHead,yb->bHead,yc->cHead,yd->dHead}) /.subsFlavs;
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)


GaugeSectorU1[model_]:=Module[{beta1,beta2},
If[nU1s==0,Return[{0,0}]];

beta1=gMatrix.Plus@@(matrixVis2 nFlavs[model] dimRs);
beta2=gMatrix.(4Plus@@(matrixVis2 g2Ci nFlavs[model] dimRs)-CF[Plus@@(YDYnoF[y,matrixVis2,y] dimRs),{2},{1}]);
Return[{beta1,beta2}];
]

GaugeSectorNonU1[model_]:=Module[{dims,auxY,auxSRCR,beta1,beta2},
beta1=(arrayG^3(sR-3cG))[[nonU1sPositions]];

auxY=CF[arrayG^3/dG Plus@@(YDYnoF[y,casimirsRep,y] dimRs),{2},{1}];

dims=DimR[group[model],#]&/@reps[model];
auxSRCR=arrayG^3Plus@@(dynkinRep g2Ci/dims  dimRs nFlavs[model]);

beta2=(arrayG^5(-6cG^2+2cG sR)+4auxSRCR-auxY)[[nonU1sPositions]];
Return[{beta1,beta2}];
]

GaugeSector[model_]:=Module[{auxU1,auxNonU1,beta1,beta2},
auxU1=GaugeSectorU1[model];
auxNonU1=GaugeSectorNonU1[model];

If[nU1s!=0,
beta1=Join[auxU1[[1]]//Flatten,auxNonU1[[1]]];
beta2=Join[auxU1[[2]]//Flatten,auxNonU1[[2]]];
,
{beta1,beta2}=auxNonU1;
];

Return[{beta1,beta2}];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

GauginoSectorU1[model_]:=Module[{aux,auxY,auxSRCR,beta1,beta2},
If[nU1s==0,Return[{0,0}]];

aux=Plus@@(matrixVis2 nFlavs[model] dimRs);
beta1=mMatrix.aux+aux.mMatrix;

auxSRCR=4 mMatrix.(Plus@@(matrixVis2 g2Ci  dimRs nFlavs[model]))+4 (Plus@@(matrixVis2 g2Ci  dimRs nFlavs[model])).mMatrix+8(Plus@@(matrixVis2 g2MCi  dimRs nFlavs[model]));
auxY=CF[Plus@@((2YDYnoF[h,matrixVis2,y] -YDYnoF[y,(mMatrix.#+#.mMatrix)&/@matrixVis2,y])dimRs),{2},{1}];

beta2=auxSRCR+auxY;
Return[{beta1,beta2}];
]

GauginoSectorNonU1[model_]:=Module[{dims,auxY,auxSRCR,beta1,beta2},
beta1=(arrayM arrayG^2(2sR-6cG))[[nonU1sPositions]];

auxY=Plus@@(YDYnoF[h,casimirsRep,y] dimRs);
auxY=2arrayG^2(auxY-arrayM (auxY/.h->y))/dG ;
auxY=CF[auxY,{2},{1}];

dims=DimR[group[model],#]&/@reps[model];
auxSRCR=8arrayM arrayG^2Plus@@(dynkinRep g2Ci/dims  dimRs nFlavs[model])+8 arrayG^2Plus@@(dynkinRep g2MCi/dims  dimRs nFlavs[model]);

beta2=(arrayG^4arrayM(-24cG^2+8cG sR)+auxSRCR+auxY)[[nonU1sPositions]];

Return[{beta1,beta2}];
]

GauginoSector[model_]:=Module[{auxU1,auxNonU1,beta1,beta2},
auxU1=GauginoSectorU1[model];
auxNonU1=GauginoSectorNonU1[model];

If[nU1s!=0,
beta1=Join[auxU1[[1]]//Flatten,auxNonU1[[1]]];
beta2=Join[auxU1[[2]]//Flatten,auxNonU1[[2]]];
,
{beta1,beta2}=auxNonU1;
];

Return[{beta1,beta2}];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

Y\[Mu]LSector[]:=Module[{gamma1Part1,gamma1Part2,gamma2Part1,gamma2Part2,aux1,aux2,aux3,y1loop,y2loop,\[Mu]1loop,\[Mu]2loop,l1loop,l2loop,result},

gamma1Part1=1/2Conjugate[YYc[y,y]];
gamma1Part2=-2g2Ci;

gamma2Part1=-1/2 YcYYcY[y,y,y,y]+2 Conjugate[YGcYc[y,y]]- g2Ci Conjugate[YYc[y,y]];
gamma2Part2=2(g4CiSR+2g4CiCi-3g4CGCi);

(* Gammas have been computed ... now use them *)

(* Y 1-loop *)
aux1=Table[{CF[pY[[i]],{1},{4}],CF[pY[[i]],{2},{4}],CF[pY[[i]],{3},{4}]},{i,Length[pY]}];

aux2=Table[{CF[gamma1Part1[[pY[[i,1,1]]]],{1,2,3,4},{4,1,5,6}],CF[gamma1Part1[[pY[[i,1,2]]]],{1,2,3,4},{4,2,5,6}],CF[gamma1Part1[[pY[[i,1,3]]]],{1,2,3,4},{4,3,5,6}]},{i,Length[pY]}];
aux2=MapThread[Dot,{aux1,aux2}];

aux3=pY Table[Plus@@gamma1Part2[[pY[[i,1]]]],{i,Length[pY]}];

y1loop=aux2+aux3;

(* Y 2-loop *)
aux2=Table[{CF[gamma2Part1[[pY[[i,1,1]]]],{1,2,3,4,5,6,7},{4,1,5,6,7,8,9}],CF[gamma2Part1[[pY[[i,1,2]]]],{1,2,3,4,5,6,7},{4,2,5,6,7,8,9}],CF[gamma2Part1[[pY[[i,1,3]]]],{1,2,3,4,5,6,7},{4,3,5,6,7,8,9}]},{i,Length[pY]}];
aux2=MapThread[Dot,{aux1,aux2}];

aux3=pY Table[Plus@@gamma2Part2[[pY[[i,1]]]],{i,Length[pY]}];

y2loop=aux2+aux3;


(* \[Mu] 1-loop *)
aux1=Table[{CF[p\[Mu][[i]],{1},{3}],CF[p\[Mu][[i]],{2},{3}]},{i,Length[p\[Mu]]}];
aux2=Table[{CF[gamma1Part1[[p\[Mu][[i,1,1]]]],{1,2,3,4},{3,1,4,5}],CF[gamma1Part1[[p\[Mu][[i,1,2]]]],{1,2,3,4},{3,2,4,5}]},{i,Length[p\[Mu]]}];

aux2=MapThread[Dot,{aux1,aux2}];

aux3=p\[Mu] Table[Plus@@gamma1Part2[[p\[Mu][[i,1]]]],{i,Length[p\[Mu]]}];

\[Mu]1loop=aux2+aux3;

(* \[Mu] 2-loop *)
aux2=Table[{CF[gamma2Part1[[p\[Mu][[i,1,1]]]],{1,2,3,4,5,6,7},{3,1,4,5,6,7,8}],CF[gamma2Part1[[p\[Mu][[i,1,2]]]],{1,2,3,4,5,6,7},{3,2,4,5,6,7,8}]},{i,Length[p\[Mu]]}];
aux2=MapThread[Dot,{aux1,aux2}];

aux3=p\[Mu] Table[Plus@@gamma2Part2[[p\[Mu][[i,1]]]],{i,Length[p\[Mu]]}];

\[Mu]2loop=aux2+aux3;

(* L 1-loop *)
aux1=Table[{CF[pL[[i]],{1},{2}]},{i,Length[pL]}];

aux2=Table[{CF[gamma1Part1[[pL[[i,1,1]]]],{1,2,3,4},{2,1,3,4}]},{i,Length[pL]}];
aux2=MapThread[Dot,{aux1,aux2}];

aux3=pL Table[Plus@@gamma1Part2[[pL[[i,1]]]],{i,Length[pL]}];

l1loop=aux2+aux3;

(* L 2-loop *)
aux2=Table[{CF[gamma2Part1[[pL[[i,1,1]]]],{1,2,3,4,5,6,7},{2,1,3,4,5,6,7}]},{i,Length[pL]}];
aux2=MapThread[Dot,{aux1,aux2}];

aux3=pL Table[Plus@@gamma2Part2[[pL[[i,1]]]],{i,Length[pL]}];

l2loop=aux2+aux3;

result={{y1loop,y2loop},{\[Mu]1loop,\[Mu]2loop},{l1loop,l2loop}};
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

HSector[]:=Module[{listH,listHplain,listY,listYplain,aux1,h1loop,h2loop,result},

aux1=1/2Conjugate[YYc[y,y]];
listH=CF[pH,{1},{4}]CF[aux1[[#]]&/@pY[[1;;-1,1,1]],{1,2,3,4},{4,1,5,6}]+CF[pH,{2},{4}]CF[aux1[[#]]&/@pY[[1;;-1,1,2]],{1,2,3,4},{4,2,5,6}]+CF[pH,{3},{4}]CF[aux1[[#]]&/@pY[[1;;-1,1,3]],{1,2,3,4},{4,3,5,6}];


listHplain=-2pH Table[Plus@@g2Ci[[pY[[i,1]]]],{i,Length[pY]}];

listY=Conjugate[YYc[y,h]];
listY=CF[pY,{1},{4}]CF[listY[[#]]&/@pY[[1;;-1,1,1]],{1,2,3,4},{4,1,5,6}]+CF[pY,{2},{4}]CF[listY[[#]]&/@pY[[1;;-1,1,2]],{1,2,3,4},{4,2,5,6}]+CF[pY,{3},{4}]CF[listY[[#]]&/@pY[[1;;-1,1,3]],{1,2,3,4},{4,3,5,6}];

listYplain=4pY Table[Plus@@g2MCi[[pY[[i,1]]]],{i,Length[pY]}];

h1loop=listH+listY+listHplain+listYplain;

(* 2 loop *)
aux1=-1/2 YcYYcY[y,y,y,y] +2Conjugate[YGcYc[y,y]]- g2Ci Conjugate[YYc[y,y]];
listH=CF[pH,{1},{4}]CF[aux1[[#]]&/@pY[[1;;-1,1,1]],{1,2,3,4,5,6,7},{4,1,5,6,7,8,9}]+CF[pH,{2},{4}]CF[aux1[[#]]&/@pY[[1;;-1,1,2]],{1,2,3,4,5,6,7},{4,2,5,6,7,8,9}]+CF[pH,{3},{4}]CF[aux1[[#]]&/@pY[[1;;-1,1,3]],{1,2,3,4,5,6,7},{4,3,5,6,7,8,9}];

aux1=g4CiSR+2g4CiCi-3g4CGCi;
listHplain=2pH Table[Plus@@aux1[[pY[[i,1]]]],{i,Length[pY]}];

aux1=-YcYYcY[y,y,y,h]-YcYYcY[y,h,y,y] +2(2Conjugate[YGcYc[y,h]]- g2Ci Conjugate[YYc[y,h]])-2(2Conjugate[YMccYc[y,y]]- g2MCi Conjugate[YYc[y,y]]);
listY=CF[pY,{1},{4}]CF[aux1[[#]]&/@pY[[1;;-1,1,1]],{1,2,3,4,5,6,7},{4,1,5,6,7,8,9}]+CF[pY,{2},{4}]CF[aux1[[#]]&/@pY[[1;;-1,1,2]],{1,2,3,4,5,6,7},{4,2,5,6,7,8,9}]+CF[pY,{3},{4}]CF[aux1[[#]]&/@pY[[1;;-1,1,3]],{1,2,3,4,5,6,7},{4,3,5,6,7,8,9}];

aux1=g4MCiSR+2g4MCiCi-3g4MCGCi;
listYplain=-8pY Table[Plus@@aux1[[pY[[i,1]]]],{i,Length[pY]}];

h2loop=listH+listY+listHplain+listYplain;
Return[{h1loop,h2loop}];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

BSector[model_]:=Module[{listB,listBplain,list\[Mu],list\[Mu]plain,singletTerm1,singletTerm2,singletTerm3,singletTerm4,listSinglet,aux1,aux2,aux3,b1loop,b2loop,result},

(* 1 loop *)
aux1=1/2Conjugate[YYc[y,y]];
listB=CF[pB,{1},{3}]CF[aux1[[#]]&/@p\[Mu][[1;;-1,1,1]],{1,2,3,4},{3,1,4,5}]+CF[pB,{2},{3}]CF[aux1[[#]]&/@p\[Mu][[1;;-1,1,2]],{1,2,3,4},{3,2,4,5}];

listBplain=-2pB Table[Plus@@g2Ci[[p\[Mu][[i,1]]]],{i,Length[p\[Mu]]}];

aux1=Conjugate[YYc[y,h]];
list\[Mu]=CF[p\[Mu],{1},{3}]CF[aux1[[#]]&/@p\[Mu][[1;;-1,1,1]],{1,2,3,4},{3,1,4,5}]+CF[p\[Mu],{2},{3}]CF[aux1[[#]]&/@p\[Mu][[1;;-1,1,2]],{1,2,3,4},{3,2,4,5}];

list\[Mu]plain=4p\[Mu] Table[Plus@@g2MCi[[p\[Mu][[i,1]]]],{i,Length[p\[Mu]]}];

b1loop=listB+list\[Mu]+listBplain+list\[Mu]plain;

(* 2 loop *)
aux1=-1/2 YcYYcY[y,y,y,y] +2Conjugate[YGcYc[y,y]]- g2Ci Conjugate[YYc[y,y]];
listB=CF[pB,{1},{3}]CF[aux1[[#]]&/@p\[Mu][[1;;-1,1,1]],{1,2,3,4,5,6,7},{3,1,4,5,6,7,8}]+CF[pB,{2},{3}]CF[aux1[[#]]&/@p\[Mu][[1;;-1,1,2]],{1,2,3,4,5,6,7},{3,2,4,5,6,7,8}];

aux1=g4CiSR+2 g4CiCi-3g4CGCi;
listBplain=2pB Table[Plus@@aux1[[p\[Mu][[i,1]]]],{i,Length[p\[Mu]]}];

aux1=-YcYYcY[y,h,y,y]-YcYYcY[y,y,y,h] +2(2Conjugate[YGcYc[y,h]]- g2Ci Conjugate[YYc[y,h]])-2(2Conjugate[YMccYc[y,y]]- g2MCi Conjugate[YYc[y,y]]);
list\[Mu]=CF[p\[Mu],{1},{3}]CF[aux1[[#]]&/@p\[Mu][[1;;-1,1,1]],{1,2,3,4,5,6,7},{3,1,4,5,6,7,8}]+CF[p\[Mu],{2},{3}]CF[aux1[[#]]&/@p\[Mu][[1;;-1,1,2]],{1,2,3,4,5,6,7},{3,2,4,5,6,7,8}];

aux1=g4MCiSR+2g4MCiCi-3g4MCGCi;
list\[Mu]plain=-8p\[Mu] Table[Plus@@aux1[[p\[Mu][[i,1]]]],{i,Length[p\[Mu]]}];

b2loop=listB+list\[Mu]+listBplain+list\[Mu]plain;

(*If the model contains an invariant representation under the symmetries ... there are 4 terms that must be added to the RGEs*)

If[!(FindInvariantRep[model]==0), 

(* ---------- singletTerm1 ---------- *)
singletTerm1=YToB[model,Conjugate[YYc[y,b]],b];
singletTerm1=YBConnection[model]CF[singletTerm1,{1,3,4},{3,4,5}]; (* flavour 2 does not exist in singletTerm1 *)

(* ---------- singletTerm2 and singletTerm3 ---------- *)
singletTerm3=YToB[model,-YcYYcY[y,h,y,\[Mu]],\[Mu]];
singletTerm2 =singletTerm3 /.{\[Mu]->b,h->y};

 (* flavour 2 does not exist in singletTerm2 and singletTerm3 *)
singletTerm2=YBConnection[model]CF[singletTerm2,{1,3,4,5,6,7},{3,4,5,6,7,8}];
singletTerm3=YBConnection[model]CF[singletTerm3,{1,3,4,5,6,7},{3,4,5,6,7,8}];

(* ---------- singletTerm4 ---------- *)
singletTerm4=4(YToB[model,Conjugate[YGcYc[y,b]],b]-YToB[model,Conjugate[YMccYc[y,\[Mu]]],\[Mu]]);

 (* flavour 2 does not exist in singletTerm4 *)
singletTerm4=YBConnection[model]CF[singletTerm4,{1,3,4,5,6,7},{3,4,5,6,7,8}];

(* ---------- add the terms to the beta functions ---------- *)
b1loop+=singletTerm1;
b2loop+=singletTerm2+singletTerm3+singletTerm4;

,Null];

Return[{b1loop,b2loop}];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

SSector[model_]:=Module[{singletIndex,listSplain,s1loop,s2loop,aux1,aux2,aux3,term1L1,term1L2,term1L3,term1L4,term1L5,term1L6,term2L1,term2L2,term2L3,term2L4,term2L5,term2L6,term2L7,term2L8,term2L9,term2L10,term2L11,term2L12,term2L13,term2L14,term2L15,term2L16,term2L17,term2L18,term2L19,term2L20,result},

singletIndex=FindInvariantRep[model];

If[!(singletIndex==0), 
term1L1=1/2 YYc[y,y][[singletIndex]]CF[pS,{1},{2}];
term1L2=YYc[h,y][[singletIndex]]CF[pL,{1},{2}];
term1L3={\[Mu][{singletIndex,singletIndex},{f[1],f[2]}]}CF[YToB[model,Conjugate[YYc[y,b]],b],{1},{2}];
term1L4={2YToB[model,YDY[y,Conjugate[pM2],\[Mu]],\[Mu]]};
term1L5={YToB[model,YYc[h,b],b]};

s1loop=term1L1+term1L2+term1L3+term1L4+term1L5;

term2L1=2YGYc[y,y][[singletIndex]]CF[pS,{1},{2}];
term2L2=-1/2Conjugate[YcYYcY[y,y,y,y]][[singletIndex]]CF[pS,{1},{2}];
term2L3=(-4YMYc[y,y]+4YGYc[h,y])[[singletIndex]]CF[pL,{1},{2}];
term2L4=-Conjugate[(YcYYcY[y,y,h,y]+YcYYcY[h,y,y,y])][[singletIndex]]CF[pL,{1},{2}];
term2L5=-{4\[Mu][{singletIndex,singletIndex},{f[1],f[2]}]}CF[Conjugate[(YToB[model,YMccYc[y,\[Mu]],\[Mu]]-YToB[model,YGcYc[y,b],b])],{1},{2}];

term2L6=-{\[Mu][{singletIndex,singletIndex},{f[1],f[2]}]}(CF[YToB[model,YcYYcY[y,h,y,\[Mu]],\[Mu]],{1},{2}]+CF[YToB[model,YcYYcY[y,y,y,b],b],{1},{2}]);

(* Missing "{}" but it is irrelevant *)
term2L7=8YToB[model,YMMcYc[y,\[Mu]],\[Mu]];
term2L8=-4YToB[model,YMYc[y,b],b];
term2L9=-4YToB[model,YMcYc[h,\[Mu]],\[Mu]];
term2L10=4YToB[model,YGYc[h,b],b];
term2L11=4YToB[model,YDnoFDY[y,g2Ci,Conjugate[pM2],\[Mu]],\[Mu]];
term2L12=4YToB[model,YDY[y,g2Ci Conjugate[pM2],\[Mu]],\[Mu]];

term2L13=-YToB[model,Conjugate[YcYYcY[y,y,h,b]],b];
term2L14=-YToB[model,Conjugate[YcYYcY[h,y,y,b]],b];
term2L15=-Conjugate[YToB[model,YcYYcY[h,h,y,\[Mu]],\[Mu]]];

term2L16=-YToB[model,YDDY[y,Conjugate[pM2],CF[Conjugate[YYc[y,y]],{3,4,5,6},{7,8,9,10}],\[Mu]],\[Mu]];

aux1=CF[pM2,{1,2},{1,6}]CF[Conjugate[YYc[y,y]],{1,2,3,4},{6,2,7,8}];
term2L17=-YToB[model,YDY[y,Conjugate[aux1],\[Mu]],\[Mu]];

aux1=CF[YYc[y,y],{1,2,3,4},{1,6,7,8}]CF[pM2,{1,2},{6,2}];
term2L18=-YToB[model,YDY[y,aux1,\[Mu]],\[Mu]];

aux1=CF[YDY[y,Conjugate[pM2],y],{3,4,5},{6,7,8}];
term2L19=-2YToB[model,YDY[y,Conjugate[aux1],\[Mu]],\[Mu]];

term2L20=-YToB[model,Conjugate[YcYYcY[y,h,h,\[Mu]]],\[Mu]];

s2loop=term2L1+term2L2+term2L3+term2L4+term2L5+term2L6+{term2L7+term2L8+term2L9+term2L10+term2L11+term2L12+term2L13+term2L14+term2L15+term2L16+term2L17+term2L18+term2L19+term2L20};

Return[{s1loop,s2loop}];
,
Return[{{},{}}];
];

]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

M2Sector[]:=Module[{aux,listM2plain,m21loop,m22loop,aux1,aux2,aux3,term1L1,term1L2,term1L3,term1L4,term1L5,term1L6,term2L1,term2L2,term2L3,term2L4,term2L5,term2L6,term2L7,term2L8,term2L9,term2L10,term2L11,term2L12,term2L13,term2L14,term2L15,term2L16,term2L17,term2L18,term2L19,term2L20,term2L21,result},

term1L1=1/2 CF[pM2,{1,2},{1,3}]CF[YYc[y,y],{1,2,3,4},{3,2,4,5}] ;
term1L2=1/2CF[YYc[y,y],{1,2,3,4},{1,3,4,5}]CF[pM2,{1,2},{3,2}] ;
term1L3=2YDY[y,Conjugate[pM2],y];
term1L4=YYc[h,h];
term1L5=-8 g2MMcCi KroneckerDelta[f[1],f[2]];
term1L6=2 CF[g2tTrtm2,{1},{3}] KroneckerDelta[f[1],f[2]];

m21loop=term1L1+term1L2+term1L3+term1L4+term1L5+term1L6;


term2L1=-1/2 CF[Conjugate[YcYYcY[y,y,y,y]],{1,2,3,4,5,6,7},{1,3,4,5,6,7,8}] CF[pM2,{1,2},{3,2}];
term2L2=-1/2 CF[pM2,{1,2},{1,3}]CF[Conjugate[YcYYcY[y,y,y,y]],{1,2,3,4,5,6,7},{3,2,4,5,6,7,8}] ;

aux=CF[pM2,{1,2},{1,6}]CF[YYc[y,y],{1,2,3,4},{6,2,7,8}];
term2L3=-YDY[y,Conjugate[aux],y];

aux=CF[YYc[y,y],{1,2,3,4},{1,6,7,8}]CF[pM2,{1,2},{6,2}];
term2L4=-YDY[y,Conjugate[aux],y];

term2L5=-YDDY[y,Conjugate[pM2],CF[Conjugate[YYc[y,y]],{3,4,5,6},{7,8,9,10}],y];

aux=CF[YDY[y,Conjugate[pM2],y],{3,4,5},{6,7,8}];
term2L6=-2YDY[y,Conjugate[aux],y];

term2L7=-Conjugate[YcYYcY[y,h,h,y]];
term2L8=-Conjugate[YcYYcY[h,y,y,h]];
term2L9=-Conjugate[YcYYcY[y,y,h,h]];
term2L10=-Conjugate[YcYYcY[h,h,y,y]];
term2L11=CF[YYc[y,y],{1,2,3,4},{1,3,4,5}] CF[pM2,{1,2},{3,2}](-g2Ci)+2CF[YGYc[y,y],{1,2,3,4},{1,3,4,5}] CF[pM2,{1,2},{3,2}];
term2L12=CF[pM2,{1,2},{1,3}]CF[YYc[y,y],{1,2,3,4},{3,2,4,5}](-g2Ci)+2CF[pM2,{1,2},{1,3}]CF[YGYc[y,y],{1,2,3,4},{3,2,4,5}];
term2L13=4YDY[y,Conjugate[pM2],y](-g2Ci)+4YDnoFDY[y,g2Ci,Conjugate[pM2],y]+4YDY[y,g2Ci Conjugate[pM2],y];
term2L14=2YYc[h,h](-g2Ci)+4YGYc[h,h];
term2L15=2YYc[y,h]g2MCi-4YMYc[y,h];
term2L16=2YYc[h,y]g2McCi-4YMcYc[h,y];
term2L17=-4YYc[y,y]g2MMcCi+8 YMMcYc[y,y];
term2L18=-2CF[g2ttm2YYc,{1,2},{6,7}] KroneckerDelta[f[1],f[2]];
term2L19=8CF[g4tTrtCim2,{1},{3}] KroneckerDelta[f[1],f[2]];

term2L20=KroneckerDelta[f[1],f[2]](24 g4MMcCiSR+48g4MMcCiCi-72g4MMcCGCi);
term2L21=8KroneckerDelta[f[1],f[2]]CF[(g4CiTrSrm2-g4MMcCGCi),{1},{3}];

m22loop=term2L1+term2L2+term2L3+term2L4+term2L5+term2L6+term2L7+term2L8+term2L9+term2L10+term2L11+term2L12+term2L13+term2L14+term2L15+term2L16+term2L17+term2L18+term2L19+term2L20+term2L21;

Return[{m21loop,m22loop}];
]

End[];
EndPackage[];
