(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



BeginPackage["Susyno`ModelBuilding`",{"Susyno`LieGroups`","Susyno`SusyRGEs`","Susyno`IO`"}]

{SearchForInvariants,GenerateModelParameters,GenerateModel};

(* properties of a model - see TagSet and Upset (e.g.:area[square]^=1)*)
{group,reps,nFlavs,discreteSym,conjugateReps,nReps,parameters,lagrangian,betaFunctions,parameterRenamingRules,author,date};

(* properties of a model due to SSB *)
{fundamentalModel,definingVevs,gaugeRotation,matterRotation,boundaryConditions};

(* These are the default Susyno names for the parameters of the model *)
{originalParameters,parameterTransformationRule,RenameParametersWithRules};

(* parametersSymmetries contains the symmetries of the model parameters; the optional variable fieldNames contains a model's field names *)
{parametersSymmetries,fieldNames,breakingVEVs};

(* Simplify the parameter names and eliminate some of them *)
{ExcludeUnrealizableParameters,CutUnwantedFlavourIndices,CutUnwantedInvariantIndices,UseFieldNames};

{PrintModelInformation};

{IsModelAnomalyFree};

{CalculateLagrangian,f1,f2,f3,PrintHeaderText,PrintHeaderText2,PrintHeaderText3};

{g,M,f,y,\[Mu],l,h,b,s,m2};

{CalculateEverything,CalculateBetaFunctions,BasisRotation};

{PrintAllModelInformation};

(* SSB: this is something which is set up only in the SSB sub-package *)
{parentModel,childModel,parentReps,childReps};

Begin["Private`"];

(* This method should be for internal use only *)
Options[RenameParametersWithRules]={Verbose->False};
RenameParametersWithRules[model_, ruleList_,OptionsPattern[]]:=Module[{aux},
lagrangian[model]^=lagrangian[model]//.ruleList;
betaFunctions[model]^=betaFunctions[model]//.ruleList;
parameters[model]^=parameters[model]//.ruleList;
parameterTransformationRule[model]^=If[ValueQ[parameterTransformationRule[model]],Append[parameterTransformationRule[model],ruleList],{ruleList}];
If[OptionValue[Verbose],PrintAllModelInformation[model]];
]

(* If this method is called, all variables associated with a model are computed and made available *)
Options[GenerateModel]={CalculateEverything->False,CalculateBetaFunctions->True,Verbose->True,BasisRotation->Null};
GenerateModel[model_,OptionsPattern[]]:=Module[{},
If[CheckModel[model],
(* Reset transformation rules *)
parameterTransformationRule[model]^={};
If[!ValueQ[parameterRenamingRules[model]],parameterRenamingRules[model]^={}]; (* These are user defined rules *)

GenerateModelParameters[model];
parameters[model]^=parameters[model]//.parameterRenamingRules[model];

If[OptionValue[CalculateBetaFunctions],
GenerateModelBetaFunctions[model];
betaFunctions[model]^=betaFunctions[model]//.parameterRenamingRules[model];
];

If[OptionValue[CalculateEverything],
CalculateLagrangian[model,Verbose->False,BasisRotation->OptionValue[BasisRotation]];
lagrangian[model]^=lagrangian[model]//.parameterRenamingRules[model];
];

(* Things to include: model name; model group; model representations; nFlavs; discreteSyms; model parameters; model beta functions; *)
If[OptionValue[Verbose],PrintAllModelInformation[model]];
];
]
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Any input with group, reps, fieldNames, nFlavs and discreteSym defined will trigger the execution of PrintAllModelInformation *)

(*
$Pre=If[ValueQ[group[#]]&&ValueQ[reps[#]]&&ValueQ[fieldNames[#]]&&ValueQ[nFlavs[#]]&&ValueQ[discreteSym[#]],PrintAllModelInformation[#],#]&;
*)


SetAttributes[myPre, HoldAll];
myPre[input_]:=Module[{aux,groupNames},
aux=ToString[Unevaluated[input]];
groupNames=Join[StringCases[aux,RegularExpression["(?i)SU[0-9]+"],IgnoreCase->True],StringCases[aux,RegularExpression["(?i)SO[0-9]+"],IgnoreCase->True],StringCases[aux,RegularExpression["(?i)SP[0-9]+"],IgnoreCase->True],Names[RegularExpression["(?i)SU[0-9]+"],IgnoreCase->True],Names[RegularExpression["(?i)SO[0-9]+"],IgnoreCase->True],Names[RegularExpression["(?i)SP[0-9]+"],IgnoreCase->True]];

(If[Head[ToExpression[#]]==Symbol,Evaluate[ToExpression[#]]=CartanMatrix[StringTake[#,2],ToExpression[StringDrop[#,2]]]])&/@groupNames;

Return[Evaluate[input]];];

$Pre=myPre;



myPost[input_]:=Module[{},
If[ValueQ[group[input]]&&ValueQ[reps[input]]&&ValueQ[fieldNames[input]]&&ValueQ[nFlavs[input]]&&ValueQ[discreteSym[input]],PrintAllModelInformation[input],Return[input]];
];
$Post=myPost;

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

IsModelAnomalyFree[model_]:=Module[{anomalyValues},
anomalyValues=Total[nFlavs[model] (TriangularAnomalyValue[group[model],#]&/@reps[model])];Which[anomalyValues===0anomalyValues,Return[True],anomalyValues=!=0anomalyValues,Return[False],True,Print["The model is anomaly if and only if ",anomalyValues, " are all zero."]];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXX Generating the model's parameters XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Returns the position and multiplicity in 'reps' of the representations that form trilinear invariants with reps[[i]] and reps[[j]]. Only representations with a position bigger than j will be returned. The output is {{rep1 position, #invariants with rep1},...} *)
SearchForInvariants[model_,i_,j_]:=Module[{aux,result,discreteCharge},
aux=Simplify[ReduceRepProduct[group[model],{reps[model][[i]],reps[model][[j]]}]];
discreteCharge=discreteSym[model][[i]] discreteSym[model][[j]];
aux=Table[{{aux[[k,1]],discreteCharge},aux[[k,2]]},{k,Length[aux]}];
aux=DeleteCases[aux,x_/;!MemberQ[conjugateReps[model][[j;;-1]],x[[1]],{1}]];
result={j-1+(Position[conjugateReps[model][[j;;-1]],#[[1]]])[[All,1]],#[[2]]}&/@aux;

result=Flatten[Table[{result[[c1,1,c2]],result[[c1,2]]},{c1,Length[result]},{c2,Length[result[[c1,1]]]}],1];
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

GenerateModelParameters[model_]:=Module[{aux,conjugateRs,nonU1sPositions,u1sPositions,nU1s,gMatrix,mMatrix,pY,p\[Mu],pL,pH,pB,pS,pM2,modelParametersSusyno},

(* Calculate and set the model's conjugate representations *)
conjugateRs=ConjugateIrrep[group[model],#]&/@reps[model];
conjugateRs=Thread[{conjugateRs,1/discreteSym[model]}];

conjugateReps[model]^=conjugateRs;

(* Set the number of representations *)
nReps[model]^=Length[reps[model]];


aux=Table[SearchForInvariants[model,i,j],{i,nReps[model]},{j,i,nReps[model]}];
aux=Table[{i,i+j-1,aux[[i,j,k,1]],aux[[i,j,k,2]]},{i,Length[aux]},{j,Length[aux[[i]]]},{k,Length[aux[[i,j]]]}];
aux=Flatten[aux,2];
(* aux now contains a list with (index1,index2,index3,multiplicity) of each trilinear parameter allowed by the model *)
(* Get all the Yukawa parameters *)
pY=Flatten[Table[y[aux[[i,1;;3]],j,{f[1],f[2],f[3]}],{i,Length[aux]},{j,aux[[i,4]]}],1];
pH=pY/.y->h;
(* [end]Get all the Yukawa parameters *)

(* Get all the bilinear parameters *)
aux=Table[If[{reps[model][[i]],discreteSym[model][[i]]}==conjugateRs[[j]],{i,j},Null],{i,nReps[model]},{j,i,nReps[model]}];
aux=Flatten[aux,1];
aux=DeleteCases[aux,Null,{1}];
p\[Mu]=Table[\[Mu][aux[[i]],{f[1],f[2]}],{i,Length[aux]}];
pB=p\[Mu]/.\[Mu]->b;
(* [end]Get all the bilinear parameters *)

(* Get all the linear parameters *)
aux={conjugateRs[[1,1]]0,conjugateRs[[1,2]]0+1};
aux=Position[conjugateRs,aux,{1}];

pL=Table[l[aux[[i]],{f[1]}],{i,Length[aux]}];
pS=pL/.l->s;
(* [end]Get all the linear parameters *)

(* Get all mass parameters *)
(* pM2=Array[m2[{#,#},{f[1],f[2]}]&,nReps[model]]; *)

aux=Table[If[{reps[model][[i]],discreteSym[model][[i]]}=={reps[model][[j]],discreteSym[model][[j]]},{i,j},Null],{i,nReps[model]},{j,i,nReps[model]}];
aux=Flatten[aux,1];
aux=DeleteCases[aux,Null,{1}];
pM2=Table[m2[aux[[i]],{f[1],f[2]}],{i,Length[aux]}];
(* [end]Get all mass parameters *)





(* Get all gauge and gaugino parameter *)

nonU1sPositions=Position[group[model],x_/;!(x==U1),{1}]//Flatten;
u1sPositions=Position[group[model],U1]//Flatten;
nU1s=Length[u1sPositions];

If[nU1s>0,
gMatrix=Array[g[u1sPositions[[#1]],u1sPositions[[#2]]]&,{nU1s,nU1s}];
mMatrix=Array[M[u1sPositions[[#1]],u1sPositions[[#2]]]&,{nU1s,nU1s}];
,
(* trick the code by assuming that there is an U1 with everything set to 0 *)
gMatrix={};
mMatrix={};
];

If[nU1s==1,
gMatrix=gMatrix/.g[1,1]:>g[1];
mMatrix=mMatrix/.M[1,1]:>M[1];
];
(* [end]Get all gauge and gaugino parameter *)


parameters[model]^={Join[gMatrix//Flatten,g/@nonU1sPositions],Join[mMatrix//Flatten,M/@nonU1sPositions],Sort[pY],Sort[p\[Mu]],Sort[pL],Sort[pH],Sort[pB],Sort[pS],Sort[pM2]};
originalParameters[model]^=parameters[model];

(* Must be called in this order *)
ExcludeUnrealizableParameters[model];
CutUnwantedFlavourIndices[model];
CutUnwantedInvariantIndices[model];
UseFieldNames[model];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* This method is to be called after the model parameters are generated, assuming nothing about the number of flavours. This methods will then take into account the permutation symmetry of the invariant combinations of fields and see what is the induced symmetry on the flavour indices of the parameters. The parameters which, due to antisymmetries are not realizable are then cut from the list of parameters *)
ExcludeUnrealizableParameters[model_]:=Module[{temporaryParameters,symInformation,parameterHead,flavours,types,repsPlusDiscreteCharges,result,aux1,aux2,counter,mainList,snDimentionOfEachFieldCombination,numberOfIndependentParameters},
temporaryParameters=originalParameters[model];
symInformation=ConstantArray[Null,9];
Do[
parameterHead=Switch[part,3,y,4,\[Mu],5,l,6,h,7,b,8,s];
flavours=Array[f,Switch[part,3,3,4,2,5,1,6,3,7,2,8,1]];

types=temporaryParameters[[part,All,1]];
types=Tally[types][[All,1]];
(* [OLD] Using "PermutationSymmetryOfInvariants[group[model],reps[model][[#]]]&/@types" only will not take into account fields may be distinguisable by the discrete symmetry charges. The solution used is to add temporarily a fake U1 group with these charges *)
(* [NEW] Actually different fields (as given by the user) are distinct always even if they have the the same gauge representations and discrete charges. The trick then is to add a fake U1 with hypercharges which are always distinct amoungst different fields. This can be done term by term (fake hypercharges may vary from term to term) - TODO *)
aux=Tally/@types;
fakeHypercharges={};
Do[
sum=0;collect={};
Do[
AppendTo[collect,{aux[[j,i,1]]->i}];
sum+=i aux[[j,i,2]];
,{i,Length[aux[[j]]]-1}];
AppendTo[collect,{aux[[j,-1,1]]->-sum/aux[[j,-1,2]]}];
AppendTo[fakeHypercharges,types[[j]]/.Flatten[collect]];
,{j,Length[aux]}];

repsWithFakeHypercharges=MapThread[MapThread[Append,{##}]&,{reps[model][[#]]&/@types,fakeHypercharges}];
(* [END] Adding fake hypercharges *)
aux1=PermutationSymmetryOfInvariants[Append[group[model],U1],#]&/@repsWithFakeHypercharges;

(* This is the master list: it for every combination of fields and every snIrrep allowed by it, there is an entry with {A,B,C,D,E},
A=position of the indices involved;
B=model index of the fields involved;
C=Sn irrep;
D=multiplicity of Sn irrep;
E=total number of invariants of this type, taking into account the Sn irrep size and its multiplicity;
F=number of independent (complex in principle) parameters computed taking into account the number of flavors of each field
*)
mainList=Table[{aux1[[fieldCombination,1]],types[[fieldCombination,#]]&/@aux1[[fieldCombination,1]],snIrrep[[1]],snIrrep[[2]],snIrrep[[2]]Times@@(SnIrrepDim/@snIrrep[[1]]),Times@@MapThread[HookContentFormula,{snIrrep[[1]],nFlavs[model][[types[[fieldCombination,#]]]]&/@aux1[[fieldCombination,1,All,1]]}]},{fieldCombination,Length[aux1]},{snIrrep, aux1[[fieldCombination,2]]}];
mainList=Flatten[mainList,1];

aux1={};
aux2={};
Do[
counter=Count[aux1,Sort[Flatten[entry[[2]]]]];
aux1=Join[aux1,ConstantArray[Sort[Flatten[entry[[2]]]],entry[[5]]]];

(* The following If is needed to avoid introducing a "1" invariant index to \[Mu],l,b,s parameters *)
If[part==3||part==6,
aux2=Join[aux2,Table[{parameterHead[Sort[Flatten[entry[[2]]]],counter+j,flavours],entry[[1]],entry[[3]],entry[[6]]},{j,entry[[5]]}]];
,
aux2=Join[aux2,Table[{parameterHead[Sort[Flatten[entry[[2]]]],flavours],entry[[1]],entry[[3]],entry[[6]]},{j,entry[[5]]}]];
]
,{entry,Cases[mainList,x_/;!(x[[6]]===0)]}];


(* Record the information and save it at the end to the model variable *)
temporaryParameters[[part]]=aux2[[All,1]];
symInformation[[part]]=aux2[[All,2;;-1]];

,{part,3,8}];

(* There is no redefinition of parameters here; some of them are simply deleted *)
originalParameters[model]^=temporaryParameters;
parameters[model]^=temporaryParameters;
parametersSymmetries[model]^=symInformation;

];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

CutUnwantedFlavourIndices[model_]:=Module[{rules,ruleP1,ruleP2,nfs,aux,s1,s2,s3},

rules={};
Do[
nfs=Switch[part,3,3,4,2,5,1,6,3,7,2,8,1,9,2];
aux=Flatten[Position[parameter[[1]],x_/;!(nFlavs[model][[x]]===1),Heads->False]];
ruleP1=parameter;
ruleP1[[-1]]={s1_,s2_,s3_}[[1;;nfs]];
ruleP2=parameter;
ruleP2[[-1]]={s1,s2,s3}[[aux]];
If[ruleP2[[-1]]==={},ruleP2=Delete[ruleP2,-1]];
AppendTo[rules,ruleP1->ruleP2];

,{part,3,9},{parameter,originalParameters[model][[part]]}];

RenameParametersWithRules[model,rules];
];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* This applies only to trilinear terms *)
(* Maybe in the future \[Mu],L,b,s terms could from the start have the invariant index supressed *)
CutUnwantedInvariantIndices[model_]:=Module[{rules,ruleP1,ruleP2,numberOfOccurences,aux,s1,s2,s3},

rules={};
Do[

numberOfOccurences=Count[parameters[model][[part,All,1]],parameter[[1]]];

(* kill the invariant index if there is no possible confusion *)
If[numberOfOccurences==1,
ruleP1=parameter;
ruleP2=parameter;
If[Length[parameter]==3,
ruleP1[[3]]={s1_,s2_,s3_}[[1;;Length[parameter[[-1]]]]];
ruleP2[[3]]={s1,s2,s3}[[1;;Length[parameter[[-1]]]]];
];
ruleP2=Delete[ruleP2,2];
AppendTo[rules,ruleP1->ruleP2];
];

,{part,{3,6}},{parameter,parameters[model][[part]]}];

RenameParametersWithRules[model,rules];
];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* If fieldNames[model] has been defined by the user, the parameter names instead of using each field's position will use the field's name *)
UseFieldNames[model_]:=Module[{rules,more},

If[ValueQ[fieldNames[model]],

rules={};
Do[
AppendTo[rules,parameter[[0]][parameter[[1]],more___]->parameter[[0]][fieldNames[model][[parameter[[1]]]],more]];
,{part,3,9},{parameter,parameters[model][[part]]}];

 RenameParametersWithRules[model,rules]; 
];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX GENERATING THE LAGRANGIAN XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

Options[CalculateLagrangian]={Verbose->True,BasisRotation->Null};
CalculateLagrangian[model_,OptionsPattern[]]:=Module[{sum,inv,combinatorialFactor,fNames,result,parts,noU1sPositions,aux,ruleA,ruleB,rotationOfRepresentations,start,end,rotationRule,hasFlavors,vectorDimensions,vector1,vector2},
result={};
fNames=If[ValueQ[fieldNames[model]],fieldNames[model],Table[ToExpression["\[CapitalPhi]"<>ToString[i]],{i,Length[reps[model]]}]];


(* If[OptionValue[BasisRotation]===Null,
rotationOfRepresentations=Null;
,
aux=(Times@@DimR[group[model],#])&/@reps[model];
start=Accumulate[aux]-aux+1;
end=Accumulate[aux];

rotationOfRepresentations=Table[OptionValue[BasisRotation][[start[[i]];;end[[i]],start[[i]];;end[[i]]]],{i,Length[reps[model]]}];
]; *)

parts={{1,2,3},{1,2},{1},{1,2,3},{1,2},{1}};

Do[
sum=0;
Do[

(* Get rid of gauge indices which are always one *)
noU1sPositions=Flatten[Position[group[model],x_/;x=!={},{1},Heads->False]];
aux=DimR[group[model][[noU1sPositions]],#[[noU1sPositions]]]&/@reps[model][[parameter[[1]]]];
aux=Flatten[Position[#,Except[1],{1},Heads->False]]&/@aux;
ruleA={a,b,c}[[#]][x__]:>If[aux[[#]]==={},{a,b,c}[[#]],{a,b,c}[[#]][{x}[[aux[[#]]]]]]&/@{1,2,3};
ruleB={a[{x___}]:>a[x],b[{x___}]:>b[x],c[{x___}]:>c[x]};
(* [END] Get rid of gauge indices which are always one *)

combinatorialFactor=Times@@(Factorial/@Tally[parameter[[1]]][[All,2]]);

inv=Fold[#1//.#2&,parameter,parameterTransformationRule[model]] (1/combinatorialFactor Invariants[group[model],reps[model][[parameter[[1]]]]]/. ruleA/.ruleB/.{a:>If[nFlavs[model][[parameter[[1,1]]]]===1,fNames[[parameter[[1,1]]]],fNames[[parameter[[1,1]]]][f[1]]],b:>If[nFlavs[model][[parameter[[1,2]]]]===1,fNames[[parameter[[1,2]]]],fNames[[parameter[[1,2]]]][f[2]]],c:>If[nFlavs[model][[parameter[[1,3]]]]===1,fNames[[parameter[[1,3]]]],fNames[[parameter[[1,3]]]][f[3]]]}[[parts[[i]]]]);
inv=DeleteCases[inv,0];
If[Length[inv]==0,inv={0}];
inv=If[Length[parameter]>2,inv[[parameter[[2]]]],inv[[1]]];

sum+=inv;
,{parameter,originalParameters[model][[2+i]]}];
AppendTo[result,sum];
,{i,1,6}];

sum=0;
Do[

(* Get rid of gauge indices which are always one *)
noU1sPositions=Flatten[Position[group[model],x_/;x=!={},{1},Heads->False]];
aux=DimR[group[model][[noU1sPositions]],#[[noU1sPositions]]]&/@reps[model][[parameter[[1]]]];
aux=Flatten[Position[#,Except[1],{1},Heads->False]]&/@aux;
ruleA={a,b,c}[[#]][x__]:>If[aux[[#]]==={},{a,b,c}[[#]],{a,b,c}[[#]][{x}[[aux[[#]]]]]]&/@{1,2,3};
ruleB={a[{x___}]:>a[x],b[{x___}]:>b[x],c[{x___}]:>c[x]};
(* [END] Get rid of gauge indices which are always one *)

inv=Fold[#1//.#2&,parameter,parameterTransformationRule[model]] (Invariants[group[model],reps[model][[parameter[[1]]]],Conjugations->{False,True}]/.ruleA/.ruleB/. {a:>If[nFlavs[model][[parameter[[1,1]]]]===1,fNames[[parameter[[1,1]]]],fNames[[parameter[[1,1]]]][f[1]]],b:>If[nFlavs[model][[parameter[[1,2]]]]===1,Conjugate[fNames[[parameter[[1,2]]]]],Conjugate[fNames[[parameter[[1,2]]]]][f[2]]]});
inv=DeleteCases[inv,0][[1]];

sum+=inv;
,{parameter,originalParameters[model][[9]]}];
AppendTo[result,sum];

(* Deal with possible rotations in matter field space *)
If[OptionValue[BasisRotation]=!=Null,
hasFlavors=(!(#===1))&/@nFlavs[model];
vectorDimensions=DeleteCases[DimR[group[model],#],1]&/@reps[model];

vector2=Flatten[Table[Array[If[hasFlavors[[nameI]],fNames[[nameI]][flavIdx],fNames[[nameI]]],vectorDimensions[[nameI]]]/.head_[]:>head,{nameI,Length[fNames]}]];
vector1=vector2/.flavIdx->flavIdx_;

rotationRule=MapThread[RuleDelayed,{vector1,Conjugate[OptionValue[BasisRotation]].vector2}];
result=Expand[result/.rotationRule];
];
(* /Deal with possible rotations *)

lagrangian[model]^=result;


(* Print the result if needed *)
If[OptionValue[Verbose],PrintLagrangian[model]];

]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX PRINTING FUNCTIONS XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)


(* Appears to be buggy *)
 Off[ColumnForm::"colmh"]; 

PrintAllModelInformation[model_]:=Module[{spacing,tab},

(* First make user that user defined substitutions, defined after the last GenerateModel was executed, are indeed implemented *)
If[ValueQ[parameterRenamingRules[model]],
parameters[model]^=parameters[model]//.parameterRenamingRules[model];
betaFunctions[model]^=betaFunctions[model]//.parameterRenamingRules[model];
If[ValueQ[lagrangian[model]],
lagrangian[model]^=lagrangian[model]//.parameterRenamingRules[model];
]
];

spacing=StringJoin@@ConstantArray[" ",6];
tab=TabView[{spacing<>"Model Information"<>spacing->PrintModelInformation[model],spacing<>"Gauge group"<>spacing->PrintModelGaugeGoup[model],spacing<>"Representations"<>spacing->PrintModelRepresentations[model],spacing<>"Parameters in model"<>spacing->PrintModelParameters[model],spacing<>"Lagrangian"<>spacing->PrintLagrangian[model],spacing<>"BetaFunctions"<>spacing->PrintModelBetaFunctions[model]},1,LabelStyle->{Darker[Red],FontFamily->"Consolas",FontSize->13,Bold},ControlPlacement->Top,Appearance->None,FrameMargins->20,Alignment->{Left,Automatic},ImageSize->{(*6 170*)Automatic,Automatic}];
Print[tab];
];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

PrintModelInformation[model_]:=Module[{result},
result={OpenerView[{Style["Model name",Bold],Row[{"",model}]},True]};

If[ValueQ[author[model]],AppendTo[result,OpenerView[{Style["Author",Bold],Row[{"",author[model]}]},True]]];
If[ValueQ[date[model]],AppendTo[result,OpenerView[{Style["Date",Bold],Row[{"",date[model]}]},True]]];


Return[Row[result,"\n",BaseStyle->(FontFamily->"Consolas")]];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

PrintModelGaugeGoup[model_]:=Module[{result},
result={};
(*
AppendTo[result,PrintHeaderText2["Gauge group","X",120]];
AppendTo[result,""];
*)
AppendTo[result,StringJoin[Riffle[CMtoName/@group[model]," x "]]];
AppendTo[result,""];
If[IsModelAnomalyFree[model],
AppendTo[result,Row[{Style["GOOD NEWS:",{Bold,Darker[Green]}],Style[" The model is gauge anomaly free.",Darker[Green]]}]];,
AppendTo[result,Row[{Style["BAD NEWS:",{Bold,Darker[Red]}],Style[" The model contains gauge anomalies!",Darker[Red]]}]];
];

AppendTo[result,""];
AppendTo[result,Style[">>> Extra information",{GrayLevel[0.5],Bold}]];
AppendTo[result,Row[{"    This data is contained in the ",Button[Style["group["<>ToString[model]<>"]",{Underlined,GrayLevel[0.5],FontFamily->"Consolas"}],CellPrint[Cell["group["<>ToString[model]<>"]","Input"]],Appearance->None,Background->GrayLevel[1],FrameMargins->2]," variable."},BaseStyle->GrayLevel[0.5]]];

Return[Row[result,"\n",BaseStyle->(FontFamily->"Consolas")]];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

PrintModelRepresentations[model_]:=
Module[{aux,grayType,result},
grayType=GrayLevel[.9];
result=Table[Tooltip[#[[i]],Grid[{{"Dim(R)","=",DimR[group[model][[i]],#[[i]]]},{"C(R)","=",Casimir[group[model][[i]],#[[i]]]},{"S(R)","=",DynkinIndex[group[model][[i]],#[[i]]]}},Spacings->{0.5,1}],Evaluate[If[$VersionNumber>=8,LabelStyle(*TooltipStyle*),LabelStyle ]->{Background->Automatic,CellFrameColor->RGBColor[174/256,0,41/256],CellFrame->5}]],{i,Length[#]}]&/@reps[model];

result=Prepend[result,Style[CMtoName[#],Bold]&/@group[model]];
result=Transpose[result];

aux=Prepend[nFlavs[model],Style["#Flavours",Bold]];
AppendTo[result,aux];

aux=Prepend[discreteSym[model],Style["R-Charges",Bold]];
AppendTo[result,aux];

TextAngle[texts_,slotSize_]:=If[0^2+Max[StringLength/@ToString/@texts]^2<=slotSize^2,0,ArcCos[N[(slotSize Max[StringLength/@ToString/@texts]+Sqrt[1.5^2-slotSize^2+Max[StringLength/@ToString/@texts]^2])/(1.5^2+Max[StringLength/@ToString/@texts]^2)]]];
TextAngle[texts_String,slotSize_]:=If[1.5^2+Max[StringLength/@texts]^2<=slotSize^2,0,ArcCos[N[(slotSize Max[StringLength/@texts]+Sqrt[1.5^2-slotSize^2+Max[StringLength/@texts]^2])/(1.5^2+Max[StringLength/@texts]^2)]]];

aux=If[ValueQ[fieldNames[model]],Prepend[Table[Rotate[Style[fieldNames[model][[i]],Bold],TextAngle[fieldNames[model],3]],{i,Length[reps[model]]}],Null],Prepend[Table[Rotate[Style["Field "<>ToString[i],Bold],TextAngle[{"Field "<>ToString[Length[reps[model]]]},3]],{i,Length[reps[model]]}],Null]];
PrependTo[result,aux];

result={Grid[result,Alignment->{Center,Center},Dividers->{{2->{grayType,Thick}},{2->{grayType,Thick},-3->{grayType,Thick},-2->{grayType,Thick}}},Spacings->{1,1},ItemSize->{{6}}]};

AppendTo[result,""];
AppendTo[result,Style[">>> Extra information",{GrayLevel[0.5],Bold}]];
AppendTo[result,Row[{"    This data is contained in the ",Button[Style["reps["<>ToString[model]<>"]",{Underlined,GrayLevel[0.5],FontFamily->"Consolas"}],CellPrint[Cell["reps["<>ToString[model]<>"]","Input"]],Appearance->None,Background->GrayLevel[1],FrameMargins->2]," variable."},BaseStyle->GrayLevel[0.5]]];

Return[Row[result,"\n",BaseStyle->{FontFamily->"Consolas",FontSize->13}]];

]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Auxilar method used to write down the symmetries of parameters under a permutation of flavors *)
PrintParametersSymmetries[model_,i_,j_]:=Module[{aux1,aux2,out,syms,anyNonTrivialSymmetry=False},
If[i<3||i>8,Return[Row[{},BaseStyle->GrayLevel[0.5]]]];

aux1=Position[parametersSymmetries[model][[i,j,1]],x_/;Length[x]>1,{1},Heads->False]//Flatten;

(* Condition 1: there must be repeated indices! *)
syms={};
If[Length[aux1]>0,
Do[
aux2=originalParameters[model][[i,j,1,parametersSymmetries[model][[i,j,1,k,1]]]];
(* Condition 2: there must be more than one copy of the repeated fields *)
If[nFlavs[model][[aux2]]=!=1,AppendTo[syms,k]];
,{k,aux1}];
];

(* At this point, syms contains for each parameter (given by i,j) the position in parametersSymmetries[model][[i,j,1]] and parametersSymmetries[model][[i,j,2]] of the symmetries that need to be reported (the non-trivial ones) *)
out={};
Do[
aux1=Which[Length[parametersSymmetries[model][[i,j,2,k]]]==1,{"symmetric"},Length[parametersSymmetries[model][[i,j,2,k]]]==Total[parametersSymmetries[model][[i,j,2,k]]],{"antisymmetric"},True,{"transforms as the ",parametersSymmetries[model][[i,j,2,k]]," representation of ",Subscript["S", Total[parametersSymmetries[model][[i,j,2,k]]]]}];
out=Join[out,aux1,{" under a permutation of the flavor indices ",Fold[#1/.#2&,(f/@parametersSymmetries[model][[i,j,1,k]]),parameterRenamingRules[model]],", "}]; (* Note - this line is fine: parametersSymmetries[model][[i,j,1,k]] contains the position of the field in the parameter, and this is the same as the flavor index number even if 'previous' fields are unflavored *)
,{k,syms}];
If[Length[syms]>0,
PrependTo[out,"  ("];
out[[-1]]=")"
];

Return[Row[out,BaseStyle->{GrayLevel[0.5],FontFamily->"Consolas",FontSize->13}]];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

PrintModelParameters[model_]:=Module[{result,parametersAndSymmetries},
result={};

If[ValueQ[parameters[model]],
parametersAndSymmetries=Table[Row[{parameters[model][[i,j]],PrintParametersSymmetries[model,i,j]}],{i,9},{j,Length[originalParameters[model][[i]]]}];
parametersAndSymmetries=Table[If[el==={},{Style["---",{Black,Plain}]},el],{el,parametersAndSymmetries}];

result={Column[MapThread[OpenerView[{Style[#1,Bold],Column[#2,BaseStyle->{Darker[Orange],Bold}]},True]&,{{"Gauge coupling constants","Gaugino masses","Superpotential trilinear parameters","Superpotential bilinear parameters","Superpotential linear parameters","Soft trilinear parameters","Soft bilinear parameters","Soft linear parameters","Soft masses"},parametersAndSymmetries}]]};


If[!ValueQ[parameterRenamingRules[model]]||parameterRenamingRules[model]==={},
AppendTo[result,""];
AppendTo[result,Style[">>> Parameter notation",{GrayLevel[0.5],Bold}]];
AppendTo[result,Row[{"    The program's default notation can be changed by setting ", Button[Style["parameterRenamingRules["<>ToString[model]<>"]",{Underlined,GrayLevel[0.5],FontFamily->"Consolas"}],CellPrint[Cell["parameterRenamingRules["<>ToString[model]<>"]","Input"]],Appearance->None,FrameMargins->2]," (see the ",Hyperlink["Susyno Tutorial", 
  "paclet:Susyno/tutorial/SusynoTutorial"],")."},BaseStyle->{GrayLevel[0.5]}]];
];

AppendTo[result,""];
AppendTo[result,Style[">>> Extra information",{GrayLevel[0.5],Bold}]];
AppendTo[result,Row[{"    This data is contained in the ",Button[Style["parameters["<>ToString[model]<>"]",{Underlined,GrayLevel[0.5],FontFamily->"Consolas"}],CellPrint[Cell["parameters["<>ToString[model]<>"]","Input"]],Appearance->None,Background->GrayLevel[1],FrameMargins->2]," variable."},BaseStyle->GrayLevel[0.5]]];
AppendTo[result,Row[{"    Symmetries of parameters under a change of flavor indices are in ",Button[Style["parametersSymmetries["<>ToString[model]<>"]",{Underlined,GrayLevel[0.5],FontFamily->"Consolas"}],CellPrint[Cell["parametersSymmetries["<>ToString[model]<>"]","Input"]],Appearance->None,Background->GrayLevel[1],FrameMargins->2],"."},BaseStyle->GrayLevel[0.5]]];

,

AppendTo[result,Row[{"Run ",Button[Style["GenerateModel["<>ToString[model]<>"]",{Underlined,GrayLevel[0.5],FontFamily->"Consolas"}],CellPrint[Cell["GenerateModel["<>ToString[model]<>"]","Input"]],Appearance->None,Background->GrayLevel[1],FrameMargins->2]," to compute the list of model parameters."},BaseStyle->GrayLevel[0.5]]];


];
Return[Row[result,"\n",BaseStyle->{FontFamily->"Consolas",FontSize->13}]];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

PrintLagrangian[model_]:=Module[{pos,aux0,aux1,aux2,aux3,result},
result={};
If[ValueQ[lagrangian[model]],

(* Explain the notation *)
AppendTo[result,Row[{">>> ",Style["Parameters",{Darker[Orange],Bold}]," are shown in dark orange; ", Style["field heads",{RGBColor[0,51/255,153/255],Bold}] ," are shown in blue."},BaseStyle->{GrayLevel[0.5],Bold}]];
AppendTo[result,""];
AppendTo[result,Style[">>> Field notation",{GrayLevel[0.5],Bold}]];

pos=Table[Flatten[Position[DimR[group[model],el],Except[1],{1},Heads->False]],{el,reps[model]}];
aux0=Table[(CMtoName[#]<>"_index")&/@(group[model][[Flatten[Position[DimR[group[model],el],Except[1],{1},Heads->False]]]]),{el,reps[model]}];
aux1=Table[If[Length[pos[[i]]]==0,"","["<>StringJoin[Riffle[(CMtoName[#]<>"_index")&/@group[model][[pos[[i]]]],", "]]<>"]"],{i,Length[reps[model]]}];

Do[
aux2=If[Head[fieldNames[model][[i]]]===String,fieldNames[model][[i]],ToString[fieldNames[model][[i]]]]<>If[nFlavs[model][[i]]===1,"","[flavor_index]"];
aux3=StringJoin[Riffle[Table[aux0[[i,j]]<>" = 1 to "<>ToString[DimR[group[model],reps[model][[i]]][[pos[[i,j]]]]],{j,Length[pos[[i]]]}],", "]];
aux2=Style["    "<>aux2<>aux1[[i]]<>If[Length[pos[[i]]]==0,"","   with   "<>aux3<>""],GrayLevel[0.5]];
AppendTo[result,aux2];
,{i,Length[reps[model]]}];
AppendTo[result,""];
AppendTo[result,Style[">>> Extra information",{GrayLevel[0.5],Bold}]];
AppendTo[result,Row[{"    This data is contained in the ",Button[Style["lagrangian["<>ToString[model]<>"]",{Underlined,GrayLevel[0.5],FontFamily->"Consolas"}],CellPrint[Cell["lagrangian["<>ToString[model]<>"]","Input"]],Appearance->None,Background->GrayLevel[1],FrameMargins->2]," variable."},BaseStyle->{GrayLevel[0.5],FontSize->13}]];

PrependTo[result,""];

PrependTo[result,Column[MapThread[OpenerView[{Style[#1,Bold],#2},True]&,{{"Superpotential (trilinear terms)","Superpotential (bilinear terms)","Superpotential (linear terms)","Soft SUSY breaking Lagrangian (trilinear terms)","Soft SUSY breaking Lagrangian (bilinear terms)","Soft SUSY breaking Lagrangian (linear terms)","Soft SUSY breaking Lagrangian (mass terms)"},lagrangian[model]/.Join[(#:>Style[#,{Darker[Orange],Bold}]&/@Flatten[parameters[model],1]),(#:>Style[#,{RGBColor[0,51/255,153/255],Bold}]&/@fieldNames[model])]}]]];
,
AppendTo[result,Row[{"Run ",Button[Style["GenerateModel["<>ToString[model]<>",CalculateEverything->True]",{Underlined,GrayLevel[0.5],FontFamily->"Consolas"}],CellPrint[Cell["GenerateModel["<>ToString[model]<>",CalculateEverything->True]","Input"]],Appearance->None,Background->GrayLevel[1],FrameMargins->2]," to compute the model Lagrangian."},BaseStyle->{GrayLevel[0.5],FontSize->13}]];
];
SAVE0=Row[result,"\n",BaseStyle->{FontFamily->"Consolas",FontSize->13}];
Return[Row[result,"\n",BaseStyle->{FontFamily->"Consolas",FontSize->13}]];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

PrintModelBetaFunctions[model_]:=Module[{result},
result={};
If[ValueQ[betaFunctions[model]],
Do[
AppendTo[result,{Style[parameters[model][[i,j]],{Darker[Orange],Bold}],Column[{OpenerView[{Style["~~~~~ \!\(\*SuperscriptBox[\(\[Beta]\), \((1)\)]\) ~~~~~",{Bold,RGBColor[0,51/255,153/255]}],Expand[betaFunctions[model][[i,1,j]]]}],OpenerView[{Style["~~~~~ \!\(\*SuperscriptBox[\(\[Beta]\), \((2)\)]\) ~~~~~",{Bold,RGBColor[0,51/255,153/255]}],Expand[betaFunctions[model][[i,2,j]]]}]}]}];

,{i,Length[parameters[model]]},{j,Length[parameters[model][[i]]]}];
result={Column[OpenerView/@result,Dividers->{Center,GrayLevel[0.9]},ItemSize->{79,Automatic}]};
AppendTo[result,""];
AppendTo[result,Style[">>> Extra information",{GrayLevel[0.5],Bold}]];
AppendTo[result,Row[{"    This data is contained in the ",Button[Style["betaFunctions["<>ToString[model]<>"]",{Underlined,GrayLevel[0.5],FontFamily->"Consolas"}],CellPrint[Cell["betaFunctions["<>ToString[model]<>"]","Input"]],Appearance->None,Background->GrayLevel[1],FrameMargins->2]," variable."},BaseStyle->GrayLevel[0.5]]];

Return[Row[result,"\n",BaseStyle->{FontFamily->"Consolas",FontSize->13}]];
,
result=Row[{"Run ",Button[Style["GenerateModel["<>ToString[model]<>"]",{Underlined,GrayLevel[0.5],FontFamily->"Consolas"}],CellPrint[Cell["GenerateModel["<>ToString[model]<>"]","Input"]],Appearance->None,Background->GrayLevel[1],FrameMargins->2]," to compute the model \[Beta] functions."},BaseStyle->{GrayLevel[0.5],FontFamily->"Consolas",FontSize->13}];

Return[result];];

]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

PrintHeaderText[text_,paddingChar_,lineLength_,textColor_:Black]:=Module[{n, leftXs, rightXs,m},
n=StringLength[text];
m=Max[lineLength-4-n,6];
leftXs=StringJoin@@ConstantArray[paddingChar,Quotient[m,2]]<>"  ";
rightXs="  "<>StringJoin@@ConstantArray[paddingChar,m-Quotient[m,2]];

Return[Row[{Style[leftXs,GrayLevel[0.5]], Style[text,{Bold,textColor}], Style[rightXs,GrayLevel[0.5]]}]];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

PrintHeaderText2[text_,paddingChar_,lineLength_]:=Module[{n, leftXs, rightXs,m},
Return[Row[{Style[StringJoin@@ConstantArray[paddingChar,lineLength],GrayLevel[0.5]],PrintHeaderText[text,paddingChar,lineLength,Darker[Red]],Style[StringJoin@@ConstantArray[paddingChar,lineLength],GrayLevel[0.5]]},"\n"]];
]

End[];
EndPackage[];
