(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     54905,       1734]
NotebookOptionsPosition[     48281,       1519]
NotebookOutlinePosition[     50235,       1570]
CellTagsIndexPosition[     50149,       1565]
WindowTitle->RepMinimalMatrices - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/RepMinimalMatrices\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/RepMinimalMatrices"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
RepMinimalMatrices.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/RepMinimalMatrices", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["RepMinimalMatrices", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RepMinimalMatrices", "[", 
       RowBox[{"group", ",", "rep"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]Returns the matrices of a representation ",
     Cell[BoxData["rep"], "InlineFormula"],
     " of ",
     Cell[BoxData["group"], "InlineFormula"],
     " "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RepMinimalMatrices", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"group1", ",", "group2", ",", "..."}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"rep_group1", ",", "rep_group2", ",", "..."}], "}"}]}], 
       "]"}]], "InlineFormula"],
     "\[LineSeparator]Returns the matrices of representation ",
     Cell[BoxData["rep_group1"], "InlineFormula"],
     " of ",
     Cell[BoxData["group1"], "InlineFormula"],
     ",  ",
     Cell[BoxData["rep_group2"], "InlineFormula"],
     " of ",
     Cell[BoxData["group2"], "InlineFormula"],
     ", ..."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->451502098],

Cell[TextData[{
 "The ",
 Cell[BoxData["group"], "InlineFormula"],
 "s should be the ",
 ButtonBox["Cartan matrices",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 " of the intended groups."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Each representation ",
 Cell[BoxData["rep"], "InlineFormula"],
 " should be a list of non-negative integers (Dynkin coefficients)."
}], "Notes",
 CellID->41030773],

Cell[TextData[{
 "In the output the results are in ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " form. Use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " built-in commands ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " to convert the results if needed."
}], "Notes",
 CellID->812326107],

Cell[TextData[{
 "The output of this function is a list of sets of 3 matrices: {{",
 Cell[BoxData[
  SubscriptBox["E", "1"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["F", "1"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["H", "1"]], "InlineFormula"],
 "},{",
 Cell[BoxData[
  SubscriptBox["E", "2"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["F", "2"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["H", "2"]], "InlineFormula"],
 "},\[CenterEllipsis],{",
 Cell[BoxData[
  SubscriptBox["E", "n"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["F", "n"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["H", "n"]], "InlineFormula"],
 "}}, where n is the group's rank. ",
 Cell[BoxData[
  SubscriptBox["H", "i"]], "InlineFormula"],
 " are diagonal matrices, while ",
 Cell[BoxData[
  SubscriptBox["E", "i"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox["F", "i"]], "InlineFormula"],
 " are raising and lowering operators. These matrices obey the \
Chevalley-Serre relations: [",
 Cell[BoxData[
  SubscriptBox["E", "i"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["E", "j"]], "InlineFormula"],
 "]=",
 Cell[BoxData[
  SubscriptBox["\[Delta]", "ij"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  SubscriptBox["H", "i"]], "InlineFormula"],
 ", [",
 Cell[BoxData[
  SubscriptBox["H", "i"]], "InlineFormula"],
 ",",
 Cell[BoxData[
  SubscriptBox["E", "j"]], "InlineFormula"],
 "]= ",
 Cell[BoxData[
  SubscriptBox["A", "ji"]], "InlineFormula"],
 Cell[BoxData[
  SubscriptBox["E", "j"]], "InlineFormula"],
 ", [",
 Cell[BoxData[
  SubscriptBox["H", "i"]], "InlineFormula"],
 ",",
 Cell[BoxData[
  SubscriptBox["F", "j"]], "InlineFormula"],
 "]= -",
 Cell[BoxData[
  SubscriptBox["A", "ji"]], "InlineFormula"],
 Cell[BoxData[
  SubscriptBox["F", "j"]], "InlineFormula"],
 " and [",
 Cell[BoxData[
  SubscriptBox["H", "i"]], "InlineFormula"],
 ",",
 Cell[BoxData[
  SubscriptBox["H", "j"]], "InlineFormula"],
 "]=0, where A is the Cartan matrix of the group/algebra."
}], "Notes",
 CellID->29855657],

Cell[TextData[{
 "With the exception of SU(2) [n=1], these 3n matrices ",
 Cell[BoxData[
  SubscriptBox["E", "i"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["F", "i"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["H", "i"]], "InlineFormula"],
 " do not generate the Lie algebra, which is bigger, as some raising and \
lowering operators are missing. However, these remaining operators can be \
obtained through simple commutations: [",
 Cell[BoxData[
  SubscriptBox["E", "i"]], "InlineFormula"],
 ",",
 Cell[BoxData[
  SubscriptBox["E", "j"]], "InlineFormula"],
 "], [",
 Cell[BoxData[
  SubscriptBox["E", "i"]], "InlineFormula"],
 ",[",
 Cell[BoxData[
  SubscriptBox["E", "j"]], "InlineFormula"],
 ",",
 Cell[BoxData[
  SubscriptBox["E", "k"]], "InlineFormula"],
 "]],\[CenterEllipsis], [",
 Cell[BoxData[
  SubscriptBox["F", "i"]], "InlineFormula"],
 ",",
 Cell[BoxData[
  SubscriptBox["F", "j"]], "InlineFormula"],
 "], [",
 Cell[BoxData[
  SubscriptBox["F", "i"]], "InlineFormula"],
 ",[",
 Cell[BoxData[
  SubscriptBox["F", "j"]], "InlineFormula"],
 ",",
 Cell[BoxData[
  SubscriptBox["F", "k"]], "InlineFormula"],
 "]]."
}], "Notes",
 CellID->220613822],

Cell["\<\
This method clearly must assume a particular basis for each representation so \
the results are basis dependent.\
\>", "Notes",
 CellID->18412127],

Cell[TextData[{
 "Also, unlike ",
 Cell[BoxData[
  ButtonBox["RepMatrices",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/RepMatrices"]], "InlineFormula"],
 ", the matrices given by this function are not Hermitian and therefore they \
do not conform with the usual requirements of model building in particle \
physics. However, for some applications, they might be all that is needed."
}], "Notes",
 CellID->28371261]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->127688078],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->801757193],

Cell["SU(2)'s doublet representation [={1}] matrices:", "ExampleText",
 CellID->513681956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"matrices", "=", 
  RowBox[{"RepMinimalMatrices", "[", 
   RowBox[{"SU2", ",", 
    RowBox[{"{", "1", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196926373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    TagBox[
     RowBox[{"SparseArray", "[", 
      RowBox[{
       InterpretationBox[
        RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1", 
         "\[InvisibleSpace]", "\<\">\"\>"}],
        SequenceForm["<", 1, ">"],
        Editable->False], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "]"}],
     False,
     Editable->False], ",", 
    TagBox[
     RowBox[{"SparseArray", "[", 
      RowBox[{
       InterpretationBox[
        RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1", 
         "\[InvisibleSpace]", "\<\">\"\>"}],
        SequenceForm["<", 1, ">"],
        Editable->False], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "]"}],
     False,
     Editable->False], ",", 
    TagBox[
     RowBox[{"SparseArray", "[", 
      RowBox[{
       InterpretationBox[
        RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
         "\[InvisibleSpace]", "\<\">\"\>"}],
        SequenceForm["<", 2, ">"],
        Editable->False], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{540, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->626877149]
}, Open  ]],

Cell["\<\
Use Normal or MatrixForm, matrix by matrix, to convert the results:\
\>", "ExampleText",
 CellID->349147845],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"matrices", "//", "Normal"}], "\[IndentingNewLine]", 
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", " ", ",", "matrices", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->4735082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "}"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9615607],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"0", "1"},
        {"0", "0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[
      SparseArray[Automatic, {2, 2}, 0, {1, {{0, 1, 1}, {{2}}}, {1}}]]]], ",", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"0", "0"},
        {"1", "0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[
      SparseArray[Automatic, {2, 2}, 0, {1, {{0, 0, 1}, {{1}}}, {1}}]]]], ",", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "0"},
        {"0", 
         RowBox[{"-", "1"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[
      SparseArray[
       Automatic, {2, 2}, 0, {1, {{0, 1, 2}, {{1}, {2}}}, {1, -1}}]]]]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{188, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->809630235]
}, Open  ]],

Cell["\<\
These three matrices do generate the SU(2) algebra, and one can build the \
Pauli matrices from complex linear combinations of them.\
\>", "ExampleText",
 CellID->106768249],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->957507525],

Cell["Consider the fundamental representation of SU(3):", "ExampleText",
 CellID->692636],

Cell[CellGroupData[{

Cell["\<\
{{E1,F1,H1},{E2,F2,H2}} = RepMinimalMatrices[SU3, {1,0}];
Map[MatrixForm , {{E1,F1,H1},{E2,F2,H2}}, {2}]\
\>", "Input",
 CellLabel->"In[1]:=",
 CellID->101142205],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnT1yGz0MhpWf4rtG2hzBXXKEfBdwMhO18SSZiVO5VCl1Kl26dCeVKlXq
ADqASpcqlZXkbNZakvuSCwIUhGfGGZsBl3wJCF7uD/zuy7dPw9eDweDHf9U/
nz7/+vD9++ff/7+tfvj4++fXL2+qb95XX8tXg8H++x0ps+HgwHCG2iKWsUem
IWrEfMYUxC11u2dCX35/4SjyrGlRFZlt1pOr55nOhleTddj4aDu5gqRFHZmE
qBHzGZMQtdRNkqfKrxFHk2dNi6bI3G634/H4pLHxsd3PGDkO+EkPH/nu7g4Z
y0d/LYTGObS0xkVJcCjSsadGHPWeNS20kdmELUprHh8fN5vNSWPzYxufLVGz
dhfnZHD6ayE0zqEFnFi4S1T3rBpx1HvWtCDGaR3ZorTGeToklVSrX3zT6RQ4
jJv+WgiNc2gBJxbuQhi6PTXiqPesaUGM0zqyRemR1Wo1n8/b7VLb/93BTdUi
ICOeQKKF1phcS2tclHybrGSNOJfgWdOSb/u/Y4nSmtFo5GxfT4bPl37/fdcB
fKOq48iVp5bLJTLiCSRaaI3JtRxJulEV7VCwY7JGnEvwrGkhj8wmDFFa472E
u7+1dqT7xlptCj3e0HXkp6entHN1Ei20xuRa4pY6ZqrJHZM14lyCZ00LeWQ2
YYjSmpubG56Boki7W2dapMh9d7XM1dDkWU1afLA9A3B9fc0zUBRp8k2LFLnD
tczV0ORZTVp89I7Sw6sGpyfFjkb+J7gQ0mZlWqR4Odvjriz6qu9fLEoF0KTF
BxClodB1vmHgbCzzBF7TZkSTFh8OjeuEm2l7LEpF0KTFBxql7tBdTyZgY6En
8Jo2I5q0+HBqnE0SXh20KJVBkxYfeJS6Gi2pFoQmLT4sqeKYFiksqSb0Mi1S
WFLFMS1SlJBUBQuRUbs4Y2VCdi0k5c6IF0QwqWaL0u4lkvWsoihlqmYpnlRl
C5HRujhfZUJ+LSTlzsgXRCqp5otSZIkEPaspStmqWYonVcE3kXd5NiNUpQli
jal/QSS+KB08FGgWp5EhqeZ+x5wzqWr6xOWrHNJnlJKSKmvNnCNlJNUStSSX
9AkfCjSL0sibVLNUQxJKqmf/ictX467PKL2SKv6U6mW4GJxY26xALWeUVFOe
VC0mShEzS6oKkir0pOps6Lhq62w8cAmbkda4IQrXEjO9f/UmnBfzc2//d6G4
i7O27X9u44vd/u/AlElxpipYiGznkn+4zdex7CRJtXAtyXXS2hAuCHgO0C28
mCg9EptU2TyrL0oZqlmmn6ke2/o/UiVXiGznkI94OHT3P3DCljC9KGNaLel1
0hqQLwh2tQoRXkqUIksk6VlFUcpWzVL8RpUsp/L3q9e9bqZFCihcIeEWpTJo
0uLDkuqLn7Frc6ZFCihcIeEWpTJo0uLDkmpCL9MiheAbVYJo8qwmLT4sqSb0
Mi1SWFLFMS1SWFJN6GVapLCkimNapOiXVCMeqipzWTS5WJMWHw6NpEWqy1wN
TZ7VpMUHGqXe0EX/nEqZy6LJxZq0+Hipkf7PqZS5Gpo8q0mLDyBKe4buM7e3
t77/OrtCZKYlTL6OaRpxzLMeW9SVZWthqmaZO0prfMtyjoXITEuArB2lkurF
epaneGMn/H7xka9UYwL2JnJuY0EtbB1zh6t5tqsLaFaiFrZqluJnqudYM8e0
BMjaUepM9cI9m7vOWCf8fglTSFIdjUbOdsFw3Ww2Dw8PwWO4MS0B8nVM1ohj
nu3sApoVqIUnqTJEaU21LNvttt0uuLFaLBar1Sp8ECemJUC+jskaccyzXZME
zUrUwlPNkiFKa6oEPp/P2+2Chcim02nntJ2YlgD5OiZrxDHPOqEq3nhGn7gw
gQVhiNIm4/HY0SpUiKxy0/39PTZxB6bFS56OPTXimGebEBZvFNfCUM2SLUpr
lssl24lxJ5V254YCxLQw01MjTlGrocmzmrT4YIvSJovFgnlEH/1nYlo44Zxh
OauhybOatPgof4aGYRiGYRiGEcsf51k+nA==
    "], {{0, 42}, {455, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{455, 42},
  PlotRange->{{0, 455}, {0, 42}}]], "Output",
 ImageSize->{459, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146030642]
}, Open  ]],

Cell["Note that the Cartan matrix of SU(3) is", "ExampleText",
 CellID->681777881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SU3", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->546007265],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", 
      RowBox[{"-", "1"}]},
     {
      RowBox[{"-", "1"}], "2"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{62, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->626193029]
}, Open  ]],

Cell["\<\
We can then check that the Chevalley-Serre relations are obeyed:\
\>", "ExampleText",
 CellID->300819889],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"E1", ".", "F1"}], "-", 
   RowBox[{"F1", ".", "E1"}]}], "\[Equal]", "H1"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"E1", ".", "F2"}], "-", 
   RowBox[{"F2", ".", "E1"}]}], "\[Equal]", 
  RowBox[{"0", " ", "H1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"E2", ".", "F2"}], "-", 
    RowBox[{"F2", ".", "E2"}]}], "\[Equal]", "H2"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H1", ".", "E1"}], "-", 
   RowBox[{"E1", ".", "H1"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"SU3", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "E1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H1", ".", "E2"}], "-", 
   RowBox[{"E2", ".", "H1"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"SU3", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "1"}], "]"}], "]"}], "E2"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H2", ".", "E1"}], "-", 
   RowBox[{"E1", ".", "H2"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"SU3", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "E1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"H2", ".", "E2"}], "-", 
    RowBox[{"E2", ".", "H2"}]}], "\[Equal]", 
   RowBox[{
    RowBox[{"SU3", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "2"}], "]"}], "]"}], "E2"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H1", ".", "F1"}], "-", 
   RowBox[{"F1", ".", "H1"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"SU3", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1"}], "]"}], "]"}]}], 
   "F1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H1", ".", "F2"}], "-", 
   RowBox[{"F2", ".", "H1"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"SU3", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "1"}], "]"}], "]"}]}], 
   "F2"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H2", ".", "F1"}], "-", 
   RowBox[{"F1", ".", "H2"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"SU3", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], 
   "F1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"H2", ".", "F2"}], "-", 
    RowBox[{"F2", ".", "H2"}]}], "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"SU3", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "F2"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H1", ".", "H2"}], "-", 
   RowBox[{"H2", ".", "H1"}]}], "\[Equal]", 
  RowBox[{"0", "H1"}]}], "\[IndentingNewLine]"}], "Input",
 CellLabel->"In[3]:=",
 CellID->271990732],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->909443065],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->128003131],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->86554699],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->370622069],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->119795156],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->89086490],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->292384091],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1460144],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->403373367],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->150848433],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->319576349],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8444093]
}, Open  ]],

Cell["The two missing SU(3) generators can be built as follows:", \
"ExampleText",
 CellID->115306888],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"E12", "=", 
   RowBox[{
    RowBox[{"E1", ".", "E2"}], "-", 
    RowBox[{"E2", ".", "E1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"F12", "=", 
    RowBox[{
     RowBox[{"F1", ".", "F2"}], "-", 
     RowBox[{"F2", ".", "F1"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<The following matrices form a basis of the SU(3) algebra:\>\"", "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MatrixForm", "/@", 
   RowBox[{"{", 
    RowBox[{
    "E1", ",", "E2", ",", "E12", ",", "F1", ",", "F2", ",", "F12", ",", "H1", 
     ",", "H2"}], "}"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<The Gell-Mann matrices:\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"E1", "+", "F1"}], ",", 
    RowBox[{"\[ImaginaryI]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "E1"}], "+", "F1"}], ")"}]}], ",", "H1", ",", 
    RowBox[{"E12", "-", "F12"}], ",", 
    RowBox[{"\[ImaginaryI]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "E12"}], "-", "F12"}], ")"}]}], ",", 
    RowBox[{"E2", "+", "F2"}], ",", 
    RowBox[{"\[ImaginaryI]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "E2"}], "+", "F2"}], ")"}]}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       SqrtBox["3"]], "H1"}], "+", 
     RowBox[{
      FractionBox["2", 
       SqrtBox["3"]], "H2"}]}]}], "}"}]}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->334918258],

Cell[BoxData["\<\"The following matrices form a basis of the SU(3) algebra:\"\
\>"], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->37845453],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnT9y4zYUhz1JilwjbY7gVMkRNhfw7syqjWeTmXgrlyqlTqVLl+6sUqVK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    "], {{0, 42}, {571, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{571, 42},
  PlotRange->{{0, 571}, {0, 42}}]], "Output",
 ImageSize->{575, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->18019207],

Cell[BoxData["\<\"The Gell-Mann matrices:\"\>"], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->24353159],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnb1y4zgWhb0/wb7GvsZkO48w+wDbM1XjUjau2a1aT+Swgw3srEOHCpmp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    "], {{0, 139}, {351, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{351, 139},
  PlotRange->{{0, 351}, {0, 139}}]], "Output",
 ImageSize->{355, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->50111683]
}, Open  ]],

Cell["\<\
Instead of the fundamental representation ({1,0}) one could have used some \
other one. For example:\
\>", "ExampleText",
 CellID->200171223],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"E1", ",", "F1", ",", "H1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"E2", ",", "F2", ",", "H2"}], "}"}]}], "}"}], " ", "=", " ", 
   RowBox[{"RepMinimalMatrices", "[", 
    RowBox[{"SU3", ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{"MatrixForm", " ", ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"E1", ",", "F1", ",", "H1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"E2", ",", "F2", ",", "H2"}], "}"}]}], "}"}], ",", " ", 
    RowBox[{"{", "2", "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"E1", ".", "F1"}], "-", 
   RowBox[{"F1", ".", "E1"}]}], "\[Equal]", "H1"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"E1", ".", "F2"}], "-", 
   RowBox[{"F2", ".", "E1"}]}], "\[Equal]", 
  RowBox[{"0", " ", "H1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"E2", ".", "F2"}], "-", 
    RowBox[{"F2", ".", "E2"}]}], "\[Equal]", "H2"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H1", ".", "E1"}], "-", 
   RowBox[{"E1", ".", "H1"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"SU3", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "E1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H1", ".", "E2"}], "-", 
   RowBox[{"E2", ".", "H1"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"SU3", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "1"}], "]"}], "]"}], "E2"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H2", ".", "E1"}], "-", 
   RowBox[{"E1", ".", "H2"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"SU3", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "E1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"H2", ".", "E2"}], "-", 
    RowBox[{"E2", ".", "H2"}]}], "\[Equal]", 
   RowBox[{
    RowBox[{"SU3", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "2"}], "]"}], "]"}], "E2"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H1", ".", "F1"}], "-", 
   RowBox[{"F1", ".", "H1"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"SU3", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1"}], "]"}], "]"}]}], 
   "F1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H1", ".", "F2"}], "-", 
   RowBox[{"F2", ".", "H1"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"SU3", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "1"}], "]"}], "]"}]}], 
   "F2"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H2", ".", "F1"}], "-", 
   RowBox[{"F1", ".", "H2"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"SU3", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], 
   "F1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"H2", ".", "F2"}], "-", 
    RowBox[{"F2", ".", "H2"}]}], "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"SU3", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "F2"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H1", ".", "H2"}], "-", 
   RowBox[{"H2", ".", "H1"}]}], "\[Equal]", 
  RowBox[{"0", "H1"}]}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->159492392],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          SqrtBox["2"], "0", "0", "0", "0"},
         {"0", "0", "0", 
          SqrtBox["2"], "0", "0"},
         {"0", "0", "0", "0", "1", "0"},
         {"0", "0", "0", "0", "0", "0"},
         {"0", "0", "0", "0", "0", "0"},
         {"0", "0", "0", "0", "0", "0"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[
       SparseArray[
        Automatic, {6, 6}, 0, {
         1, {{0, 1, 2, 3, 3, 3, 3}, {{2}, {4}, {5}}}, {
          2^Rational[1, 2], 2^Rational[1, 2], 1}}]]]], ",", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", "0", "0", "0", "0", "0"},
         {
          SqrtBox["2"], "0", "0", "0", "0", "0"},
         {"0", "0", "0", "0", "0", "0"},
         {"0", 
          SqrtBox["2"], "0", "0", "0", "0"},
         {"0", "0", "1", "0", "0", "0"},
         {"0", "0", "0", "0", "0", "0"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[
       SparseArray[
        Automatic, {6, 6}, 0, {
         1, {{0, 0, 1, 1, 2, 3, 3}, {{1}, {2}, {3}}}, {
          2^Rational[1, 2], 2^Rational[1, 2], 1}}]]]], ",", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"2", "0", "0", "0", "0", "0"},
         {"0", "0", "0", "0", "0", "0"},
         {"0", "0", "1", "0", "0", "0"},
         {"0", "0", "0", 
          RowBox[{"-", "2"}], "0", "0"},
         {"0", "0", "0", "0", 
          RowBox[{"-", "1"}], "0"},
         {"0", "0", "0", "0", "0", "0"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[
       SparseArray[
        Automatic, {6, 6}, 0, {
         1, {{0, 1, 1, 2, 3, 4, 4}, {{1}, {3}, {4}, {5}}}, {2, 
          1, -2, -1}}]]]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", "0", "0", "0", "0", "0"},
         {"0", "0", "1", "0", "0", "0"},
         {"0", "0", "0", "0", "0", "0"},
         {"0", "0", "0", "0", 
          SqrtBox["2"], "0"},
         {"0", "0", "0", "0", "0", 
          SqrtBox["2"]},
         {"0", "0", "0", "0", "0", "0"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[
       SparseArray[
        Automatic, {6, 6}, 0, {
         1, {{0, 0, 1, 1, 2, 3, 3}, {{3}, {5}, {6}}}, {
          1, 2^Rational[1, 2], 2^Rational[1, 2]}}]]]], ",", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", "0", "0", "0", "0", "0"},
         {"0", "0", "0", "0", "0", "0"},
         {"0", "1", "0", "0", "0", "0"},
         {"0", "0", "0", "0", "0", "0"},
         {"0", "0", "0", 
          SqrtBox["2"], "0", "0"},
         {"0", "0", "0", "0", 
          SqrtBox["2"], "0"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[
       SparseArray[
        Automatic, {6, 6}, 0, {
         1, {{0, 0, 0, 1, 1, 2, 3}, {{2}, {4}, {5}}}, {
          1, 2^Rational[1, 2], 2^Rational[1, 2]}}]]]], ",", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", "0", "0", "0", "0", "0"},
         {"0", "1", "0", "0", "0", "0"},
         {"0", "0", 
          RowBox[{"-", "1"}], "0", "0", "0"},
         {"0", "0", "0", "2", "0", "0"},
         {"0", "0", "0", "0", "0", "0"},
         {"0", "0", "0", "0", "0", 
          RowBox[{"-", "2"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[
       SparseArray[
        Automatic, {6, 6}, 0, {
         1, {{0, 0, 1, 2, 3, 3, 4}, {{2}, {3}, {4}, {6}}}, {1, -1, 
          2, -2}}]]]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{445, 200},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->68352478],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->249334717],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->280321605],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->313005577],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->479300385],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->909243672],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->80294449],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->373860011],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->193201011],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->652835830],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->164740903],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->218981361],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->665861113]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["RepMatrices",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/RepMatrices"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"]
}], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 729},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RepMinimalMatrices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2014, 7, 24, 0, 39, 31.7314264}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "RepMinimalMatrices[group, rep] Returns the matrices of a representation \
rep of group RepMinimalMatrices[{group1, group2, ...}, {rep_group1, \
rep_group2, ...}] Returns the matrices of representation rep_group1 of \
group1, rep_group2 of group2, ...", "synonyms" -> {}, "title" -> 
    "RepMinimalMatrices", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/RepMinimalMatrices"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "9.0 for Microsoft Windows (64-bit) (January 25, 2013)", 
  StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "10.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion.nb", CharacterEncoding -> "WindowsANSI"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10020, 340, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->127688078]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 50005, 1558}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[611, 21, 76, 1, 70, "SymbolColorBar"],
Cell[690, 24, 178, 5, 70, "LinkTrail"],
Cell[871, 31, 2338, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[3212, 86, 61, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[CellGroupData[{
Cell[3298, 91, 1180, 35, 70, "Usage",
 CellID->982511436],
Cell[CellGroupData[{
Cell[4503, 130, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->451502098],
Cell[5086, 149, 249, 9, 70, "Notes",
 CellID->1067943069],
Cell[5338, 160, 181, 5, 70, "Notes",
 CellID->41030773],
Cell[5522, 167, 589, 21, 70, "Notes",
 CellID->812326107],
Cell[6114, 190, 2081, 80, 70, "Notes",
 CellID->29855657],
Cell[8198, 272, 1184, 44, 70, "Notes",
 CellID->220613822],
Cell[9385, 318, 156, 4, 70, "Notes",
 CellID->18412127],
Cell[9544, 324, 427, 10, 70, "Notes",
 CellID->28371261]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10020, 340, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->127688078],
Cell[CellGroupData[{
Cell[10506, 357, 148, 5, 70, "ExampleSection",
 CellID->801757193],
Cell[10657, 364, 90, 1, 70, "ExampleText",
 CellID->513681956],
Cell[CellGroupData[{
Cell[10772, 369, 195, 6, 70, "Input",
 CellID->196926373],
Cell[10970, 377, 1306, 44, 36, "Output",
 CellID->626877149]
}, Open  ]],
Cell[12291, 424, 118, 3, 70, "ExampleText",
 CellID->349147845],
Cell[CellGroupData[{
Cell[12434, 431, 240, 6, 70, "Input",
 CellID->4735082],
Cell[12677, 439, 743, 27, 36, "Output",
 CellID->9615607],
Cell[13423, 468, 2288, 65, 49, "Output",
 CellID->809630235]
}, Open  ]],
Cell[15726, 536, 183, 4, 70, "ExampleText",
 CellID->106768249],
Cell[CellGroupData[{
Cell[15934, 544, 125, 3, 70, "ExampleDelimiter",
 CellID->957507525],
Cell[16062, 549, 89, 1, 70, "ExampleText",
 CellID->692636],
Cell[CellGroupData[{
Cell[16176, 554, 172, 5, 45, "Input",
 CellID->101142205],
Cell[16351, 561, 2537, 49, 63, "Output",
 CellID->146030642]
}, Open  ]],
Cell[18903, 613, 82, 1, 70, "ExampleText",
 CellID->681777881],
Cell[CellGroupData[{
Cell[19010, 618, 104, 3, 70, "Input",
 CellID->546007265],
Cell[19117, 623, 771, 24, 63, "Output",
 CellID->626193029]
}, Open  ]],
Cell[19903, 650, 115, 3, 70, "ExampleText",
 CellID->300819889],
Cell[CellGroupData[{
Cell[20043, 657, 2739, 97, 70, "Input",
 CellID->271990732],
Cell[22785, 756, 161, 5, 36, "Output",
 CellID->909443065],
Cell[22949, 763, 161, 5, 36, "Output",
 CellID->128003131],
Cell[23113, 770, 160, 5, 36, "Output",
 CellID->86554699],
Cell[23276, 777, 161, 5, 36, "Output",
 CellID->370622069],
Cell[23440, 784, 161, 5, 36, "Output",
 CellID->119795156],
Cell[23604, 791, 160, 5, 36, "Output",
 CellID->89086490],
Cell[23767, 798, 161, 5, 36, "Output",
 CellID->292384091],
Cell[23931, 805, 159, 5, 36, "Output",
 CellID->1460144],
Cell[24093, 812, 161, 5, 36, "Output",
 CellID->403373367],
Cell[24257, 819, 161, 5, 36, "Output",
 CellID->150848433],
Cell[24421, 826, 161, 5, 36, "Output",
 CellID->319576349],
Cell[24585, 833, 159, 5, 36, "Output",
 CellID->8444093]
}, Open  ]],
Cell[24759, 841, 102, 2, 70, "ExampleText",
 CellID->115306888],
Cell[CellGroupData[{
Cell[24886, 847, 1606, 53, 70, "Input",
 CellID->334918258],
Cell[26495, 902, 157, 3, 23, "Print",
 CellID->37845453],
Cell[26655, 907, 2687, 52, 59, "Output",
 CellID->18019207],
Cell[29345, 961, 121, 2, 23, "Print",
 CellID->24353159],
Cell[29469, 965, 4720, 85, 160, "Output",
 CellID->50111683]
}, Open  ]],
Cell[34204, 1053, 151, 4, 70, "ExampleText",
 CellID->200171223],
Cell[CellGroupData[{
Cell[34380, 1061, 3455, 120, 70, "Input",
 CellID->159492392],
Cell[37838, 1183, 6414, 173, 221, "Output",
 CellID->68352478],
Cell[44255, 1358, 161, 5, 36, "Output",
 CellID->249334717],
Cell[44419, 1365, 161, 5, 36, "Output",
 CellID->280321605],
Cell[44583, 1372, 161, 5, 36, "Output",
 CellID->313005577],
Cell[44747, 1379, 161, 5, 36, "Output",
 CellID->479300385],
Cell[44911, 1386, 161, 5, 36, "Output",
 CellID->909243672],
Cell[45075, 1393, 160, 5, 36, "Output",
 CellID->80294449],
Cell[45238, 1400, 161, 5, 36, "Output",
 CellID->373860011],
Cell[45402, 1407, 161, 5, 36, "Output",
 CellID->193201011],
Cell[45566, 1414, 161, 5, 36, "Output",
 CellID->652835830],
Cell[45730, 1421, 161, 5, 36, "Output",
 CellID->164740903],
Cell[45894, 1428, 161, 5, 36, "Output",
 CellID->218981361],
Cell[46058, 1435, 161, 5, 36, "Output",
 CellID->665861113]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46292, 1448, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[46714, 1462, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[46902, 1470, 427, 12, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[47332, 1484, 907, 30, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[48254, 1517, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

