(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     13548,        444]
NotebookOptionsPosition[     10601,        353]
NotebookOutlinePosition[     12331,        400]
CellTagsIndexPosition[     12246,        395]
WindowTitle->RPVMSSM - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/Weights\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/Weights"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/Weights.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", "Susyno/ref/Weights",
              ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["RPVMSSM", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["RPVMSSM"], "InlineFormula"],
     " \[LineSeparator]Variable with all the data of the R-parity violating \
MSSM"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->39190707],

Cell[TextData[{
 Cell[BoxData["RPVMSSM"], "InlineFormula"],
 "  is ready to be used with ",
 ButtonBox["GenerateModel",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/GenerateModel"],
 "."
}], "Notes",
 CellID->1067943069]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->33049931],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->78414027],

Cell[TextData[{
 Cell[BoxData["RPVMSSM"], "InlineFormula"],
 " is defined as having the following gauge group, representations, field \
names, number of flavors, and discrete symmetry:"
}], "Notes",
 CellID->315923061],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"group", "[", "RPVMSSM", "]"}], "^=", 
    RowBox[{"{", 
     RowBox[{"U1", ",", "SU2", ",", "SU3"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"normalization", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"3", "/", "5"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "/", "3"}], " ", "normalization"}], ",", 
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "/", "3"}], " ", "normalization"}], ",", 
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "/", "6"}], " ", "normalization"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"{", 
    RowBox[{"normalization", ",", 
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], " ", "normalization"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hu", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "/", "2"}], " ", "normalization"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Hd", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], " ", "normalization"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"reps", "[", "RPVMSSM", "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{
    "u", ",", "d", ",", "Q", ",", "e", ",", "L", ",", "Hu", ",", "Hd"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fieldNames", "[", "RPVMSSM", "]"}], "^=", 
    RowBox[{"{", 
     RowBox[{
     "\"\<u\>\"", ",", "\"\<d\>\"", ",", "\"\<Q\>\"", ",", "\"\<e\>\"", ",", 
      "\"\<L\>\"", ",", "\"\<Hu\>\"", ",", "\"\<Hd\>\""}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nFlavs", "[", "RPVMSSM", "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "1", ",", "1"}],
     "}"}]}], ";", 
  RowBox[{
   RowBox[{"discreteSym", "[", "RPVMSSM", "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}],
     "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->295978785],

Cell["Compute the RGEs of this model:", "Notes",
 CellID->215478229],

Cell[BoxData[
 RowBox[{"GenerateModel", "[", "RPVMSSM", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->762564837]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GenerateModel",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/GenerateModel"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["MSSM",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/MSSM"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["NMSSM",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/NMSSM"]], "InlineFormula"]
}], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 729},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RPVMSSM - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2014, 7, 24, 0, 39, 36.1143527}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "RPVMSSM Variable with all the data of the R-parity violating MSSM", 
    "synonyms" -> {}, "title" -> "RPVMSSM", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/Weights"}, "LinkTrails" -> "", "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "9.0 for Microsoft Windows (64-bit) (January 25, 2013)", 
  StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "10.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion.nb", CharacterEncoding -> "WindowsANSI"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4476, 139, 460, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->33049931]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12104, 388}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[600, 21, 76, 1, 70, "SymbolColorBar"],
Cell[679, 24, 178, 5, 70, "LinkTrail"],
Cell[860, 31, 2293, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[3156, 86, 50, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[CellGroupData[{
Cell[3231, 91, 360, 11, 70, "Usage",
 CellID->982511436],
Cell[CellGroupData[{
Cell[3616, 106, 579, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->39190707],
Cell[4198, 125, 229, 8, 70, "Notes",
 CellID->1067943069]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4476, 139, 460, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->33049931],
Cell[CellGroupData[{
Cell[4961, 156, 147, 5, 70, "ExampleSection",
 CellID->78414027],
Cell[5111, 163, 218, 5, 70, "Notes",
 CellID->315923061],
Cell[5332, 170, 3282, 106, 70, "Input",
 CellID->295978785],
Cell[8617, 278, 68, 1, 70, "Notes",
 CellID->215478229],
Cell[8688, 281, 115, 3, 70, "Input",
 CellID->762564837]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8852, 290, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[9274, 304, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[9462, 312, 427, 12, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[9892, 326, 667, 22, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[10574, 351, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

