(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12640,        421]
NotebookOptionsPosition[      9655,        324]
NotebookOutlinePosition[     11205,        369]
CellTagsIndexPosition[     11120,        364]
WindowTitle->SnClassOrder - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/SnClassOrder\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/SnClassOrder"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
SnClassOrder.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/SnClassOrder", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["SnClassOrder", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SnClassOrder", "[", 
       RowBox[{"conjugacy", " ", "class"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]Calculates the order/size of a conjugacy class of ",
     Cell[BoxData[
      SubscriptBox["S", "n"]], "InlineFormula"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->358032673],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"conjugacy", " ", "class"}]], "InlineFormula"],
 " must be a partition of some integer n."
}], "Notes",
 CellID->613073599],

Cell[TextData[{
 "Recall that each conjugacy class of ",
 Cell[BoxData[
  SubscriptBox["S", "n"]], "InlineFormula"],
 " is specified by its cycle structure \
(\[CenterEllipsis])(\[CenterEllipsis])(\[CenterEllipsis])\[CenterEllipsis]"
}], "Notes",
 CellID->106345268],

Cell[TextData[{
 "Denoting each cycle's length by ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", "1"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", "2"]], "InlineFormula"],
 ", ... with ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", "1"]], "InlineFormula"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", "2"]], "InlineFormula"],
 " \[GreaterEqual] \[CenterEllipsis], then each conjugacy class is given by \
the partition {",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", "1"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", "2"]], "InlineFormula"],
 ", \[CenterEllipsis]} of n, with ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", "1"]], "InlineFormula"],
 "+",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", "2"]], "InlineFormula"],
 "+\[CenterEllipsis]=n."
}], "Notes",
 CellID->235158835]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->105550209],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->29198190],

Cell[TextData[{
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula"],
 " has 6 elements, distributed in 3 conjugacy classes\[LongDash]class1: \
{(1)(2)(3)}; class2: {(12)(3),(13)(2),(23)(1)}; class3: {(123),(132)}. Their \
sizes could have been calculated as follows:"
}], "ExampleText",
 CellID->32979335],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SnClassOrder", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SnClassOrder", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SnClassOrder", "[", 
  RowBox[{"{", "3", "}"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->298933796],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21711148],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->922383539],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110478182]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[StyleBox[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"],
 FontFamily->"Verdana"]], "Tutorials",
 CellID->26828648]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HookContentFormula",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/HookContentFormula"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["DecomposeSnProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/DecomposeSnProduct"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["SnClassCharacter",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/SnClassCharacter"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["SnIrrepDim",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/SnIrrepDim"]], "InlineFormula"],
 " "
}], "RelatedLinks",
 CellID->461483061]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SnClassOrder - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2013, 8, 7, 2, 29, 17.1406250}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "SnClassOrder[conjugacy class] Calculates the order/size of a conjugacy \
class of S_n", "synonyms" -> {}, "title" -> "SnClassOrder", "type" -> 
    "Symbol", "uri" -> "Susyno/ref/SnClassOrder"}, "SearchTextTranslated" -> 
  ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5684, 178, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->105550209]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10977, 357}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[593, 21, 76, 1, 70, "SymbolColorBar"],
Cell[672, 24, 178, 5, 70, "LinkTrail"],
Cell[853, 31, 2314, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3192, 88, 55, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[3250, 91, 496, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3783, 110, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->358032673],
Cell[4366, 129, 164, 5, 70, "Notes",
 CellID->613073599],
Cell[4533, 136, 266, 7, 70, "Notes",
 CellID->106345268],
Cell[4802, 145, 845, 28, 70, "Notes",
 CellID->235158835]
}, Closed]],
Cell[CellGroupData[{
Cell[5684, 178, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->105550209],
Cell[CellGroupData[{
Cell[6170, 195, 147, 5, 70, "ExampleSection",
 CellID->29198190],
Cell[6320, 202, 312, 7, 70, "ExampleText",
 CellID->32979335],
Cell[CellGroupData[{
Cell[6657, 213, 369, 10, 70, "Input",
 CellID->298933796],
Cell[7029, 225, 157, 5, 36, "Output",
 CellID->21711148],
Cell[7189, 232, 158, 5, 36, "Output",
 CellID->922383539],
Cell[7350, 239, 158, 5, 36, "Output",
 CellID->110478182]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7569, 251, 417, 12, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7989, 265, 184, 4, 70, "Tutorials",
 CellID->26828648]
}, Open  ]],
Cell[CellGroupData[{
Cell[8210, 274, 419, 12, 70, "MoreAboutSection",
 CellID->38303248],
Cell[8632, 288, 981, 31, 70, "RelatedLinks",
 CellID->461483061]
}, Open  ]],
Cell[9628, 322, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

