(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21363,        696]
NotebookOptionsPosition[     17310,        567]
NotebookOutlinePosition[     19064,        614]
CellTagsIndexPosition[     18979,        609]
WindowTitle->Plethysms - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {
       RowBox[{
        RowBox[{"{", "}"}], "\[LeftDoubleBracket]", "1", 
        "\[RightDoubleBracket]"}]:>Documentation`HelpLookup[
        If[
         StringMatchQ[
          Part[{}, 2], "paclet*"], 
         Part[
          Part[{{}, {"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE", 
             StringReplace[{
               URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None}, 
              "paclet:" :> ""]}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{}, {"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE", 
              StringReplace[{
                URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None},
                "paclet:" :> ""]}}, 1], 
           2]]]], "\<\"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE\"\>":>
       Documentation`HelpLookup[
        If[
         StringMatchQ[
          StringReplace[{
            URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None}, 
           "paclet:" :> ""], "paclet*"], 
         Part[
          Part[{{}, {"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE", 
             StringReplace[{
               URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None}, 
              "paclet:" :> ""]}}, 2], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{}, {"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE", 
              StringReplace[{
                URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None},
                "paclet:" :> ""]}}, 2], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/Plethysms\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/Plethysms"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
Plethysms.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]},
             Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/Plethysms", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["Plethysms", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Plethysms", "[", 
       RowBox[{
        RowBox[{"gauge", " ", "group"}], ",", " ", 
        RowBox[{
        "representation", " ", "of", " ", "the", " ", "gauge", " ", "group"}],
         ",", " ", 
        RowBox[{"partition", " ", "of", " ", "n"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]Computes the break down of product of ",
     Cell[BoxData["n"], "InlineFormula"],
     " copies of the given representation of the gauge group in irreducible \
parts, which transform according to a given representation of the ",
     Cell[BoxData[
      SubscriptBox["S", "n"]], "InlineFormula"],
     " group under permutations of the fields"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->252152162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"gauge", " ", "group"}]], "InlineFormula"],
 " should be a ",
 ButtonBox["Cartan matrix.",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"]
}], "Notes",
 CellID->149353492],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
  "representation", " ", "of", " ", "the", " ", "gauge", " ", "group"}]], 
  "InlineFormula"],
 " should be a list of non-negative integers (Dynkin coefficients)."
}], "Notes",
 CellID->190293714],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  SuperscriptBox["\[Phi]", "i"]], "InlineFormula"],
 " are some fields transforming according to some representation of a simple \
gauge group G, the product  ",
 Cell[BoxData[
  SuperscriptBox["\[Phi]", "1"]], "InlineFormula"],
 "\[Times] ",
 Cell[BoxData[
  SuperscriptBox["\[Phi]", "2"]], "InlineFormula"],
 "\[Times]\[CenterEllipsis]\[Times]",
 Cell[BoxData[
  SuperscriptBox["\[Phi]", "n"]], "InlineFormula"],
 " can be broken down into irreducible representations of the group ",
 Cell[BoxData[
  RowBox[{"G", "\[Times]", 
   SubscriptBox["S", "n"]}]], "InlineFormula"],
 " (plethysms)."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "This function returns a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"gauge", " ", "rep1"}], ",", "multiplicity1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"gauge", " ", "rep2"}], ",", "multiplicity2"}], "}"}], ",", " ",
     "..."}], "}"}]], "InlineFormula"],
 " containing the gauge representations (with multiplicity) which are in the \
product of n copies of the given representation of the gauge group, and which \
transform according to a given representation of the ",
 Cell[BoxData[
  SubscriptBox["S", "n"]], "InlineFormula"],
 " group when permutations are performed on the representations being \
multiplied."
}], "Notes",
 CellID->175832127],

Cell[TextData[{
 Cell[BoxData["Plethysms"], "InlineFormula"],
 " follows the algorithm ",
 "described in",
 " ",
 StyleBox["M. A. A. van Leeuwen, A. M. Cohen, and B. Lisser, LiE, A Package \
for Lie Group Computations. Computer Algebra Nederland, 1992",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->784476774]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->553336640],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->452535547],

Cell[TextData[{
 "Two SU(2) doublets (={1}) form a singlet {0} and a triplet {2}. The singlet \
is known to be an antisymmetric combination of the two doublets ({1,1} \
representation of ",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula"],
 ") and the triplet is a symmetric one ({2} representation of ",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula"],
 "):"
}], "ExampleText",
 CellID->32979335],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plethysms", "[", 
  RowBox[{"SU2", ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plethysms", "[", 
   RowBox[{"SU2", ",", 
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "  "}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->651302308],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "0", "}"}], ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66000198],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "2", "}"}], ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238130079]
}, Open  ]],

Cell["\<\
Consider now three SU(3) fundamental representations {1,0}. Their product \
breaks into 1 {3,0} representation, plus 2 {1,1} representations plus 1 {0,0} \
representation:\
\>", "ExampleText",
 CellID->373992796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90866564],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{253, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->128899912]
}, Open  ]],

Cell[TextData[{
 "However, ReduceRepProduct does not return information on how these \
irreducible representations of the gauge group change under a permutation of \
the three fundamental representations of SU(3). In other words, it does not \
tell what are the ",
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula"],
 " irreducible representations that {3,0}+{1,1}+{1,1}+{0,0} are in. This can \
be found with the Plethysms function: the representation {3,0} is completely \
symmetric (irrep {3} of ",
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula"],
 ") under a permutation of the triplets being multiplied, {0,0} is completely \
antisymmetric (irrep {1,1,1} of ",
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula"],
 ") and the two {1,1}'s are of mixed symmetry (they are in a 2-dimensional \
{2,1} irrep of ",
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula"],
 ")."
}], "ExampleText",
 CellID->40383509],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plethysms", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plethysms", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plethysms", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->46820094],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "0"}], "}"}], ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->458094910],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->48732998],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->211410920]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell["\<\
M. A. A. van Leeuwen, A. M. Cohen, and B. Lisser, LiE, A Package for Lie \
Group Computations. Computer Algebra Nederland, 1992\
\>", "MoreAbout",
 CellID->1665078683],

Cell[TextData[{
 "M. A. A. van Leeuwen, A. M. Cohen, and B. Lisser, \
\[OpenCurlyDoubleQuote]LiE - A Computer algebra package for Lie group \
computations.\[CloseCurlyDoubleQuote] ",
 ButtonBox["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None},
  ButtonNote->"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"],
 ", 2012. Retrieved March 17, 2013."
}], "MoreAbout",
 CellID->867725]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InvariantPlethysms",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/InvariantPlethysms"]], "InlineFormula"],
 " ",
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["PermutationSymmetryOfTensorProductParts",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/PermutationSymmetryOfTensorProductParts"]], 
  "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["PermutationSymmetryOfInvariants",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/PermutationSymmetryOfInvariants"]], 
  "InlineFormula"]
}], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Plethysms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2013, 8, 7, 2, 28, 0.6406250}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "Plethysms[gauge group, representation of the gauge group, partition of \
n] Computes the break down of product of n copies of the given representation \
of the gauge group in irreducible parts, which transform according to a given \
representation of the S_n group under permutations of the fields", 
    "synonyms" -> {}, "title" -> "Plethysms", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/Plethysms"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8676, 256, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->553336640]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18836, 602}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[590, 21, 76, 1, 70, "SymbolColorBar"],
Cell[669, 24, 178, 5, 70, "LinkTrail"],
Cell[850, 31, 3965, 93, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4840, 128, 52, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[4895, 131, 912, 23, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5844, 159, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->252152162],
Cell[6427, 178, 233, 8, 70, "Notes",
 CellID->149353492],
Cell[6663, 188, 238, 7, 70, "Notes",
 CellID->190293714],
Cell[6904, 197, 666, 20, 70, "Notes",
 CellID->1067943069],
Cell[7573, 219, 748, 20, 70, "Notes",
 CellID->175832127],
Cell[8324, 241, 315, 10, 70, "Notes",
 CellID->784476774]
}, Closed]],
Cell[CellGroupData[{
Cell[8676, 256, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->553336640],
Cell[CellGroupData[{
Cell[9162, 273, 148, 5, 70, "ExampleSection",
 CellID->452535547],
Cell[9313, 280, 418, 11, 70, "ExampleText",
 CellID->32979335],
Cell[CellGroupData[{
Cell[9756, 295, 383, 12, 70, "Input",
 CellID->651302308],
Cell[10142, 309, 251, 9, 36, "Output",
 CellID->66000198],
Cell[10396, 320, 252, 9, 36, "Output",
 CellID->238130079]
}, Open  ]],
Cell[10663, 332, 222, 5, 70, "ExampleText",
 CellID->373992796],
Cell[CellGroupData[{
Cell[10910, 341, 354, 12, 70, "Input",
 CellID->90866564],
Cell[11267, 355, 520, 19, 36, "Output",
 CellID->128899912]
}, Open  ]],
Cell[11802, 377, 943, 22, 70, "ExampleText",
 CellID->40383509],
Cell[CellGroupData[{
Cell[12770, 403, 616, 19, 70, "Input",
 CellID->46820094],
Cell[13389, 424, 278, 10, 36, "Output",
 CellID->458094910],
Cell[13670, 436, 277, 10, 36, "Output",
 CellID->48732998],
Cell[13950, 448, 278, 10, 36, "Output",
 CellID->211410920]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14289, 465, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[14711, 479, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[14899, 487, 419, 12, 70, "MoreAboutSection",
 CellID->38303248],
Cell[15321, 501, 177, 4, 70, "MoreAbout",
 CellID->1665078683],
Cell[15501, 507, 489, 11, 70, "MoreAbout",
 CellID->867725]
}, Open  ]],
Cell[CellGroupData[{
Cell[16027, 523, 427, 12, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[16457, 537, 811, 25, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[17283, 565, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

