(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19222,        619]
NotebookOptionsPosition[     15664,        505]
NotebookOutlinePosition[     17322,        551]
CellTagsIndexPosition[     17237,        546]
WindowTitle->IrrepInProduct - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[Cell[BoxData[
     ActionMenuBox[
      FrameBox["\<\"URL \[RightGuillemet]\"\>",
       StripOnInput->False], {"\<\"Susyno/ref/IrrepInProduct\"\>":>
      None, "\<\"Copy Mathematica url\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell["Susyno/ref/IrrepInProduct"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; Null], 
      Delimiter, "\<\"Copy web url\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell[
             BoxData[
              MakeBoxes[
               Hyperlink[
               "http://reference.wolfram.com/mathematica/Susyno/ref/\
IrrepInProduct.html"], StandardForm]], "Input", TextClipboardType -> 
             "PlainText"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; 
       Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
        NotebookLocate[{
          URL[
           StringJoin[
           "http://reference.wolfram.com/mathematica/", 
            "Susyno/ref/IrrepInProduct", ".html"]], None}]}]},
      Appearance->None,
      MenuAppearance->Automatic]],
     LineSpacing->{1.4, 0}]], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["IrrepInProduct", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"IrrepInProduct", "[", 
       RowBox[{"group", ",", " ", 
        RowBox[{"{", 
         RowBox[{"rep1", ",", " ", "rep2", ",", " ", "rep3"}], "}"}]}], 
       "]"}]], "InlineFormula"],
     " \[LineSeparator]Computes generalized Clebsch-Gordon coefficients; it \
computes the combinations of ",
     Cell[BoxData["rep1"], "InlineFormula"],
     " x ",
     Cell[BoxData["rep2"], "InlineFormula"],
     " which transform as a ",
     Cell[BoxData["rep3"], "InlineFormula"],
     " of the gauge group."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->340512485],

Cell[TextData[{
 Cell[BoxData["group"], "InlineFormula"],
 " should be the ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 " of the intended group."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Each representation ",
 Cell[BoxData["rep"], "InlineFormula"],
 " should be a list of non-negative integers (Dynkin coefficients)."
}], "Notes",
 CellID->41030773],

Cell["\<\
There is no limit to the number of representations being multiplied, although \
the calculation becomes slower as their number increases.\
\>", "Notes",
 CellID->221237370],

Cell[TextData[{
 "The optional input ",
 Cell[BoxData[
  RowBox[{"Conjugations", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"conjugate", " ", "rep1"}], ",", " ", 
     RowBox[{"conjugate", " ", "rep2"}], ",", " ", 
     RowBox[{"conjugate", " ", "rep3"}]}], "}"}]}]], "InlineFormula"],
 "  can be passed to this function, where ",
 Cell[BoxData[
  RowBox[{"conjugate", " ", "repI"}]], "InlineFormula"],
 " can be either ",
 Cell[BoxData["True"], "InlineFormula"],
 " or ",
 Cell[BoxData["False"], "InlineFormula"],
 ". If ",
 Cell[BoxData["True"], "InlineFormula"],
 ", the conjugate representation of ",
 Cell[BoxData["repI"], "InlineFormula"],
 " will be considered instead of ",
 Cell[BoxData["repI"], "InlineFormula"],
 "."
}], "Notes",
 CellID->400920173],

Cell[TextData[{
 "There is also the possibility of ",
 Cell[BoxData["group"], "InlineFormula"],
 " being a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"group1", ",", "group2", ",", "..."}], "}"}]], "InlineFormula"],
 " and each ",
 Cell[BoxData["rep"], "InlineFormula"],
 " a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"rep_group1", ",", "rep_group2", ",", "..."}], "}"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->75953507],

Cell[TextData[{
 "The output of this method is a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"combination1", ",", "combination2", ",", "..."}], "}"}]], 
  "InlineFormula"],
 " where it is assumed that ",
 Cell[BoxData["a"], "InlineFormula"],
 " is a field transforming as ",
 Cell[BoxData["rep1"], "InlineFormula"],
 ",  ",
 Cell[BoxData["b"], "InlineFormula"],
 " as ",
 Cell[BoxData["rep2"], "InlineFormula"],
 ". Each of the ",
 Cell[BoxData["combinationI"], "InlineFormula"],
 " transforms as ",
 Cell[BoxData["rep3"], "InlineFormula"],
 ". The fields  ",
 Cell[BoxData["a"], "InlineFormula"],
 "  and  ",
 Cell[BoxData["b"], "InlineFormula"],
 " have group indices: ",
 Cell[BoxData[
  RowBox[{"a", "[", 
   RowBox[{"ind_group1", ",", " ", "ind_group2", ",", "..."}], "]"}]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"b", "[", 
   RowBox[{"ind_group1", ",", " ", "ind_group2", ",", "..."}], "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->10758554],

Cell[TextData[{
 "If  ",
 Cell[BoxData["rep1"], "InlineFormula"],
 " x ",
 Cell[BoxData["rep2"], "InlineFormula"],
 " does not contain any copy of ",
 Cell[BoxData["rep3"], "InlineFormula"],
 ",  ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 " is returned."
}], "Notes",
 CellID->335181877],

Cell["\<\
Clearly this method must assume a particular basis for each representation so \
the results are basis dependent.\
\>", "Notes",
 CellID->898809850],

Cell[TextData[{
 "This method is similar to ",
 Cell[BoxData[
  ButtonBox["Invariants",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/Invariants"]], "InlineFormula"],
 ": it gives generalized Clebsch-Gordon coefficients, as it works for any \
gauge group (not just SU(2))."
}], "Notes",
 CellID->329977022]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->751929947],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->53215938],

Cell["\<\
Two SU(2) doublets (={1}) contain a singlet (={0}) and a triplet (={2}). The \
explicit form of these combinations can be checked with this method:\
\>", "Notes",
 CellID->315923061],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "\"\<Gauge singlet in {1}x{1}:\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IrrepInProduct", "[", 
    RowBox[{"SU2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "0", "}"}]}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", 
  "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<\>\"", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<Gauge triplet in {1}x{1}:\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"IrrepInProduct", "[", 
     RowBox[{"SU2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "2", "}"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "//", "MatrixForm"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\< ... or (multiply by \!\(\*SuperscriptBox[\(3\), \(1/4\)]\)) ...\>\"",
    "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{"Normal", "[", 
    RowBox[{
     SuperscriptBox["3", 
      RowBox[{"1", "/", "4"}]], 
     RowBox[{
      RowBox[{"IrrepInProduct", "[", 
       RowBox[{"SU2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "1", "}"}], ",", 
          RowBox[{"{", "1", "}"}], ",", 
          RowBox[{"{", "2", "}"}]}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}], "//", 
  "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->275367989],

Cell[BoxData["\<\"Gauge singlet in {1}x{1}:\"\>"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->51510509],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztVcEJwzAQM3SAztCVOkIW6DgZ1037KAXbRNLdxU05QSA4jnTSOZfb8rgv
l1LKdbvW7Xrd10QikUgkEj1Qf8nyRrvSXUReR8gpEg1Gac0XGFrd6xGbRquL
PAIVR/lQJBrs0rgvITRZd3QUhVLbdZzct4mUL6GJQaHJ9VAqeOXfNhFyxyay
vtjQKF/ddccmfkrqzm0jeWiSuzi1r7h62Fl9wOeAzMy5TWRDC63HOHj/bJyC
5EJoQj11fKRbUXZAgV+KQI7g1L6Q84MA3y/kHEo+UdqFXOvvaDOyH9x2JPlE
aTu5u9/EL+AJtVd6Hg==
    "], {{0, 15}, {151, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{151, 15},
  PlotRange->{{0, 151}, {0, 15}}]], "Output",
 ImageSize->{155, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->552443112],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->501595322],

Cell[BoxData["\<\"Gauge triplet in {1}x{1}:\"\>"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->75520894]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnb2u2jAUgCP1SfpKXbugO7GVka1bGRkZGRkZGRkzMvIIjIyMrhukKMT2
sZ34/Dg9n4QECTgn/uJjx9xrvn/9+vH1rWman/bxxz7+PTeKokjlfr+v1+vf
Yfb7PXeMzLxeL8pKOJ1Oz+eT7HAysRcesPd8Pj8eD6pYzPF4JDuWWOA6J84S
asR0eelwOHh33W63y+VCGYwaeWMbgvXibt/tdpRh2AugbVt3e+6AvOnwfny0
y7sltwQMQlUBdzHFsd26e2G8Tz+rEtzKDFVvypaUEopjhzfexLXZbLAPPSSU
sqI1AFzS0Zf9x+eUgIG3OaxWK9SD2kHFUPpkIwa8hlOMhJ4kloCB1whB1hom
TJu13DckNhAg7UcLhI2klICBt/Jpsta7adw63L1uhYfeEKrPaEaKOoVLQIIl
a715uyg47oVrLDcHTithPoxGTNdMyhoJVVri2HV+CfPhNWK7eOJ7H/nwGjFd
7iI7VhWwG1FGsBgBvgepAuzKcTdqG2FkGUa8AyGWO+75LMOISZg2VCPEAC3C
ncWVzH9iJDonI4d6jUye6RVOpUaGiaj5xAR0aBshAJiDIo6kIPUaqbraAeo1
YhYqpVIjtXQKE6jUyIJRI9JQI9JQI9JQI9JANRL92xvgze5Gt7Tiw62sw0UD
NpPmn7GNjJ6Hok3cgv2Vx/y5stxTdilrBLhCoi/7j88pYQEBF28jM08w9CSx
hAlIC7igEfiCyWryNEbmX+FwwCmn7IJhJBRe9PSB9zSfeEsoGHDK4eCAU07Z
C1nPnru3VAlZSAiYcvSbuKtsCVlICFjvEKWRZcSbXftyGMkKVWbA04woBHAZ
8V667mAGO4x0yAJmbCPwCWJ03DOhCViOEXfcLtwIUsBijQCdMhc0AVMagbNu
NEvTwxIwmZFhu3aHpt6z420jXAETZ61QwOzNIQR9wIxZSz4sAQtpI2KhD5iy
H6lLB1fAOosiDTUiDTUiDTUiDTUiDTUiDSFGdN34HiFGdN34HiFGdE3sHjUi
DTUiDQlGMNaNH81KuZNU3mmrrBKQkGAEY9346MuULdESMJBgRNeNH8JiRNeN
B+BqI9jrxkdfGjXigLdufPPJaG/o47klIMFoRNeN98Lbs+u68S68RnTdeBf2
0a+uGz+C3YgygsVIyn8hSQa7ctyN2+0W9aAKwDKMeAdCLPd38/EaqbEfgY2Q
jV3ns4w2Yir8j60QXiM13iPARqJzMkJ4PB7eWT5rxPsLyKKYPK8omev16r1B
s6aIfw08l2EicmcFvTqqaCOh32c33Q+FU0YyDWAOijiSItiGAMzytW0rfH6j
0moHsDrgzsLmNKpYJrIwKfIrHKCKTkFZHn8BRUip4g==
    "], {{0, 91}, {134, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{134, 91},
  PlotRange->{{0, 134}, {0, 91}}]], "Output",
 ImageSize->{138, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->11025396],

Cell[BoxData["\<\" ... or (multiply by \\!\\(\\*SuperscriptBox[\\(3\\), \
\\(1/4\\)]\\)) ...\"\>"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->407396728],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        SqrtBox["2"], " ", 
        RowBox[{"a", "[", "2", "]"}], " ", 
        RowBox[{"b", "[", "2", "]"}]}]},
      {
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"a", "[", "2", "]"}]}], " ", 
         RowBox[{"b", "[", "1", "]"}]}], "-", 
        RowBox[{
         RowBox[{"a", "[", "1", "]"}], " ", 
         RowBox[{"b", "[", "2", "]"}]}]}]},
      {
       RowBox[{
        SqrtBox["2"], " ", 
        RowBox[{"a", "[", "1", "]"}], " ", 
        RowBox[{"b", "[", "1", "]"}]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{163, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->114383041]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[Cell[BoxData[
 ButtonBox["Invariants",
  BaseStyle->"Link",
  ButtonData->
   "paclet:Susyno/ref/Invariants"]], "InlineFormula"]], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IrrepInProduct - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2013, 8, 7, 2, 27, 32.3750000}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "IrrepInProduct[group, {rep1, rep2, rep3}] Computes generalized \
Clebsch-Gordon coefficients; it computes the combinations of rep1 x rep2 \
which transform as a rep3 of the gauge group.", "synonyms" -> {}, "title" -> 
    "IrrepInProduct", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/IrrepInProduct"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7818, 262, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->751929947]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17094, 539}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[595, 21, 76, 1, 70, "SymbolColorBar"],
Cell[674, 24, 178, 5, 70, "LinkTrail"],
Cell[855, 31, 1867, 41, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[2747, 76, 57, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2807, 79, 764, 22, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3608, 106, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->340512485],
Cell[4191, 125, 236, 8, 70, "Notes",
 CellID->1067943069],
Cell[4430, 135, 181, 5, 70, "Notes",
 CellID->41030773],
Cell[4614, 142, 182, 4, 70, "Notes",
 CellID->221237370],
Cell[4799, 148, 767, 24, 70, "Notes",
 CellID->400920173],
Cell[5569, 174, 444, 16, 70, "Notes",
 CellID->75953507],
Cell[6016, 192, 979, 34, 70, "Notes",
 CellID->10758554],
Cell[6998, 228, 304, 12, 70, "Notes",
 CellID->335181877],
Cell[7305, 242, 157, 4, 70, "Notes",
 CellID->898809850],
Cell[7465, 248, 316, 9, 70, "Notes",
 CellID->329977022]
}, Closed]],
Cell[CellGroupData[{
Cell[7818, 262, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->751929947],
Cell[CellGroupData[{
Cell[8304, 279, 147, 5, 70, "ExampleSection",
 CellID->53215938],
Cell[8454, 286, 192, 4, 70, "Notes",
 CellID->315923061],
Cell[CellGroupData[{
Cell[8671, 294, 1717, 54, 70, "Input",
 CellID->275367989],
Cell[10391, 350, 122, 2, 23, "Print",
 CellID->51510509],
Cell[10516, 354, 825, 21, 50, "Output",
 CellID->552443112],
Cell[CellGroupData[{
Cell[11366, 379, 98, 2, 70, "Print",
 CellID->501595322],
Cell[11467, 383, 122, 2, 23, "Print",
 CellID->75520894]
}, Open  ]],
Cell[11604, 388, 1885, 38, 126, "Output",
 CellID->11025396],
Cell[13492, 428, 172, 3, 70, "Print",
 CellID->407396728],
Cell[13667, 433, 1283, 41, 87, "Output",
 CellID->114383041]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15011, 481, 427, 12, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[15441, 495, 181, 5, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[15637, 503, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

