(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* Two effects: 1)- variables X are really Susyno`LieGroups`X; When this package is read, Susyno`LieGroups` is placed in $ContextPath/$Packages so that things can be searched by the short name *)
(* This name (Susyno`LieGroups`) has no efffect on the required init.m call since this one depends on the folder/file names *)
BeginPackage["Susyno`LieGroups`"];

{a,b,c,Adjoint,CartanMatrix,Casimir,CholeskyTypeDecomposition,ConjugateIrrep,Conjugations,DimR,DominantConjugate,DominantWeights,DynkinIndex,e6,E6,e7,E7,e8,E8,f4,F4,FindM,g2,G2,Invariants,InverseFlatten,IrrepInProduct,IsSymmetric,MatrixD,NullMatrix,NullSpace2,PositiveRoots,ReduceRepProduct,ReflectWeight,RepMatrices,RepMinimalMatrices,SimpleProduct,so10,So10,SO10,so11,So11,SO11,so12,So12,SO12,so13,So13,SO13,so14,So14,SO14,so15,So15,SO15,so16,So16,SO16,so17,So17,SO17,so18,So18,SO18,so19,So19,SO19,so20,So20,SO20,so21,So21,SO21,so22,So22,SO22,so23,So23,SO23,so24,So24,SO24,so25,So25,SO25,so26,So26,SO26,so27,So27,SO27,so28,So28,SO28,so29,So29,SO29,so3,So3,SO3,so30,So30,SO30,so31,So31,SO31,so32,So32,SO32,so5,So5,SO5,so6,So6,SO6,so7,So7,SO7,so8,So8,SO8,so9,So9,SO9,sp10,Sp10,SP10,sp12,Sp12,SP12,sp14,Sp14,SP14,sp16,Sp16,SP16,sp18,Sp18,SP18,sp2,Sp2,SP2,sp20,Sp20,SP20,sp22,Sp22,SP22,sp24,Sp24,SP24,sp26,Sp26,SP26,sp28,Sp28,SP28,sp30,Sp30,SP30,sp32,Sp32,SP32,sp4,Sp4,SP4,sp6,Sp6,SP6,sp8,Sp8,SP8,SpecialMatrixD,su10,Su10,SU10,su11,Su11,SU11,su12,Su12,SU12,su13,Su13,SU13,su14,Su14,SU14,su15,Su15,SU15,su16,Su16,SU16,su17,Su17,SU17,su18,Su18,SU18,su19,Su19,SU19,su2,Su2,SU2,su20,Su20,SU20,su21,Su21,SU21,su22,Su22,SU22,su23,Su23,SU23,su24,Su24,SU24,su25,Su25,SU25,su26,Su26,SU26,su27,Su27,SU27,su28,Su28,SU28,su29,Su29,SU29,su3,Su3,SU3,su30,Su30,SU30,su31,Su31,SU31,su32,Su32,SU32,su4,Su4,SU4,su5,Su5,SU5,su6,Su6,SU6,su7,Su7,SU7,su8,Su8,SU8,su9,Su9,SU9,SpecialMatrixD,SymmetrizeInvariants,u1,U1,WeylOrbit};

(* From the anomalies addition *)
{TriangularAnomalyCheck,TriangularAnomalyValue};

(* From the RepsUpToDimN addition *)
{RepsUpToDimN,RepsUpToDimNNoConjugates,RepsUpToDimNAuxilarMethod};

(* From the plesthysm addition *)
{SnIrrepDim,DecomposeSnProduct,PartitionSequence,RimHooks,RebuiltPartitionFromSequence,SnClassCharacter,SnClassOrder,AltDom,Adams,Plethysms,InvariantPlethysms,GatherWeights,ReduceRepPolyProduct,NumberOfInvariantsInProduct};
{TuplesWithMultiplicity, TallyWithMultiplicity, PermutationSymmetryOfTensorProductPartsAuxiliar, PermutationSymmetryOfTensorProductParts, PermutationSymmetryOfInvariants,HookContentFormula};

{CMtoName};

Begin["`Private`"]


(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

CartanMatrix[name_String,numberId_Integer]:=CartanMatrix[name,numberId]=Module[{result},
result="Unknown simple lie algebra. Try SU(n) [n>1],SO(n) [n=3 or >4],Sp(2n) [n>1] or the exceptionals G(2),F(4),E(6),E(7),E(8).";

(* Classical algebras *)

If[(ToUpperCase[name]=="A"||ToUpperCase[name]=="B"||ToUpperCase[name]=="C")&&numberId==1,
result={{2}};
];
If[ToUpperCase[name]=="A"&&numberId>1,
result=SparseArray[{Band[{1,1}]->2,Band[{2,1}]->-1,Band[{1,2}]->-1},{numberId,numberId}]//Normal;
];
If[ToUpperCase[name]=="B"&&numberId>1,
result=SparseArray[{Band[{1,1}]->2,Band[{2,1}]->-1,Band[{1,2}]->-1},{numberId,numberId}]//Normal;
result[[numberId-1,numberId]]=-2;
];
If[ToUpperCase[name]=="C"&&numberId>1,
result=SparseArray[{Band[{1,1}]->2,Band[{2,1}]->-1,Band[{1,2}]->-1},{numberId,numberId}]//Normal;
result[[numberId,numberId-1]]=-2;
];
If[ToUpperCase[name]=="D"&&numberId>2,
result=SparseArray[{Band[{1,1}]->2,Band[{2,1}]->-1,Band[{1,2}]->-1},{numberId,numberId}]//Normal;
result[[numberId,numberId-1]]=0;
result[[numberId-1,numberId]]=0;
result[[numberId,numberId-2]]=-1;
result[[numberId-2,numberId]]=-1;
];

(* Classical algebras, with alternative names *)

If[ToUpperCase[name]=="SU", (*   SU(n+1)=A(n)   *)
result=CartanMatrix["A", numberId-1]];
If[ToUpperCase[name]=="SP"&&EvenQ[numberId], (*   Sp(2n)=C(n)   *)
result=CartanMatrix["C", numberId/2]];
If[ToUpperCase[name]=="SO"&&!EvenQ[numberId], (*   SO(2n+1)=B(n)   *)
result=CartanMatrix["B", (numberId-1)/2]];
If[ToUpperCase[name]=="SO"&&EvenQ[numberId], (*   SO(2n)=D(n)   *)
result=CartanMatrix["D", numberId/2]];


(* Exceptional algebras *)

If[ToUpperCase[name]=="G"&&numberId==2,
result={{2,-3},{-1,2}};
];

If[ToUpperCase[name]=="F"&&numberId==4,
result=SparseArray[{Band[{1,1}]->2,Band[{2,1}]->-1,Band[{1,2}]->-1},{4,4}]//Normal;
result[[2,3]]=-2;
];

If[ToUpperCase[name]=="E"&&(numberId==6||numberId==7||numberId==8),
result=SparseArray[{Band[{1,1}]->2,Band[{2,1}]->-1,Band[{1,2}]->-1},{numberId,numberId}]//Normal;
result[[numberId-1,numberId]]=0;result[[numberId,numberId-1]]=0;result[[3,numberId]]=-1;result[[numberId,3]]=-1;
];

Return[result];
]

(*Assign to some variables the groups' Cartan matrix*)
(*
Do[
Evaluate[ToExpression["SU"<>ToString[i]]]=Evaluate[ToExpression["Su"<>ToString[i]]]=Evaluate[ToExpression["su"<>ToString[i]]]=CartanMatrix["SU",i];
,{i,2,32}]
Do[
Evaluate[ToExpression["SO"<>ToString[i]]]=Evaluate[ToExpression["So"<>ToString[i]]]=Evaluate[ToExpression["so"<>ToString[i]]]=CartanMatrix["SO",i];
,{i,5,32}]
Do[
Evaluate[ToExpression["SP"<>ToString[i]]]=Evaluate[ToExpression["Sp"<>ToString[i]]]=Evaluate[ToExpression["sp"<>ToString[i]]]=CartanMatrix["SP",i];
,{i,2,32,2}]
SO3=So3=so3=CartanMatrix["SO",3];
*)

E6=e6=CartanMatrix["E",6];
E7=e7=CartanMatrix["E",7];
E8=e8=CartanMatrix["E",8];
G2=g2=CartanMatrix["G",2];
F4=f4=CartanMatrix["F",4];
U1=u1=CartanMatrix["U",1]=CartanMatrix["u",1]={};

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

CMtoName[cm_]:=Module[{adjoint,dim,cas},

If[cm=={},Return["U1"]];

adjoint=Adjoint[cm];
dim=DimR[cm,adjoint];
cas=Casimir[cm,adjoint];

Return[IdentifyGroupName[{dim,cas}]];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

IdentifyGroupName[dimCas_]:=Module[{result,aux,n},

(*U(1)*)
If[dimCas=={1,0},Return["U1"]];

(*Exceptionals*)
result=Switch[dimCas,{14,4},"G2",{52,9},"F4",{78,12},"E6",{133,18},"E7",{248,30},"E8",_,Null];
If[!(result===Null),Return[result]];

(*SU(n)*)
aux=Solve[{n^2-1,n}==dimCas,n];
aux=Cases[n/.aux,x_/;x>=2&&IntegerQ[x]];
If[Length[aux]!=0,
Return["SU"<>ToString[aux[[1]]]];
];

(*SO(n)*)
aux=Solve[{1/2(n^2-n),n-2}==dimCas,n];
aux=Cases[n/.aux,x_/;x>=5&&IntegerQ[x]];
If[Length[aux]!=0,
Return["SO"<>ToString[aux[[1]]]];
];

(*SP(2n)*)
aux=Solve[{2n^2+n,2n+2}==dimCas,n];
aux=Cases[n/.aux,x_/;x>=3&&IntegerQ[x]];
If[Length[aux]!=0,
Return["SP"<>ToString[2aux[[1]]]];
];

Return["Unknown group"];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* DESCRIPTION: Returns the list of positive roots of a group *)
PositiveRoots[cm_]:=PositiveRoots[cm]=Module[{n,weights,aux1,aux2,aux3,cont},
n=Length[cm]; (* =number of simple roots *)
weights=cm;
aux1=Table[KroneckerDelta[i,j],{i,n},{j,n}];
cont=0;

While[cont<Length[weights],
cont++;
aux2=aux1[[cont]];

Do[
aux3=aux2;
aux3[[i]]++;
If[FindM[aux1,aux2,i]-weights[[cont,i]]>0 && Count[aux1,aux3]==0,
weights=Append[weights,weights[[cont]]+cm[[i]]];
aux1=Append[aux1,aux3];
,Null];

,{i,n}];
];

Return[weights];]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

SpecialMatrixD[cm_]:=SpecialMatrixD[cm]=Module[{n,result,k},
n=Length[cm];
result=Table[0,{i,n},{j,4}];

Do[
k=1;
Do[
If[cm[[i,j]]==-1,
result[[i,k]]=j;k++;
];
If[cm[[i,j]]==-2,
result[[i,k]]=j;result[[i,k+1]]=j;k=k+2;
];
If[cm[[i,j]]==-3,
result[[i,k]]=j;result[[i,k+1]]=j;result[[i,k+2]]=j;k=k+3;
];
,{j,n}],{i,n}];

Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

ReflectWeight[cm_,weight_,i_]:=Module[{mD,result},
result= weight;
result[[i]]=-weight[[i]];
mD=SpecialMatrixD[cm];
Do[
If[mD[[i,j]]!=0,result[[mD[[i,j]]]]+=weight[[i]]];
,{j,4}];

Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

DominantConjugate[cm_,weight_]:=Module[{index,dWeight,i,mD},
If[cm=={{2}},Return[If[weight[[1]]<0,{-weight,1},{weight,0}]]]; (* for SU2 the code below would not work *)
index=0;
dWeight=weight;
i=1;
mD=SpecialMatrixD[cm];

While[i<=Length[cm],
If[dWeight[[i]]<0,
index++;
dWeight=ReflectWeight[cm,dWeight,i];
i=mD[[i,1]];
,i++];
];
Return[{dWeight,index}];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

WeylOrbit[cm_,weight_]:=Module[{wL,counter,n,result,aux},
n=Length[cm];
counter=0;
wL[counter]={weight};
result={weight};

While[Length[wL[counter]]!=0,

counter++;
wL[counter]={};

Do[

If[wL[counter-1][[j,i]]>0 ,
aux=ReflectWeight[cm,wL[counter-1][[j]],i][[i+1;;n]];
If[aux==Abs[aux],
wL[counter]=Append[wL[counter],ReflectWeight[cm,wL[counter-1][[j]],i]];
]];
,{j,Length[wL[counter-1]]},{i,n}];
result=Join[result,wL[counter]];
];

Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

DominantWeights[cm_,w_]:=DominantWeights[cm,w]=Module[{proots,listw,aux,functionAux,result,aux1,aux2,n,k,cmInv,matD,cmID,deltaTimes2},
cmInv=Inverse[cm];

(* ------------------------ Generate the dominant weights without dimentionality information ------------------------*)

proots=PositiveRoots[cm];
listw={w};
counter=1;
While[counter<=Length[listw],
aux=Table[listw[[counter]]-proots[[i]],{i,Length[proots]}];
listw=DeleteDuplicates[Join[listw,DeleteCases[aux,x_/;x!=Abs[x]]]];
counter++;
];
listw=Sort[listw,OrderedQ[{-{#1-#2}.cmInv,0{#1}}]&]; 

(* ------------------------ Get dimentionality information ------------------------*)

result={{listw[[1]],1}};
functionAux[x__]=0;
functionAux[listw[[1]]]=1;

(* Invert cm and get the diagonal matrix with entries <root i, root i> *)
n=Length[cm];
matD=MatrixD[cm];
cmID=cmInv.matD;
deltaTimes2=Sum[proots[[i]],{i,Length[proots]}];

Do[

Do[
k=1;

While[(aux1=functionAux[DominantConjugate[cm,k proots[[i]]+listw[[j]]][[1]]])!=0,
aux2=k proots[[i]]+listw[[j]];
functionAux[listw[[j]]]+=2 aux1 SimpleProduct[aux2,proots[[i]],cmID];
k++;

];

,{i,Length[proots]}];

functionAux[listw[[j]]]=functionAux[listw[[j]]]/SimpleProduct[listw[[1]]+listw[[j]]+deltaTimes2,listw[[1]]-listw[[j]],cmID];


result=Append[result,{listw[[j]],functionAux[listw[[j]]]}];
,{j,2,Length[listw]}];

Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* Reference:  the Lie Manual available in http://www-math.univ-poitiers.fr/~maavl/LiE/ *)
LongestWeylWord[cm_]:=LongestWeylWord[cm]=Module[{n,weight,aux,result},
n=Length[cm];
weight=-ConstantArray[1,n];
result={};
While[weight!=Abs[weight],
aux=Position[weight,x_/;x<0,1,1][[1,1]];
weight=ReflectWeight[cm,weight,aux];
PrependTo[result,aux];
];
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

Adjoint[input__]:=If[Depth[{input}]<=4,Return[AdjointBaseMethod[input]],Return[AdjointBaseMethod@@@Transpose[{input}]]];

(* DESCRIPTION: Max weight of the adjoint representation is just the largest  positive root of the algebra [NOTE: this is correct only if the given group is simple. Otherwise the adjoint representation is not even irreducible] *)
AdjointBaseMethod[cm_]:=If[cm==={},0,If[cm===ConstantArray[{},Length[cm]],ConstantArray[0,Length[cm]],PositiveRoots[cm][[-1]]]];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

ConjugateIrrep[input__]:=ConjugateIrrep[input]=Switch[Depth[{input}],x_/;(x==3||x==4),ConjugateIrrepBase[input],5,ConjugateIrrepBase@@@Transpose[{input}]];

(* Old, innefient way of calculating the conjugate representation *)
(* ConjugateIrrepBase[cm_,rep_]:=If[cm==={},-rep,-Weights[cm,rep][[-1,1]]] *)

(* See for example "A SHORT INTRODUCTION TO SIMPLE LIE ALGEBRA REPRESENTATIONS", JOSH GUFFIN, http://www.math.upenn.edu/~guffin/teaching/talks/rep.pdf *)
ConjugateIrrepBase[cm_,rep_]:=If[cm==={}||cm===ConstantArray[{},Length[cm]],-rep,-Fold[ReflectWeight[cm,#1,#2]&,rep,LongestWeylWord[cm]]];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

SimpleProduct[v1_,v2_,cmID_]:=1/2 ({v1}.cmID.Transpose[{v2}])[[1,1]];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(*DESCRIPTION: This method returns a diagonal matrix with the values <root i, root i> *)
MatrixD[cm_]:=MatrixD[cm]=Module[ {positions,result,coord1,coord2},
positions=Position[cm,-1|-2|-3,-1];
positions=Sort[Select[positions,#[[1]]<#[[2]]&]];

(*Assume for now that all roots are the same size*)
result=Table[1,{i,Length[cm]}];
Do[
coord1=positions[[j,1]];
coord2=positions[[j,2]];
(*Give the correct value to <\alpha,\alpha>*)
result[[coord2]]=cm[[coord2,coord1]]/cm[[coord1,coord2]] result[[coord1]];
,{j,Length[positions]}];

result=DiagonalMatrix[result];

Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* DESCRIPTION: Returns the weights of a representation (with dimentionalities) *)
Unprotect[Weights];
Weights[cm_,w_]:=Weights[cm,w]=Module[{dW,result,invCM},

(* Reorder the weights of conjugate representations so that RepMatrices[group,ConjugateIrrep[group,w]]=-Conjugate[RepMatrices[group,w]] and Invariants[group,{w,ConjugateIrrep[group,w]},{False,False}]=a[1]b[1]+...+a[n]b[n] *)
If[OrderedQ[{w,ConjugateIrrep[cm,w]}]&& ConjugateIrrep[cm,w]=!=w,Return[{-1,1}#&/@Weights[cm,ConjugateIrrep[cm,w]]]]; 

invCM=Inverse[cm];
dW=DominantWeights[cm,w];
result=Table[{#,dW[[i,2]]}&/@WeylOrbit[cm,dW[[i,1]]],{i,Length[dW]}];
result=Apply[Join,result];
 result=Sort[result,OrderedQ[{-{#1[[1]]-#2[[1]]}.invCM,0{#1[[1]]}}]&]; 

Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* Auxiliar method *)
FindM[ex_,el_,indice_]:=Module[{auxMax,aux1,aux2},
aux1=el[[indice]];
aux2=el;
aux2[[indice]]=0;
auxMax=0;
Do[

If[Count[ex,aux2]==1,auxMax=aux1-i+1;Goto[end];
,Null];
aux2[[indice]]=aux2[[indice]]+1;

,{i,aux1+1}];
Label[end];
Return[auxMax];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* Reduces a direct product representation in its irreducible parts *)

ReduceRepProduct[group_,repsList_]:=ReduceRepProduct[group,repsList]=If[Depth[group]==3&&group=!=ConstantArray[U1,Length[group]],Return[ReduceRepProductBase[group,repsList]],Return[{#[[1;;-1,1]],Times@@#[[1;;-1,2]]}&/@Tuples[MapThread[ReduceRepProductBase[#1,#2]&,{group,Transpose[repsList]}]]]];

(* Deals with possible factor groups/reps *)
ReduceRepProductBase[cm_,repsList_]:=Module[{n,orderedList,result},

(* If the group is U1 - trivial *)
If[cm==U1,Return[{{Plus@@repsList,1}}]];

(* If there is only one rep in listReps - trivial *)
If[Length[repsList]==1,Return[{{repsList[[1]],1}}]];

orderedList=Sort[repsList,DimR[cm,#1]<DimR[cm,#2]&];
n=Length[orderedList];
result=ReduceRepProductBase2[cm,orderedList[[n-1]],orderedList[[n]]];
Do[
result=ReduceRepProductBase1[cm,orderedList[[n-i]],result];
,{i,2,n-1}];
Return[result];
]

ReduceRepProductBase1[cm_,rep1_,listReps_]:=Module[{result},
result=Table[({#[[1]],listReps[[i,2]]#[[2]]})&/@ReduceRepProductBase2[cm,rep1,listReps[[i,1]]],{i,Length[listReps]}];
result=Join@@result;
result=GatherBy[result,#[[1]]&];
result=Table[{result[[i,1,1]],Sum[result[[i,j,2]],{j,Length[result[[i]]]}]},{i,Length[result]}];
Return[result];
]

ReduceRepProductBase2[cm_,w1_,w2_]:=Module[{l1,wOrbit,delta,n,aux,dim,allIrrep,result},
n=Length[cm];
delta=Table[1,{i,n}];

l1=DominantWeights[cm,w1];
dim[x_]=0;
allIrrep={};
Do[
wOrbit=WeylOrbit[cm,l1[[i,1]]];
Do[
aux=DominantConjugate[cm,wOrbit[[j]]+w2+delta];

If[aux[[1]]-1==Abs[aux[[1]]-1], (*regular*)
dim[aux[[1]]-delta]+=(-1)^aux[[2]] l1[[i,2]];
allIrrep=DeleteDuplicates[Append[allIrrep,aux[[1]]-delta]];
];
,{j,Length[wOrbit]}];

,{i,Length[l1]}];

result=Table[{allIrrep[[i]],dim[allIrrep[[i]]]},{i,Length[allIrrep]}];
result=DeleteCases[result,x_/;x[[2]]==0];
Return[result];
];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* Calculates the dimention of a irrep *)
DimR[input__]:=DimR[input]=Switch[Depth[{input}],x_/;(x==3||x==4),DimRBaseMethod[input],5,DimRBaseMethod@@@Transpose[{input}]];

DimRBaseMethod[cm_,w_]:=Module[{n,proots,cmInv,matD,cmID,delta,result},
If[cm==={},Return[1]]; (* U1 group *)
If[cm===ConstantArray[{},Length[cm]],Return[ConstantArray[1,Length[cm]]]]; (* multiple U1 group *)

n=Length[cm];
proots=PositiveRoots[cm];

(* Invert cm and get the diagonal matrix with entries <root i, root i> *)
cmInv=Inverse[cm];
matD=MatrixD[cm];
cmID=cmInv.matD;
delta=1/2 Sum[proots[[i]],{i,Length[proots]}];
result=Product[SimpleProduct[proots[[i]],w+delta,cmID]/SimpleProduct[proots[[i]],delta,cmID]  ,{i,Length[proots]}];

Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

NullMatrix[n_,m_]:=Array[0&,{n,m}];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* Auxiliar method needed to construct the representation matrices *)
CholeskyTypeDecomposition[matrix_]:=Module[{n,nullRow,matD,matL,result},
n=Length[matrix];
matD=Array[0&,{n,n}];
matL=IdentityMatrix[n];

Do[
Do[
If[matD[[j,j]]!=0,
matL[[i,j]]=Simplify[1/matD[[j,j]](matrix[[i,j]]-Sum[matL[[i,k]]Conjugate[matL[[j,k]]]matD[[k,k]],{k,j-1}])];
,matL[[i,j]]=0];
,{j,i-1}];

matD[[i,i]]=Simplify[matrix[[i,i]]-Sum[matL[[i,k]]Conjugate[matL[[i,k]]]matD[[k,k]],{k,i-1}]];

,{i,Length[matrix]}];

(*Make the resulting matrix as small as possible by eliminating null columns*)
result=Transpose[matL.Sqrt[matD]];
nullRow=Array[0&,n];
result=Transpose[DeleteCases[result,nullRow]];

Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* Calculates the generators of a irrep based on the Chevalley-Serre relations *)
RepMinimalMatrices[cm_,maxW_]:=RepMinimalMatrices[cm,maxW]=Module[{aux1,aux2,aux3,aux4,aux6,aux7,aux8,n,listw,up,down,dim,dim1,dim2,dim3,col,matrixT,matrix,index,posBegin,posEnd,begin,end,b1,e1,b2,e2,matrixE,matrixF,matrixH},

(* Reorder the weights of conjugate representations so that RepMatrices[group,ConjugateIrrep[group,w]]=-Conjugate[RepMatrices[group,w]] and Invariants[group,{w,ConjugateIrrep[group,w]},{False,False}]=a[1]b[1]+...+a[n]b[n] *)
If[OrderedQ[{maxW,ConjugateIrrep[cm,maxW]}]&& ConjugateIrrep[cm,maxW]=!=maxW,Return[-RepMinimalMatrices[cm,ConjugateIrrep[cm,maxW]][[All,{2,1,3}]]]]; 

n=Length[cm];
listw=Weights[cm,maxW];

dim[x__]:=0;
up[x__]=Table[{},{i,n}];
down[x__]=Table[{},{i,n}];
Do[
dim[listw[[i,1]]]=listw[[i,2]];
,{i,Length[listw]}];
up[listw[[1,1]]]=Table[{{0}},{i,n}];

Do[
matrixT={};
Do[
col={};
Do[
dim1=dim[listw[[element,1]]+cm[[i]]];
dim2=dim[listw[[element,1]]+cm[[i]]+cm[[j]]];
dim3=dim[listw[[element,1]]+cm[[j]]];

If[dim1!=0&&dim3!=0,
If[dim2!=0,
aux1=up[listw[[element,1]]+cm[[i]]][[j]];
aux2=down[listw[[element,1]]+cm[[i]]+cm[[j]]][[i]];

If[i!=j,col=Join[col,aux1.aux2], col=Join[col,aux1.aux2+(listw[[element,1,i]] +cm[[i,i]])IdentityMatrix[dim1]]];
,
If[i!=j,col=Join[col,NullMatrix[dim1,dim3]], col=Join[col,(listw[[element,1,i]] +cm[[i,i]])IdentityMatrix[dim1]]];
];

];

,{i,n}];

If[col!={},
matrixT=Join[matrixT,Transpose[col]];
];

,{j,n}];

(* Separate the two matrices in the product (w+\[Alpha]i)i * wj *)
matrix=Transpose[matrixT];

aux1=Sum[dim[listw[[element,1]]+cm[[i]]],{i,n}];
aux2=dim[listw[[element,1]]];

aux3=PadRight[CholeskyTypeDecomposition[matrix],{aux1,aux2}];
aux4=Transpose[aux3];
If[aux3.aux4!= matrix,Print["Error!", aux3//MatrixForm,aux4//MatrixForm,matrix//MatrixForm];];


(* Obtain the blocks in  (w+\[Alpha]i)i and wj. Use it to feed the recursive algorith so that we can calculate the next w's *)

aux1={{0,0}}; (* format (+-): (valid cm raise index i - 1, start position of weight w+cm[[i-1]]-1) *)
Do[
If[dim[listw[[element,1]]+cm[[i]]]!=0,
aux1=Append[aux1,{i,aux1[[-1,2]]+dim[listw[[element,1]]+cm[[i]]]}];];
,{i,n}];

Do[
index=aux1[[i+1,1]];
posBegin=aux1[[i,2]]+1;
posEnd=aux1[[i+1,2]];


aux2=down[listw[[element,1]]+cm[[index]]];
aux2[[index]]=aux3[[posBegin;;posEnd]];
down[listw[[element,1]]+cm[[index]]]=aux2;

aux2=up[listw[[element,1]]];
aux2[[index]]=Transpose[Transpose[aux4][[posBegin;;posEnd]]];
up[listw[[element,1]]]=aux2;
,{i,Length[aux1]-1}];

,{element,2,Length[listw]}];

(* Put the collected pieces together and build the 3n matrices: hi,ei,fi *)

begin[listw[[1,1]]]=1;
end[listw[[1,1]]]=listw[[1,2]];

Do[
begin[listw[[element,1]]]=begin[listw[[element-1,1]]]+listw[[element-1,2]];
end[listw[[element,1]]]=end[listw[[element-1,1]]]+listw[[element,2]];
,{element,2,Length[listw]}];

aux1=Table[{1+Sum[listw[[j,2]],{j,i-1}],Sum[listw[[j,2]],{j,i}]},{i,Length[listw]}];
aux2=Sum[listw[[i,2]],{i,Length[listw]}];
aux3=SparseArray[PadRight[{{}},{aux2,aux2}]];

Do[
aux6=aux3; (* e[i] *)
aux7=aux3; (* f[i] *)
aux8=aux3; (* h[i] *)
Do[ 

If[dim[listw[[element,1]]+cm[[i]]]!=0,
b1=begin[listw[[element,1]]+cm[[i]]];
e1=end[listw[[element,1]]+cm[[i]]];
b2=begin[listw[[element,1]]];
e2=end[listw[[element,1]]];
aux6[[b1;;e1,b2;;e2]]=Transpose[up[listw[[element,1]]][[i]]];
];

If[dim[listw[[element,1]]-cm[[i]]]!=0,
b1=begin[listw[[element,1]]-cm[[i]]];
e1=end[listw[[element,1]]-cm[[i]]];
b2=begin[listw[[element,1]]];
e2=end[listw[[element,1]]];
aux7[[b1;;e1,b2;;e2]]=Transpose[down[listw[[element,1]]][[i]]];
];

b1=begin[listw[[element,1]]];
e1=end[listw[[element,1]]];
aux8[[b1;;e1,b1;;e1]]=listw[[element,1,i]] IdentityMatrix[listw[[element,2]]];

,{element,Length[listw]}];
matrixE[i]=SparseArray[aux6];
matrixF[i]=SparseArray[aux7];
matrixH[i]=SparseArray[aux8];

,{i,n}];

aux1=Table[{matrixE[i],matrixF[i],matrixH[i]},{i,n}];

Return[aux1]; (*  result is a list with entries {e[i],f[i],h[i]} *)
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* Calculates the Casimir invariant of an irrep *)
Casimir[input__]:=Casimir[input]=Switch[Depth[{input}],x_/;(x==3||x==4),CasimirBaseMethod[input],5,CasimirBaseMethod@@@Transpose[{input}]];

(* Uses formula XI .23 of "Semi-Simple Lie Algebras and Their Representations", page 89 *)

CasimirBaseMethod[cm_,w_]:=Module[{n,cmInv,matD,cmID,proots,deltaTimes2,result},
If[cm==={}||cm===ConstantArray[{},Length[cm]],Return[w^2]]; (* U1 group or multiple U1 groups *)

n=Length[cm];
proots=PositiveRoots[cm];

cmInv=Inverse[cm];
matD=MatrixD[cm];
cmID=cmInv.matD;
deltaTimes2=Sum[proots[[i]],{i,Length[proots]}];
result=SimpleProduct[w,w+deltaTimes2,cmID];

Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

DynkinIndex[cm_,rep_]:=Simplify[Casimir[cm,rep] DimR[cm,rep]/DimR[cm,Adjoint[cm]]]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)


(* Auxiliar method (used for building invariants) *)
BlockW[w1_,w2_,listW_,repMat_]:=Module[{dim,b,e,aux1},

dim[0]=0;
Do[dim[i]=dim[i-1]+listW[[i,2]],{i,Length[listW]}];

Do[b[listW[[i,1]]]=dim[i-1]+1;
e[listW[[i,1]]]=dim[i];
,{i,Length[listW]}];

aux1=repMat[[b[w1];;e[w1],b[w2];;e[w2]]];

Return[aux1];

]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* Auxiliar method (used for building the representation matrices) *)
NullSpace2[matrix_,dt_]:=Module[{aux1,aux2,aux3,res,n,n2,v},
Off[Power::"indet"];
n=Length[matrix];
n2=Length[matrix[[1]]];

aux1=Table[v[i],{i,n2}];

Do[

aux2=Solve[matrix[[i;;Min[i+dt-1,n]]].aux1==0][[1]];
aux1=Expand[aux1 /.aux2];

,{i,1,n,dt}];

aux3=DeleteDuplicates[Cases[aux1,v[i_]:>i,Infinity]];
res={};
Do[
res=Append[res,aux1/. v[x_]:>If[x!=aux3[[i]],0,1]];
,{i,Length[aux3]}];
Return[res];
];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* This method returns the complete set of matrices that make up a representation, with the correct casimir and trace normalizations *)

RepMatrices[input__]:=RepMatrices[input]=If[Depth[{input}]==4,Return[RepMatricesBaseMethod[input]],Return[RepMatricesBaseMethod@@@Transpose[{input}]]];

RepMatricesBaseMethod[cm_,maxW_]:=Module[{listE,listF,listH,listTotal,n,pRoots,sR,dimG,dimR,rep,matrixCholesky,aux,j},
n=Length[cm];
pRoots=PositiveRoots[cm];
rep=RepMinimalMatrices[cm,maxW];
listE=Table[SparseArray[rep[[i,1]]],{i,n}];
listF=Table[SparseArray[rep[[i,2]]],{i,n}];
listH=Table[SparseArray[rep[[i,3]]],{i,n}];

dimG=2Length[pRoots]+Length[cm];
dimR=DimR[cm,maxW];
sR=Casimir[cm,maxW] dimR/dimG;

If[dimR==1, (*trivial rep, therefore all matrices are null*)
listTotal=Table[listE[[1]],{i,dimG}];
Goto[end];
];

(* If it's not the trivial rep, generate the matrices of the remaining algebra elements. The positive roots of the algebra serve as a guide in this process of doing comutators  *)
Do[
j=1;While[(aux=Position[pRoots[[1;;i]],pRoots[[i]]-pRoots[[j]]])=={},j++];

listE=Append[listE,listE[[aux[[1,1]]]].listE[[j]]-listE[[j]].listE[[aux[[1,1]]]]];
listF=Append[listF,listF[[aux[[1,1]]]].listF[[j]]-listF[[j]].listF[[aux[[1,1]]]]];

,{i,n+1,Length[pRoots]}];


Do[
(* Change from the operadores T+, T- to Tx,Ty *)
aux=listE[[i]];
listE[[i]]=listE[[i]]+ listF[[i]];
listF[[i]]=aux-listF[[i]];

(* Control the normalizayion of the Tx,Ty matrices with the trace condition *)
 listE[[i]]=SparseArray[Simplify[Sqrt[sR]/Sqrt[ Tr[listE[[i]].listE[[i]]]]]listE[[i]]]; 
listF[[i]]=SparseArray[Simplify[Sqrt[sR]/Sqrt[ Tr[listF[[i]].listF[[i]]]]]listF[[i]]];
,{i,Length[listE]}];

matrixCholesky=Inverse[cm].MatrixD[cm]; (* See the casimir expression in a book on lie algebras *)
aux=Simplify[CholeskyDecomposition[matrixCholesky]];
listH=Table[SparseArray[Sum[aux[[i,j]]listH[[j]],{j,n}]],{i,n}];

(* Up to multiplicative factors, Tz are now correct. We fix again the normalization with the trace condition *)
listH=Table[SparseArray[Simplify[Sqrt[sR]/Sqrt[ Tr[listH[[i]].listH[[i]]]]]listH[[i]]],{i,n}];

listTotal=Join[listE,listF,listH];

(* Make sure the final matrices are simplified *)
listTotal=Table[SparseArray[Simplify[listTotal[[i]]//ArrayRules],{dimR,dimR}],{i,Length[listTotal]}];

Label[end];

Return[listTotal];
];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* This method checks if an invariant is symmetric(output=1), skew-symmetric (output=2) ou none (output=0) given the fields names (e.g. {a,b,c}) *)
IsSymmetric[invariant_,vars_]:=Module[{aux1,result},
result=0;
aux1=invariant/.{vars[[1]]->vars[[2]],vars[[2]]->vars[[1]]};
If[Expand[invariant-aux1]==0,result=1]; (* symmetric *)
If[Expand[invariant+aux1]==0,result=2]; (* skew-symmetric *)
Return[result];
];


(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Invariants3Mod and IrrepInProduct are auxiliar methods *)
Invariants3Mod[cm_,reps_,conjs_]:=Module[{},
If[(conjs[[1]]&&conjs[[2]]&&conjs[[3]])||((!conjs[[1]])&&(!conjs[[2]])&&(!conjs[[3]])),Return[InvariantsOld[cm,reps[[1]],reps[[2]],reps[[3]]]]];
If[(conjs[[1]]&&conjs[[2]]&&(!conjs[[3]]))||((!conjs[[1]])&&(!conjs[[2]])&&(conjs[[3]])),Return[InvariantsOld[cm,reps[[1]],reps[[2]],reps[[3]],True]]];

If[(conjs[[1]]&&(!conjs[[2]])&&conjs[[3]])||((!conjs[[1]])&&(conjs[[2]])&&(!conjs[[3]])),Return[InvariantsOld[cm,reps[[1]],reps[[3]],reps[[2]],True]/.{c->b,b->c}]];
If[((!conjs[[1]])&&conjs[[2]]&&conjs[[3]])||((conjs[[1]])&&(!conjs[[2]])&&(!conjs[[3]])),Return[InvariantsOld[cm,reps[[3]],reps[[2]],reps[[1]],True]/.{c->a,a->c}]];
]

Options[IrrepInProduct]={Conjugations->{}};
IrrepInProduct[cm_,reps_,OptionsPattern[]]:=Module[{aux,vector,conjs},

(* Option allows to conjugate the representations given as input. By default, no conjugation is done *)
conjs=If[OptionValue[Conjugations]==={},ConstantArray[False,Length[reps]],OptionValue[Conjugations]];

aux=Invariants3Mod[cm,reps,conjs];
vector=DeleteDuplicates[Sort[Cases[aux,c[__],-1]]];
aux=CoefficientArrays[#,vector][[2]]&/@aux;

Return[aux];
]

Options[Invariants]={Conjugations->{}};
Invariants[groupOriginal_,rOriginal_,OptionsPattern[]]:=Module[{result,pU1s,pNonU1s,hyperchargesSum,group,r,cjs},

(* Option allows to conjugate the representations given as input. By default, no conjugation is done *)
cjs=If[OptionValue[Conjugations]==={},ConstantArray[False,Length[rOriginal]],OptionValue[Conjugations]];


(* Deal with U1's *)
If[groupOriginal===U1&&Sum[rOriginal[[i]]If[cjs[[i]],-1,1],{i,Length[rOriginal]}]==0,Return[Product[ToExpression[FromCharacterCode[96+i]],{i,Length[rOriginal]}]]];
If[groupOriginal===U1&&Sum[rOriginal[[i]]If[cjs[[i]],-1,1],{i,Length[rOriginal]}]!=0,Return[{}]];

(* Remove U1s and hypercharges *)
pU1s=Flatten[Position[groupOriginal,U1]];
pNonU1s=Flatten[Position[groupOriginal,x_/;x!=U1,{1}]];
hyperchargesSum=Sum[rOriginal[[i,pU1s]]If[cjs[[i]],-1,1],{i,Length[rOriginal]}];
If[!(hyperchargesSum===0hyperchargesSum),Return[{}]];
group=groupOriginal[[pNonU1s]];
r=rOriginal[[All,pNonU1s]];



(* /Deal with U1's *)

InvariantsAux[otherStuff_,cm_,reps_,conjs_]:=Module[{aux1,aux1c,aux2,aux3,prov,trueReps,i1,j1},

If[Length[reps]==3,

aux1=Invariants3Mod[cm,reps,conjs];
aux1=(aux1//Normal)/.{a->ToExpression[FromCharacterCode[97+Length[otherStuff]]],b->ToExpression[FromCharacterCode[98+Length[otherStuff]]],c->ToExpression[FromCharacterCode[99+Length[otherStuff]]]};

aux2=otherStuff[[1]];
Do[
aux2=Flatten[Expand[otherStuff[[i1]] /.aux2],1];
,{i1,2,Length[otherStuff]}];

aux2=Flatten[Expand[aux1/.aux2]];
AppendTo[result,aux2];
Return[];
];

trueReps=Table[If[conjs[[i1]],ConjugateIrrep[cm,reps[[i1]]],reps[[i1]]],{i1,Length[reps]}];
aux1=ReduceRepProduct[cm,{trueReps[[1]],trueReps[[2]]}][[1;;-1,1]];
aux1=ConjugateIrrep[cm,#]&/@aux1;

aux2=ReduceRepProduct[cm,trueReps[[3;;-1]]][[1;;-1,1]];

aux1=Intersection[aux1,aux2];

Do[
aux2=(IrrepInProduct[cm,Append[reps[[1;;2]],aux1[[i1]]],Conjugations->Append[conjs[[1;;2]],False]] //Normal )/.{a->ToExpression[FromCharacterCode[96+Length[otherStuff]+1]],b->ToExpression[FromCharacterCode[96+Length[otherStuff]+2]]};
aux3=Flatten[Array[ToExpression[FromCharacterCode[96+Length[otherStuff]+2]],DimR[cm,aux1[[i1]]]]];
aux2=(MapThread[Rule,{aux3,#}])&/@aux2;

InvariantsAux[Append[otherStuff,aux2],cm,Prepend[reps[[3;;-1]],aux1[[i1]]],Prepend[conjs[[3;;-1]],True]];
,{i1,Length[aux1]}];
];

result={};

Piecewise[
{{InvariantsAux[{},group,r,cjs],Length[r]>3},
{result=Invariants3Mod[group,r,cjs],Length[r]==3},
{result=InvariantsOld[group,r[[1]],r[[2]],!(cjs[[1]]==cjs[[2]])],Length[r]==2},
{result=InvariantsOld[group,r[[1]],cjs[[1]]],Length[r]==1}
}];

Return[Flatten[result]];
]

(* This is the old wrapper method that calculates invariants of combinations of up to 3 fields. The new method (Invariants) may contain an arbitrary number of fields and has a different input syntax *)
InvariantsOld[arguments__]:=InvariantsOld[arguments]=Module[{result,argumentsList,nArgs,conjugate,aux,aux2,numberGroups},

argumentsList=Drop[{arguments},-1];
conjugate={arguments}[[-1]];
(* The conjugation argument is optional (default value=False) *)
If[!(TrueQ[conjugate]||TrueQ[!conjugate]),argumentsList={arguments};conjugate=False];
nArgs=Length[argumentsList];
numberGroups=Length[argumentsList[[1]]];


(* If the first argument is just one matrix (simple group) simply use the methods InvariantsBaseMethod *)
If[Depth[argumentsList[[1]]]==3,result=InvariantsBaseMethod[arguments],

(* ... ff not (semi-simple group), some work must be done before using InvariantsBaseMethod *)

Do[
aux[i]=InvariantsBaseMethod[(#[[i]]&/@argumentsList )/.{x__}:>x,conjugate];
,{i,numberGroups}];

result=aux[1];
Do[
aux2={};
Do[
If[nArgs==4,
aux2=Join[aux2,aux[i] /.a[x1_]b[x2_]c[x3_ ]:>(result[[j]]/.{a[y1__]:>a[y1,x1],b[y1__]:>b[y1,x2],c[y1__]:>c[y1,x3]})]];
If[nArgs==3,
aux2=Join[aux2,aux[i] /.a[x1_]b[x2_]:>(result[[j]]/.{a[y1__]:>a[y1,x1],b[y1__]:>b[y1,x2]})]];
If[nArgs==2,
aux2=Join[aux2,aux[i] /.a[x1_]:>(result[[j]]/.{a[y1__]:>a[y1,x1]})]];

,{j,Length[result]}]; (* maybe there is more than one invariant in aux[i]; that's why this extra loop is needed *)
result=aux2;
,{i,2,numberGroups}];

];

Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

InvariantsBaseMethod[cm_,rep1_,conj_Symbol:False]:=Module[{result},

result=If[rep1==Table[0,{i,Length[cm]}],{a[1]},{}];
Return[result];
];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

InvariantsBaseMethod[cm_,rep1_,rep2_,conj_Symbol:False]:=Module[{n,array1,array2,aux1,aux2,aux3,aux4,r1,r2,w1,w2,dim1,dim2,b1,b2,e1,e2,matrixE,bigMatrix,expr,cont,coefs,result},

Off[Solve::"svars"];
n=Length[cm];
w1=Weights[cm,rep1];
w2=Weights[cm,rep2];
r1=RepMinimalMatrices[cm,rep1];
r2=RepMinimalMatrices[cm,rep2];

If[conj,
Do[
w2[[i,1]]=-w2[[i,1]];

,{i,Length[w2]}];
Do[
r2[[i,j]]=-Transpose[r2[[i,j]]];
,{i,n},{j,3}];];

(*---------------------*)
array1[x__]:=0;
array2[x__]:=0;
Do[array1[w1[[i,1]]]=w1[[i,2]],{i,Length[w1]}];
Do[array2[w2[[i,1]]]=w2[[i,2]],{i,Length[w2]}];
(*---------------------*)
aux1={};
Do[
If[array2[-w1[[i,1]]]!=0,aux1=Append[aux1,{w1[[i,1]],-w1[[i,1]]}]];
,{i,Length[w1]}];
(*---------------------*)
dim1[0]=0;
Do[dim1[i]=dim1[i-1]+array1[aux1[[i,1]]]array2[aux1[[i,2]]],{i,Length[aux1]}];

Do[b1[aux1[[i]]]=dim1[i-1]+1;
e1[aux1[[i]]]=dim1[i];
,{i,Length[aux1]}];
(*---------------------*)


bigMatrix={};
Do[

(*--------------------- Code for the e's --------------------- *)

aux2={};
Do[
If[array1[aux1[[j,1]]+cm[[i]]]!=0,
aux2=Append[aux2,{aux1[[j,1]]+cm[[i]],aux1[[j,2]]}]];
If[array2[aux1[[j,2]]+cm[[i]]]!=0,
aux2=Append[aux2,{aux1[[j,1]],aux1[[j,2]]+cm[[i]]}]];
,{j,Length[aux1]}];

aux2=DeleteDuplicates[aux2];

If[Length[w1]==1 && Length[w2]==1,aux2=aux1];  (* Special care is needed if both reps are singlets *)


(*---------------------*)
dim2[0]=0;
Do[dim2[i]=dim2[i-1]+array1[aux2[[i,1]]]array2[aux2[[i,2]]],{i,Length[aux2]}];

Do[b2[aux2[[i]]]=dim2[i-1]+1;
e2[aux2[[i]]]=dim2[i];
,{i,Length[aux2]}];
(*---------------------*)

If[dim2[Length[aux2]]!=0&&dim1[Length[aux1]]!=0,
matrixE=SparseArray[{},{dim2[Length[aux2]],dim1[Length[aux1]]}],matrixE={}];

Do[

If[array1[aux1[[j,1]]+cm[[i]]]!=0,
aux3=aux1[[j]];
aux4={aux1[[j,1]]+cm[[i]],aux1[[j,2]]};

matrixE[[b2[aux4];;e2[aux4],b1[aux3];;e1[aux3]]]=KroneckerProduct[BlockW[aux1[[j,1]]+cm[[i]],aux1[[j,1]],w1,r1[[i,1]]],IdentityMatrix[array2[aux1[[j,2]]]]];

];

If[array2[aux1[[j,2]]+cm[[i]]]!=0,
aux3=aux1[[j]];
aux4={aux1[[j,1]],aux1[[j,2]]+cm[[i]]};

matrixE[[b2[aux4];;e2[aux4],b1[aux3];;e1[aux3]]]=KroneckerProduct[IdentityMatrix[array1[aux1[[j,1]]]],BlockW[aux1[[j,2]]+cm[[i]],aux1[[j,2]],w2,r2[[i,1]]]];

];
,{j,Length[aux1]}];


If[bigMatrix!={},bigMatrix=SparseArray[bigMatrix]];
bigMatrix=Join[bigMatrix ,matrixE];
,{i,n}];

(*---------------------*)

dim1[0]=0;
Do[dim1[i]=dim1[i-1]+w1[[i,2]],{i,Length[w1]}];

dim2[0]=0;
Do[dim2[i]=dim2[i-1]+w2[[i,2]],{i,Length[w2]}];

Do[b1[w1[[i,1]]]=dim1[i-1];
,{i,Length[w1]}];

Do[b2[w2[[i,1]]]=dim2[i-1];
,{i,Length[w2]}];


If[Length[bigMatrix]!=0,
aux4=NullSpace2[bigMatrix,100];

Do[
expr[i0]=0;
cont=0;
Do[
Do[
cont++;
expr[i0]+=aux4[[1,cont]]a[b1[aux1[[i,1]]]+j1] b[b2[aux1[[i,2]]]+j2];
,{j1,array1[aux1[[i,1]]]},{j2,array2[aux1[[i,2]]]}];
,{i,Length[aux1]}];
,{i0,Length[aux4]}];

result=Table[expr[i0],{i0,Length[aux4]}];

(* Normalize the invariants *)
coefs=result /. {Plus ->List,a[__]->1,b[__]->1,c[__]->1};
Do[
If[Length[coefs[[i]]]==0,coefs[[i]]={coefs[[i]]}];
result[[i]]=Expand[Sqrt[Sqrt[DimR[cm,rep1] DimR[cm,rep2]]/coefs[[i]].Conjugate[coefs[[i]]]] result[[i]]];
,{i,Length[coefs]}];
(* /Normalize the invariants *)

,result={}];

(* Special treatment - This code ensures that well known cases come out in the expected form *)

 (* Two SU(2) doublets and no conjugation ... fix the sign *)
If[cm==SU2&&rep1==rep2=={1}&&!conj, result=-result];

(* /Special treatment *)

Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

InvariantsBaseMethod[cm_,rep1_,rep2_,rep3_,conj_Symbol:False]:=Module[{n,array1,array2,array3,aux1,aux2,aux3,aux4,r1,r2,r3,w1,w2,w3,dim1,dim2,dim3,b1,b2,b3,e1,e2,matrixE,bigMatrix,expr,cont,coefs,result},

Off[Solve::"svars"];
n=Length[cm];

w1=Weights[cm,rep1];
w2=Weights[cm,rep2];
w3=Weights[cm,rep3];
r1=RepMinimalMatrices[cm,rep1];
r2=RepMinimalMatrices[cm,rep2];
r3=RepMinimalMatrices[cm,rep3];

If[conj,
Do[
w3[[i,1]]=-w3[[i,1]];

,{i,Length[w3]}];
Do[
r3[[i,j]]=-Transpose[r3[[i,j]]];
,{i,n},{j,3}];];

(*---------------------*)
array1[x__]:=0;
array2[x__]:=0;
array3[x__]:=0;
Do[array1[w1[[i,1]]]=w1[[i,2]],{i,Length[w1]}];
Do[array2[w2[[i,1]]]=w2[[i,2]],{i,Length[w2]}];
Do[array3[w3[[i,1]]]=w3[[i,2]],{i,Length[w3]}];
(*---------------------*)
aux1={};
Do[
If[array3[-w1[[i,1]]-w2[[j,1]]]!=0,aux1=Append[aux1,{w1[[i,1]],w2[[j,1]],-w1[[i,1]]-w2[[j,1]]}]];
,{i,Length[w1]},{j,Length[w2]}];
(*---------------------*)
dim1[0]=0;
Do[dim1[i]=dim1[i-1]+array1[aux1[[i,1]]]array2[aux1[[i,2]]]array3[aux1[[i,3]]],{i,Length[aux1]}];

Do[b1[aux1[[i]]]=dim1[i-1]+1;
e1[aux1[[i]]]=dim1[i];
,{i,Length[aux1]}];
(*---------------------*)


bigMatrix={};
Do[

(*--------------------- Code for the e's --------------------- *)

aux2={};
Do[
If[array1[aux1[[j,1]]+cm[[i]]]!=0,
aux2=Append[aux2,{aux1[[j,1]]+cm[[i]],aux1[[j,2]],aux1[[j,3]]}]];
If[array2[aux1[[j,2]]+cm[[i]]]!=0,
aux2=Append[aux2,{aux1[[j,1]],aux1[[j,2]]+cm[[i]],aux1[[j,3]]}]];
If[array3[aux1[[j,3]]+cm[[i]]]!=0,
aux2=Append[aux2,{aux1[[j,1]],aux1[[j,2]],aux1[[j,3]]+cm[[i]]}]];
,{j,Length[aux1]}];
aux2=DeleteDuplicates[aux2];
If[Length[w1]==1 && Length[w2]==1&& Length[w3]==1,aux2=aux1];   (* Special care is needed if all 3 reps are singlets *)
(*---------------------*)
dim2[0]=0;
Do[dim2[i]=dim2[i-1]+array1[aux2[[i,1]]]array2[aux2[[i,2]]]array3[aux2[[i,3]]],{i,Length[aux2]}];

Do[b2[aux2[[i]]]=dim2[i-1]+1;
e2[aux2[[i]]]=dim2[i];
,{i,Length[aux2]}];
(*---------------------*)


If[dim2[Length[aux2]]!=0&&dim1[Length[aux1]]!=0,
matrixE=SparseArray[{},{dim2[Length[aux2]],dim1[Length[aux1]]}],matrixE={}];

Do[

If[array1[aux1[[j,1]]+cm[[i]]]!=0,
aux3=aux1[[j]];
aux4={aux1[[j,1]]+cm[[i]],aux1[[j,2]],aux1[[j,3]]};

matrixE[[b2[aux4];;e2[aux4],b1[aux3];;e1[aux3]]]=KroneckerProduct[BlockW[aux1[[j,1]]+cm[[i]],aux1[[j,1]],w1,r1[[i,1]]],IdentityMatrix[array2[aux1[[j,2]]]],IdentityMatrix[array3[aux1[[j,3]]]]];
];

If[array2[aux1[[j,2]]+cm[[i]]]!=0,
aux3=aux1[[j]];
aux4={aux1[[j,1]],aux1[[j,2]]+cm[[i]],aux1[[j,3]]};

matrixE[[b2[aux4];;e2[aux4],b1[aux3];;e1[aux3]]]=KroneckerProduct[IdentityMatrix[array1[aux1[[j,1]]]],BlockW[aux1[[j,2]]+cm[[i]],aux1[[j,2]],w2,r2[[i,1]]],IdentityMatrix[array3[aux1[[j,3]]]]];
];

If[array3[aux1[[j,3]]+cm[[i]]]!=0,
aux3=aux1[[j]];
aux4={aux1[[j,1]],aux1[[j,2]],aux1[[j,3]]+cm[[i]]};

matrixE[[b2[aux4];;e2[aux4],b1[aux3];;e1[aux3]]]=KroneckerProduct[IdentityMatrix[array1[aux1[[j,1]]]],IdentityMatrix[array2[aux1[[j,2]]]],BlockW[aux1[[j,3]]+cm[[i]],aux1[[j,3]],w3,r3[[i,1]]]];
];


,{j,Length[aux1]}];

If[bigMatrix!={},bigMatrix=SparseArray[bigMatrix]];
bigMatrix=Join[bigMatrix ,matrixE];

,{i,n}];

(*---------------------*)

dim1[0]=0;
Do[dim1[i]=dim1[i-1]+w1[[i,2]],{i,Length[w1]}];

dim2[0]=0;
Do[dim2[i]=dim2[i-1]+w2[[i,2]],{i,Length[w2]}];

dim3[0]=0;
Do[dim3[i]=dim3[i-1]+w3[[i,2]],{i,Length[w3]}];

Do[b1[w1[[i,1]]]=dim1[i-1];
,{i,Length[w1]}];

Do[b2[w2[[i,1]]]=dim2[i-1];
,{i,Length[w2]}];

Do[b3[w3[[i,1]]]=dim3[i-1];
,{i,Length[w3]}];

If[Length[bigMatrix]!=0,


aux4=NullSpace2[bigMatrix,100];


Do[
expr[i0]=0;
cont=0;
Do[
Do[
aux2=0;
Do[
cont++;
aux2+=aux4[[i0,cont]]a[b1[aux1[[i,1]]]+j1] b[b2[aux1[[i,2]]]+j2] c[b3[aux1[[i,3]]]+j3];
,{j2,array2[aux1[[i,2]]]},{j3,array3[aux1[[i,3]]]}];
expr[i0]+=aux2;
,{j1,array1[aux1[[i,1]]]}]

,{i,Length[aux1]}];
,{i0,Length[aux4]}];

result=Table[expr[i0],{i0,Length[aux4]}];

(*With more that one invariant and repeated fields, make sure each invariant has some symmetry *)
If[Length[result]>1,

If[(rep1==rep2==rep3)&&!conj,result=SymmetrizeInvariants[result,{DimR[cm,rep1],DimR[cm,rep2],DimR[cm,rep3]},{{1,2,3}}];];
If[rep1==rep2!=rep3,result=SymmetrizeInvariants[result,{DimR[cm,rep1],DimR[cm,rep2],DimR[cm,rep3]},{{1,2}}];];
If[(rep1==rep3!=rep2)&&!conj,result=SymmetrizeInvariants[result,{DimR[cm,rep1],DimR[cm,rep2],DimR[cm,rep3]},{{1,3}}];];
If[(rep3==rep2!=rep1)&&!conj,result=SymmetrizeInvariants[result,{DimR[cm,rep1],DimR[cm,rep2],DimR[cm,rep3]},{{2,3}}];];
];

(* Normalize the invariants *)
coefs=result /. {Plus ->List,a[__]->1,b[__]->1,c[__]->1};
Do[
If[Length[coefs[[i]]]==0,coefs[[i]]={coefs[[i]]}];
result[[i]]=Expand[Sqrt[Sqrt[DimR[cm,rep1] DimR[cm,rep2]DimR[cm,rep3]] /coefs[[i]].Conjugate[coefs[[i]]]] result[[i]]];
,{i,Length[coefs]}];
(* /Normalize the invariants *)

,result={}];


(* Special treatment - This code ensures that well known cases come out in the expected form *)


(* Two SU(2) doublets and a singlet no conjugation on the doublets ... fix the sign *)
If[cm==SU2&&Sort[{rep1,rep2,rep3}]=={{0},{1},{1}}&&(!conj||rep3=={0}), result=-result]; 

(* /Special treatment *)

Return[result];
]

(* SymmetrizeAux and SymmetrizeInvariants are auxiliar methods to InvariantsBaseMethod[cm,rep1,rep2,rep3]; They are used to make sure the result is (anti)symmetric *)
SymmetrizeAux[expression_,vars_]:=Module[{aux,res1,res2,permutations,rules,signs},
res1=res2=0;

permutations=Permutations[vars];
rules=MapThread[Rule,{vars,#}]&/@permutations;
signs=(Signature/@permutations )/Signature[vars];

aux=expression/.rules;

res1=Plus@@aux;
res2=signs.aux;
Return[Expand[{res1,res2}]];

]

SymmetrizeInvariants[invariants_,dimReps_,pos_]:=Module[{i,j,nReps,vars,fieldComponents,aux,aux2,dimRepsCom},
nReps=Length[dimReps];
aux=invariants;

Do[
vars=(ToExpression[FromCharacterCode[96+#]]&/@pos[[i]]);

aux=Flatten[SymmetrizeAux[#,vars]& /@aux];

aux=DeleteCases[aux,0];
,{i,Length[pos]}];

(* Maybe the 1 and 1' irreps of the symmetry group Sn are insufficient *)
If[Length[aux]!=Length[invariants],Return[invariants]];


fieldComponents=Table[Array[ToExpression[FromCharacterCode[96+i]],dimReps[[i]]],{i,nReps}];
fieldComponents=Flatten[fieldComponents];
aux=CoefficientArrays[#,fieldComponents][[nReps+1]]&/@aux;

dimRepsCom=Table[Sum[dimReps[[j]],{j,i-1}],{i,nReps}];
aux2=Table[1+dimRepsCom[[i]];;dimRepsCom[[i]]+dimReps[[i]],{i,nReps}];
aux=Table[(Part[aux[[j]],##])&@@aux2,{j,Length[aux]}];
aux=SparseArray[Flatten/@aux];
aux2={aux[[1]]};

Do[
If[MatrixRank[Append[aux2,aux[[i]]]]>MatrixRank[aux2],AppendTo[aux2,aux[[i]]]];
,{i,Length[aux]}];

aux=InverseFlatten[#,dimReps]&/@aux2;

fieldComponents=Reverse[Table[Array[ToExpression[FromCharacterCode[96+i]],dimReps[[i]]],{i,nReps}]];
aux=Dot[aux,##]&@@fieldComponents;

Return[Expand[aux]];
]

(* If x is a nested list then x=InverseFlatten[Flatten[x],Dimensions[x]] *)
InverseFlatten[flattenedList_,dims_]:=Fold[Partition[#,#2]&,flattenedList,Most[Reverse[dims]]];



(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX ANOMALIES XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Check if a model is anomally free or not *)
TriangularAnomalyCheck[groups_,reps_,nF_:Null]:=Module[{nFlavours,posU1s,posSUNs,dimRepsNFlavs,dynkins,n,sigmas,aux,result},

(* If no number of flavours were given assume that they are all =1 *)
nFlavours=If[nF===Null,ConstantArray[1,Length[reps]],nF];

result=True;
posU1s=Position[groups,{},{1}]//Flatten;
posSUNs=Position[groups,x_/;Length[x]>1&&x===CartanMatrix["A",Length[x]],{1}]//Flatten;

dimRepsNFlavs=Apply[Times,DimR[groups,#]&/@reps,{1}] nFlavours;
dynkins=dimRepsNFlavs(DynkinIndex[groups,#]/DimR[groups,#]&/@reps);

(* Y^3 cases and T T Y cases *)
Do[
aux=Total[dynkins reps[[All,i]]];
result=result&&(aux==0aux);
,{i,posU1s}];

(* TTT cases - see "Gauge groups without triangular anomaly", Susumu Okubo, 1977 *)
Do[
n=Length[groups[[i]]]+1;
sigmas=Prepend[Accumulate[#],0]&/@reps[[All,i]];
sigmas=sigmas+1/2(n+1)-ConstantArray[Range[n],Length[reps]]-1/n Total[sigmas,{2}];
aux=Total[dimRepsNFlavs n/((n^2-1)(n^2-4))sigmas^3,2];
result=result&&(aux==0);
,{i,posSUNs}];
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* For 1 field/representation this method gives a list which, when summed for all the representations in a model (note: including flavour multiplicity), must be the {0,0,...} list *)
TriangularAnomalyValue[groups_,rep_]:=Module[{posU1s,posSUNs,dimRep,dynkins,n,sigmas,aux,part1,part2,result},

posU1s=Position[groups,{},{1}]//Flatten;
posSUNs=Position[groups,x_/;Length[x]>1&&x===CartanMatrix["A",Length[x]],{1}]//Flatten;

dimRep=Times@@DimR[groups,rep] ;
dynkins=dimRep DynkinIndex[groups,rep]/DimR[groups,rep];

(* Y^3 cases and T T Y cases *)
result={};
Do[
aux=dynkins rep[[i]];
AppendTo[result,aux];
,{i,posU1s}];

(* TTT cases - see "Gauge groups without triangular anomaly", Susumu Okubo, 1977 *)
Do[
n=Length[groups[[i]]]+1;
sigmas=-Prepend[Accumulate[rep[[i]]],0];
sigmas=sigmas+1/2(n+1)-Range[n]-1/n Total[sigmas];
aux=Total[dimRep n/((n^2-1)(n^2-4))sigmas^3];
AppendTo[result,aux];
,{i,posSUNs}];

result=Flatten[result];
Return[result];
]


(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX LISTING ALL REPS UP TO SOME SIZE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* For a simple group, this method calculates all the representations up to a given size maxDim *)
RepsUpToDimN[group_,maxDim_]:=RepsUpToDimNAuxilarMethod[group,ConstantArray[0,Length[group]],1,maxDim,{}]

(* Same as RepsUpToDimN but returns only one representation for each pair of conjugate representations *)
RepsUpToDimNNoConjugates[group_,maxDim_]:=DeleteDuplicates[RepsUpToDimN[group,maxDim],#1==#2||#1==ConjugateIrrep[group,#2]&]

(* This is a recursive auxiliar method used by RepsUpToDimN and is not meant to be used directly *)
RepsUpToDimNAuxilarMethod[group_,w_,digit_,max_,results_]:=Module[{wAux,newResult},
wAux=w;
wAux[[digit]]=0;
newResult=results;
(* If it is a leaf ... *)
If[digit==Length[w],
While[DimR[group,wAux]<=max,
AppendTo[newResult,wAux];
wAux[[digit]]++;
];,
While[DimR[group,wAux]<=max,
newResult=RepsUpToDimNAuxilarMethod[group,wAux,digit+1,max,newResult];
wAux[[digit]]++;
];
];
Return[newResult];
]


(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXX THE SYMMETRY TO TENSOR PRODUCTS - PLESTHYSM XXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Hook length formula for the dimension of the Sn representations. Should be the same as SnClassCharacter[partition,ConstantArray[1,Total[partition]]] *)
SnIrrepDim[partition_]:=Module[{n1,n2,inverseP,result},
n1=partition[[1]];
n2=Length[partition];
inverseP=Count[partition,x_/;x>=#]&/@Range[n1];
result=Table[Max[partition[[j]]+inverseP[[i]]-(j-1)-(i-1)-1,1],{i,n1},{j,n2}];
result=Total[partition]!/(Times@@Flatten[result]);
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* This method decomposes the product of a list of Sn representations into its irreducible parts *)
DecomposeSnProduct[partitionsList_]:=Module[{n,characterTable,aux,result},
(* must be the same as for all partitions in partitionsList *)
n=Total[partitionsList[[1]]]; 
result=1/n!Table[Sum[SnClassOrder[i]Product[SnClassCharacter[inputPartition,i],{inputPartition,partitionsList}]SnClassCharacter[j,i],{i,IntegerPartitions[n]}],{j,IntegerPartitions[n]}];
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* See arXiv:math/0309225v1[math.CO] - this is an auxiliar method to calculate SnClassCharacter *)
(* Note: a partitition is a list of non-increasing positive integers - see http://en.wikipedia.org/wiki/Young_tableau *)
PartitionSequence[partition_]:=Module[{sequence},
sequence=ConstantArray[1,partition[[-1]]];
AppendTo[sequence,0];
Do[
sequence=Join[sequence,ConstantArray[1,partition[[-i]]-partition[[-i+1]]]];
AppendTo[sequence,0];
,{i,2,Length[partition]}];
Return[sequence];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* See arXiv:math/0309225v1[math.CO] - this is an auxiliar method to calculate SnClassCharacter *)
(* This method finds all the rim hooks \[Xi] with length l and returns a list with all the possibilities {partition\\[Xi], leg length of rim hook \[Xi]} which is writen as {partition\\[Xi],ll(\[Xi])}*)
RimHooks[partition_,l_]:=Module[{seqMinusHook,sequence,length,result},
sequence=PartitionSequence[partition];
result={};

Do[
If[sequence[[i]]==1&&sequence[[i+l]]==0,

seqMinusHook=sequence;seqMinusHook[[i]]=0;seqMinusHook[[i+l]]=1;
length=Count[sequence[[i;;i+l]],0]-1;
AppendTo[result,{RebuiltPartitionFromSequence[seqMinusHook],length}];
];

,{i,Length[sequence]-l}];
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* See arXiv:math/0309225v1[math.CO] - this is an auxiliar method to calculate SnClassCharacter *)
(* RebuiltPartitionFromSequence[PartitionSequence[partition]]=partition *)
RebuiltPartitionFromSequence[sequence_]:=Module[{start,end,validSequence,counter1s,result},
counter1s=0;result={};
Do[
If[sequence[[i]]==0,
PrependTo[result,counter1s];
,
counter1s++;
];

,{i,Length[sequence]}];
Return[DeleteCases[result,0]];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* See arXiv:math/0309225v1[math.CO] for the way to compute SnClassCharacter from the Murnaghan-Nakayama rule  *)
(* \[Lambda] is the representation; \[Mu] is the conjugacy class. This method computes the character of conjugacy class \mu in the irreducible representation \[Lambda]  *)
SnClassCharacter[partition\[Lambda]_,partition\[Mu]_]:=SnClassCharacter[partition\[Lambda],partition\[Mu]]=Module[{new\[Lambda]s,new\[Mu],n,result},

If[Length[partition\[Lambda]]==0,Return[1]];

n=Total[partition\[Lambda]];
If[n!=Total[partition\[Mu]],Return["Error in SnClassCharacter function: both partitions must be of the same order."]];

new\[Lambda]s=RimHooks[partition\[Lambda],partition\[Mu][[1]]];
new\[Mu]=partition\[Mu][[2;;-1]];

result=Sum[(-1)^new\[Lambda]s[[i,2]] SnClassCharacter[new\[Lambda]s[[i,1]],new\[Mu]],{i,Length[new\[Lambda]s]}];

Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* Reference: Unless otherwise stated, the reference for the code below was the Lie Manual available in http://www-math.univ-poitiers.fr/~maavl/LiE/ *)

(* Size of a given conjugacy class of Sn. The formula is easy but see for example "Enumerative Combinatorics", Richard P.Stanley, http://math.mit.edu/~rstan/ec/ec1.pdf, 1.3.2 Proposition *)
SnClassOrder[partition_]:=SnClassOrder[partition]=Module[{aux,n,result},
n=Total[partition];
aux=Tally[partition];
result=n!/Product[aux[[i,1]]^aux[[i,2]] aux[[i,2]]!,{i,Length[aux]}];
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

VDecomp[cm_,dominantWeight_]:=Module[{result},
result=AltDom[cm,WeylOrbit[cm,dominantWeight]];
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

AltDom[cm_,weights_,weylWord_]:=Module[{cmInv,matD,cmID,aux,prov,result},
prov={#,1}&/@weights;


Do[
(* aux=SimpleProduct[prov[[j]],cm[[i]],cmID]; *)
If[prov[[j,2]]!=0,
Which[prov[[j,1,weylWord[[i]]]]>=0,Null,
prov[[j,1,weylWord[[i]]]]==-1,prov[[j,2]]=0,
prov[[j,1,weylWord[[i]]]]<=-2,prov[[j,2]]=-prov[[j,2]];prov[[j,1]]=prov[[j,1]]-(prov[[j,1,weylWord[[i]]]]+1)cm[[weylWord[[i]]]];

];

];

,{i,Length[weylWord]},{j,Length[prov]}];
prov=DeleteCases[prov,x_/;x[[2]]==0];

Return[prov];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

AltDom[cm_,weights_]:=AltDom[cm,weights,LongestWeylWord[cm]]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

Adams[cm_,n_,rep_]:=Module[{aux,result},
aux=DominantWeights[cm,rep];
aux={#[[1]] n,#[[2]]}&/@aux;

result=Table[{VDecomp[cm,aux[[i,1]]],aux[[i,2]]},{i,Length[aux]}];
result=Table[{result[[i,1,j,1]],result[[i,1,j,2]]result[[i,2]]},{i,Length[result]},{j,Length[result[[i,1]]]}];
result=Flatten[result,1];
Return[result];
]
(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

Plethysms[cm_,weight_,partition_]:=Plethysms[cm,weight,partition]=Module[{n,kList,aux,aux1,aux2,factor,sum},

n=Plus@@partition;

(* If group = U1 *)
If[cm===U1,
Return[If[Length[partition]==1,{{n weight,1}},{}]];
];

kList=IntegerPartitions[n];
sum={};

Do[
factor=1/n!SnClassOrder[kList[[i]]]SnClassCharacter[partition,kList[[i]]];

aux=Adams[cm,#,weight]&/@kList[[i]];

aux=ReduceRepPolyProduct[cm,aux];
aux={#[[1]],factor #[[2]]}&/@aux;

AppendTo[sum,aux];
,{i,Length[kList]}];

sum=GatherWeights[sum];
Return[sum];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

InvariantPlethysms[cm_,weight_,partition_]:=InvariantPlethysms[cm,weight,partition]=Module[{n,kList,aux,aux1,aux2,factor,sum},
n=Plus@@partition;
kList=IntegerPartitions[n];
sum=0;

(* If group = U1 *)
If[cm===U1,
Return[If[Length[partition]==1&&weight==0,1,0]];
];

Do[
factor=1/n!SnClassOrder[kList[[i]]]SnClassCharacter[partition,kList[[i]]];
aux=Adams[cm,#,weight]&/@kList[[i]];
aux=NumberOfInvariantsInProduct[cm,aux];
sum=sum+factor aux;

,{i,Length[kList]}];

Return[sum];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

GatherWeights[listW_]:=Module[{aux},
aux=Flatten[listW,1];
aux=Gather[aux,#1[[1]]==#2[[1]]&];

aux={#[[1,1]],Plus@@#[[1;;-1,2]]}&/@aux;
aux=DeleteCases[aux,x_/;x[[2]]==0];

Return[aux];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

GatherWeights[listW_,listMult_]:=Module[{aux},
aux=Table[{#[[1]],listMult[[i]]#[[2]]}&/@listW[[i]],{i,Length[listW]}];
aux=Flatten[aux,1];
aux=Gather[aux,#1[[1]]==#2[[1]]&];

aux={#[[1,1]],Plus@@#[[1;;-1,2]]}&/@aux;
aux=DeleteCases[aux,x_/;x[[2]]==0];
Return[aux];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* This method calculates the decompositions of a product of sums of irreps: (R11+R12+R13+...) x (R21+R22+R23+...) x ... *)
(* polyList = list of lists of representations to be multiplied. The method outputs the decomposition of such a product *)
ReduceRepPolyProduct[cm_,polyList_]:=Module[{n,aux,aux2},

n=Length[polyList];
aux=polyList[[1]];
If[n<=1,Return[aux]];
Do[
aux=Tuples[{aux,polyList[[i+1]]}];

aux2=ReduceRepProduct[cm,#[[1;;2,1]]]&/@aux;

aux=GatherWeights[aux2,#[[1,2]]#[[2,2]]&/@aux];
,{i,n-1}];

Return[aux];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* This method is similar to ReduceRepPolyProduct but it only cares about the number of invariants in product. That is its output *)
NumberOfInvariantsInProduct[cm_,polyList_]:=Module[{n,aux,aux2,invariantRep,list1,list2},
invariantRep=ConstantArray[0,Length[cm]];
n=Length[polyList];

(* If there is no product, just find the number of invariants in polyList[[1]] and return *)
If[n==1,
aux=Cases[polyList[[1]],x_/;x[[1]]==0x[[1]]:>x[[2]]];
Return[Total[aux]];
];

(* If theres is more than one factor list in polyList, break polyList in two parts with abou the same length  *)
(* E.g.: if Length[polyList]=2 then Length[list1]=Length[list2]=1; If Length[polyList]=3 then Length[list1]=1 and Length[list2]=2. *)
(* Conjugate the irreps in the first part (list1) and match then to irreps in second part (list2) - those form invariants *)
list1=ReduceRepPolyProduct[cm,polyList[[1;;Floor[n/2] ]]];
list2=ReduceRepPolyProduct[cm,polyList[[Floor[n/2]+1;;-1]]];
list1={ConjugateIrrep[cm,#[[1]]],#[[2]]}&/@list1;

aux=(Cases[list2,x_/;x[[1]]==#[[1]]:>x[[2]]]&/@list1);
aux=Total[Flatten[list1[[All,2]]aux]];

Return[aux];
]




(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)
(* TuplesWithMultiplicity, TallyWithMultiplicity, PermutationSymmetryOfTensorProductPartsAuxiliar, PermutationSymmetryOfTensorProductParts, PermutationSymmetryOfInvariants *)
(* These are functions related to the symmetry of invariants  which are more ready to use when building a Lagrangian: they deal with products of different representations and the group can be semisimple *)

(* E.g.: TuplesWithMultiplicity[{{{X1,1},{X2,2}},{{Y1,10}},{{Z1,\[Pi]},{Z2,-\[Pi]}}}] = {{{X1,Y1,Z1},10 \[Pi]},{{X1,Y1,Z2},-10 \[Pi]},{{X2,Y1,Z1},20 \[Pi]},{{X2,Y1,Z2},-20 \[Pi]}} *)
TuplesWithMultiplicity[listOflists_]:=Module[{aux1,aux2,result},
aux1=Tuples[listOflists];
aux2=Times@@@aux1[[All,All,2]];
aux1=aux1[[All,All,1]];
result=MapThread[List,{aux1,aux2}];
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* E.g.: TallyWithMultiplicity[{{X,1},{X,10},{Y,2},{Z,1},{X,2}}] = {{X,13},{Y,2},{Z,1}} *)
TallyWithMultiplicity[listOflists_]:=Module[{aux1,aux2,result},
aux1=Gather[listOflists,#1[[1]]==#2[[1]]&];
aux2=Plus@@@(aux1[[All,All,2]]);
aux1=aux1[[All,1,1]];
result=MapThread[List,{aux1,aux2}];
Return[result];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Base method for PermutationSymmetryOfTensorProductParts *)
PermutationSymmetryOfTensorProductPartsAuxiliar[group_,rep_,n_]:=Module[{aux,snPart,intPartitionsN,result},
intPartitionsN=IntegerPartitions[n];
aux=Tuples[intPartitionsN,Length[group]];
snPart=DecomposeSnProduct/@aux;
aux=Table[Plethysms[group[[j]],rep[[j]],i[[j]]],{i,aux},{j,Length[i]}];
aux=TuplesWithMultiplicity/@aux;
aux=Table[{{aux[[i,j,1]],intPartitionsN[[k]]},aux[[i,j,2]]snPart[[i,k]]},{i,Length[aux]},{j,Length[aux[[i]]]},{k,Length[intPartitionsN]}];
aux=DeleteCases[Flatten[aux,2],x_/;x[[-1]]==0];
result=TallyWithMultiplicity[aux];
Return[result];
];

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* This calculates the Plethysms in a tensor product of different fields/representations *)
PermutationSymmetryOfTensorProductParts[group_,listOfReps_]:=Module[{aux1,aux2,aux3,plesthysmFields},
aux1=Tally[listOfReps];
plesthysmFields=Flatten[Position[listOfReps,#]]&/@aux1[[All,1]];

aux2=Table[PermutationSymmetryOfTensorProductPartsAuxiliar[group,aux1[[i,1]],aux1[[i,2]]],{i,Length[aux1]}];
aux2=TuplesWithMultiplicity[aux2];
aux3=Table[ReduceRepProduct[group,i[[1,All,1]]],{i,aux2}];
aux3=Table[{{aux3[[i,j,1]],aux2[[i,1,All,2]]},aux3[[i,j,2]]aux2[[i,2]]},{i,Length[aux3]},{j,Length[aux3[[i]]]}];
aux3=TallyWithMultiplicity[Flatten[aux3,1]];
Return[{plesthysmFields,aux3}];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* This returns only the invariant plesthysms in a tensor product of different fields/representations *)
(* Output is: {A,B,C} where A = groups os representations (by index) which are equal; B = list with the Sn reps of these groups of representations; C = multiplicity of the invariant *)
PermutationSymmetryOfInvariants[group_,listOfReps_]:=Module[{indices,invariants},
{indices,invariants}=PermutationSymmetryOfTensorProductParts[group,listOfReps];
invariants=DeleteCases[invariants,x_/;x[[1,1]]0!=x[[1,1]]];
invariants=Table[{i[[1,2]],i[[2]]},{i,invariants}];
Return[{indices,invariants}];
]

(* XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX *)

(* Hook-content formula: counts the number of semi-standard Young tableaux of shape given by partition and with the cells filled with the numbers 1,...,n *)
HookContentFormula[partition_,nMax_]:=Module[{n1,n2,inverseP,hookLengths,content,result,aux},
n1=partition[[1]];
n2=Length[partition];
inverseP=Count[partition,x_/;x>=#]&/@Range[n1];

aux=Table[If[partition[[j]]+inverseP[[i]]-(j-1)-(i-1)-1>0,(nMax+i-j)/(partition[[j]]+inverseP[[i]]-(j-1)-(i-1)-1),1],{i,n1},{j,n2}];
result=Times@@Flatten[aux];
Return[result];
]


End[];
EndPackage[];
