(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20937,        714]
NotebookOptionsPosition[     17279,        595]
NotebookOutlinePosition[     18883,        640]
CellTagsIndexPosition[     18798,        635]
WindowTitle->TriangularAnomalyValue - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Phys.Rev. D6 (1972) 429\"\>":>
       Documentation`HelpLookup[
        If[
         StringMatchQ[{
           URL["http://dx.doi.org/10.1103/PhysRevD.6.429"], None}, "paclet*"], 
         Part[
          Part[{{"Phys.Rev. D6 (1972) 429", {
              URL["http://dx.doi.org/10.1103/PhysRevD.6.429"], None}}}, 1], 
          2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"Phys.Rev. D6 (1972) 429", {
               URL["http://dx.doi.org/10.1103/PhysRevD.6.429"], None}}}, 1], 
           2]]]]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/TriangularAnomalyValue\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/TriangularAnomalyValue"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
TriangularAnomalyValue.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/TriangularAnomalyValue", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["TriangularAnomalyValue", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TriangularAnomalyValue", "[", 
       RowBox[{"group", ",", "representation"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]Contribution to gauge anomalies from a given ",
     Cell[BoxData["representation"], "InlineFormula"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->751845745],

Cell[TextData[{
 Cell[BoxData["group"], "InlineFormula"],
 " should be a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Each representation ",
 Cell[BoxData["rep"], "InlineFormula"],
 " should be a list of non-negative integers (Dynkin coefficients)."
}], "Notes",
 CellID->125196071],

Cell[TextData[{
 "The output of this functions is a list of anomaly values. Assuming a gauge \
group ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["G", "1"], "x", " ", 
   SubscriptBox["G", "2"], "x", " ", "\[CenterEllipsis]"}]], "InlineFormula"],
 ", where some of the ",
 Cell[BoxData[
  SubscriptBox["G", "i"]], "InlineFormula"],
 " are U(1)'s and/or SU(n)'s, then the output is the anomalies associated to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"U", 
    RowBox[{"(", "1", ")"}], 
    SuperscriptBox[
     SubscriptBox["G", "1"], "2"]}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"U", 
   RowBox[{"(", "1", ")"}], 
   SuperscriptBox[
    SubscriptBox["G", "2"], "2"]}]], "InlineFormula"],
 ", \[CenterEllipsis], ",
 Cell[BoxData[
  RowBox[{"U", 
   RowBox[{
    RowBox[{"(", "1", ")"}], "'"}], 
   SuperscriptBox[
    SubscriptBox["G", "1"], "2"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"U", 
   RowBox[{
    RowBox[{"(", "1", ")"}], "'"}], 
   SuperscriptBox[
    SubscriptBox["G", "2"], "2"]}]], "InlineFormula"],
 ", \[CenterEllipsis], ",
 Cell[BoxData[
  RowBox[{"U", 
   RowBox[{
    RowBox[{"(", "1", ")"}], "''"}], 
   SuperscriptBox[
    SubscriptBox["G", "1"], "2"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"U", 
   RowBox[{
    RowBox[{"(", "1", ")"}], "''"}], 
   SuperscriptBox[
    SubscriptBox["G", "2"], "2"]}]], "InlineFormula"],
 ",  \[CenterEllipsis], ",
 Cell[BoxData[
  RowBox[{"SU", 
   SuperscriptBox[
    RowBox[{"(", "n", ")"}], "3"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"SU", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"n", "'"}], ")"}], "3"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"SU", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"n", "''"}], ")"}], "3"]}]], "InlineFormula"],
 ", \[CenterEllipsis]}."
}], "Notes",
 CellID->205761631],

Cell["\<\
In a gauge anomaly free theory, the sum of the triangular anomaly values of \
all representations (taking into account the number of flavors of each) adds \
up to zero.\
\>", "Notes",
 CellID->19148277]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->106233826],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->588480501],

Cell[TextData[{
 "Contribution of one generation of left-handed quarks (Q) to the gauge \
anomalies {",
 Cell[BoxData[
  RowBox[{"U", 
   SuperscriptBox[
    RowBox[{"(", "1", ")"}], "3"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"U", 
   RowBox[{"(", "1", ")"}], "\[Times]", "SU", 
   SuperscriptBox[
    RowBox[{"(", "2", ")"}], "2"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"U", 
   RowBox[{"(", "1", ")"}], "\[Times]", "SU", 
   SuperscriptBox[
    RowBox[{"(", "3", ")"}], "2"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"SU", 
   SuperscriptBox[
    RowBox[{"(", "3", ")"}], "3"]}]], "InlineFormula"],
 "}:"
}], "ExampleText",
 CellID->283112903],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "6"}], " ", ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TriangularAnomalyValue", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"U1", ",", "SU2", ",", "SU3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "6"}], " ", ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->473091279],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "36"], ",", 
   FractionBox["1", "4"], ",", 
   FractionBox["1", "6"], ",", 
   RowBox[{"-", 
    FractionBox["1", "10"]}]}], "}"}]], "Output",
 ImageSize->{118, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26536736]
}, Open  ]],

Cell["\<\
Summing all contributions from the MSSM fields (taking into account the \
flavor multiplicity of each one), there is no gauge anomalies:\
\>", "ExampleText",
 CellID->34514],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], "/", "3"}], " ", ",", 
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "3"}], " ", ",", 
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "6"}], " ", ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], " ", ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hu", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], " ", ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Hd", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], " ", ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<Gauge anomalies {\!\(\*SuperscriptBox[\(U1\), \(3\)]\), \
U1\[Times]\!\(\*SuperscriptBox[\(SU2\), \(2\)]\), \
U1\[Times]\!\(\*SuperscriptBox[\(SU3\), \(2\)]\), \
\!\(\*SuperscriptBox[\(SU3\), \(3\)]\)}:\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "1", ",", "1"}], 
   "}"}], ".", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"TriangularAnomalyValue", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"U1", ",", "SU2", ",", "SU3"}], "}"}], ",", "#"}], "]"}], 
     "&"}], "/@", 
    RowBox[{"{", 
     RowBox[{
     "u", ",", "d", ",", "Q", ",", "e", ",", "L", ",", "Hu", ",", "Hd"}], 
     "}"}]}], ")"}]}], "\[IndentingNewLine]"}], "Input",
 CellLabel->"In[2]:=",
 CellID->101047489],

Cell[BoxData["\<\"Gauge anomalies {\\!\\(\\*SuperscriptBox[\\(U1\\), \\(3\\)]\
\\), U1\[Times]\\!\\(\\*SuperscriptBox[\\(SU2\\), \\(2\\)]\\), \
U1\[Times]\\!\\(\\*SuperscriptBox[\\(SU3\\), \\(2\\)]\\), \
\\!\\(\\*SuperscriptBox[\\(SU3\\), \\(3\\)]\\)}:\"\>"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->55367056],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->372984614]
}, Open  ]],

Cell[TextData[{
 "In general, with ",
 Cell[BoxData[
  SubscriptBox["n", "Hu"]], "InlineFormula"],
 " (",
 Cell[BoxData[
  SubscriptBox["n", "Hd"]], "InlineFormula"],
 ") Higgs doublets Hu (Hd) one can see that anomaly cancellation requires  ",
 Cell[BoxData[
  SubscriptBox["n", "Hu"]], "InlineFormula"],
 "= ",
 Cell[BoxData[
  SubscriptBox["n", "Hd"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->415445203],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<Gauge anomalies {\!\(\*SuperscriptBox[\(U1\), \(3\)]\), \
U1\[Times]\!\(\*SuperscriptBox[\(SU2\), \(2\)]\), \
U1\[Times]\!\(\*SuperscriptBox[\(SU3\), \(2\)]\), \
\!\(\*SuperscriptBox[\(SU3\), \(3\)]\)}:\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
    SubscriptBox["n", "\"\<Hu\>\""], ",", 
    SubscriptBox["n", "\"\<Hd\>\""]}], "}"}], ".", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"TriangularAnomalyValue", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"U1", ",", "SU2", ",", "SU3"}], "}"}], ",", "#"}], "]"}], 
     "&"}], "/@", 
    RowBox[{"{", 
     RowBox[{
     "u", ",", "d", ",", "Q", ",", "e", ",", "L", ",", "Hu", ",", "Hd"}], 
     "}"}]}], ")"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->98461483],

Cell[BoxData["\<\"Gauge anomalies {\\!\\(\\*SuperscriptBox[\\(U1\\), \\(3\\)]\
\\), U1\[Times]\\!\\(\\*SuperscriptBox[\\(SU2\\), \\(2\\)]\\), \
U1\[Times]\\!\\(\\*SuperscriptBox[\\(SU3\\), \\(2\\)]\\), \
\\!\\(\\*SuperscriptBox[\\(SU3\\), \\(3\\)]\\)}:\"\>"], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->554207185],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SubscriptBox["n", "\<\"Hd\"\>"], "4"]}], "+", 
    FractionBox[
     SubscriptBox["n", "\<\"Hu\"\>"], "4"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SubscriptBox["n", "\<\"Hd\"\>"], "4"]}], "+", 
    FractionBox[
     SubscriptBox["n", "\<\"Hu\"\>"], "4"]}], ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{196, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->510937307]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 "H. Georgi and S. L. Glashow, ",
 StyleBox[ButtonBox["Phys.Rev. D6 (1972) 429",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://dx.doi.org/10.1103/PhysRevD.6.429"], None}],
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->929782353],

Cell[TextData[{
 "S. Okubo, ",
 StyleBox[ButtonBox["Phys.Rev. D16 (1977) 3528",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://link.aps.org/doi/10.1103/PhysRevD.16.3528"], None}],
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->87449871],

Cell[BoxData[Cell[BoxData[
  ButtonBox["",
   BaseStyle->"Link"]], "InlineFormula"]], "SeeAlso",
 CellID->772792248]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TriangularAnomalyValue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2013, 8, 7, 2, 29, 29.0312500}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "TriangularAnomalyValue[group, representation] Contribution to gauge \
anomalies from a given representation", "synonyms" -> {}, "title" -> 
    "TriangularAnomalyValue", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/TriangularAnomalyValue"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7602, 245, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->106233826]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18655, 628}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[603, 21, 76, 1, 70, "SymbolColorBar"],
Cell[682, 24, 178, 5, 70, "LinkTrail"],
Cell[863, 31, 3026, 71, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3914, 106, 65, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[3982, 109, 493, 13, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4512, 127, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->751845745],
Cell[5095, 146, 212, 8, 70, "Notes",
 CellID->1067943069],
Cell[5310, 156, 182, 5, 70, "Notes",
 CellID->125196071],
Cell[5495, 163, 1855, 70, 70, "Notes",
 CellID->205761631],
Cell[7353, 235, 212, 5, 70, "Notes",
 CellID->19148277]
}, Closed]],
Cell[CellGroupData[{
Cell[7602, 245, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->106233826],
Cell[CellGroupData[{
Cell[8088, 262, 148, 5, 70, "ExampleSection",
 CellID->588480501],
Cell[8239, 269, 688, 26, 70, "ExampleText",
 CellID->283112903],
Cell[CellGroupData[{
Cell[8952, 299, 613, 20, 70, "Input",
 CellID->473091279],
Cell[9568, 321, 333, 12, 53, "Output",
 CellID->26536736]
}, Open  ]],
Cell[9916, 336, 183, 4, 70, "ExampleText",
 CellID->34514],
Cell[CellGroupData[{
Cell[10124, 344, 2597, 86, 70, "Input",
 CellID->101047489],
Cell[12724, 432, 331, 5, 70, "Print",
 CellID->55367056],
Cell[13058, 439, 223, 7, 36, "Output",
 CellID->372984614]
}, Open  ]],
Cell[13296, 449, 417, 15, 70, "ExampleText",
 CellID->415445203],
Cell[CellGroupData[{
Cell[13738, 468, 892, 27, 70, "Input",
 CellID->98461483],
Cell[14633, 497, 333, 5, 70, "Print",
 CellID->554207185],
Cell[14969, 504, 547, 20, 51, "Output",
 CellID->510937307]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15577, 531, 417, 12, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[15997, 545, 259, 8, 70, "SeeAlso",
 CellID->929782353],
Cell[16259, 555, 249, 8, 70, "SeeAlso",
 CellID->87449871],
Cell[16511, 565, 116, 3, 70, "SeeAlso",
 CellID->772792248]
}, Open  ]],
Cell[CellGroupData[{
Cell[16664, 573, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[17086, 587, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[17252, 593, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

