(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11971,        395]
NotebookOptionsPosition[      9040,        301]
NotebookOutlinePosition[     10586,        345]
CellTagsIndexPosition[     10501,        340]
WindowTitle->SnIrrepDim - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/SnIrrepDim\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/SnIrrepDim"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
SnIrrepDim.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/SnIrrepDim", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["SnIrrepDim", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SnIrrepDim", "[", "representation", "]"}]], "InlineFormula"],
     " \[LineSeparator]Calculates the dimension of a representation of the ",
     Cell[BoxData[
      SubscriptBox["S", "n"]], "InlineFormula"],
     " group"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->418981419],

Cell[TextData[{
 Cell[BoxData["representation"], "InlineFormula"],
 " must be a partition of some integer n, as irreducible representations of  ",
 Cell[BoxData[
  SubscriptBox["S", "n"]], "InlineFormula"],
 " are specified in this way;"
}], "Notes",
 CellID->613073599],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SnIrrepDim", "[", "representation", "]"}]], "InlineFormula"],
 " gives the same result as ",
 Cell[BoxData[
  RowBox[{"SnClassCharacter", "[", 
   RowBox[{"representation", ",", " ", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", " ", "1", ",", " ", "\[CenterEllipsis]", ",", " ", "1"}], 
     "}"}]}], "]"}]], "InlineFormula"],
 ", even though the calculations performed are different (",
 Cell[BoxData["SnIrrepDim"], "InlineFormula"],
 " uses the  Hook length formula)."
}], "Notes",
 CellID->182112945]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->672260082],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->452687101],

Cell[TextData[{
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula"],
 " has 3 irreducible representations: {3}, {2,1}, {1,1,1}. Their dimensions \
are the following:"
}], "ExampleText",
 CellID->32979335],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SnIrrepDim", "[", 
  RowBox[{"{", "3", "}"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SnIrrepDim", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SnIrrepDim", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->298933796],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180858793],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20287095],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->390033598]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->26828648]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HookContentFormula",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/HookContentFormula"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["DecomposeSnProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/DecomposeSnProduct"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["SnClassCharacter",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/SnClassCharacter"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["SnClassOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/SnClassOrder"]], "InlineFormula"]
}], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SnIrrepDim - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2013, 8, 7, 2, 29, 23.9218750}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "SnIrrepDim[representation] Calculates the dimension of a representation \
of the S_n group", "synonyms" -> {}, "title" -> "SnIrrepDim", "type" -> 
    "Symbol", "uri" -> "Susyno/ref/SnIrrepDim"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5200, 158, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->672260082]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10358, 333}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[591, 21, 76, 1, 70, "SymbolColorBar"],
Cell[670, 24, 178, 5, 70, "LinkTrail"],
Cell[851, 31, 2306, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3182, 88, 53, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[3238, 91, 484, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3759, 110, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->418981419],
Cell[4342, 129, 270, 7, 70, "Notes",
 CellID->613073599],
Cell[4615, 138, 548, 15, 70, "Notes",
 CellID->182112945]
}, Closed]],
Cell[CellGroupData[{
Cell[5200, 158, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->672260082],
Cell[CellGroupData[{
Cell[5686, 175, 148, 5, 70, "ExampleSection",
 CellID->452687101],
Cell[5837, 182, 211, 6, 70, "ExampleText",
 CellID->32979335],
Cell[CellGroupData[{
Cell[6073, 192, 363, 10, 70, "Input",
 CellID->298933796],
Cell[6439, 204, 158, 5, 36, "Output",
 CellID->180858793],
Cell[6600, 211, 157, 5, 36, "Output",
 CellID->20287095],
Cell[6760, 218, 158, 5, 36, "Output",
 CellID->390033598]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6979, 230, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[7401, 244, 150, 3, 70, "Tutorials",
 CellID->26828648]
}, Open  ]],
Cell[CellGroupData[{
Cell[7588, 252, 427, 12, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[8018, 266, 980, 30, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[9013, 299, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

