(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43366,       1526]
NotebookOptionsPosition[     36346,       1286]
NotebookOutlinePosition[     38058,       1334]
CellTagsIndexPosition[     37972,       1329]
WindowTitle->ReduceRepProduct - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"DimR\"\>":>Documentation`HelpLookup[
       "paclet:Susyno/ref/DimR"], \
"\<\"PermutationSymmetryOfTensorProductParts\"\>":>Documentation`HelpLookup[
       "paclet:Susyno/ref/PermutationSymmetryOfTensorProductParts"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {
       RowBox[{
        RowBox[{"{", "}"}], "\[LeftDoubleBracket]", "1", 
        "\[RightDoubleBracket]"}]:>Documentation`HelpLookup[
        If[
         StringMatchQ[
          Part[{}, 2], "paclet*"], 
         Part[
          
          Part[{{}, {
            "D.M. Snow, ACM Trans. Math. Softw. 16 (1990) 94ACM Trans. Math. \
Softw. 19 (1993) 95", 
             StringReplace[{
               URL["http://dx.doi.org/10.1145/77626.77634"], None}, "paclet:" :> 
              ""]}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           
           Part[{{}, {
             "D.M. Snow, ACM Trans. Math. Softw. 16 (1990) 94ACM Trans. Math. \
Softw. 19 (1993) 95", 
              StringReplace[{
                URL["http://dx.doi.org/10.1145/77626.77634"], None}, 
               "paclet:" :> ""]}}, 1], 
           2]]]], "\<\"D.M. Snow, ACM Trans. Math. Softw. 16 (1990) 94ACM \
Trans. Math. Softw. 19 (1993) 95\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[
          StringReplace[{
            URL["http://dx.doi.org/10.1145/77626.77634"], None}, "paclet:" :> 
           ""], "paclet*"], 
         Part[
          
          Part[{{}, {
            "D.M. Snow, ACM Trans. Math. Softw. 16 (1990) 94ACM Trans. Math. \
Softw. 19 (1993) 95", 
             StringReplace[{
               URL["http://dx.doi.org/10.1145/77626.77634"], None}, "paclet:" :> 
              ""]}}, 2], 2], 
         StringJoin["paclet:", 
          Part[
           
           Part[{{}, {
             "D.M. Snow, ACM Trans. Math. Softw. 16 (1990) 94ACM Trans. Math. \
Softw. 19 (1993) 95", 
              StringReplace[{
                URL["http://dx.doi.org/10.1145/77626.77634"], None}, 
               "paclet:" :> ""]}}, 2], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/ReduceRepProduct\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/ReduceRepProduct"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
ReduceRepProduct.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/ReduceRepProduct", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["ReduceRepProduct", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReduceRepProduct", "[", 
       RowBox[{"group", ",", " ", 
        RowBox[{"{", 
         RowBox[{"rep1", ",", " ", "rep2", ",", "..."}], "}"}]}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]Reduces the direct product representation ",
     Cell[BoxData["rep1"], "InlineFormula"],
     " x ",
     Cell[BoxData["rep2"], "InlineFormula"],
     " x ... into its irreducible parts"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->178786723],

Cell[TextData[{
 Cell[BoxData["group"], "InlineFormula"],
 " should be the ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 " of the intended group."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Each representation ",
 Cell[BoxData["rep"], "InlineFormula"],
 " should be a list of non-negative integers (Dynkin coefficients)."
}], "Notes",
 CellID->360734878],

Cell[TextData[{
 "There can be 2 or more  ",
 Cell[BoxData["rep"], "InlineFormula"],
 "s as input (there is no upper limit)."
}], "Notes",
 CellID->73174212],

Cell[TextData[{
 "The output of this method is of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"irrep1", ",", " ", "multiplicity1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"irrep2", ",", "multiplicity2"}], "}"}], ",", " "}]}]], 
  "InlineFormula"],
 " ",
 Cell[BoxData[
  RowBox[{"...", "}"}]], "InlineFormula"],
 " where ",
 Cell[BoxData["irrep"], "InlineFormula"],
 "s are the irreducible representations in the product (given by their Dynkin \
coefficients) and ",
 Cell[BoxData["multiplicities"], "InlineFormula"],
 " are the number of times each ",
 Cell[BoxData["irrep"], "InlineFormula"],
 " is contained in the product."
}], "Notes",
 CellID->133619986],

Cell[TextData[{
 "The function ",
 ButtonBox["PermutationSymmetryOfTensorProductParts",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/PermutationSymmetryOfTensorProductParts"],
 " can be seen as a generalization of ReduceRepProduct, as it also outputs \
information concerning the transformation of each irreducible representations \
in the product, under a permutation of the fields being multiplied."
}], "Notes",
 CellID->597051646]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->142576531],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->851606763],

Cell["\<\
This tells us that in the product {1,0} x {1,0} of SU(3) there is one {2,0} \
irrep and one {1,0}:\
\>", "ExampleText",
 CellID->513681956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196926373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28296660]
}, Open  ]],

Cell["\<\
It turns out that {1,0} is the fundamental representation of SU(3). That is \
possible since ...\
\>", "ExampleText",
 CellID->791803354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DimR", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43353311],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->504535365]
}, Open  ]],

Cell["\<\
So what is its conjugate? We can check that it is {0,1} because the product \
{1,0} x {0,1} contains the SU(3) singlet {0,0}:\
\>", "ExampleText",
 CellID->337007840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->103769142],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->19401659]
}, Open  ]],

Cell["Sure enough,", "ExampleText",
 CellID->30425394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DimR", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->102523921],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->97821043]
}, Open  ]],

Cell["\<\
and {1,1}, the other representation in the product, is the adjoint (as \
expected):\
\>", "ExampleText",
 CellID->284900139],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Print", "[", "\"\<Adjoint of SU(3):\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Adjoint", "[", "SU3", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<Its dimension:\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DimR", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->714739772],

Cell[BoxData["\<\"Adjoint of SU(3):\"\>"], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->13048954],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 ImageSize->{43, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->299923998],

Cell[BoxData["\<\"Its dimension:\"\>"], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->271738423],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->15194187]
}, Open  ]],

Cell["\<\
Note that there is no limit for the number of representations in the product. \
For example {1, 0} x {1, 1} x {7, 2} x {2, 2} of SU(3):\
\>", "ExampleText",
 CellID->164023796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->26272814],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "5"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "6"}], "}"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "4"}], "}"}], ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "7"}], "}"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"8", ",", "5"}], "}"}], ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"12", ",", "3"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "2"}], "}"}], ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "3"}], "}"}], ",", "28"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "1"}], "}"}], ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "6"}], "}"}], ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "4"}], "}"}], ",", "36"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"8", ",", "2"}], "}"}], ",", "43"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "8"}], "}"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "9"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "7"}], "}"}], ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}], ",", "28"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}], ",", "45"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "8"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "6"}], "}"}], ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}], ",", "28"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"13", ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"12", ",", "0"}], "}"}], ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "0"}], "}"}], ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "1"}], "}"}], ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "2"}], "}"}], ",", "34"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "0"}], "}"}], ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "7"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "6"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{535, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->488119055]
}, Open  ]],

Cell["\<\
Different representations which are indistinguishable just by looking at the \
dimensions,\
\>", "ExampleText",
 CellID->554346309],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DimR", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DimR", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->353483304],

Cell[BoxData["210"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->397961725],

Cell[BoxData["210"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->87144179]
}, Open  ]],

Cell["\<\
... may reveal their differences in direct products with known \
representations such as {1,0,0,0,0}=fundamental of SO(10):\
\>", "ExampleText",
 CellID->360467482],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}], "}"}]}],
   "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
   "]"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->196227131],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{551, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->372591401],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{415, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->701607823]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell["\<\
Each quark is in the SU(3) fundamental representation (which is {1,0}) and an \
anti-quark in its conjugate {0,1}. We can see if different combinations of \
quarks and anti-quarks can be uncolored by checking if in the direct product \
representation there are SU(3) singlets {0,0}:\
\>", "ExampleText",
 CellID->358872975],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Print", "[", "\"\<Are there colour singlets in q q q?\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"irrepList", "=", 
  RowBox[{"ReduceRepProduct", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MemberQ", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", "\[Infinity]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<Are there colour singlets in q q q q?\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"irrepList", "=", 
  RowBox[{"ReduceRepProduct", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MemberQ", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", "\[Infinity]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<Are there colour singlets in q q q q q?\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"irrepList", "=", 
  RowBox[{"ReduceRepProduct", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MemberQ", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", "\[Infinity]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<Are there colour singlets in q q q q qBar?\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"irrepList", "=", 
  RowBox[{"ReduceRepProduct", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MemberQ", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", "\[Infinity]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  "\"\<Are there colour singlets in q q q qBar qBar?\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"irrepList", "=", 
  RowBox[{"ReduceRepProduct", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MemberQ", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", "\[Infinity]"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->96133454],

Cell[BoxData["\<\"Are there colour singlets in q q q?\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->157377905],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{253, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53683075],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192883237],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->122503210],

Cell[BoxData["\<\"Are there colour singlets in q q q q?\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->114543341]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{335, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163536231],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70351448],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->25128319],

Cell[BoxData["\<\"Are there colour singlets in q q q q q?\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->374437202]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182240781],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93557438],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->858494951],

Cell[BoxData["\<\"Are there colour singlets in q q q q qBar?\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->255673628]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "3"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{499, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->903715891],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26092675],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->409158297],

Cell[BoxData["\<\"Are there colour singlets in q q q qBar qBar?\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->814880512]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{499, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273586460],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169566272]
}, Open  ]],

Cell["\<\
Using ReduceRepProduct and DimR together: the function DimR can be used to \
convert the irreps given in Dynkin coefficients notation, to the (potentially \
ambiguous) 'dimension notation':\
\>", "ExampleText",
 CellID->448198813],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Print", "[", 
  "\"\<Fundamental x Fundamental x 24 of SU(5) breaks down into:\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"irreps", "=", 
    RowBox[{"ReduceRepProduct", "[", 
     RowBox[{"SU5", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{"DimR", "[", 
        RowBox[{"SU5", ",", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", "Bold"}], "]"}], ",", 
     RowBox[{"#", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "&"}], "/@", 
  "irreps"}], "\[IndentingNewLine]"}], "Input",
 CellLabel->"In[2]:=",
 CellID->244066278],

Cell[BoxData["\<\"Fundamental x Fundamental x 24 of SU(5) breaks down into:\"\
\>"], "Print",
 CellLabel->"During evaluation of In[33]:=",
 CellID->23552650],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["160",
      StripOnInput->False,
      FontWeight->Bold], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["175",
      StripOnInput->False,
      FontWeight->Bold], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["15",
      StripOnInput->False,
      FontWeight->Bold], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["40",
      StripOnInput->False,
      FontWeight->Bold], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["10",
      StripOnInput->False,
      FontWeight->Bold], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{306, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->291287552]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DimR",
    BaseStyle->"Link",
    ButtonData->"paclet:Susyno/ref/DimR"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PermutationSymmetryOfTensorProductParts",
    BaseStyle->"Link",
    ButtonData->"paclet:Susyno/ref/PermutationSymmetryOfTensorProductParts"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell["The algorithm used is based on the following sources:", "MoreAbout",
 CellID->474435919],

Cell[TextData[{
 ButtonBox["D.M. Snow, ACM Trans. Math. Softw. 16 (1990) 94",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://dx.doi.org/10.1145/77626.77634"], None}],
 ";\[LineSeparator]",
 ButtonBox["ACM Trans. Math. Softw. 19 (1993) 95",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://dx.doi.org/10.1145/151271.151278"], None}],
 "."
}], "MoreAbout",
 CellID->1665078683]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReduceRepProduct - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2013, 8, 7, 2, 28, 22.3750000}", "context" -> "Susyno`", 
    "keywords" -> {
     "Direct product", "Representation", "Group", 
      "Irreducible representation", "Reduce"}, "index" -> True, "label" -> 
    "Susyno Paclet Symbol", "language" -> "en", "paclet" -> "Susyno", 
    "status" -> "None", "summary" -> 
    "ReduceRepProduct[group, {rep1, rep2, ...}] Reduces the direct product \
representation rep1 x rep2 x ... into its irreducible parts", 
    "synonyms" -> {}, "title" -> "ReduceRepProduct", "type" -> "Symbol", 
    "uri" -> "Susyno/ref/ReduceRepProduct"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8772, 261, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->142576531]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37829, 1322}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[597, 21, 76, 1, 70, "SymbolColorBar"],
Cell[676, 24, 178, 5, 70, "LinkTrail"],
Cell[857, 31, 4779, 118, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[5661, 153, 59, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[5723, 156, 654, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6414, 180, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->178786723],
Cell[6997, 199, 236, 8, 70, "Notes",
 CellID->1067943069],
Cell[7236, 209, 182, 5, 70, "Notes",
 CellID->360734878],
Cell[7421, 216, 157, 5, 70, "Notes",
 CellID->73174212],
Cell[7581, 223, 708, 22, 70, "Notes",
 CellID->133619986],
Cell[8292, 247, 443, 9, 70, "Notes",
 CellID->597051646]
}, Closed]],
Cell[CellGroupData[{
Cell[8772, 261, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->142576531],
Cell[CellGroupData[{
Cell[9258, 278, 148, 5, 70, "ExampleSection",
 CellID->851606763],
Cell[9409, 285, 149, 4, 70, "ExampleText",
 CellID->513681956],
Cell[CellGroupData[{
Cell[9583, 293, 292, 10, 70, "Input",
 CellID->196926373],
Cell[9878, 305, 407, 15, 36, "Output",
 CellID->28296660]
}, Open  ]],
Cell[10300, 323, 147, 4, 70, "ExampleText",
 CellID->791803354],
Cell[CellGroupData[{
Cell[10472, 331, 173, 6, 70, "Input",
 CellID->43353311],
Cell[10648, 339, 158, 5, 36, "Output",
 CellID->504535365]
}, Open  ]],
Cell[10821, 347, 176, 4, 70, "ExampleText",
 CellID->337007840],
Cell[CellGroupData[{
Cell[11022, 355, 292, 10, 70, "Input",
 CellID->103769142],
Cell[11317, 367, 407, 15, 36, "Output",
 CellID->19401659]
}, Open  ]],
Cell[11739, 385, 54, 1, 70, "ExampleText",
 CellID->30425394],
Cell[CellGroupData[{
Cell[11818, 390, 174, 6, 70, "Input",
 CellID->102523921],
Cell[11995, 398, 157, 5, 36, "Output",
 CellID->97821043]
}, Open  ]],
Cell[12167, 406, 134, 4, 70, "ExampleText",
 CellID->284900139],
Cell[CellGroupData[{
Cell[12326, 414, 405, 10, 70, "Input",
 CellID->714739772],
Cell[12734, 426, 114, 2, 70, "Print",
 CellID->13048954],
Cell[12851, 430, 203, 7, 36, "Output",
 CellID->299923998],
Cell[13057, 439, 112, 2, 70, "Print",
 CellID->271738423],
Cell[13172, 443, 157, 5, 36, "Output",
 CellID->15194187]
}, Open  ]],
Cell[13344, 451, 186, 4, 70, "ExampleText",
 CellID->164023796],
Cell[CellGroupData[{
Cell[13555, 459, 417, 14, 70, "Input",
 CellID->26272814],
Cell[13975, 475, 4017, 143, 122, "Output",
 CellID->488119055]
}, Open  ]],
Cell[18007, 621, 141, 4, 70, "ExampleText",
 CellID->554346309],
Cell[CellGroupData[{
Cell[18173, 629, 376, 12, 70, "Input",
 CellID->353483304],
Cell[18552, 643, 160, 5, 36, "Output",
 CellID->397961725],
Cell[18715, 650, 159, 5, 36, "Output",
 CellID->87144179]
}, Open  ]],
Cell[18889, 658, 174, 4, 70, "ExampleText",
 CellID->360467482],
Cell[CellGroupData[{
Cell[19088, 666, 672, 20, 70, "Input",
 CellID->196227131],
Cell[19763, 688, 776, 27, 36, "Output",
 CellID->372591401],
Cell[20542, 717, 628, 22, 36, "Output",
 CellID->701607823]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21219, 745, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[21450, 754, 333, 6, 70, "ExampleText",
 CellID->358872975],
Cell[CellGroupData[{
Cell[21808, 764, 3870, 115, 70, "Input",
 CellID->96133454],
Cell[25681, 881, 134, 2, 70, "Print",
 CellID->157377905],
Cell[25818, 885, 519, 19, 36, "Output",
 CellID->53683075],
Cell[26340, 906, 161, 5, 36, "Output",
 CellID->192883237],
Cell[CellGroupData[{
Cell[26526, 915, 99, 2, 70, "Print",
 CellID->122503210],
Cell[26628, 919, 136, 2, 70, "Print",
 CellID->114543341]
}, Open  ]],
Cell[26779, 924, 632, 23, 36, "Output",
 CellID->163536231],
Cell[27414, 949, 161, 5, 36, "Output",
 CellID->70351448],
Cell[CellGroupData[{
Cell[27600, 958, 98, 2, 70, "Print",
 CellID->25128319],
Cell[27701, 962, 138, 2, 70, "Print",
 CellID->374437202]
}, Open  ]],
Cell[27854, 967, 744, 27, 36, "Output",
 CellID->182240781],
Cell[28601, 996, 161, 5, 36, "Output",
 CellID->93557438],
Cell[CellGroupData[{
Cell[28787, 1005, 99, 2, 70, "Print",
 CellID->858494951],
Cell[28889, 1009, 141, 2, 70, "Print",
 CellID->255673628]
}, Open  ]],
Cell[29045, 1014, 856, 31, 36, "Output",
 CellID->903715891],
Cell[29904, 1047, 160, 5, 36, "Output",
 CellID->26092675],
Cell[CellGroupData[{
Cell[30089, 1056, 99, 2, 70, "Print",
 CellID->409158297],
Cell[30191, 1060, 144, 2, 70, "Print",
 CellID->814880512]
}, Open  ]],
Cell[30350, 1065, 856, 31, 36, "Output",
 CellID->273586460],
Cell[31209, 1098, 162, 5, 36, "Output",
 CellID->169566272]
}, Open  ]],
Cell[31386, 1106, 240, 5, 70, "ExampleText",
 CellID->448198813],
Cell[CellGroupData[{
Cell[31651, 1115, 1069, 32, 70, "Input",
 CellID->244066278],
Cell[32723, 1149, 157, 3, 70, "Print",
 CellID->23552650],
Cell[32883, 1154, 821, 32, 36, "Output",
 CellID->291287552]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33765, 1193, 417, 12, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[34185, 1207, 558, 18, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[34780, 1230, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[35202, 1244, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[35390, 1252, 419, 12, 70, "MoreAboutSection",
 CellID->38303248],
Cell[35812, 1266, 94, 1, 70, "MoreAbout",
 CellID->474435919],
Cell[35909, 1269, 395, 12, 70, "MoreAbout",
 CellID->1665078683]
}, Open  ]],
Cell[36319, 1284, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

