(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     56299,       1598]
NotebookOptionsPosition[     50034,       1395]
NotebookOutlinePosition[     51896,       1444]
CellTagsIndexPosition[     51810,       1439]
WindowTitle->PermutationSymmetryOfTensorProductParts - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {
       RowBox[{
        RowBox[{"{", "}"}], "\[LeftDoubleBracket]", "1", 
        "\[RightDoubleBracket]"}]:>Documentation`HelpLookup[
        If[
         StringMatchQ[
          Part[{}, 2], "paclet*"], 
         Part[
          Part[{{}, {"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE", 
             StringReplace[{
               URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None}, 
              "paclet:" :> ""]}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{}, {"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE", 
              StringReplace[{
                URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None},
                "paclet:" :> ""]}}, 1], 
           2]]]], "\<\"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE\"\>":>
       Documentation`HelpLookup[
        If[
         StringMatchQ[
          StringReplace[{
            URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None}, 
           "paclet:" :> ""], "paclet*"], 
         Part[
          Part[{{}, {"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE", 
             StringReplace[{
               URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None}, 
              "paclet:" :> ""]}}, 2], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{}, {"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE", 
              StringReplace[{
                URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None},
                "paclet:" :> ""]}}, 2], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->
         False], {"\<\"Susyno/ref/PermutationSymmetryOfTensorProductParts\"\>\
":>None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/PermutationSymmetryOfTensorProductParts"]}, 
            Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
PermutationSymmetryOfTensorProductParts.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/PermutationSymmetryOfTensorProductParts", ".html"]], 
           None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["PermutationSymmetryOfTensorProductParts", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PermutationSymmetryOfTensorProductParts", "[", 
       RowBox[{
        RowBox[{"gauge", " ", "group"}], ",", 
        RowBox[{"list", " ", "of", " ", "representations"}]}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]Computes the irreducible parts (irreps) in the product \
of the representations of the gauge group provided, together with the \
information on how these irreps change under a permutation of the \
representations being multiplied"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->454475215],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"gauge", " ", "group"}]], "InlineFormula"],
 " can be a list of simple/abelian groups (see ",
 ButtonBox["Cartan matrix)",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 "."
}], "Notes",
 CellID->149353492],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"list", " ", "of", " ", "representations"}]], "InlineFormula"],
 " must be a list of representations of the gauge group."
}], "Notes",
 CellID->190293714],

Cell[TextData[{
 "This function is a more complicated version of ",
 Cell[BoxData[
  ButtonBox["Plethysms",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/Plethysms"]], "InlineFormula"],
 ", which can handle gauge groups which are not simple, and also product of \
representations which need not be the same. This function can also be seen as \
a generalization of ",
 Cell[BoxData[
  ButtonBox["PermutationSymmetryOfInvariants",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/PermutationSymmetryOfInvariants"]], 
  "InlineFormula"],
 ": this latter function deals only with the gauge invariant parts of the \
product of the representations given as input. Also, this function gives more \
information that ",
 Cell[BoxData[
  ButtonBox["ReduceRepProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/ReduceRepProduct"]], "InlineFormula"],
 ", which completely ignores what happens under a permutation of equal \
representations."
}], "Notes",
 CellID->757085513],

Cell[TextData[{
 "The output is rather complex (see the examples below). It is made of two \
lists: {",
 Cell[BoxData["indices"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"gauge", " ", "group", "\[Times]", "permutation", " ", "group"}], 
    ")"}], " ", "representations"}]], "InlineFormula"],
 " }. The first one (",
 Cell[BoxData["indices"], "InlineFormula"],
 ") indicates the position of equal representations in the  input list. So ",
 Cell[BoxData["indices"], "InlineFormula"],
 "={",
 Cell[BoxData["G1"], "InlineFormula"],
 ", ",
 Cell[BoxData["G2"], "InlineFormula"],
 ", \[CenterEllipsis]} where each ",
 Cell[BoxData["GI"], "InlineFormula"],
 " lists the positions of a group of equal representations. For example, if \
the input list is {",
 Cell[BoxData[
  SubscriptBox["R", "1"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["R", "2"]], "InlineFormula"],
 ",",
 Cell[BoxData[
  SubscriptBox["R", "1"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["R", "2"]], "InlineFormula"],
 "} for some representation ",
 Cell[BoxData[
  SubscriptBox["R", "1"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["R", "2"]], "InlineFormula"],
 " of the gauge group, ",
 Cell[BoxData["indices"], "InlineFormula"],
 " will be {{1,3},{2,4}} (the representations in positions 1 and 3 are the \
same, as well as the ones in the positions 2 and 4). The second list (",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"gauge", " ", "group", "*", "Sn"}], ")"}], " ", 
   "representations"}]], "InlineFormula"],
 ") is itself a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"Rep1", ",", " ", "Rep2", ",", " ", "\[CenterEllipsis]"}], "}"}]], 
  "InlineFormula"],
 " with the break down of the representations being multiplied according to \
how they change under (a) the gauge group and (b) under permutations of equal \
representations. Specifically, each ",
 Cell[BoxData["RepI"], "InlineFormula"],
 " is of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"GaugeGroupIrrep", ",", 
      RowBox[{"{", 
       RowBox[{
       "SnRepIG1", ",", " ", "SnRepIG2", ",", " ", "\[CenterEllipsis]"}], 
       "}"}]}], "}"}], ",", " ", "multiplicity"}], "}"}]], "InlineFormula"],
 " where ",
 Cell[BoxData["GaugeGroupIrrep"], "InlineFormula"],
 " is the gauge group irrep, and each ",
 Cell[BoxData["SnRepIGJ"], "InlineFormula"],
 " is the irreducible representation of an ",
 Cell[BoxData[
  SubscriptBox["S", "n"]], "InlineFormula"],
 " induced when the same fields in the grouping ",
 Cell[BoxData["GJ"], "InlineFormula"],
 " are permuted. ",
 Cell[BoxData["multiplicity"], "InlineFormula"],
 " indicates how many times such an irrep of the (gauge ",
 "group",
 " \[Times] permutation group) is contained in the product of the \
representations of the gauge group provided."
}], "Notes",
 CellID->311445735],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PermutationSymmetryOfTensorProductParts",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/PermutationSymmetryOfTensorProductParts"]], 
  "InlineFormula"],
 " is related to the ",
 Cell[BoxData[
  ButtonBox["Plethysms",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/Plethysms"]], "InlineFormula"],
 " function, which follows the algorithm described in ",
 StyleBox["M. A. A. van Leeuwen, A. M. Cohen, and B. Lisser, LiE, A Package \
for Lie Group Computations. Computer Algebra Nederland, 1992",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->586435317]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->196088492],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->273538768],

Cell["\<\
Consider gauge groups with a single factor\[LongDash]for example {SU2}. We \
shall consider a product of two doublets (={{1}}) and two quadruplets \
(={{3}}).\
\>", "ExampleText",
 CellID->21576093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermutationSymmetryOfTensorProductParts", "[", 
  RowBox[{
   RowBox[{"{", "SU2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", "1", "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", "1", "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", "3", "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", "3", "}"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39678609],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnFGO5TYORY1kJVlJ9hBkBb2B7P+rkzTwClXPLokiLyVaPgcYYIa2Lq9E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    "], {{0, 84}, {575, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{575, 84},
  PlotRange->{{0, 575}, {0, 84}}]], "Output",
 ImageSize->{579, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74239269]
}, Open  ]],

Cell[TextData[{
 "We now carefully look at the output. The first part of it is {{1, 2}, {3, \
4}}, and it tells us that there are two groups of equal representations in \
the product: representation #1 and #2 are equal (group1), and representations \
#3 and #4 are also the same (group2). This is manifestly true by looking at \
the input (the {SU2} representations are {{{1}}, {{1}}, {{2}}, {{2}}}). The \
next part of the output contains the following items:\[LineSeparator]\
\[LineSeparator]{{{{8}}, {{2}, {2}}}, 1}\[LineSeparator]{{{{4}}, {{2}, {2}}}, \
2}\[LineSeparator]{{{{6}}, {{2}, {2}}}, 1}\[LineSeparator]{{{{0}}, {{2}, \
{2}}}, 1}\[LineSeparator]{{{{2}}, {{2}, {2}}}, 1}\[LineSeparator]{{{{6}}, \
{{2}, {1, 1}}}, 1}\[LineSeparator]{{{{2}}, {{2}, {1, 1}}}, \
2}\[LineSeparator]{{{{4}}, {{2}, {1, 1}}}, 1}\[LineSeparator]{{{{6}}, {{1, \
1}, {2}}}, 1}\[LineSeparator]{{{{2}}, {{1, 1}, {2}}}, \
1}\[LineSeparator]{{{{4}}, {{1, 1}, {1, 1}}}, 1}\[LineSeparator]{{{{0}}, {{1, \
1}, {1, 1}}}, 1}\[LineSeparator]\[LineSeparator]They all follow the form \
{<{{SU2} representation}>, {<",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula"],
 " representation induced by a permutation of the fields in group1 (rep #1 \
and rep #2)>,<",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula"],
 " representation induced by a permutation of the fields in group2 (rep #3 \
and rep #4)>}, <multiplicity>}",
 StyleBox[". \[LineSeparator]\[LineSeparator]", "TR"],
 "For example, {{{{8}}, {{2}, {2}}}, 1} tells us that in the product \
{1}x{1}x{3}x{3} of SU2 representations there is an {8}, and it is in a \
symmetric combination of the {1}'s (i.e., it is in the  representation {2} of \
the permutation group ",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula"],
 "), and it is also in a symmetric combination of the {3}'s  (again, \
symbolically this is the same as saying that it is in the representation {2} \
of the permutation group ",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula"],
 ").\[LineSeparator]\[LineSeparator]Another example: {{{{6}}, {{2}, {1, 1}}}, \
1}. It means that in the product {1}x{1}x{3}x{3} of SU2 there is one \
representation {6} of SU2 (7-dimensional), which is symmetric under a \
permutation of the {1}'s (irrep {2} of ",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula"],
 ") and antisymmetric under a permutation of the {3}'s (irrep {1,1} of ",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula"],
 ")."
}], "ExampleText",
 CellID->151918977],

Cell["\<\
Consider now the product of 3 triplets of SU3 with a singlet:\
\>", "ExampleText",
 CellID->425739455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermutationSymmetryOfTensorProductParts", "[", 
  RowBox[{
   RowBox[{"{", "SU3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->631183171],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"3", ",", "0"}], "}"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "3", "}"}], ",", 
           RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2", ",", "1"}], "}"}], ",", 
           RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
           RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}], ",", "1"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{452, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->185989622]
}, Open  ]],

Cell[TextData[{
 "The output informs us that representations #1, #2, #4 are equal (group1), \
and then there is representation #3. The product {{1, 0}}x{{1, 0}}x{{0, \
0}}x{{1, 0}} of {SU3} representations breaks down in representations of \
{SU3}x",
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula"],
 "x",
 Cell[BoxData[
  SubscriptBox["S", "1"]], "InlineFormula"],
 " as follows:\[LineSeparator]{{{{3, 0}}, {{3}, {1}}}, \
1}\[LineSeparator]{{{{1, 1}}, {{2, 1}, {1}}}, 1}\[LineSeparator]{{{{0, 0}}, \
{{1, 1, 1}, {1}}}, 1}\[LineSeparator]\[LineSeparator]In words, there is one \
{{3, 0}}x{3}x{1}, one {{1, 1}}x{2,1}x{1}, and one {{0, 0}}x{1,1,1}x{1} \
representation of the {SU3}x",
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula"],
 "x",
 Cell[BoxData[
  SubscriptBox["S", "1"]], "InlineFormula"],
 " group. Note that it would be wrong to think that there is only one {{1,1}} \
representation of {SU3} in the product because the representation {2,1} of ",
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula"],
 " is 2-dimensinal:"
}], "ExampleText",
 CellID->651730668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SnIrrepDim", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->140558511],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->53032437]
}, Open  ]],

Cell[TextData[{
 "Indeed, using the ",
 StyleBox[ButtonBox["ReduceRepProduct",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/ReduceRepProduct"], "Code"],
 " function which deals only with the decomposition into irreducible \
representations of the gauge group, we get"
}], "ExampleText",
 CellID->289351674],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->216308175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{253, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->76952409]
}, Open  ]],

Cell["The dimensions add up:", "ExampleText",
 CellID->176196727],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DimR", "[", 
    RowBox[{"SU3", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "]"}], "^", "3"}], " ", 
  RowBox[{"DimR", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DimR", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "0"}], "}"}]}], "]"}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"DimR", "[", 
    RowBox[{"SU3", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "+", 
  RowBox[{"DimR", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->100031268],

Cell[BoxData["27"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->590574086],

Cell[BoxData["27"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->84698464]
}, Open  ]],

Cell["\<\
Once the output format of the PermutationSymmetryOfTensorProductParts is \
understood, it can be parsed easily:\
\>", "ExampleText",
 CellID->544317391],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"result", "=", 
    RowBox[{"PermutationSymmetryOfTensorProductParts", "[", 
     RowBox[{
      RowBox[{"{", "SO10", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], "}"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], 
         "}"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"Style", "[", 
     RowBox[{
     "\"\<>>> The product of SO(10) representations 10x10x16x16 breaks as \
follows:\>\"", ",", "Bold"}], "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"irrep", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"irrep", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "1"}], ",", 
         "\"\< time\>\"", ",", "\"\< times\>\""}], "]"}], ",", 
       "\"\< the SO(10) representation \>\"", ",", 
       RowBox[{"irrep", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1", ",", "1"}], "]"}], "]"}], ",", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"irrep", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "2", ",", "1"}], "]"}], "]"}], "===", 
          RowBox[{"{", "2", "}"}]}], ",", "\"\< in a symmetric\>\"", ",", 
         "\"\< in an antisymmetric\>\""}], "]"}], ",", 
       "\"\< configuration of the 10's and \>\"", ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"irrep", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "2", ",", "2"}], "]"}], "]"}], "===", 
          RowBox[{"{", "2", "}"}]}], ",", "\"\< in a symmetric\>\"", ",", 
         "\"\< in an antisymmetric\>\""}], "]"}], ",", 
       "\"\< configuration of the 16's.\>\""}], "]"}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"irrep", ",", 
      RowBox[{"result", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellLabel->"In[6]:=",
 CellID->419989149],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\">>> The product of SO(10) representations 10x10x16x16 breaks \
as follows:\"\>",
  StripOnInput->False,
  FontWeight->Bold]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->466805490],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {2, 0, 0, 0, 2}, 
   " in a symmetric", " configuration of the 10's and ", " in a symmetric", 
   " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->774740358],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 0, 0, 2, 0}, 
   " in a symmetric", " configuration of the 10's and ", " in a symmetric", 
   " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->115388594],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 0, 0, 1, 1}, 
   " in a symmetric", " configuration of the 10's and ", " in a symmetric", 
   " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->71234362],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {3, 0, 0, 0, 0}, 
   " in a symmetric", " configuration of the 10's and ", " in a symmetric", 
   " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->28477018],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 1, 0, 0, 0}, 
   " in a symmetric", " configuration of the 10's and ", " in a symmetric", 
   " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->14324273],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\" times\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  2, " times", " the SO(10) representation ", {1, 0, 0, 0, 0}, 
   " in a symmetric", " configuration of the 10's and ", " in a symmetric", 
   " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->71060304],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {2, 0, 1, 0, 0}, 
   " in a symmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->139330917],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\" times\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  2, " times", " the SO(10) representation ", {0, 0, 1, 0, 0}, 
   " in a symmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->38371167],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 0, 0, 1, 1}, 
   " in a symmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->9303816],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 1, 0, 0, 0}, 
   " in a symmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->66794255],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 0, 0, 0, 2}, 
   " in a symmetric", " configuration of the 10's and ", " in a symmetric", 
   " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->846789555],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 1, 0, 0, 2}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in a symmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->200207895],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 0, 0, 1, 1}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in a symmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->281840598],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\" times\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  2, " times", " the SO(10) representation ", {0, 0, 1, 0, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in a symmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->6123158],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 0, 0, 0, 2}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in a symmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->6881588],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 1, 0, 0, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in a symmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->482982862],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in a symmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 0, 0, 0, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in a symmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->386984469],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 1, 1, 0, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->67802601],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 0, 0, 1, 1}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->741917247],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 1, 0, 0, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->934711805],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 0, 0, 0, 2}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->81344691],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 0, 0, 2, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->520053330],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {0, 0, 1, 0, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->514994521],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" time\"\>", 
   "\[InvisibleSpace]", "\<\" the SO(10) representation \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 10's and \"\>", 
   "\[InvisibleSpace]", "\<\" in an antisymmetric\"\>", 
   "\[InvisibleSpace]", "\<\" configuration of the 16's.\"\>"}],
  SequenceForm[
  1, " time", " the SO(10) representation ", {1, 0, 0, 0, 0}, 
   " in an antisymmetric", " configuration of the 10's and ", 
   " in an antisymmetric", " configuration of the 16's."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->713384163]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell["\<\
M. A. A. van Leeuwen, A. M. Cohen, and B. Lisser, LiE, A Package for Lie \
Group Computations. Computer Algebra Nederland, 1992\
\>", "MoreAbout",
 CellID->1665078683],

Cell[TextData[{
 "M. A. A. van Leeuwen, A. M. Cohen, and B. Lisser, \
\[OpenCurlyDoubleQuote]LiE - A Computer algebra package for Lie group \
computations.\[CloseCurlyDoubleQuote] ",
 ButtonBox["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"], None},
  ButtonNote->"http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"],
 ", 2012. Retrieved March 17, 2013."
}], "MoreAbout",
 CellID->867725]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED DEMONSTRATIONS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedDemonstrationsSection",
 CellID->1268215905],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InvariantPlethysms",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/InvariantPlethysms"]], "InlineFormula"],
 " \[EmptyVerySmallSquare] ",
 Cell[BoxData[
  ButtonBox["PermutationSymmetryOfInvariants",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/PermutationSymmetryOfInvariants"]], 
  "InlineFormula"],
 " \[EmptyVerySmallSquare] ",
 Cell[BoxData[
  ButtonBox["Plethysms",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/Plethysms"]], "InlineFormula"],
 " \[EmptyVerySmallSquare] ",
 Cell[BoxData[
  ButtonBox["ReduceRepProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/ReduceRepProduct"]], "InlineFormula"]
}], "RelatedDemonstrations",
 CellID->1129518860]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PermutationSymmetryOfTensorProductParts - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2013, 8, 7, 2, 27, 54.8593750}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "PermutationSymmetryOfTensorProductParts[gauge group, list of \
representations] Computes the irreducible parts (irreps) in the product of \
the representations of the gauge group provided, together with the \
information on how these irreps change under a permutation of the \
representations being multiplied", "synonyms" -> {}, "title" -> 
    "PermutationSymmetryOfTensorProductParts", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/PermutationSymmetryOfTensorProductParts"}, 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11481, 327, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->196088492]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 51666, 1432}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[620, 21, 76, 1, 70, "SymbolColorBar"],
Cell[699, 24, 178, 5, 70, "LinkTrail"],
Cell[880, 31, 4116, 96, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[5021, 131, 82, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[5106, 134, 723, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5866, 157, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->454475215],
Cell[6449, 176, 271, 9, 70, "Notes",
 CellID->149353492],
Cell[6723, 187, 195, 5, 70, "Notes",
 CellID->190293714],
Cell[6921, 194, 993, 24, 70, "Notes",
 CellID->757085513],
Cell[7917, 220, 2906, 83, 70, "Notes",
 CellID->311445735],
Cell[10826, 305, 618, 17, 70, "Notes",
 CellID->586435317]
}, Closed]],
Cell[CellGroupData[{
Cell[11481, 327, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->196088492],
Cell[CellGroupData[{
Cell[11967, 344, 148, 5, 70, "ExampleSection",
 CellID->273538768],
Cell[12118, 351, 208, 5, 70, "ExampleText",
 CellID->21576093],
Cell[CellGroupData[{
Cell[12351, 360, 464, 15, 28, "Input",
 CellID->39678609],
Cell[12818, 377, 3187, 60, 98, "Output",
 CellID->74239269]
}, Open  ]],
Cell[16020, 440, 2519, 47, 70, "ExampleText",
 CellID->151918977],
Cell[18542, 489, 112, 3, 70, "ExampleText",
 CellID->425739455],
Cell[CellGroupData[{
Cell[18679, 496, 577, 19, 70, "Input",
 CellID->631183171],
Cell[19259, 517, 1466, 50, 54, "Output",
 CellID->185989622]
}, Open  ]],
Cell[20740, 570, 1097, 26, 70, "ExampleText",
 CellID->651730668],
Cell[CellGroupData[{
Cell[21862, 600, 153, 5, 70, "Input",
 CellID->140558511],
Cell[22018, 607, 157, 5, 36, "Output",
 CellID->53032437]
}, Open  ]],
Cell[22190, 615, 315, 8, 70, "ExampleText",
 CellID->289351674],
Cell[CellGroupData[{
Cell[22530, 627, 418, 14, 70, "Input",
 CellID->216308175],
Cell[22951, 643, 519, 19, 36, "Output",
 CellID->76952409]
}, Open  ]],
Cell[23485, 665, 65, 1, 70, "ExampleText",
 CellID->176196727],
Cell[CellGroupData[{
Cell[23575, 670, 748, 26, 70, "Input",
 CellID->100031268],
Cell[24326, 698, 159, 5, 36, "Output",
 CellID->590574086],
Cell[24488, 705, 158, 5, 36, "Output",
 CellID->84698464]
}, Open  ]],
Cell[24661, 713, 162, 4, 70, "ExampleText",
 CellID->544317391],
Cell[CellGroupData[{
Cell[24848, 721, 2744, 77, 70, "Input",
 CellID->419989149],
Cell[CellGroupData[{
Cell[27617, 802, 227, 6, 70, "Print",
 CellID->466805490],
Cell[27847, 810, 785, 18, 70, "Print",
 CellID->774740358],
Cell[28635, 830, 785, 18, 70, "Print",
 CellID->115388594],
Cell[29423, 850, 784, 18, 70, "Print",
 CellID->71234362],
Cell[30210, 870, 784, 18, 70, "Print",
 CellID->28477018],
Cell[30997, 890, 784, 18, 70, "Print",
 CellID->14324273],
Cell[31784, 910, 786, 18, 70, "Print",
 CellID->71060304],
Cell[32573, 930, 795, 18, 70, "Print",
 CellID->139330917],
Cell[33371, 950, 796, 18, 70, "Print",
 CellID->38371167],
Cell[34170, 970, 793, 18, 70, "Print",
 CellID->9303816],
Cell[34966, 990, 794, 18, 70, "Print",
 CellID->66794255],
Cell[35763, 1010, 785, 18, 70, "Print",
 CellID->846789555],
Cell[36551, 1030, 795, 18, 70, "Print",
 CellID->200207895],
Cell[37349, 1050, 795, 18, 70, "Print",
 CellID->281840598],
Cell[38147, 1070, 795, 18, 70, "Print",
 CellID->6123158],
Cell[38945, 1090, 793, 18, 70, "Print",
 CellID->6881588],
Cell[39741, 1110, 795, 18, 70, "Print",
 CellID->482982862],
Cell[40539, 1130, 795, 18, 70, "Print",
 CellID->386984469],
Cell[41337, 1150, 804, 18, 70, "Print",
 CellID->67802601],
Cell[42144, 1170, 805, 18, 70, "Print",
 CellID->741917247],
Cell[42952, 1190, 805, 18, 70, "Print",
 CellID->934711805],
Cell[43760, 1210, 804, 18, 70, "Print",
 CellID->81344691],
Cell[44567, 1230, 805, 18, 70, "Print",
 CellID->520053330],
Cell[45375, 1250, 805, 18, 70, "Print",
 CellID->514994521],
Cell[46183, 1270, 805, 18, 70, "Print",
 CellID->713384163]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47061, 1296, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[47483, 1310, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[47671, 1318, 419, 12, 70, "MoreAboutSection",
 CellID->38303248],
Cell[48093, 1332, 177, 4, 70, "MoreAbout",
 CellID->1665078683],
Cell[48273, 1338, 489, 11, 70, "MoreAbout",
 CellID->867725]
}, Open  ]],
Cell[CellGroupData[{
Cell[48799, 1354, 445, 12, 70, "RelatedDemonstrationsSection",
 CellID->1268215905],
Cell[49247, 1368, 745, 22, 70, "RelatedDemonstrations",
 CellID->1129518860]
}, Open  ]],
Cell[50007, 1393, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

