(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26954,        955]
NotebookOptionsPosition[     22126,        793]
NotebookOutlinePosition[     23682,        837]
CellTagsIndexPosition[     23597,        832]
WindowTitle->Invariants - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/Invariants\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/Invariants"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
Invariants.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/Invariants", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["Invariants", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Invariants", "[", 
       RowBox[{"group", ",", 
        RowBox[{"{", 
         RowBox[{"rep1", ",", " ", "rep2", ",", " ", "..."}], "}"}]}], "]"}]],
       "InlineFormula"],
     "\[LineSeparator]Calculates the invariants of ",
     Cell[BoxData["rep1"], "InlineFormula"],
     " x ",
     Cell[BoxData["rep2"], "InlineFormula"],
     " x \[CenterEllipsis]"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->195041733],

Cell[TextData[{
 Cell[BoxData["group"], "InlineFormula"],
 " should be the ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 " of the intended group."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Each representation ",
 Cell[BoxData["rep"], "InlineFormula"],
 " should be a list of non-negative integers (Dynkin coefficients)."
}], "Notes",
 CellID->41030773],

Cell["\<\
There is no limit to the number of representations being multiplied, although \
the calculation becomes slower as their number increases.\
\>", "Notes",
 CellID->221237370],

Cell[TextData[{
 "The optional input ",
 Cell[BoxData[
  RowBox[{"Conjugations", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"conjugate", " ", "rep1"}], ",", " ", 
     RowBox[{"conjugate", " ", "rep2"}], ",", " ", "\[CenterEllipsis]"}], 
    "}"}]}]], "InlineFormula"],
 "  can be passed to this function, where ",
 Cell[BoxData[
  RowBox[{"conjugate", " ", "repI"}]], "InlineFormula"],
 " can be either ",
 Cell[BoxData["True"], "InlineFormula"],
 " or ",
 Cell[BoxData["False"], "InlineFormula"],
 ". If ",
 Cell[BoxData["True"], "InlineFormula"],
 ", the conjugate representation of ",
 Cell[BoxData["repI"], "InlineFormula"],
 " will be considered instead of ",
 Cell[BoxData["repI"], "InlineFormula"],
 "."
}], "Notes",
 CellID->400920173],

Cell[TextData[{
 "There is also the possibility of ",
 Cell[BoxData["group"], "InlineFormula"],
 " being a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"group1", ",", "group2", ",", "..."}], "}"}]], "InlineFormula"],
 " and each ",
 Cell[BoxData["rep"], "InlineFormula"],
 " a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"rep_group1", ",", "rep_group2", ",", "..."}], "}"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->75953507],

Cell[TextData[{
 "The output of this method is a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"Invariant1", ",", "Invariant2", ",", "..."}], "}"}]], 
  "InlineFormula"],
 " where it is assumed that ",
 Cell[BoxData["a"], "InlineFormula"],
 " is a field transforming as ",
 Cell[BoxData["rep1"], "InlineFormula"],
 ", ",
 Cell[BoxData["b"], "InlineFormula"],
 " as ",
 Cell[BoxData["rep2"], "InlineFormula"],
 ", ",
 Cell[BoxData["c"], "InlineFormula"],
 " as ",
 Cell[BoxData["rep3"], "InlineFormula"],
 ", and so on. These fields have group indices: ",
 Cell[BoxData[
  RowBox[{"a", "[", 
   RowBox[{"ind_group1", ",", " ", "ind_group2", ",", "..."}], "]"}]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"b", "[", 
   RowBox[{"ind_group1", ",", " ", "ind_group2", ",", "..."}], "]"}]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"c", "[", 
   RowBox[{"ind_group1", ",", " ", "ind_group2", ",", "..."}], "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->10758554],

Cell[TextData[{
 "If there are no invariants, ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 " is returned."
}], "Notes",
 CellID->335181877],

Cell["\<\
Clearly this method must assume a particular basis for each representation so \
the results are basis dependent.\
\>", "Notes",
 CellID->898809850],

Cell[TextData[{
 "This method computes essentially generalized Clebsch-Gordon coefficients, \
for any group (not just SU(2)) - see also the method ",
 Cell[BoxData[
  ButtonBox["IrrepInProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/IrrepInProduct"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->329977022]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->132666956],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->19140300],

Cell["\<\
If a and b are SU(2) doublets [={1}], they form an invariant:\
\>", "ExampleText",
 CellID->513681956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Invariants", "[", 
  RowBox[{"SU2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196926373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "2", "]"}], " ", 
    RowBox[{"b", "[", "1", "]"}]}], "-", 
   RowBox[{
    RowBox[{"a", "[", "1", "]"}], " ", 
    RowBox[{"b", "[", "2", "]"}]}]}], "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162871902]
}, Open  ]],

Cell["\<\
How to put together two SU(2) doublets (a and b) and a triplet c?\
\>", "ExampleText",
 CellID->155872588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Invariants", "[", 
  RowBox[{"SU2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->459878862],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"a", "[", "2", "]"}], " ", 
     RowBox[{"b", "[", "2", "]"}], " ", 
     RowBox[{"c", "[", "1", "]"}]}], 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "4"}]]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"a", "[", "2", "]"}], " ", 
     RowBox[{"b", "[", "1", "]"}], " ", 
     RowBox[{"c", "[", "2", "]"}]}], 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "4"}]]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], " ", 
     RowBox[{"b", "[", "2", "]"}], " ", 
     RowBox[{"c", "[", "2", "]"}]}], 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "4"}]]], "+", 
   FractionBox[
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"a", "[", "1", "]"}], " ", 
     RowBox[{"b", "[", "1", "]"}], " ", 
     RowBox[{"c", "[", "3", "]"}]}], 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "4"}]]]}], "}"}]], "Output",
 ImageSize->{488, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->709250]
}, Open  ]],

Cell["\<\
The overall factor is of course irrelevant, therefore the following is also \
an invariant:\
\>", "ExampleText",
 CellID->307224643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   SuperscriptBox["3", 
    RowBox[{"1", "/", "4"}]], " ", "%"}], " ", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->744812328],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"a", "[", "2", "]"}], " ", 
    RowBox[{"b", "[", "2", "]"}], " ", 
    RowBox[{"c", "[", "1", "]"}]}], "-", 
   RowBox[{
    RowBox[{"a", "[", "2", "]"}], " ", 
    RowBox[{"b", "[", "1", "]"}], " ", 
    RowBox[{"c", "[", "2", "]"}]}], "-", 
   RowBox[{
    RowBox[{"a", "[", "1", "]"}], " ", 
    RowBox[{"b", "[", "2", "]"}], " ", 
    RowBox[{"c", "[", "2", "]"}]}], "+", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"a", "[", "1", "]"}], " ", 
    RowBox[{"b", "[", "1", "]"}], " ", 
    RowBox[{"c", "[", "3", "]"}]}]}], "}"}]], "Output",
 ImageSize->{471, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->780334933]
}, Open  ]],

Cell["\<\
If a is in the SU(3) fundamental representation [={1,0}] and b in its \
conjugate...\
\>", "ExampleText",
 CellID->285596647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Invariants", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"Conjugations", "->", 
    RowBox[{"{", 
     RowBox[{"False", ",", "True"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->125780274],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "1", "]"}], " ", 
    RowBox[{"b", "[", "1", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "2", "]"}], " ", 
    RowBox[{"b", "[", "2", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "3", "]"}], " ", 
    RowBox[{"b", "[", "3", "]"}]}]}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->547169760]
}, Open  ]],

Cell["\<\
... but there is an equivalent way to do this since the conjugate of the \
{1,0} representation is also known...it is {0,1}:\
\>", "ExampleText",
 CellID->178491849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Invariants", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->3239219],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "1", "]"}], " ", 
    RowBox[{"b", "[", "1", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "2", "]"}], " ", 
    RowBox[{"b", "[", "2", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "3", "]"}], " ", 
    RowBox[{"b", "[", "3", "]"}]}]}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->96088639]
}, Open  ]],

Cell["\<\
Consider now the 10-dimensional representation of SO(10), which is real. \
However, in a general basis, the representation matrices might not be real \
and as a consequence we get\
\>", "ExampleText",
 CellID->227005108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Invariants", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
   "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->440424632],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "10", "]"}], " ", 
    RowBox[{"b", "[", "1", "]"}]}], "-", 
   RowBox[{
    RowBox[{"a", "[", "9", "]"}], " ", 
    RowBox[{"b", "[", "2", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "8", "]"}], " ", 
    RowBox[{"b", "[", "3", "]"}]}], "-", 
   RowBox[{
    RowBox[{"a", "[", "7", "]"}], " ", 
    RowBox[{"b", "[", "4", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "6", "]"}], " ", 
    RowBox[{"b", "[", "5", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "5", "]"}], " ", 
    RowBox[{"b", "[", "6", "]"}]}], "-", 
   RowBox[{
    RowBox[{"a", "[", "4", "]"}], " ", 
    RowBox[{"b", "[", "7", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "3", "]"}], " ", 
    RowBox[{"b", "[", "8", "]"}]}], "-", 
   RowBox[{
    RowBox[{"a", "[", "2", "]"}], " ", 
    RowBox[{"b", "[", "9", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "1", "]"}], " ", 
    RowBox[{"b", "[", "10", "]"}]}]}], "}"}]], "Output",
 ImageSize->{452, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->429779945]
}, Open  ]],

Cell[TextData[{
 "In fact, Susyno assumes a basis where n of the algebra generators are \
diagonal (n=group rank). The quantum numbers of fields are easily read off in \
this basis, but it is easy to check that this basis always leads to group \
representation matrices which are not real. Use the Conjugation option in the \
cases where there is a field \[Phi] and its conjugate ",
 Cell[BoxData[
  SuperscriptBox["\[Phi]", "*"]], "InlineFormula"],
 " (in mass terms for example):"
}], "ExampleText",
 CellID->180242795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Invariants", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"Conjugations", "->", 
    RowBox[{"{", 
     RowBox[{"False", ",", "True"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->388476289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "1", "]"}], " ", 
    RowBox[{"b", "[", "1", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "2", "]"}], " ", 
    RowBox[{"b", "[", "2", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "3", "]"}], " ", 
    RowBox[{"b", "[", "3", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "4", "]"}], " ", 
    RowBox[{"b", "[", "4", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "5", "]"}], " ", 
    RowBox[{"b", "[", "5", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "6", "]"}], " ", 
    RowBox[{"b", "[", "6", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "7", "]"}], " ", 
    RowBox[{"b", "[", "7", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "8", "]"}], " ", 
    RowBox[{"b", "[", "8", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "9", "]"}], " ", 
    RowBox[{"b", "[", "9", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "10", "]"}], " ", 
    RowBox[{"b", "[", "10", "]"}]}]}], "}"}]], "Output",
 ImageSize->{459, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->666374976]
}, Open  ]],

Cell["\<\
More complicated cases where group is a list of simple factors is also \
possible:\
\>", "ExampleText",
 CellID->259255305],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Q", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
  "    "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hu", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Invariants", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"SU2", ",", "SU3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Q", ",", "u", ",", "Hu"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->595169869],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"2", ",", "1"}], "]"}], " ", 
    RowBox[{"b", "[", 
     RowBox[{"1", ",", "1"}], "]"}], " ", 
    RowBox[{"c", "[", 
     RowBox[{"1", ",", "1"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"2", ",", "2"}], "]"}], " ", 
    RowBox[{"b", "[", 
     RowBox[{"1", ",", "2"}], "]"}], " ", 
    RowBox[{"c", "[", 
     RowBox[{"1", ",", "1"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"2", ",", "3"}], "]"}], " ", 
    RowBox[{"b", "[", 
     RowBox[{"1", ",", "3"}], "]"}], " ", 
    RowBox[{"c", "[", 
     RowBox[{"1", ",", "1"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"1", ",", "1"}], "]"}], " ", 
    RowBox[{"b", "[", 
     RowBox[{"1", ",", "1"}], "]"}], " ", 
    RowBox[{"c", "[", 
     RowBox[{"2", ",", "1"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"1", ",", "2"}], "]"}], " ", 
    RowBox[{"b", "[", 
     RowBox[{"1", ",", "2"}], "]"}], " ", 
    RowBox[{"c", "[", 
     RowBox[{"2", ",", "1"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"1", ",", "3"}], "]"}], " ", 
    RowBox[{"b", "[", 
     RowBox[{"1", ",", "3"}], "]"}], " ", 
    RowBox[{"c", "[", 
     RowBox[{"2", ",", "1"}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{484, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->316621270]
}, Open  ]],

Cell[TextData[{
 "Note that in the output the first field/representation is always called ",
 Cell[BoxData["a"], "InlineFormula"],
 ", the second ",
 Cell[BoxData["b"], "InlineFormula"],
 ", the third ",
 Cell[BoxData["c"], "InlineFormula"],
 ", and so on. So in this last example, given that the groups are {SU2,SU3}, \
each of these fields has two indices: (a or b or c)[SU2Index,SU3Index]."
}], "ExampleText",
 CellID->597458693]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[ButtonBox["IrrepInProduct",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/ref/IrrepInProduct"]], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Invariants - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2013, 8, 7, 2, 27, 25.3437500}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "Invariants[group, {rep1, rep2, ...}] Calculates the invariants of rep1 x \
rep2 x \\[CenterEllipsis]", "synonyms" -> {}, "title" -> "Invariants", "type" -> 
    "Symbol", "uri" -> "Susyno/ref/Invariants"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7963, 266, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->132666956]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23454, 825}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[591, 21, 76, 1, 70, "SymbolColorBar"],
Cell[670, 24, 178, 5, 70, "LinkTrail"],
Cell[851, 31, 2306, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3182, 88, 53, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[3238, 91, 621, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3896, 115, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->195041733],
Cell[4479, 134, 236, 8, 70, "Notes",
 CellID->1067943069],
Cell[4718, 144, 181, 5, 70, "Notes",
 CellID->41030773],
Cell[4902, 151, 182, 4, 70, "Notes",
 CellID->221237370],
Cell[5087, 157, 751, 24, 70, "Notes",
 CellID->400920173],
Cell[5841, 183, 444, 16, 70, "Notes",
 CellID->75953507],
Cell[6288, 201, 993, 35, 70, "Notes",
 CellID->10758554],
Cell[7284, 238, 154, 6, 70, "Notes",
 CellID->335181877],
Cell[7441, 246, 157, 4, 70, "Notes",
 CellID->898809850],
Cell[7601, 252, 325, 9, 70, "Notes",
 CellID->329977022]
}, Closed]],
Cell[CellGroupData[{
Cell[7963, 266, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->132666956],
Cell[CellGroupData[{
Cell[8449, 283, 147, 5, 70, "ExampleSection",
 CellID->19140300],
Cell[8599, 290, 112, 3, 70, "ExampleText",
 CellID->513681956],
Cell[CellGroupData[{
Cell[8736, 297, 232, 8, 70, "Input",
 CellID->196926373],
Cell[8971, 307, 372, 13, 36, "Output",
 CellID->162871902]
}, Open  ]],
Cell[9358, 323, 116, 3, 70, "ExampleText",
 CellID->155872588],
Cell[CellGroupData[{
Cell[9499, 330, 268, 9, 70, "Input",
 CellID->459878862],
Cell[9770, 341, 1079, 37, 58, "Output",
 CellID->709250]
}, Open  ]],
Cell[10864, 381, 142, 4, 70, "ExampleText",
 CellID->307224643],
Cell[CellGroupData[{
Cell[11031, 389, 180, 6, 70, "Input",
 CellID->744812328],
Cell[11214, 397, 768, 25, 43, "Output",
 CellID->780334933]
}, Open  ]],
Cell[11997, 425, 135, 4, 70, "ExampleText",
 CellID->285596647],
Cell[CellGroupData[{
Cell[12157, 433, 390, 13, 70, "Input",
 CellID->125780274],
Cell[12550, 448, 466, 16, 36, "Output",
 CellID->547169760]
}, Open  ]],
Cell[13031, 467, 175, 4, 70, "ExampleText",
 CellID->178491849],
Cell[CellGroupData[{
Cell[13231, 475, 284, 10, 70, "Input",
 CellID->3239219],
Cell[13518, 487, 465, 16, 36, "Output",
 CellID->96088639]
}, Open  ]],
Cell[13998, 506, 230, 5, 70, "ExampleText",
 CellID->227005108],
Cell[CellGroupData[{
Cell[14253, 515, 350, 11, 70, "Input",
 CellID->440424632],
Cell[14606, 528, 1126, 37, 54, "Output",
 CellID->429779945]
}, Open  ]],
Cell[15747, 568, 521, 10, 70, "ExampleText",
 CellID->180242795],
Cell[CellGroupData[{
Cell[16293, 582, 455, 14, 70, "Input",
 CellID->388476289],
Cell[16751, 598, 1126, 37, 54, "Output",
 CellID->666374976]
}, Open  ]],
Cell[17892, 638, 133, 4, 70, "ExampleText",
 CellID->259255305],
Cell[CellGroupData[{
Cell[18050, 646, 890, 33, 70, "Input",
 CellID->595169869],
Cell[18943, 681, 1456, 49, 54, "Output",
 CellID->316621270]
}, Open  ]],
Cell[20414, 733, 432, 10, 70, "ExampleText",
 CellID->597458693]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20895, 749, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[21317, 763, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[21505, 771, 427, 12, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[21935, 785, 149, 3, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[22099, 791, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

