(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9919,        332]
NotebookOptionsPosition[      7107,        241]
NotebookOutlinePosition[      8673,        286]
CellTagsIndexPosition[      8589,        281]
WindowTitle->ConjugateIrrep - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/ConjugateIrrep\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/ConjugateIrrep"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
ConjugateIrrep.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/ConjugateIrrep", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["ConjugateIrrep", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConjugateIrrep", "[", 
       RowBox[{"group", ",", "rep"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]Computes the Dynkin indices of the representation \
conjugate to ",
     Cell[BoxData["rep"], "InlineFormula"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->283900292],

Cell[TextData[{
 Cell[BoxData["group"], "InlineFormula"],
 " should be a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 " of a simple group."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->91401959],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->12471916],

Cell["\<\
Compute the conjugate representation to {1, 0, 2, 0} of the SU(5) group:\
\>", "ExampleText",
 CellID->32979335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConjugateIrrep", "[", 
  RowBox[{"SU5", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "2", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->280814282],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "2", ",", "0", ",", "1"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->201611465]
}, Open  ]],

Cell["The Dynkin coefficients can be symbolic:", "ExampleText",
 CellID->312700170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConjugateIrrep", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192311210],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x1", ",", "x2", ",", "x3", ",", "x5", ",", "x4"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10171402]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConjugateIrrep - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2013, 8, 7, 2, 26, 44.3750000}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "ConjugateIrrep[group, rep] Computes the Dynkin indices of the \
representation conjugate to rep", "synonyms" -> {}, "title" -> 
    "ConjugateIrrep", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/ConjugateIrrep"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4632, 142, 460, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->91401959]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8447, 274}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[595, 21, 76, 1, 70, "SymbolColorBar"],
Cell[674, 24, 178, 5, 70, "LinkTrail"],
Cell[855, 31, 2322, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3202, 88, 57, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[3262, 91, 483, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3782, 110, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->283900292],
Cell[4365, 129, 230, 8, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[4632, 142, 460, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->91401959],
Cell[CellGroupData[{
Cell[5117, 159, 147, 5, 70, "ExampleSection",
 CellID->12471916],
Cell[5267, 166, 122, 3, 70, "ExampleText",
 CellID->32979335],
Cell[CellGroupData[{
Cell[5414, 173, 204, 6, 70, "Input",
 CellID->280814282],
Cell[5621, 181, 223, 7, 36, "Output",
 CellID->201611465]
}, Open  ]],
Cell[5859, 191, 83, 1, 70, "ExampleText",
 CellID->312700170],
Cell[CellGroupData[{
Cell[5967, 196, 223, 7, 70, "Input",
 CellID->192311210],
Cell[6193, 205, 238, 7, 36, "Output",
 CellID->10171402]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6492, 219, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[6914, 233, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[7080, 239, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

