(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14981,        506]
NotebookOptionsPosition[     11555,        392]
NotebookOutlinePosition[     13086,        436]
CellTagsIndexPosition[     13001,        431]
WindowTitle->Casimir - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/Casimir\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/Casimir"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/Casimir.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", "Susyno/ref/Casimir",
              ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["Casimir", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Casimir", "[", 
       RowBox[{"group", ",", " ", "rep"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]Computes the quadratic Casimir of representation ",
     Cell[BoxData["rep"], "InlineFormula"],
     " of ",
     Cell[BoxData["group"], "InlineFormula"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->59836205],

Cell[TextData[{
 Cell[BoxData["group"], "InlineFormula"],
 " should a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 ";"
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Each representation ",
 Cell[BoxData["rep"], "InlineFormula"],
 " should be a list of non-negative integers (Dynkin coefficients)."
}], "Notes",
 CellID->125196071]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->172084995],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->39933526],

Cell[TextData[{
 "The usual convention of having the fundamental of SU(n) with a Casimir ",
 Cell[BoxData[
  FractionBox[
   RowBox[{
    SuperscriptBox["n", "2"], "-", "1"}], 
   RowBox[{"2", "n"}]]], "InlineFormula"],
 " is respected by this method:"
}], "ExampleText",
 CellID->32979335],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Casimir of the fundamental of SU(2): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"SU2", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Casimir of the fundamental of SU(3): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"SU3", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Casimir of the fundamental of SU(4): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"SU4", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Casimir of the fundamental of SU(5): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"SU5", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "]"}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->280814282],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Casimir of the fundamental of SU(2): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["3", "4"]}],
  SequenceForm["Casimir of the fundamental of SU(2): ", 
   Rational[3, 4]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->228298276],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Casimir of the fundamental of SU(3): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["4", "3"]}],
  SequenceForm["Casimir of the fundamental of SU(3): ", 
   Rational[4, 3]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->77120153],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Casimir of the fundamental of SU(4): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["15", "8"]}],
  SequenceForm["Casimir of the fundamental of SU(4): ", 
   Rational[15, 8]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->442042769],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Casimir of the fundamental of SU(5): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["12", "5"]}],
  SequenceForm["Casimir of the fundamental of SU(5): ", 
   Rational[12, 5]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->67545091]
}, Open  ]]
}, Open  ]],

Cell["\<\
C(G), the Casimir of the adjoint representation, can be found using the \
Adjoint method:\
\>", "ExampleText",
 CellID->6164437],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<C(G) of SU(2): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"SU2", ",", 
      RowBox[{"Adjoint", "[", "SU2", "]"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<C(G) of SU(5): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"SU5", ",", 
      RowBox[{"Adjoint", "[", "SU5", "]"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<C(G) of SO(10): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"SO10", ",", 
      RowBox[{"Adjoint", "[", "SO10", "]"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<C(G) of E(6): \>\"", ",", 
    RowBox[{"Casimir", "[", 
     RowBox[{"E6", ",", 
      RowBox[{"Adjoint", "[", "E6", "]"}]}], "]"}]}], "]"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->194792086],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C(G) of SU(2): \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["C(G) of SU(2): ", 2],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->491564830],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C(G) of SU(5): \"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm["C(G) of SU(5): ", 5],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->101124815],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C(G) of SO(10): \"\>", "\[InvisibleSpace]", "8"}],
  SequenceForm["C(G) of SO(10): ", 8],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->409490347],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C(G) of E(6): \"\>", "\[InvisibleSpace]", "12"}],
  SequenceForm["C(G) of E(6): ", 12],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->54151611]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[ButtonBox["Adjoint",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/ref/Adjoint"]], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Casimir - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 3, 2, 12, 14, 24.8593750}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "Casimir[group, rep] Computes the quadratic Casimir of representation rep \
of group", "synonyms" -> {}, "title" -> "Casimir", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/Casimir"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4793, 150, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->172084995]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12858, 424}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[588, 21, 76, 1, 70, "SymbolColorBar"],
Cell[667, 24, 178, 5, 70, "LinkTrail"],
Cell[848, 31, 2293, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3166, 88, 50, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[3219, 91, 524, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3780, 111, 579, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->59836205],
Cell[4362, 130, 209, 8, 70, "Notes",
 CellID->1067943069],
Cell[4574, 140, 182, 5, 70, "Notes",
 CellID->125196071]
}, Closed]],
Cell[CellGroupData[{
Cell[4793, 150, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->172084995],
Cell[CellGroupData[{
Cell[5279, 167, 147, 5, 70, "ExampleSection",
 CellID->39933526],
Cell[5429, 174, 290, 9, 70, "ExampleText",
 CellID->32979335],
Cell[CellGroupData[{
Cell[5744, 187, 1111, 32, 70, "Input",
 CellID->280814282],
Cell[CellGroupData[{
Cell[6880, 223, 317, 9, 70, "Print",
 CellID->228298276],
Cell[7200, 234, 316, 9, 70, "Print",
 CellID->77120153],
Cell[7519, 245, 319, 9, 70, "Print",
 CellID->442042769],
Cell[7841, 256, 318, 9, 70, "Print",
 CellID->67545091]
}, Open  ]]
}, Open  ]],
Cell[8186, 269, 138, 4, 70, "ExampleText",
 CellID->6164437],
Cell[CellGroupData[{
Cell[8349, 277, 961, 29, 70, "Input",
 CellID->194792086],
Cell[CellGroupData[{
Cell[9335, 310, 230, 6, 70, "Print",
 CellID->491564830],
Cell[9568, 318, 230, 6, 70, "Print",
 CellID->101124815],
Cell[9801, 326, 232, 6, 70, "Print",
 CellID->409490347],
Cell[10036, 334, 229, 6, 70, "Print",
 CellID->54151611]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10338, 348, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[10760, 362, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[10948, 370, 427, 12, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[11378, 384, 135, 3, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[11528, 390, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

