(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     95642,       3111]
NotebookOptionsPosition[     83391,       2705]
NotebookOutlinePosition[     85597,       2759]
CellTagsIndexPosition[     85554,       2756]
WindowTitle->Susyno Tutorial - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->
         False], {"\<\"http://web.ist.utl.pt/renato.fonseca/susyno.html\"\>":>
       Documentation`HelpLookup[
        If[
         StringMatchQ[
          StringReplace[{
            URL["http://web.ist.utl.pt/renato.fonseca/susyno.html"], None}, 
           "paclet:" :> ""], "paclet*"], 
         Part[
          Part[{{"http://web.ist.utl.pt/renato.fonseca/susyno.html", 
             StringReplace[{
               URL["http://web.ist.utl.pt/renato.fonseca/susyno.html"], None},
               "paclet:" :> ""]}, {"arXiv:1106.5016 [hep-ph]", 
             StringReplace[{
               URL["http://arxiv.org/abs/1106.5016"], None}, "paclet:" :> 
              ""]}, {"R. Slansky, Phys.Rept. 79 (1981)", 
             StringReplace[{
               URL["http://dx.doi.org/10.1016/0370-1573(81)90092-2"], None}, 
              "paclet:" :> ""]}, {}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"http://web.ist.utl.pt/renato.fonseca/susyno.html", 
              StringReplace[{
                URL["http://web.ist.utl.pt/renato.fonseca/susyno.html"], 
                None}, "paclet:" :> ""]}, {"arXiv:1106.5016 [hep-ph]", 
              StringReplace[{
                URL["http://arxiv.org/abs/1106.5016"], None}, "paclet:" :> 
               ""]}, {"R. Slansky, Phys.Rept. 79 (1981)", 
              StringReplace[{
                URL["http://dx.doi.org/10.1016/0370-1573(81)90092-2"], None}, 
               "paclet:" :> ""]}, {}}, 1], 
           2]]]], "\<\"arXiv:1106.5016 [hep-ph]\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[
          StringReplace[{
            URL["http://arxiv.org/abs/1106.5016"], None}, "paclet:" :> ""], 
          "paclet*"], 
         Part[
          Part[{{"http://web.ist.utl.pt/renato.fonseca/susyno.html", 
             StringReplace[{
               URL["http://web.ist.utl.pt/renato.fonseca/susyno.html"], None},
               "paclet:" :> ""]}, {"arXiv:1106.5016 [hep-ph]", 
             StringReplace[{
               URL["http://arxiv.org/abs/1106.5016"], None}, "paclet:" :> 
              ""]}, {"R. Slansky, Phys.Rept. 79 (1981)", 
             StringReplace[{
               URL["http://dx.doi.org/10.1016/0370-1573(81)90092-2"], None}, 
              "paclet:" :> ""]}, {}}, 2], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"http://web.ist.utl.pt/renato.fonseca/susyno.html", 
              StringReplace[{
                URL["http://web.ist.utl.pt/renato.fonseca/susyno.html"], 
                None}, "paclet:" :> ""]}, {"arXiv:1106.5016 [hep-ph]", 
              StringReplace[{
                URL["http://arxiv.org/abs/1106.5016"], None}, "paclet:" :> 
               ""]}, {"R. Slansky, Phys.Rept. 79 (1981)", 
              StringReplace[{
                URL["http://dx.doi.org/10.1016/0370-1573(81)90092-2"], None}, 
               "paclet:" :> ""]}, {}}, 2], 
           2]]]], "\<\"R. Slansky, Phys.Rept. 79 (1981)\"\>":>
       Documentation`HelpLookup[
        If[
         StringMatchQ[
          StringReplace[{
            URL["http://dx.doi.org/10.1016/0370-1573(81)90092-2"], None}, 
           "paclet:" :> ""], "paclet*"], 
         Part[
          Part[{{"http://web.ist.utl.pt/renato.fonseca/susyno.html", 
             StringReplace[{
               URL["http://web.ist.utl.pt/renato.fonseca/susyno.html"], None},
               "paclet:" :> ""]}, {"arXiv:1106.5016 [hep-ph]", 
             StringReplace[{
               URL["http://arxiv.org/abs/1106.5016"], None}, "paclet:" :> 
              ""]}, {"R. Slansky, Phys.Rept. 79 (1981)", 
             StringReplace[{
               URL["http://dx.doi.org/10.1016/0370-1573(81)90092-2"], None}, 
              "paclet:" :> ""]}, {}}, 3], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"http://web.ist.utl.pt/renato.fonseca/susyno.html", 
              StringReplace[{
                URL["http://web.ist.utl.pt/renato.fonseca/susyno.html"], 
                None}, "paclet:" :> ""]}, {"arXiv:1106.5016 [hep-ph]", 
              StringReplace[{
                URL["http://arxiv.org/abs/1106.5016"], None}, "paclet:" :> 
               ""]}, {"R. Slansky, Phys.Rept. 79 (1981)", 
              StringReplace[{
                URL["http://dx.doi.org/10.1016/0370-1573(81)90092-2"], None}, 
               "paclet:" :> ""]}, {}}, 3], 2]]]], 
       RowBox[{
        RowBox[{"{", "}"}], "\[LeftDoubleBracket]", "1", 
        "\[RightDoubleBracket]"}]:>Documentation`HelpLookup[
        If[
         StringMatchQ[
          Part[{}, 2], "paclet*"], 
         Part[
          Part[{{"http://web.ist.utl.pt/renato.fonseca/susyno.html", 
             StringReplace[{
               URL["http://web.ist.utl.pt/renato.fonseca/susyno.html"], None},
               "paclet:" :> ""]}, {"arXiv:1106.5016 [hep-ph]", 
             StringReplace[{
               URL["http://arxiv.org/abs/1106.5016"], None}, "paclet:" :> 
              ""]}, {"R. Slansky, Phys.Rept. 79 (1981)", 
             StringReplace[{
               URL["http://dx.doi.org/10.1016/0370-1573(81)90092-2"], None}, 
              "paclet:" :> ""]}, {}}, 4], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"http://web.ist.utl.pt/renato.fonseca/susyno.html", 
              StringReplace[{
                URL["http://web.ist.utl.pt/renato.fonseca/susyno.html"], 
                None}, "paclet:" :> ""]}, {"arXiv:1106.5016 [hep-ph]", 
              StringReplace[{
                URL["http://arxiv.org/abs/1106.5016"], None}, "paclet:" :> 
               ""]}, {"R. Slansky, Phys.Rept. 79 (1981)", 
              StringReplace[{
                URL["http://dx.doi.org/10.1016/0370-1573(81)90092-2"], None}, 
               "paclet:" :> ""]}, {}}, 4], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Functions \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Adjoint\"\>":>Documentation`HelpLookup[
       "paclet:Susyno/ref/Adjoint"], "\<\"BetaFunctions1L\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/BetaFunctions1L"], "\<\"BetaFunctions2L\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/BetaFunctions2L"], "\<\"CanonicalForm\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CanonicalForm"], "\<\"CartanMatrix\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"Casimir\"\>":>
       Documentation`HelpLookup["paclet:Susyno/ref/Casimir"], "\<\"DimR\"\>":>
       Documentation`HelpLookup["paclet:Susyno/ref/DimR"], "\<\"E6\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"E7\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"E8\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"F4\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"G2\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"Invariants\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/Invariants"], "\<\"ListContract\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/ListContract"], "\<\"MSSM\"\>":>
       Documentation`HelpLookup["paclet:Susyno/ref/MSSM"], "\<\"NMSSM\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/NMSSM"], "\<\"PositiveRoots\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/PositiveRoots"], "\<\"ReduceRepProduct\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/ReduceRepProduct"], "\<\"RepMatrices\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/RepMatrices"], "\<\"ShowLagrangian\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/ShowLagrangian"], "\<\"SO3\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"SO32\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"SO5\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"SO6\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"SO7\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"SP2\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"SP32\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"SP4\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"SP6\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"SP8\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"SU2\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"SU3\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"SU32\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"SU4\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"SU5\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"U1\"\>":>
       Documentation`HelpLookup[
       "paclet:Susyno/ref/CartanMatrix"], "\<\"Weights\"\>":>
       Documentation`HelpLookup["paclet:Susyno/ref/Weights"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/tutorial/SusynoTutorial\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/tutorial/SusynoTutorial"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/tutorial/\
SusynoTutorial.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/tutorial/SusynoTutorial", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["Susyno Tutorial", "Title",
 CellID->509267359],

Cell["\<\
Susyno is a package which calculates the 2-loop renormalization group \
equations (RGEs) of SUSY models. The input is just the gauge group, \
representations, number of flavours and any abelian symmetries of the model. \
Susyno then automatically generates the Lagrangian and other group \
theoretical quantities. These are then used to calculate the \[Beta] \
functions for all the parameters of the model.\
\>", "Text",
 CellID->1534169418],

Cell["\<\
Some of the internally used methods are exposed to the user. In particular \
there are group theoretical methods that may be useful.\
\>", "Text",
 CellID->99754619],

Cell[TextData[{
 "This package should work on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 7 and latter."
}], "Text",
 CellID->421768310],

Cell["This loads the package:", "MathCaption",
 CellID->836781195],

Cell[BoxData[
 RowBox[{"<<", "Susyno`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2058623809],

Cell[CellGroupData[{

Cell["Quick start (MSSM example)", "Section",
 CellID->2591],

Cell["\<\
After loading the package the following code will compute the MSSM's two loop \
RGEs.\
\>", "Text",
 CellID->24858853],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "the", " ", "gauge", " ", "factor", " ", "groups", " ", "and", 
    " ", "the", " ", 
    RowBox[{"fields", "/", "representations"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Also", " ", "set", " ", "the", " ", "number", " ", "of", " ", "flavours",
      " ", "and", " ", "R"}], "-", 
    RowBox[{"parity", " ", "of", " ", "each", " ", "field"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"norm", "=", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"3", "/", "5"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"U1", "->", 
        RowBox[{
         RowBox[{"1", "/", "6"}], " ", "norm"}]}], " ", ",", 
       RowBox[{"SU2", "->", 
        RowBox[{"{", "1", "}"}]}], ",", 
       RowBox[{"SU3", "->", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], ",", 
       RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
       RowBox[{"DiscreteSym", "\[Rule]", 
        RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"U1", "->", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], "/", "3"}], " ", "norm"}]}], " ", ",", 
       RowBox[{"SU2", "->", 
        RowBox[{"{", "0", "}"}]}], ",", 
       RowBox[{"SU3", "->", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], ",", 
       RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
       RowBox[{"DiscreteSym", "\[Rule]", 
        RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"U1", "\[Rule]", 
        RowBox[{
         RowBox[{"1", "/", "3"}], " ", "norm"}]}], " ", ",", 
       RowBox[{"SU2", "->", 
        RowBox[{"{", "0", "}"}]}], ",", 
       RowBox[{"SU3", "->", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], ",", 
       RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
       RowBox[{"DiscreteSym", "\[Rule]", 
        RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"L", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"U1", "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], " ", "norm"}]}], " ", ",", 
       RowBox[{"SU2", "->", 
        RowBox[{"{", "1", "}"}]}], ",", 
       RowBox[{"SU3", "->", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], ",", 
       RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
       RowBox[{"DiscreteSym", "\[Rule]", 
        RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"U1", "\[Rule]", " ", "norm"}], " ", ",", 
       RowBox[{"SU2", "->", 
        RowBox[{"{", "0", "}"}]}], ",", 
       RowBox[{"SU3", "->", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], ",", 
       RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
       RowBox[{"DiscreteSym", "\[Rule]", 
        RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Hu", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"U1", "\[Rule]", " ", 
        RowBox[{
         RowBox[{"1", "/", "2"}], "norm"}]}], " ", ",", 
       RowBox[{"SU2", "->", 
        RowBox[{"{", "1", "}"}]}], ",", 
       RowBox[{"SU3", "->", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], ",", 
       RowBox[{"NFlavours", "\[Rule]", "1"}], ",", 
       RowBox[{"DiscreteSym", "\[Rule]", "1"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Hd", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"U1", "\[Rule]", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], "norm"}]}], " ", ",", 
       RowBox[{"SU2", "->", 
        RowBox[{"{", "1", "}"}]}], ",", 
       RowBox[{"SU3", "->", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], ",", 
       RowBox[{"NFlavours", "\[Rule]", "1"}], ",", 
       RowBox[{"DiscreteSym", "\[Rule]", "1"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"model", "=", 
     RowBox[{"{", 
      RowBox[{
      "Q", ",", "u", ",", "d", ",", "L", ",", "e", ",", "Hu", ",", "Hd"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"BetaFunctions2L", "[", "model", "]"}], ";"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6265725],

Cell["To view the Lagrangian being used by the program type", "Text",
 CellID->44162439],

Cell[BoxData[
 RowBox[{"ShowLagrangian", "[", "model", "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->337054168]
}, Open  ]],

Cell[CellGroupData[{

Cell["Available functions", "Section",
 CellID->8978917],

Cell[BoxData[GridBox[{
   {
    ButtonBox["BetaFunctions1L",
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/BetaFunctions1L"], Cell["\<\
Computes the 1-loop \[Beta] functions\
\>", "TableText"]},
   {
    ButtonBox["BetaFunctions2L",
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/BetaFunctions2L"], Cell["\<\
Computes the 2-loop \[Beta] functions\
\>", "TableText"]},
   {
    ButtonBox["ShowLagrangian",
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/ShowLagrangian"], Cell["\<\
Shows the Lagrangian used to compute the \[Beta] functions\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->306150231],

Cell["Functions from Susyno.m", "Caption",
 CellID->25601712],

Cell[BoxData[GridBox[{
   {
    ButtonBox["DimR",
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/DimR"], Cell[
    "Computes the dimension of a representation", "TableText"]},
   {
    ButtonBox["ReduceRepProduct",
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/ReduceRepProduct"], Cell["\<\
Decomposes a direct product representation in its irreducible parts\
\>", "TableText"]},
   {
    ButtonBox["RepMatrices",
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/RepMatrices"], Cell[
    "Computes the representation matrices (in some basis)", "TableText"]},
   {
    ButtonBox["Invariants",
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/Invariants"], Cell["\<\
Computes the invariant combinations of a product of 1,2 or 3 representations\
\>", "TableText"]},
   {
    ButtonBox["CartanMatrix",
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/CartanMatrix"], Cell[
    "Computes the Cartan matrix of a group", "TableText"]},
   {
    ButtonBox["Casimir",
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/Casimir"], Cell[
    "Computes the Casimir of a representation", "TableText"]},
   {
    ButtonBox["Adjoint",
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/Adjoint"], Cell[
    "Computes the adjoint representation of a group", "TableText"]},
   {
    ButtonBox["Weights",
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/Weights"], Cell[
    "Computes the weights of a representation", "TableText"]},
   {
    ButtonBox["PositiveRoots",
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/PositiveRoots"], Cell[
    "Computes the positive roots of a group", "TableText"]}
  }]], "DefinitionBox",
 CellID->110605517],

Cell["Functions from LieGroups.m", "Caption",
 CellID->108810841],

Cell[BoxData[GridBox[{
   {
    ButtonBox["CanonicalForm",
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/CanonicalForm"], Cell[
    "Simplifies an expression written in the Einstein convention", 
     "TableText"]},
   {
    ButtonBox["ListContract",
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/ListContract"], Cell[TextData[Cell[
    BoxData[Cell[
     "Efficiently calculates traces of multi-index tensors", "TableText"]]]], 
     "TableText"]}
  }]], "DefinitionBox",
 CellID->70978957],

Cell["Functions from SusyRGEs.m", "Caption",
 CellID->145991187]
}, Open  ]],

Cell[CellGroupData[{

Cell["Available variables", "Section",
 CellID->199085598],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MSSM",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/MSSM"], ",", " ", 
     ButtonBox["NMSSM",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/NMSSM"]}], Cell["\<\
Variables with all the information on the MSSM and NMSSM models ready to use\
\>", "TableText"]},
   {
    ButtonBox["U1",
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/CartanMatrix"], Cell[
    "The same as {}", "TableText"]},
   {
    RowBox[{
     ButtonBox["SU2",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", 
     ButtonBox["SU3",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", 
     ButtonBox["SU4",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", 
     ButtonBox["SU5",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", " ", "...", ",", 
     ButtonBox["SU32",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"]}], Cell[
    "Cartan matrices of these simple groups", "TableText"]},
   {
    RowBox[{
     ButtonBox["SO3",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", 
     ButtonBox["SO5",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", 
     ButtonBox["SO6",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", 
     ButtonBox["SO7",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", " ", "...", ",", 
     ButtonBox["SO32",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"]}], Cell[
    "Cartan matrices of these simple groups (SO4 is not simple)", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["SP2",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", 
     ButtonBox["SP4",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", 
     ButtonBox["SP6",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", 
     ButtonBox["SP8",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", " ", "...", ",", 
     ButtonBox["SP32",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"]}], Cell[
    "Cartan matrices of these simple groups", "TableText"]},
   {
    RowBox[{
     ButtonBox["G2",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", 
     ButtonBox["F4",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", 
     ButtonBox["E6",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", 
     ButtonBox["E7",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"], ",", 
     ButtonBox["E8",
      BaseStyle->"Link",
      ButtonData->"paclet:Susyno/ref/CartanMatrix"]}], Cell[
    "Cartan matrices of these simple groups", "TableText"]}
  }]], "DefinitionBox",
 CellID->856307529]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing a model", "Section",
 CellID->53920555],

Cell[TextData[{
 "Ultimately we want to call ",
 Cell[BoxData[
  ButtonBox["BetaFunctions2L",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/BetaFunctions2L"]], "InlineFormula"],
 " (for 2-loop results) or ",
 Cell[BoxData[
  ButtonBox["BetaFunctions1L",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/BetaFunctions1L"]], "InlineFormula"],
 " (for 1-loop results). These functions require the details of the model: \
gauge groups, representations, number of flavours and abelian discrete \
symmetry of each field (if any). In particular, Susyno does not need names of \
fields nor names of parameters of the model; only the above defining elements \
of the model are necessary."
}], "Text",
 CellID->100635996],

Cell[TextData[{
 "The basic idea is to build a list of chiral superfields (I'll call them \
simply ",
 StyleBox["fields", "TI"],
 "):"
}], "Text",
 CellID->423206022],

Cell["A model is just a list of fields:", "MathCaption",
 CellID->824451330],

Cell["model={field1,field2,...};", "Code",
 Evaluatable->False,
 InitializationCell->False,
 CellID->13441295],

Cell["\<\
Each field must contain the information on the representations under the \
gauge groups, number of flavours, and abelian discrete symmetries (if any):\
\>", "Text",
 CellID->388589019],

Cell["A generic example of a field: ", "MathCaption",
 CellID->154743581],

Cell["\<\
field={g1->g1_rep,g2->g2_rep,...,NFlavours \[Rule] nf,DiscreteSym \[Rule] q};\
\>", "Code",
 Evaluatable->False,
 InitializationCell->False,
 CellID->487015284],

Cell["where ...", "Text",
 CellID->160230726],

Cell[">>> g1,g2,... are the gauge factor groups;", "Text",
 CellID->633280229],

Cell["\<\
>>> g1_rep, g2_rep, ... are the representations under the gauge factor groups \
of the field;\
\>", "Text",
 CellID->4571369],

Cell[">>> nf is the number of flavours/copies;", "Text",
 CellID->455991224],

Cell["\<\
>>> q is the charge of the field under some abelian discrete symmetries (like \
R-parity).\
\>", "Text",
 CellID->13923596],

Cell[TextData[StyleBox["Groups", "Subsection"]], "Text",
 CellID->22581803],

Cell[TextData[{
 "Susyno accepts a direct product of any Lie groups - see the ",
 Cell[BoxData[
  ButtonBox["CartanMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/CartanMatrix"]], "InlineFormula"],
 " method for details.  There are two important things to keep in mind:"
}], "Text",
 CellID->58772511],

Cell["\<\
>>> The ordering of the factor groups must be consistent across all fields;\
\>", "Text",
 CellID->195708328],

Cell[">>> U(1) factor groups must come first.", "Text",
 CellID->193008405],

Cell[CellGroupData[{

Cell["Representations", "Subsection",
 CellID->264470554],

Cell["\<\
A real number (hypercharge) specifies a representation of a U(1) factor \
group. So we should write\
\>", "Text",
 CellID->68464658],

Cell["To specify a U(1) representation we just need a real number:", \
"MathCaption",
 CellID->315402278],

Cell["U1->(some number)", "Code",
 Evaluatable->False,
 InitializationCell->False,
 CellID->38080131],

Cell[TextData[{
 "Things are a little more complicated for simple gauge groups like SU(n), \
SO(n), .... Representations of these groups are often specified by their \
dimension [",
 StyleBox["3",
  FontWeight->"Bold"],
 " of SU(3), ",
 StyleBox["45",
  FontWeight->"Bold"],
 " of SO(10), ",
 StyleBox["24",
  FontWeight->"Bold"],
 " of SU(5), etc]. Susyno does not accept this because the dimensionality of \
a representation can be an ambiguous label for it. For example, there are two \
irreducible 15-dimensional representations of SU(3) [four if we include the \
conjugated ones]."
}], "Text",
 CellID->87239316],

Cell["\<\
Instead, the program expects for each field and for each simple gauge factor \
group a representation that should be specified by its Dynkin coefficients. \
These are just a list of n non-negative integers where n is the group rank. \
To find n, type\
\>", "Text",
 CellID->719752033],

Cell["Length[group]", "Code",
 CellID->99800453],

Cell["Rank of SU(3):", "MathCaption",
 CellID->38172770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "SU3", "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->252225000],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->264615598]
}, Open  ]],

Cell["Rank of SO(10):", "MathCaption",
 CellID->9207279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "SO10", "]"}]], "Input",
 CellLabel->"In[41]:=",
 CellID->453374297],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]=",
 CellID->12440822]
}, Open  ]],

Cell["\<\
For instance, {0,0},{0,1},{1,0},{1,1},... is a complete listing of the \
representations of SU(3). These are also the Dynkin coefficients that Susyno \
wants.\
\>", "Text",
 CellID->186840582],

Cell[TextData[{
 "Some familiarity might be needed with this notation. One way to explore \
this topic is to read a reference such as ",
 ButtonBox["R. Slansky, Phys.Rept. 79 (1981)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://dx.doi.org/10.1016/0370-1573(81)90092-2"], None}],
 " where there are long tables of the representations of each group and some \
of their properties."
}], "Text",
 CellID->13545047],

Cell[TextData[{
 "Another possibility is to explore the properties of each representation \
(given in Dynkin coefficients) with some of the methods included in Susyno \
itself. ",
 Cell[BoxData[
  ButtonBox["DimR",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/DimR"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ReduceRepProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/ReduceRepProduct"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RepMatrices",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/RepMatrices"]], "InlineFormula"],
 " may be particularly useful."
}], "Text",
 CellID->291374766],

Cell["\<\
No other pair of non-negative integers {x,y} has dimension 8. Therefore {1,1} \
is the adjoint representation of SU(3):\
\>", "MathCaption",
 CellID->454189483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DimR", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[42]:=",
 CellID->514460268],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[42]=",
 CellID->166118683]
}, Open  ]],

Cell["\<\
In any case, here is a list of some of the representations that show up in \
Particle Physics:\
\>", "Text",
 CellID->186880836],

Cell[BoxData[GridBox[{
   {Cell["Group", "TableHeader"], Cell["Representation", "TableHeader"], " "},
   {
    RowBox[{"SU", 
     RowBox[{"(", "2", ")"}]}], 
    RowBox[{"{", "0", "}"}], 
    RowBox[{
     StyleBox["1",
      FontFamily->"Courier New",
      FontWeight->"Bold"], " ", 
     RowBox[{"(", "trivial", ")"}]}]},
   {" ", 
    RowBox[{"{", "1", "}"}], 
    RowBox[{
     StyleBox["2",
      FontFamily->"Courier New",
      FontWeight->"Bold"], " ", 
     RowBox[{"(", "fundamental", ")"}]}]},
   {" ", 
    RowBox[{"{", "2", "}"}], 
    RowBox[{
     StyleBox["3",
      FontFamily->"Courier New",
      FontWeight->"Bold"], 
     RowBox[{"(", "adjoint", ")"}]}]},
   {
    RowBox[{"SU", 
     RowBox[{"(", "3", ")"}]}], 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], 
    RowBox[{
     StyleBox["1",
      FontFamily->"Courier New",
      FontWeight->"Bold"], " ", 
     RowBox[{"(", "trivial", ")"}]}]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], 
    RowBox[{
     StyleBox["3",
      FontFamily->"Courier New",
      FontWeight->"Bold"], 
     RowBox[{"(", "fundamental", ")"}]}]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], 
    RowBox[{
     StyleBox[
      OverscriptBox[
       StyleBox["3",
        FontFamily->"Courier New",
        FontWeight->"Bold"], "_"],
      FontFamily->"Courier New",
      FontWeight->"Bold"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"fundamental", "'"}], "s", " ", "conjugate"}], ")"}]}]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], 
    RowBox[{
     StyleBox["8",
      FontFamily->"Courier New",
      FontWeight->"Bold"], 
     RowBox[{"(", "adjoint", ")"}]}]},
   {
    RowBox[{"SU", 
     RowBox[{"(", "5", ")"}]}], 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], 
    RowBox[{
     StyleBox["1",
      FontFamily->"Courier New",
      FontWeight->"Bold"], " ", 
     RowBox[{"(", "trivial", ")"}]}]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], 
    RowBox[{
     StyleBox["5",
      FontFamily->"Courier New",
      FontWeight->"Bold"], " ", 
     RowBox[{"(", "fundamental", ")"}]}]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], 
    RowBox[{
     StyleBox[
      OverscriptBox[
       StyleBox["5",
        FontFamily->"Courier New",
        FontWeight->"Bold"], "_"],
      FontFamily->"Courier New",
      FontWeight->"Bold"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"fundamental", "'"}], "s", " ", "conjugate"}], ")"}]}]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0", ",", "0", ",", "0"}], "}"}], 
    StyleBox["15",
     FontFamily->"Courier New",
     FontWeight->"Bold"]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], 
    StyleBox[
     OverscriptBox[
      StyleBox["15",
       FontFamily->"Courier New",
       FontWeight->"Bold"], "_"],
     FontFamily->"Courier New",
     FontWeight->"Bold"]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], 
    RowBox[{
     StyleBox["10",
      FontFamily->"Courier New",
      FontWeight->"Bold"], " "}]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "1"}], "}"}], 
    RowBox[{
     StyleBox["24",
      FontFamily->"Courier New",
      FontWeight->"Bold"], 
     RowBox[{"(", "adjoint", ")"}]}]},
   {
    RowBox[{"SO", 
     RowBox[{"(", "10", ")"}]}], 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
    RowBox[{
     StyleBox["1",
      FontFamily->"Courier New",
      FontWeight->"Bold"], " ", 
     RowBox[{"(", "trivial", ")"}]}]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
    RowBox[{
     StyleBox["10",
      FontFamily->"Courier New",
      FontWeight->"Bold"], " ", 
     RowBox[{"(", "fundamental", ")"}]}]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], 
    RowBox[{
     StyleBox["16",
      FontFamily->"Courier New",
      FontWeight->"Bold"], " ", 
     RowBox[{"(", "spinor", ")"}]}]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], 
    RowBox[{
     StyleBox[
      OverscriptBox[
       StyleBox["16",
        FontFamily->"Courier New",
        FontWeight->"Bold"], "_"],
      FontFamily->"Courier New",
      FontWeight->"Bold"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"spinor", "'"}], "s", " ", "conjugate"}], ")"}]}]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], 
    RowBox[{
     StyleBox["45",
      FontFamily->"Courier New",
      FontWeight->"Bold"], 
     RowBox[{"(", "adjoint", ")"}]}]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], 
    RowBox[{
     StyleBox["120",
      FontFamily->"Courier New",
      FontWeight->"Bold"], " "}]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
    RowBox[{
     StyleBox["126",
      FontFamily->"Courier New",
      FontWeight->"Bold"], " "}]},
   {" ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "0"}], "}"}], 
    RowBox[{
     StyleBox[
      OverscriptBox[
       StyleBox["126",
        FontFamily->"Courier New",
        FontWeight->"Bold"], "_"],
      FontFamily->"Courier New",
      FontWeight->"Bold"], " "}]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->3225],

Cell["Small list of useful representations.", "Caption",
 CellID->251894822],

Cell["\<\
For example, in the MSSM we have the trivial ({0,0}), fundamental ({1,0}) and \
anti-fundamental ({0,1}) representations of SU(3) and the trivial/singlet \
({0}) and fundamental/doublet ({1}) representations of SU(2).\
\>", "Text",
 CellID->53721323]
}, Open  ]],

Cell[CellGroupData[{

Cell["Number of flavours", "Subsection",
 CellID->130285366],

Cell["\<\
Many models contain repetitions of some of the representations of the gauge \
group. Instead of considering them distinct fields, we usually view these as \
different flavours of a single field and Susyno needs to know how many \
flavours there are in order to compute the \[Beta]-functions. The user must \
use the expression\
\>", "Text",
 CellID->346919154],

Cell["\<\
NFlavours \[Rule] (number of flavours)\
\>", "Code",
 Evaluatable->False,
 InitializationCell->False,
 CellID->109118134],

Cell[TextData[{
 "The number of flavours can be a number or a symbol like ",
 Cell[BoxData["x"], "InlineFormula"],
 ". If no NFlavours command is used in a particular field, that field is \
assumed to have ",
 Cell[BoxData[
  RowBox[{"nf", "[", "i", "]"}]], "InlineFormula"],
 " flavours, where i is the order of the field."
}], "Text",
 CellID->201997723]
}, Open  ]],

Cell[CellGroupData[{

Cell["Abelian discrete symmetries", "Subsection",
 CellID->167242659],

Cell[TextData[{
 "There are models in which we must forbid some couplings and in order to do \
that some abelian discrete symmetry is introduced. The MSSM is a good example \
- in this case there is a ",
 Cell[BoxData[
  SubscriptBox["Z", "2"]], "InlineFormula"],
 " symmetry called R-parity that imposes baryon and lepton number \
conservation (at the perturbative level).  To tell the program about the \
fields' charges under some ",
 Cell[BoxData[
  SubscriptBox["Z", "n"]], "InlineFormula"],
 " symmetry the user must use the expression"
}], "Text",
 CellID->239542694],

Cell["DiscreteSym \[Rule] (field charge) ", "Code",
 Evaluatable->False,
 InitializationCell->False,
 CellID->421781349],

Cell["The field charge must be a complex number with modulus 1.", "Text",
 CellID->60958078],

Cell[TextData[{
 "If there are many ",
 Cell[BoxData[
  SubscriptBox["Z", "n"]], "InlineFormula"],
 " symmetries we can always reduce them to a single one. But that is not \
necessary since the program also accepts a list of charges  (one for each \
abelian discrete symmetry). Note however that this number of charges must be \
the same for all fields."
}], "Text",
 CellID->174451658],

Cell["\<\
If no DiscreteSym command is used in a particular field, that field is \
assumed to have a trivial charge of 1.\
\>", "Text",
 CellID->6965007]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calling BetaFunctions1L / BetaFunctions2L", "Subsection",
 CellID->305509497],

Cell[TextData[{
 "Assuming that we have saved in a variable ",
 Cell[BoxData["model"], "InlineFormula"],
 " all the model's data, we may then call"
}], "Text",
 CellID->776410528],

Cell["1-loop \[Beta] functions", "MathCaption",
 CellID->649717704],

Cell[BoxData[
 RowBox[{"BetaFunctions1L", "[", "model", "]"}]], "Input",
 CellID->411943553],

Cell["2-loop \[Beta] functions", "MathCaption",
 CellID->209515848],

Cell[BoxData[
 RowBox[{"BetaFunctions2L", "[", "model", "]"}]], "Input",
 CellID->87655055],

Cell["\<\
There is a Verbose option (by default set to True) which prints the results. \
If we do not wish that to happen, we must use\
\>", "Text",
 CellID->22160086],

Cell["\<\
1-loop \[Beta] functions (no printing)\
\>", "MathCaption",
 CellID->575302465],

Cell[BoxData[
 RowBox[{"BetaFunctions1L", "[", 
  RowBox[{"model", ",", 
   RowBox[{"Verbose", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellID->28350640],

Cell["\<\
2-loop \[Beta] functions (no printing)\
\>", "MathCaption",
 CellID->295648887],

Cell[BoxData[
 RowBox[{"BetaFunctions2L", "[", 
  RowBox[{"model", ",", 
   RowBox[{"Verbose", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellID->75071267],

Cell[TextData[{
 "See functions ",
 Cell[BoxData[
  ButtonBox["BetaFunctions1L",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/BetaFunctions1L"]], "InlineFormula"],
 " and  ",
 Cell[BoxData[
  ButtonBox["BetaFunctions2L",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/BetaFunctions2L"]], "InlineFormula"],
 " for more details."
}], "Text",
 CellID->471652425]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interpreting the output", "Section",
 CellID->21141493],

Cell[TextData[{
 "After executing the ",
 Cell[BoxData[
  ButtonBox["BetaFunctions1L",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/BetaFunctions1L"]], "InlineFormula"],
 " / ",
 Cell[BoxData[
  ButtonBox["BetaFunctions2L",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/BetaFunctions2L"]], "InlineFormula"],
 " functions the program starts printing the \[Beta]- functions on the screen."
}], "Text",
 CellID->16778654],

Cell["\<\
We must remember that there are no names of parameters as input; the program \
builds the Lagrangian automatically and assigns names to the parameters of \
the model. \
\>", "Text",
 CellID->38125756],

Cell[TextData[StyleBox["Naming of model parameters", "Subsection"]], "Text",
 CellID->502385924],

Cell["\<\
One option would be to start giving trivial names such as A,B,C,... as \
needed. The problem with this approach is that these names do not give any \
information about the parameters they are representing.\
\>", "Text",
 CellID->7204230],

Cell["\<\
Susyno takes the following approach: the parameters' names indicate what \
fields they are multiplying. For instance, the up-quark Yukawas could be \
something like y[Q,u,Hu,<flavours>]. The problem now is that the program does \
not ask (and does not need) as input the field's names. Therefore there is no \
such thing as 'Q', 'u' and 'Hu'. Instead the program identifies each field by \
the order in which it was passed on as input. For example, if in the MSSM the \
representations/fields are given in the following order,\
\>", "Text",
 CellID->58309820],

Cell["model = {Q, u, d, L, e, Hu, Hd};", "Code",
 Evaluatable->False,
 InitializationCell->False,
 CellID->85331752],

Cell["\<\
then field Q = 1, field u = 2 and so on. So the up-quark Yukawas would be \
y[1,2,6,...].\
\>", "Text",
 CellID->154281417],

Cell["\<\
There is one other non-trivial factor to consider. At some point during the \
program's execution, Susyno will analyze the triple product of Q,u, Hu (for \
example). It will figure out that these three gauge group representations \
form an invariant combination, therefore a parameter y[1,2,6,...] is needed \
to multiply the whole expression.\
\>", "Text",
 CellID->653273530],

Cell[TextData[{
 "The problem is that a triple product of representations may form more than \
one invariant combination.  An example of this is ",
 StyleBox["8",
  FontWeight->"Bold"],
 " x ",
 StyleBox["8",
  FontWeight->"Bold"],
 " x ",
 StyleBox["8",
  FontWeight->"Bold"],
 " in SU(3):"
}], "Text",
 CellID->69440856],

Cell[TextData[{
 "{1,1} is the ",
 StyleBox["8",
  FontWeight->"Bold"],
 " (see discussion above) of SU(3). The expressions of the invariants are \
very long so we only ",
 "check",
 " that there are two of them. See method ",
 Cell[BoxData[
  ButtonBox["Invariants",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/Invariants"]], "InlineFormula"],
 " for details."
}], "MathCaption",
 CellID->40914729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Invariants", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[43]:=",
 CellID->14784177],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]=",
 CellID->35220029]
}, Open  ]],

Cell["\<\
Let us call these invariants Inv1, Inv2,..., InvN. The program will need more \
than one parameter: y[1,2,6,1,<flavours>] for Inv1, y[1,2,6,2,<flavours>]  \
for Inv2,..., y[1,2,6,N,<flavours>]  for InvN.\
\>", "Text",
 CellID->224561642],

Cell["\<\
This may only happen in triple products of representations; bilinear and \
linear combinations can have at most 1 invariant. However, just for \
consistency Susyno always adds an extra index, even if it is always 1. In the \
MSSM example given above the \[Mu] parameter would be called mu[6,7,1] (6=Hu \
field; 7=Hd field; 1=index of the invariant ... in bilinear terms this index \
is superfluous since it is always 1). \
\>", "Text",
 CellID->115676422],

Cell["\<\
Finally there are the flavours. Again using the up-quark Yukawas of the MSSM \
as example, the complete parameter is y[1,2,6,1,i,j]. The flavour indices i \
and j are of field 1=Q and field 2=u respectively. Field 6=Hu does not have \
one because Susyno knows that there is only one flavour of Hu so there is no \
need for an index.\
\>", "Text",
 CellID->58656751],

Cell["In conclusion, the general rule is:", "Text",
 CellID->48947923],

Cell[TextData[{
 "General rule for the naming of parameters. ",
 Cell[BoxData["y"], "InlineFormula"],
 ", ",
 Cell[BoxData["mu"], "InlineFormula"],
 ", ",
 Cell[BoxData["l"], "InlineFormula"],
 " are the parameters of the superpotential's trilinear, bilinear and linear \
terms. ",
 Cell[BoxData["h"], "InlineFormula"],
 ", ",
 Cell[BoxData["b"], "InlineFormula"],
 ", ",
 Cell[BoxData["s"], "InlineFormula"],
 " are the parameters of ",
 Cell[BoxData[
  SubscriptBox["\[GothicCapitalL]", "soft"]], "InlineFormula"],
 "'s trilinear, bilinear and linear terms while ",
 Cell[BoxData["m2"], "InlineFormula"],
 " are the soft masses. "
}], "MathCaption",
 CellID->42414503],

Cell["\<\
y[field1, field2, field3, InvIndex, <flav1>, <flav2>, <flav3>]
mu[field1, field2, InvIndex, <flav1>, <flav2>]
l[field1, InvIndex, <flav1>]\[LineSeparator]h[field1, field2, field3, \
InvIndex, <flav1>, <flav2>, <flav3>]
b[field1, field2, InvIndex, <flav1>, <flav2>]
s[field1, InvIndex, <flav1>]
m2[field1, field2, InvIndex, <flav1>, <flav2>]\
\>", "Code",
 Evaluatable->False,
 InitializationCell->False,
 CellID->220050688],

Cell["\<\
For the MSSM in the form described in this tutorial (model = {Q, u, d, L, e, \
Hu, Hd}), the complete list of parameters is the following:\
\>", "Text",
 CellID->212841405],

Cell[BoxData[GridBox[{
   {Cell["Susyno's notation", "TableHeader"], Cell[
    "Conventional notation", "TableHeader"]},
   {
    RowBox[{
     RowBox[{"g", "[", "1", "]"}], ",", " ", 
     RowBox[{"g", "[", "2", "]"}], ",", " ", 
     RowBox[{"g", "[", "3", "]"}]}], 
    RowBox[{
     SubscriptBox["g", "1"], ",", " ", 
     SubscriptBox["g", "2"], ",", " ", 
     SubscriptBox["g", "3"]}]},
   {
    RowBox[{
     RowBox[{"M", "[", "1", "]"}], ",", " ", 
     RowBox[{"M", "[", "2", "]"}], ",", " ", 
     RowBox[{"M", "[", "3", "]"}]}], 
    RowBox[{
     SubscriptBox["M", "1"], ",", " ", 
     SubscriptBox["M", "2"], ",", " ", 
     SubscriptBox["M", "3"]}]},
   {
    RowBox[{"y", "[", 
     RowBox[{"1", ",", "2", ",", "6", ",", "1", ",", "i", ",", "j"}], "]"}], 
    FormBox[
     SubscriptBox[
      RowBox[{"(", 
       SubscriptBox["Y", "u"], ")"}], "ji"],
     TraditionalForm]},
   {
    RowBox[{"y", "[", 
     RowBox[{"1", ",", "3", ",", "7", ",", "1", ",", "i", ",", "j"}], "]"}], 
    FormBox[
     SubscriptBox[
      RowBox[{"(", 
       SubscriptBox["Y", "d"], ")"}], "ji"],
     TraditionalForm]},
   {
    RowBox[{"y", "[", 
     RowBox[{"4", ",", "5", ",", "7", ",", "1", ",", "i", ",", "j"}], "]"}], 
    FormBox[
     SubscriptBox[
      RowBox[{"(", 
       SubscriptBox["Y", "e"], ")"}], "ji"],
     TraditionalForm]},
   {
    RowBox[{"mu", "[", 
     RowBox[{"6", ",", "7", ",", "1"}], "]"}], "\[Mu]"},
   {
    RowBox[{"h", "[", 
     RowBox[{"1", ",", "2", ",", "6", ",", "1", ",", "i", ",", "j"}], "]"}], 
    FormBox[
     SubscriptBox[
      RowBox[{"(", 
       SubscriptBox["h", "u"], ")"}], "ji"],
     TraditionalForm]},
   {
    RowBox[{"h", "[", 
     RowBox[{"1", ",", "3", ",", "7", ",", "1", ",", "i", ",", "j"}], "]"}], 
    FormBox[
     SubscriptBox[
      RowBox[{"(", 
       SubscriptBox["h", "d"], ")"}], "ji"],
     TraditionalForm]},
   {
    RowBox[{"h", "[", 
     RowBox[{"4", ",", "5", ",", "7", ",", "1", ",", "i", ",", "j"}], "]"}], 
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["h", "e"], ")"}], "ji"]},
   {
    RowBox[{"b", "[", 
     RowBox[{"6", ",", "7", ",", "1"}], "]"}], 
    FormBox["B",
     TraditionalForm]},
   {
    RowBox[{"m2", "[", 
     RowBox[{"1", ",", "1", ",", "1", ",", "i", ",", "j"}], "]"}], 
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox[
       SuperscriptBox["m", "2"], "Q"], ")"}], "ji"]},
   {
    RowBox[{"m2", "[", 
     RowBox[{"2", ",", "2", ",", "1", ",", "i", ",", "j"}], "]"}], 
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox[
       SuperscriptBox["m", "2"], "u"], ")"}], "ij"]},
   {
    RowBox[{"m2", "[", 
     RowBox[{"3", ",", "3", ",", "1", ",", "i", ",", "j"}], "]"}], 
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox[
       SuperscriptBox["m", "2"], "d"], ")"}], "ij"]},
   {
    RowBox[{"m2", "[", 
     RowBox[{"4", ",", "4", ",", "1", ",", "i", ",", "j"}], "]"}], 
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox[
       SuperscriptBox["m", "2"], "L"], ")"}], "ji"]},
   {
    RowBox[{"m2", "[", 
     RowBox[{"5", ",", "5", ",", "1", ",", "i", ",", "j"}], "]"}], 
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox[
       SuperscriptBox["m", "2"], "e"], ")"}], "ij"]},
   {
    RowBox[{"m2", "[", 
     RowBox[{"6", ",", "6", ",", "1", ",", "i", ",", "j"}], "]"}], 
    SubscriptBox[
     SuperscriptBox["m", "2"], 
     SubscriptBox["H", "u"]]},
   {
    RowBox[{"m2", "[", 
     RowBox[{"7", ",", "7", ",", "1", ",", "i", ",", "j"}], "]"}], 
    SubscriptBox[
     SuperscriptBox["m", "2"], 
     SubscriptBox["H", "d"]]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->117867006],

Cell["List of MSSM parameters for model = {Q, u, d, L, e, Hu, Hd}.", "Caption",
 CellID->77697423],

Cell[TextData[{
 "In this table, I have added the ",
 Cell[BoxData[
  RowBox[{"g", "[", "i", "]"}]], "InlineFormula"],
 " coupling constants and gaugino masses ",
 Cell[BoxData[
  RowBox[{"M", "[", "i", "]"}]], "InlineFormula"],
 " which have an obvious notation. "
}], "Text",
 CellID->518844087],

Cell[TextData[{
 "'Conventional notation' here refers to the following W and ",
 Cell[BoxData[
  SubscriptBox["\[GothicCapitalL]", "soft"]], "InlineFormula"],
 ":"
}], "Text",
 CellID->182805404],

Cell[TextData[Cell[BoxData[
 RowBox[{"W", "=", 
  RowBox[{
   RowBox[{"u", " ", 
    SubscriptBox["Y", "u"], " ", "Q", " ", 
    SubscriptBox["H", "u"]}], "+", 
   RowBox[{"d", " ", 
    SubscriptBox["Y", "d"], " ", "Q", " ", 
    SubscriptBox["H", "d"]}], " ", "+", " ", 
   RowBox[{"e", " ", 
    SubscriptBox["Y", "e"], " ", "Q", " ", 
    SubscriptBox["H", "d"]}], " ", "+", " ", 
   RowBox[{"\[Mu]", " ", 
    SubscriptBox["H", "u"], " ", 
    SubscriptBox["H", "d"]}]}]}]], "InlineFormula"]], "Text",
 CellID->809320560],

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SubscriptBox["\[GothicCapitalL]", "soft"]}], "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      OverscriptBox["u", "^"], " ", 
      SubscriptBox["h", "u"], " ", 
      OverscriptBox["Q", "^"], " ", 
      SubscriptBox[
       OverscriptBox["H", "^"], "u"]}], "+", 
     RowBox[{
      OverscriptBox["d", "^"], " ", 
      SubscriptBox["h", "d"], " ", 
      OverscriptBox["Q", "^"], " ", 
      SubscriptBox[
       OverscriptBox["H", "^"], "d"]}], " ", "+", " ", 
     RowBox[{
      OverscriptBox["e", "^"], " ", 
      SubscriptBox["h", "e"], " ", 
      OverscriptBox["L", "^"], " ", 
      SubscriptBox[
       OverscriptBox["H", "^"], "d"]}], " ", "+", " ", 
     RowBox[{"B", " ", 
      SubscriptBox[
       OverscriptBox["H", "^"], "u"], " ", 
      SubscriptBox[
       OverscriptBox["H", "^"], "d"]}], "+", 
     RowBox[{"h", ".", "c", "."}]}], ")"}], "+", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"+", " ", 
     SubscriptBox[
      SuperscriptBox["m", "2"], 
      SubscriptBox["H", "u"]]}], " ", 
    SubscriptBox[
     SuperscriptBox[
      OverscriptBox["H", "^"], "\[Dagger]"], "u"], 
    SubscriptBox[
     OverscriptBox["H", "^"], "u"]}], "+", 
   RowBox[{
    SubscriptBox[
     SuperscriptBox["m", "2"], 
     SubscriptBox["H", "d"]], 
    SubscriptBox[
     SuperscriptBox[
      OverscriptBox["H", "^"], "\[Dagger]"], "d"], 
    SubscriptBox[
     OverscriptBox["H", "^"], "d"]}], "+", 
   RowBox[{
    SuperscriptBox[
     OverscriptBox["Q", "^"], "\[Dagger]"], 
    SubscriptBox[
     SuperscriptBox["m", "2"], "Q"], 
    OverscriptBox["Q", "^"]}], "+", 
   RowBox[{
    SuperscriptBox[
     OverscriptBox["L", "^"], "\[Dagger]"], 
    SubscriptBox[
     SuperscriptBox["m", "2"], "L"], 
    OverscriptBox["L", "^"]}], "+", 
   RowBox[{
    OverscriptBox["u", "^"], " ", 
    SubscriptBox[
     SuperscriptBox["m", "2"], "u"], 
    SuperscriptBox[
     OverscriptBox["u", "^"], "\[Dagger]"]}], "+", 
   RowBox[{
    OverscriptBox["d", "^"], " ", 
    SubscriptBox[
     SuperscriptBox["m", "2"], "d"], 
    SuperscriptBox[
     OverscriptBox["d", "^"], "\[Dagger]"]}], "+", 
   RowBox[{
    OverscriptBox["e", "^"], " ", 
    SubscriptBox[
     SuperscriptBox["m", "2"], "e"], 
    SuperscriptBox[
     OverscriptBox["e", "^"], "\[Dagger]"]}]}]}]], "InlineFormula"]], "Text",
 CellID->28169906],

Cell[CellGroupData[{

Cell["Viewing the Lagrangian used", "Subsection",
 CellID->434412357],

Cell["\<\
Knowing the Lagrangian used is important because of the normalization of the \
parameters of the model.\
\>", "Text",
 CellID->74743838],

Cell["\<\
For example, two SU(2) doublets - vectorA={a[1],a[2]} and vectorB={b[1],b[2]} \
- form an invariant a[1]b[2]-a[2]b[1]. If these were fields in a model, \
Susyno would find out that this combination exists and would form a term \
mu[...](a[1]b[2]-a[2]b[1]). The problem is that any expression \
C(a[1]b[2]-a[2]b[1]) is also an invariant.  The effect of this is that we may \
think we have in the Lagrangian mu[...](a[1]b[2]-a[2]b[1]) but instead we \
have C mu[...](a[1]b[2]-a[2]b[1]). Equivalently, mu[...] -> C mu[...] so this \
is clearly a parameter normalization problem. \
\>", "Text",
 CellID->22005238],

Cell["\<\
That is why it may be important to look at the Lagrangian. To view it, type\
\>", "Text",
 CellID->275674183],

Cell["\<\
Use the ShowLagrangian function to view the Lagrangian used by the program.\
\>", "MathCaption",
 CellID->603378766],

Cell[BoxData[
 RowBox[{"ShowLagrangian", "[", "model", "]"}]], "Input",
 CellLabel->"In[328]:=",
 CellID->62206324],

Cell[TextData[{
 "This will print the superpotential W and ",
 Cell[BoxData[
  SubscriptBox["\[GothicCapitalL]", "soft"]], "InlineFormula"],
 " in extended form. In general we can write these as"
}], "Text",
 CellID->813068499],

Cell[TextData[{
 "W= ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["1", "6"], " ", 
     SuperscriptBox["Y", "ijk"], " ", 
     SubscriptBox["\[CapitalPhi]", "i"], " ", 
     SubscriptBox["\[CapitalPhi]", "j"], " ", 
     SubscriptBox["\[CapitalPhi]", "k"]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["\[Mu]", "ij"], 
     SubscriptBox["\[CapitalPhi]", "i"], " ", " ", 
     SubscriptBox["\[CapitalPhi]", "j"]}], "+", 
    RowBox[{
     SuperscriptBox["L", "i"], 
     SubscriptBox["\[CapitalPhi]", "i"]}]}], TraditionalForm]], "InlineMath"]
}], "Text",
 CellID->18075909],

Cell[TextData[{
 "-",
 Cell[BoxData[
  SubscriptBox["\[GothicCapitalL]", "soft"]]],
 "=",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "6"], " ", 
       SuperscriptBox["h", "ijk"], " ", 
       SubscriptBox["\[Phi]", "i"], " ", 
       SubscriptBox["\[Phi]", "j"], " ", 
       SubscriptBox["\[Phi]", "k"]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["b", "ij"], 
       SubscriptBox["\[Phi]", "i"], "  ", 
       SubscriptBox["\[Phi]", "j"]}], "+", 
      RowBox[{
       SuperscriptBox["s", "i"], 
       SubscriptBox["\[Phi]", "i"]}], "+", 
      RowBox[{"h", ".", "c", "."}]}], ")"}], "+", 
    RowBox[{
     SubscriptBox[
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox["m", "2"], ")"}], "j"], "i"], 
     SubscriptBox["\[Phi]", "j"], 
     SubscriptBox[
      SuperscriptBox["\[Phi]", "*"], "i"]}], "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], 
       SubscriptBox["M", "a"], 
       SubscriptBox["\[Lambda]", "a"], 
       SubscriptBox["\[Lambda]", "a"]}], "+", 
      RowBox[{"h", ".", "c", "."}]}], ")"}]}], TraditionalForm]], "InlineMath"]
}], "Text",
 CellID->143483544],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ShowLagrangian",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/ShowLagrangian"]], "InlineFormula"],
 " calls  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox["Y", "ijk"], " ", 
    SubscriptBox["\[CapitalPhi]", "i"], " ", 
    SubscriptBox["\[CapitalPhi]", "j"], " ", 
    SubscriptBox["\[CapitalPhi]", "k"]}], TraditionalForm]], "InlineMath"],
 "  the ",
 StyleBox["Y part",
  FontSlant->"Italic"],
 ",  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["\[Mu]", "ij"], 
    SubscriptBox["\[CapitalPhi]", "i"], " ", " ", 
    SubscriptBox["\[CapitalPhi]", "j"]}], TraditionalForm]], "InlineMath"],
 "  the \[Mu]",
 StyleBox[" part",
  FontSlant->"Italic"],
 ",  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["L", "i"], 
    SubscriptBox["\[CapitalPhi]", "i"]}], TraditionalForm]], "InlineMath"],
 "  the ",
 StyleBox["L part",
  FontSlant->"Italic"],
 ",  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox["h", "ijk"], " ", 
    SubscriptBox["\[Phi]", "i"], " ", 
    SubscriptBox["\[Phi]", "j"], " ", 
    SubscriptBox["\[Phi]", "k"]}], TraditionalForm]], "InlineMath"],
 "  the ",
 StyleBox["H part",
  FontSlant->"Italic"],
 ",  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["b", "ij"], 
    SubscriptBox["\[Phi]", "i"], "  ", 
    SubscriptBox["\[Phi]", "j"]}], TraditionalForm]], "InlineMath"],
 "  the ",
 StyleBox["B part",
  FontSlant->"Italic"],
 ",  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["s", "i"], 
    SubscriptBox["\[Phi]", "i"]}], TraditionalForm]], "InlineMath"],
 "  the ",
 StyleBox["S part",
  FontSlant->"Italic"],
 " and  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["m", "2"], ")"}], "j"], "i"], 
    SubscriptBox["\[Phi]", "j"], 
    SubscriptBox[
     SuperscriptBox["\[Phi]", "*"], "i"]}], TraditionalForm]], "InlineMath"],
 "  the ",
 StyleBox["M2 part",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->689775355],

Cell[TextData[{
 "The gaugino mass term (",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], 
     SubscriptBox["M", "a"], 
     SubscriptBox["\[Lambda]", "a"], 
     SubscriptBox["\[Lambda]", "a"]}], "+", 
    RowBox[{"h", ".", "c", "."}]}], TraditionalForm]], "InlineMath"],
 ") has always the same trivial structure and is not shown."
}], "Text",
 CellID->159960695],

Cell[TextData[{
 "The function itself returns the list of tensors {Y,\[Mu],L,h,b,s, ",
 Cell[BoxData[
  SuperscriptBox["m", "2"]], "InlineFormula"],
 "}."
}], "Text",
 CellID->117256491],

Cell["\<\
Again, there is a Verbose option (set to True by default) that controls the \
printing process.\
\>", "Text",
 CellID->750652415],

Cell["\<\
Use Verbose->False if there is no need to have the Lagrangian printed.\
\>", "MathCaption",
 CellID->22987297],

Cell[BoxData[
 RowBox[{"ShowLagrangian", "[", 
  RowBox[{"model", ",", " ", 
   RowBox[{"Verbose", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[328]:=",
 CellID->7600290],

Cell[TextData[{
 "Calling ",
 Cell[BoxData[
  ButtonBox["ShowLagrangian",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/ShowLagrangian"]], "InlineFormula"],
 " will generate the model Lagrangian even if neither  ",
 Cell[BoxData[
  ButtonBox["BetaFunctions1L",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/BetaFunctions1L"]], "InlineFormula"],
 "  nor ",
 Cell[BoxData[
  ButtonBox["BetaFunctions2L",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/BetaFunctions2L"]], "InlineFormula"],
 "  have not been called before. This means that this function can be used to \
generate the superpotential W and ",
 Cell[BoxData[
  SubscriptBox["\[GothicCapitalL]", "soft"]], "InlineFormula"],
 " of a SUSY model even if there is no intention of ever calculating \[Beta] \
functions."
}], "Text",
 CellID->441445416],

Cell["\<\
There is another way of handling the normalization problem we have been \
discussing. Susyno uses the following convention for the normalization of the \
invariants:\
\>", "Text",
 CellID->97450775],

Cell[TextData[Cell[BoxData[
 RowBox[{
  UnderscriptBox["\[Sum]", 
   RowBox[{"coeff", " ", "of", " ", "the", " ", "invariant"}]], 
  RowBox[{"|", "coefficients", 
   SuperscriptBox["|", "2"], 
   RowBox[{"=", 
    SqrtBox[
     RowBox[{
      RowBox[{"dim", 
       RowBox[{"(", "rep1", ")"}], "dim", 
       RowBox[{"(", "rep2", ")"}]}], 
      "..."}]]}]}]}]], "InlineFormula"]], "Text",
 CellID->299293111],

Cell[TextData[{
 "Take the SU(2) doublet example C(a[1]b[2]-a[2]b[1]). Both representations \
are 2-dimensional so the right-hand side is ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    RowBox[{"2", "\[Times]", "2"}]], "=", "2"}]], "InlineFormula"],
 ". The left side is ",
 Cell[BoxData[
  RowBox[{"|", "C", 
   SuperscriptBox["|", "2"], 
   RowBox[{"+", 
    RowBox[{"|", 
     RowBox[{"-", "C"}], 
     SuperscriptBox["|", "2"], 
     RowBox[{"=", 
      RowBox[{"2", "|", "C", 
       SuperscriptBox["|", "2"]}]}]}]}]}]], "InlineFormula"],
 " so Susyno's choice is ",
 Cell[BoxData[
  RowBox[{"|", "C", "|"}]]],
 "=1. If the phase of C is really important (it can't be incorporated in a \
redefinition of fields) then we must really look at the Lagrangian using  ",
 Cell[BoxData[
  ButtonBox["ShowLagrangian",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/ShowLagrangian"]], "InlineFormula"],
 "."
}], "Text",
 CellID->455643976],

Cell[TextData[{
 "Running  ",
 Cell[BoxData[
  ButtonBox["ShowLagrangian",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/ShowLagrangian"]], "InlineFormula"],
 " for the MSSM example and looking closely at the results reveals something \
that may seem odd with the colour quantum number. The core of the issue is \
that vectorA={a[1],a[2],a[3]} and vectorB={b[1],b[2],b[3]} transforming as a ",
 Cell[BoxData[
  StyleBox["3",
   FontFamily->"Courier New",
   FontWeight->"Bold"]],
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}}],
 " and a ",
 Cell[BoxData[
  StyleBox[
   OverscriptBox[
    StyleBox["3",
     FontFamily->"Courier New",
     FontWeight->"Bold"], "_"],
   FontFamily->"Courier New",
   FontWeight->"Bold"]],
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}}],
 " of SU(3) will not form an invariant of the form a[1]b[1]+a[2]b[2]+a[3]b[3] \
but instead,"
}], "Text",
 CellID->37891906],

Cell[TextData[{
 " ",
 Cell[BoxData[
  StyleBox["3",
   FontFamily->"Courier New",
   FontWeight->"Bold"]],
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}}],
 " ={1,0} and a ",
 Cell[BoxData[
  StyleBox[
   OverscriptBox[
    StyleBox["3",
     FontFamily->"Courier New",
     FontWeight->"Bold"], "_"],
   FontFamily->"Courier New",
   FontWeight->"Bold"]],
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}}],
 " ={0,1} of SU(3) form this invariant:"
}], "MathCaption",
 CellID->177859870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Invariants", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[44]:=",
 CellID->229943877],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "3", "]"}], " ", 
    RowBox[{"b", "[", "1", "]"}]}], "-", 
   RowBox[{
    RowBox[{"a", "[", "2", "]"}], " ", 
    RowBox[{"b", "[", "2", "]"}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "1", "]"}], " ", 
    RowBox[{"b", "[", "3", "]"}]}]}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[44]=",
 CellID->91737904]
}, Open  ]],

Cell[TextData[{
 "Is this relevant? No, because this is due to a choice of basis for the ",
 Cell[BoxData[
  StyleBox["3",
   FontFamily->"Courier New",
   FontWeight->"Bold"]],
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}}],
 " / ",
 Cell[BoxData[
  StyleBox[
   OverscriptBox[
    StyleBox["3",
     FontFamily->"Courier New",
     FontWeight->"Bold"], "_"],
   FontFamily->"Courier New",
   FontWeight->"Bold"]],
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}}],
 " representations. While the explicit expression of the Lagrangian changes \
with the basis used, physical meaningful quantities (such as the \[Beta] \
functions) do not. See ",
 Cell[BoxData["Invariants"], "InlineFormula"],
 " for a discussion on this."
}], "Text",
 CellID->69981609]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["More examples", "Section",
 CellID->323535181],

Cell["Here are some other models.", "Text",
 CellID->19160971],

Cell[TextData[StyleBox["NMSSM", "Subsection"]], "Text",
 CellID->416897326],

Cell[BoxData[{
 RowBox[{
  RowBox[{"norm", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "->", 
      RowBox[{
       RowBox[{"1", "/", "6"}], " ", "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "1", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "->", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "/", "3"}], " ", "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", 
      RowBox[{
       RowBox[{"1", "/", "3"}], " ", "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], " ", "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "1", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", " ", "norm"}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hu", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", " ", 
      RowBox[{
       RowBox[{"1", "/", "2"}], "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "1", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "1"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hd", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "1", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "1"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"U1", "\[Rule]", "0"}], " ", ",", 
      RowBox[{"SU2", "->", 
       RowBox[{"{", "0", "}"}]}], ",", 
      RowBox[{"SU3", "->", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", 
      RowBox[{"NFlavours", "\[Rule]", "1"}], ",", 
      RowBox[{"DiscreteSym", "\[Rule]", "1"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"model", "=", 
    RowBox[{"{", 
     RowBox[{
     "Q", ",", "u", ",", "d", ",", "L", ",", "e", ",", "Hu", ",", "Hd", ",", 
      "S"}], "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BetaFunctions2L", "[", "model", "]"}], ";"}]}], "Input",
 CellLabel->"In[15]:=",
 CellID->64279527],

Cell[TextData[StyleBox["Cubic NMSSM", "Subsection"]], "Text",
 CellID->731454495],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"w", "=", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"2", 
       RowBox[{"\[Pi]", "/", "3"}], " ", "\[ImaginaryI]"}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "->", 
      RowBox[{"1", "/", "6"}]}], "  ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "1", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "w"}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "->", 
      RowBox[{
       RowBox[{"-", "2"}], "/", "3"}]}], "  ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "w"}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", 
      RowBox[{"1", "/", "3"}]}], "  ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "w"}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}]}], "  ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "1", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "w"}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", " ", "1"}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "w"}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hu", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", " ", 
      RowBox[{"1", "/", "2"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "1", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "1"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "w"}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hd", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", " ", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "1", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "1"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "w"}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"U1", "\[Rule]", "0"}], " ", ",", 
      RowBox[{"SU2", "->", 
       RowBox[{"{", "0", "}"}]}], ",", 
      RowBox[{"SU3", "->", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", 
      RowBox[{"NFlavours", "\[Rule]", "1"}], ",", 
      RowBox[{"DiscreteSym", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "w"}], "}"}]}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"model", "=", 
    RowBox[{"{", 
     RowBox[{
     "Q", ",", "u", ",", "d", ",", "L", ",", "e", ",", "Hu", ",", "Hd", ",", 
      "S"}], "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BetaFunctions2L", "[", "model", "]"}], ";"}]}], "Input",
 CellLabel->"In[26]:=",
 CellID->290326339],

Cell[CellGroupData[{

Cell[TextData[StyleBox["General MSSM", "Subsection"]], "Subsection",
 CellID->132997645],

Cell["\<\
The following code is for a MSSM-like model with R-parity violation and an \
undefined number of copies of each representation.\
\>", "Text",
 CellID->164721189],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "the", " ", "gauge", " ", "factor", " ", "groups", " ", "and", 
    " ", "the", " ", 
    RowBox[{"fields", "/", "representations"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Also", " ", "set", " ", "the", " ", "number", " ", "of", " ", "flavours",
      " ", "and", " ", "R"}], "-", 
    RowBox[{"parity", " ", "of", " ", "each", " ", "field"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"norm", "=", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"3", "/", "5"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"U1", "->", 
        RowBox[{
         RowBox[{"1", "/", "6"}], " ", "norm"}]}], " ", ",", 
       RowBox[{"SU2", "->", 
        RowBox[{"{", "1", "}"}]}], ",", 
       RowBox[{"SU3", "->", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"U1", "->", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], "/", "3"}], " ", "norm"}]}], " ", ",", 
       RowBox[{"SU2", "->", 
        RowBox[{"{", "0", "}"}]}], ",", 
       RowBox[{"SU3", "->", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"U1", "\[Rule]", 
        RowBox[{
         RowBox[{"1", "/", "3"}], " ", "norm"}]}], " ", ",", 
       RowBox[{"SU2", "->", 
        RowBox[{"{", "0", "}"}]}], ",", 
       RowBox[{"SU3", "->", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"L", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"U1", "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], " ", "norm"}]}], " ", ",", 
       RowBox[{"SU2", "->", 
        RowBox[{"{", "1", "}"}]}], ",", 
       RowBox[{"SU3", "->", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"U1", "\[Rule]", " ", "norm"}], " ", ",", 
       RowBox[{"SU2", "->", 
        RowBox[{"{", "0", "}"}]}], ",", 
       RowBox[{"SU3", "->", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Hu", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"U1", "\[Rule]", " ", 
        RowBox[{
         RowBox[{"1", "/", "2"}], "norm"}]}], " ", ",", 
       RowBox[{"SU2", "->", 
        RowBox[{"{", "1", "}"}]}], ",", 
       RowBox[{"SU3", "->", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Hd", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"U1", "\[Rule]", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], "norm"}]}], " ", ",", 
       RowBox[{"SU2", "->", 
        RowBox[{"{", "1", "}"}]}], ",", 
       RowBox[{"SU3", "->", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"model", "=", 
     RowBox[{"{", 
      RowBox[{
      "Q", ",", "u", ",", "d", ",", "L", ",", "e", ",", "Hu", ",", "Hd"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"BetaFunctions2L", "[", "model", "]"}], ";"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->117496310],

Cell[TextData[StyleBox["SO(10) model", "Subsection"]], "Text",
 CellID->212393141],

Cell["\<\
The following code is for an SO(10) model with one 10-dimensional \
representations and three 16-dimensional representations.\
\>", "Text",
 CellID->355991212],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rep10", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SO10", "->", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rep16", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SO10", "->", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"NFlavours", "\[Rule]", "3"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BetaFunctions2L", "[", 
  RowBox[{"{", 
   RowBox[{"rep10", ",", "rep16"}], "}"}], "]"}]}], "Input",
 CellLabel->"In[37]:=",
 CellID->162008933]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FURTHER READING", "TutorialMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 "Susyno's website: ",
 ButtonBox["http://web.ist.utl.pt/renato.fonseca/susyno.html",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://web.ist.utl.pt/renato.fonseca/susyno.html"], None}]
}], "TutorialMoreAbout",
 CellID->4029634],

Cell[TextData[{
 "Susyno's manual: ",
 ButtonBox["arXiv:1106.5016 [hep-ph]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://arxiv.org/abs/1106.5016"], None}]
}], "TutorialMoreAbout",
 CellID->1567025153],

Cell[TextData[{
 "For lists of group representations see ",
 ButtonBox["R. Slansky, Phys.Rept. 79 (1981)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://dx.doi.org/10.1016/0370-1573(81)90092-2"], None}]
}], "TutorialMoreAbout",
 CellID->9400535],

Cell[TextData[{
 "For an quick introduction to Lie Algebras there is for example the book ",
 StyleBox["Semi-Simple Lie Algebras and Their Representations",
  FontSlant->"Italic"],
 " by R. Cahn."
}], "TutorialMoreAbout",
 CellID->189317751]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Susyno Tutorial - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 3, 2, 12, 17, 0.3593750}", "context" -> "Susyno`", 
    "keywords" -> {"Susyno Tutorial RGE SUSY"}, "index" -> True, "label" -> 
    "Susyno Tutorial", "language" -> "en", "paclet" -> "Susyno", "status" -> 
    "None", "summary" -> 
    "Susyno is a package which calculates the 2-loop renormalization group \
equations (RGEs) of SUSY models. The input is just the gauge group, \
representations, number of flavours and any abelian symmetries of the model. \
Susyno then automatically generates the Lagrangian and other group \
theoretical quantities. These are then used to calculate the \\[Beta] \
functions for all the parameters of the model. Some of the internally used \
methods are exposed to the user. In particular there are group theoretical \
methods that may be useful. This package should work on Mathematica 7 and \
latter.", "synonyms" -> {}, "title" -> "Susyno Tutorial", "type" -> 
    "Tutorial", "uri" -> "Susyno/tutorial/SusynoTutorial"}, 
  "SearchTextTranslated" -> ""},
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"], 
   Cell[
    StyleData["TutorialMoreAboutSection"], 
    CellGroupingRules -> {"SectionGrouping", 30}], 
   Cell[
    StyleData["RelatedTutorialsSection"], 
    CellGroupingRules -> {"SectionGrouping", 30}], 
   Cell[
    StyleData["TutorialRelatedLinksSection"], 
    CellGroupingRules -> {"SectionGrouping", 30}]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[596, 21, 78, 1, 70, "TutorialColorBar"],
Cell[677, 24, 178, 5, 70, "LinkTrail"],
Cell[858, 31, 11556, 244, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[12439, 279, 52, 1, 70, "Title",
 CellID->509267359],
Cell[12494, 282, 452, 8, 70, "Text",
 CellID->1534169418],
Cell[12949, 292, 175, 4, 70, "Text",
 CellID->99754619],
Cell[13127, 298, 147, 6, 70, "Text",
 CellID->421768310],
Cell[13277, 306, 66, 1, 70, "MathCaption",
 CellID->836781195],
Cell[13346, 309, 95, 3, 70, "Input",
 CellID->2058623809],
Cell[CellGroupData[{
Cell[13466, 316, 60, 1, 70, "Section",
 CellID->2591],
Cell[13529, 319, 128, 4, 70, "Text",
 CellID->24858853],
Cell[13660, 325, 4646, 135, 70, "Input",
 CellID->6265725],
Cell[18309, 462, 88, 1, 70, "Text",
 CellID->44162439],
Cell[18400, 465, 115, 3, 70, "Input",
 CellID->337054168]
}, Open  ]],
Cell[CellGroupData[{
Cell[18552, 473, 56, 1, 70, "Section",
 CellID->8978917],
Cell[18611, 476, 642, 20, 70, "DefinitionBox",
 CellID->306150231],
Cell[19256, 498, 61, 1, 70, "Caption",
 CellID->25601712],
Cell[19320, 501, 1727, 49, 70, "DefinitionBox",
 CellID->110605517],
Cell[21050, 552, 65, 1, 70, "Caption",
 CellID->108810841],
Cell[21118, 555, 519, 15, 70, "DefinitionBox",
 CellID->70978957],
Cell[21640, 572, 64, 1, 70, "Caption",
 CellID->145991187]
}, Open  ]],
Cell[CellGroupData[{
Cell[21741, 578, 58, 1, 70, "Section",
 CellID->199085598],
Cell[21802, 581, 3055, 90, 70, "DefinitionBox",
 CellID->856307529]
}, Open  ]],
Cell[CellGroupData[{
Cell[24894, 676, 53, 1, 70, "Section",
 CellID->53920555],
Cell[24950, 679, 728, 17, 70, "Text",
 CellID->100635996],
Cell[25681, 698, 166, 6, 70, "Text",
 CellID->423206022],
Cell[25850, 706, 76, 1, 70, "MathCaption",
 CellID->824451330],
Cell[25929, 709, 110, 3, 70, "Code",
 Evaluatable->False,
 InitializationCell->False,
 CellID->13441295],
Cell[26042, 714, 194, 4, 70, "Text",
 CellID->388589019],
Cell[26239, 720, 73, 1, 70, "MathCaption",
 CellID->154743581],
Cell[26315, 723, 170, 5, 70, "Code",
 Evaluatable->False,
 InitializationCell->False,
 CellID->487015284],
Cell[26488, 730, 45, 1, 70, "Text",
 CellID->160230726],
Cell[26536, 733, 78, 1, 70, "Text",
 CellID->633280229],
Cell[26617, 736, 135, 4, 70, "Text",
 CellID->4571369],
Cell[26755, 742, 76, 1, 70, "Text",
 CellID->455991224],
Cell[26834, 745, 133, 4, 70, "Text",
 CellID->13923596],
Cell[26970, 751, 75, 1, 70, "Text",
 CellID->22581803],
Cell[27048, 754, 318, 8, 70, "Text",
 CellID->58772511],
Cell[27369, 764, 119, 3, 70, "Text",
 CellID->195708328],
Cell[27491, 769, 75, 1, 70, "Text",
 CellID->193008405],
Cell[CellGroupData[{
Cell[27591, 774, 57, 1, 70, "Subsection",
 CellID->264470554],
Cell[27651, 777, 142, 4, 70, "Text",
 CellID->68464658],
Cell[27796, 783, 105, 2, 70, "MathCaption",
 CellID->315402278],
Cell[27904, 787, 101, 3, 70, "Code",
 Evaluatable->False,
 InitializationCell->False,
 CellID->38080131],
Cell[28008, 792, 617, 17, 70, "Text",
 CellID->87239316],
Cell[28628, 811, 294, 6, 70, "Text",
 CellID->719752033],
Cell[28925, 819, 48, 1, 70, "Code",
 CellID->99800453],
Cell[28976, 822, 56, 1, 70, "MathCaption",
 CellID->38172770],
Cell[CellGroupData[{
Cell[29057, 827, 105, 3, 70, "Input",
 CellID->252225000],
Cell[29165, 832, 159, 5, 36, "Output",
 CellID->264615598]
}, Open  ]],
Cell[29339, 840, 56, 1, 70, "MathCaption",
 CellID->9207279],
Cell[CellGroupData[{
Cell[29420, 845, 106, 3, 70, "Input",
 CellID->453374297],
Cell[29529, 850, 158, 5, 36, "Output",
 CellID->12440822]
}, Open  ]],
Cell[29702, 858, 202, 5, 70, "Text",
 CellID->186840582],
Cell[29907, 865, 424, 10, 70, "Text",
 CellID->13545047],
Cell[30334, 877, 649, 20, 70, "Text",
 CellID->291374766],
Cell[30986, 899, 170, 4, 70, "MathCaption",
 CellID->454189483],
Cell[CellGroupData[{
Cell[31181, 907, 175, 6, 70, "Input",
 CellID->514460268],
Cell[31359, 915, 159, 5, 36, "Output",
 CellID->166118683]
}, Open  ]],
Cell[31533, 923, 138, 4, 70, "Text",
 CellID->186880836],
Cell[31674, 929, 5710, 206, 70, "DefinitionBox3Col",
 CellID->3225],
Cell[37387, 1137, 76, 1, 70, "Caption",
 CellID->251894822],
Cell[37466, 1140, 260, 5, 70, "Text",
 CellID->53721323]
}, Open  ]],
Cell[CellGroupData[{
Cell[37763, 1150, 60, 1, 70, "Subsection",
 CellID->130285366],
Cell[37826, 1153, 370, 7, 70, "Text",
 CellID->346919154],
Cell[38199, 1162, 131, 5, 70, "Code",
 Evaluatable->False,
 InitializationCell->False,
 CellID->109118134],
Cell[38333, 1169, 356, 9, 70, "Text",
 CellID->201997723]
}, Open  ]],
Cell[CellGroupData[{
Cell[38726, 1183, 69, 1, 70, "Subsection",
 CellID->167242659],
Cell[38798, 1186, 574, 13, 70, "Text",
 CellID->239542694],
Cell[39375, 1201, 120, 3, 70, "Code",
 Evaluatable->False,
 InitializationCell->False,
 CellID->421781349],
Cell[39498, 1206, 92, 1, 70, "Text",
 CellID->60958078],
Cell[39593, 1209, 386, 9, 70, "Text",
 CellID->174451658],
Cell[39982, 1220, 153, 4, 70, "Text",
 CellID->6965007]
}, Open  ]],
Cell[CellGroupData[{
Cell[40172, 1229, 83, 1, 70, "Subsection",
 CellID->305509497],
Cell[40258, 1232, 179, 5, 70, "Text",
 CellID->776410528],
Cell[40440, 1239, 67, 1, 70, "MathCaption",
 CellID->649717704],
Cell[40510, 1242, 92, 2, 70, "Input",
 CellID->411943553],
Cell[40605, 1246, 67, 1, 70, "MathCaption",
 CellID->209515848],
Cell[40675, 1249, 91, 2, 70, "Input",
 CellID->87655055],
Cell[40769, 1253, 167, 4, 70, "Text",
 CellID->22160086],
Cell[40939, 1259, 89, 3, 70, "MathCaption",
 CellID->575302465],
Cell[41031, 1264, 154, 4, 70, "Input",
 CellID->28350640],
Cell[41188, 1270, 89, 3, 70, "MathCaption",
 CellID->295648887],
Cell[41280, 1275, 154, 4, 70, "Input",
 CellID->75071267],
Cell[41437, 1281, 379, 13, 70, "Text",
 CellID->471652425]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41865, 1300, 61, 1, 70, "Section",
 CellID->21141493],
Cell[41929, 1303, 439, 13, 70, "Text",
 CellID->16778654],
Cell[42371, 1318, 210, 5, 70, "Text",
 CellID->38125756],
Cell[42584, 1325, 96, 1, 70, "Text",
 CellID->502385924],
Cell[42683, 1328, 247, 5, 70, "Text",
 CellID->7204230],
Cell[42933, 1335, 569, 9, 70, "Text",
 CellID->58309820],
Cell[43505, 1346, 116, 3, 70, "Code",
 Evaluatable->False,
 InitializationCell->False,
 CellID->85331752],
Cell[43624, 1351, 133, 4, 70, "Text",
 CellID->154281417],
Cell[43760, 1357, 387, 7, 70, "Text",
 CellID->653273530],
Cell[44150, 1366, 322, 13, 70, "Text",
 CellID->69440856],
Cell[44475, 1381, 411, 14, 70, "MathCaption",
 CellID->40914729],
Cell[CellGroupData[{
Cell[44911, 1399, 338, 11, 70, "Input",
 CellID->14784177],
Cell[45252, 1412, 158, 5, 36, "Output",
 CellID->35220029]
}, Open  ]],
Cell[45425, 1420, 247, 5, 70, "Text",
 CellID->224561642],
Cell[45675, 1427, 465, 8, 70, "Text",
 CellID->115676422],
Cell[46143, 1437, 375, 7, 70, "Text",
 CellID->58656751],
Cell[46521, 1446, 70, 1, 70, "Text",
 CellID->48947923],
Cell[46594, 1449, 670, 21, 70, "MathCaption",
 CellID->42414503],
Cell[47267, 1472, 433, 11, 70, "Code",
 Evaluatable->False,
 InitializationCell->False,
 CellID->220050688],
Cell[47703, 1485, 182, 4, 70, "Text",
 CellID->212841405],
Cell[47888, 1491, 3792, 127, 70, "DefinitionBox3Col",
 CellID->117867006],
Cell[51683, 1620, 98, 1, 70, "Caption",
 CellID->77697423],
Cell[51784, 1623, 297, 9, 70, "Text",
 CellID->518844087],
Cell[52084, 1634, 195, 6, 70, "Text",
 CellID->182805404],
Cell[52282, 1642, 526, 15, 70, "Text",
 CellID->809320560],
Cell[52811, 1659, 2400, 80, 70, "Text",
 CellID->28169906],
Cell[CellGroupData[{
Cell[55236, 1743, 69, 1, 70, "Subsection",
 CellID->434412357],
Cell[55308, 1746, 146, 4, 70, "Text",
 CellID->74743838],
Cell[55457, 1752, 619, 10, 70, "Text",
 CellID->22005238],
Cell[56079, 1764, 119, 3, 70, "Text",
 CellID->275674183],
Cell[56201, 1769, 126, 3, 70, "MathCaption",
 CellID->603378766],
Cell[56330, 1774, 115, 3, 70, "Input",
 CellID->62206324],
Cell[56448, 1779, 227, 6, 70, "Text",
 CellID->813068499],
Cell[56678, 1787, 629, 20, 70, "Text",
 CellID->18075909],
Cell[57310, 1809, 1239, 42, 70, "Text",
 CellID->143483544],
Cell[58552, 1853, 2186, 85, 70, "Text",
 CellID->689775355],
Cell[60741, 1940, 399, 13, 70, "Text",
 CellID->159960695],
Cell[61143, 1955, 186, 6, 70, "Text",
 CellID->117256491],
Cell[61332, 1963, 139, 4, 70, "Text",
 CellID->750652415],
Cell[61474, 1969, 120, 3, 70, "MathCaption",
 CellID->22987297],
Cell[61597, 1974, 182, 5, 70, "Input",
 CellID->7600290],
Cell[61782, 1981, 834, 23, 70, "Text",
 CellID->441445416],
Cell[62619, 2006, 208, 5, 70, "Text",
 CellID->97450775],
Cell[62830, 2013, 409, 13, 70, "Text",
 CellID->299293111],
Cell[63242, 2028, 941, 29, 70, "Text",
 CellID->455643976],
Cell[64186, 2059, 1132, 33, 70, "Text",
 CellID->37891906],
Cell[65321, 2094, 712, 25, 70, "MathCaption",
 CellID->177859870],
Cell[CellGroupData[{
Cell[66058, 2123, 240, 8, 70, "Input",
 CellID->229943877],
Cell[66301, 2133, 466, 16, 36, "Output",
 CellID->91737904]
}, Open  ]],
Cell[66782, 2152, 978, 29, 70, "Text",
 CellID->69981609]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67809, 2187, 52, 1, 70, "Section",
 CellID->323535181],
Cell[67864, 2190, 62, 1, 70, "Text",
 CellID->19160971],
Cell[67929, 2193, 75, 1, 70, "Text",
 CellID->416897326],
Cell[68007, 2196, 4283, 133, 70, "Input",
 CellID->64279527],
Cell[72293, 2331, 81, 1, 70, "Text",
 CellID->731454495],
Cell[72377, 2334, 4737, 154, 70, "Input",
 CellID->290326339],
Cell[CellGroupData[{
Cell[77139, 2492, 88, 1, 70, "Subsection",
 CellID->132997645],
Cell[77230, 2495, 171, 4, 70, "Text",
 CellID->164721189],
Cell[77404, 2501, 3806, 121, 70, "Input",
 CellID->117496310],
Cell[81213, 2624, 82, 1, 70, "Text",
 CellID->212393141],
Cell[81298, 2627, 169, 4, 70, "Text",
 CellID->355991212],
Cell[81470, 2633, 770, 24, 70, "Input",
 CellID->162008933]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[82289, 2663, 70, 1, 70, "TutorialMoreAboutSection",
 CellID->23220180],
Cell[82362, 2666, 254, 7, 70, "TutorialMoreAbout",
 CellID->4029634],
Cell[82619, 2675, 214, 7, 70, "TutorialMoreAbout",
 CellID->1567025153],
Cell[82836, 2684, 257, 7, 70, "TutorialMoreAbout",
 CellID->9400535],
Cell[83096, 2693, 241, 6, 70, "TutorialMoreAbout",
 CellID->189317751]
}, Open  ]]
}, Open  ]],
Cell[83364, 2703, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

