(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24068,        801]
NotebookOptionsPosition[     20584,        690]
NotebookOutlinePosition[     22165,        735]
CellTagsIndexPosition[     22080,        730]
WindowTitle->ShowLagrangian - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/ShowLagrangian\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/ShowLagrangian"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
ShowLagrangian.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/ShowLagrangian", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["ShowLagrangian", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShowLagrangian", "[", "model", "]"}]], "InlineFormula"],
     " \[LineSeparator]Shows the Lagrangian (parts Y, \[Mu], L, h, b, s, ",
     Cell[BoxData[
      SuperscriptBox["m", "2"]], "InlineFormula"],
     ") used to calculate the RGEs"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->63042833],

Cell[TextData[{
 "The input is a list of fields: ",
 Cell[BoxData[
  RowBox[{"model", "=", 
   RowBox[{"{", 
    RowBox[{"field1", ",", "field2", ",", "..."}], "}"}]}]], "InlineFormula"],
 ". Each field should be in the format ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"g1", "\[Rule]", "g1_rep"}], ",", 
    RowBox[{"g2", "\[Rule]", "g2_rep"}], ",", "...", ",", 
    RowBox[{"NFlavours", "\[Rule]", "nf"}], ",", 
    RowBox[{"DiscreteSym", "\[Rule]", "q"}]}], "}"}]], "InlineFormula"],
 ";"
}], "Notes",
 CellID->113314501],

Cell[TextData[{
 Cell[BoxData["g1"], "InlineFormula"],
 ", ",
 Cell[BoxData["g2"], "InlineFormula"],
 ", ... are the gauge factor groups of the model (each specified by a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"],
 ");"
}], "Notes",
 CellID->170829957],

Cell[TextData[{
 Cell[BoxData["g1_rep"], "InlineFormula"],
 ", ",
 Cell[BoxData["g2_rep"], "InlineFormula"],
 ", ... are the representations of the field under each of the gauge factor \
groups. For U(1)'s these are just numbers (the hypercharges). For simple \
factor groups like SU(n), SO(n), ...,  the user must use Dynkin coefficients \
(see the ",
 ButtonBox["Susyno Tutorial",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"],
 " for details);"
}], "Notes",
 CellID->523050374],

Cell[TextData[{
 Cell[BoxData["nf"], "InlineFormula"],
 " is the number of flavours (the ",
 Cell[BoxData[
  RowBox[{"NFlavours", "\[Rule]", "nf"}]], "InlineFormula"],
 " command can be omitted in which case the number of flavours is taken to be \
the symbolic value ",
 Cell[BoxData[
  RowBox[{"nf", "[", "i", "]"}]], "InlineFormula"],
 " where ",
 Cell[BoxData["i"], "InlineFormula"],
 " is the order of the field). ",
 Cell[BoxData["nf"], "InlineFormula"],
 " can be a number or a symbol;"
}], "Notes",
 CellID->260481255],

Cell[TextData[{
 Cell[BoxData["q"], "InlineFormula"],
 " is the charge of the field under some abelian discrete symmetry  (the ",
 Cell[BoxData[
  RowBox[{"DiscreteSym", "\[Rule]", "q"}]], "InlineFormula"],
 " command can be omitted in which case the field is taken to have trivial \
charge [=1]). ",
 Cell[BoxData["q"], "InlineFormula"],
 " can be a number (only one abelian discrete symmetry) or a list of numbers \
(if there is more than one abelian discrete symmetry). In any case, all the \
numbers must have modulus 1 since they are ",
 Cell[BoxData[
  SubscriptBox["Z", "n"]], "InlineFormula"],
 " charges;"
}], "Notes",
 CellID->8615200],

Cell[TextData[{
 "There is an option ",
 Cell[BoxData["Verbose"], "InlineFormula"],
 " which is ",
 Cell[BoxData["True"], "InlineFormula"],
 " by default, meaning that the results are printed on the front-end. No \
printing occurs if ",
 Cell[BoxData[
  RowBox[{"Verbose", "\[Rule]", "False"}]], "InlineFormula"],
 ";"
}], "Notes",
 CellID->145507827],

Cell[TextData[{
 "In general we have W= ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["1", "6"], " ", 
     SuperscriptBox["Y", "ijk"], " ", 
     SubscriptBox["\[CapitalPhi]", "i"], " ", 
     SubscriptBox["\[CapitalPhi]", "j"], " ", 
     SubscriptBox["\[CapitalPhi]", "k"]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["\[Mu]", "ij"], 
     SubscriptBox["\[CapitalPhi]", "i"], " ", " ", 
     SubscriptBox["\[CapitalPhi]", "j"]}], "+", 
    RowBox[{
     SuperscriptBox["L", "i"], 
     SubscriptBox["\[CapitalPhi]", "i"]}]}], TraditionalForm]], "InlineMath"],
 "  and -",
 Cell[BoxData[
  SubscriptBox["\[GothicCapitalL]", "soft"]]],
 "=",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "6"], " ", 
       SuperscriptBox["h", "ijk"], " ", 
       SubscriptBox["\[Phi]", "i"], " ", 
       SubscriptBox["\[Phi]", "j"], " ", 
       SubscriptBox["\[Phi]", "k"]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["b", "ij"], 
       SubscriptBox["\[Phi]", "i"], "  ", 
       SubscriptBox["\[Phi]", "j"]}], "+", 
      RowBox[{
       SuperscriptBox["s", "i"], 
       SubscriptBox["\[Phi]", "i"]}], "+", 
      RowBox[{"h", ".", "c", "."}]}], ")"}], "+", 
    RowBox[{
     SubscriptBox[
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox["m", "2"], ")"}], "i"], "j"], 
     SubscriptBox["\[Phi]", "i"], 
     SubscriptBox[
      SuperscriptBox["\[Phi]", "*"], "j"]}], "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], 
       SubscriptBox["M", "a"], 
       SubscriptBox["\[Lambda]", "a"], 
       SubscriptBox["\[Lambda]", "a"]}], "+", 
      RowBox[{"h", ".", "c", "."}]}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ";"
}], "Notes",
 CellID->417629817],

Cell[TextData[{
 "With  ",
 Cell[BoxData[
  RowBox[{"Verbose", "\[Rule]", "True"}]], "InlineFormula"],
 ", this method will print  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox["Y", "ijk"], " ", 
    SubscriptBox["\[CapitalPhi]", "i"], " ", 
    SubscriptBox["\[CapitalPhi]", "j"], " ", 
    SubscriptBox["\[CapitalPhi]", "k"]}], TraditionalForm]], "InlineMath"],
 "  (",
 StyleBox["Y part",
  FontSlant->"Italic"],
 "),  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["\[Mu]", "ij"], 
    SubscriptBox["\[CapitalPhi]", "i"], " ", " ", 
    SubscriptBox["\[CapitalPhi]", "j"]}], TraditionalForm]], "InlineMath"],
 "  (\[Mu]",
 StyleBox[" part",
  FontSlant->"Italic"],
 "),  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["L", "i"], 
    SubscriptBox["\[CapitalPhi]", "i"]}], TraditionalForm]], "InlineMath"],
 "  (",
 StyleBox["L part",
  FontSlant->"Italic"],
 "),  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox["h", "ijk"], " ", 
    SubscriptBox["\[Phi]", "i"], " ", 
    SubscriptBox["\[Phi]", "j"], " ", 
    SubscriptBox["\[Phi]", "k"]}], TraditionalForm]], "InlineMath"],
 "  (",
 StyleBox["H part",
  FontSlant->"Italic"],
 "),  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["b", "ij"], 
    SubscriptBox["\[Phi]", "i"], "  ", 
    SubscriptBox["\[Phi]", "j"]}], TraditionalForm]], "InlineMath"],
 "  (",
 StyleBox["B part",
  FontSlant->"Italic"],
 "),  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["s", "i"], 
    SubscriptBox["\[Phi]", "i"]}], TraditionalForm]], "InlineMath"],
 "  (",
 StyleBox["S part",
  FontSlant->"Italic"],
 ") and  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["m", "2"], ")"}], "i"], "j"], 
    SubscriptBox["\[Phi]", "i"], 
    SubscriptBox[
     SuperscriptBox["\[Phi]", "*"], "j"]}], TraditionalForm]], "InlineMath"],
 "  (",
 StyleBox["M2 part",
  FontSlant->"Italic"],
 "). Representations/fields are named ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Fld", "[", "repIdx", "]"}], "[", 
   RowBox[{"groupIdx1", ",", "groupIdx2", ",", "...", ",", 
    RowBox[{"<", 
     RowBox[{"flav", " ", "if", " ", "any"}], ">"}]}], "]"}]], 
  "InlineFormula"],
 " where ",
 Cell[BoxData["groupIdx1"], "InlineFormula"],
 ", ",
 Cell[BoxData["groupIdx2"], "InlineFormula"],
 ", ... are the gauge indices of the fields. The flavour indices ",
 Cell[BoxData[
  RowBox[{"<", 
   RowBox[{"flav", " ", "if", " ", "any"}], ">"}]], "InlineFormula"],
 "  may not be present if a particular representation has only one flavour;"
}], "Notes",
 CellID->881343760],

Cell[TextData[{
 "The method returns the list of tensors {Y,\[Mu],L,h,b,s, ",
 Cell[BoxData[
  SuperscriptBox["m", "2"]], "InlineFormula"],
 "}. If needed, use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " built-in commands ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " to convert these results which are in ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " form."
}], "Notes",
 CellID->78760176]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->731771050],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->187288908],

Cell["Set the MSSM model input as usual:", "ExampleText",
 CellID->788],

Cell[BoxData[{
 RowBox[{
  RowBox[{"norm", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"3", "/", "5"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "->", 
      RowBox[{
       RowBox[{"1", "/", "6"}], " ", "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "1", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "->", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "/", "3"}], " ", "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", 
      RowBox[{
       RowBox[{"1", "/", "3"}], " ", "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], " ", "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "1", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", " ", "norm"}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hu", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", " ", 
      RowBox[{
       RowBox[{"1", "/", "2"}], "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "1", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "1"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Hd", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"U1", "\[Rule]", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], "norm"}]}], " ", ",", 
      RowBox[{"SU2", "->", 
       RowBox[{"{", "1", "}"}]}], ",", 
      RowBox[{"SU3", "->", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", 
      RowBox[{"NFlavours", "\[Rule]", "1"}], ",", 
      RowBox[{"DiscreteSym", "\[Rule]", "1"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"model", "=", 
   RowBox[{"{", 
    RowBox[{
    "Q", ",", "u", ",", "d", ",", "L", ",", "e", ",", "Hu", ",", "Hd"}], 
    "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->790578945],

Cell["\<\
Then we can take a look at the Lagrangian built by the program:\
\>", "ExampleText",
 CellID->222648444],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Prints", " ", "the", " ", "results"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ShowLagrangian", "[", "model", "]"}], ";"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331362712],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Prints", " ", "nothing"}], ";", " ", 
    RowBox[{
    "returns", " ", "the", " ", "results", " ", "as", " ", "tensors"}]}], " ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{"ShowLagrangian", "[", 
   RowBox[{"model", ",", 
    RowBox[{"Verbose", "\[Rule]", "False"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->49360905],

Cell["\<\
In the latter case, if we really want to see the tensors we may use Normal:\
\>", "ExampleText",
 CellID->84739912],

Cell[BoxData[
 RowBox[{
  RowBox[{"ShowLagrangian", "[", 
   RowBox[{"model", ",", 
    RowBox[{"Verbose", "\[Rule]", "False"}]}], "]"}], " ", "//", 
  "Normal"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->554943635]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BetaFunctions1L",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/BetaFunctions1L"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["BetaFunctions2L",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/BetaFunctions2L"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"]
}], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShowLagrangian - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 3, 2, 12, 16, 41.8437500}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "ShowLagrangian[model] Shows the Lagrangian (parts Y, \\[Mu], L, h, b, s, \
m^2) used to calculate the RGEs", "synonyms" -> {}, "title" -> 
    "ShowLagrangian", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/ShowLagrangian"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12645, 416, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->731771050]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21936, 723}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[595, 21, 76, 1, 70, "SymbolColorBar"],
Cell[674, 24, 178, 5, 70, "LinkTrail"],
Cell[855, 31, 2322, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3202, 88, 57, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[3262, 91, 501, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3800, 110, 579, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->63042833],
Cell[4382, 129, 539, 16, 70, "Notes",
 CellID->113314501],
Cell[4924, 147, 310, 10, 70, "Notes",
 CellID->170829957],
Cell[5237, 159, 510, 13, 70, "Notes",
 CellID->523050374],
Cell[5750, 174, 525, 15, 70, "Notes",
 CellID->260481255],
Cell[6278, 191, 645, 15, 70, "Notes",
 CellID->8615200],
Cell[6926, 208, 351, 11, 70, "Notes",
 CellID->145507827],
Cell[7280, 221, 1858, 62, 70, "Notes",
 CellID->417629817],
Cell[9141, 285, 2766, 100, 70, "Notes",
 CellID->881343760],
Cell[11910, 387, 698, 24, 70, "Notes",
 CellID->78760176]
}, Closed]],
Cell[CellGroupData[{
Cell[12645, 416, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->731771050],
Cell[CellGroupData[{
Cell[13131, 433, 148, 5, 70, "ExampleSection",
 CellID->187288908],
Cell[13282, 440, 71, 1, 70, "ExampleText",
 CellID->788],
Cell[13356, 443, 3790, 119, 70, "Input",
 CellID->790578945],
Cell[17149, 564, 114, 3, 70, "ExampleText",
 CellID->222648444],
Cell[17266, 569, 259, 8, 70, "Input",
 CellID->331362712],
Cell[17528, 579, 404, 12, 70, "Input",
 CellID->49360905],
Cell[17935, 593, 125, 3, 70, "ExampleText",
 CellID->84739912],
Cell[18063, 598, 216, 7, 70, "Input",
 CellID->554943635]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18328, 611, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[18750, 625, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[18938, 633, 427, 12, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[19368, 647, 1174, 38, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[20557, 688, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

