(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11407,        360]
NotebookOptionsPosition[      9175,        290]
NotebookOutlinePosition[     10735,        335]
CellTagsIndexPosition[     10650,        330]
WindowTitle->Error07 - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[Cell[BoxData[
     ActionMenuBox[
      FrameBox["\<\"URL \[RightGuillemet]\"\>",
       StripOnInput->False], {"\<\"Susyno/ref/Error07\"\>":>
      None, "\<\"Copy Mathematica url\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell["Susyno/ref/Error07"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; Null], 
      Delimiter, "\<\"Copy web url\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell[
             BoxData[
              MakeBoxes[
               Hyperlink[
               "http://reference.wolfram.com/mathematica/Susyno/ref/Error07.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
           False]]; SelectionMove[
        DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; 
       Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
        NotebookLocate[{
          URL[
           StringJoin[
           "http://reference.wolfram.com/mathematica/", "Susyno/ref/Error07", 
            ".html"]], None}]}]},
      Appearance->None,
      MenuAppearance->Automatic]],
     LineSpacing->{1.4, 0}]], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["Error07", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Error07"], "InlineFormula"],
     " \[LineSeparator]This error message is generated when fields have a \
varying number of discrete abelian group charges "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->170781000],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->446154239],

Cell["\<\
The highlighted line is wrong (because the Q field contains 2 discrete \
symmetry charges instead of 1):\
\>", "ExampleText",
 CellID->340568843],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"norm", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"3", "/", "5"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"Q", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"U1", "->", 
       RowBox[{
        RowBox[{"1", "/", "6"}], " ", "norm"}]}], " ", ",", 
      RowBox[{"SU2", "->", 
       RowBox[{"{", "1", "}"}]}], ",", 
      RowBox[{"SU3", "->", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], ",", 
      RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
      RowBox[{"DiscreteSym", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "}"}]}], ";"}],
  Background->RGBColor[
   1., 0.7254901960784313, 0.7254901960784313]], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "->", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "/", "3"}], " ", "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", 
      RowBox[{
       RowBox[{"1", "/", "3"}], " ", "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], " ", "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "1", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", " ", "norm"}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hu", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", " ", 
      RowBox[{
       RowBox[{"1", "/", "2"}], "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "1", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "1"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Hd", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"U1", "\[Rule]", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], "norm"}]}], " ", ",", 
      RowBox[{"SU2", "->", 
       RowBox[{"{", "1", "}"}]}], ",", 
      RowBox[{"SU3", "->", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", 
      RowBox[{"NFlavours", "\[Rule]", "1"}], ",", 
      RowBox[{"DiscreteSym", "\[Rule]", "1"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"model", "=", 
    RowBox[{"{", 
     RowBox[{
     "Q", ",", "u", ",", "d", ",", "L", ",", "e", ",", "Hu", ",", "Hd"}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BetaFunctions2L", "[", "model", "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->817848179],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    ButtonBox[
     PaneSelectorBox[{False->"\<\"[ERROR CODE 07]\"\>", True->
      StyleBox["\<\"[ERROR CODE 07]\"\>", "HyperlinkActive"]}, Dynamic[
       CurrentValue["MouseOver"]],
      BaseStyle->{"Hyperlink"},
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/Error07",
     ButtonNote->"paclet:Susyno/ref/Error07"],
    Annotation[#, "paclet:Susyno/ref/Error07", "Hyperlink"]& ], 
   "\[InvisibleSpace]", "\<\" Different fields have a different number of \
\"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"discrete symmetries\"\>",
    StripOnInput->False,
    FontWeight->Bold]}],
  SequenceForm[
   Hyperlink["[ERROR CODE 07]", "paclet:Susyno/ref/Error07"], 
   " Different fields have a different number of ", 
   Style["discrete symmetries", Bold]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->387807574]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Error07 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 3, 2, 12, 15, 17.3906250}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "Error07 This error message is generated when fields have a varying \
number of discrete abelian group charges ", "synonyms" -> {}, "title" -> 
    "Error07", "type" -> "Symbol", "uri" -> "Susyno/ref/Error07"}, 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3204, 95, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->170781000]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10508, 323}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[588, 21, 76, 1, 70, "SymbolColorBar"],
Cell[667, 24, 178, 5, 70, "LinkTrail"],
Cell[848, 31, 1838, 41, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[2711, 76, 50, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2764, 79, 403, 11, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3204, 95, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->170781000],
Cell[CellGroupData[{
Cell[3690, 112, 148, 5, 70, "ExampleSection",
 CellID->446154239],
Cell[3841, 119, 155, 4, 70, "ExampleText",
 CellID->340568843],
Cell[CellGroupData[{
Cell[4021, 127, 4080, 127, 70, "Input",
 CellID->817848179],
Cell[8104, 256, 1005, 27, 70, "Print",
 CellID->387807574]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[9148, 288, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

