(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12650,        399]
NotebookOptionsPosition[     10274,        324]
NotebookOutlinePosition[     11812,        368]
CellTagsIndexPosition[     11727,        363]
WindowTitle->Error 05 - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/Error05\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/Error05"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/Error05.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", "Susyno/ref/Error05",
              ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["Error 05", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Error", " ", "05"}]], "InlineFormula"],
     " \[LineSeparator]This error message is generated when some of the \
hypercharges are not numbers."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->180094633],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->343274160],

Cell["The highlighted line is wrong (yQ is not a number):", "ExampleText",
 CellID->340568843],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"norm", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"3", "/", "5"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"Q", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"U1", "\[Rule]", "yQ"}], " ", ",", 
      RowBox[{"SU2", "->", 
       RowBox[{"{", "1", "}"}]}], ",", 
      RowBox[{"SU3", "->", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], ",", 
      RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
      RowBox[{"DiscreteSym", "\[Rule]", 
       RowBox[{"-", "1"}]}]}], "}"}]}], ";"}],
  Background->RGBColor[
   1., 0.7254901960784313, 0.7254901960784313]], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "->", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "/", "3"}], " ", "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", 
      RowBox[{
       RowBox[{"1", "/", "3"}], " ", "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], " ", "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "1", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", " ", "norm"}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "3"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hu", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U1", "\[Rule]", " ", 
      RowBox[{
       RowBox[{"1", "/", "2"}], "norm"}]}], " ", ",", 
     RowBox[{"SU2", "->", 
      RowBox[{"{", "1", "}"}]}], ",", 
     RowBox[{"SU3", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NFlavours", "\[Rule]", "1"}], ",", 
     RowBox[{"DiscreteSym", "\[Rule]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Hd", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"U1", "\[Rule]", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], "norm"}]}], " ", ",", 
      RowBox[{"SU2", "->", 
       RowBox[{"{", "1", "}"}]}], ",", 
      RowBox[{"SU3", "->", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", 
      RowBox[{"NFlavours", "\[Rule]", "1"}], ",", 
      RowBox[{"DiscreteSym", "\[Rule]", "1"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"model", "=", 
    RowBox[{"{", 
     RowBox[{
     "Q", ",", "u", ",", "d", ",", "L", ",", "e", ",", "Hu", ",", "Hd"}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BetaFunctions2L", "[", "model", "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->119897586],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    ButtonBox[
     PaneSelectorBox[{False->"\<\"[ERROR CODE 05]\"\>", True->
      StyleBox["\<\"[ERROR CODE 05]\"\>", "HyperlinkActive"]}, Dynamic[
       CurrentValue["MouseOver"]],
      BaseStyle->{"Hyperlink"},
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     BaseStyle->"Link",
     ButtonData->"paclet:Susyno/ref/Error05",
     ButtonNote->"paclet:Susyno/ref/Error05"],
    Annotation[#, "paclet:Susyno/ref/Error05", "Hyperlink"]& ], 
   "\[InvisibleSpace]", "\<\" Some of the hypercharges of \"\>", 
   "\[InvisibleSpace]", 
   StyleBox["\<\"field #\"\>",
    StripOnInput->False,
    FontWeight->Bold], "\[InvisibleSpace]", 
   StyleBox["1",
    StripOnInput->False,
    FontWeight->Bold], 
   "\[InvisibleSpace]", "\<\" are not correct. Make sure that they are all \
numbers.\"\>"}],
  SequenceForm[
   Hyperlink["[ERROR CODE 05]", "paclet:Susyno/ref/Error05"], 
   " Some of the hypercharges of ", 
   Style["field #", Bold], 
   Style[1, Bold], " are not correct. Make sure that they are all numbers."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->17170204]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Error 05 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 3, 2, 12, 15, 4.2812500}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "Error 05 This error message is generated when some of the hypercharges \
are not numbers.", "synonyms" -> {}, "title" -> "Error 05", "type" -> 
    "Symbol", "uri" -> "Susyno/ref/Error05"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3665, 108, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->180094633]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11584, 356}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[589, 21, 76, 1, 70, "SymbolColorBar"],
Cell[668, 24, 178, 5, 70, "LinkTrail"],
Cell[849, 31, 2293, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3167, 88, 51, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[3221, 91, 407, 12, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3665, 108, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->180094633],
Cell[CellGroupData[{
Cell[4151, 125, 148, 5, 70, "ExampleSection",
 CellID->343274160],
Cell[4302, 132, 94, 1, 70, "ExampleText",
 CellID->340568843],
Cell[CellGroupData[{
Cell[4421, 137, 3967, 123, 70, "Input",
 CellID->119897586],
Cell[8391, 262, 1207, 33, 70, "Print",
 CellID->17170204]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9659, 302, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[10081, 316, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[10247, 322, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

