(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24003,        810]
NotebookOptionsPosition[     20564,        701]
NotebookOutlinePosition[     22157,        746]
CellTagsIndexPosition[     22072,        741]
WindowTitle->ShowLagrangian - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/ShowLagrangian\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/ShowLagrangian"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
ShowLagrangian.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/ShowLagrangian", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["ShowLagrangian", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShowLagrangian", "[", 
       RowBox[{
       "group", ",", "representations", ",", "nFlavours", ",", "RParity", ",", 
        RowBox[{"<", "print", ">"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]Shows the Lagrangian used to calculate the RGEs"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->257632923],

Cell[TextData[{
 "Input for this method is very similar to that of ",
 Cell[BoxData[
  ButtonBox["BetaFunctions1L",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/BetaFunctions1L"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BetaFunctions2L",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/BetaFunctions2L"]], "InlineFormula"],
 ";"
}], "Notes",
 CellID->64151256],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"groups", "=", 
   RowBox[{"{", 
    RowBox[{"group1", ",", "group2", ",", "..."}], "}"}]}]], "InlineFormula"],
 " is a list of simple groups (each specified by a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CM"],
 ");"
}], "Notes",
 CellID->566462438],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"representations", "=", 
   RowBox[{"{", 
    RowBox[{"rep1", ",", "rep2", ",", "rep3", ",", "..."}], "}"}]}]], 
  "InlineFormula"],
 " is a list of the representations/fields in the model. Each field in the \
list is of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
   "hypCharge1", ",", "hypCharge2", ",", "...", ",", "rep_grp1", ",", 
    "rep_grp2", ",", "..."}], "}"}]], "InlineFormula"],
 " where the hypercharges are just numbers and ",
 Cell[BoxData["rep_grp1"], "InlineFormula"],
 ", ",
 Cell[BoxData["rep_grp2"], "InlineFormula"],
 ",... are the field's representations in each of the simple factor groups ",
 Cell[BoxData["group1"], "InlineFormula"],
 ", ",
 Cell[BoxData["group2"], "InlineFormula"],
 ",...;"
}], "Notes",
 CellID->20918677],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"nFlavours", "=", 
   RowBox[{"{", 
    RowBox[{"nf1", ",", "nf2", ",", "..."}], "}"}]}]], "InlineFormula"],
 " should be a list (of numbers or symbols) representing the number of \
flavours of each representation/field. Therefore it must have the same size \
as the list of representations of the model. If ",
 Cell[BoxData[
  RowBox[{"nFlavours", "=", 
   RowBox[{"{", "}"}]}]], "InlineFormula"],
 ", the program will use the abstract default value ",
 Cell[BoxData[
  RowBox[{"nFlavours", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"nf", "[", "1", "]"}], ",", 
     RowBox[{"nf", "[", "2", "]"}], ",", "..."}], "}"}]}]], "InlineFormula"],
 ";"
}], "Notes",
 CellID->125998336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"RParity", "=", 
   RowBox[{"{", 
    RowBox[{"r1", ",", "r2", ",", "..."}], "}"}]}]], "InlineFormula"],
 " should be a list (of numbers) with the R-symmetry of each \
representation/field and with the same size as the list of representations of \
the model. If ",
 Cell[BoxData[
  RowBox[{"RParity", "=", 
   RowBox[{"{", "}"}]}]], "InlineFormula"],
 ", the program will assume  ",
 Cell[BoxData[
  RowBox[{"RParity", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "..."}], "}"}]}]], "InlineFormula"],
 ";"
}], "Notes",
 CellID->408512623],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"<", "print", ">"}]], "InlineFormula"],
 " can be ",
 Cell[BoxData["True"], "InlineFormula"],
 " or ",
 Cell[BoxData["False"], "InlineFormula"],
 ". This parameter is optional (default value is ",
 Cell[BoxData["True"], "InlineFormula"],
 ");"
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "In general we have W= ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["1", "6"], " ", 
     SuperscriptBox["Y", "ijk"], " ", 
     SubscriptBox["\[CapitalPhi]", "i"], " ", 
     SubscriptBox["\[CapitalPhi]", "j"], " ", 
     SubscriptBox["\[CapitalPhi]", "k"]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["\[Mu]", "ij"], 
     SubscriptBox["\[CapitalPhi]", "i"], " ", " ", 
     SubscriptBox["\[CapitalPhi]", "j"]}], "+", 
    RowBox[{
     SuperscriptBox["L", "i"], 
     SubscriptBox["\[CapitalPhi]", "i"]}]}], TraditionalForm]], "InlineMath"],
 "  and -",
 Cell[BoxData[
  SubscriptBox["\[GothicCapitalL]", "soft"]]],
 "=",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "6"], " ", 
       SuperscriptBox["h", "ijk"], " ", 
       SubscriptBox["\[Phi]", "i"], " ", 
       SubscriptBox["\[Phi]", "j"], " ", 
       SubscriptBox["\[Phi]", "k"]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["b", "ij"], 
       SubscriptBox["\[Phi]", "i"], "  ", 
       SubscriptBox["\[Phi]", "j"]}], "+", 
      RowBox[{
       SuperscriptBox["s", "i"], 
       SubscriptBox["\[Phi]", "i"]}], "+", 
      RowBox[{"h", ".", "c", "."}]}], ")"}], "+", 
    RowBox[{
     SubscriptBox[
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox["m", "2"], ")"}], "i"], "j"], 
     SubscriptBox["\[Phi]", "i"], 
     SubscriptBox[
      SuperscriptBox["\[Phi]", "*"], "j"]}], "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], 
       SubscriptBox["M", "a"], 
       SubscriptBox["\[Lambda]", "a"], 
       SubscriptBox["\[Lambda]", "a"]}], "+", 
      RowBox[{"h", ".", "c", "."}]}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ";"
}], "Notes",
 CellID->417629817],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"<", "print", ">", " ", 
   RowBox[{"=", "True"}]}]], "InlineFormula"],
 " , this method will print  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox["Y", "ijk"], " ", 
    SubscriptBox["\[CapitalPhi]", "i"], " ", 
    SubscriptBox["\[CapitalPhi]", "j"], " ", 
    SubscriptBox["\[CapitalPhi]", "k"]}], TraditionalForm]], "InlineMath"],
 "  (",
 StyleBox["Y part",
  FontSlant->"Italic"],
 "),  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["\[Mu]", "ij"], 
    SubscriptBox["\[CapitalPhi]", "i"], " ", " ", 
    SubscriptBox["\[CapitalPhi]", "j"]}], TraditionalForm]], "InlineMath"],
 "  (\[Mu]",
 StyleBox[" part",
  FontSlant->"Italic"],
 "),  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["L", "i"], 
    SubscriptBox["\[CapitalPhi]", "i"]}], TraditionalForm]], "InlineMath"],
 "  (",
 StyleBox["L part",
  FontSlant->"Italic"],
 "),  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox["h", "ijk"], " ", 
    SubscriptBox["\[Phi]", "i"], " ", 
    SubscriptBox["\[Phi]", "j"], " ", 
    SubscriptBox["\[Phi]", "k"]}], TraditionalForm]], "InlineMath"],
 "  (",
 StyleBox["H part",
  FontSlant->"Italic"],
 "),  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["b", "ij"], 
    SubscriptBox["\[Phi]", "i"], "  ", 
    SubscriptBox["\[Phi]", "j"]}], TraditionalForm]], "InlineMath"],
 "  (",
 StyleBox["B part",
  FontSlant->"Italic"],
 "),  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["s", "i"], 
    SubscriptBox["\[Phi]", "i"]}], TraditionalForm]], "InlineMath"],
 "  (",
 StyleBox["S part",
  FontSlant->"Italic"],
 ") and  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["m", "2"], ")"}], "i"], "j"], 
    SubscriptBox["\[Phi]", "i"], 
    SubscriptBox[
     SuperscriptBox["\[Phi]", "*"], "j"]}], TraditionalForm]], "InlineMath"],
 "  (",
 StyleBox["M2 part",
  FontSlant->"Italic"],
 "). Representations/fields are named ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Fld", "[", "repIdx", "]"}], "[", 
   RowBox[{"groupIdx1", ",", "groupIdx2", ",", "...", ",", 
    RowBox[{"<", 
     RowBox[{"flav", " ", "if", " ", "any"}], ">"}]}], "]"}]], 
  "InlineFormula"],
 " where ",
 Cell[BoxData["groupIdx1"], "InlineFormula"],
 ", ",
 Cell[BoxData["groupIdx2"], "InlineFormula"],
 ", ... are the gauge indices of the fields. The flavour indices ",
 Cell[BoxData[
  RowBox[{"<", 
   RowBox[{"flav", " ", "if", " ", "any"}], ">"}]], "InlineFormula"],
 "  may not be present if a particular representation has only one flavour;"
}], "Notes",
 CellID->881343760],

Cell[TextData[{
 "If  ",
 Cell[BoxData[
  RowBox[{"<", "print", ">", " ", 
   RowBox[{"=", "False"}]}]], "InlineFormula"],
 " the method outputs the list of tensors {Y,\[Mu],L,h,b,s, ",
 Cell[BoxData[
  SuperscriptBox["m", "2"]], "InlineFormula"],
 "} and nothing is printed. If needed, use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " built-in commands ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " to convert these results which are in ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " form;"
}], "Notes",
 CellID->78760176]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->433708130],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->95776747],

Cell["First set the MSSM model input as usual:", "ExampleText",
 CellID->788],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"groups", "=", 
    RowBox[{"{", 
     RowBox[{"SU2", ",", "SU3"}], "}"}]}], ";"}], "  ", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norm", "=", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"3", "/", "5"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "/", "6"}], " ", "norm"}], " ", ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "/", "3"}], " ", "norm"}], ",", 
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "3"}], " ", "norm"}], ",", 
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
  "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], " ", "norm"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"e", "=", 
    RowBox[{"{", 
     RowBox[{"norm", ",", 
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
  "                "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hu", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "/", "2"}], " ", "norm"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Hd", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], "norm"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"representations", "=", 
    RowBox[{"{", 
     RowBox[{
     "Q", ",", "u", ",", "d", ",", "L", ",", "e", ",", "Hu", ",", "Hd"}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nFlavours", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "1", ",", "1"}],
     "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RParity", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1", ",", "1"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->790578945],

Cell["\<\
Then we can take a look at the Lagrangian built by the program:\
\>", "ExampleText",
 CellID->222648444],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Prints", " ", "the", " ", "results"}], ";", " ", 
    RowBox[{"returns", " ", "Null"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ShowLagrangian", "[", 
    RowBox[{
    "groups", ",", "representations", ",", "nFlavours", ",", "RParity"}], 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Prints", " ", "nothing"}], ";", " ", 
     RowBox[{
     "returns", " ", "the", " ", "results", " ", "as", " ", "tensors"}]}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"ShowLagrangian", "[", 
    RowBox[{
    "groups", ",", "representations", ",", "nFlavours", ",", "RParity", ",", 
     "False"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331362712],

Cell["\<\
In the latter case, if we really want to see the tensors we may use Normal:\
\>", "ExampleText",
 CellID->84739912],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ShowLagrangian", "[", 
    RowBox[{
    "groups", ",", "representations", ",", "nFlavours", ",", "RParity", ",", 
     "False"}], "]"}], " ", "//", "Normal"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->554943635]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BetaFunctions1L",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/BetaFunctions1L"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["BetaFunctions2L",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/BetaFunctions2L"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"]
}], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShowLagrangian - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2011, 2, 8, 16, 0, 30.8437500}", "context" -> "Susyno`", 
    "keywords" -> {}, "index" -> True, "label" -> "Susyno Paclet Symbol", 
    "language" -> "en", "paclet" -> "Susyno", "status" -> "None", "summary" -> 
    "ShowLagrangian[group, representations, nFlavours, RParity, < print >] \
Shows the Lagrangian used to calculate the RGEs", "synonyms" -> {}, "title" -> 
    "ShowLagrangian", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/ShowLagrangian"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13109, 437, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->433708130]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21928, 734}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[595, 21, 76, 1, 70, "SymbolColorBar"],
Cell[674, 24, 178, 5, 70, "LinkTrail"],
Cell[855, 31, 2322, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3202, 88, 57, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[3262, 91, 518, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3817, 110, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->257632923],
Cell[4400, 129, 396, 13, 70, "Notes",
 CellID->64151256],
Cell[4799, 144, 333, 11, 70, "Notes",
 CellID->566462438],
Cell[5135, 157, 802, 23, 70, "Notes",
 CellID->20918677],
Cell[5940, 182, 726, 20, 70, "Notes",
 CellID->125998336],
Cell[6669, 204, 599, 18, 70, "Notes",
 CellID->408512623],
Cell[7271, 224, 318, 11, 70, "Notes",
 CellID->1067943069],
Cell[7592, 237, 1858, 62, 70, "Notes",
 CellID->417629817],
Cell[9453, 301, 2787, 101, 70, "Notes",
 CellID->881343760],
Cell[12243, 404, 829, 28, 70, "Notes",
 CellID->78760176]
}, Closed]],
Cell[CellGroupData[{
Cell[13109, 437, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->433708130],
Cell[CellGroupData[{
Cell[13595, 454, 147, 5, 70, "ExampleSection",
 CellID->95776747],
Cell[13745, 461, 77, 1, 70, "ExampleText",
 CellID->788],
Cell[13825, 464, 3082, 107, 70, "Input",
 CellID->790578945],
Cell[16910, 573, 114, 3, 70, "ExampleText",
 CellID->222648444],
Cell[17027, 578, 814, 22, 70, "Input",
 CellID->331362712],
Cell[17844, 602, 125, 3, 70, "ExampleText",
 CellID->84739912],
Cell[17972, 607, 287, 9, 70, "Input",
 CellID->554943635]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18308, 622, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[18730, 636, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[18918, 644, 427, 12, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[19348, 658, 1174, 38, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[20537, 699, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

