(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38373,       1371]
NotebookOptionsPosition[     31670,       1141]
NotebookOutlinePosition[     33380,       1189]
CellTagsIndexPosition[     33294,       1184]
WindowTitle->ReduceRepProduct - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"DimR\"\>":>Documentation`HelpLookup[
       "paclet:Susyno/ref/DimR"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/ReduceRepProduct\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/ReduceRepProduct"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/\
ReduceRepProduct.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "Susyno/ref/ReduceRepProduct", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["ReduceRepProduct", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReduceRepProduct", "[", 
       RowBox[{"group", ",", " ", "rep1", ",", " ", "rep2", ",", "..."}], 
       "]"}]], "InlineFormula"],
     " \[LineSeparator]Reduces the direct product representation ",
     Cell[BoxData["rep1"], "InlineFormula"],
     " x ",
     Cell[BoxData["rep2"], "InlineFormula"],
     " x ... into its irreducible parts"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->58122818],

Cell[TextData[{
 Cell[BoxData["group"], "InlineFormula"],
 " should be the ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CM"],
 " of the intended group;"
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Each representation ",
 Cell[BoxData["rep"], "InlineFormula"],
 " should be a list of non-negative integers (Dynkin coefficients);"
}], "Notes",
 CellID->360734878],

Cell[TextData[{
 "There can be 2 or more  ",
 Cell[BoxData["rep"], "InlineFormula"],
 "s as input (there is no upper limit);"
}], "Notes",
 CellID->73174212],

Cell[TextData[{
 "The output of this method is of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"irrep1", ",", " ", "multiplicity1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"irrep2", ",", "multiplicity2"}], "}"}], ",", " "}]}]], 
  "InlineFormula"],
 " ",
 Cell[BoxData[
  RowBox[{"...", "}"}]], "InlineFormula"],
 " where ",
 Cell[BoxData["irrep"], "InlineFormula"],
 "s are the irreducible representations in the product (given in Dynkin \
coefficients) and ",
 Cell[BoxData["multiplicities"], "InlineFormula"],
 " are the number of times each ",
 Cell[BoxData["irrep"], "InlineFormula"],
 " is contained in the product."
}], "Notes",
 CellID->133619986]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->165740056],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->214581247],

Cell["\<\
This tells us that in the product {1,0} x {1,0} of SU(3) there is one {2,0} \
irrep and one {1,0} :\
\>", "ExampleText",
 CellID->513681956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196926373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->372239613]
}, Open  ]],

Cell["\<\
It turns out that {1,0} is the fundamental representation of SU(3). That is \
possible since ...\
\>", "ExampleText",
 CellID->791803354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DimR", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43353311],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23316078]
}, Open  ]],

Cell["\<\
So what is its conjugate? We can check that it is {0,1} because the product \
{1,0} x {0,1} contains the SU(3) singlet {0,0}:\
\>", "ExampleText",
 CellID->337007840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->103769142],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->513679871]
}, Open  ]],

Cell["Sure enough,", "ExampleText",
 CellID->30425394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DimR", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->102523921],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->425251226]
}, Open  ]],

Cell["\<\
and {1,1}, the other representation in the product, is the adjoint (as \
expected):\
\>", "ExampleText",
 CellID->284900139],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Print", "[", "\"\<Adjoint of SU(3):\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Adjoint", "[", "SU3", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<Its dimension:\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DimR", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->714739772],

Cell[BoxData["\<\"Adjoint of SU(3):\"\>"], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->455802147],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 ImageSize->{43, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->164152913],

Cell[BoxData["\<\"Its dimension:\"\>"], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->594113801],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->989303556]
}, Open  ]],

Cell["\<\
Note that there is no limit for the number of representations in the product. \
For example {1, 0} x {1, 1} x {7, 2} x {2, 2} of SU(3):\
\>", "ExampleText",
 CellID->164023796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->26272814],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "5"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "6"}], "}"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "4"}], "}"}], ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "7"}], "}"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"8", ",", "5"}], "}"}], ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"12", ",", "3"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "2"}], "}"}], ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "3"}], "}"}], ",", "28"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "1"}], "}"}], ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "6"}], "}"}], ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "4"}], "}"}], ",", "36"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"8", ",", "2"}], "}"}], ",", "43"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "8"}], "}"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "9"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "7"}], "}"}], ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}], ",", "28"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}], ",", "45"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "8"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "6"}], "}"}], ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}], ",", "28"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"13", ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"12", ",", "0"}], "}"}], ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "0"}], "}"}], ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "1"}], "}"}], ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "2"}], "}"}], ",", "34"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "0"}], "}"}], ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "7"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "6"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{535, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->223992513]
}, Open  ]],

Cell["\<\
Different representations which are indistinguishable just by looking at the \
dimensions,\
\>", "ExampleText",
 CellID->554346309],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DimR", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DimR", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->353483304],

Cell[BoxData["210"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->286126778],

Cell[BoxData["210"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->721592750]
}, Open  ]],

Cell["\<\
... may reveal their differences in direct products with known \
representations such as {1,0,0,0,0}=fundamental of SO(10):\
\>", "ExampleText",
 CellID->360467482],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->196227131],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{551, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->82371302],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{415, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->177376853]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell["\<\
Each quark is in the SU(3) fundamental representation (which is {1,0}) and an \
anti-quark in its conjugate {0,1}. We can see if different combinations of \
quarks and anti-quarks can be uncolored by checking if in the direct product \
representation there are SU(3) singlets {0,0}:\
\>", "ExampleText",
 CellID->358872975],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Print", "[", "\"\<Are there colour singlets in q q q?\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"irrepList", "=", 
  RowBox[{"ReduceRepProduct", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MemberQ", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", "\[Infinity]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<Are there colour singlets in q q q q?\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"irrepList", "=", 
  RowBox[{"ReduceRepProduct", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MemberQ", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", "\[Infinity]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<Are there colour singlets in q q q q q?\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"irrepList", "=", 
  RowBox[{"ReduceRepProduct", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MemberQ", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", "\[Infinity]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<Are there colour singlets in q q q q qBar?\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"irrepList", "=", 
  RowBox[{"ReduceRepProduct", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MemberQ", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", "\[Infinity]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  "\"\<Are there colour singlets in q q q qBar qBar?\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"irrepList", "=", 
  RowBox[{"ReduceRepProduct", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MemberQ", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", "\[Infinity]"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->96133454],

Cell[BoxData["\<\"Are there colour singlets in q q q?\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->330019],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{253, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->770906776],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83329753],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->306927342],

Cell[BoxData["\<\"Are there colour singlets in q q q q?\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->527025003]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{335, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76625266],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->847731845],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->172509633],

Cell[BoxData["\<\"Are there colour singlets in q q q q q?\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->46637857]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->547606438],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140759670],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->167202265],

Cell[BoxData["\<\"Are there colour singlets in q q q q qBar?\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->169153268]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "3"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{499, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24170969],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->186924740],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->133434257],

Cell[BoxData["\<\"Are there colour singlets in q q q qBar qBar?\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->225783943]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{499, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->941074617],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55851426]
}, Open  ]],

Cell["\<\
Using ReduceRepProduct and DimR together - DimR can be used to convert the \
irreps given in Dynkin coefficients notation, to the (potentially ambiguous) \
'dimension notation':\
\>", "ExampleText",
 CellID->448198813],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Print", "[", 
  "\"\<Fundamental x Fundamental x 24 of SU(5) breaks down into:\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"irreps", "=", 
    RowBox[{"ReduceRepProduct", "[", 
     RowBox[{"SU5", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{"DimR", "[", 
        RowBox[{"SU5", ",", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", "Bold"}], "]"}], ",", 
     RowBox[{"#", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "&"}], "/@", 
  "irreps"}], "\[IndentingNewLine]"}], "Input",
 CellLabel->"In[2]:=",
 CellID->244066278],

Cell[BoxData["\<\"Fundamental x Fundamental x 24 of SU(5) breaks down into:\"\
\>"], "Print",
 CellLabel->"During evaluation of In[33]:=",
 CellID->107487656],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["160",
      StripOnInput->False,
      FontWeight->Bold], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["175",
      StripOnInput->False,
      FontWeight->Bold], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["15",
      StripOnInput->False,
      FontWeight->Bold], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["40",
      StripOnInput->False,
      FontWeight->Bold], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["10",
      StripOnInput->False,
      FontWeight->Bold], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{306, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->245052368]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["DimR",
   BaseStyle->"Link",
   ButtonData->"paclet:Susyno/ref/DimR"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReduceRepProduct - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2011, 2, 8, 16, 0, 14.7187500}", "context" -> "Susyno`", 
    "keywords" -> {
     "Direct product", "Representation", "Group", 
      "Irreducible representation", "Reduce"}, "index" -> True, "label" -> 
    "Susyno Paclet Symbol", "language" -> "en", "paclet" -> "Susyno", 
    "status" -> "None", "summary" -> 
    "ReduceRepProduct[group, rep1, rep2, ...] Reduces the direct product \
representation rep1 x rep2 x ... into its irreducible parts", 
    "synonyms" -> {}, "title" -> "ReduceRepProduct", "type" -> "Symbol", 
    "uri" -> "Susyno/ref/ReduceRepProduct"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6031, 189, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->165740056]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33151, 1177}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[597, 21, 76, 1, 70, "SymbolColorBar"],
Cell[676, 24, 178, 5, 70, "LinkTrail"],
Cell[857, 31, 2549, 59, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3431, 94, 59, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[3493, 97, 606, 17, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4136, 119, 579, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->58122818],
Cell[4718, 138, 226, 8, 70, "Notes",
 CellID->1067943069],
Cell[4947, 148, 182, 5, 70, "Notes",
 CellID->360734878],
Cell[5132, 155, 157, 5, 70, "Notes",
 CellID->73174212],
Cell[5292, 162, 702, 22, 70, "Notes",
 CellID->133619986]
}, Closed]],
Cell[CellGroupData[{
Cell[6031, 189, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->165740056],
Cell[CellGroupData[{
Cell[6517, 206, 148, 5, 70, "ExampleSection",
 CellID->214581247],
Cell[6668, 213, 150, 4, 70, "ExampleText",
 CellID->513681956],
Cell[CellGroupData[{
Cell[6843, 221, 245, 8, 70, "Input",
 CellID->196926373],
Cell[7091, 231, 408, 15, 36, "Output",
 CellID->372239613]
}, Open  ]],
Cell[7514, 249, 147, 4, 70, "ExampleText",
 CellID->791803354],
Cell[CellGroupData[{
Cell[7686, 257, 173, 6, 70, "Input",
 CellID->43353311],
Cell[7862, 265, 157, 5, 36, "Output",
 CellID->23316078]
}, Open  ]],
Cell[8034, 273, 176, 4, 70, "ExampleText",
 CellID->337007840],
Cell[CellGroupData[{
Cell[8235, 281, 245, 8, 70, "Input",
 CellID->103769142],
Cell[8483, 291, 408, 15, 36, "Output",
 CellID->513679871]
}, Open  ]],
Cell[8906, 309, 54, 1, 70, "ExampleText",
 CellID->30425394],
Cell[CellGroupData[{
Cell[8985, 314, 174, 6, 70, "Input",
 CellID->102523921],
Cell[9162, 322, 158, 5, 36, "Output",
 CellID->425251226]
}, Open  ]],
Cell[9335, 330, 134, 4, 70, "ExampleText",
 CellID->284900139],
Cell[CellGroupData[{
Cell[9494, 338, 405, 10, 70, "Input",
 CellID->714739772],
Cell[9902, 350, 115, 2, 70, "Print",
 CellID->455802147],
Cell[10020, 354, 203, 7, 36, "Output",
 CellID->164152913],
Cell[10226, 363, 112, 2, 70, "Print",
 CellID->594113801],
Cell[10341, 367, 158, 5, 36, "Output",
 CellID->989303556]
}, Open  ]],
Cell[10514, 375, 186, 4, 70, "ExampleText",
 CellID->164023796],
Cell[CellGroupData[{
Cell[10725, 383, 362, 12, 70, "Input",
 CellID->26272814],
Cell[11090, 397, 4017, 143, 122, "Output",
 CellID->223992513]
}, Open  ]],
Cell[15122, 543, 141, 4, 70, "ExampleText",
 CellID->554346309],
Cell[CellGroupData[{
Cell[15288, 551, 376, 12, 70, "Input",
 CellID->353483304],
Cell[15667, 565, 160, 5, 36, "Output",
 CellID->286126778],
Cell[15830, 572, 160, 5, 36, "Output",
 CellID->721592750]
}, Open  ]],
Cell[16005, 580, 174, 4, 70, "ExampleText",
 CellID->360467482],
Cell[CellGroupData[{
Cell[16204, 588, 578, 16, 70, "Input",
 CellID->196227131],
Cell[16785, 606, 775, 27, 36, "Output",
 CellID->82371302],
Cell[17563, 635, 628, 22, 36, "Output",
 CellID->177376853]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18240, 663, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[18471, 672, 333, 6, 70, "ExampleText",
 CellID->358872975],
Cell[CellGroupData[{
Cell[18829, 682, 3557, 100, 70, "Input",
 CellID->96133454],
Cell[22389, 784, 131, 2, 70, "Print",
 CellID->330019],
Cell[22523, 788, 520, 19, 36, "Output",
 CellID->770906776],
Cell[23046, 809, 160, 5, 36, "Output",
 CellID->83329753],
Cell[CellGroupData[{
Cell[23231, 818, 99, 2, 70, "Print",
 CellID->306927342],
Cell[23333, 822, 136, 2, 70, "Print",
 CellID->527025003]
}, Open  ]],
Cell[23484, 827, 631, 23, 36, "Output",
 CellID->76625266],
Cell[24118, 852, 162, 5, 36, "Output",
 CellID->847731845],
Cell[CellGroupData[{
Cell[24305, 861, 99, 2, 70, "Print",
 CellID->172509633],
Cell[24407, 865, 137, 2, 70, "Print",
 CellID->46637857]
}, Open  ]],
Cell[24559, 870, 744, 27, 36, "Output",
 CellID->547606438],
Cell[25306, 899, 162, 5, 36, "Output",
 CellID->140759670],
Cell[CellGroupData[{
Cell[25493, 908, 99, 2, 70, "Print",
 CellID->167202265],
Cell[25595, 912, 141, 2, 70, "Print",
 CellID->169153268]
}, Open  ]],
Cell[25751, 917, 855, 31, 36, "Output",
 CellID->24170969],
Cell[26609, 950, 161, 5, 36, "Output",
 CellID->186924740],
Cell[CellGroupData[{
Cell[26795, 959, 99, 2, 70, "Print",
 CellID->133434257],
Cell[26897, 963, 144, 2, 70, "Print",
 CellID->225783943]
}, Open  ]],
Cell[27056, 968, 856, 31, 36, "Output",
 CellID->941074617],
Cell[27915, 1001, 161, 5, 36, "Output",
 CellID->55851426]
}, Open  ]],
Cell[28091, 1009, 228, 5, 70, "ExampleText",
 CellID->448198813],
Cell[CellGroupData[{
Cell[28344, 1018, 1009, 30, 70, "Input",
 CellID->244066278],
Cell[29356, 1050, 158, 3, 70, "Print",
 CellID->107487656],
Cell[29517, 1055, 821, 32, 36, "Output",
 CellID->245052368]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30399, 1094, 417, 12, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[30819, 1108, 199, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[31055, 1119, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[31477, 1133, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[31643, 1139, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

