(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27817,        905]
NotebookOptionsPosition[     23206,        750]
NotebookOutlinePosition[     24843,        797]
CellTagsIndexPosition[     24758,        792]
WindowTitle->CM - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:Susyno/guide/Susyno"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["SUSYNO PACLET SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno Tutorial\"\>":>
       Documentation`HelpLookup["paclet:Susyno/tutorial/SusynoTutorial"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Susyno/ref/CM\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["Susyno/ref/CM"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/Susyno/ref/CM.html"]\
, StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", "Susyno/ref/CM", 
             ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["CM", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CM", "[", 
       RowBox[{"\"\<group name\>\"", ",", 
        RowBox[{"family", " ", "index"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]Returns the Cartan matrix of a group, given its name"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->225369098],

Cell[TextData[{
 Cell[BoxData["\"\<group name\>\""], "InlineFormula"],
 " can be ",
 Cell[BoxData["\"\<SU\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<SO\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<SP\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<E\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<F\>\""], "InlineFormula"],
 " or ",
 Cell[BoxData["\"\<G\>\""], "InlineFormula"],
 " (the method is not case sensitive);"
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"family", " ", "index"}]], "InlineFormula"],
 " should be an integer describing the group's index in its family: SU(n) | \
n=2,3,....; SO(n) | n=3,5,6,7,... [SO(4) is not simple]; SP(n) | \
n=2,4,6,8,...; F(n) | n=4 only; G(n) | n=2 only; E(n) | n=6,7,8;"
}], "Notes",
 CellID->42278994],

Cell[TextData[{
 "In Susyno,  a simple Lie group is specified by its Cartan matrix. To avoid \
repeated use of this ",
 Cell[BoxData["CM"], "InlineFormula"],
 " method, the program automatically assigns to some variables with names of \
groups the corresponding Cartan matrix. For example the variable ",
 Cell[BoxData["SU3"], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{"CM", "[", 
   RowBox[{"\"\<SU\>\"", ",", "3"}], "]"}]], "InlineFormula"],
 " which is a 2x2 matrix;"
}], "Notes",
 CellID->139516995],

Cell[TextData[{
 "The complete list of variable that are set by Susyno is: ",
 Cell[BoxData["SU2"], "InlineFormula"],
 ", ",
 Cell[BoxData["SU3"], "InlineFormula"],
 ",..., ",
 Cell[BoxData["SU32"], "InlineFormula"],
 "; ",
 Cell[BoxData["SO3"], "InlineFormula"],
 ", ",
 Cell[BoxData["SO5"], "InlineFormula"],
 ",",
 Cell[BoxData["SO6"], "InlineFormula"],
 ",",
 Cell[BoxData["SO7"], "InlineFormula"],
 ",...,",
 Cell[BoxData["SO32"], "InlineFormula"],
 "; ",
 Cell[BoxData["SP2"], "InlineFormula"],
 ",",
 Cell[BoxData["SP4"], "InlineFormula"],
 ",",
 Cell[BoxData["SP6"], "InlineFormula"],
 ",...,",
 Cell[BoxData["SP32"], "InlineFormula"],
 "; ",
 Cell[BoxData["G2"], "InlineFormula"],
 ",",
 Cell[BoxData["F4"], "InlineFormula"],
 ",",
 Cell[BoxData["E6"], "InlineFormula"],
 ",",
 Cell[BoxData["E7"], "InlineFormula"],
 ",",
 Cell[BoxData["E8"], "InlineFormula"],
 ". Variations such as ",
 Cell[BoxData["Su3"], "InlineFormula"],
 ", ",
 Cell[BoxData["su3"], "InlineFormula"],
 " (but not ",
 Cell[BoxData["sU3"], "InlineFormula"],
 ") have also been assigned;"
}], "Notes",
 CellID->52353557],

Cell["\<\
Rigorously a Cartan matrix defines a complex simple Lie algebra - not a \
group. However, to keep it simple this abuse of terminology is carried out \
here and throughout Susyno (and throughout the field of Particle Physics).\
\>", "Notes",
 CellID->5162272]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->716292288],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->132566411],

Cell["The SU(3) group is defined by its 2x2 Cartan matrix ...", "ExampleText",
 CellID->513681956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CM", "[", 
   RowBox[{"\"\<SU\>\"", ",", "3"}], "]"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->158313393],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztl0sKgDAMRANew43X8BgeoRfw/iutCxei/cw0/UkHCkIy4SlNiIvZNzOJ
yGzPas/1fPSspvj9MDGocksRyVONC70TdIF1Q4nJdClXqBZqsNpnNB5AvRPz
0XKo8hRUk6Yt32WuKDS+tIZYTMHEe1tYgzafBm0+Ddp80qKlpy40sRW/LfeO
kL0uLWpvhLaLm4Aa0f2BXvZQACgzsWUIS9Cu+F/GbY+QkVh9a6kpmN/rBLWW
l1w=
    "], {{0, 28}, {58, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{58, 28},
  PlotRange->{{0, 58}, {0, 28}}]], "Output",
 ImageSize->{62, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->201913899]
}, Open  ]],

Cell["... which is the same as any of these variables:", "ExampleText",
 CellID->205981777],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SU3", "//", "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{"Su3", "//", "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{"su3", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->62374381],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztl0sKgDAMRANew43X8BgeoRfw/iutCxei/cw0/UkHCkIy4SlNiIvZNzOJ
yGzPas/1fPSspvj9MDGocksRyVONC70TdIF1Q4nJdClXqBZqsNpnNB5AvRPz
0XKo8hRUk6Yt32WuKDS+tIZYTMHEe1tYgzafBm0+Ddp80qKlpy40sRW/LfeO
kL0uLWpvhLaLm4Aa0f2BXvZQACgzsWUIS9Cu+F/GbY+QkVh9a6kpmN/rBLWW
l1w=
    "], {{0, 28}, {58, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{58, 28},
  PlotRange->{{0, 58}, {0, 28}}]], "Output",
 ImageSize->{62, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->309495403],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztl0sKgDAMRANew43X8BgeoRfw/iutCxei/cw0/UkHCkIy4SlNiIvZNzOJ
yGzPas/1fPSspvj9MDGocksRyVONC70TdIF1Q4nJdClXqBZqsNpnNB5AvRPz
0XKo8hRUk6Yt32WuKDS+tIZYTMHEe1tYgzafBm0+Ddp80qKlpy40sRW/LfeO
kL0uLWpvhLaLm4Aa0f2BXvZQACgzsWUIS9Cu+F/GbY+QkVh9a6kpmN/rBLWW
l1w=
    "], {{0, 28}, {58, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{58, 28},
  PlotRange->{{0, 58}, {0, 28}}]], "Output",
 ImageSize->{62, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->162355419],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztl0sKgDAMRANew43X8BgeoRfw/iutCxei/cw0/UkHCkIy4SlNiIvZNzOJ
yGzPas/1fPSspvj9MDGocksRyVONC70TdIF1Q4nJdClXqBZqsNpnNB5AvRPz
0XKo8hRUk6Yt32WuKDS+tIZYTMHEe1tYgzafBm0+Ddp80qKlpy40sRW/LfeO
kL0uLWpvhLaLm4Aa0f2BXvZQACgzsWUIS9Cu+F/GbY+QkVh9a6kpmN/rBLWW
l1w=
    "], {{0, 28}, {58, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{58, 28},
  PlotRange->{{0, 58}, {0, 28}}]], "Output",
 ImageSize->{62, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->727686144]
}, Open  ]],

Cell["Other examples:", "ExampleText",
 CellID->432963277],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"CM", "[", 
  RowBox[{"\"\<E\>\"", ",", "7"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"CM", "[", 
  RowBox[{"\"\<so\>\"", ",", "10"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->493559987],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}], ",", "2", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", "2", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", "2", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{460, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->109368014],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}], ",", "2", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{360, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->789713459]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["\<\
SU(2), SP(2), SO(3) are isomorphic. SO(6) and SU(4) are too (interchange row \
1 <-> row 2 and column 1 <-> column 2). SP(4) and SO(5) are also isomorphic \
(interchange row 1<-> row 2 and column 1 <-> column 2):\
\>", "ExampleText",
 CellID->192159632],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "\"\<SU2; SP2; SO3:\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
   RowBox[{"SU2", "//", "MatrixForm"}], ",", "\"\<;\>\"", ",", 
   RowBox[{"SP2", "//", "MatrixForm"}], ",", "\"\<;\>\"", ",", 
   RowBox[{"SO3", "//", "MatrixForm"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<SO6; SU4:\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
   RowBox[{"SO6", "//", "MatrixForm"}], ",", "\"\<;\>\"", ",", 
   RowBox[{"SU4", "//", "MatrixForm"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<SP4; SO5:\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
   RowBox[{"SP4", "//", "MatrixForm"}], ",", "\"\<;\>\"", ",", 
   RowBox[{"SO5", "//", "MatrixForm"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->154510494],

Cell[CellGroupData[{

Cell[BoxData["\<\"SU2; SP2; SO3:\"\>"], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->76776412],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\";\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\";\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{2}}], ";", 
   MatrixForm[{{2}}], ";", 
   MatrixForm[{{2}}]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->273182410],

Cell[BoxData["\<\"SO6; SU4:\"\>"], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->152815402],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", 
        RowBox[{"-", "1"}], 
        RowBox[{"-", "1"}]},
       {
        RowBox[{"-", "1"}], "2", "0"},
       {
        RowBox[{"-", "1"}], "0", "2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\";\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", 
        RowBox[{"-", "1"}], "0"},
       {
        RowBox[{"-", "1"}], "2", 
        RowBox[{"-", "1"}]},
       {"0", 
        RowBox[{"-", "1"}], "2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{2, -1, -1}, {-1, 2, 0}, {-1, 0, 2}}], ";", 
   MatrixForm[{{2, -1, 0}, {-1, 2, -1}, {0, -1, 2}}]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->25085371],

Cell[BoxData["\<\"SP4; SO5:\"\>"], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->205021110],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", 
        RowBox[{"-", "1"}]},
       {
        RowBox[{"-", "2"}], "2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\";\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", 
        RowBox[{"-", "2"}]},
       {
        RowBox[{"-", "1"}], "2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{2, -1}, {-2, 2}}], ";", 
   MatrixForm[{{2, -2}, {-1, 2}}]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->113354683]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
There is no SU(1), SO(4) [this group is not simple] or ABC(100):\
\>", "ExampleText",
 CellID->321780030],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"CM", "[", 
  RowBox[{"\"\<SU\>\"", ",", "1"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"CM", "[", 
  RowBox[{"\"\<SO\>\"", ",", "4"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"CM", "[", 
  RowBox[{"\"\<ABC\>\"", ",", "100"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->72861505],

Cell[BoxData["\<\"Unknown simple lie algebra. Try SU(n) [n>1],SO(n) [n=3 or \
>4],Sp(2n) [n>1] or the exceptionals G(2),F(4),E(6),E(7),E(8).\"\>"], "Output",
 ImageSize->{474, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->393488991],

Cell[BoxData["\<\"Unknown simple lie algebra. Try SU(n) [n>1],SO(n) [n=3 or \
>4],Sp(2n) [n>1] or the exceptionals G(2),F(4),E(6),E(7),E(8).\"\>"], "Output",
 ImageSize->{474, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->773554274],

Cell[BoxData["\<\"Unknown simple lie algebra. Try SU(n) [n>1],SO(n) [n=3 or \
>4],Sp(2n) [n>1] or the exceptionals G(2),F(4),E(6),E(7),E(8).\"\>"], "Output",
 ImageSize->{474, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170991570]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Susyno Tutorial",
 BaseStyle->"Link",
 ButtonData->"paclet:Susyno/tutorial/SusynoTutorial"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 566},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CM - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2011, 2, 8, 15, 59, 31.5625000}", "context" -> "Susyno`", 
    "keywords" -> {
     "SO", "SO(n)", "SON", "SU", "SU(n)", "SUN", "SP", "SP(n)", "SPN", "E", 
      "E6", "E7", "E8", "F4", "G2"}, "index" -> True, "label" -> 
    "Susyno Paclet Symbol", "language" -> "en", "paclet" -> "Susyno", 
    "status" -> "None", "summary" -> 
    "CM[\"group name\", family index] Returns the Cartan matrix of a group, \
given its name", "synonyms" -> {}, "title" -> "CM", "type" -> "Symbol", "uri" -> 
    "Susyno/ref/CM"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
   StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7011, 225, 461, 13, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->716292288]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24615, 785}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[583, 21, 76, 1, 70, "SymbolColorBar"],
Cell[662, 24, 178, 5, 70, "LinkTrail"],
Cell[843, 31, 2273, 53, 70, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3141, 88, 45, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[3189, 91, 463, 13, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3689, 109, 580, 17, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->225369098],
Cell[4272, 128, 473, 16, 70, "Notes",
 CellID->1067943069],
Cell[4748, 146, 328, 7, 70, "Notes",
 CellID->42278994],
Cell[5079, 155, 522, 13, 70, "Notes",
 CellID->139516995],
Cell[5604, 170, 1099, 43, 70, "Notes",
 CellID->52353557],
Cell[6706, 215, 268, 5, 70, "Notes",
 CellID->5162272]
}, Closed]],
Cell[CellGroupData[{
Cell[7011, 225, 461, 13, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->716292288],
Cell[CellGroupData[{
Cell[7497, 242, 148, 5, 70, "ExampleSection",
 CellID->132566411],
Cell[7648, 249, 98, 1, 70, "ExampleText",
 CellID->513681956],
Cell[CellGroupData[{
Cell[7771, 254, 172, 6, 28, "Input",
 CellID->158313393],
Cell[7946, 262, 744, 20, 63, "Output",
 CellID->201913899]
}, Open  ]],
Cell[8705, 285, 91, 1, 70, "ExampleText",
 CellID->205981777],
Cell[CellGroupData[{
Cell[8821, 290, 229, 5, 65, "Input",
 CellID->62374381],
Cell[9053, 297, 744, 20, 63, "Output",
 CellID->309495403],
Cell[9800, 319, 744, 20, 63, "Output",
 CellID->162355419],
Cell[10547, 341, 744, 20, 63, "Output",
 CellID->727686144]
}, Open  ]],
Cell[11306, 364, 58, 1, 70, "ExampleText",
 CellID->432963277],
Cell[CellGroupData[{
Cell[11389, 369, 220, 6, 70, "Input",
 CellID->493559987],
Cell[11612, 377, 1207, 35, 71, "Output",
 CellID->109368014],
Cell[12822, 414, 797, 25, 54, "Output",
 CellID->789713459]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13668, 445, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[13909, 454, 263, 5, 70, "ExampleText",
 CellID->192159632],
Cell[CellGroupData[{
Cell[14197, 463, 917, 24, 70, "Input",
 CellID->154510494],
Cell[CellGroupData[{
Cell[15139, 491, 112, 2, 70, "Print",
 CellID->76776412],
Cell[15254, 495, 2069, 59, 70, "Print",
 CellID->273182410],
Cell[17326, 556, 108, 2, 70, "Print",
 CellID->152815402],
Cell[17437, 560, 1781, 53, 70, "Print",
 CellID->25085371],
Cell[19221, 615, 108, 2, 70, "Print",
 CellID->205021110],
Cell[19332, 619, 1580, 47, 70, "Print",
 CellID->113354683]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20973, 673, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[21207, 682, 115, 3, 70, "ExampleText",
 CellID->321780030],
Cell[CellGroupData[{
Cell[21347, 689, 310, 8, 70, "Input",
 CellID->72861505],
Cell[21660, 699, 288, 6, 54, "Output",
 CellID->393488991],
Cell[21951, 707, 288, 6, 54, "Output",
 CellID->773554274],
Cell[22242, 715, 288, 6, 54, "Output",
 CellID->170991570]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22591, 728, 419, 12, 70, "TutorialsSection",
 CellID->250839057],
Cell[23013, 742, 151, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[23179, 748, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

