(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     17708,        469]
NotebookOptionsPosition[     12700,        360]
NotebookOutlinePosition[     15135,        420]
CellTagsIndexPosition[     15050,        415]
WindowTitle->TransposeTableaux
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "222ecdab-3aac-481c-be27-cea9e8c8da70"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"601b3c5e-0819-41f7-9911-4c8928336264"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "8f3aa399-fe45-4326-a991-f3abdc141d4b"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"58de9a09-df40-440e-b89c-efc9c6595b70"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"TransposePartition\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/TransposePartition"], "\<\"YoungDiagram\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/ref/YoungDiagram"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "428fa674-7d2b-4a19-85cf-f1d233c5e713"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"d1d14e48-9cbc-4fbe-8f35-309ee5ec915a"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/TransposeTableaux\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/TransposeTableaux"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
TransposeTableaux.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$32011], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/TransposeTableaux", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "cf6d01b8-8d2b-433e-83f8-095f6b60a61e"]
    }], "AnchorBar",ExpressionUUID->"fe78db76-7ea4-4f88-9877-7757ff39d43d"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"78ef586b-b90a-4656-b6bf-8470bd09fe4b"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["TransposeTableaux", "ObjectName",ExpressionUUID->
  "b3112f69-4abd-49a9-9ecd-9d330993bbfd"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"a3e14149-87d0-48b1-9370-99f40261a8f6"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "7eb1466c-4707-49f3-a037-7efc1b48334c"]
}], "ObjectNameGrid",ExpressionUUID->"18ccf235-b519-407d-98eb-8d365a2c1bff"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TransposeTableaux", "[", "tableaux", "]"}]], "InlineFormula",
      ExpressionUUID->"f4dcb399-055a-4a11-86ff-a587581f7c66"],
     " \[LineSeparator]Transposes the ",
     Cell[BoxData[
     "tableaux"], "InlineFormula",ExpressionUUID->
      "a2a7bccf-3ff8-4c27-b9e6-7e0387890924"],
     " (rows become columns and vice-versa)"
    }],ExpressionUUID->"7bcb7173-ae45-470d-b692-df7e2acee49f"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"3de5affa-71c4-4d00-9ec0-62715bcdafb0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"613c149e-6931-407e-9ef1-cc09cc25fd36"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"451ecf32-19c0-459b-9eb6-1df14a0a7b14"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"8146783e-d35c-4b8f-ad90-d38f12a1ca47"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->129083057,ExpressionUUID->"ccfd3e05-c924-46cf-ac9f-744b5221447e"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"31721465-65fc-4f95-b099-016948d20e8b"],

Cell[TextData[{
 "If the shape of ",
 Cell[BoxData[
 "tableaux"], "InlineFormula",ExpressionUUID->
  "4d699f13-2134-4b92-862f-4c7e1bbbc1ab"],
 " is given by a partition ",
 Cell[BoxData[
 "p"], "InlineFormula",ExpressionUUID->"4c9a2abb-41f8-4789-a946-73cfc6d545dd"],
 ", then the shape of ",
 Cell[BoxData[
  RowBox[{"TransposeTableaux", "[", "tableaux", "]"}]], "InlineFormula",
  ExpressionUUID->"2e2246e0-6c43-46fe-aa4d-b33002767fe8"],
 " is given by the partition ",
 Cell[BoxData[
  RowBox[{"TransposePartition", "[", "p", "]"}]], "InlineFormula",
  ExpressionUUID->"15bf4e8e-d7c6-4d0b-9690-a8708f2ac528"],
 "."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"498cc84e-a6d7-4841-bc1f-1afe8b51941e"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"1fcdba16-5fcb-4b89-9628-cdf64d93c092"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"1a6b5167-12d0-41b3-b833-d9f22cde94ae"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "f71fa109-faae-4c2f-9a11-4f0dc60d071f"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->311388979,ExpressionUUID->"d8e01368-465a-4744-995f-ecbbcd77e925"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "a25eb84c-a9f6-40c0-aaf0-655c249ac3d8"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->406861396,ExpressionUUID->"98e0aae3-7eb2-42f5-a661-04713a5233fb"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"tableaux", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x6", ",", "x7"}], "}"}], ",", 
    RowBox[{"{", "x8", "}"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"Grid", "[", 
  RowBox[{"tableaux", ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"tableauxT", "=", 
  RowBox[{
  "TransposeTableaux", "[", "tableaux", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Grid", "[", 
  RowBox[{"tableauxT", ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->995373406,ExpressionUUID->"3a7fc05d-5d75-44fa-a776-3634336ba2c9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x6", ",", "x7"}], "}"}], ",", 
   RowBox[{"{", "x8", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->579699304,ExpressionUUID->"f61a3d94-92c5-49c0-9deb-9a9593d853fb"],

Cell[BoxData[
 TagBox[GridBox[{
    {"x1", "x2", "x3", "x4", "x5"},
    {"x6", "x7", "", "", ""},
    {"x8", "", "", "", ""}
   },
   AutoDelete->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellLabel->"Out[1]=",
 CellID->97096740,ExpressionUUID->"71f44e19-94f7-48c3-b13a-3172a6a8e4e4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1", ",", "x6", ",", "x8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x2", ",", "x7"}], "}"}], ",", 
   RowBox[{"{", "x3", "}"}], ",", 
   RowBox[{"{", "x4", "}"}], ",", 
   RowBox[{"{", "x5", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->106285976,ExpressionUUID->"6e5f65d7-950b-4276-926f-e844e468530c"],

Cell[BoxData[
 TagBox[GridBox[{
    {"x1", "x6", "x8"},
    {"x2", "x7", ""},
    {"x3", "", ""},
    {"x4", "", ""},
    {"x5", "", ""}
   },
   AutoDelete->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellLabel->"Out[1]=",
 CellID->388202182,ExpressionUUID->"59c15bbe-1d85-4dcd-9a4e-f0f1a24a2a1f"]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"73afc9a1-2c38-4602-8b14-f8bb06561f1a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"c6359ca8-db07-495b-8890-2e44e0be4e63"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"8a832ccc-c819-4c24-b7a5-1e5c0344cec2"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["TransposePartition"]],
    "paclet:GroupMath/ref/TransposePartition"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"bfb7fee0-69d6-4297-b04d-5dd3030df656"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["YoungDiagram"]],"paclet:GroupMath/ref/YoungDiagram"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"e3f811b4-b8f0-451b-82f0-3d115062277e"]
}], "SeeAlso",
 CellID->929782353,ExpressionUUID->"3b19fac1-9cd2-4230-97b1-bc59c23653a3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"f2679dbf-9479-46bf-a5bb-5f47961000a8"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"ea9271e0-6637-4637-b0c3-88a6e65d4aff"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"40444e04-fc1f-4bae-a5ba-c2ae7168dce2"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"65111c83-f4b0-4a2b-8432-6255825bfd87"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"70961e23-7dfb-46a2-9e58-e9924bcbc690"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TransposeTableaux",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 14, 36.6004240}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "TransposeTableaux[tableaux] Transposes the tableaux (rows become columns \
and vice-versa)", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "TransposeTableaux", "titlemodifier" -> "", "windowtitle" -> 
    "TransposeTableaux", "type" -> "Symbol", "uri" -> 
    "GroupMath/ref/TransposeTableaux", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7703, 200, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"d8e01368-465a-4744-995f-ecbbcd77e925",
   CellTags->"PrimaryExamplesSection",
   CellID->311388979]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14852, 408}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[589, 21, 4221, 95, 53, "AnchorBarGrid",ExpressionUUID->"78ef586b-b90a-4656-b6bf-8470bd09fe4b",
 CellID->1],
Cell[CellGroupData[{
Cell[4835, 120, 402, 9, 52, "ObjectNameGrid",ExpressionUUID->"18ccf235-b519-407d-98eb-8d365a2c1bff"],
Cell[5240, 131, 648, 14, 110, "Usage",ExpressionUUID->"3de5affa-71c4-4d00-9ec0-62715bcdafb0",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5925, 150, 855, 21, 37, "NotesSection",ExpressionUUID->"ccfd3e05-c924-46cf-ac9f-744b5221447e",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->129083057],
Cell[6783, 173, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"31721465-65fc-4f95-b099-016948d20e8b"],
Cell[6872, 175, 705, 18, 70, "Notes",ExpressionUUID->"498cc84e-a6d7-4841-bc1f-1afe8b51941e",
 CellID->1067943069],
Cell[7580, 195, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"1fcdba16-5fcb-4b89-9628-cdf64d93c092"]
}, Closed]],
Cell[CellGroupData[{
Cell[7703, 200, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"d8e01368-465a-4744-995f-ecbbcd77e925",
 CellTags->"PrimaryExamplesSection",
 CellID->311388979],
Cell[CellGroupData[{
Cell[8163, 215, 308, 7, 29, "ExampleSection",ExpressionUUID->"98e0aae3-7eb2-42f5-a661-04713a5233fb",
 CellID->406861396],
Cell[CellGroupData[{
Cell[8496, 226, 739, 19, 75, "Input",ExpressionUUID->"3a7fc05d-5d75-44fa-a776-3634336ba2c9",
 CellID->995373406],
Cell[9238, 247, 341, 9, 35, "Output",ExpressionUUID->"f61a3d94-92c5-49c0-9deb-9a9593d853fb",
 CellID->579699304],
Cell[9582, 258, 409, 11, 72, "Output",ExpressionUUID->"71f44e19-94f7-48c3-b13a-3172a6a8e4e4",
 CellID->97096740],
Cell[9994, 271, 389, 11, 35, "Output",ExpressionUUID->"6e5f65d7-950b-4276-926f-e844e468530c",
 CellID->106285976],
Cell[10386, 284, 422, 13, 104, "Output",ExpressionUUID->"59c15bbe-1d85-4dcd-9a4e-f0f1a24a2a1f",
 CellID->388202182]
}, Open  ]]
}, Open  ]],
Cell[10835, 301, 86, 0, 29, "SectionFooterSpacer",ExpressionUUID->"73afc9a1-2c38-4602-8b14-f8bb06561f1a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10958, 306, 260, 7, 72, "SeeAlsoSection",ExpressionUUID->"8a832ccc-c819-4c24-b7a5-1e5c0344cec2",
 CellID->1255426704],
Cell[11221, 315, 750, 19, 70, "SeeAlso",ExpressionUUID->"3b19fac1-9cd2-4230-97b1-bc59c23653a3",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[12008, 339, 262, 7, 70, "TutorialsSection",ExpressionUUID->"ea9271e0-6637-4637-b0c3-88a6e65d4aff",
 CellID->250839057],
Cell[12273, 348, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"40444e04-fc1f-4bae-a5ba-c2ae7168dce2"],
Cell[12362, 350, 241, 5, 70, "Tutorials",ExpressionUUID->"65111c83-f4b0-4a2b-8432-6255825bfd87",
 CellID->341631938]
}, Open  ]],
Cell[12618, 358, 78, 0, 70, "FooterCell",ExpressionUUID->"70961e23-7dfb-46a2-9e58-e9924bcbc690"]
}
]
*)

(* End of internal cache information *)

