(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15482,        394]
NotebookOptionsPosition[     10853,        292]
NotebookOutlinePosition[     13440,        354]
CellTagsIndexPosition[     13355,        349]
WindowTitle->TransposePartition
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "640a28a7-0c56-4af5-9099-4fb411a2d8d5"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"8897c969-8500-4449-bd82-aabcd027c583"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "7db5c9d8-2244-4194-8faf-92f06ee1397e"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"0911ce91-d739-49fb-8d6d-5e3c64d90309"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"TransposeTableaux\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/TransposeTableaux"], "\<\"YoungDiagram\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/ref/YoungDiagram"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "d9c3e342-81ac-4b98-a402-e0a8fb25be95"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"996d6815-e355-4cb1-bfe3-3ddce066786a"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/TransposePartition\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/TransposePartition"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
TransposePartition.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$31514], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/TransposePartition", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "1c26d3be-f93d-498d-abf0-45aa35ceae61"]
    }], "AnchorBar",ExpressionUUID->"e078ce46-a7f0-4b78-b404-ac862a3c36cf"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"c9398bba-91ef-4806-8b54-56556f3c77b3"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["TransposePartition", "ObjectName",ExpressionUUID->
  "7e5c6ffe-ea55-4447-b31c-590badee4a7c"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"4149742b-948f-40a0-b733-e5f115a3ff6d"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "74b77b5f-7705-49b8-8b1c-fd0a0027a229"]
}], "ObjectNameGrid",ExpressionUUID->"551e8db2-c93c-4fa8-b6f6-d2b683d2682f"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TransposePartition", "[", "partition", "]"}]], "InlineFormula",
      ExpressionUUID->"b8b92210-bbd1-4921-9d8b-84aa513554a8"],
     " \[LineSeparator]Transposes the ",
     Cell[BoxData[
     "partition"], "InlineFormula",ExpressionUUID->
      "a6b4846d-6caa-48f1-bbd6-a1d116a3ede0"],
     ". The result is a partition which has a Young diagram which is obtained \
by reflecting the Young diagram of ",
     Cell[BoxData[
     "partition"], "InlineFormula",ExpressionUUID->
      "40f5027e-3918-4074-aa34-78b020bc4b9f"],
     " along its main diagonal (rows become columns and vice-versa)."
    }],ExpressionUUID->"b27bad24-4ef0-44d1-8741-b12e97cb74ef"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"1ea0e46e-0106-4a34-ad54-00018376edfc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"92930380-a19d-42e2-bf01-ac4d2a1a4a54"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "5a86e737-d643-4511-9366-0b28f07bf753"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->642124241,ExpressionUUID->"2750b90f-595e-40ac-8909-84d15995b6d4"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "b77b6630-cbbb-4699-ad91-23530c73492c"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->311039866,ExpressionUUID->"4ed7ea67-13f6-483d-abf5-2e7978f186d6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"partition", "=", 
  RowBox[{"{", 
   RowBox[{"5", ",", "4", ",", "1"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"YoungDiagram", "[", "partition", "]"}], "\[IndentingNewLine]", 
 RowBox[{"partitionT", "=", 
  RowBox[{"TransposePartition", "[", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "1"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"YoungDiagram", "[", "partitionT", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->267328708,ExpressionUUID->"53143f15-d3e9-4034-bddc-d2a9e819ee9e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "4", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->330910324,ExpressionUUID->"f49e7198-fc00-4ee6-9f12-fc4c3de1ba60"],

Cell[BoxData[
 GraphicsBox[{LineBox[{{0, 0}, {5, 0}}], LineBox[{{0, -1}, {5, -1}}], 
   LineBox[{{0, -2}, {4, -2}}], LineBox[{{0, -3}, {1, -3}}], 
   LineBox[{{0, 0}, {0, -3}}], LineBox[{{1, 0}, {1, -3}}], 
   LineBox[{{2, 0}, {2, -2}}], LineBox[{{3, 0}, {3, -2}}], 
   LineBox[{{4, 0}, {4, -2}}], LineBox[{{5, 0}, {5, -1}}]},
  ImageMargins->0,
  ImagePadding->None,
  ImageSize->100,
  PlotRange->{{0, 5.2}, {-3.2, 0}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->37384878,ExpressionUUID->"64b227a5-2acc-469f-ab18-7f25187c4479"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "2", ",", "2", ",", "2", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->580156178,ExpressionUUID->"13c31d8e-9f60-49fb-ae5b-145c29119aaf"],

Cell[BoxData[
 GraphicsBox[{LineBox[{{0, 0}, {3, 0}}], LineBox[{{0, -1}, {3, -1}}], 
   LineBox[{{0, -2}, {2, -2}}], LineBox[{{0, -3}, {2, -3}}], 
   LineBox[{{0, -4}, {2, -4}}], LineBox[{{0, -5}, {1, -5}}], 
   LineBox[{{0, 0}, {0, -5}}], LineBox[{{1, 0}, {1, -5}}], 
   LineBox[{{2, 0}, {2, -4}}], LineBox[{{3, 0}, {3, -1}}]},
  ImageMargins->0,
  ImagePadding->None,
  ImageSize->60,
  PlotRange->{{0, 3.2}, {-5.2, 0}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->932944950,ExpressionUUID->"4bf26814-a49e-48c5-bbcc-05f42a7c05a8"]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"e0114f21-c542-4f0c-8204-ad2e5e8da993"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"c605ed51-cfb2-4dd0-aa57-f7fa15a0c308"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"1a0d8d78-fd5b-4fb3-9e2d-6966cc4df722"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["TransposeTableaux"]],"paclet:GroupMath/ref/TransposeTableaux"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"540c5c6e-a4e5-4f3a-9a14-d5ee051b81e7"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["YoungDiagram"]],"paclet:GroupMath/ref/YoungDiagram"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"01cb10ab-13a7-4c68-8f7b-ebc7bbdc4a89"]
}], "SeeAlso",
 CellID->929782353,ExpressionUUID->"0fdcf20d-9b6e-4f3b-8a6d-3498e528b19c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"9dd228f6-73a6-49a4-8e9e-e6e4de7c1c0a"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"ba0dbcea-9814-4da3-8ae0-02ce898369ff"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"5eaa8b9b-45a9-4b39-9df6-6c0640bc825a"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"48355901-3e55-44ec-89f1-4d986d6825b1"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"84379243-5155-4c6d-a24c-7d19215cc1e2"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TransposePartition",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 14, 34.4136656}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "TransposePartition[partition] Transposes the partition. The result is a \
partition which has a Young diagram which is obtained by reflecting the Young \
diagram of partition along its main diagonal (rows become columns and \
vice-versa).", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "TransposePartition", "titlemodifier" -> "", "windowtitle" -> 
    "TransposePartition", "type" -> "Symbol", "uri" -> 
    "GroupMath/ref/TransposePartition", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6193, 155, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"2750b90f-595e-40ac-8909-84d15995b6d4",
   CellTags->"PrimaryExamplesSection",
   CellID->642124241]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13157, 342}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[590, 21, 4223, 95, 53, "AnchorBarGrid",ExpressionUUID->"c9398bba-91ef-4806-8b54-56556f3c77b3",
 CellID->1],
Cell[CellGroupData[{
Cell[4838, 120, 403, 9, 52, "ObjectNameGrid",ExpressionUUID->"551e8db2-c93c-4fa8-b6f6-d2b683d2682f"],
Cell[5244, 131, 912, 19, 151, "Usage",ExpressionUUID->"1ea0e46e-0106-4a34-ad54-00018376edfc",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6193, 155, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"2750b90f-595e-40ac-8909-84d15995b6d4",
 CellTags->"PrimaryExamplesSection",
 CellID->642124241],
Cell[CellGroupData[{
Cell[6653, 170, 308, 7, 29, "ExampleSection",ExpressionUUID->"4ed7ea67-13f6-483d-abf5-2e7978f186d6",
 CellID->311039866],
Cell[CellGroupData[{
Cell[6986, 181, 526, 11, 75, "Input",ExpressionUUID->"53143f15-d3e9-4034-bddc-d2a9e819ee9e",
 CellID->267328708],
Cell[7515, 194, 181, 4, 35, "Output",ExpressionUUID->"f49e7198-fc00-4ee6-9f12-fc4c3de1ba60",
 CellID->330910324],
Cell[7699, 200, 530, 11, 83, "Output",ExpressionUUID->"64b227a5-2acc-469f-ab18-7f25187c4479",
 CellID->37384878],
Cell[8232, 213, 201, 4, 35, "Output",ExpressionUUID->"13c31d8e-9f60-49fb-ae5b-145c29119aaf",
 CellID->580156178],
Cell[8436, 219, 532, 11, 119, "Output",ExpressionUUID->"4bf26814-a49e-48c5-bbcc-05f42a7c05a8",
 CellID->932944950]
}, Open  ]]
}, Open  ]],
Cell[8995, 234, 86, 0, 29, "SectionFooterSpacer",ExpressionUUID->"e0114f21-c542-4f0c-8204-ad2e5e8da993"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9118, 239, 260, 7, 72, "SeeAlsoSection",ExpressionUUID->"1a0d8d78-fd5b-4fb3-9e2d-6966cc4df722",
 CellID->1255426704],
Cell[9381, 248, 743, 18, 70, "SeeAlso",ExpressionUUID->"0fdcf20d-9b6e-4f3b-8a6d-3498e528b19c",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[10161, 271, 262, 7, 70, "TutorialsSection",ExpressionUUID->"ba0dbcea-9814-4da3-8ae0-02ce898369ff",
 CellID->250839057],
Cell[10426, 280, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"5eaa8b9b-45a9-4b39-9df6-6c0640bc825a"],
Cell[10515, 282, 241, 5, 70, "Tutorials",ExpressionUUID->"48355901-3e55-44ec-89f1-4d986d6825b1",
 CellID->341631938]
}, Open  ]],
Cell[10771, 290, 78, 0, 70, "FooterCell",ExpressionUUID->"84379243-5155-4c6d-a24c-7d19215cc1e2"]
}
]
*)

(* End of internal cache information *)

