(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    243560,       5989]
NotebookOptionsPosition[    228204,       5685]
NotebookOutlinePosition[    232051,       5767]
CellTagsIndexPosition[    231927,       5761]
WindowTitle->SubgroupCoefficients
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "3205f5ca-7448-458e-b129-28504a4fa3c2"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"bbd660fa-c0d7-4ce7-b538-f19ae0d445b7"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "3a52400d-d7ba-4934-81c7-687eb13ad797"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"a2ff5d83-7ae1-4e91-8bb8-de1225bc6074"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"DecomposeRep\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/DecomposeRep"], \
"\<\"RegularSubgroupProjectionMatrix\"\>":>Documentation`HelpLookup[
       "paclet:GroupMath/ref/RegularSubgroupProjectionMatrix"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "b7b70e93-c7a3-440c-99a2-f0fe09441a25"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"4d97d2f7-f741-4928-8412-dad7d8dea3f6"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/SubgroupCoefficients\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/SubgroupCoefficients"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
SubgroupCoefficients.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$30982], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/SubgroupCoefficients", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "cd11c92e-d2fb-477f-970f-5381effa460f"]
    }], "AnchorBar",ExpressionUUID->"159aecf5-43fa-48e7-9491-debc9aade269"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"c21d28cf-8f05-4ab9-8eb5-5a2710168bc0"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["SubgroupCoefficients", "ObjectName",ExpressionUUID->
  "d4877647-977f-43ec-ae83-612eaf267313"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"021a483c-6923-4175-a00e-d904c5eb9703"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "eb5d3a8a-e153-4479-8a07-7f9cfdb79f8f"]
}], "ObjectNameGrid",ExpressionUUID->"fac35d31-2316-4db2-b7d3-7cca951d84b8"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SubgroupCoefficients", "[", 
       RowBox[{
       "group", ",", " ", "representationsList", ",", "subgroup", ",", 
        "breakingInfo"}], "]"}]], "InlineFormula",ExpressionUUID->
      "90a1d512-80d5-401e-8bf5-82cad4e6c8f8"],
     " \[LineSeparator]Calculates Georgi\[Dash]Jarlskog-like relations. For \
some ",
     Cell[BoxData[
     "subgroup"], "InlineFormula",ExpressionUUID->
      "db5ab5d1-9d88-4d6e-94b4-a73fc98c7d39"],
     " of ",
     Cell[BoxData[
     "group"], "InlineFormula",ExpressionUUID->
      "25d1ec5a-00ae-456e-806d-216e5f29d240"],
     ", and for the product of representations of ",
     Cell[BoxData[
     "group"], "InlineFormula",ExpressionUUID->
      "0796f301-7335-4ed1-a247-3b821b080934"],
     " in ",
     Cell[BoxData[
     "representationsList"], "InlineFormula",ExpressionUUID->
      "675074f3-e245-4467-8014-63d5cb4a4714"],
     ", this functions calculates the relation amongst the \
invariants/Clebsch-Gordon coefficients of ",
     Cell[BoxData[
     "subgroup"], "InlineFormula",ExpressionUUID->
      "b6b3210d-aa7d-4efd-b1ba-df8259aec13f"],
     " imposed by the remaining symmetry generators of ",
     Cell[BoxData[
     "group"], "InlineFormula",ExpressionUUID->
      "bc28a3c1-ee17-421a-8ee1-48d4fcc96e3d"],
     " which are not part of ",
     Cell[BoxData[
     "subgroup"], "InlineFormula",ExpressionUUID->
      "f8b46d2e-dcff-4fd9-a982-211eb8c4a986"],
     ".\[LineSeparator]\[LineSeparator]Quick example: the 16 and 10 of SO(10) \
form the a trilinear invariant (16 x 16 x 10). Under the subgroup ",
     Cell[BoxData[
      SubscriptBox["G", "SM"]], "InlineFormula",ExpressionUUID->
      "b69742ee-5d5b-42a7-9fb7-994edfba08b6"],
     "=SU(3)xSU(2)xU(1) of SO(10), these representations break into various \
irreducible representations of  ",
     Cell[BoxData[
      SubscriptBox["G", "SM"]], "InlineFormula",ExpressionUUID->
      "4fba3eee-30ac-40d9-8b27-af5b8e37545f"],
     ", and a total of 17 terms invariant only under  ",
     Cell[BoxData[
      SubscriptBox["G", "SM"]], "InlineFormula",ExpressionUUID->
      "4667038c-91f9-483a-8cb4-d9ee05f63d98"],
     " can be written with these  ",
     Cell[BoxData[
      SubscriptBox["G", "SM"]], "InlineFormula",ExpressionUUID->
      "d5ca7f81-4c5a-4466-80ab-3d1c51fc7c58"],
     "-representations. Since there is only one invariant under the full \
group, SO(10), the coefficients of these 17 ",
     Cell[BoxData[
      SubscriptBox["G", "SM"]], "InlineFormula",ExpressionUUID->
      "38b1e280-abea-4aec-84ee-0d4f8669707d"],
     "-invariant terms must be related in an SO(10)-symmetric scenario. ",
     Cell[BoxData[
     "SubgroupCoefficients"], "InlineFormula",ExpressionUUID->
      "47a90386-ea58-4a1d-80ab-87252401c062"],
     " returns such relations."
    }],ExpressionUUID->"5b22a89c-327e-4ed5-9ca3-a86cbe46d262"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"2d8808d9-eebc-4345-a46d-95c1dbdf1fd3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"cb0029c2-5d61-43d4-b5d6-8a3e3b0dea19"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"4829a22e-8edc-41f7-9203-882be4f23995"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"d553698a-01b8-4ec9-8fad-df2ccba77de2"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->133061962,ExpressionUUID->"e2caf555-d1bb-4477-b901-743343b972a4"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"c70e9c26-d1b9-49e9-b704-a8a2979e903f"],

Cell[TextData[{
 "Quick explanation: This function calculates Georgi\[Dash]Jarlskog-like \
relations for a group (e.g. SO(10)) breaking into one of its regular \
subgroups (e.g. SU(3)xSU(2)xU(1)) and for an arbitrary product of \
representations of the group (e.g. 16 x 16 x 10 or 16 x 16 x 120). The only \
restriction is that ",
 StyleBox["the subgroup must be regular",
  FontSlant->"Italic"],
 " (it cannot be special)."
}], "Notes",
 CellID->46206203,ExpressionUUID->"d4c2ddad-322d-4b68-8ae7-4f75d156becb"],

Cell["\<\
In the following, the calculations performed by this complicated function \
will be described in detail.\
\>", "Notes",
 CellID->182247527,ExpressionUUID->"0ef5b04e-400c-4857-a851-046c050affbd"],

Cell[TextData[{
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "18d78f55-b213-4972-ba96-998c7203d193"],
 " and ",
 Cell[BoxData[
 "subgroup"], "InlineFormula",ExpressionUUID->
  "8ae10318-16e9-49a8-bfc9-2f54dfcfb64f"],
 " must be lists of simple/U(1) factor groups:   ",
 Cell[BoxData[
  RowBox[{"group", "=", 
   RowBox[{"{", 
    RowBox[{"G1", ",", "G2", ",", "..."}], "}"}]}]], "InlineFormula",
  ExpressionUUID->"02ec33c7-1a01-435e-883f-ed26347f5c60"],
 ",  ",
 Cell[BoxData[
  RowBox[{"subgroup", "=", 
   RowBox[{"{", 
    RowBox[{"H1", ",", "H2", ",", "..."}], "}"}]}]], "InlineFormula",
  ExpressionUUID->"f329bfe6-c673-4c37-8978-0e6e3e808d24"],
 "."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"60511c9e-97d2-4258-af3e-381165c884c7"],

Cell[TextData[{
 Cell[BoxData[
 "representationsList"], "InlineFormula",ExpressionUUID->
  "fb001381-2fe1-48b1-9b34-34b4206fdc51"],
 " must be a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"R1", ",", "R2", ",", "..."}], "}"}]], "InlineFormula",
  ExpressionUUID->"5c209662-b6c9-4a89-bb2a-132e2df0a30e"],
 " of representations of ",
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "919e2571-4ec7-4a06-94b7-bbc93ce83d66"],
 ", such that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"R1", " ", "x", " ", "R2", " ", "x"}], " ", "..."}]], 
  "InlineFormula",ExpressionUUID->"3b7b40c2-fb9a-4de9-a9dc-ba3f122949eb"],
 " contains one or more  ",
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "bcb5656a-2362-4934-be87-0c58c0c4a2b1"],
 " singlets. It is also possible to use the simplified input format for \
representations (see the ",
 ButtonBox["GroupMath tutorial",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/tutorial/GroupMathDoc"],
 " page)."
}], "Notes",
 CellID->52399537,ExpressionUUID->"00c335f2-327f-47e8-8f2c-d74cbe2cace9"],

Cell[TextData[{
 Cell[BoxData[
 "breakingInformation"], "InlineFormula",ExpressionUUID->
  "7287cb06-6b2a-4b0c-90f8-5c68db89886b"],
 " should contain the information about which dots of the Dynkin diagram of ",
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "5291a54a-6758-4a3b-ada0-bd9b64789c24"],
 " are to be dropped and if the diagram is to be extended or not. It is the \
same as in the function ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["RegularSubgroupProjectionMatrix"]],
    "paclet:GroupMath/ref/RegularSubgroupProjectionMatrix"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "6faad7bc-2f6f-4f23-af17-e60d179e3ad4"],
 " \[LongDash] please see the examples contained in this link.  "
}], "Notes",
 CellID->784021019,ExpressionUUID->"bcbcb3c7-d2da-4dd9-b523-c827a9264fbd"],

Cell[TextData[{
 "The output of this function is complicated and is better explained by \
example \[LongDash] see below. However, the general picture is the following.\
\[LineSeparator]\[LineSeparator]For each representation R of ",
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "16b9b650-b526-4933-b3bd-62e22a6da3f1"],
 ", the representation matrices are known in an explicit basis (with ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["RepMatrices"]],"paclet:GroupMath/ref/RepMatrices"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "7bff606a-7e97-45e0-83f5-99656fe29984"],
 "). We can call them ",
 Cell[BoxData[
  SuperscriptBox["T", "a"]], "InlineFormula",ExpressionUUID->
  "348dfeae-a3d9-42ae-90c4-1c187e68eba0"],
 "(R). The decomposition of R into irreducible representations ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R", "'"}], ")"}], "i"]], "InlineFormula",ExpressionUUID->
  "29324e08-282a-4a70-8caa-aadd81e14fc9"],
 " of ",
 Cell[BoxData[
 "subgroup"], "InlineFormula",ExpressionUUID->
  "97e1c8b4-7711-4e51-ad94-1604a0ac2317"],
 " is also know (with ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["DecomposeRep"]],"paclet:GroupMath/ref/DecomposeRep"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "569f9473-8cbe-41b3-8a0f-cfd6a8d953de"],
 ") and the explicit basis for these matrices can be obtained (again, with ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["RepMatrices"]],"paclet:GroupMath/ref/RepMatrices"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "5d35be16-05a3-4f20-815f-1f7fba60f79b"],
 "): we get the  ",
 Cell[BoxData[
  SuperscriptBox["T", "b"]], "InlineFormula",ExpressionUUID->
  "9d727bfd-f0d4-4e51-b9e0-85fc6e198a7d"],
 "(",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R", "'"}], ")"}], "i"]], "InlineFormula",ExpressionUUID->
  "9f53d43a-692f-4794-b45c-ab6e49c23008"],
 ") matrices. We may place these  ",
 Cell[BoxData[
  SuperscriptBox["T", "b"]], "InlineFormula",ExpressionUUID->
  "7699876b-9b6a-4c48-a398-b62c3bc35614"],
 "(",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R", "'"}], ")"}], "1"]], "InlineFormula",ExpressionUUID->
  "9664c8d0-675c-4e66-b4e2-4f878c56ed5a"],
 "), ",
 Cell[BoxData[
  SuperscriptBox["T", "b"]], "InlineFormula",ExpressionUUID->
  "e09ed5bc-6f49-4eaa-b96a-fc0bc26e3558"],
 "(",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R", "'"}], ")"}], "2"]], "InlineFormula",ExpressionUUID->
  "e2414123-3ca5-4c88-b7bc-da45b0d67106"],
 "), ... matrices as diagonal blocks of matrices ",
 Cell[BoxData[
  SuperscriptBox["T", "b"]], "InlineFormula",ExpressionUUID->
  "fa0562ce-a40c-4a62-91fc-ad0b2b135c0a"],
 "(R') which have the same dimensions as the ",
 Cell[BoxData[
  SuperscriptBox["T", "a"]], "InlineFormula",ExpressionUUID->
  "1fd8aafe-319b-40d6-aab3-3bada7a6a471"],
 "(R).\[LineSeparator]\[LineSeparator]How are the matrices  ",
 Cell[BoxData[
  SuperscriptBox["T", "a"]], "InlineFormula",ExpressionUUID->
  "d4c9b17f-4966-434f-861f-c2d801198c33"],
 "(R) related to  ",
 Cell[BoxData[
  SuperscriptBox["T", "b"]], "InlineFormula",ExpressionUUID->
  "459efeaa-310b-422e-b929-c1a403cb521f"],
 "(R')? We need to a) take a linear combination ",
 Cell[BoxData[
  SubscriptBox["c", "ba"]], "InlineFormula",ExpressionUUID->
  "44244e14-a5da-464a-a268-181aa251b65c"],
 " of the  ",
 Cell[BoxData[
  SuperscriptBox["T", "a"]], "InlineFormula",ExpressionUUID->
  "0acbfb0d-ba12-44d1-8398-8bfacc50c814"],
 "(R) matrices (the same for any representation R) and b) change the basis of \
the  ",
 Cell[BoxData[
  SuperscriptBox["T", "a"]], "InlineFormula",ExpressionUUID->
  "f99c2737-37fd-4762-b9eb-95eddf8bc3b1"],
 "(R) with a unitary matrix ",
 Cell[BoxData[
  RowBox[{"B", 
   RowBox[{"(", "R", ")"}]}]], "InlineFormula",ExpressionUUID->
  "c73b8571-f0d1-46a9-b765-c74d01297ef8"],
 " such that these matrices become block diagonal, with the blocks given by \
the ",
 Cell[BoxData[
  SuperscriptBox["T", "b"]], "InlineFormula",ExpressionUUID->
  "6cf02f9f-c137-4d49-896e-248329b9b3cb"],
 "(",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R", "'"}], ")"}], "i"]], "InlineFormula",ExpressionUUID->
  "724f0a00-0c13-411b-851e-0373b2b1c6d6"],
 "). In other words,\[LineSeparator]\[LineSeparator]",
 Cell[BoxData[
  SuperscriptBox["T", "b"]], "InlineFormula",ExpressionUUID->
  "19eea193-211d-47a4-a789-44b674bca56f"],
 "(",
 Cell[BoxData[
  RowBox[{"R", "'"}]], "InlineFormula",ExpressionUUID->
  "bf4f1eea-2c3b-4fdc-a03c-03b0474d5b87"],
 ")=",
 Cell[BoxData[
  SubscriptBox["c", "ba"]], "InlineFormula",ExpressionUUID->
  "b84f6c1c-3d7c-484e-b8a9-5a6b79ed0f4b"],
 " ",
 Cell[BoxData[
  RowBox[{"B", 
   SuperscriptBox[
    RowBox[{"(", "R", ")"}], "\[Dagger]"]}]], "InlineFormula",ExpressionUUID->
  "4e202d88-2ed5-4835-99da-1f774b58c97e"],
 ".",
 Cell[BoxData[
  SuperscriptBox["T", "a"]], "InlineFormula",ExpressionUUID->
  "a76d7b2d-9e8c-4d7e-9128-19efb4fecf11"],
 "(R).B(R)  (sum over b).\[LineSeparator]\[LineSeparator]GroupMath can \
calculate both ",
 Cell[BoxData[
  SubscriptBox["c", "ba"]], "InlineFormula",ExpressionUUID->
  "29f47967-29ef-4d15-82a3-53759a123273"],
 " for any regular group embedding, and the matrix B(R) for any \
representation. As such, the program is aware of how the sub-representations \
are exactly/explicitly embedded in each representation of ",
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "1943e94c-4120-4909-b55e-6cd6db3c6067"],
 ". \[LineSeparator]\[LineSeparator]Thus, given a list of representations R1, \
R2, ... of  ",
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "6b44905c-da6c-419a-b9dd-9292ca929a5a"],
 " such that R1 x R2 x ... contains group invariants, it can compute all the ",
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "7957a628-02d3-487d-98e3-7740e8f93699"],
 " invariants/Clebsch-Gordon coefficients ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox["c", "a"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula",ExpressionUUID->
  "cac73318-1c29-4bc0-95ac-8fdcbf6a362d"],
 " such that\[LineSeparator]\[LineSeparator] ",
 Cell[BoxData[
  RowBox[{"Inv", "=", 
   SubscriptBox[
    SuperscriptBox["c", "a"], 
    RowBox[{"i1", ",", "i2", ",", "..."}]]}]], "InlineFormula",ExpressionUUID->
  "43af2568-a70a-4e05-b50c-9359df01a759"],
 " R1[i1] R2[i2] ... (sum over the components i1, i2,...)\[LineSeparator]\
\[LineSeparator]are ",
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "b7b2bc2b-26f3-42f8-bc39-892e4e418250"],
 "-invariants. Here, Rj[i] refers to the component i of the \
field/representation Rj. Also, because there might be more than one \
invariant, the index a=1,2,... was added.\[LineSeparator]\[LineSeparator]But \
GroupMath can also calculate the ",
 Cell[BoxData[
 "subgroup"], "InlineFormula",ExpressionUUID->
  "2fb3c01e-b939-44e7-86dd-93bdc8c7c44f"],
 " invariants/Clebsch-Gordon coefficients of the form \[LineSeparator]\
\[LineSeparator] ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox[
    RowBox[{"c", "'"}], "b"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula",ExpressionUUID->
  "fd789749-3c5b-4732-a019-8138750a4545"],
 "(x1,x2,...) ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R1", "'"}], ")"}], "x1"]], "InlineFormula",ExpressionUUID->
  "eb0f5c81-6b3b-4d77-b8dc-3f3d5b35e68b"],
 "[i1] ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R2", "'"}], ")"}], "x2"]], "InlineFormula",ExpressionUUID->
  "2583ce9b-143b-4f5d-b1ca-a8db9f1846e4"],
 "[i1]  ... (sum over the components i1, i2,...)\[LineSeparator]\
\[LineSeparator]in the basis where the fields ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"Ri", "'"}], ")"}], "xi"]], "InlineFormula",ExpressionUUID->
  "9949504e-cb62-4d89-9b34-df7c443721df"],
 " are rotated by the ",
 Cell[BoxData[
  RowBox[{"B", 
   SuperscriptBox[
    RowBox[{"(", "Ri", ")"}], "\[Dagger]"]}]], "InlineFormula",ExpressionUUID->
  "1283e90b-8033-49a8-b28d-74e7859ad3ba"],
 " matrices (as opposed to rotating the Ri by  ",
 Cell[BoxData[
  RowBox[{"B", 
   RowBox[{"(", "Ri", ")"}]}]], "InlineFormula",ExpressionUUID->
  "aa25f519-c385-4078-8e12-9fd02378e52f"],
 "). Note that we get in general many of these invariants ",
 Cell[BoxData[
  RowBox[{"c", "'"}]], "InlineFormula",ExpressionUUID->
  "c13aa0d4-6eee-45d5-a239-d0ec31f89a2e"],
 " because we have to consider all combinations of the x1, x2, ... which will \
form ",
 Cell[BoxData[
 "subgroup"], "InlineFormula",ExpressionUUID->
  "156f09de-b526-459b-905c-e8cce3e7f1bd"],
 " invariants (in other words, the representations of ",
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "0e436dd5-7279-4395-9fe4-0641943e181a"],
 " break into many pieces/representations of ",
 Cell[BoxData[
 "subgroup"], "InlineFormula",ExpressionUUID->
  "9521e5f6-9393-43dc-a2c6-0cdb92e2f7d4"],
 ", and we have to look for all invariants formed from these pieces).\
\[LineSeparator]\[LineSeparator]So, for each  ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox["c", "a"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula",ExpressionUUID->
  "7f0d3cdd-8ff5-41fc-82fc-48be2af78072"],
 " (symmetric under ",
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "2e01f610-3479-4d59-a68c-119ce4294b70"],
 "), there are many  ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox[
    RowBox[{"c", "'"}], "b"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula",ExpressionUUID->
  "a018976c-b90b-44a7-8035-2bead43d218b"],
 "(x1,x2,...)  (symmetric under just ",
 Cell[BoxData[
 "subgroup"], "InlineFormula",ExpressionUUID->
  "c12d8aaa-925a-49fe-aebe-d37de098c57c"],
 "). Clearly the coefficients  ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox["c", "a"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula",ExpressionUUID->
  "ce39842d-5efa-478e-a9d8-5220aee77234"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox[
    RowBox[{"c", "'"}], "b"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula",ExpressionUUID->
  "c1350948-94e6-4de3-982f-10674062bc05"],
 "(x1,x2,...) are related by the group generators of ",
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "7f601bb6-f7f0-4178-83a6-5ece257bf088"],
 " which are not part of  ",
 Cell[BoxData[
 "subgroup"], "InlineFormula",ExpressionUUID->
  "e1191d72-8f04-4a0f-89d3-2cf56a88c7b0"],
 ", and so we get:\[LineSeparator]\[LineSeparator]",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox["c", "a"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula",ExpressionUUID->
  "1dec14b8-f774-4adb-bfc9-ca97f37eb81f"],
 "=",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox["k", "ab"], 
   RowBox[{
    RowBox[{"x1", " ", "x2"}], " ", "..."}]]], "InlineFormula",ExpressionUUID->
  "78f9b328-89de-45b1-9638-9fe6c505e6cc"],
 " ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox[
    RowBox[{"c", "'"}], "b"], 
   RowBox[{"i1", ",", "i2", ",", "..."}]]], "InlineFormula",ExpressionUUID->
  "99d5e6cb-5a5f-4eb1-8781-8af067ab141a"],
 "(x1,x2,...) (sum over x1,x2...)\[LineSeparator]\[LineSeparator]for some \
embedding coefficients ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox["k", "ab"], 
   RowBox[{
    RowBox[{"x1", " ", "x2"}], " ", "..."}]]], "InlineFormula",ExpressionUUID->
  "7e340a50-8275-45a8-bc21-702558b28781"],
 ". These numbers ",
 Cell[BoxData[
  SubscriptBox[
   SuperscriptBox["k", "ab"], 
   RowBox[{
    RowBox[{"x1", " ", "x2"}], " ", "..."}]]], "InlineFormula",ExpressionUUID->
  "42bfb6ec-4b12-44fe-8b4a-b0e1159b2f10"],
 " are the main output of this function ",
 Cell[BoxData[
 "SubgroupCoefficients"], "InlineFormula",ExpressionUUID->
  "84de57d7-cc89-4f2d-a548-cdd923da0110"],
 ". Indeed the output of the function is of the form\[LineSeparator]\
\[LineSeparator]{{",
 Cell[BoxData[
 "Inv"], "InlineFormula",ExpressionUUID->
  "383c6886-a2b7-4d6a-bf64-44fbf7cfcc0a"],
 ",{",
 Cell[BoxData[
  RowBox[{"B", 
   RowBox[{"(", "R1", ")"}]}]], "InlineFormula",ExpressionUUID->
  "b09fc160-247a-4d45-a631-40aea3028772"],
 ",",
 Cell[BoxData[
  RowBox[{"B", 
   RowBox[{"(", "R2", ")"}]}]], "InlineFormula",ExpressionUUID->
  "11d36ed3-022f-4eb2-8359-ff00cd385364"],
 ",...}},{group,projectionMatrix,{<list of ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R1", "'"}], ")"}], "i"]], "InlineFormula",ExpressionUUID->
  "4a3a286a-ff79-4fb3-99c8-1c561d36dfd8"],
 " in R1>, <list of ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"R2", "'"}], ")"}], "i"]], "InlineFormula",ExpressionUUID->
  "2aebaf94-c4a2-4a81-8d4b-b0962bc89806"],
 " in R2>, ...},<list with the information of which combinations of ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"Rj", "'"}], ")"}], "i"]], "InlineFormula",ExpressionUUID->
  "963db7ec-0cf0-4f05-90d8-b98cef10c57d"],
 " form ",
 Cell[BoxData[
 "subgroup"], "InlineFormula",ExpressionUUID->
  "2738d6f3-bf4d-477f-9e0f-c287f95bbdb8"],
 " invariants>, ",
 Cell[BoxData[
  SubscriptBox["k", 
   RowBox[{"ij", "..."}]]], "InlineFormula",ExpressionUUID->
  "92c7e77c-a309-4bff-a091-58302939f9bf"],
 "}."
}], "Notes",
 CellID->45496372,ExpressionUUID->"59cb1323-d5c0-42d4-b5b1-52766f2dded9"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"9f1ea6b1-bf8a-4e74-b221-4f9f71b65934"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"14c5f8c0-ba42-44eb-884f-6f6869b1e86a"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "49817d41-f9bc-4715-a6b1-5ff923152fab"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->499396244,ExpressionUUID->"3180d622-6e53-45e9-97ae-9b414fb5c275"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "f73d749b-4ebe-4b23-b9ee-1afde9065f97"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->589262989,ExpressionUUID->"cb89b141-f67e-4a9b-b76a-99a1234f428f"],

Cell["\<\
Consider how the product 16 x 16 x 10 in SO(10) looks under the subgroup \
SU(3)xSU(2)xU(1). Dynkin coefficients can be used for the input \
representations, but in this example the simplified input format will be used.\
\>", "ExampleText",
 CellID->19615827,ExpressionUUID->"43a21be8-deee-4407-aa07-c71f62ff25a4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"breakInfo", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"{", "4", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "6"}]}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result", "=", 
   RowBox[{"SubgroupCoefficients", "[", 
    RowBox[{"SO10", ",", 
     RowBox[{"{", 
      RowBox[{"16", ",", "16", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"SU3", ",", "SU2", ",", "U1"}], "}"}], ",", "breakInfo"}], 
    "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->85442412,ExpressionUUID->"3f826b1f-0c8e-458f-889d-74ad7f16fa5a"],

Cell[TextData[{
 "The output was saved to the variable ",
 Cell[BoxData[
 "result"], "InlineFormula",ExpressionUUID->
  "e8db0875-e3fa-48a3-9fe9-2676247df252"],
 ". Let us look at its important parts:  ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]], "InlineFormula",ExpressionUUID->
  "a09d9a63-a36b-47cf-b500-4ace4fe1d343"],
 " contains just the invariants/Clebsch-Gordon coefficients (one in this \
case) of 16 x 16 x 10 in SO(10), exactly as given by the ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["Invariants"]],"paclet:GroupMath/ref/Invariants"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "0072885d-54fa-4424-810e-0e3ae7369d05"],
 " function:"
}], "ExampleText",
 CellID->147360266,ExpressionUUID->"8c7df7c4-4359-4756-bf72-ed5d84b4dfb2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->276648439,ExpressionUUID->"e8418c16-468d-4abf-9f21-62565e36551d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["SparseArray",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    TemplateBox[{PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEBitmaps", "SquarePlusIconMedium"]], 
              ButtonFunction :> (Typeset`open$$ = True), Appearance -> None, 
              Evaluator -> Automatic, Method -> "Preemptive"], 
             Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 3.5 CurrentValue["FontCapHeight"]/
                AbsoluteCurrentValue[Magnification]}]], 
            GraphicsBox[
             RasterBox[
             SparseArray[
              Automatic, {10, 10}, 0.93, {
               1, {{0, 1, 1, 4, 4, 5, 6, 6, 8, 10, 13}, {{4}, {6}, {7}, {
                 10}, {5}, {9}, {3}, {8}, {5}, {7}, {2}, {3}, {7}}}, {0., 0., 
                0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}}], {{0, 0}, {10, 
              10}}, {0, 1}], Frame -> False, Axes -> False, AspectRatio -> 1, 
             ImageSize -> 
             Dynamic[{
               Automatic, 3.5 CurrentValue["FontCapHeight"]/
                AbsoluteCurrentValue[Magnification]}], Frame -> True, 
             FrameTicks -> None, FrameStyle -> Directive[
               Opacity[0.5], 
               Thickness[Tiny], 
               RGBColor[0.368417, 0.506779, 0.709798]], 
             FrameLabel -> {None, None}, 
             FrameTicks -> {{None, None}, {None, None}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Specified elements: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["80", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Dimensions: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"1", ",", "16", ",", "16", ",", "10"}], "}"}], 
                  "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEBitmaps", "SquareMinusIconMedium"]], 
              ButtonFunction :> (Typeset`open$$ = False), Appearance -> None, 
              Evaluator -> Automatic, Method -> "Preemptive"], 
             Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 3.5 CurrentValue["FontCapHeight"]/
                AbsoluteCurrentValue[Magnification]}]], 
            GraphicsBox[
             RasterBox[
             SparseArray[
              Automatic, {10, 10}, 0.93, {
               1, {{0, 1, 1, 4, 4, 5, 6, 6, 8, 10, 13}, {{4}, {6}, {7}, {
                 10}, {5}, {9}, {3}, {8}, {5}, {7}, {2}, {3}, {7}}}, {0., 0., 
                0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}}], {{0, 0}, {10, 
              10}}, {0, 1}], Frame -> False, Axes -> False, AspectRatio -> 1, 
             ImageSize -> 
             Dynamic[{
               Automatic, 3.5 CurrentValue["FontCapHeight"]/
                AbsoluteCurrentValue[Magnification]}], Frame -> True, 
             FrameTicks -> None, FrameStyle -> Directive[
               Opacity[0.5], 
               Thickness[Tiny], 
               RGBColor[0.368417, 0.506779, 0.709798]], 
             FrameLabel -> {None, None}, 
             FrameTicks -> {{None, None}, {None, None}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Specified elements: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["80", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Dimensions: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"1", ",", "16", ",", "16", ",", "10"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Default: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["0", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Density: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["0.03125`", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Elements:\"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"\"", "SummaryItem"]}]}, {
               TagBox[
                TagBox[
                 GridBox[{{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "8", ",", "1"}], "}"}], 
                    "\[Rule]", 
                    StyleBox[
                    PaneBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["2", "5"], ")"}], 
                    RowBox[{"1", "/", "4"}]], ContentPadding -> False, 
                    FrameMargins -> 0, StripOnInput -> True, BaselinePosition -> 
                    Baseline, ImageSize -> {{1, 300}, Automatic}], 
                    LineBreakWithin -> False]}]}, {
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "12", ",", "2"}], "}"}], 
                    "\[Rule]", 
                    StyleBox[
                    PaneBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["2", "5"], ")"}], 
                    RowBox[{"1", "/", "4"}]], ContentPadding -> False, 
                    FrameMargins -> 0, StripOnInput -> True, BaselinePosition -> 
                    Baseline, ImageSize -> {{1, 300}, Automatic}], 
                    LineBreakWithin -> False]}]}, {
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "14", ",", "3"}], "}"}], 
                    "\[Rule]", 
                    StyleBox[
                    PaneBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["2", "5"], ")"}], 
                    RowBox[{"1", "/", "4"}]], ContentPadding -> False, 
                    FrameMargins -> 0, StripOnInput -> True, BaselinePosition -> 
                    Baseline, ImageSize -> {{1, 300}, Automatic}], 
                    LineBreakWithin -> False]}]}, {
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "15", ",", "4"}], "}"}], 
                    "\[Rule]", 
                    StyleBox[
                    PaneBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["2", "5"], ")"}], 
                    RowBox[{"1", "/", "4"}]], ContentPadding -> False, 
                    FrameMargins -> 0, StripOnInput -> True, BaselinePosition -> 
                    Baseline, ImageSize -> {{1, 300}, Automatic}], 
                    LineBreakWithin -> False]}]}, {
                    ItemBox[
                    "\"\[VerticalEllipsis]\"", Alignment -> Center, 
                    StripOnInput -> False]}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                 "Column"], "SummaryItem"]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  SparseArray[
  Automatic, {1, 16, 16, 10}, 0, {
   1, {{0, 80}, {{1, 8, 1}, {1, 12, 2}, {1, 14, 3}, {1, 15, 4}, {1, 16, 5}, {
     2, 7, 1}, {2, 11, 2}, {2, 13, 3}, {2, 15, 6}, {2, 16, 7}, {3, 6, 1}, {3, 
     10, 2}, {3, 13, 4}, {3, 14, 6}, {3, 16, 8}, {4, 5, 1}, {4, 9, 2}, {4, 13,
      5}, {4, 14, 7}, {4, 15, 8}, {5, 4, 1}, {5, 10, 3}, {5, 11, 4}, {5, 12, 
     6}, {5, 16, 9}, {6, 3, 1}, {6, 9, 3}, {6, 11, 5}, {6, 12, 7}, {6, 15, 
     9}, {7, 2, 1}, {7, 9, 4}, {7, 10, 5}, {7, 12, 8}, {7, 14, 9}, {8, 1, 
     1}, {8, 9, 6}, {8, 10, 7}, {8, 11, 8}, {8, 13, 9}, {9, 4, 2}, {9, 6, 
     3}, {9, 7, 4}, {9, 8, 6}, {9, 16, 10}, {10, 3, 2}, {10, 5, 3}, {10, 7, 
     5}, {10, 8, 7}, {10, 15, 10}, {11, 2, 2}, {11, 5, 4}, {11, 6, 5}, {11, 8,
      8}, {11, 14, 10}, {12, 1, 2}, {12, 5, 6}, {12, 6, 7}, {12, 7, 8}, {12, 
     13, 10}, {13, 2, 3}, {13, 3, 4}, {13, 4, 5}, {13, 8, 9}, {13, 12, 10}, {
     14, 1, 3}, {14, 3, 6}, {14, 4, 7}, {14, 7, 9}, {14, 11, 10}, {15, 1, 
     4}, {15, 2, 6}, {15, 4, 8}, {15, 6, 9}, {15, 10, 10}, {16, 1, 5}, {16, 2,
      7}, {16, 3, 8}, {16, 5, 9}, {16, 9, 10}}}, {
    Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], -Rational[2, 5]^Rational[1, 4], -
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4], 
     Rational[2, 5]^Rational[1, 4], Rational[2, 5]^Rational[1, 4]}}],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellLabel->"Out[2]=",
 CellID->275772318,ExpressionUUID->"fc45a446-23e4-45f4-afa9-fa82f3976233"]
}, Open  ]],

Cell["Notice the normalization of the coefficients:", "ExampleText",
 CellID->240482480,ExpressionUUID->"ef1e2011-895f-423e-92c9-67b2066a72a1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"result", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1"}], "]"}], "]"}], ".", 
    RowBox[{"Array", "[", 
     RowBox[{"c", ",", "10"}], "]"}], ".", 
    RowBox[{"Array", "[", 
     RowBox[{"b", ",", "16"}], "]"}], ".", 
    RowBox[{"Array", "[", 
     RowBox[{"a", ",", "16"}], "]"}]}], "//", "Expand"}], "//", 
  RowBox[{
   RowBox[{"Short", "[", 
    RowBox[{"#", ",", "4"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->259293861,ExpressionUUID->"bb6db65c-8a57-4abb-8c35-8dd77e8e28a9"],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"a", "[", "8", "]"}], " ", 
     RowBox[{"b", "[", "1", "]"}], " ", 
     RowBox[{"c", "[", "1", "]"}]}], "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"a", "[", "7", "]"}], " ", 
     RowBox[{"b", "[", "2", "]"}], " ", 
     RowBox[{"c", "[", "1", "]"}]}], "+", 
    RowBox[{"\[LeftSkeleton]", "113", "\[RightSkeleton]"}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"a", "[", "11", "]"}], " ", 
     RowBox[{"b", "[", "14", "]"}], " ", 
     RowBox[{"c", "[", "10", "]"}]}], "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"a", "[", "10", "]"}], " ", 
     RowBox[{"b", "[", "15", "]"}], " ", 
     RowBox[{"c", "[", "10", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"a", "[", "9", "]"}], " ", 
     RowBox[{"b", "[", "16", "]"}], " ", 
     RowBox[{"c", "[", "10", "]"}]}]}], "}"}],
  Short[#, 4]& ]], "Output",
 CellLabel->"Out[3]//Short=",
 CellID->22030373,ExpressionUUID->"b6044c31-60c6-4f46-bf4b-c39c7f5cead5"]
}, Open  ]],

Cell[TextData[{
 "Now, ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "2"}], "]"}], "]"}]], "InlineFormula",ExpressionUUID->
  "b6ff4f08-f5b4-4566-82b5-7961a6bd10ed"],
 " is more interesting: it contains the rotations matrices needed to block \
diagonalize the representations 16, 16, 10 of SO(10) (as given by ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["RepMatrices"]],"paclet:GroupMath/ref/RepMatrices"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "9aa9da1c-263e-4d71-9bff-0a6caa2f5469"],
 "), with the blocks being the representation matrices under SU(3)xSU(2)xU(1) \
(as given by ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["RepMatrices"]],"paclet:GroupMath/ref/RepMatrices"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "ded8e5f6-98ed-4c90-8a87-78f1047ae4e4"],
 ") after suitable linear combinations of the SO(10) [not shown in the \
output] are taken:"
}], "ExampleText",
 CellID->490834723,ExpressionUUID->"69bd67eb-dbfe-413f-8a62-04dd776f145c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->27134387,ExpressionUUID->"9508c838-78cb-4bd2-9434-0bab258e5da5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {
        RowBox[{"-", "1"}], "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0"},
       {"0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        RowBox[{"-", "1"}], "0", "0", "0"},
       {"0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        RowBox[{"-", "1"}], "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", 
        RowBox[{"-", "1"}], "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[
     SparseArray[
      Automatic, {16, 16}, 0, {
       1, {{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {{2}, {
         1}, {3}, {6}, {4}, {7}, {14}, {13}, {5}, {8}, {12}, {11}, {10}, {
         9}, {15}, {16}}}, {1, -1, 1, 1, 1, 1, 1, -1, 1, 1, -1, 1, 1, -1, 1, 
        1}}]]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {
        RowBox[{"-", "1"}], "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0"},
       {"0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        RowBox[{"-", "1"}], "0", "0", "0"},
       {"0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        RowBox[{"-", "1"}], "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", 
        RowBox[{"-", "1"}], "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[
     SparseArray[
      Automatic, {16, 16}, 0, {
       1, {{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {{2}, {
         1}, {3}, {6}, {4}, {7}, {14}, {13}, {5}, {8}, {12}, {11}, {10}, {
         9}, {15}, {16}}}, {1, -1, 1, 1, 1, 1, 1, -1, 1, 1, -1, 1, 1, -1, 1, 
        1}}]]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1", "0", "0", "0", "0", "0", "0", "0"},
       {"0", 
        RowBox[{"-", "1"}], "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "1", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "1", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "1", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "1", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "1", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "1", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[
     SparseArray[
      Automatic, {10, 10}, 0, {
       1, {{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {{3}, {2}, {1}, {4}, {6}, {
         5}, {7}, {8}, {9}, {10}}}, {1, -1, 1, 1, 1, 1, 1, 1, 1, 1}}]]]]}], 
  "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->492044275,ExpressionUUID->"ed478327-d3b8-420f-8e1a-bfe37ca5be2c"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}]], "InlineFormula",ExpressionUUID->
  "6be2a3f3-c708-4464-848a-ed06a21fc1dd"],
 " just returns the group given as input, and ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "2"}], "]"}], "]"}]], "InlineFormula",ExpressionUUID->
  "557c8a68-58cf-459a-bc81-0c18b2a0f900"],
 " is the projection matrix derived by the program (see ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["RegularSubgroupProjectionMatrix"]],
    "paclet:GroupMath/ref/RegularSubgroupProjectionMatrix"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "5472ee79-ce17-4d22-9c21-c5e07c45d2e2"],
 "). So we move on to ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "3"}], "]"}], "]"}]], "InlineFormula",ExpressionUUID->
  "6f21c96a-4252-42b7-8ae3-66aad512706f"],
 ":"
}], "ExampleText",
 CellID->985435234,ExpressionUUID->"2100828f-b712-4d75-8ba3-3daff64a5f7e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->148666411,ExpressionUUID->"fbfad0b9-b6da-4909-9de6-6be1f0aa51ad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", 
       RowBox[{"-", 
        FractionBox["2", "3"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", 
       FractionBox["1", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       FractionBox["1", "6"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", 
       RowBox[{"-", 
        FractionBox["2", "3"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", 
       FractionBox["1", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       FractionBox["1", "6"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", 
       FractionBox["1", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", "0", "}"}], ",", 
       RowBox[{"-", 
        FractionBox["1", "3"]}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->564167968,ExpressionUUID->"b3f4e6a5-06fc-4251-85e5-d744df0fd5f5"]
}, Open  ]],

Cell[TextData[{
 "This is the list of representations of the subgroup found in the \
representations {16,16,10} of SO(10), respectively (see ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["DecomposeRep"]],"paclet:GroupMath/ref/DecomposeRep"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "55a8b707-9263-4470-8713-1f993f9aa023"],
 " for details). To better see it, use ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["RepName"]],"paclet:Group/ref/RepName"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "31694f1c-362f-40fa-a8b4-fca6bed90cdb"]
}], "ExampleText",
 CellID->4552369,ExpressionUUID->"c62bcb0f-eefe-44e8-b5ad-8fee60a317ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"RepName", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"SU3", ",", "SU2", ",", "U1"}], "}"}], ",", "#"}], "]"}], 
    "&"}], ",", 
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->522541032,ExpressionUUID->"1d30765c-6dd9-4553-99b2-6ba6942c3f23"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnU2O3DYQhTvJJstcIbcIepdltg6yDWAjIyMbB7ADGFn5CrpB34KX4WE6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    "], {{0, 94}, {375, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{375, 94},
  PlotRange->{{0, 375}, {0, 94}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[6]=",
 CellID->329274229,ExpressionUUID->"e05bd11d-146b-4334-8ad3-e8ee9d287e8c"]
}, Open  ]],

Cell[TextData[{
 "The position of the sub-representations shown is important in the \
following:\[LineSeparator]the #1 subrep of the 16 is 1x2x-1/2, #2 is ",
 Cell[BoxData[
  OverscriptBox["3", "_"]], "InlineFormula",ExpressionUUID->
  "1e81033d-68eb-45a9-9c07-56d3723835b9"],
 "x1x-2/3, etc...\[LineSeparator]the #1 subrep of the 16 is 1x2x-1/2, #2 is ",
 Cell[BoxData[
  OverscriptBox["3", "_"]], "InlineFormula",ExpressionUUID->
  "c3dc92ff-bd36-425b-879a-3bd9721d8540"],
 "x1x-2/3, etc...\[LineSeparator]the #1 subrep of the 10 is ",
 Cell[BoxData[
  OverscriptBox["3", "_"]], "InlineFormula",ExpressionUUID->
  "9e7dc8b8-9c32-4e8b-9749-bf5a426b206d"],
 "x1x1/3, #2 is 1x2x1/2, etc...\[LineSeparator]\[LineSeparator]Now, we look \
at ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "4"}], "]"}], "]"}]], "InlineFormula",ExpressionUUID->
  "af9beac5-4db8-4064-bf8e-030645f984e4"],
 ", or, without loosing information, just at"
}], "ExampleText",
 Deletable->True,
 CellID->49186995,ExpressionUUID->"04acbc06-0bae-4d1f-8f15-03929f2c7021"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", "4", ",", "All", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->97988462,ExpressionUUID->"b6662cee-3baf-41b5-a489-08f87442e702"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "6", ",", "3"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "6", ",", "4"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "3"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "5", ",", "4"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "3", ",", "3"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "4", ",", "4"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "1", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "3", ",", "4"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "1", ",", "3"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "2", ",", "4"}], "}"}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[7]=",
 CellID->1020355790,ExpressionUUID->"b4b23eb6-1452-4d8f-a7a5-e73d55acf90e"]
}, Open  ]],

Cell[TextData[{
 "What this tells us is that the ...\[LineSeparator]- (",
 StyleBox["#1",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the first rep [the 16]) x (",
 StyleBox["#4",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the second rep [the 16]) x (",
 StyleBox["#1",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the third rep [the 10]) contains ",
 StyleBox["one",
  FontColor->RGBColor[0.5, 0, 0.5]],
 " subgroup [SU3xSU2xU1] invariant\[LineSeparator]- (",
 StyleBox["#1",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the first rep [the 16]) x (",
 StyleBox["#5",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the second rep [the 16]) x (",
 StyleBox["#2",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the third rep [the 10]) contains ",
 StyleBox["one",
  FontColor->RGBColor[0.5, 0, 0.5]],
 " subgroup [SU3xSU2xU1] invariant\[LineSeparator]- (",
 StyleBox["#1",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the first rep [the 16]) x (",
 StyleBox["#6",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the second rep [the 16]) x (",
 StyleBox["#3",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the third rep [the 10]) contains ",
 StyleBox["one",
  FontColor->RGBColor[0.5, 0, 0.5]],
 " subgroup [SU3xSU2xU1] invariant\[LineSeparator]...\[LineSeparator]- (",
 StyleBox["#6",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the first rep [the 16]) x (",
 StyleBox["#2",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the second rep [the 16]) x (",
 StyleBox["#4",
  FontColor->RGBColor[1, 0, 0]],
 " subrep of the third rep [the 10]) contains ",
 StyleBox["one",
  FontColor->RGBColor[0.5, 0, 0.5]],
 " subgroup [SU3xSU2xU1] invariant\[LineSeparator]\[LineSeparator]In total \
then, there are 17 SU(3)xSU(2)xU(1) invariants in the 16 x 16 x 10 SO(10) \
invariant. To see more clearly the SU(3)xSU(2)xU(1) representations involved \
in each, we can write the following:"
}], "ExampleText",
 Deletable->True,
 CellID->137870151,ExpressionUUID->"6529b912-9631-4276-929d-e7e590c69270"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"RepName", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"SU3", ",", "SU2", ",", "U1"}], "}"}], ",", "#"}], "]"}], 
    "&"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Extract", "[", 
      RowBox[{
       RowBox[{"result", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", "#"}], "]"}], "&"}], "/@", 
    RowBox[{"result", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "4", ",", "All", ",", "2"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->55378935,ExpressionUUID->"dce4f96b-a565-4e64-8b96-d135d5e9170f"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnbuu80pyhY/txKFDp34LQ5lDp2P4AWbg0cDJGJgxYDj6X4GJ4/0W/TL9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    "], {{0, 280}, {405, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{405, 280},
  PlotRange->{{0, 405}, {0, 280}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[8]=",
 CellID->542344503,ExpressionUUID->"bd7dd1fb-5af6-46b3-95c3-7a22465273a2"]
}, Open  ]],

Cell[TextData[{
 "All these 17 products provide just a single SU(3)xSU(2)xU(1) invariant (see \
",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "4"}], "]"}], "]"}]], "InlineFormula",ExpressionUUID->
  "f75adf11-f73a-4165-bd40-f3930ae6bc13"],
 " above), but in general this is might not be the case. So the following, \
more complicated code is safer, as it will take into account this potential \
multiplicity:"
}], "ExampleText",
 Deletable->True,
 CellID->332102819,ExpressionUUID->"e73fc873-2bb3-4423-a307-9202e66f65b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"RepName", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"SU3", ",", "SU2", ",", "U1"}], "}"}], ",", "#"}], "]"}], 
    "&"}], ",", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"ConstantArray", "[", 
        RowBox[{
         RowBox[{"Extract", "[", 
          RowBox[{
           RowBox[{"result", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "&"}], "/@", 
      RowBox[{"result", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "4", ",", "All", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], ",", "1"}], "]"}],
    ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->52206020,ExpressionUUID->"30df55b8-1c83-4dd5-b04b-185754f09e84"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnbuu80pyhY/txKFDp34LQ5lDp2P4AWbg0cDJGJgxYDj6X4GJ4/0W/TL9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    "], {{0, 280}, {405, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{405, 280},
  PlotRange->{{0, 405}, {0, 280}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[9]=",
 CellID->776004901,ExpressionUUID->"05c759d3-484e-453d-bf81-de4cd3ee6d0a"]
}, Open  ]],

Cell[TextData[{
 "Finally, we are in a position to interpret the main part of output we got: ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "5"}], "]"}], "]"}]], "InlineFormula",ExpressionUUID->
  "28cd9631-069e-4e16-bcd3-3a11bdadbee9"],
 ". Each SO(10) invariant of the form 16 x 16 x 10 [there is just one in this \
case], is a linear combination of the 17 invariants of SU(3)xSU(2)xU(1), and \
the coefficients are"
}], "ExampleText",
 Deletable->True,
 CellID->27014175,ExpressionUUID->"779b567f-152a-4644-ac60-41190bcd8e77"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->49277989,ExpressionUUID->"a0aa5331-fcff-4436-882a-6357bc302c22"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    FractionBox[
     SuperscriptBox["2", 
      RowBox[{"3", "/", "4"}]], 
     SuperscriptBox["15", 
      RowBox[{"1", "/", "4"}]]], ",", 
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]]}], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    FractionBox[
     SuperscriptBox["2", 
      RowBox[{"3", "/", "4"}]], 
     SuperscriptBox["15", 
      RowBox[{"1", "/", "4"}]]], ",", 
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]]}], ",", 
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]]}], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]]}], ",", 
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]]}], ",", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["2", 
       RowBox[{"3", "/", "4"}]], 
      SuperscriptBox["15", 
       RowBox[{"1", "/", "4"}]]]}], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", "5"], ")"}], 
      RowBox[{"1", "/", "4"}]]}], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "5"], ")"}], 
     RowBox[{"1", "/", "4"}]]}], "}"}], "}"}]], "Output",
 CellLabel->"Out[10]=",
 CellID->326281188,ExpressionUUID->"007369dc-1924-4dad-bbeb-4789aa71ec71"]
}, Open  ]],

Cell[TextData[{
 "[Note: in the present case, we see from ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "4"}], "]"}], "]"}]], "InlineFormula",ExpressionUUID->
  "3f72ad8e-7de8-43f2-8fb3-9e92e5fb7dda"],
 " that all 17 products of representations provide just a single \
SU(3)xSU(2)xU(1) invariant each. If this is not the case, we would have more \
than 17 coefficients in  ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "5"}], "]"}], "]"}]], "InlineFormula",ExpressionUUID->
  "48041357-4c64-4db8-8036-6bcf5d3ac6d3"],
 ". For the sake of simplicity, consider this situation: if ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "4", ",", "All", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]], "InlineFormula",
  ExpressionUUID->"4bb87714-afa2-40b8-baae-c4a16fb27a5c"],
 " was {{{1,1,1},2},{{1,2,3},3},{{1,3,4},1}}, then  ",
 Cell[BoxData[
  RowBox[{"result", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "5"}], "]"}], "]"}]], "InlineFormula",ExpressionUUID->
  "d0a13d68-5846-4f5f-b7a5-cae7e5a36f5a"],
 " would be of the form {{c1,c2,c3,c4,c5,c6}} with c1,c2 corresponding to \
{{1,1,1},2}, c3,c4,c5 to {{1,2,3},3}, and c6 to {{1,3,4},1}}]."
}], "ExampleText",
 Deletable->True,
 CellID->377252352,ExpressionUUID->"56f351b0-ed5f-4f32-bbc7-f48dc2396cdf"],

Cell["We can put it in a more readable form as follows", "ExampleText",
 Deletable->True,
 CellID->409441931,ExpressionUUID->"b5beeb1c-6cd2-49c3-a383-5d7656b4a4c6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"coefficients", "=", 
    RowBox[{"result", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"productFields", "=", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"RepName", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"SU3", ",", "SU2", ",", "U1"}], "}"}], ",", "#"}], "]"}], 
       "&"}], ",", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ConstantArray", "[", 
           RowBox[{
            RowBox[{"Extract", "[", 
             RowBox[{
              RowBox[{"result", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", 
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "&"}], "/@", 
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "4", ",", "All", ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], ",", "1"}], 
       "]"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<The product of \>\"", ",", 
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"RepName", "[", 
          RowBox[{"SO10", ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{"16", ",", "16", ",", "10"}], "}"}]}], ",", 
       RowBox[{"Darker", "[", "Red", "]"}]}], "]"}], ",", 
     "\"\< of SO(1O) is the same as\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aux", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"coefficients", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"Darker", "[", "Gray", "]"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"productFields", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"Darker", "[", "Red", "]"}]}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "coefficients", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Row", "[", 
    RowBox[{"aux", ",", "\"\< + \>\""}], "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<in SU(3)xSU(2)xU(1)\>\"", "]"}], ";"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->325694542,ExpressionUUID->"ae923ce1-d756-4e0e-ac12-f4486cccd232"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The product of \"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"{", 
     RowBox[{
      StyleBox["\<\"16\"\>",
       StripOnInput->False,
       FontWeight->Bold], ",", 
      StyleBox["\<\"16\"\>",
       StripOnInput->False,
       FontWeight->Bold], ",", 
      StyleBox["\<\"10\"\>",
       StripOnInput->False,
       FontWeight->Bold]}], "}"}],
    StripOnInput->False,
    FontColor->RGBColor[
      Rational[2, 3], 0, 0],
    $CellContext`LineColor -> RGBColor[
      Rational[2, 3], 0, 0],
    $CellContext`FrontFaceColor -> RGBColor[
      Rational[2, 3], 0, 0],
    $CellContext`BackFaceColor -> RGBColor[
      Rational[2, 3], 0, 0],
    $CellContext`GraphicsColor -> RGBColor[
      Rational[2, 3], 0, 0]], 
   "\[InvisibleSpace]", "\<\" of SO(1O) is the same as\"\>"}],
  SequenceForm["The product of ", 
   Style[{
     Style["16", Bold], 
     Style["16", Bold], 
     Style["10", Bold]}, 
    RGBColor[
     Rational[2, 3], 0, 0]], " of SO(1O) is the same as"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[219]:=",
 CellID->559028900,ExpressionUUID->"21fd36c2-57d4-4e9b-ba4e-e46674c4ec84"],

Cell[BoxData[
 TemplateBox[{" + ","\" + \"",TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"2\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       SuperscriptBox["2", 
        RowBox[{"3", "/", "4"}]], 
       SuperscriptBox["15", 
        RowBox[{"1", "/", "4"}]]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "5"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"2\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       SuperscriptBox["2", 
        RowBox[{"3", "/", "4"}]], 
       SuperscriptBox["15", 
        RowBox[{"1", "/", "4"}]]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "5"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "5"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "5"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"2\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "5"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{"3", "/", "4"}]], 
         SuperscriptBox["15", 
          RowBox[{"1", "/", "4"}]]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"2\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "5"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "5"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"]},
  "RowWithSeparators"]], "Print",
 CellLabel->"During evaluation of In[219]:=",
 CellID->120921690,ExpressionUUID->"e4c6775b-0434-4643-90b5-138ea17e8bf8"],

Cell[BoxData["\<\"in SU(3)xSU(2)xU(1)\"\>"], "Print",
 CellLabel->"During evaluation of In[219]:=",
 CellID->581693393,ExpressionUUID->"e41aa28b-d0d4-4bbe-9460-1b2139ebd327"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "These coefficients in gray have been computed by GroupMath by explicitly \
embedding each and all sub-representations of SU(3)xSU(2)xU(1) in the \
corresponding representation of SO(10), computing the \
invariants/Clebsch-Gordon coefficients with both symmetry groups, and \
matching them. The fact that coefficients we returned at all (i.e., no error \
was produced) means that such matching was achieved successfully, and \
therefore is a very strong sign that the computation chain and the final \
output are correct.\[LineSeparator]\[LineSeparator]A potential question is: \
why are the coefficients so complicated (with quartic roots for example)? The \
answer is simple: it is due to the normalization convention of GroupMath for \
all invariants/Clebsch-Gordon coefficients, which in this case affects both \
those at the SO(10) level as well as those at the SU(3)xSU(2)xU(1) level. \
These invariants are calculated with the ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["Invariants"]],"paclet:GroupMath/ref/Invariants"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "d1e41ada-c66e-4bb2-8b05-92120a9ff584"],
 " function (see the normalization convention in the documentation of this \
function).\[LineSeparator]\[LineSeparator]Note however that at the \
SU(3)xSU(2)xU(1) level, most invariants are normalized as it is usually done. \
For example, the invariants/Clebsch-Gordon coefficients of the products"
}], "ExampleText",
 Deletable->True,
 CellID->40659380,ExpressionUUID->"ac7b333d-ed0b-4959-84a2-2dcccdbedbd2"],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     StyleBox["\<\"3\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/6\\)\"\>"}], ",", 
    RowBox[{
     OverscriptBox[
      StyleBox["\<\"3\"\>",
       StripOnInput->False,
       FontWeight->Bold], "_"], "\[CircleTimes]", 
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], 
     "\[CircleTimes]", "\<\"\\!\\(-\\(\\(2\\/3\\)\\)\\)\"\>"}], ",", 
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/2\\)\"\>"}]}], "}"}],
  StripOnInput->False,
  FontColor->RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`LineColor -> RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`FrontFaceColor -> RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`GraphicsColor -> RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`BackFaceColor -> RGBColor[
    Rational[2, 3], 0, 0]]], "Output",
 ImageSize->{190, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->20401898,ExpressionUUID->"8e4a2269-ea49-48c7-8fa9-61d07a8a0f52"],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     StyleBox["\<\"3\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/6\\)\"\>"}], ",", 
    RowBox[{
     OverscriptBox[
      StyleBox["\<\"3\"\>",
       StripOnInput->False,
       FontWeight->Bold], "_"], "\[CircleTimes]", 
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/3\\)\"\>"}], ",", 
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], 
     "\[CircleTimes]", "\<\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\"\>"}]}], "}"}],
  StripOnInput->False,
  FontColor->RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`LineColor -> RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`FrontFaceColor -> RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`GraphicsColor -> RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`BackFaceColor -> RGBColor[
    Rational[2, 3], 0, 0]]], "Output",
 ImageSize->{190, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->201267126,ExpressionUUID->"2cd97f98-3f0b-4d33-8558-974c26e4fcf6"],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], 
     "\[CircleTimes]", "\<\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\"\>"}], ",", 
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\)\"\>"}], ",", 
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], 
     "\[CircleTimes]", "\<\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\"\>"}]}], "}"}],
  StripOnInput->False,
  FontColor->RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`LineColor -> RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`FrontFaceColor -> RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`GraphicsColor -> RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`BackFaceColor -> RGBColor[
    Rational[2, 3], 0, 0]]], "Output",
 ImageSize->{194, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->99615333,ExpressionUUID->"14821e11-b4f2-418a-b22f-4e6ef7374105"],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], 
     "\[CircleTimes]", "\<\"\\!\\(-\\(\\(1\\/2\\)\\)\\)\"\>"}], ",", 
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(0\\)\"\>"}], ",", 
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", 
     StyleBox["\<\"2\"\>",
      StripOnInput->False,
      FontWeight->Bold], "\[CircleTimes]", "\<\"\\!\\(1\\/2\\)\"\>"}]}], "}"}],
  StripOnInput->False,
  FontColor->RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`LineColor -> RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`FrontFaceColor -> RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`GraphicsColor -> RGBColor[
    Rational[2, 3], 0, 0],
  $CellContext`BackFaceColor -> RGBColor[
    Rational[2, 3], 0, 0]]], "Output",
 ImageSize->{186, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->238858373,ExpressionUUID->"44700bbf-50d1-45d9-abee-727dce690df8"],

Cell["\<\
are, up to a sign, as in the Standard Model of Particle Physics, so we can \
compare the coefficients of each without further worries (except for signs, \
which we might want to keep track). To factor out the normalization choice of \
the 16 x 16 x 10 SO(10) invariant we can look at the ratio of these \
coefficients. Above, we can see that in all 4 cases the coefficients are\
\>", "ExampleText",
 Deletable->True,
 CellID->83166596,ExpressionUUID->"254a97bb-d5ee-4d4c-a7d1-526e4be3e333"],

Cell[BoxData[
 StyleBox[
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox["2", "5"], ")"}], 
   RowBox[{"1", "/", "4"}]],
  StripOnInput->False,
  FontColor->RGBColor[
   0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`],
  $CellContext`LineColor -> 
  RGBColor[0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`],
  $CellContext`FrontFaceColor -> 
  RGBColor[0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`],
  $CellContext`BackFaceColor -> 
  RGBColor[0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`],
  $CellContext`GraphicsColor -> 
  RGBColor[0.33333333333333337`, 0.33333333333333337`, 
    0.33333333333333337`]]], "Input",
 CellLabel->"In[16]:=",
 CellID->897575960,ExpressionUUID->"691c6d37-3c39-468b-a981-6bda6d9b6492"],

Cell["or", "ExampleText",
 Deletable->True,
 CellID->242635841,ExpressionUUID->"806ff140-f79f-4db1-9ec9-b09cb85ff1ea"],

Cell[BoxData[
 StyleBox[
  RowBox[{"-", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["2", "5"], ")"}], 
    RowBox[{"1", "/", "4"}]]}],
  StripOnInput->False,
  FontColor->RGBColor[
   0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`],
  $CellContext`LineColor -> 
  RGBColor[0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`],
  $CellContext`FrontFaceColor -> 
  RGBColor[0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`],
  $CellContext`BackFaceColor -> 
  RGBColor[0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`],
  $CellContext`GraphicsColor -> 
  RGBColor[0.33333333333333337`, 0.33333333333333337`, 
    0.33333333333333337`]]], "Input",
 CellLabel->"In[17]:=",
 CellID->48697774,ExpressionUUID->"58749966-5c33-48ac-abb0-456ea6897366"],

Cell["\<\
So we conclude that the with this sign convention for SU(3)xSU(2)xU(1) \
contractions, the Yukawa couplings would have the relation Yu=Yd=-Ye=-Y\[Nu] \
in an SO(10) model if they were to come from an 16 x 16 x 10 coupling.\
\>", "ExampleText",
 Deletable->True,
 CellID->216184249,ExpressionUUID->"712f236e-2b45-487d-9f03-23ff7c5fa6d4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "d9af37b4-eb08-4eaa-ab0e-ae8f8ce140e5"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197771987,ExpressionUUID->"6919bfaa-c859-4ca4-8fe2-137df65417e3"],

Cell["\<\
Let us repeat the previous example, but with the other possible scalar \
representations S that can form a trilinear term 16 x 16 x S, namely the 120 \
({0,0,1,0,0}) and the 126 ({0,0,0,2,0}):\
\>", "ExampleText",
 CellID->26134510,ExpressionUUID->"84f24623-35af-4193-bbbf-ee6b3f000d18"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "16"}], ",", 
     RowBox[{"-", "16"}]}], "}"}], ",", 
   RowBox[{"UseName", "\[Rule]", "False"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SO10", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "16"}], ",", 
     RowBox[{"-", "16"}]}], "}"}], ",", 
   RowBox[{"UseName", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->691511790,ExpressionUUID->"527ae235-d038-47ef-b14c-32eefb7713e2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->527729796,ExpressionUUID->"8b5c48c7-ce9c-4a2a-b1ac-36818e5b585f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["\<\"126\"\>",
      StripOnInput->False,
      FontWeight->Bold], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["\<\"120\"\>",
      StripOnInput->False,
      FontWeight->Bold], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["\<\"10\"\>",
      StripOnInput->False,
      FontWeight->Bold], ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->2941169,ExpressionUUID->"d81e220c-4af2-4584-92f7-ef53111607ac"]
}, Open  ]],

Cell["Let us consider just S={0,0,0,2,0} (the 126):", "ExampleText",
 CellID->281445517,ExpressionUUID->"62c1071c-a0f6-4fbc-a753-84b448236d94"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"breakInfo", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"{", "4", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "6"}]}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result", "=", 
   RowBox[{"SubgroupCoefficients", "[", 
    RowBox[{"SO10", ",", 
     RowBox[{"{", 
      RowBox[{"16", ",", "16", ",", "126"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"SU3", ",", "SU2", ",", "U1"}], "}"}], ",", "breakInfo"}], 
    "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1908845,ExpressionUUID->"9059b2fa-3ba9-4682-937c-3b0338e54eac"],

Cell["The result can be summarized as follows:", "ExampleText",
 CellID->154247179,ExpressionUUID->"3cc1ba49-409b-4fed-8dcf-2070ddd62d10"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"coefficients", "=", 
    RowBox[{"result", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"productFields", "=", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"RepName", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"SU3", ",", "SU2", ",", "U1"}], "}"}], ",", "#"}], "]"}], 
       "&"}], ",", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ConstantArray", "[", 
           RowBox[{
            RowBox[{"Extract", "[", 
             RowBox[{
              RowBox[{"result", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", 
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "&"}], "/@", 
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "4", ",", "All", ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], ",", "1"}], 
       "]"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<The product of \>\"", ",", 
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"RepName", "[", 
          RowBox[{"SO10", ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{"16", ",", "16", ",", "126"}], "}"}]}], ",", 
       RowBox[{"Darker", "[", "Red", "]"}]}], "]"}], ",", 
     "\"\< of SO(1O) is the same as\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aux", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"coefficients", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"Darker", "[", "Gray", "]"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"productFields", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"Darker", "[", "Red", "]"}]}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "coefficients", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Row", "[", 
    RowBox[{"aux", ",", "\"\< + \>\""}], "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<in SU(3)xSU(2)xU(1)\>\"", "]"}], ";"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->28459257,ExpressionUUID->"aeb7a3cc-1e62-4946-a757-5d77d3ced8a0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The product of \"\>", "\[InvisibleSpace]", 
   StyleBox[
    RowBox[{"{", 
     RowBox[{
      StyleBox["\<\"16\"\>",
       StripOnInput->False,
       FontWeight->Bold], ",", 
      StyleBox["\<\"16\"\>",
       StripOnInput->False,
       FontWeight->Bold], ",", 
      StyleBox["\<\"126\"\>",
       StripOnInput->False,
       FontWeight->Bold]}], "}"}],
    StripOnInput->False,
    FontColor->RGBColor[
      Rational[2, 3], 0, 0],
    $CellContext`LineColor -> RGBColor[
      Rational[2, 3], 0, 0],
    $CellContext`FrontFaceColor -> RGBColor[
      Rational[2, 3], 0, 0],
    $CellContext`BackFaceColor -> RGBColor[
      Rational[2, 3], 0, 0],
    $CellContext`GraphicsColor -> RGBColor[
      Rational[2, 3], 0, 0]], 
   "\[InvisibleSpace]", "\<\" of SO(1O) is the same as\"\>"}],
  SequenceForm["The product of ", 
   Style[{
     Style["16", Bold], 
     Style["16", Bold], 
     Style["126", Bold]}, 
    RGBColor[
     Rational[2, 3], 0, 0]], " of SO(1O) is the same as"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[229]:=",
 CellID->5698085,ExpressionUUID->"0a64bfd7-b955-4196-a78f-757d09b080bb"],

Cell[BoxData[
 TemplateBox[{" + ","\" + \"",TemplateBox[{
     StyleBox[
      RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "21"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
              FractionBox["2", "7"], ")"}], 
            RowBox[{"1", "/", "4"}]]}], 
         SqrtBox["3"]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"7\\\", \\\"6\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
              FractionBox["2", "7"], ")"}], 
            RowBox[{"1", "/", "4"}]]}], 
         SqrtBox["3"]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       SuperscriptBox["2", 
        RowBox[{"3", "/", "4"}]], 
       SuperscriptBox["21", 
        RowBox[{"1", "/", "4"}]]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
          FractionBox["2", "7"], ")"}], 
        RowBox[{"1", "/", "4"}]], 
       SqrtBox["3"]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"2\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
              FractionBox["2", "7"], ")"}], 
            RowBox[{"1", "/", "4"}]]}], 
         SqrtBox["3"]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"7\\\", \\\"6\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox["4", 
       RowBox[{
         SuperscriptBox["3", 
          RowBox[{"3", "/", "4"}]], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"6\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"4\\\", \\\"3\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SqrtBox["2"]}], 
       RowBox[{
         SuperscriptBox["3", 
          RowBox[{"3", "/", "4"}]], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"6\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "3"], ")"}], 
          RowBox[{"3", "/", "4"}]], 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox["4", 
       RowBox[{"3", " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"8\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"2\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{
        FractionBox["1", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "7"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"2\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"2\\\", \\\"3\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox["0", 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
              FractionBox["2", "7"], ")"}], 
            RowBox[{"1", "/", "4"}]]}], 
         SqrtBox["3"]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SqrtBox["2"]}], 
       RowBox[{
         SuperscriptBox["3", 
          RowBox[{"3", "/", "4"}]], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"6\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "3"], ")"}], 
          RowBox[{"3", "/", "4"}]], 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox["4", 
       RowBox[{
         SuperscriptBox["3", 
          RowBox[{"3", "/", "4"}]], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"6\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox["4", 
       RowBox[{"3", " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"8\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{
        FractionBox["1", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "7"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox["2", 
          RowBox[{"3", "/", "4"}]]}], 
       RowBox[{"3", " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{
        FractionBox["1", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "7"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"4\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       SuperscriptBox["2", 
        RowBox[{"3", "/", "4"}]], 
       SuperscriptBox["21", 
        RowBox[{"1", "/", "4"}]]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
          FractionBox["2", "7"], ")"}], 
        RowBox[{"1", "/", "4"}]], 
       SqrtBox["3"]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox["4", 
       RowBox[{"3", " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"8\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"2\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{
        FractionBox["1", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "7"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"2\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox["4", 
       RowBox[{"3", " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"8\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{
        FractionBox["1", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "7"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
           SqrtBox[
            FractionBox["2", "3"]]}], 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"6\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox["2", "3"]}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "21"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       SuperscriptBox["2", 
        RowBox[{"3", "/", "4"}]], 
       RowBox[{"3", " ", 
         SuperscriptBox["21", 
          RowBox[{"1", "/", "4"}]]}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
              FractionBox["2", "7"], ")"}], 
            RowBox[{"1", "/", "4"}]]}], 
         SqrtBox["3"]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"6\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
              FractionBox["2", "7"], ")"}], 
            RowBox[{"1", "/", "4"}]]}], 
         SqrtBox["3"]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"7\\\", \
\\\"6\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"2\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"2\\\", \\\"3\\\"]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox["2", 
          RowBox[{"3", "/", "4"}]]}], 
       RowBox[{"3", " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{
        FractionBox["1", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["2", "7"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
              FractionBox["2", "7"], ")"}], 
            RowBox[{"1", "/", "4"}]]}], 
         SqrtBox["3"]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"6\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox["2", 
          RowBox[{"3", "/", "4"}]]}], 
       RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", \\\"1\\\"}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox["0", 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"4\\\", \
\\\"3\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
              FractionBox["2", "7"], ")"}], 
            RowBox[{"1", "/", "4"}]]}], 
         SqrtBox["3"]]}], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"3\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
          RowBox[{
            OverscriptBox[
             StyleBox["\"3\"", Bold, StripOnInput -> False], "_"], 
            "\[CircleTimes]", 
            StyleBox["\"2\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"7\\\", \
\\\"6\\\"]}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            FractionBox["2", "7"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
       SqrtBox["3"]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", \\\"1\\\"}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"],
   TemplateBox[{
     StyleBox[
      FractionBox[
       RowBox[{"2", " ", 
         SuperscriptBox["2", 
          RowBox[{"3", "/", "4"}]]}], 
       RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]], 
      RGBColor[
      0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
      StripOnInput -> False], 
     StyleBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
          RowBox[{
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            StyleBox["\"1\"", Bold, StripOnInput -> False], "\[CircleTimes]", 
            "\"\\!\\(\\*RowBox[{\\\"-\\\", \\\"2\\\"}]\\)\""}]}], "}"}], 
      RGBColor[
       Rational[2, 3], 0, 0], StripOnInput -> False]}, "RowDefault"]},
  "RowWithSeparators"]], "Print",
 CellLabel->"During evaluation of In[229]:=",
 CellID->772047024,ExpressionUUID->"5a422f79-2000-47b3-ac29-8cf995574ab0"],

Cell[BoxData["\<\"in SU(3)xSU(2)xU(1)\"\>"], "Print",
 CellLabel->"During evaluation of In[229]:=",
 CellID->213938306,ExpressionUUID->"bb45209d-3e61-42ce-9ffb-8d46ee59e591"]
}, Open  ]]
}, Open  ]],

Cell["The important terms are the following:", "ExampleText",
 CellID->16234398,ExpressionUUID->"c7ab08d1-c97d-4687-8858-e4ea9fb5cdf8"],

Cell[BoxData[
 TemplateBox[{StyleBox[
    RowBox[{
      FractionBox["1", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]]}], $CellContext`LineColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`FrontFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`BackFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`GraphicsColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], FontColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], StripOnInput -> False],StyleBox[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          StyleBox["\"3\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
        RowBox[{
          OverscriptBox[
           StyleBox["\"3\"", FontWeight -> Bold, StripOnInput -> False], "_"],
           "\[CircleTimes]", 
          StyleBox["\"1\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"2\\\", \
\\\"3\\\"]}]\\)\""}], ",", 
        RowBox[{
          StyleBox["\"1\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"2\\\"]\\)\""}]}], 
      "}"}], $CellContext`LineColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`FrontFaceColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`BackFaceColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`GraphicsColor -> RGBColor[
      Rational[2, 3], 0, 0], FontColor -> RGBColor[
      Rational[2, 3], 0, 0], StripOnInput -> False]},
  "RowDefault"]], "Output",
 CellLabel->"Out[4]=",
 CellID->364487517,ExpressionUUID->"c78e77f8-5157-4e47-894d-33d649f25299"],

Cell[BoxData[
 TemplateBox[{StyleBox[
    RowBox[{
      FractionBox["1", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
         FractionBox["2", "7"], ")"}], 
       RowBox[{"1", "/", "4"}]]}], $CellContext`LineColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`FrontFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`BackFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`GraphicsColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], FontColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], StripOnInput -> False],StyleBox[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          StyleBox["\"3\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"6\\\"]\\)\""}], ",", 
        RowBox[{
          OverscriptBox[
           StyleBox["\"3\"", FontWeight -> Bold, StripOnInput -> False], "_"],
           "\[CircleTimes]", 
          StyleBox["\"1\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"3\\\"]\\)\""}], ",", 
        RowBox[{
          StyleBox["\"1\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}]}], "}"}], $CellContext`LineColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`FrontFaceColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`BackFaceColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`GraphicsColor -> RGBColor[
      Rational[2, 3], 0, 0], FontColor -> RGBColor[
      Rational[2, 3], 0, 0], StripOnInput -> False]},
  "RowDefault"]], "Output",
 CellLabel->"Out[5]=",
 CellID->176525280,ExpressionUUID->"dfa59c87-4fcb-4103-8b09-9c3c2cdef6f7"],

Cell[BoxData[
 TemplateBox[{StyleBox[
    SuperscriptBox[
     RowBox[{"(", 
       FractionBox["2", "7"], ")"}], 
     RowBox[{"1", "/", "4"}]], $CellContext`LineColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`FrontFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`BackFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`GraphicsColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], FontColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], StripOnInput -> False],StyleBox[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          StyleBox["\"1\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
        RowBox[{
          StyleBox["\"1\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          StyleBox["\"1\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", "\"\\!\\(\\*RowBox[{\\\"1\\\"}]\\)\""}], ",", 
        RowBox[{
          StyleBox["\"1\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}]}], "}"}], $CellContext`LineColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`FrontFaceColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`BackFaceColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`GraphicsColor -> RGBColor[
      Rational[2, 3], 0, 0], FontColor -> RGBColor[
      Rational[2, 3], 0, 0], StripOnInput -> False]},
  "RowDefault"]], "Output",
 CellLabel->"Out[6]=",
 CellID->420098858,ExpressionUUID->"d9b79b27-afff-4a6e-bc78-0c861ef5d62c"],

Cell[BoxData[
 TemplateBox[{StyleBox[
    SuperscriptBox[
     RowBox[{"(", 
       FractionBox["2", "7"], ")"}], 
     RowBox[{"1", "/", "4"}]], $CellContext`LineColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`FrontFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`BackFaceColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], $CellContext`GraphicsColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], FontColor -> 
    RGBColor[0.33333333333333337`, 0.33333333333333337`, 
      0.33333333333333337`], StripOnInput -> False],StyleBox[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          StyleBox["\"1\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          "\"\\!\\(\\*RowBox[{\\\"-\\\", FractionBox[\\\"1\\\", \
\\\"2\\\"]}]\\)\""}], ",", 
        RowBox[{
          StyleBox["\"1\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          StyleBox["\"1\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\)\""}], ",", 
        RowBox[{
          StyleBox["\"1\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          StyleBox["\"2\"", FontWeight -> Bold, StripOnInput -> False], 
          "\[CircleTimes]", 
          "\"\\!\\(\\*FractionBox[\\\"1\\\", \\\"2\\\"]\\)\""}]}], 
      "}"}], $CellContext`LineColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`FrontFaceColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`BackFaceColor -> RGBColor[
      Rational[2, 3], 0, 0], $CellContext`GraphicsColor -> RGBColor[
      Rational[2, 3], 0, 0], FontColor -> RGBColor[
      Rational[2, 3], 0, 0], StripOnInput -> False]},
  "RowDefault"]], "Output",
 CellLabel->"Out[7]=",
 CellID->236312083,ExpressionUUID->"175209fa-fb92-4e40-beaa-0de690419552"],

Cell["\<\
By looking at the ratio of the numerical coefficients in gray, we conclude \
that the Yukawa couplings would have the relation Yu=Yd=1/3 Ye=1/3 Y\[Nu] in \
an SO(10) model where they come from an 16 x 16 x 126 coupling. This compares \
with the relation Yu=Yd=-Ye=-Y\[Nu] obtained from a 16 x 16 x 10 coupling.\
\>", "ExampleText",
 CellID->53541657,ExpressionUUID->"2b79f759-c5fe-47f6-9ece-bee0d25ffd84"],

Cell["\<\
It is worth stressing again that at no point did we see how GroupMath is \
performing the SU(3)xSU(2)xU(1) contractions. But we can:\
\>", "ExampleText",
 CellID->795546701,ExpressionUUID->"5a36d42b-5430-4518-bfec-407caf7d670d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"repQ", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"1", "/", "6"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repUc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], "/", "3"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repDc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"1", "/", "3"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repL", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repNc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "0", "}"}], ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repEc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "0", "}"}], ",", "1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repHu", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repHd", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Invariants", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"SU3", ",", "SU2", ",", "U1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"repQ", ",", "repUc", ",", "repHu"}], "}"}]}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"uL", "[", "red", "]"}]}], ",", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"uL", "[", "green", "]"}]}], ",", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"uL", "[", "blue", "]"}]}], ",", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "2"}], "]"}], "\[Rule]", 
     RowBox[{"dL", "[", "red", "]"}]}], ",", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2"}], "]"}], "\[Rule]", 
     RowBox[{"dL", "[", "green", "]"}]}], ",", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "2"}], "]"}], "\[Rule]", 
     RowBox[{"dL", "[", "blue", "]"}]}], ",", 
    RowBox[{
     RowBox[{"b", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"uRc", "[", "red", "]"}]}], ",", 
    RowBox[{
     RowBox[{"b", "[", 
      RowBox[{"2", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"uRc", "[", "green", "]"}]}], ",", 
    RowBox[{
     RowBox[{"b", "[", 
      RowBox[{"3", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"uRc", "[", "blue", "]"}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"Hu", "[", "1", "]"}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", 
      RowBox[{"1", ",", "2"}], "]"}], "\[Rule]", 
     RowBox[{"Hu", "[", "0", "]"}]}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Invariants", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"SU3", ",", "SU2", ",", "U1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"repQ", ",", "repDc", ",", "repHd"}], "}"}]}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"uL", "[", "red", "]"}]}], ",", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"uL", "[", "green", "]"}]}], ",", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"uL", "[", "blue", "]"}]}], ",", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "2"}], "]"}], "\[Rule]", 
     RowBox[{"dL", "[", "red", "]"}]}], ",", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2"}], "]"}], "\[Rule]", 
     RowBox[{"dL", "[", "green", "]"}]}], ",", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "2"}], "]"}], "\[Rule]", 
     RowBox[{"dL", "[", "blue", "]"}]}], ",", 
    RowBox[{
     RowBox[{"b", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"dRc", "[", "red", "]"}]}], ",", 
    RowBox[{
     RowBox[{"b", "[", 
      RowBox[{"2", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"dRc", "[", "green", "]"}]}], ",", 
    RowBox[{
     RowBox[{"b", "[", 
      RowBox[{"3", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"dRc", "[", "blue", "]"}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"Hd", "[", "0", "]"}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", 
      RowBox[{"1", ",", "2"}], "]"}], "\[Rule]", 
     RowBox[{"Hd", "[", 
      RowBox[{"-", "1"}], "]"}]}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Invariants", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"SU3", ",", "SU2", ",", "U1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"repL", ",", "repNc", ",", "repHu"}], "}"}]}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", "\[Nu]L"}], ",", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "2"}], "]"}], "\[Rule]", "eL"}], ",", 
    RowBox[{
     RowBox[{"b", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", "\[Nu]Rc"}], ",", 
    RowBox[{
     RowBox[{"c", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"Hu", "[", "1", "]"}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", 
      RowBox[{"1", ",", "2"}], "]"}], "\[Rule]", 
     RowBox[{"Hu", "[", "0", "]"}]}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Invariants", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"SU3", ",", "SU2", ",", "U1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"repL", ",", "repEc", ",", "repHd"}], "}"}]}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", "\[Nu]L"}], ",", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "2"}], "]"}], "\[Rule]", "eL"}], ",", 
    RowBox[{
     RowBox[{"b", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", "eRc"}], ",", 
    RowBox[{
     RowBox[{"c", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", 
     RowBox[{"Hd", "[", "0", "]"}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", 
      RowBox[{"1", ",", "2"}], "]"}], "\[Rule]", 
     RowBox[{"Hd", "[", 
      RowBox[{"-", "1"}], "]"}]}]}], "}"}]}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->222557021,ExpressionUUID->"2f6b821f-25f8-4432-80e1-c35f47df5122"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"dL", "[", "blue", "]"}], " ", 
    RowBox[{"Hu", "[", "1", "]"}], " ", 
    RowBox[{"uRc", "[", "blue", "]"}]}], "-", 
   RowBox[{
    RowBox[{"Hu", "[", "0", "]"}], " ", 
    RowBox[{"uL", "[", "blue", "]"}], " ", 
    RowBox[{"uRc", "[", "blue", "]"}]}], "+", 
   RowBox[{
    RowBox[{"dL", "[", "green", "]"}], " ", 
    RowBox[{"Hu", "[", "1", "]"}], " ", 
    RowBox[{"uRc", "[", "green", "]"}]}], "-", 
   RowBox[{
    RowBox[{"Hu", "[", "0", "]"}], " ", 
    RowBox[{"uL", "[", "green", "]"}], " ", 
    RowBox[{"uRc", "[", "green", "]"}]}], "+", 
   RowBox[{
    RowBox[{"dL", "[", "red", "]"}], " ", 
    RowBox[{"Hu", "[", "1", "]"}], " ", 
    RowBox[{"uRc", "[", "red", "]"}]}], "-", 
   RowBox[{
    RowBox[{"Hu", "[", "0", "]"}], " ", 
    RowBox[{"uL", "[", "red", "]"}], " ", 
    RowBox[{"uRc", "[", "red", "]"}]}]}], "}"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->832857323,ExpressionUUID->"2d4afd4b-be12-4a82-bb3e-ee76b59540e7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"dL", "[", "blue", "]"}], " ", 
    RowBox[{"dRc", "[", "blue", "]"}], " ", 
    RowBox[{"Hd", "[", "0", "]"}]}], "+", 
   RowBox[{
    RowBox[{"dL", "[", "green", "]"}], " ", 
    RowBox[{"dRc", "[", "green", "]"}], " ", 
    RowBox[{"Hd", "[", "0", "]"}]}], "+", 
   RowBox[{
    RowBox[{"dL", "[", "red", "]"}], " ", 
    RowBox[{"dRc", "[", "red", "]"}], " ", 
    RowBox[{"Hd", "[", "0", "]"}]}], "-", 
   RowBox[{
    RowBox[{"dRc", "[", "blue", "]"}], " ", 
    RowBox[{"Hd", "[", 
     RowBox[{"-", "1"}], "]"}], " ", 
    RowBox[{"uL", "[", "blue", "]"}]}], "-", 
   RowBox[{
    RowBox[{"dRc", "[", "green", "]"}], " ", 
    RowBox[{"Hd", "[", 
     RowBox[{"-", "1"}], "]"}], " ", 
    RowBox[{"uL", "[", "green", "]"}]}], "-", 
   RowBox[{
    RowBox[{"dRc", "[", "red", "]"}], " ", 
    RowBox[{"Hd", "[", 
     RowBox[{"-", "1"}], "]"}], " ", 
    RowBox[{"uL", "[", "red", "]"}]}]}], "}"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->202953586,ExpressionUUID->"d68b6e64-3dd4-4b34-bef6-3ad210285b61"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[Nu]L"}], " ", "\[Nu]Rc", " ", 
    RowBox[{"Hu", "[", "0", "]"}]}], "+", 
   RowBox[{"eL", " ", "\[Nu]Rc", " ", 
    RowBox[{"Hu", "[", "1", "]"}]}]}], "}"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->180275008,ExpressionUUID->"91e3f8ff-0926-4305-b03c-47ed2fd3e859"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "eRc"}], " ", "\[Nu]L", " ", 
    RowBox[{"Hd", "[", 
     RowBox[{"-", "1"}], "]"}]}], "+", 
   RowBox[{"eL", " ", "eRc", " ", 
    RowBox[{"Hd", "[", "0", "]"}]}]}], "}"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->107252272,ExpressionUUID->"7d91b337-a0fb-4e64-95c1-41dad527c546"]
}, Open  ]],

Cell[TextData[{
 "However, it is perfectly acceptable to use other conventions. For example, \
if we were to consider a minus sign in the last two expressions, effectively \
we would be switching the signs of Ye and Y\[Nu]: Ye (new) = - Ye (old) and Y\
\[Nu] (new) = - Y\[Nu] (old). Therefore, we would have the relations \
Yu=Yd=Ye=Y\[Nu] and  Yu=Yd=-1/3 Ye=-1/3 Y\[Nu]. This should be seen as a \
warning that the output of ",
 Cell[BoxData[
 "SubgroupCoefficients"], "InlineFormula",ExpressionUUID->
  "f3f4d10e-4215-4716-958d-f44bdd37cc38"],
 " must be interpreted with care."
}], "ExampleText",
 CellID->29036104,ExpressionUUID->"f6697072-f376-4e26-bd5b-c32b11555ff1"]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"48f5e48b-a68c-495f-bcc7-110916490475"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"3be2eff9-48d4-44bc-952c-73c46dfd59d7"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"98b6bfba-6400-4e22-923a-cb20a8740016"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["DecomposeRep"]],"paclet:GroupMath/ref/DecomposeRep"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"1a94ba60-b8d5-4468-889e-c5a33a51146b"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["RegularSubgroupProjectionMatrix"]],
    "paclet:GroupMath/ref/RegularSubgroupProjectionMatrix"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"3d19a2b9-fda0-46a8-81a1-61bd8745f5ec"]
}], "SeeAlso",
 CellID->1038487239,ExpressionUUID->"94224fc7-681b-4e1c-8e01-29c3e8e65508"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"1058eb5a-35a1-4536-aa2b-9ebb113c3163"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"85b319e7-11a2-445e-b71c-c3ad9d10fceb"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"212fd45e-e99d-4889-a52d-46dffdbe958f"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"6fa79b2f-990f-4cbc-8527-5fe2e3c06c6e"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"7d74c54a-7695-4618-89d3-7277586c56b2"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SubgroupCoefficients",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 14, 27.6148129}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "SubgroupCoefficients[group, representationsList, subgroup, \\ \
breakingInfo] Calculates Georgi\\[Dash]Jarlskog-like relations. For some \
subgroup of group, and for the product of representations of group in \
representationsList, this functions calculates the relation amongst the \
invariants/Clebsch-Gordon coefficients of subgroup imposed by the remaining \
symmetry generators of group which are not part of subgroup. Quick example: \
the 16 and 10 of SO(10) form the a trilinear invariant (16 x 16 x 10). Under \
the subgroup GSM=SU(3)xSU(2)xU(1) of SO(10), these representations break into \
various irreducible representations of GSM, and a total of 17 terms invariant \
only under GSM can be written with these GSM-representations. Since there is \
only one invariant under the full group, SO(10), the coefficients of these 17 \
GSM-invariant terms must be related in an SO(10)-symmetric scenario. \
SubgroupCoefficients returns such relations.", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "SubgroupCoefficients", "titlemodifier" -> 
    "", "windowtitle" -> "SubgroupCoefficients", "type" -> "Symbol", "uri" -> 
    "GroupMath/ref/SubgroupCoefficients", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[26191, 698, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"3180d622-6e53-45e9-97ae-9b414fb5c275",
   CellTags->"PrimaryExamplesSection",
   CellID->499396244]},
 "RasterizedOutput"->{
  Cell[58001, 1484, 4104, 73, 115, "Output",ExpressionUUID->"e05bd11d-146b-4334-8ad3-e8ee9d287e8c",
   CellTags->"RasterizedOutput",
   CellID->329274229],
  Cell[68443, 1755, 11667, 197, 301, "Output",ExpressionUUID->"bd7dd1fb-5af6-46b3-95c3-7a22465273a2",
   CellTags->"RasterizedOutput",
   CellID->542344503],
  Cell[81758, 2006, 11667, 197, 301, "Output",ExpressionUUID->"05c759d3-484e-453d-bf81-de4cd3ee6d0a",
   CellTags->"RasterizedOutput",
   CellID->776004901]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 231232, 5744},
 {"RasterizedOutput", 231431, 5748}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[592, 21, 4261, 96, 53, "AnchorBarGrid",ExpressionUUID->"c21d28cf-8f05-4ab9-8eb5-5a2710168bc0",
 CellID->1],
Cell[CellGroupData[{
Cell[4878, 121, 405, 9, 52, "ObjectNameGrid",ExpressionUUID->"fac35d31-2316-4db2-b7d3-7cca951d84b8"],
Cell[5286, 132, 3102, 70, 295, "Usage",ExpressionUUID->"2d8808d9-eebc-4345-a46d-95c1dbdf1fd3",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[8425, 207, 855, 21, 37, "NotesSection",ExpressionUUID->"e2caf555-d1bb-4477-b901-743343b972a4",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->133061962],
Cell[9283, 230, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"c70e9c26-d1b9-49e9-b704-a8a2979e903f"],
Cell[9372, 232, 511, 10, 70, "Notes",ExpressionUUID->"d4c2ddad-322d-4b68-8ae7-4f75d156becb",
 CellID->46206203],
Cell[9886, 244, 204, 4, 70, "Notes",ExpressionUUID->"0ef5b04e-400c-4857-a851-046c050affbd",
 CellID->182247527],
Cell[10093, 250, 761, 22, 70, "Notes",ExpressionUUID->"60511c9e-97d2-4258-af3e-381165c884c7",
 CellID->1067943069],
Cell[10857, 274, 1064, 29, 70, "Notes",ExpressionUUID->"00c335f2-327f-47e8-8f2c-d74cbe2cace9",
 CellID->52399537],
Cell[11924, 305, 844, 19, 70, "Notes",ExpressionUUID->"bcbcb3c7-d2da-4dd9-b523-c827a9264fbd",
 CellID->784021019],
Cell[12771, 326, 13294, 365, 70, "Notes",ExpressionUUID->"59cb1323-d5c0-42d4-b5b1-52766f2dded9",
 CellID->45496372],
Cell[26068, 693, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"9f1ea6b1-bf8a-4e74-b221-4f9f71b65934"]
}, Closed]],
Cell[CellGroupData[{
Cell[26191, 698, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"3180d622-6e53-45e9-97ae-9b414fb5c275",
 CellTags->"PrimaryExamplesSection",
 CellID->499396244],
Cell[CellGroupData[{
Cell[26651, 713, 308, 7, 29, "ExampleSection",ExpressionUUID->"cb89b141-f67e-4a9b-b76a-99a1234f428f",
 CellID->589262989],
Cell[26962, 722, 324, 5, 76, "ExampleText",ExpressionUUID->"43a21be8-deee-4407-aa07-c71f62ff25a4",
 CellID->19615827],
Cell[27289, 729, 873, 27, 59, "Input",ExpressionUUID->"3f826b1f-0c8e-458f-889d-74ad7f16fa5a",
 CellID->85442412],
Cell[28165, 758, 851, 21, 77, "ExampleText",ExpressionUUID->"8c7df7c4-4359-4756-bf72-ed5d84b4dfb2",
 CellID->147360266],
Cell[CellGroupData[{
Cell[29041, 783, 204, 5, 26, "Input",ExpressionUUID->"e8418c16-468d-4abf-9f21-62565e36551d",
 CellID->276648439],
Cell[29248, 790, 13160, 252, 70, "Output",ExpressionUUID->"fc45a446-23e4-45f4-afa9-fa82f3976233",
 CellID->275772318]
}, Open  ]],
Cell[42423, 1045, 143, 1, 70, "ExampleText",ExpressionUUID->"ef1e2011-895f-423e-92c9-67b2066a72a1",
 CellID->240482480],
Cell[CellGroupData[{
Cell[42591, 1050, 568, 17, 70, "Input",ExpressionUUID->"bb6db65c-8a57-4abb-8c35-8dd77e8e28a9",
 CellID->259293861],
Cell[43162, 1069, 1535, 47, 84, "Output",ExpressionUUID->"b6044c31-60c6-4f46-bf4b-c39c7f5cead5",
 CellID->22030373]
}, Open  ]],
Cell[44712, 1119, 1088, 26, 70, "ExampleText",ExpressionUUID->"69bd67eb-dbfe-413f-8a62-04dd776f145c",
 CellID->490834723],
Cell[CellGroupData[{
Cell[45825, 1149, 238, 6, 70, "Input",ExpressionUUID->"9508c838-78cb-4bd2-9434-0bab258e5da5",
 CellID->27134387],
Cell[46066, 1157, 6165, 137, 509, "Output",ExpressionUUID->"ed478327-d3b8-420f-8e1a-bfe37ca5be2c",
 CellID->492044275]
}, Open  ]],
Cell[52246, 1297, 1054, 28, 70, "ExampleText",ExpressionUUID->"2100828f-b712-4d75-8ba3-3daff64a5f7e",
 CellID->985435234],
Cell[CellGroupData[{
Cell[53325, 1329, 204, 5, 70, "Input",ExpressionUUID->"fbfad0b9-b6da-4909-9de6-6be1f0aa51ad",
 CellID->148666411],
Cell[53532, 1336, 3252, 108, 146, "Output",ExpressionUUID->"b3f4e6a5-06fc-4251-85e5-d744df0fd5f5",
 CellID->564167968]
}, Open  ]],
Cell[56799, 1447, 722, 17, 70, "ExampleText",ExpressionUUID->"c62bcb0f-eefe-44e8-b5ad-8fee60a317ff",
 CellID->4552369],
Cell[CellGroupData[{
Cell[57546, 1468, 452, 14, 70, "Input",ExpressionUUID->"1d30765c-6dd9-4553-99b2-6ba6942c3f23",
 CellID->522541032],
Cell[58001, 1484, 4104, 73, 115, "Output",ExpressionUUID->"e05bd11d-146b-4334-8ad3-e8ee9d287e8c",
 CellTags->"RasterizedOutput",
 CellID->329274229]
}, Open  ]],
Cell[62120, 1560, 1075, 24, 70, "ExampleText",ExpressionUUID->"04acbc06-0bae-4d1f-8f15-03929f2c7021",
 CellID->49186995],
Cell[CellGroupData[{
Cell[63220, 1588, 276, 7, 70, "Input",ExpressionUUID->"b6662cee-3baf-41b5-a489-08f87442e702",
 CellID->97988462],
Cell[63499, 1597, 2229, 73, 84, "Output",ExpressionUUID->"b4b23eb6-1452-4d8f-a7a5-e73d55acf90e",
 CellID->1020355790]
}, Open  ]],
Cell[65743, 1673, 1990, 55, 70, "ExampleText",ExpressionUUID->"6529b912-9631-4276-929d-e7e590c69270",
 CellID->137870151],
Cell[CellGroupData[{
Cell[67758, 1732, 682, 21, 70, "Input",ExpressionUUID->"dce4f96b-a565-4e64-8b96-d135d5e9170f",
 CellID->55378935],
Cell[68443, 1755, 11667, 197, 301, "Output",ExpressionUUID->"bd7dd1fb-5af6-46b3-95c3-7a22465273a2",
 CellTags->"RasterizedOutput",
 CellID->542344503]
}, Open  ]],
Cell[80125, 1955, 558, 13, 70, "ExampleText",ExpressionUUID->"e73fc873-2bb3-4423-a307-9202e66f65b9",
 CellID->332102819],
Cell[CellGroupData[{
Cell[80708, 1972, 1047, 32, 70, "Input",ExpressionUUID->"30df55b8-1c83-4dd5-b04b-185754f09e84",
 CellID->52206020],
Cell[81758, 2006, 11667, 197, 301, "Output",ExpressionUUID->"05c759d3-484e-453d-bf81-de4cd3ee6d0a",
 CellTags->"RasterizedOutput",
 CellID->776004901]
}, Open  ]],
Cell[93440, 2206, 565, 12, 70, "ExampleText",ExpressionUUID->"779b567f-152a-4644-ac60-41190bcd8e77",
 CellID->27014175],
Cell[CellGroupData[{
Cell[94030, 2222, 204, 5, 70, "Input",ExpressionUUID->"a0aa5331-fcff-4436-882a-6357bc302c22",
 CellID->49277989],
Cell[94237, 2229, 2353, 83, 91, "Output",ExpressionUUID->"007369dc-1924-4dad-bbeb-4789aa71ec71",
 CellID->326281188]
}, Open  ]],
Cell[96605, 2315, 1391, 33, 70, "ExampleText",ExpressionUUID->"56f351b0-ed5f-4f32-bbc7-f48dc2396cdf",
 CellID->377252352],
Cell[97999, 2350, 164, 2, 70, "ExampleText",ExpressionUUID->"b5beeb1c-6cd2-49c3-a383-5d7656b4a4c6",
 CellID->409441931],
Cell[CellGroupData[{
Cell[98188, 2356, 2919, 86, 70, "Input",ExpressionUUID->"ae923ce1-d756-4e0e-ac12-f4486cccd232",
 CellID->325694542],
Cell[CellGroupData[{
Cell[101132, 2446, 1186, 36, 70, "Print",ExpressionUUID->"21fd36c2-57d4-4e9b-ba4e-e46674c4ec84",
 CellID->559028900],
Cell[102321, 2484, 21375, 508, 70, "Print",ExpressionUUID->"e4c6775b-0434-4643-90b5-138ea17e8bf8",
 CellID->120921690],
Cell[123699, 2994, 174, 2, 70, "Print",ExpressionUUID->"e41aa28b-d0d4-4bbe-9460-1b2139ebd327",
 CellID->581693393]
}, Open  ]]
}, Open  ]],
Cell[123900, 3000, 1589, 26, 70, "ExampleText",ExpressionUUID->"ac7b333d-ed0b-4959-84a2-2dcccdbedbd2",
 CellID->40659380],
Cell[125492, 3028, 1373, 42, 53, "Output",ExpressionUUID->"8e4a2269-ea49-48c7-8fa9-61d07a8a0f52",
 CellID->20401898],
Cell[126868, 3072, 1374, 42, 53, "Output",ExpressionUUID->"2cd97f98-3f0b-4d33-8558-974c26e4fcf6",
 CellID->201267126],
Cell[128245, 3116, 1359, 42, 53, "Output",ExpressionUUID->"14821e11-b4f2-418a-b22f-4e6ef7374105",
 CellID->99615333],
Cell[129607, 3160, 1341, 41, 53, "Output",ExpressionUUID->"44700bbf-50d1-45d9-abee-727dce690df8",
 CellID->238858373],
Cell[130951, 3203, 500, 8, 70, "ExampleText",ExpressionUUID->"254a97bb-d5ee-4d4c-a7d1-526e4be3e333",
 CellID->83166596],
Cell[131454, 3213, 795, 19, 70, "Input",ExpressionUUID->"691c6d37-3c39-468b-a981-6bda6d9b6492",
 CellID->897575960],
Cell[132252, 3234, 118, 2, 70, "ExampleText",ExpressionUUID->"806ff140-f79f-4db1-9ec9-b09cb85ff1ea",
 CellID->242635841],
Cell[132373, 3238, 816, 20, 70, "Input",ExpressionUUID->"58749966-5c33-48ac-abb0-456ea6897366",
 CellID->48697774],
Cell[133192, 3260, 346, 6, 70, "ExampleText",ExpressionUUID->"712f236e-2b45-487d-9f03-23ff7c5fa6d4",
 CellID->216184249],
Cell[CellGroupData[{
Cell[133563, 3270, 242, 5, 70, "ExampleDelimiter",ExpressionUUID->"6919bfaa-c859-4ca4-8fe2-137df65417e3",
 CellID->197771987],
Cell[133808, 3277, 297, 5, 70, "ExampleText",ExpressionUUID->"84f24623-35af-4193-bbbf-ee6b3f000d18",
 CellID->26134510],
Cell[CellGroupData[{
Cell[134130, 3286, 576, 16, 70, "Input",ExpressionUUID->"527ae235-d038-47ef-b14c-32eefb7713e2",
 CellID->691511790],
Cell[134709, 3304, 595, 19, 35, "Output",ExpressionUUID->"8b5c48c7-ce9c-4a2a-b1ac-36818e5b585f",
 CellID->527729796],
Cell[135307, 3325, 556, 19, 35, "Output",ExpressionUUID->"d81e220c-4af2-4584-92f7-ef53111607ac",
 CellID->2941169]
}, Open  ]],
Cell[135878, 3347, 143, 1, 70, "ExampleText",ExpressionUUID->"62c1071c-a0f6-4fbc-a753-84b448236d94",
 CellID->281445517],
Cell[136024, 3350, 873, 27, 70, "Input",ExpressionUUID->"9059b2fa-3ba9-4682-937c-3b0338e54eac",
 CellID->1908845],
Cell[136900, 3379, 138, 1, 70, "ExampleText",ExpressionUUID->"3cc1ba49-409b-4fed-8dcf-2070ddd62d10",
 CellID->154247179],
Cell[CellGroupData[{
Cell[137063, 3384, 2918, 86, 70, "Input",ExpressionUUID->"aeb7a3cc-1e62-4946-a757-5d77d3ced8a0",
 CellID->28459257],
Cell[CellGroupData[{
Cell[140006, 3474, 1186, 36, 70, "Print",ExpressionUUID->"0a64bfd7-b955-4196-a78f-757d09b080bb",
 CellID->5698085],
Cell[141195, 3512, 64531, 1562, 70, "Print",ExpressionUUID->"5a422f79-2000-47b3-ac29-8cf995574ab0",
 CellID->772047024],
Cell[205729, 5076, 174, 2, 70, "Print",ExpressionUUID->"bb45209d-3e61-42ce-9ffb-8d46ee59e591",
 CellID->213938306]
}, Open  ]]
}, Open  ]],
Cell[205930, 5082, 135, 1, 70, "ExampleText",ExpressionUUID->"c7ab08d1-c97d-4687-8858-e4ea9fb5cdf8",
 CellID->16234398],
Cell[206068, 5085, 2256, 48, 52, "Output",ExpressionUUID->"c78e77f8-5157-4e47-894d-33d649f25299",
 CellID->364487517],
Cell[208327, 5135, 2249, 47, 52, "Output",ExpressionUUID->"dfa59c87-4fcb-4103-8b09-9c3c2cdef6f7",
 CellID->176525280],
Cell[210579, 5184, 2157, 44, 52, "Output",ExpressionUUID->"d9b79b27-afff-4a6e-bc78-0c861ef5d62c",
 CellID->420098858],
Cell[212739, 5230, 2141, 44, 52, "Output",ExpressionUUID->"175209fa-fb92-4e40-beaa-0de690419552",
 CellID->236312083],
Cell[214883, 5276, 415, 6, 70, "ExampleText",ExpressionUUID->"2b79f759-c5fe-47f6-9ece-bee0d25ffd84",
 CellID->53541657],
Cell[215301, 5284, 238, 4, 70, "ExampleText",ExpressionUUID->"5a36d42b-5430-4518-bfec-407caf7d670d",
 CellID->795546701],
Cell[CellGroupData[{
Cell[215564, 5292, 7237, 229, 70, "Input",ExpressionUUID->"2f6b821f-25f8-4432-80e1-c35f47df5122",
 CellID->222557021],
Cell[222804, 5523, 1015, 28, 68, "Output",ExpressionUUID->"2d4afd4b-be12-4a82-bb3e-ee76b59540e7",
 CellID->832857323],
Cell[223822, 5553, 1078, 31, 68, "Output",ExpressionUUID->"d68b6e64-3dd4-4b34-bef6-3ad210285b61",
 CellID->202953586],
Cell[224903, 5586, 339, 9, 35, "Output",ExpressionUUID->"91e3f8ff-0926-4305-b03c-47ed2fd3e859",
 CellID->180275008],
Cell[225245, 5597, 352, 10, 35, "Output",ExpressionUUID->"7d91b337-a0fb-4e64-95c1-41dad527c546",
 CellID->107252272]
}, Open  ]],
Cell[225612, 5610, 673, 12, 70, "ExampleText",ExpressionUUID->"f6697072-f376-4e26-bd5b-c32b11555ff1",
 CellID->29036104]
}, Open  ]]
}, Open  ]],
Cell[226312, 5626, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"48f5e48b-a68c-495f-bcc7-110916490475"]
}, Open  ]],
Cell[CellGroupData[{
Cell[226435, 5631, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"98b6bfba-6400-4e22-923a-cb20a8740016",
 CellID->1255426704],
Cell[226698, 5640, 777, 19, 70, "SeeAlso",ExpressionUUID->"94224fc7-681b-4e1c-8e01-29c3e8e65508",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[227512, 5664, 262, 7, 70, "TutorialsSection",ExpressionUUID->"85b319e7-11a2-445e-b71c-c3ad9d10fceb",
 CellID->250839057],
Cell[227777, 5673, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"212fd45e-e99d-4889-a52d-46dffdbe958f"],
Cell[227866, 5675, 241, 5, 70, "Tutorials",ExpressionUUID->"6fa79b2f-990f-4cbc-8527-5fe2e3c06c6e",
 CellID->341631938]
}, Open  ]],
Cell[228122, 5683, 78, 0, 70, "FooterCell",ExpressionUUID->"7d74c54a-7695-4618-89d3-7277586c56b2"]
}
]
*)

(* End of internal cache information *)

