(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     39360,       1111]
NotebookOptionsPosition[     31346,        938]
NotebookOutlinePosition[     33814,        998]
CellTagsIndexPosition[     33729,        993]
WindowTitle->SnIrrepGenerators
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "d4529b82-bee8-434b-b148-8824e88cb212"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"d84834a5-cd18-4884-8673-7b6886b827e3"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "872bcd6d-7995-4e60-8300-789876d14e41"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"ec8bfa72-d7e6-4c0b-bc2e-0a5ac7da8bbc"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"SnClassCharacter\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/SnClassCharacter"], "\<\"SnClassOrder\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/SnClassOrder"], "\<\"SnIrrepDim\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/SnIrrepDim"], "\<\"Invariants\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/ref/Invariants"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "f18d1c2e-e382-4482-bb5d-55cb72ae70e0"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"5ec04b04-592d-45d4-b993-0a0299039e3b"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/SnIrrepGenerators\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/SnIrrepGenerators"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
SnIrrepGenerators.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$30410], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/SnIrrepGenerators", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ffbb9d51-afee-4bfd-bc57-af26546583ed"]
    }], "AnchorBar",ExpressionUUID->"d99092a3-63d7-49c8-8153-d99f38b8b677"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"f8303baa-1671-4a34-81c4-8f67f3623ff2"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["SnIrrepGenerators", "ObjectName",ExpressionUUID->
  "93526734-322f-46c7-bf41-6fe30138aec9"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"03570041-11f1-4668-b359-fe2d5b2e7c43"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "dd4e9097-b5c7-470d-95cc-16074a71c0d2"]
}], "ObjectNameGrid",ExpressionUUID->"1f75640c-ba99-48a7-8c19-d23aa01ed84b"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SnIrrepGenerators", "[", "representation", "]"}]], 
      "InlineFormula",ExpressionUUID->"0cf473d2-912e-4e7b-b8ba-4b0345b3d9a9"],
     " \[LineSeparator]Calculates the representation matrices of the (12) and \
(12...n) elements of the ",
     Cell[BoxData[
      SubscriptBox["S", "n"]], "InlineFormula",ExpressionUUID->
      "0141e2ae-6390-4201-9856-c60f40fdc033"],
     " group"
    }],ExpressionUUID->"2baddfb7-6a26-422c-a7ad-8a77f23eea64"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"81861ef4-6e8e-4e28-87cb-24d77043e9f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"11556c2d-ea4f-4be7-895d-f7bd289cfa00"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"b53ea11c-4430-4075-9923-4be80c18767a"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"c5eda9a7-f706-4a67-8b65-64c839a83a95"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->49283700,ExpressionUUID->"1ae5205b-a749-42c1-bbd3-d5ad4e254834"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"30a98412-2251-46a5-90b4-0e8e13d4799f"],

Cell[TextData[{
 Cell[BoxData[
 "representation"], "InlineFormula",ExpressionUUID->
  "f3c1c187-23cf-4e7a-9369-00776f329fa4"],
 " must be a partition of some integer n, as irreducible representations of  ",
 Cell[BoxData[
  SubscriptBox["S", "n"]], "InlineFormula",ExpressionUUID->
  "2bf48fac-93c7-40ae-b10d-4ac88a09b71d"],
 " are specified in this way;"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"698355c8-f112-40b9-bfdc-eae838d3458c"],

Cell[TextData[{
 "Note that for any n, it is possible to generate all  ",
 Cell[BoxData[
  SubscriptBox["S", "n"]], "InlineFormula",ExpressionUUID->
  "e3745608-31f2-4cab-9fa7-58919553eeca"],
 " group elements by repeatedly multiplying just the (12) and (12...n) \
elements in all possible ways."
}], "Notes",
 CellID->239732298,ExpressionUUID->"955c6669-c662-4d8b-896d-4e49ece12216"],

Cell[TextData[{
 "This function returns two real orthogonal/unitary matrices which are the \
representation matrices of the elements (12) and (12...n) of the ",
 Cell[BoxData[
  SubscriptBox["S", "n"]], "InlineFormula",ExpressionUUID->
  "a7ebe25c-d2a0-4693-9e34-2060d93e126a"],
 " group. If orthogonality is not required, the option ",
 StyleBox["OrthogonalizeGenerators\[Rule]False", "InlineCode"],
 " can be used \[LongDash] the resulting matrices have less complicated \
values, and the code is executed more quickly."
}], "Notes",
 CellID->100129342,ExpressionUUID->"8662455a-c210-4a55-ae61-45e684456fc9"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"6dcfa3aa-f61e-406b-bb48-1d8481a43776"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"ee894968-e493-4750-a8a2-177d432f98bb"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount",ExpressionUUID->
  "0ed7efd8-a1a9-4e2a-bfaa-0a95468497b5"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->50502635,ExpressionUUID->"9dcbe47d-ed6c-4172-bc7d-fe96e92dbded"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "40ffb427-3ab3-49ae-b915-fdfb64702987"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->90195699,ExpressionUUID->"79eafe8b-d4f4-4a02-bda5-e75e2508a54a"],

Cell[TextData[{
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula",ExpressionUUID->
  "2a527b74-8b9f-4f22-9c33-54fedb86d097"],
 " has 3 irreducible representations: {3}, {2,1}, {1,1,1}. For example the \
elements (12) and (123) of the irrep {2,1} can be written as follows:"
}], "ExampleText",
 CellID->447494391,ExpressionUUID->"8bbab751-b49e-461c-aa52-dd50876d8a91"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"gens", "=", 
   RowBox[{"SnIrrepGenerators", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "/@", "gens"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->640503189,ExpressionUUID->"9e4d40dd-e57d-4729-a538-f50f53b364f9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", "2"], 
        RowBox[{"-", 
         FractionBox[
          SqrtBox["3"], "2"]}]},
       {
        RowBox[{"-", 
         FractionBox[
          SqrtBox["3"], "2"]}], 
        RowBox[{"-", 
         FractionBox["1", "2"]}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox["1", "2"]}], 
        FractionBox[
         SqrtBox["3"], "2"]},
       {
        RowBox[{"-", 
         FractionBox[
          SqrtBox["3"], "2"]}], 
        RowBox[{"-", 
         FractionBox["1", "2"]}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->120033565,ExpressionUUID->"e733d49c-ad9e-44f9-89bb-abc7c67cccec"]
}, Open  ]],

Cell["\<\
By multiplying repeatedly these matrices together we get 6 matrices:\
\>", "ExampleText",
 CellID->32979335,ExpressionUUID->"f51c4228-c0a3-4688-ba89-61f260f2af92"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"FixedPoint", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sort", "[", 
      RowBox[{"DeleteDuplicates", "[", 
       RowBox[{"Join", "[", 
        RowBox[{"#", ",", 
         RowBox[{"Dot", "@@@", 
          RowBox[{"Tuples", "[", 
           RowBox[{"#", ",", "2"}], "]"}]}]}], "]"}], "]"}], "]"}], "&"}], 
    ",", "gens"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->281335393,ExpressionUUID->"3b2fe03d-c04b-462a-b9a5-e1b79d3501d6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "1"}], "0"},
       {"0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox["1", "2"]}], 
        RowBox[{"-", 
         FractionBox[
          SqrtBox["3"], "2"]}]},
       {
        FractionBox[
         SqrtBox["3"], "2"], 
        RowBox[{"-", 
         FractionBox["1", "2"]}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox["1", "2"]}], 
        FractionBox[
         SqrtBox["3"], "2"]},
       {
        RowBox[{"-", 
         FractionBox[
          SqrtBox["3"], "2"]}], 
        RowBox[{"-", 
         FractionBox["1", "2"]}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", "2"], 
        RowBox[{"-", 
         FractionBox[
          SqrtBox["3"], "2"]}]},
       {
        RowBox[{"-", 
         FractionBox[
          SqrtBox["3"], "2"]}], 
        RowBox[{"-", 
         FractionBox["1", "2"]}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", "2"], 
        FractionBox[
         SqrtBox["3"], "2"]},
       {
        FractionBox[
         SqrtBox["3"], "2"], 
        RowBox[{"-", 
         FractionBox["1", "2"]}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->2126672,ExpressionUUID->"bab6832a-80fe-4984-aa19-5267859d5cb5"]
}, Open  ]],

Cell[TextData[{
 "If the representation does not need to be unitary, then we can use the \
option ",
 StyleBox["OrthogonalizeGenerators", "InlineCode"],
 ":"
}], "ExampleText",
 CellID->20498925,ExpressionUUID->"0a554296-25b7-4a81-adee-1f14d6109ac6"],

Cell[CellGroupData[{

Cell["\<\
gens=SnIrrepGenerators[{2,1},OrthogonalizeGenerators\[Rule]False];
MatrixForm/@gens\
\>", "Input",
 CellLabel->"In[3]:=",
 CellID->91661810,ExpressionUUID->"15ea133e-cf8d-4b9e-a4a8-144a178d43ef"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {
        RowBox[{"-", "1"}], 
        RowBox[{"-", "1"}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1"},
       {
        RowBox[{"-", "1"}], 
        RowBox[{"-", "1"}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->34811079,ExpressionUUID->"eca5011f-0e82-4815-9f5e-6b029a566518"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "7eead9b3-c80f-4a59-82bc-2b798cfbd551"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324607423,ExpressionUUID->"eb7ed735-3039-459f-ae0f-4d9a32e3d4e3"],

Cell[TextData[{
 "The function ",
 StyleBox["SnIrrepGenerators", "InlineCode"],
 " works even for very big irreducible representations of ",
 Cell[BoxData[
  SubscriptBox["S", "n"]], "InlineFormula",ExpressionUUID->
  "680e5f0f-f17c-4d5d-ac40-6baa6b6619e1"],
 ". For example, it can compute the representation matrices of the \
42-dimension representation {3,3,2} of ",
 Cell[BoxData[
  SubscriptBox["S", "8"]], "InlineFormula",ExpressionUUID->
  "12ad0637-ae63-4cf2-ab6f-7bbe3e9f1190"],
 ". Note however that a significant amount of time is used orthogonalizing \
the resulting matrices, so if this is not required, the option ",
 StyleBox["OrthogonalizeGenerators", "InlineCode"],
 " should be used:"
}], "ExampleText",
 CellID->42214145,ExpressionUUID->"8fa8f239-3307-4804-85a0-e566f7a20efc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{"SnIrrepGenerators", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3", ",", "2"}], "}"}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->333761032,ExpressionUUID->"03cd5140-2b66-48ff-ac7f-b8b67957c11a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"182.2294969`", ",", "Null"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->258338573,ExpressionUUID->"1ad4f9de-c9d0-48c7-9fdd-ffe69ff13b27"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{"SnIrrepGenerators", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "2"}], "}"}], ",", 
     RowBox[{"OrthogonalizeGenerators", "\[Rule]", "False"}]}], "]"}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->616528551,ExpressionUUID->"e07807b1-d925-4617-a1ec-58b1c020e44d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5419134`", ",", "Null"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->189540148,ExpressionUUID->"900b8c4d-ff1a-4342-9062-c9834c427fee"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Properties & Relations",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "394e5d0f-e55a-44dd-a2fa-6b1c3b852ea1"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2123667759,ExpressionUUID->"1812d429-cd2d-45d9-b96f-c7292cc1548a"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["Invariants"]],"paclet:GroupMath/ref/Invariants"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "aa44cc20-ec6a-4d96-b3b7-18fa806691ad"],
 " calculates explicitly the invariant combinations of some representations \
of a Lie group. If some of the representations are repeated, it will use ",
 Cell[BoxData[
 "SnIrrepGenerators"], "InlineFormula",ExpressionUUID->
  "3fab784a-d9f1-4aba-845a-70270ab3b6c3"],
 " to ensure a very specific transformation of these invariant combinations \
under permutations of the repeated representations."
}], "Notes",
 CellID->43954176,ExpressionUUID->"36fbce92-dc47-402d-a8cd-14bdc33fd8ab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"invariantsOf4Doublets", "=", 
  RowBox[{"Invariants", "[", 
   RowBox[{"SU2", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "1", "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->376133771,ExpressionUUID->"cbde9bb4-183d-4885-9a11-a7c538112900"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"a", "[", "2", "]"}], " ", 
       RowBox[{"b", "[", "2", "]"}], " ", 
       RowBox[{"c", "[", "1", "]"}], " ", 
       RowBox[{"d", "[", "1", "]"}]}], 
      SqrtBox["3"]]}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"a", "[", "2", "]"}], " ", 
      RowBox[{"b", "[", "1", "]"}], " ", 
      RowBox[{"c", "[", "2", "]"}], " ", 
      RowBox[{"d", "[", "1", "]"}]}], 
     SqrtBox["3"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], " ", 
      RowBox[{"b", "[", "2", "]"}], " ", 
      RowBox[{"c", "[", "2", "]"}], " ", 
      RowBox[{"d", "[", "1", "]"}]}], 
     SqrtBox["3"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"a", "[", "2", "]"}], " ", 
      RowBox[{"b", "[", "1", "]"}], " ", 
      RowBox[{"c", "[", "1", "]"}], " ", 
      RowBox[{"d", "[", "2", "]"}]}], 
     SqrtBox["3"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], " ", 
      RowBox[{"b", "[", "2", "]"}], " ", 
      RowBox[{"c", "[", "1", "]"}], " ", 
      RowBox[{"d", "[", "2", "]"}]}], 
     SqrtBox["3"]], "-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"a", "[", "1", "]"}], " ", 
      RowBox[{"b", "[", "1", "]"}], " ", 
      RowBox[{"c", "[", "2", "]"}], " ", 
      RowBox[{"d", "[", "2", "]"}]}], 
     SqrtBox["3"]]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"a", "[", "2", "]"}], " ", 
      RowBox[{"b", "[", "2", "]"}], " ", 
      RowBox[{"c", "[", "1", "]"}], " ", 
      RowBox[{"d", "[", "1", "]"}]}], 
     SqrtBox["3"]], "-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"a", "[", "2", "]"}], " ", 
      RowBox[{"b", "[", "1", "]"}], " ", 
      RowBox[{"c", "[", "2", "]"}], " ", 
      RowBox[{"d", "[", "1", "]"}]}], 
     SqrtBox["3"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], " ", 
      RowBox[{"b", "[", "2", "]"}], " ", 
      RowBox[{"c", "[", "2", "]"}], " ", 
      RowBox[{"d", "[", "1", "]"}]}], 
     SqrtBox["3"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"a", "[", "2", "]"}], " ", 
      RowBox[{"b", "[", "1", "]"}], " ", 
      RowBox[{"c", "[", "1", "]"}], " ", 
      RowBox[{"d", "[", "2", "]"}]}], 
     SqrtBox["3"]], "-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"a", "[", "1", "]"}], " ", 
      RowBox[{"b", "[", "2", "]"}], " ", 
      RowBox[{"c", "[", "1", "]"}], " ", 
      RowBox[{"d", "[", "2", "]"}]}], 
     SqrtBox["3"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], " ", 
      RowBox[{"b", "[", "1", "]"}], " ", 
      RowBox[{"c", "[", "2", "]"}], " ", 
      RowBox[{"d", "[", "2", "]"}]}], 
     SqrtBox["3"]]}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->248220564,ExpressionUUID->"3af998e8-fc27-43dc-8543-02ffde3aef15"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"s4IrrepGenerators", "=", 
   RowBox[{"SnIrrepGenerators", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"OrthogonalizeGenerators", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "/@", "S4IrrepGenerators"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->49844007,ExpressionUUID->"41e3da60-27ce-4660-b01d-d327b30830b3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {
        RowBox[{"-", "1"}], 
        RowBox[{"-", "1"}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "1"}], 
        RowBox[{"-", "1"}]},
       {"0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->81360911,ExpressionUUID->"35ae1a22-bd06-4616-b828-55a3c34c8a6c"]
}, Open  ]],

Cell[TextData[{
 "Check that the effect of changing {a\[Rule]b,b\[Rule]a} and {a\[Rule]b,b\
\[Rule]c,c\[Rule]d,d\[Rule]a} is the same as applying the first and second ",
 Cell[BoxData[
 "s4IrrepGenerators"], "InlineFormula",ExpressionUUID->
  "72995270-bff0-472b-b649-b18bb5aa1824"],
 " to the invariants:"
}], "Notes",
 CellID->378438895,ExpressionUUID->"cd6a13fd-e01c-4a3f-ba5d-617ee5349e51"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"s4IrrepGenerators", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ".", "invariantsOf4Doublets"}], "==", 
   RowBox[{"(", 
    RowBox[{"invariantsOf4Doublets", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "b"}], ",", 
       RowBox[{"b", "\[Rule]", "a"}]}], "}"}]}], ")"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"s4IrrepGenerators", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ".", "invariantsOf4Doublets"}], "==", 
   RowBox[{"(", 
    RowBox[{"invariantsOf4Doublets", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "b"}], ",", 
       RowBox[{"b", "\[Rule]", "c"}], ",", 
       RowBox[{"c", "\[Rule]", "d"}], ",", 
       RowBox[{"d", "\[Rule]", "a"}]}], "}"}]}], ")"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->217712811,ExpressionUUID->"f9c9cd02-a0c1-4e31-8e55-148f0ad7bd82"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[3]=",
 CellID->171240538,ExpressionUUID->"8cfe2c1d-4413-4f81-b989-b39879282a5b"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[3]=",
 CellID->46927186,ExpressionUUID->"f83f6354-0e32-4659-b5dd-8a084d16d89e"]
}, Open  ]],

Cell[TextData[{
 "This is so by construction. The function ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["Invariants"]],"paclet:GroupMath/ref/Invariants"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "519e40ee-3959-4faf-a6ac-60ce17c5d6be"],
 " works analogously for any other situation where there are repeated \
representations being multiplied."
}], "Notes",
 CellID->547357535,ExpressionUUID->"acd5539f-538d-44fc-ad21-3797672df4eb"]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"71c6e773-a15d-4599-a2ff-91fc5be87c66"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"0007abe3-a9e7-47e8-9f98-36184e4081eb"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"df25e53d-8564-4b3c-80d5-3d8134e3bfda"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["SnClassCharacter"]],"paclet:GroupMath/ref/SnClassCharacter"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"4556f2d8-4a71-4549-9a19-3987e09b00fe"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["SnClassOrder"]],"paclet:GroupMath/ref/SnClassOrder"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"2bede54f-86f1-4b4d-901e-6f95a472e69c"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["SnIrrepDim"]],"paclet:GroupMath/ref/SnIrrepDim"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"b13f5928-c672-414d-be14-53a4a3aaa5c7"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["Invariants"]],"paclet:GroupMath/ref/Invariants"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"a5f2da88-ba90-434d-b717-6143af167f4d"]
}], "SeeAlso",
 CellID->929782353,ExpressionUUID->"2c6f13f3-227b-48ac-82bd-e7b99a055f27"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"d82b1e85-03e9-49fb-bc89-cd81ca2f5b49"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"9466f0c7-b40a-41d6-824a-a7b433d235b4"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"20f4c361-cdbc-4beb-bfd4-615978d9d171"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"a47f336b-37ca-443d-8ab7-e4412032a20e"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"1cb1f809-059b-45ae-b4ca-1b937068ad4c"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SnIrrepGenerators",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 14, 24.7377250}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "SnIrrepGenerators[representation] Calculates the representation matrices \
of the (12) and (12...n) elements of the Sn group", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "SnIrrepGenerators", "titlemodifier" -> "", 
    "windowtitle" -> "SnIrrepGenerators", "type" -> "Symbol", "uri" -> 
    "GroupMath/ref/SnIrrepGenerators", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8690, 220, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"9dcbe47d-ed6c-4172-bc7d-fe96e92dbded",
   CellTags->"PrimaryExamplesSection",
   CellID->50502635]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33532, 986}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[589, 21, 4415, 99, 53, "AnchorBarGrid",ExpressionUUID->"f8303baa-1671-4a34-81c4-8f67f3623ff2",
 CellID->1],
Cell[CellGroupData[{
Cell[5029, 124, 402, 9, 52, "ObjectNameGrid",ExpressionUUID->"1f75640c-ba99-48a7-8c19-d23aa01ed84b"],
Cell[5434, 135, 703, 15, 110, "Usage",ExpressionUUID->"81861ef4-6e8e-4e28-87cb-24d77043e9f8",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6174, 155, 854, 21, 37, "NotesSection",ExpressionUUID->"1ae5205b-a749-42c1-bbd3-d5ad4e254834",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->49283700],
Cell[7031, 178, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"30a98412-2251-46a5-90b4-0e8e13d4799f"],
Cell[7120, 180, 444, 10, 70, "Notes",ExpressionUUID->"698355c8-f112-40b9-bfdc-eae838d3458c",
 CellID->1067943069],
Cell[7567, 192, 384, 8, 70, "Notes",ExpressionUUID->"955c6669-c662-4d8b-896d-4e49ece12216",
 CellID->239732298],
Cell[7954, 202, 610, 11, 70, "Notes",ExpressionUUID->"8662455a-c210-4a55-ae61-45e684456fc9",
 CellID->100129342],
Cell[8567, 215, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"6dcfa3aa-f61e-406b-bb48-1d8481a43776"]
}, Closed]],
Cell[CellGroupData[{
Cell[8690, 220, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"9dcbe47d-ed6c-4172-bc7d-fe96e92dbded",
 CellTags->"PrimaryExamplesSection",
 CellID->50502635],
Cell[CellGroupData[{
Cell[9149, 235, 307, 7, 29, "ExampleSection",ExpressionUUID->"79eafe8b-d4f4-4a02-bda5-e75e2508a54a",
 CellID->90195699],
Cell[9459, 244, 375, 7, 57, "ExampleText",ExpressionUUID->"8bbab751-b49e-461c-aa52-dd50876d8a91",
 CellID->447494391],
Cell[CellGroupData[{
Cell[9859, 255, 329, 8, 43, "Input",ExpressionUUID->"9e4d40dd-e57d-4729-a538-f50f53b364f9",
 CellID->640503189],
Cell[10191, 265, 1584, 52, 78, "Output",ExpressionUUID->"e733d49c-ad9e-44f9-89bb-abc7c67cccec",
 CellID->120033565]
}, Open  ]],
Cell[11790, 320, 173, 3, 38, "ExampleText",ExpressionUUID->"f51c4228-c0a3-4688-ba89-61f260f2af92",
 CellID->32979335],
Cell[CellGroupData[{
Cell[11988, 327, 499, 14, 43, "Input",ExpressionUUID->"3b2fe03d-c04b-462a-b9a5-e1b79d3501d6",
 CellID->281335393],
Cell[12490, 343, 3975, 129, 78, "Output",ExpressionUUID->"bab6832a-80fe-4984-aa19-5267859d5cb5",
 CellID->2126672]
}, Open  ]],
Cell[16480, 475, 250, 6, 57, "ExampleText",ExpressionUUID->"0a554296-25b7-4a81-adee-1f14d6109ac6",
 CellID->20498925],
Cell[CellGroupData[{
Cell[16755, 485, 205, 5, 41, "Input",ExpressionUUID->"15ea133e-cf8d-4b9e-a4a8-144a178d43ef",
 CellID->91661810],
Cell[16963, 492, 1234, 38, 48, "Output",ExpressionUUID->"eca5011f-0e82-4815-9f5e-6b029a566518",
 CellID->34811079]
}, Open  ]],
Cell[CellGroupData[{
Cell[18234, 535, 242, 5, 70, "ExampleDelimiter",ExpressionUUID->"eb7ed735-3039-459f-ae0f-4d9a32e3d4e3",
 CellID->324607423],
Cell[18479, 542, 795, 17, 70, "ExampleText",ExpressionUUID->"8fa8f239-3307-4804-85a0-e566f7a20efc",
 CellID->42214145],
Cell[CellGroupData[{
Cell[19299, 563, 289, 7, 70, "Input",ExpressionUUID->"03cd5140-2b66-48ff-ac7f-b8b67957c11a",
 CellID->333761032],
Cell[19591, 572, 185, 4, 35, "Output",ExpressionUUID->"1ad4f9de-c9d0-48c7-9fdd-ffe69ff13b27",
 CellID->258338573]
}, Open  ]],
Cell[CellGroupData[{
Cell[19813, 581, 377, 10, 70, "Input",ExpressionUUID->"e07807b1-d925-4617-a1ec-58b1c020e44d",
 CellID->616528551],
Cell[20193, 593, 183, 4, 35, "Output",ExpressionUUID->"900b8c4d-ff1a-4342-9062-c9834c427fee",
 CellID->189540148]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20437, 604, 317, 7, 70, "ExampleSection",ExpressionUUID->"1812d429-cd2d-45d9-b96f-c7292cc1548a",
 CellID->2123667759],
Cell[20757, 613, 745, 16, 70, "Notes",ExpressionUUID->"36fbce92-dc47-402d-a8cd-14bdc33fd8ab",
 CellID->43954176],
Cell[CellGroupData[{
Cell[21527, 633, 409, 11, 70, "Input",ExpressionUUID->"cbde9bb4-183d-4885-9a11-a7c538112900",
 CellID->376133771],
Cell[21939, 646, 2910, 91, 173, "Output",ExpressionUUID->"3af998e8-fc27-43dc-8543-02ffde3aef15",
 CellID->248220564]
}, Open  ]],
Cell[CellGroupData[{
Cell[24886, 742, 442, 11, 70, "Input",ExpressionUUID->"41e3da60-27ce-4660-b01d-d327b30830b3",
 CellID->49844007],
Cell[25331, 755, 1234, 38, 48, "Output",ExpressionUUID->"35ae1a22-bd06-4616-b828-55a3c34c8a6c",
 CellID->81360911]
}, Open  ]],
Cell[26580, 796, 394, 8, 70, "Notes",ExpressionUUID->"cd6a13fd-e01c-4a3f-ba5d-617ee5349e51",
 CellID->378438895],
Cell[CellGroupData[{
Cell[26999, 808, 976, 27, 70, "Input",ExpressionUUID->"f9c9cd02-a0c1-4e31-8e55-148f0ad7bd82",
 CellID->217712811],
Cell[27978, 837, 129, 2, 35, "Output",ExpressionUUID->"8cfe2c1d-4413-4f81-b989-b39879282a5b",
 CellID->171240538],
Cell[28110, 841, 128, 2, 35, "Output",ExpressionUUID->"f83f6354-0e32-4659-b5dd-8a084d16d89e",
 CellID->46927186]
}, Open  ]],
Cell[28253, 846, 482, 11, 70, "Notes",ExpressionUUID->"acd5539f-538d-44fc-ad21-3797672df4eb",
 CellID->547357535]
}, Closed]],
Cell[28750, 860, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"71c6e773-a15d-4599-a2ff-91fc5be87c66"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28873, 865, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"df25e53d-8564-4b3c-80d5-3d8134e3bfda",
 CellID->1255426704],
Cell[29136, 874, 1481, 38, 70, "SeeAlso",ExpressionUUID->"2c6f13f3-227b-48ac-82bd-e7b99a055f27",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[30654, 917, 262, 7, 70, "TutorialsSection",ExpressionUUID->"9466f0c7-b40a-41d6-824a-a7b433d235b4",
 CellID->250839057],
Cell[30919, 926, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"20f4c361-cdbc-4beb-bfd4-615978d9d171"],
Cell[31008, 928, 241, 5, 70, "Tutorials",ExpressionUUID->"a47f336b-37ca-443d-8ab7-e4412032a20e",
 CellID->341631938]
}, Open  ]],
Cell[31264, 936, 78, 0, 70, "FooterCell",ExpressionUUID->"1cb1f809-059b-45ae-b4ca-1b937068ad4c"]
}
]
*)

(* End of internal cache information *)

