(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     31533,        882]
NotebookOptionsPosition[     23618,        713]
NotebookOutlinePosition[     26049,        773]
CellTagsIndexPosition[     25964,        768]
WindowTitle->RepsUpToDimN
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "937adbb6-4b8f-475f-96d6-64d4e66ea585"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"e6800ac2-6fee-4d64-a5f9-33308149e7ca"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "934e72d4-0e56-46fd-aab2-fea3d991b05a"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"0f857d19-d1b1-4b00-b056-946867d9bd14"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"DimR\"\>":>Documentation`HelpLookup[
       "paclet:GroupMath/ref/DimR"], "\<\"RepName\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/RepName"], "\<\"RepsUpToDimNNoConjugates\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/RepsUpToDimNNoConjugates"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "f92cec22-f1f4-4fa3-9d74-e1f6e49ab67d"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"c9da144b-bef2-425f-a07a-45c82ad0d5fe"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/RepsUpToDimN\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/RepsUpToDimN"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
RepsUpToDimN.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$26734], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/RepsUpToDimN", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "d69f0f20-0dca-463c-af79-59602a3604ce"]
    }], "AnchorBar",ExpressionUUID->"1d2b77b2-b60e-41d2-bc8b-3b4c290aa789"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"bb5e8d7a-6779-4476-8db3-fa3fa0856f54"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["RepsUpToDimN", "ObjectName",ExpressionUUID->
  "24cc9f96-990b-4612-b592-f14199273618"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"871f6abe-83c8-49d1-813b-991c2e9f1317"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "63564603-d41b-4b9b-9e93-5766fc1ce19e"]
}], "ObjectNameGrid",ExpressionUUID->"2416cdcc-dd11-4022-96c4-a26264f211e4"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RepsUpToDimN", "[", 
       RowBox[{"group", ",", " ", "maxDim"}], "]"}]], "InlineFormula",
      ExpressionUUID->"862701f7-bb30-4d28-828b-3033e568e223"],
     " \[LineSeparator]Lists all representations of ",
     Cell[BoxData[
     "group"], "InlineFormula",ExpressionUUID->
      "05a92fa2-cf9e-4146-8b16-b353329c9969"],
     " with dimension smaller or equal to ",
     Cell[BoxData[
     "maxDim"], "InlineFormula",ExpressionUUID->
      "3798c582-c5fc-4eb4-adf1-ce31bca2b3f8"],
     " "
    }],ExpressionUUID->"0b57f58f-efb9-4f25-bfb7-48862c8db523"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"ad24bb0a-dd9c-46cb-9748-f0bf47a65bed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"e321ed20-b9b4-4577-aac7-889e5d57f572"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"69f9a30a-2ecf-43e8-8d3b-73cb303efd63"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"03d67c95-43c3-424b-b249-122bd5060a40"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->205872487,ExpressionUUID->"2cd2b3e0-b919-40a7-864b-f30d044fd93b"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"a676cd9f-b102-4aa5-a0a6-3b97ebf3a0f7"],

Cell[TextData[{
 "Argument ",
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "62761e03-883e-4a55-8e8f-9d007a80ea34"],
 " should be the ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/ref/CartanMatrix"],
 " of the group."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"c2d3ed88-1162-4969-b89c-880f316c7229"],

Cell[TextData[{
 "This method outputs a list o representations, each given by its Dynkin \
coefficients. The option ",
 Cell[BoxData[
  RowBox[{"UseName", "->", "True"}]], "InlineFormula",ExpressionUUID->
  "56147dce-fb16-4860-a55f-df38d4a61488"],
 " can be used to get the names of the representations instead (as given by \
the ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["RepName"]],"paclet:GroupMath/ref/RepName"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "fdb00bc8-4991-45e1-b0c7-2c7bcfbead59"],
 " function)."
}], "Notes",
 CellID->159441392,ExpressionUUID->"d3a4e015-ed30-4b61-af7e-b766e0e0754f"],

Cell[TextData[{
 "Unlike the function ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["RepsUpToDimNNoConjugates"]],
    "paclet:GroupMath/ref/RepsUpToDimNNoConjugates"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "7af55097-976f-4d37-96d5-c20f79d1424c"],
 ", ",
 Cell[BoxData[
 "RepsUoToDimN"], "InlineFormula",ExpressionUUID->
  "e1dd751b-bff5-4445-b0ef-fc6beb64899d"],
 " returns all representations, including conjugated representations."
}], "Notes",
 CellID->739693312,ExpressionUUID->"ddc70642-90fb-4fdf-8543-6a4f28edfbc3"],

Cell[TextData[{
 Cell[BoxData[
 "RepsUoToDimN"], "InlineFormula",ExpressionUUID->
  "36c7e9e8-e461-48b2-8c66-ebafe0aec6fc"],
 " will order the representations by dimension, representation index, and \
conjugacy class (with this order of importance). However, this sorting \
process can be very time consuming, in which case the option ",
 StyleBox["SortResult\[Rule]False", "InlineCode"],
 " can be used."
}], "Notes",
 CellID->740164301,ExpressionUUID->"134f7c4b-e977-439b-9702-2c76309d8851"],

Cell[TextData[{
 "The option ",
 StyleBox["UseName->True", "InlineCode"],
 " can be used to get the names of output representations (as opposed to the \
Dynkin coefficients)."
}], "Notes",
 CellID->147826559,ExpressionUUID->"61630570-bfba-4ba9-9adc-edbf19114770"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"60d11afd-1460-475d-98d6-5acaef3ad489"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"0695026a-9e81-440e-8173-6244891f634e"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "2b6245da-d604-4c9a-baed-c96470f71b8a"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->273511747,ExpressionUUID->"c3baf2a7-263b-4998-94f8-a2c6475aea80"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "073548ee-2e4c-4768-8d8f-6d198d7886e8"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->84089378,ExpressionUUID->"5830d511-7ad9-42e0-96ae-b8035d1db185"],

Cell[TextData[{
 "List all representations of ",
 Cell[BoxData[
  SubscriptBox["E", "6"]], "InlineFormula",ExpressionUUID->
  "e67b8e21-27b5-4e56-8a29-7c4867263682"],
 " with dimensions smaller than or equal to 10000:"
}], "ExampleText",
 CellID->283112903,ExpressionUUID->"77581a2d-acb2-447c-b4cc-96e4aeabca96"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RepsUpToDimN", "[", 
  RowBox[{"E6", ",", "10000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->473091279,ExpressionUUID->"b19ce768-c2da-4b8a-8a9c-ea9fb7cb0dac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "3", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "2", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->730505272,ExpressionUUID->"8bd8187d-cae8-4c30-9efb-fe8c620ceea8"]
}, Open  ]],

Cell["Get the names instead:", "ExampleText",
 CellID->23985300,ExpressionUUID->"d3c9b8d2-e380-4f84-bdbc-118865599861"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RepsUpToDimN", "[", 
  RowBox[{"E6", ",", "10000", ",", 
   RowBox[{"UseName", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->205549982,ExpressionUUID->"e6aa5185-b707-4929-80cc-450ffb9412f7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["\<\"1\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"27\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"27\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"], ",", 
   StyleBox["\<\"78\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"351\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"351\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"], ",", 
   StyleBox["\<\"351'\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"351'\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"], ",", 
   StyleBox["\<\"650\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"1728\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"1728\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"], ",", 
   StyleBox["\<\"2430\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"2925\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"3003\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"3003\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"], ",", 
   StyleBox["\<\"5824\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"5824\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"], ",", 
   StyleBox["\<\"7371\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"7371\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"], ",", 
   StyleBox["\<\"7722\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   OverscriptBox[
    StyleBox["\<\"7722\"\>",
     StripOnInput->False,
     FontWeight->Bold], "_"]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->72092718,ExpressionUUID->"dc295cca-0fcb-4e72-80ad-d05ba3a04d5b"]
}, Open  ]],

Cell[TextData[{
 "We see the 27 and its conjugate on the list. To get rid of the conjugated \
representations, one can use ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["RepsUpToDimNNoConjugates"]],
    "paclet:GroupMath/ref/RepsUpToDimNNoConjugates"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "d2194485-13f7-45b6-9993-3de09c06aa4f"],
 " instead:"
}], "ExampleText",
 CellID->31989200,ExpressionUUID->"326f623b-e916-4442-918e-10e1e37e80a2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RepsUpToDimNNoConjugates", "[", 
  RowBox[{"E6", ",", "10000", ",", 
   RowBox[{"UseName", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->538622000,ExpressionUUID->"a98f7eba-bdf3-4e38-8515-c2d38d88ac3f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["\<\"1\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"27\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"78\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"351\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"351'\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"650\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"1728\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"2430\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"2925\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"3003\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"5824\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"7371\"\>",
    StripOnInput->False,
    FontWeight->Bold], ",", 
   StyleBox["\<\"7722\"\>",
    StripOnInput->False,
    FontWeight->Bold]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->732641330,ExpressionUUID->"937cf994-bdd3-455d-a231-d2bdd8a0e478"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "39e6b9a0-535c-42e8-a757-f4aeed8f136d"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->277143050,ExpressionUUID->"a41fcf31-c8fb-4dfa-8e4f-1c40af6ecc06"],

Cell[TextData[{
 Cell[BoxData[
 "RepsUoToDimN"], "InlineFormula",ExpressionUUID->
  "2aaa6a7f-cd2d-4a3c-84e0-f4db66f384be"],
 " neatly sorts the output representations, but this can be very time \
consuming (note that the program saves these results, so running the same \
code a second time is very fast):"
}], "ExampleText",
 CellID->583535372,ExpressionUUID->"06ab12bc-bef1-4b1c-b63f-e4a67794f6d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{"reps1", "=", 
    RowBox[{"RepsUpToDimN", "[", 
     RowBox[{"SU5", ",", "100000"}], "]"}]}], ";"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->339767984,ExpressionUUID->"ad5adff3-076f-4563-bbe5-f7574da28d4f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"15.0244349`", ",", "Null"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->729023990,ExpressionUUID->"b5bed5d6-a0a2-41b5-ac1e-06e8f32c5dd7"]
}, Open  ]],

Cell["We may therefore not order the result:", "ExampleText",
 CellID->4496015,ExpressionUUID->"f44c4752-f7eb-4c0e-852d-9130d933e252"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{"reps2", "=", 
    RowBox[{"RepsUpToDimN", "[", 
     RowBox[{"SU5", ",", "100000", ",", 
      RowBox[{"SortResult", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->470592848,ExpressionUUID->"d2da671a-3bca-44fd-9a00-bebaea12d2d4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.077599`", ",", "Null"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->43524912,ExpressionUUID->"d23fd934-1ecd-4246-9d8d-c2651fec0e1c"]
}, Open  ]],

Cell["\<\
The two lists have the same representations, but in different orders:\
\>", "ExampleText",
 CellID->626759953,ExpressionUUID->"8afa7e1c-e1ea-4994-a4e0-3c5bfcbefba7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"reps1", "\[Equal]", "reps2"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sort", "[", "reps1", "]"}], "\[Equal]", 
  RowBox[{"Sort", "[", "reps2", "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->8776216,ExpressionUUID->"b4c9fa2e-1700-4e42-8998-0f8875c06c64"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[3]=",
 CellID->243472129,ExpressionUUID->"c2ca37d4-02e6-457a-8d1f-a84cd359883b"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[3]=",
 CellID->886340075,ExpressionUUID->"f2057fea-f216-4dff-b79c-e6f329ea85ac"]
}, Open  ]],

Cell[TextData[{
 "With the  ",
 StyleBox["SortResult\[Rule]False", "InlineCode"],
 " option one can compute all representations up to much larger bounds:"
}], "ExampleText",
 CellID->267541465,ExpressionUUID->"a8307cf8-7585-4ebe-b412-01e671955a44"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{"reps3", "=", 
    RowBox[{"RepsUpToDimN", "[", 
     RowBox[{"SU5", ",", 
      RowBox[{"10", "^", "9"}], ",", 
      RowBox[{"SortResult", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "reps3", "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->169269358,ExpressionUUID->"9739dd64-6df2-4058-bfee-b77ec8404d37"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.8791789`", ",", "Null"}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->114847960,ExpressionUUID->"65b4fd23-31b6-4aa3-b16b-b5f16d30cc26"],

Cell[BoxData["108502"], "Output",
 CellLabel->"Out[4]=",
 CellID->693923252,ExpressionUUID->"602bc893-00f1-4531-a191-c8e71c12bfb2"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"b5a5492d-50d3-498e-a7f9-d3a1468560a0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"3a9b3568-95ef-40af-b4b7-2e262e4ff85a"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"59c43732-1e33-4adc-998a-f93f752e9e91"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["DimR"]],"paclet:GroupMath/ref/DimR"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"5decda1d-e91b-4533-8b06-d58d576d3520"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["RepName"]],"paclet:GroupMath/ref/RepName"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"17db5f96-8ea5-4120-b205-9842fb154b71"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["RepsUpToDimNNoConjugates"]],
    "paclet:GroupMath/ref/RepsUpToDimNNoConjugates"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"b95a7ae8-986f-4705-ab01-41ac1b7470b6"]
}], "SeeAlso",
 CellID->86727222,ExpressionUUID->"6050869e-b4a2-41d4-a4d9-e30bca372ff3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"9ef0eb06-44a2-4063-a6d6-693c2b32046b"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"0e7a56dc-eeea-47fe-a073-6e7ddaaa1cd2"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"090768ea-e7ae-4da3-a8ee-e51ac54fd3c7"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"ec0500fd-15f9-4277-a0b1-4b6da7e95fcf"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"70c42e57-c847-422c-9662-a177f5eff4b1"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RepsUpToDimN",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 14, 7.1013940}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "RepsUpToDimN[group, maxDim] Lists all representations of group with \
dimension smaller or equal to maxDim ", "synonyms" -> {}, "tabletags" -> {}, 
    "title" -> "RepsUpToDimN", "titlemodifier" -> "", "windowtitle" -> 
    "RepsUpToDimN", "type" -> "Symbol", "uri" -> "GroupMath/ref/RepsUpToDimN",
     "WorkflowDockedCell" -> ""}, "SearchTextTranslated" -> "", "NewStyles" -> 
  False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9578, 255, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"c3baf2a7-263b-4998-94f8-a2c6475aea80",
   CellTags->"PrimaryExamplesSection",
   CellID->273511747]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25766, 761}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[584, 21, 4290, 97, 53, "AnchorBarGrid",ExpressionUUID->"bb5e8d7a-6779-4476-8db3-fa3fa0856f54",
 CellID->1],
Cell[CellGroupData[{
Cell[4899, 122, 397, 9, 52, "ObjectNameGrid",ExpressionUUID->"2416cdcc-dd11-4022-96c4-a26264f211e4"],
Cell[5299, 133, 813, 19, 110, "Usage",ExpressionUUID->"ad24bb0a-dd9c-46cb-9748-f0bf47a65bed",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6149, 157, 855, 21, 37, "NotesSection",ExpressionUUID->"2cd2b3e0-b919-40a7-864b-f30d044fd93b",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->205872487],
Cell[7007, 180, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"a676cd9f-b102-4aa5-a0a6-3b97ebf3a0f7"],
Cell[7096, 182, 359, 11, 70, "Notes",ExpressionUUID->"c2d3ed88-1162-4969-b89c-880f316c7229",
 CellID->1067943069],
Cell[7458, 195, 655, 16, 70, "Notes",ExpressionUUID->"d3a4e015-ed30-4b61-af7e-b766e0e0754f",
 CellID->159441392],
Cell[8116, 213, 574, 15, 70, "Notes",ExpressionUUID->"ddc70642-90fb-4fdf-8543-6a4f28edfbc3",
 CellID->739693312],
Cell[8693, 230, 493, 10, 70, "Notes",ExpressionUUID->"134f7c4b-e977-439b-9702-2c76309d8851",
 CellID->740164301],
Cell[9189, 242, 263, 6, 70, "Notes",ExpressionUUID->"61630570-bfba-4ba9-9adc-edbf19114770",
 CellID->147826559],
Cell[9455, 250, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"60d11afd-1460-475d-98d6-5acaef3ad489"]
}, Closed]],
Cell[CellGroupData[{
Cell[9578, 255, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"c3baf2a7-263b-4998-94f8-a2c6475aea80",
 CellTags->"PrimaryExamplesSection",
 CellID->273511747],
Cell[CellGroupData[{
Cell[10038, 270, 307, 7, 29, "ExampleSection",ExpressionUUID->"5830d511-7ad9-42e0-96ae-b8035d1db185",
 CellID->84089378],
Cell[10348, 279, 312, 7, 38, "ExampleText",ExpressionUUID->"77581a2d-acb2-447c-b4cc-96e4aeabca96",
 CellID->283112903],
Cell[CellGroupData[{
Cell[10685, 290, 191, 4, 26, "Input",ExpressionUUID->"b19ce768-c2da-4b8a-8a9c-ea9fb7cb0dac",
 CellID->473091279],
Cell[10879, 296, 2313, 67, 116, "Output",ExpressionUUID->"8bd8187d-cae8-4c30-9efb-fe8c620ceea8",
 CellID->730505272]
}, Open  ]],
Cell[13207, 366, 119, 1, 38, "ExampleText",ExpressionUUID->"d3c9b8d2-e380-4f84-bdbc-118865599861",
 CellID->23985300],
Cell[CellGroupData[{
Cell[13351, 371, 240, 5, 26, "Input",ExpressionUUID->"e6aa5185-b707-4929-80cc-450ffb9412f7",
 CellID->205549982],
Cell[13594, 378, 2076, 75, 52, "Output",ExpressionUUID->"dc295cca-0fcb-4e72-80ad-d05ba3a04d5b",
 CellID->72092718]
}, Open  ]],
Cell[15685, 456, 490, 12, 58, "ExampleText",ExpressionUUID->"326f623b-e916-4442-918e-10e1e37e80a2",
 CellID->31989200],
Cell[CellGroupData[{
Cell[16200, 472, 252, 5, 26, "Input",ExpressionUUID->"a98f7eba-bdf3-4e38-8515-c2d38d88ac3f",
 CellID->538622000],
Cell[16455, 479, 1208, 43, 35, "Output",ExpressionUUID->"937cf994-bdd3-455d-a231-d2bdd8a0e478",
 CellID->732641330]
}, Open  ]],
Cell[CellGroupData[{
Cell[17700, 527, 242, 5, 70, "ExampleDelimiter",ExpressionUUID->"a41fcf31-c8fb-4dfa-8e4f-1c40af6ecc06",
 CellID->277143050],
Cell[17945, 534, 401, 8, 70, "ExampleText",ExpressionUUID->"06ab12bc-bef1-4b1c-b63f-e4a67794f6d1",
 CellID->583535372],
Cell[CellGroupData[{
Cell[18371, 546, 285, 7, 70, "Input",ExpressionUUID->"ad5adff3-076f-4563-bbe5-f7574da28d4f",
 CellID->339767984],
Cell[18659, 555, 184, 4, 35, "Output",ExpressionUUID->"b5bed5d6-a0a2-41b5-ac1e-06e8f32c5dd7",
 CellID->729023990]
}, Open  ]],
Cell[18858, 562, 134, 1, 70, "ExampleText",ExpressionUUID->"f44c4752-f7eb-4c0e-852d-9130d933e252",
 CellID->4496015],
Cell[CellGroupData[{
Cell[19017, 567, 344, 9, 70, "Input",ExpressionUUID->"d2da671a-3bca-44fd-9a00-bebaea12d2d4",
 CellID->470592848],
Cell[19364, 578, 181, 4, 35, "Output",ExpressionUUID->"d23fd934-1ecd-4246-9d8d-c2651fec0e1c",
 CellID->43524912]
}, Open  ]],
Cell[19560, 585, 175, 3, 70, "ExampleText",ExpressionUUID->"8afa7e1c-e1ea-4994-a4e0-3c5bfcbefba7",
 CellID->626759953],
Cell[CellGroupData[{
Cell[19760, 592, 289, 6, 70, "Input",ExpressionUUID->"b4c9fa2e-1700-4e42-8998-0f8875c06c64",
 CellID->8776216],
Cell[20052, 600, 130, 2, 35, "Output",ExpressionUUID->"c2ca37d4-02e6-457a-8d1f-a84cd359883b",
 CellID->243472129],
Cell[20185, 604, 129, 2, 35, "Output",ExpressionUUID->"f2057fea-f216-4dff-b79c-e6f329ea85ac",
 CellID->886340075]
}, Open  ]],
Cell[20329, 609, 248, 5, 70, "ExampleText",ExpressionUUID->"a8307cf8-7585-4ebe-b412-01e671955a44",
 CellID->267541465],
Cell[CellGroupData[{
Cell[20602, 618, 433, 11, 70, "Input",ExpressionUUID->"9739dd64-6df2-4058-bfee-b77ec8404d37",
 CellID->169269358],
Cell[21038, 631, 183, 4, 35, "Output",ExpressionUUID->"65b4fd23-31b6-4aa3-b16b-b5f16d30cc26",
 CellID->114847960],
Cell[21224, 637, 131, 2, 35, "Output",ExpressionUUID->"602bc893-00f1-4531-a191-c8e71c12bfb2",
 CellID->693923252]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[21394, 644, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"b5a5492d-50d3-498e-a7f9-d3a1468560a0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21517, 649, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"59c43732-1e33-4adc-998a-f93f752e9e91",
 CellID->1255426704],
Cell[21780, 658, 1109, 29, 70, "SeeAlso",ExpressionUUID->"6050869e-b4a2-41d4-a4d9-e30bca372ff3",
 CellID->86727222]
}, Open  ]],
Cell[CellGroupData[{
Cell[22926, 692, 262, 7, 70, "TutorialsSection",ExpressionUUID->"0e7a56dc-eeea-47fe-a073-6e7ddaaa1cd2",
 CellID->250839057],
Cell[23191, 701, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"090768ea-e7ae-4da3-a8ee-e51ac54fd3c7"],
Cell[23280, 703, 241, 5, 70, "Tutorials",ExpressionUUID->"ec0500fd-15f9-4277-a0b1-4b6da7e95fcf",
 CellID->341631938]
}, Open  ]],
Cell[23536, 711, 78, 0, 70, "FooterCell",ExpressionUUID->"70c42e57-c847-422c-9662-a177f5eff4b1"]
}
]
*)

(* End of internal cache information *)

