(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     29091,        844]
NotebookOptionsPosition[     21896,        687]
NotebookOutlinePosition[     24336,        747]
CellTagsIndexPosition[     24251,        742]
WindowTitle->ReflectWeight
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "9b30db3a-0e28-42ad-893b-432aabbc0e4b"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"2744a90b-cf06-4d7c-bd49-4f10f097548d"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ecfbba88-6cfd-4446-b9ed-0904d4f46baf"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"88825125-9a1d-48db-9c1f-41b3a25770de"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"Weights\"\>":>Documentation`HelpLookup[
       "paclet:GroupMath/ref/Weights"], "\<\"DominantWeights\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/DominantWeights"], "\<\"DominantConjugate\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/DominantConjugate"], "\<\"WeylOrbit\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/ref/WeylOrbit"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "d81c60dd-35e5-42e1-b2bd-8e72dfdf0241"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"0b0f3a7d-a872-4748-8fce-18e2f579c74f"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/ReflectWeight\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/ReflectWeight"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
ReflectWeight.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$23828], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/ReflectWeight", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "f1494fa7-ee48-4b0e-97ba-1b48490d7e39"]
    }], "AnchorBar",ExpressionUUID->"faeef8ac-94da-4bb0-bb97-9304bd468cdf"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"914e0a9f-e558-422e-8630-1e537dab91eb"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["ReflectWeight", "ObjectName",ExpressionUUID->
  "f47f2274-9d63-47d1-8b4e-ed4a841ebedb"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"4c9faf8c-0edb-4364-8932-7f6602b21efa"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "cc1329ee-eaf9-4cb9-aa33-0ff41bb3d4d2"]
}], "ObjectNameGrid",ExpressionUUID->"e846f4a1-8bd5-42c2-b508-8eb842bea2f5"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReflectWeight", "[", 
       RowBox[{"group", ",", "weight", ",", "i"}], "]"}]], "InlineFormula",
      ExpressionUUID->"bb7be86d-0758-466e-9501-b75d288f5ac1"],
     " \[LineSeparator]Performs the simple Weyl reflection ",
     Cell[BoxData[
     "i"], "InlineFormula",ExpressionUUID->
      "e899cded-97ff-4f83-bbc0-ff668b27f642"],
     ", of the ",
     Cell[BoxData[
     "weight"], "InlineFormula",ExpressionUUID->
      "b7a6a9c4-a846-4c12-bc6b-35fa5dd36ad6"],
     " of the simple Lie ",
     Cell[BoxData[
     "group"], "InlineFormula",ExpressionUUID->
      "deb0166e-d757-4fa7-8301-d5d002c96b66"],
     "."
    }],ExpressionUUID->"fd897f1a-1a3a-4b18-a52b-70700dab9ea7"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"b7fc0949-fd53-452d-a98a-b8500bf5f306"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"f4d475b6-2c77-4125-a726-04c26bc89465"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"39f39c7f-36a2-4598-970a-40b3b01fcea6"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"8733791a-bae5-425d-8e6f-99f01ce9ffbb"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->600419301,ExpressionUUID->"c2805a8e-1dc7-435b-970f-7dfb01d495cc"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"7a08cba5-9f7d-4df3-8c13-ea4cd87f2122"],

Cell[TextData[{
 "The set of weights of a representation of a simple Lie group have a \
symmetry characterized by the Weyl group. This group is generated by n \
elementary reflections ",
 Cell[BoxData[
  SubscriptBox["s", "i"]], "InlineFormula",ExpressionUUID->
  "d68fdcc6-231f-403c-9958-7d55a6c4756e"],
 " (where n is the group rank), which are performed by performed by this \
function ",
 Cell[BoxData[
 "ReflectWeight"], "InlineFormula",ExpressionUUID->
  "82db3071-8e68-45aa-b18d-640e67bfdb65"],
 "."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"a40962d1-53f3-4332-b1e7-0a2de894b5da"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"7fb67ed5-d852-4ee2-ad3f-b49838deb2b5"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"b545c128-2747-4b54-969f-2ba781d0cdd3"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "296aaa5b-69a3-4665-aad9-3c39be87d124"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->557391103,ExpressionUUID->"03afd6c4-8151-4f8a-a1c1-3e9644e4712d"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "c3a479e7-d34c-4f66-8a6f-02b502d9c5c0"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->114766459,ExpressionUUID->"2bf9b17d-cfdd-4eab-8b9f-e74ad579f3f7"],

Cell[TextData[{
 "Consider the weight {3,4} of SU(3). It's ",
 Cell[BoxData[
  SubscriptBox["s", "1"]], "InlineFormula",ExpressionUUID->
  "d7ac4786-b0d2-4644-a0fe-82f6e88bedb7"],
 " reflection is"
}], "Notes",
 CellID->187841187,ExpressionUUID->"69a0f522-37f4-4d50-b86c-01cc2eb55436"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReflectWeight", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73384153,ExpressionUUID->"78f42afd-3dad-40ab-bd8a-1109e534292a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3"}], ",", "7"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->552044577,ExpressionUUID->"7fbc5d86-e1b3-4812-a9d1-170aa35a66c5"]
}, Open  ]],

Cell[TextData[{
 "The other reflection, ",
 Cell[BoxData[
  SubscriptBox["s", "2"]], "InlineFormula",ExpressionUUID->
  "f4ad8887-e4ff-493a-9058-a8e8a46fcee2"],
 ", yields"
}], "Notes",
 CellID->688350564,ExpressionUUID->"9de42fc1-2ea5-4d7f-a634-d01b06d41a79"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReflectWeight", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->254270140,ExpressionUUID->"65f425c8-ed33-4b74-a714-e41c98bf2457"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", 
   RowBox[{"-", "4"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->232066343,ExpressionUUID->"373934ef-04de-43ab-a965-1574d257393b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "2e1f266f-8a99-4c04-bfd3-dacfc390e44a"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->403508811,ExpressionUUID->"b79156a8-b858-4b16-9032-68d413b8c562"],

Cell["\<\
Let us consider the {2,1} representation of SU(3), which is 15-dimensional:\
\>", "Notes",
 CellID->450341596,ExpressionUUID->"f3703053-d621-45b9-b6ad-04aff51e46ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RepName", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162970475,ExpressionUUID->"04c13331-eb9f-46eb-9e2b-d9ab288ccf08"],

Cell[BoxData[
 StyleBox["\<\"15\"\>",
  StripOnInput->False,
  FontWeight->Bold]], "Output",
 CellLabel->"Out[1]=",
 CellID->23257430,ExpressionUUID->"fa30bc64-aae8-49f0-b60f-667d3ec1c36d"]
}, Open  ]],

Cell["Its weights, with multiplicities, are the following:", "Notes",
 CellID->79786814,ExpressionUUID->"d520528c-0bd7-4133-88d8-bbc59a705486"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"weights", "=", 
  RowBox[{"Weights", "[", 
   RowBox[{"SU3", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->121374016,ExpressionUUID->"76efe778-1137-4068-8069-fcd554965ca0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->107888041,ExpressionUUID->"0d4a38a8-444f-46d4-806b-9b820b3e383f"]
}, Open  ]],

Cell[TextData[{
 "Their ",
 Cell[BoxData[
  SubscriptBox["s", "1"]], "InlineFormula",ExpressionUUID->
  "cc81ca68-b399-4fd0-bf7a-1a65571cd2aa"],
 "  and ",
 Cell[BoxData[
  SubscriptBox["s", "2"]], "InlineFormula",ExpressionUUID->
  "886fd96b-1f4d-4ac4-a9ea-c9e4a6bed657"],
 " reflections are"
}], "Notes",
 CellID->336055572,ExpressionUUID->"0ef0ea21-c4c8-49af-8846-f450e7b7b8c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"weightsS1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ReflectWeight", "[", 
       RowBox[{"SU3", ",", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", "1"}], "]"}], ",", 
      RowBox[{"#", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "&"}], "/@", 
   RowBox[{"Weights", "[", 
    RowBox[{"SU3", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->784741422,ExpressionUUID->"5ddcc087-807d-445b-8994-14d5c4395f4b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->348980319,ExpressionUUID->"1ab38aaa-07a5-4613-934f-3cc73a66df09"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"weightsS2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ReflectWeight", "[", 
       RowBox[{"SU3", ",", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", "2"}], "]"}], ",", 
      RowBox[{"#", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "&"}], "/@", 
   RowBox[{"Weights", "[", 
    RowBox[{"SU3", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->525776994,ExpressionUUID->"9bc95961-e26c-4039-9d90-d4ef53906cfe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->426542476,ExpressionUUID->"9d4e52f1-b45a-4d96-9013-00bd9d6bda80"]
}, Open  ]],

Cell["These are exactly the original weights, but reshuffled:", "Notes",
 CellID->346716671,ExpressionUUID->"7d539820-c249-4b55-a477-cb9c24e4278e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Sort", "[", "weights", "]"}], "\[Equal]", 
  RowBox[{"Sort", "[", "weightsS1", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sort", "[", "weights", "]"}], "\[Equal]", 
  RowBox[{"Sort", "[", "weightsS2", "]"}]}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->98827248,ExpressionUUID->"d8bff46a-6bf7-4f8c-b2b0-a231694384ad"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[5]=",
 CellID->55604204,ExpressionUUID->"7662d92c-919b-4010-a07b-fb9c45090353"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[5]=",
 CellID->921868352,ExpressionUUID->"b14895bf-1143-4a32-bf85-8553fdac02ce"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"3e1f6b75-15c0-4d0f-928a-3728763cf615"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"25c69117-e73b-4ef9-a6ab-e8db3b843be4"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"beb70a57-9c50-4067-b9eb-d7f2869a501e"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["Weights"]],"paclet:GroupMath/ref/Weights"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"85c32340-3955-45b0-8b6d-6fcce2bdc770"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["DominantWeights"]],"paclet:GroupMath/ref/DominantWeights"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"7010daba-efa4-4136-b570-01628a585f2c"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["DominantConjugate"]],"paclet:GroupMath/ref/DominantConjugate"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"04c177d8-f464-4f7a-bb9a-5a2785efa517"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["WeylOrbit"]],"paclet:GroupMath/ref/WeylOrbit"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"767614ad-9146-4e31-b54e-0b4daede5841"]
}], "SeeAlso",
 CellID->40137011,ExpressionUUID->"27073cde-2745-432b-85c1-45aab34670df"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"58fd25c4-1cc5-4f70-9735-b81587b7c504"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"86f5c17d-42ef-4a75-bb66-bf7d4cdb447f"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"9c5f49c8-381d-4753-ab09-27c609cb228b"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"760fb8fd-09db-48a3-b079-45fe7385c4fc"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"d8b3c7c9-b67f-4e88-bf30-8d23efc37820"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReflectWeight",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 13, 53.3811877}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "ReflectWeight[group, weight, i] Performs the simple Weyl reflection i, \
of the weight of the simple Lie group.", "synonyms" -> {}, "tabletags" -> {}, 
    "title" -> "ReflectWeight", "titlemodifier" -> "", "windowtitle" -> 
    "ReflectWeight", "type" -> "Symbol", "uri" -> 
    "GroupMath/ref/ReflectWeight", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8044, 208, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"03afd6c4-8151-4f8a-a1c1-3e9644e4712d",
   CellTags->"PrimaryExamplesSection",
   CellID->557391103]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24053, 735}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[585, 21, 4391, 98, 53, "AnchorBarGrid",ExpressionUUID->"914e0a9f-e558-422e-8630-1e537dab91eb",
 CellID->1],
Cell[CellGroupData[{
Cell[5001, 123, 398, 9, 52, "ObjectNameGrid",ExpressionUUID->"e846f4a1-8bd5-42c2-b508-8eb842bea2f5"],
Cell[5402, 134, 937, 23, 110, "Usage",ExpressionUUID->"b7fc0949-fd53-452d-a98a-b8500bf5f306",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6376, 162, 855, 21, 37, "NotesSection",ExpressionUUID->"c2805a8e-1dc7-435b-970f-7dfb01d495cc",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->600419301],
Cell[7234, 185, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"7a08cba5-9f7d-4df3-8c13-ea4cd87f2122"],
Cell[7323, 187, 595, 14, 70, "Notes",ExpressionUUID->"a40962d1-53f3-4332-b1e7-0a2de894b5da",
 CellID->1067943069],
Cell[7921, 203, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"7fb67ed5-d852-4ee2-ad3f-b49838deb2b5"]
}, Closed]],
Cell[CellGroupData[{
Cell[8044, 208, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"03afd6c4-8151-4f8a-a1c1-3e9644e4712d",
 CellTags->"PrimaryExamplesSection",
 CellID->557391103],
Cell[CellGroupData[{
Cell[8504, 223, 308, 7, 29, "ExampleSection",ExpressionUUID->"2bf9b17d-cfdd-4eab-8b9f-e74ad579f3f7",
 CellID->114766459],
Cell[8815, 232, 285, 7, 35, "Notes",ExpressionUUID->"69a0f522-37f4-4d50-b86c-01cc2eb55436",
 CellID->187841187],
Cell[CellGroupData[{
Cell[9125, 243, 247, 6, 26, "Input",ExpressionUUID->"78f42afd-3dad-40ab-bd8a-1109e534292a",
 CellID->73384153],
Cell[9375, 251, 190, 5, 35, "Output",ExpressionUUID->"7fbc5d86-e1b3-4812-a9d1-170aa35a66c5",
 CellID->552044577]
}, Open  ]],
Cell[9580, 259, 260, 7, 35, "Notes",ExpressionUUID->"9de42fc1-2ea5-4d7f-a634-d01b06d41a79",
 CellID->688350564],
Cell[CellGroupData[{
Cell[9865, 270, 248, 6, 26, "Input",ExpressionUUID->"65f425c8-ed33-4b74-a714-e41c98bf2457",
 CellID->254270140],
Cell[10116, 278, 190, 5, 35, "Output",ExpressionUUID->"373934ef-04de-43ab-a965-1574d257393b",
 CellID->232066343]
}, Open  ]],
Cell[CellGroupData[{
Cell[10343, 288, 242, 5, 8, "ExampleDelimiter",ExpressionUUID->"b79156a8-b858-4b16-9032-68d413b8c562",
 CellID->403508811],
Cell[10588, 295, 175, 3, 35, "Notes",ExpressionUUID->"f3703053-d621-45b9-b6ad-04aff51e46ed",
 CellID->450341596],
Cell[CellGroupData[{
Cell[10788, 302, 232, 6, 26, "Input",ExpressionUUID->"04c13331-eb9f-46eb-9e2b-d9ab288ccf08",
 CellID->162970475],
Cell[11023, 310, 189, 5, 35, "Output",ExpressionUUID->"fa30bc64-aae8-49f0-b60f-667d3ec1c36d",
 CellID->23257430]
}, Open  ]],
Cell[11227, 318, 143, 1, 35, "Notes",ExpressionUUID->"d520528c-0bd7-4133-88d8-bbc59a705486",
 CellID->79786814],
Cell[CellGroupData[{
Cell[11395, 323, 264, 7, 26, "Input",ExpressionUUID->"76efe778-1137-4068-8069-fcd554965ca0",
 CellID->121374016],
Cell[11662, 332, 1725, 62, 52, "Output",ExpressionUUID->"0d4a38a8-444f-46d4-806b-9b820b3e383f",
 CellID->107888041]
}, Open  ]],
Cell[13402, 397, 381, 11, 70, "Notes",ExpressionUUID->"0ef0ea21-c4c8-49af-8846-f450e7b7b8c6",
 CellID->336055572],
Cell[CellGroupData[{
Cell[13808, 412, 572, 17, 70, "Input",ExpressionUUID->"5ddcc087-807d-445b-8994-14d5c4395f4b",
 CellID->784741422],
Cell[14383, 431, 1725, 62, 52, "Output",ExpressionUUID->"1ab38aaa-07a5-4613-934f-3cc73a66df09",
 CellID->348980319]
}, Open  ]],
Cell[CellGroupData[{
Cell[16145, 498, 572, 17, 70, "Input",ExpressionUUID->"9bc95961-e26c-4039-9d90-d4ef53906cfe",
 CellID->525776994],
Cell[16720, 517, 1728, 63, 52, "Output",ExpressionUUID->"9d4e52f1-b45a-4d96-9013-00bd9d6bda80",
 CellID->426542476]
}, Open  ]],
Cell[18463, 583, 147, 1, 70, "Notes",ExpressionUUID->"7d539820-c249-4b55-a477-cb9c24e4278e",
 CellID->346716671],
Cell[CellGroupData[{
Cell[18635, 588, 364, 8, 70, "Input",ExpressionUUID->"d8bff46a-6bf7-4f8c-b2b0-a231694384ad",
 CellID->98827248],
Cell[19002, 598, 128, 2, 35, "Output",ExpressionUUID->"7662d92c-919b-4010-a07b-fb9c45090353",
 CellID->55604204],
Cell[19133, 602, 129, 2, 35, "Output",ExpressionUUID->"b14895bf-1143-4a32-bf85-8553fdac02ce",
 CellID->921868352]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[19301, 609, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"3e1f6b75-15c0-4d0f-928a-3728763cf615"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19424, 614, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"beb70a57-9c50-4067-b9eb-d7f2869a501e",
 CellID->1255426704],
Cell[19687, 623, 1480, 38, 70, "SeeAlso",ExpressionUUID->"27073cde-2745-432b-85c1-45aab34670df",
 CellID->40137011]
}, Open  ]],
Cell[CellGroupData[{
Cell[21204, 666, 262, 7, 70, "TutorialsSection",ExpressionUUID->"86f5c17d-42ef-4a75-bb66-bf7d4cdb447f",
 CellID->250839057],
Cell[21469, 675, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"9c5f49c8-381d-4753-ab09-27c609cb228b"],
Cell[21558, 677, 241, 5, 70, "Tutorials",ExpressionUUID->"760fb8fd-09db-48a3-b079-45fe7385c4fc",
 CellID->341631938]
}, Open  ]],
Cell[21814, 685, 78, 0, 70, "FooterCell",ExpressionUUID->"d8b3c7c9-b67f-4e88-bf30-8d23efc37820"]
}
]
*)

(* End of internal cache information *)

