(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     18237,        484]
NotebookOptionsPosition[     12651,        362]
NotebookOutlinePosition[     15039,        421]
CellTagsIndexPosition[     14954,        416]
WindowTitle->PositiveRoots
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "06d330b2-817b-482f-810c-e9bcdb8ed9ff"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"ef47773c-5e33-44b3-a9ba-93443314ae49"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "c148c457-b8a6-401e-bf1d-f8f92fdfa1a1"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"b39adc35-5cf5-422f-8c19-7ef44d6f9604"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/PositiveRoots\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/PositiveRoots"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
PositiveRoots.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$22795], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/PositiveRoots", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "7e9a05fd-076d-4999-9778-6af3ac554d23"]
    }], "AnchorBar",ExpressionUUID->"e3f40b67-c951-415e-977a-8c674178e814"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"fe19f734-dc8b-40c9-a581-a8e01eda5265"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["PositiveRoots", "ObjectName",ExpressionUUID->
  "f09ed51f-3f6a-412e-ba62-a4d3a21a162b"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"8f513fa3-eaa6-472d-b28e-9a058f83fbfd"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "1f156ff6-d219-457e-827a-6d4a296fddaf"]
}], "ObjectNameGrid",ExpressionUUID->"6f8e8f10-1496-4636-a484-2b34eb0b1853"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PositiveRoots", "[", "group", "]"}]], "InlineFormula",
      ExpressionUUID->"2b813d5e-b797-438f-a7f0-823df5d5eb8b"],
     " \[LineSeparator]Computes the positive roots of ",
     Cell[BoxData[
     "group"], "InlineFormula",ExpressionUUID->
      "7d0bba57-320c-44af-97c6-d931dc9f7c48"]
    }],ExpressionUUID->"004dfb1d-316f-4824-99a5-8344e0c8853c"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"31575dff-c804-4baa-bbfb-86b423954486"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"54cdf2b8-2689-4e07-b62b-a58a44868297"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"df1c4c44-f223-4d92-ab5a-44038e4ff262"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"98c2aa88-2afa-48b7-b28d-79d7295fa053"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->688749775,ExpressionUUID->"a760cfb9-2ac8-468f-8fce-97992b1529e9"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"90284f47-7ca3-42c7-a6ad-c4a9cbe69040"],

Cell[TextData[{
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "487c369f-cc92-48ed-b5c9-200953f16c9a"],
 " should be the ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/ref/CartanMatrix"],
 " of the intended group."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"e7c5c9a7-5b11-40bc-9c28-12e218cd9699"],

Cell[TextData[{
 "The roots are given as Dynkin coefficients ",
 Cell[BoxData[
  RowBox[{"2", 
   FractionBox[
    RowBox[{
     RowBox[{"<", 
      RowBox[{"positive", " ", "root"}]}], ",", 
     RowBox[{
      SubscriptBox["\[Alpha]", "i"], ">"}]}], 
    RowBox[{
     RowBox[{"<", 
      SubscriptBox["\[Alpha]", "i"]}], ",", 
     RowBox[{
      SubscriptBox["\[Alpha]", "i"], ">"}]}]]}]], "InlineFormula",
  ExpressionUUID->"30fb498a-5cdd-49a6-b88e-ed57a9faf156"],
 ". See a Lie Algebra book for more information."
}], "Notes",
 CellID->600864457,ExpressionUUID->"410040d0-acfc-46e4-817b-7300f2291297"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"73f13b26-2ae6-4493-ad1c-a6a9a1eb89d1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"b2b6b62b-7891-4884-a9e5-2f1d2c70258c"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "3a94c753-a8a6-4802-a971-7c17a88fa639"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->162364209,ExpressionUUID->"a08c1498-37f1-4efe-afbf-0f7407659cf0"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "1581d91d-9edb-4ff5-be54-df29b300dd43"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->330337408,ExpressionUUID->"ed267196-d19b-4be4-9e24-d51fc49ba68c"],

Cell["SU(3) has 3 positive roots:", "ExampleText",
 CellID->90625990,ExpressionUUID->"1dee99a4-0568-4fa7-90ad-2b63387a0317"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveRoots", "[", "SU3", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->204539992,ExpressionUUID->"c18fa330-90ff-416e-8385-5921b70439ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->13568069,ExpressionUUID->"0789cf05-398c-4be4-ab37-69526ea576c9"]
}, Open  ]],

Cell["\<\
Without going into details we can check two interesting facts. First, the \
'biggest' positive root is also the highest weight of the adjoint \
representation of the group. In practice this means that \
adjointRep=PositiveRoots[group][[-1]] (last positive root is the biggest):\
\>", "ExampleText",
 CellID->23607392,ExpressionUUID->"257b6466-2aee-40cf-8e41-d0a7b842a9c5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "\"\<Adjoint of SU(3):\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"PositiveRoots", "[", "SU3", "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"-", "1"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->54710674,ExpressionUUID->"adf5da7f-5d93-440a-96e0-445cd47f518f"],

Cell[BoxData["\<\"Adjoint of SU(3):\"\>"], "Print",
 CellLabel->"During evaluation of In[168]:=",
 CellID->241830925,ExpressionUUID->"7f41ec2b-e616-4f60-b976-f14961ab35c4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->38207750,ExpressionUUID->"e24b7c1e-1825-4a1d-8ea7-6c8ef1d48a34"]
}, Open  ]],

Cell["\<\
Another thing we can check is that the dimension of the algebra (=dimension \
of the adjoint representation) is equal to 2 #positive roots+#simple roots. \
In practice this means that dim(group)= 2 \
Length[PositiveRoots[group]]+Length[group]:\
\>", "ExampleText",
 CellID->63590369,ExpressionUUID->"ed87abbb-949d-444c-9094-5d462c95c6a5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dimG", "=", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"Length", "[", 
      RowBox[{"PositiveRoots", "[", "SU3", "]"}], "]"}]}], "+", 
    RowBox[{"Length", "[", "SU3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<The SU(3) algebra has \>\"", ",", "dimG", " ", ",", 
     "\"\< elements\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimG", "=", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"Length", "[", 
      RowBox[{"PositiveRoots", "[", "E7", "]"}], "]"}]}], "+", 
    RowBox[{"Length", "[", "E7", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<The E(7) algebra has \>\"", ",", "dimG", " ", ",", 
    "\"\< elements\>\""}], "]"}], ";"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->98902658,ExpressionUUID->"7535e629-e342-41aa-9c8e-5fc5df585829"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The SU(3) algebra has \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" elements\"\>"}],
  SequenceForm["The SU(3) algebra has ", 8, " elements"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[170]:=",
 CellID->207810697,ExpressionUUID->"14f6eb06-3a49-4132-9ebd-046e2188f240"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The E(7) algebra has \"\>", "\[InvisibleSpace]", "133", 
   "\[InvisibleSpace]", "\<\" elements\"\>"}],
  SequenceForm["The E(7) algebra has ", 133, " elements"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[170]:=",
 CellID->30145809,ExpressionUUID->"483ebd04-0fd0-4182-b3dc-79078ea1b24c"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"4998af87-2025-4256-ae72-165ebcc76a7e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"02833476-a42f-4e3a-a0e8-3baaa43e2e1a"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"5730f592-3726-4535-9089-b4603c4eadd2"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"789b8be6-a94c-4c25-8afd-3600a590556b"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"b1f66dea-fcae-43a1-9e6f-abb6ee26be17"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"ed04160e-f031-483b-a8b0-c4ca3b022344"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PositiveRoots",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 13, 49.2224474}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "PositiveRoots[group] Computes the positive roots of group", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "PositiveRoots", 
    "titlemodifier" -> "", "windowtitle" -> "PositiveRoots", "type" -> 
    "Symbol", "uri" -> "GroupMath/ref/PositiveRoots", "WorkflowDockedCell" -> 
    ""}, "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7149, 193, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"a08c1498-37f1-4efe-afbf-0f7407659cf0",
   CellTags->"PrimaryExamplesSection",
   CellID->162364209]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14756, 409}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[585, 21, 3456, 77, 53, "AnchorBarGrid",ExpressionUUID->"fe19f734-dc8b-40c9-a581-a8e01eda5265",
 CellID->1],
Cell[CellGroupData[{
Cell[4066, 102, 398, 9, 52, "ObjectNameGrid",ExpressionUUID->"6f8e8f10-1496-4636-a484-2b34eb0b1853"],
Cell[4467, 113, 608, 13, 110, "Usage",ExpressionUUID->"31575dff-c804-4baa-bbfb-86b423954486",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5112, 131, 855, 21, 37, "NotesSection",ExpressionUUID->"a760cfb9-2ac8-468f-8fce-97992b1529e9",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->688749775],
Cell[5970, 154, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"90284f47-7ca3-42c7-a6ad-c4a9cbe69040"],
Cell[6059, 156, 354, 10, 70, "Notes",ExpressionUUID->"e7c5c9a7-5b11-40bc-9c28-12e218cd9699",
 CellID->1067943069],
Cell[6416, 168, 607, 18, 70, "Notes",ExpressionUUID->"410040d0-acfc-46e4-817b-7300f2291297",
 CellID->600864457],
Cell[7026, 188, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"73f13b26-2ae6-4493-ad1c-a6a9a1eb89d1"]
}, Closed]],
Cell[CellGroupData[{
Cell[7149, 193, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"a08c1498-37f1-4efe-afbf-0f7407659cf0",
 CellTags->"PrimaryExamplesSection",
 CellID->162364209],
Cell[CellGroupData[{
Cell[7609, 208, 308, 7, 29, "ExampleSection",ExpressionUUID->"ed267196-d19b-4be4-9e24-d51fc49ba68c",
 CellID->330337408],
Cell[7920, 217, 124, 1, 38, "ExampleText",ExpressionUUID->"1dee99a4-0568-4fa7-90ad-2b63387a0317",
 CellID->90625990],
Cell[CellGroupData[{
Cell[8069, 222, 166, 3, 26, "Input",ExpressionUUID->"c18fa330-90ff-416e-8385-5921b70439ac",
 CellID->204539992],
Cell[8238, 227, 369, 12, 35, "Output",ExpressionUUID->"0789cf05-398c-4be4-ab37-69526ea576c9",
 CellID->13568069]
}, Open  ]],
Cell[8622, 242, 382, 6, 76, "ExampleText",ExpressionUUID->"257b6466-2aee-40cf-8e41-d0a7b842a9c5",
 CellID->23607392],
Cell[CellGroupData[{
Cell[9029, 252, 321, 8, 43, "Input",ExpressionUUID->"adf5da7f-5d93-440a-96e0-445cd47f518f",
 CellID->54710674],
Cell[9353, 262, 172, 2, 22, "Print",ExpressionUUID->"7f41ec2b-e616-4f60-b976-f14961ab35c4",
 CellID->241830925],
Cell[9528, 266, 170, 4, 35, "Output",ExpressionUUID->"e24b7c1e-1825-4a1d-8ea7-6c8ef1d48a34",
 CellID->38207750]
}, Open  ]],
Cell[9713, 273, 348, 6, 76, "ExampleText",ExpressionUUID->"ed87abbb-949d-444c-9094-5d462c95c6a5",
 CellID->63590369],
Cell[CellGroupData[{
Cell[10086, 283, 962, 28, 91, "Input",ExpressionUUID->"7535e629-e342-41aa-9c8e-5fc5df585829",
 CellID->98902658],
Cell[CellGroupData[{
Cell[11073, 315, 360, 7, 70, "Print",ExpressionUUID->"14f6eb06-3a49-4132-9ebd-046e2188f240",
 CellID->207810697],
Cell[11436, 324, 361, 7, 70, "Print",ExpressionUUID->"483ebd04-0fd0-4182-b3dc-79078ea1b24c",
 CellID->30145809]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[11836, 336, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"4998af87-2025-4256-ae72-165ebcc76a7e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11959, 341, 262, 7, 70, "TutorialsSection",ExpressionUUID->"5730f592-3726-4535-9089-b4603c4eadd2",
 CellID->250839057],
Cell[12224, 350, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"789b8be6-a94c-4c25-8afd-3600a590556b"],
Cell[12313, 352, 241, 5, 70, "Tutorials",ExpressionUUID->"b1f66dea-fcae-43a1-9e6f-abb6ee26be17",
 CellID->341631938]
}, Open  ]],
Cell[12569, 360, 78, 0, 70, "FooterCell",ExpressionUUID->"ed04160e-f031-483b-a8b0-c4ca3b022344"]
}
]
*)

(* End of internal cache information *)

