(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     39152,       1049]
NotebookOptionsPosition[     29970,        860]
NotebookOutlinePosition[     32580,        922]
CellTagsIndexPosition[     32495,        917]
WindowTitle->Plethysms
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "65761fb2-f4ec-4925-9be8-5f8fcff9e1a3"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"24f9b3e2-e7a9-48bc-9bc1-345ac2a9c108"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "21366c01-1f41-4b14-bc0a-3307ee778588"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"bf7c10b0-3c7c-49fd-af78-8bcd6a304911"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"PermutationSymmetry\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/PermutationSymmetry"], \
"\<\"PermutationSymmetryOfInvariants\"\>":>Documentation`HelpLookup[
       "paclet:GroupMath/ref/PermutationSymmetryOfInvariants"], \
"\<\"ReduceRepProduct\"\>":>Documentation`HelpLookup[
       "paclet:GroupMath/ref/ReduceRepProduct"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "20b4743e-89db-4149-954b-29ce67884d0c"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"e79814cf-660c-4d9c-907f-38fbf74e1be8"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/Plethysms\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/Plethysms"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
Plethysms.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]},
             Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$22277], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/Plethysms", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "0f51f58b-dad9-4de2-aca7-9b83015aef56"]
    }], "AnchorBar",ExpressionUUID->"521f4b65-ecf8-48e0-a618-93dc308015f8"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"5286cabf-3bae-4b74-9f86-227bc503fa0f"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["Plethysms", "ObjectName",ExpressionUUID->
  "2f1613be-151f-4b27-bfb1-eb53169548f7"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"57d0df1e-9f62-4862-9a1e-c896c0870032"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "5876a754-6017-4d45-a0bc-eb17e0540b99"]
}], "ObjectNameGrid",ExpressionUUID->"1cc54c52-2876-4fdb-9cc6-b5f7983be61a"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Plethysms", "[", 
       RowBox[{
        RowBox[{"gauge", " ", "group"}], ",", " ", 
        RowBox[{
        "representation", " ", "of", " ", "the", " ", "gauge", " ", "group"}],
         ",", " ", 
        RowBox[{"partition", " ", "of", " ", "n"}]}], "]"}]], "InlineFormula",
      ExpressionUUID->"66b3323b-b32a-42d0-b32f-9e345adc8b62"],
     " \[LineSeparator]Computes the break down of product of ",
     Cell[BoxData[
     "n"], "InlineFormula",ExpressionUUID->
      "248c406f-b145-478b-9e0e-101df02c2b95"],
     " copies of the given representation of the gauge group in irreducible \
parts, which transform according to a given representation of the ",
     Cell[BoxData[
      SubscriptBox["S", "n"]], "InlineFormula",ExpressionUUID->
      "45fc3802-b806-4472-a0ba-9f9aa3290e0c"],
     " group under permutations of the fields"
    }],ExpressionUUID->"d1bd91bf-3ed2-48d9-9c88-a4bf1d13c87f"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"bb2d989d-e9d2-44d7-b77d-a68d6ff54792"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"b389fe55-9d60-4e60-af6e-8b45b559617d"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"18c1c6b4-b9fe-45c2-b4c4-5234cf276327"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"528e6814-7ee7-47af-a2ac-b82ec8b7818b"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->136174238,ExpressionUUID->"392410ab-52fa-4539-ade9-c8e857d21c70"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"edecfcb2-f720-48ce-9cb4-95de155c0630"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"gauge", " ", "group"}]], "InlineFormula",ExpressionUUID->
  "51345c48-2cf3-405c-84be-669a3ec07185"],
 " should be a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/ref/CartanMatrix"],
 " (it must correspond to a simple group)."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"d1ae9412-6eb8-4e9a-9242-cb66dc8fe849"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
  "representation", " ", "of", " ", "the", " ", "gauge", " ", "group"}]], 
  "InlineFormula",ExpressionUUID->"a44873e8-0f24-4aa1-8ac2-622acdf0c592"],
 " should be a list of non-negative integers (Dynkin coefficients). It is \
also possible to use the simplified input format for representations (see the \
",
 ButtonBox["GroupMath tutorial",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/tutorial/GroupMathDoc"],
 " page)."
}], "Notes",
 CellID->77911800,ExpressionUUID->"b826dbb6-a71d-4a24-b7bf-dfd686972491"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  SuperscriptBox["\[Phi]", "i"]], "InlineFormula",ExpressionUUID->
  "35863517-9a6c-4bc7-b2ef-61aaf84b9557"],
 " are some fields transforming according to some representation of a simple \
gauge group G, the product  ",
 Cell[BoxData[
  SuperscriptBox["\[Phi]", "1"]], "InlineFormula",ExpressionUUID->
  "a86502ad-80dc-4a09-be8f-9a687729c9c3"],
 "\[Times] ",
 Cell[BoxData[
  SuperscriptBox["\[Phi]", "2"]], "InlineFormula",ExpressionUUID->
  "8879bf1f-1e45-47b1-8dc7-420c666660cd"],
 "\[Times]\[CenterEllipsis]\[Times]",
 Cell[BoxData[
  SuperscriptBox["\[Phi]", "n"]], "InlineFormula",ExpressionUUID->
  "3480b7aa-d82b-4b3d-9e2a-6c205df7b648"],
 " can be broken down into irreducible representations of the group ",
 Cell[BoxData[
  RowBox[{"G", "\[Times]", 
   SubscriptBox["S", "n"]}]], "InlineFormula",ExpressionUUID->
  "cb7cf33f-0444-41d5-8b1f-8f0fc1df9f5e"],
 " (plethysms)."
}], "Notes",
 CellID->53705956,ExpressionUUID->"e576ff17-9c12-485c-a63a-66f57a531974"],

Cell[TextData[{
 "This function returns a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"gauge", " ", "rep1"}], ",", "multiplicity1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"gauge", " ", "rep2"}], ",", "multiplicity2"}], "}"}], ",", " ",
     "..."}], "}"}]], "InlineFormula",ExpressionUUID->
  "4165ffa7-8f29-4b11-a8a4-965778cc234a"],
 " containing the gauge representations (with multiplicity) which are in the \
product of n copies of the given ",
 Cell[BoxData[
  RowBox[{
  "representation", " ", "of", " ", "the", " ", "gauge", " ", "group"}]], 
  "InlineFormula",ExpressionUUID->"d0194a1b-dd34-4517-98f6-532ccd054700"],
 ", and which transform according to the representation of the ",
 Cell[BoxData[
  SubscriptBox["S", "n"]], "InlineFormula",ExpressionUUID->
  "c08b1c8e-5034-4709-a2dd-78087e2503c7"],
 " group supplied by the user (",
 Cell[BoxData[
  RowBox[{"partition", " ", "of", " ", "n"}]], "InlineFormula",ExpressionUUID->
  "0dd3ca0a-8770-4fcd-a3a3-091bc16f50cc"],
 "), when permutations are performed on the representations being multiplied."
}], "Notes",
 CellID->106537809,ExpressionUUID->"e4df8da3-ea16-46f2-bede-c90f26dad879"],

Cell[TextData[{
 Cell[BoxData[
 "Plethysms"], "InlineFormula",ExpressionUUID->
  "cc604d3a-4dc9-4e07-9bbd-3aa9d794f448"],
 " follows the algorithm ",
 "described in",
 " ",
 StyleBox["M. A. A. van Leeuwen, A. M. Cohen, and B. Lisser, LiE, A Package \
for Lie Group Computations. Computer Algebra Nederland, 1992",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->225128198,ExpressionUUID->"974fc1de-d09a-476b-8592-c081c229cd63"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"e52c54d4-57a4-4e38-a07e-4a461307b84e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"68a43885-afc6-4a9d-8d18-db4fec9f6746"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "de13f60d-b386-449b-a1a1-122a84bb6a6b"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->486793868,ExpressionUUID->"bd2e83ce-1a71-4b11-9f36-f60eb6b43ab0"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "d1f4255a-d73d-4ec1-8c15-400c9a234841"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->37943911,ExpressionUUID->"f31d4b90-97f0-4086-aff6-7c2e048d14ac"],

Cell[TextData[{
 "Two SU(2) doublets (={1}) form a singlet {0} and a triplet {2}. The singlet \
is known to be an antisymmetric combination of the two doublets ({1,1} \
representation of ",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula",ExpressionUUID->
  "07653543-a036-480f-9296-aac1345d1253"],
 ") and the triplet is a symmetric one ({2} representation of ",
 Cell[BoxData[
  SubscriptBox["S", "2"]], "InlineFormula",ExpressionUUID->
  "a375761f-60d2-4cc0-9a90-8e4a5479223c"],
 "):"
}], "ExampleText",
 CellID->32979335,ExpressionUUID->"e58b3f79-1fee-432d-8e04-175be8ff7b3c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plethysms", "[", 
  RowBox[{"SU2", ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plethysms", "[", 
  RowBox[{"SU2", ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->651302308,ExpressionUUID->"d30fd92c-3f5e-497e-8ff0-f497b64e1a52"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "0", "}"}], ",", "1"}], "}"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->384717579,ExpressionUUID->"4879999c-1cd8-4700-96c5-dbc7eb0cba41"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "2", "}"}], ",", "1"}], "}"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->37569318,ExpressionUUID->"6245ef8b-78cf-4637-a89b-5edf3262a786"]
}, Open  ]],

Cell["\<\
The simplified input format for representations of the Lie group can be used, \
so the above is equivalent to this:\
\>", "ExampleText",
 CellID->202198849,ExpressionUUID->"ef0f11d9-c721-4a59-9541-467ab7928611"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plethysms", "[", 
  RowBox[{"SU2", ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plethysms", "[", 
  RowBox[{"SU2", ",", "2", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->669883045,ExpressionUUID->"ec7c05c8-0e51-4ea2-87fa-6d27a9146e0a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "0", "}"}], ",", "1"}], "}"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->140506171,ExpressionUUID->"530c95c6-5adb-420e-ad4a-13eb3facf2d5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "2", "}"}], ",", "1"}], "}"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->829741532,ExpressionUUID->"b741b669-250c-4344-9cac-113130ba9a5f"]
}, Open  ]],

Cell["\<\
Furthermore, the option UseName->True can be used to rewrite automatically \
the Dynkin coefficients in the output into the representation's name:\
\>", "ExampleText",
 CellID->145425172,ExpressionUUID->"51b09787-a05b-4303-8609-fa6e59161316"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plethysms", "[", 
  RowBox[{"SU2", ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"UseName", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plethysms", "[", 
  RowBox[{"SU2", ",", "2", ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"UseName", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->115884006,ExpressionUUID->"c95c4f07-0246-45e3-aa78-e4a8e0a38bd6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    StyleBox["\<\"1\"\>",
     StripOnInput->False,
     FontWeight->Bold], ",", "1"}], "}"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->21322997,ExpressionUUID->"46442e99-7f9c-4622-916d-3210478c8729"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    StyleBox["\<\"3\"\>",
     StripOnInput->False,
     FontWeight->Bold], ",", "1"}], "}"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->188389597,ExpressionUUID->"8071e109-2891-4056-946c-55e469d0c640"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "a13fc97d-bb50-4a9e-85c4-a7461465cb60"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119280766,ExpressionUUID->"d396c8a0-f14b-47d5-af0a-d0deb1abee65"],

Cell["\<\
Consider three SU(3) fundamental representations. Their product breaks into \
one 10 representation, plus two 8's plus one singlet:\
\>", "ExampleText",
 CellID->373992796,ExpressionUUID->"b1427075-1249-482c-90e3-4f37882f3105"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReduceRepProduct", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"UseName", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90866564,ExpressionUUID->"f330486c-7b0f-47b1-8d14-7356e51abff2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["\<\"10\"\>",
      StripOnInput->False,
      FontWeight->Bold], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["\<\"8\"\>",
      StripOnInput->False,
      FontWeight->Bold], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontWeight->Bold], ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->505493253,ExpressionUUID->"659d8e13-1715-4b60-b385-69f49fcdaf73"]
}, Open  ]],

Cell[TextData[{
 "However, ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ReduceRepProduct"]],"paclet:GroupMath/ref/ReduceRepProduct"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "7ce8429f-495b-474c-9297-35c23db92750"],
 " does not return information on how these irreducible representations of \
the gauge group change under a permutation of the three fundamental \
representations of SU(3). In other words, it does not tell what are the ",
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula",ExpressionUUID->
  "5dbc57b1-c063-4b14-807a-8ddb30df2ba1"],
 " irreducible representations that 10+8+8+1 are in. This can be found with \
the ",
 Cell[BoxData[
 "Plethysms"], "InlineFormula",ExpressionUUID->
  "2672b56e-4cc4-4c76-8408-edc1efb156af"],
 " function: the representation 10 is completely symmetric (irrep {3} of ",
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula",ExpressionUUID->
  "ae1e3814-c4b3-4931-be65-b92c144f2c4e"],
 ") under a permutation of the triplets being multiplied, 1 is completely \
antisymmetric (irrep {1,1,1} of ",
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula",ExpressionUUID->
  "069bad3e-6565-468b-bf99-fe1180fe02cd"],
 ") and the two8's are of mixed symmetry (they are in a 2-dimensional {2,1} \
irrep of ",
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula",ExpressionUUID->
  "a958ce09-8b96-4961-9a35-15a4313bfae9"],
 ")."
}], "ExampleText",
 CellID->40383509,ExpressionUUID->"617b2668-734a-4fec-ab66-d3ea47dfb07d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plethysms", "[", 
  RowBox[{"SU3", ",", "3", ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"UseName", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plethysms", "[", 
  RowBox[{"SU3", ",", "3", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"UseName", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plethysms", "[", 
  RowBox[{"SU3", ",", "3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"UseName", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->46820094,ExpressionUUID->"48c6c3b3-4ddc-4e10-9f11-57ba87bfd205"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    StyleBox["\<\"10\"\>",
     StripOnInput->False,
     FontWeight->Bold], ",", "1"}], "}"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->235793954,ExpressionUUID->"f6c980d8-11a0-425a-b954-9bb6710cfaaf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    StyleBox["\<\"8\"\>",
     StripOnInput->False,
     FontWeight->Bold], ",", "1"}], "}"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->146442518,ExpressionUUID->"f336afc2-e183-4168-a9d1-d60e63753c46"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    StyleBox["\<\"1\"\>",
     StripOnInput->False,
     FontWeight->Bold], ",", "1"}], "}"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->71042309,ExpressionUUID->"7b688599-de1d-4f72-baeb-cba2de00e7e1"]
}, Open  ]],

Cell[TextData[{
 "Even better, the function ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["PermutationSymmetry"]],
    "paclet:GroupMath/ref/PermutationSymmetry"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Consolas"}]], "InlineFormula",
  ExpressionUUID->"0733dd69-5906-4653-967c-6fe096a32c6a"],
 " provides this information in a single line (please see its documentation \
for details):"
}], "ExampleText",
 CellID->507269474,ExpressionUUID->"f2ce8163-9703-47bb-a819-4a324a6f761b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermutationSymmetry", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"UseName", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->252075103,ExpressionUUID->"504b9f0e-64e1-4d41-9b41-66d687b5e13b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         StyleBox["\<\"10\"\>",
          StripOnInput->False,
          FontWeight->Bold], ",", 
         RowBox[{"{", 
          GraphicsBox[
           TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBbCBOamKOsVEOM5DJA8RyQAxSyMDQ
YM8wIunB4AZa0rj8S61wG+zmDBV3jvp31L+j/h267hz176h/SfHvcKUHgxvo
TwMA+IQU1Q==
             "], {{0, 12}, {30, 0}}, {0., 1.},
             ColorFunction->GrayLevel],
            BoxForm`ImageTag[
            "Real32", ColorSpace -> "Grayscale", Interleaving -> False, 
             Magnification -> Automatic],
            Selectable->False],
           DefaultBaseStyle->"ImageGraphics",
           ImageSize->{30, 12},
           ImageSizeRaw->{30, 12},
           PlotRange->{{0, 30}, {0, 12}}], "}"}]}], "}"}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         StyleBox["\<\"8\"\>",
          StripOnInput->False,
          FontWeight->Bold], ",", 
         RowBox[{"{", 
          GraphicsBox[
           TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBbCBOamKOsVEOM5ApCsUghQwMDfYM
Q4oeDG7ARuNyJ7X8SytzRt056s5Rd466c7C6c7DRgz08Byq+Rt056s7BYP6o
O4emO6lF08qdg5sGAJzZUUQ=
             "], {{0, 21}, {21, 0}}, {0., 1.},
             ColorFunction->GrayLevel],
            BoxForm`ImageTag[
            "Real32", ColorSpace -> "Grayscale", Interleaving -> False, 
             Magnification -> Automatic],
            Selectable->False],
           DefaultBaseStyle->"ImageGraphics",
           ImageSize->{21, 21},
           ImageSizeRaw->{21, 21},
           PlotRange->{{0, 21}, {0, 21}}], "}"}]}], "}"}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         StyleBox["\<\"1\"\>",
          StripOnInput->False,
          FontWeight->Bold], ",", 
         RowBox[{"{", 
          GraphicsBox[
           TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBbCBOamKOsVEOM5ApB8Q8QAxSyMDQ
YM9AF5raZuIyn1ruHDV/1PyhaD616OEaPqPmj5pPifnUoodr+IyaP2o+JeZT
i6amWbhpAPjMFNU=
             "], {{0, 30}, {12, 0}}, {0., 1.},
             ColorFunction->GrayLevel],
            BoxForm`ImageTag[
            "Real32", ColorSpace -> "Grayscale", Interleaving -> False, 
             Magnification -> Automatic],
            Selectable->False],
           DefaultBaseStyle->"ImageGraphics",
           ImageSize->{12, 30},
           ImageSizeRaw->{12, 30},
           PlotRange->{{0, 12}, {0, 30}}], "}"}]}], "}"}], ",", "1"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->429589518,ExpressionUUID->"8b067500-d789-4a73-9772-9e9b4decf5a0"]
}, Open  ]],

Cell[TextData[{
 "If we care only about the group group singlets (i.e. the SU(3) singlet in \
this example), then the function ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["PermutationSymmetryOfInvariants"]],
    "paclet:GroupMath/ref/PermutationSymmetryOfInvariants"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "af379600-643b-4deb-beef-2b052acaea7e"],
 " can be used (please see its documentation for details):"
}], "ExampleText",
 CellID->121330172,ExpressionUUID->"e64d2193-1479-4626-931c-1d93559f338e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermutationSymmetryOfInvariants", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"UseName", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->611450105,ExpressionUUID->"714bb47c-1a5d-4ab9-ad98-2a7773226c6b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBbCBOamKOsVEOM5ApB8Q8QAxSyMDQ
YM9AF5raZuIyn1ruHDV/1PyhaD616OEaPqPmj5pPifnUoodr+IyaP2o+JeZT
i6amWbhpAPjMFNU=
          "], {{0, 30}, {12, 0}}, {0., 1.},
          ColorFunction->GrayLevel],
         BoxForm`ImageTag[
         "Real32", ColorSpace -> "Grayscale", Interleaving -> False, 
          Magnification -> Automatic],
         Selectable->False],
        DefaultBaseStyle->"ImageGraphics",
        ImageSize->{12, 30},
        ImageSizeRaw->{12, 30},
        PlotRange->{{0, 12}, {0, 30}}], "}"}], ",", "1"}], "}"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->406391109,ExpressionUUID->"93201399-f2de-491e-886b-1687886d346f"]
}, Open  ]],

Cell[TextData[{
 "The output says that there is 1 SU(3) invariant, and it transforms in a \
completely anti-symmetric way (irrep {1,1,1} of ",
 Cell[BoxData[
  SubscriptBox["S", "3"]], "InlineFormula",ExpressionUUID->
  "ab2ae001-42ba-4648-bde0-7897806e6474"],
 ")."
}], "ExampleText",
 CellID->41060410,ExpressionUUID->"dc14eea0-bafb-499b-8542-086dfd2ad548"]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"1ebc6c81-1333-4ce9-8c8b-06bf0ff51d48"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"737c87f3-3001-40ed-9b75-d535ecb49245"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"a61b3e29-9f21-42fb-93f5-c06551e80dcb"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["PermutationSymmetry"]],
    "paclet:GroupMath/ref/PermutationSymmetry"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"9677fb7f-eabc-4afc-b0c0-20c95287c124"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["PermutationSymmetryOfInvariants"]],
    "paclet:GroupMath/ref/PermutationSymmetryOfInvariants"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"203dc7db-9b15-4b76-b88f-1802587dc69c"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ReduceRepProduct"]],"paclet:GroupMath/ref/ReduceRepProduct"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"55e069fd-b4c1-41a2-ab7d-eface1f37fd8"]
}], "SeeAlso",
 CellID->1038487239,ExpressionUUID->"9bba73b6-c5a4-41bd-8dd0-d5b22b7ca4a6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"428027d1-f181-48f0-a068-29ea33f690eb"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"affb2a08-960c-4e21-8dd9-7f35aa4c7ac4"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"a72840d8-5b57-4803-83c3-e99b0d381d9b"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"ac48978a-3b78-4da3-8fc2-f92061cef075"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"ab7db1da-4644-4950-80f4-9f1f22e25132"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"6e660942-08a8-4755-8db1-c214aac80118"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"1926befc-aa33-489c-b034-311884b547ec"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"f2bcfd43-d42f-4c7d-8a27-c149805686ed"],

Cell[TextData[StyleBox["M. A. A. van Leeuwen, A. M. Cohen, and B. Lisser, \
LiE, A Package for Lie Group Computations. Computer Algebra Nederland, 1992", \
"TR"]], "SeeAlso",
 CellID->18928657,ExpressionUUID->"f043f66a-b329-471b-bf04-e05f7045d0ae"],

Cell[TextData[{
 StyleBox["M. A. A. van Leeuwen, A. M. Cohen, and B. Lisser, \
\[OpenCurlyDoubleQuote]LiE - A Computer algebra package for Lie group \
computations.\[CloseCurlyDoubleQuote] ", "TR"],
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE"]],
    "http://wwwmathlabo.univ-poitiers.fr/~maavl/LiE/"},
   "WebLink",
   BaseStyle->{"RelatedLinks", "TR"}]],ExpressionUUID->
  "24042f60-4f23-46bf-8be3-6661ef75f722"],
 StyleBox[", 2012. Retrieved 15 January 2020.", "TR"]
}], "RelatedLinks",
 CellID->656640475,ExpressionUUID->"2fe96951-2e1a-4ce7-bb02-2bbea304bad6"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"2748b69d-c5b3-4c25-adbf-7ddaf437ca65"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Plethysms",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 13, 46.5734822}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "Plethysms[gauge group, representation of the gauge group, partition of \
n] Computes the break down of product of n copies of the given representation \
of the gauge group in irreducible parts, which transform according to a given \
representation of the Sn group under permutations of the fields", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "Plethysms", 
    "titlemodifier" -> "", "windowtitle" -> "Plethysms", "type" -> "Symbol", 
    "uri" -> "GroupMath/ref/Plethysms", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11240, 293, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"bd2e83ce-1a71-4b11-9f36-f60eb6b43ab0",
   CellTags->"PrimaryExamplesSection",
   CellID->486793868]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32296, 910}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[581, 21, 4334, 98, 53, "AnchorBarGrid",ExpressionUUID->"5286cabf-3bae-4b74-9f86-227bc503fa0f",
 CellID->1],
Cell[CellGroupData[{
Cell[4940, 123, 394, 9, 52, "ObjectNameGrid",ExpressionUUID->"1cc54c52-2876-4fdb-9cc6-b5f7983be61a"],
Cell[5337, 134, 1162, 25, 151, "Usage",ExpressionUUID->"bb2d989d-e9d2-44d7-b77d-a68d6ff54792",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6536, 164, 855, 21, 37, "NotesSection",ExpressionUUID->"392410ab-52fa-4539-ade9-c8e857d21c70",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->136174238],
Cell[7394, 187, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"edecfcb2-f720-48ce-9cb4-95de155c0630"],
Cell[7483, 189, 394, 10, 70, "Notes",ExpressionUUID->"d1ae9412-6eb8-4e9a-9242-cb66dc8fe849",
 CellID->1067943069],
Cell[7880, 201, 559, 13, 70, "Notes",ExpressionUUID->"b826dbb6-a71d-4a24-b7bf-dfd686972491",
 CellID->77911800],
Cell[8442, 216, 1009, 25, 70, "Notes",ExpressionUUID->"e576ff17-9c12-485c-a63a-66f57a531974",
 CellID->53705956],
Cell[9454, 243, 1227, 29, 70, "Notes",ExpressionUUID->"e4df8da3-ea16-46f2-bede-c90f26dad879",
 CellID->106537809],
Cell[10684, 274, 430, 12, 70, "Notes",ExpressionUUID->"974fc1de-d09a-476b-8592-c081c229cd63",
 CellID->225128198],
Cell[11117, 288, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"e52c54d4-57a4-4e38-a07e-4a461307b84e"]
}, Closed]],
Cell[CellGroupData[{
Cell[11240, 293, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"bd2e83ce-1a71-4b11-9f36-f60eb6b43ab0",
 CellTags->"PrimaryExamplesSection",
 CellID->486793868],
Cell[CellGroupData[{
Cell[11700, 308, 307, 7, 29, "ExampleSection",ExpressionUUID->"f31d4b90-97f0-4086-aff6-7c2e048d14ac",
 CellID->37943911],
Cell[12010, 317, 589, 13, 76, "ExampleText",ExpressionUUID->"e58b3f79-1fee-432d-8e04-175be8ff7b3c",
 CellID->32979335],
Cell[CellGroupData[{
Cell[12624, 334, 416, 11, 43, "Input",ExpressionUUID->"d30fd92c-3f5e-497e-8ff0-f497b64e1a52",
 CellID->651302308],
Cell[13043, 347, 220, 6, 35, "Output",ExpressionUUID->"4879999c-1cd8-4700-96c5-dbc7eb0cba41",
 CellID->384717579],
Cell[13266, 355, 219, 6, 35, "Output",ExpressionUUID->"6245ef8b-78cf-4637-a89b-5edf3262a786",
 CellID->37569318]
}, Open  ]],
Cell[13500, 364, 221, 4, 57, "ExampleText",ExpressionUUID->"ef0f11d9-c721-4a59-9541-467ab7928611",
 CellID->202198849],
Cell[CellGroupData[{
Cell[13746, 372, 368, 9, 43, "Input",ExpressionUUID->"ec7c05c8-0e51-4ea2-87fa-6d27a9146e0a",
 CellID->669883045],
Cell[14117, 383, 220, 6, 35, "Output",ExpressionUUID->"530c95c6-5adb-420e-ad4a-13eb3facf2d5",
 CellID->140506171],
Cell[14340, 391, 220, 6, 35, "Output",ExpressionUUID->"b741b669-250c-4344-9cac-113130ba9a5f",
 CellID->829741532]
}, Open  ]],
Cell[14575, 400, 252, 4, 57, "ExampleText",ExpressionUUID->"51b09787-a05b-4303-8609-fa6e59161316",
 CellID->145425172],
Cell[CellGroupData[{
Cell[14852, 408, 466, 11, 70, "Input",ExpressionUUID->"c95c4f07-0246-45e3-aa78-e4a8e0a38bd6",
 CellID->115884006],
Cell[15321, 421, 266, 8, 35, "Output",ExpressionUUID->"46442e99-7f9c-4622-916d-3210478c8729",
 CellID->21322997],
Cell[15590, 431, 267, 8, 35, "Output",ExpressionUUID->"8071e109-2891-4056-946c-55e469d0c640",
 CellID->188389597]
}, Open  ]],
Cell[CellGroupData[{
Cell[15894, 444, 242, 5, 70, "ExampleDelimiter",ExpressionUUID->"d396c8a0-f14b-47d5-af0a-d0deb1abee65",
 CellID->119280766],
Cell[16139, 451, 237, 4, 70, "ExampleText",ExpressionUUID->"b1427075-1249-482c-90e3-4f37882f3105",
 CellID->373992796],
Cell[CellGroupData[{
Cell[16401, 459, 299, 7, 70, "Input",ExpressionUUID->"f330486c-7b0f-47b1-8d14-7356e51abff2",
 CellID->90866564],
Cell[16703, 468, 554, 19, 35, "Output",ExpressionUUID->"659d8e13-1715-4b60-b385-69f49fcdaf73",
 CellID->505493253]
}, Open  ]],
Cell[17272, 490, 1528, 35, 70, "ExampleText",ExpressionUUID->"617b2668-734a-4fec-ab66-d3ea47dfb07d",
 CellID->40383509],
Cell[CellGroupData[{
Cell[18825, 529, 671, 16, 70, "Input",ExpressionUUID->"48c6c3b3-4ddc-4e10-9f11-57ba87bfd205",
 CellID->46820094],
Cell[19499, 547, 268, 8, 35, "Output",ExpressionUUID->"f6c980d8-11a0-425a-b954-9bb6710cfaaf",
 CellID->235793954],
Cell[19770, 557, 267, 8, 35, "Output",ExpressionUUID->"f336afc2-e183-4168-a9d1-d60e63753c46",
 CellID->146442518],
Cell[20040, 567, 266, 8, 35, "Output",ExpressionUUID->"7b688599-de1d-4f72-baeb-cba2de00e7e1",
 CellID->71042309]
}, Open  ]],
Cell[20321, 578, 508, 12, 70, "ExampleText",ExpressionUUID->"f2ce8163-9703-47bb-a819-4a324a6f761b",
 CellID->507269474],
Cell[CellGroupData[{
Cell[20854, 594, 303, 7, 70, "Input",ExpressionUUID->"504b9f0e-64e1-4d41-9b41-66d687b5e13b",
 CellID->252075103],
Cell[21160, 603, 2895, 81, 53, "Output",ExpressionUUID->"8b067500-d789-4a73-9772-9e9b4decf5a0",
 CellID->429589518]
}, Open  ]],
Cell[24070, 687, 556, 12, 70, "ExampleText",ExpressionUUID->"e64d2193-1479-4626-931c-1d93559f338e",
 CellID->121330172],
Cell[CellGroupData[{
Cell[24651, 703, 315, 7, 70, "Input",ExpressionUUID->"714bb47c-1a5d-4ab9-ad98-2a7773226c6b",
 CellID->611450105],
Cell[24969, 712, 950, 27, 53, "Output",ExpressionUUID->"93201399-f2de-491e-886b-1687886d346f",
 CellID->406391109]
}, Open  ]],
Cell[25934, 742, 359, 8, 70, "ExampleText",ExpressionUUID->"dc14eea0-bafb-499b-8542-086dfd2ad548",
 CellID->41060410]
}, Open  ]]
}, Open  ]],
Cell[26320, 754, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"1ebc6c81-1333-4ce9-8c8b-06bf0ff51d48"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26443, 759, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"a61b3e29-9f21-42fb-93f5-c06551e80dcb",
 CellID->1255426704],
Cell[26706, 768, 1178, 30, 70, "SeeAlso",ExpressionUUID->"9bba73b6-c5a4-41bd-8dd0-d5b22b7ca4a6",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[27921, 803, 262, 7, 70, "TutorialsSection",ExpressionUUID->"affb2a08-960c-4e21-8dd9-7f35aa4c7ac4",
 CellID->250839057],
Cell[28186, 812, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"a72840d8-5b57-4803-83c3-e99b0d381d9b"],
Cell[28275, 814, 241, 5, 70, "Tutorials",ExpressionUUID->"ac48978a-3b78-4da3-8fc2-f92061cef075",
 CellID->341631938],
Cell[28519, 821, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"ab7db1da-4644-4950-80f4-9f1f22e25132"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28642, 826, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"1926befc-aa33-489c-b034-311884b547ec",
 CellID->1584193535],
Cell[28915, 835, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"f2bcfd43-d42f-4c7d-8a27-c149805686ed"],
Cell[29004, 837, 248, 3, 70, "SeeAlso",ExpressionUUID->"f043f66a-b329-471b-bf04-e05f7045d0ae",
 CellID->18928657],
Cell[29255, 842, 618, 13, 70, "RelatedLinks",ExpressionUUID->"2fe96951-2e1a-4ce7-bb02-2bbea304bad6",
 CellID->656640475]
}, Open  ]],
Cell[29888, 858, 78, 0, 70, "FooterCell",ExpressionUUID->"2748b69d-c5b3-4c25-adbf-7ddaf437ca65"]
}
]
*)

(* End of internal cache information *)

