(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     25509,        698]
NotebookOptionsPosition[     19020,        562]
NotebookOutlinePosition[     21590,        623]
CellTagsIndexPosition[     21505,        618]
WindowTitle->LittlewoodRichardsonCoefficients
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "8e85beb3-fcbb-40ca-a191-8539e37f1d3b"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"977e5ed3-b39e-417a-8bdf-f1802a4115c9"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "041014f9-6aa6-4965-b3f2-3ee1a683b73e"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"15283562-6a80-4ae7-b8b9-6c9eef4f0e22"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"ReduceRepProduct\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/ReduceRepProduct"], "\<\"SnBranchingRules\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/ref/SnBranchingRules"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "45dc8c89-3180-4772-88f5-00af4071b9ca"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"92875152-827c-45e5-b546-3d76c22a5f3d"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->
         False], {"\<\"GroupMath/ref/LittlewoodRichardsonCoefficients\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/LittlewoodRichardsonCoefficients"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
LittlewoodRichardsonCoefficients.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$20099], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/LittlewoodRichardsonCoefficients", ".html"]], 
           None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "6945b9dc-6b45-4b3d-bd54-8954dbcebd39"]
    }], "AnchorBar",ExpressionUUID->"8bdb479e-5d0d-43a7-97b8-dabcfa734cb9"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"c5c2cb36-6d96-41b2-819e-7f0d5f46cb1a"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["LittlewoodRichardsonCoefficients", "ObjectName",ExpressionUUID->
  "bd2e43f5-cbb3-4ee4-b47c-9b86b3a3f197"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"66e2328c-5fce-45a5-8a10-760e2e42a226"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "8964c860-415f-4675-b565-a2e05b91eb94"]
}], "ObjectNameGrid",ExpressionUUID->"baf80822-09b6-43ae-92a0-38d702d1a4ae"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LittlewoodRichardsonCoefficients", "[", 
       RowBox[{"list", " ", "of", " ", "partitons"}], "]"}]], "InlineFormula",
      ExpressionUUID->"05df8ef3-31d1-4924-a340-028afac0d2a0"],
     " \[LineSeparator]Calculates the Littlewood-Richardson coefficients for \
the permutation group representations given as a list"
    }],ExpressionUUID->"20975f99-2c06-47d4-b356-2d6d7100c932"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"632619ca-7f6f-40b6-b3bd-b12a8067a2ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"99026722-422d-4eb7-bbcf-d5519b997bf1"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"e226e7b4-5ea2-4571-8877-02ad9de28e20"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"ba23c25e-d331-43fb-9924-c5c2f90808a7"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->8660249,ExpressionUUID->"587a4d92-e7a5-451c-972b-89bb835bd198"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"2a2eb094-f44d-4639-8275-e4044a088e92"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"list", " ", "of", " ", "Sn", " ", "representations"}]], 
  "InlineFormula",ExpressionUUID->"4d480a3d-25e0-498b-a903-4b1f674a9481"],
 " must be a list of partitions {\[Lambda]1, \[Lambda]2,...} of natural \
numbers n1, n2, ..."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"303a24e5-763b-422e-81ae-2ae09abf1026"],

Cell[TextData[{
 "The Littlewood-Richardson coefficients can be interpreted in many different \
ways (see ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["here"]],
    "http://en.wikipedia.org/wiki/Littlewood%E2%80%93Richardson_rule#\
Littlewood%E2%80%93Richardson_coefficients"},
   "WebLink",
   BaseStyle->{"Notes"}]],ExpressionUUID->
  "788a1613-829d-4142-bad5-4ba829dedb15"],
 " for details). On the them is the following: it provides the number of \
times that the product \[Lambda]1 x \[Lambda]2 x ... of Sn1 x Sn2 x ... is \
contained in each of the irreps of the larger group SN, with N=n1+n2+... \
components."
}], "Notes",
 CellID->231691174,ExpressionUUID->"e29c2197-206f-48c4-a98a-c0983329c5b1"],

Cell[TextData[{
 "This function is related to ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ReduceRepProduct"]],"paclet:GroupMath/ref/ReduceRepProduct"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "0a8da9b3-2a66-4cd7-a318-5b9ef30e52e1"],
 " applied to SU(n) Lie groups. On the other hand, it is also closelly \
related to ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["SnBranchingRules"]],"paclet:GroupMath/ref/SnBranchingRules"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Consolas"}]], "InlineFormula",
  ExpressionUUID->"b71aa055-3b76-4597-bdf0-443f2dea5a79"],
 "."
}], "Notes",
 CellID->168134201,ExpressionUUID->"70412be9-70c7-4ca6-9f04-86fe2a2efaf1"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"b0a29455-333b-43b1-8d33-3b6f003b17fc"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"84ad13f6-06b8-4fb0-9001-3bcfcbb4fb91"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "31c733a2-05dc-4834-8560-2e38cd1b1aae"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->183126480,ExpressionUUID->"cacfa53d-9fea-46de-853a-12abd389c986"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "92d16c74-9cec-4eac-ac4c-9a7c626e8d17"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->523946922,ExpressionUUID->"92a1fc2f-ba8d-48c4-b75a-f4bbd242e112"],

Cell[TextData[{
 "Consider the representation R={2,1} x {2, 2} of S3 x S4. This permutation \
group is a subgroup of S7, so we might want to know, for each of the irreps \
of S7, how many copies of the R sub-representation does it contain, if any. ",
 Cell[BoxData[
 "LittlewoodRichardsonCoefficients"], "InlineFormula",ExpressionUUID->
  "f78701e4-59c5-49ba-9fe2-18e8ffb7a288"],
 " provides us with the following answer:"
}], "ExampleText",
 CellID->329238481,ExpressionUUID->"d474c901-d683-457e-a6b3-98123c3564b8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"R", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"LittlewoodRichardsonCoefficients", "[", "R", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->250692952,ExpressionUUID->"52da26f6-672a-4f46-82fc-63e00400a0d6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1", ",", "1"}], "}"}], ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", "1"}], "}"}]}],
   "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->65825606,ExpressionUUID->"995fb9b3-e4b0-41ec-aa71-c37e9b9654ab"]
}, Open  ]],

Cell[TextData[{
 "This output states that {4,3}, {4,2,1}, {3,2,2}, {3,3,1}, {3,2,1,1} and \
{2,2,2,1} all contain exactly once the R sub-representation. We could have \
found this information by using the function ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["SnBranchingRules"]],"paclet:GroupMath/ref/SnBranchingRules"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Consolas"}]], "InlineFormula",
  ExpressionUUID->"7d438a1b-1788-4817-8907-bba25bed306b"],
 " to each of these S7 irreps:"
}], "ExampleText",
 CellID->339308793,ExpressionUUID->"1ffc6258-b140-4284-b14e-b8f168bc67a1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"SnBranchingRules", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"R", ",", "_"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"SnBranchingRules", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"R", ",", "_"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"SnBranchingRules", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"R", ",", "_"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"SnBranchingRules", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"R", ",", "_"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"SnBranchingRules", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"R", ",", "_"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"SnBranchingRules", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"R", ",", "_"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->115422392,ExpressionUUID->"f4e53ab3-dda1-4016-ada3-6ee507aa0a0b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", "1"}], "}"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->85890577,ExpressionUUID->"b8ce75fd-c748-4797-b328-66cf351715ee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", "1"}], "}"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->17825497,ExpressionUUID->"c99644fb-7bfe-4574-ae92-1b62377ae7e4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", "1"}], "}"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->8098646,ExpressionUUID->"3d17312e-2db0-405f-8a6c-2b42f2317b95"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", "1"}], "}"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->498480378,ExpressionUUID->"3de7bc4f-cdd3-4114-b73a-3592459f68f3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", "1"}], "}"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->850194432,ExpressionUUID->"84ef016e-f4ac-4412-b84f-02a21d568670"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", "1"}], "}"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->296634802,ExpressionUUID->"b83b0cb8-32aa-4f98-bcfe-b44e45634080"]
}, Open  ]],

Cell["\<\
On the other hand, for example the irrep {5,2} of S7 does not contain R:\
\>", "ExampleText",
 CellID->864924527,ExpressionUUID->"7c7cd411-9a29-4723-a272-d4403e7423e5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"SnBranchingRules", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"R", ",", "_"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->587792993,ExpressionUUID->"8c6718a9-8134-492b-9593-b31ed178c998"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->288061771,ExpressionUUID->"684bd0d3-bf75-48bb-b3a3-18f61f18d69a"]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"62428bf5-99b4-475d-8a01-be575aa112dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"c59c8707-9311-46e9-8c70-f141f7e30ce7"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"a008ac7c-6d43-4179-b350-9eeb1ef9adc4"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ReduceRepProduct"]],"paclet:GroupMath/ref/ReduceRepProduct"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"634bdb64-0767-4831-8be9-735c67eb8021"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["SnBranchingRules"]],"paclet:GroupMath/ref/SnBranchingRules"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"dc20f863-7c2b-4219-b9a9-3c78ef13fe75"]
}], "SeeAlso",
 CellID->302395502,ExpressionUUID->"c9f904f8-3a32-46af-a6b1-0aa6c9091a19"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"81040065-d6c5-4308-bc07-f96aa6646abf"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"5b86c072-5007-4085-93c8-831924e6b027"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"3a2e56f1-f0aa-496d-b92c-ad33cd8fc372"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"7dd45edd-2b97-46a9-af12-c5124e818ee0"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"af76c877-e948-4807-b524-c3de5b68a187"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LittlewoodRichardsonCoefficients",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 13, 36.1742686}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "LittlewoodRichardsonCoefficients[list of partitons] Calculates the \
Littlewood-Richardson coefficients for the permutation group representations \
given as a list", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "LittlewoodRichardsonCoefficients", "titlemodifier" -> "", "windowtitle" -> 
    "LittlewoodRichardsonCoefficients", "type" -> "Symbol", "uri" -> 
    "GroupMath/ref/LittlewoodRichardsonCoefficients", "WorkflowDockedCell" -> 
    ""}, "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8921, 228, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"cacfa53d-9fea-46de-853a-12abd389c986",
   CellTags->"PrimaryExamplesSection",
   CellID->183126480]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21307, 611}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[604, 21, 4321, 98, 53, "AnchorBarGrid",ExpressionUUID->"c5c2cb36-6d96-41b2-819e-7f0d5f46cb1a",
 CellID->1],
Cell[CellGroupData[{
Cell[4950, 123, 417, 9, 52, "ObjectNameGrid",ExpressionUUID->"baf80822-09b6-43ae-92a0-38d702d1a4ae"],
Cell[5370, 134, 637, 12, 131, "Usage",ExpressionUUID->"632619ca-7f6f-40b6-b3bd-b12a8067a2ae",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6044, 151, 853, 21, 37, "NotesSection",ExpressionUUID->"587a4d92-e7a5-451c-972b-89bb835bd198",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->8660249],
Cell[6900, 174, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"2a2eb094-f44d-4639-8275-e4044a088e92"],
Cell[6989, 176, 357, 7, 70, "Notes",ExpressionUUID->"303a24e5-763b-422e-81ae-2ae09abf1026",
 CellID->1067943069],
Cell[7349, 185, 713, 16, 70, "Notes",ExpressionUUID->"e29c2197-206f-48c4-a98a-c0983329c5b1",
 CellID->231691174],
Cell[8065, 203, 730, 18, 70, "Notes",ExpressionUUID->"70412be9-70c7-4ca6-9f04-86fe2a2efaf1",
 CellID->168134201],
Cell[8798, 223, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"b0a29455-333b-43b1-8d33-3b6f003b17fc"]
}, Closed]],
Cell[CellGroupData[{
Cell[8921, 228, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"cacfa53d-9fea-46de-853a-12abd389c986",
 CellTags->"PrimaryExamplesSection",
 CellID->183126480],
Cell[CellGroupData[{
Cell[9381, 243, 308, 7, 29, "ExampleSection",ExpressionUUID->"92a1fc2f-ba8d-48c4-b75a-f4bbd242e112",
 CellID->523946922],
Cell[9692, 252, 516, 9, 95, "ExampleText",ExpressionUUID->"d474c901-d683-457e-a6b3-98123c3564b8",
 CellID->329238481],
Cell[CellGroupData[{
Cell[10233, 265, 408, 11, 43, "Input",ExpressionUUID->"52da26f6-672a-4f46-82fc-63e00400a0d6",
 CellID->250692952],
Cell[10644, 278, 899, 30, 52, "Output",ExpressionUUID->"995fb9b3-e4b0-41ec-aa71-c37e9b9654ab",
 CellID->65825606]
}, Open  ]],
Cell[11558, 311, 606, 12, 76, "ExampleText",ExpressionUUID->"1ffc6258-b140-4284-b14e-b8f168bc67a1",
 CellID->339308793],
Cell[CellGroupData[{
Cell[12189, 327, 2005, 62, 107, "Input",ExpressionUUID->"f4e53ab3-dda1-4016-ada3-6ee507aa0a0b",
 CellID->115422392],
Cell[14197, 391, 358, 12, 35, "Output",ExpressionUUID->"b8ce75fd-c748-4797-b328-66cf351715ee",
 CellID->85890577],
Cell[14558, 405, 358, 12, 35, "Output",ExpressionUUID->"c99644fb-7bfe-4574-ae92-1b62377ae7e4",
 CellID->17825497],
Cell[14919, 419, 357, 12, 35, "Output",ExpressionUUID->"3d17312e-2db0-405f-8a6c-2b42f2317b95",
 CellID->8098646],
Cell[15279, 433, 359, 12, 35, "Output",ExpressionUUID->"3de7bc4f-cdd3-4114-b73a-3592459f68f3",
 CellID->498480378],
Cell[15641, 447, 359, 12, 35, "Output",ExpressionUUID->"84ef016e-f4ac-4412-b84f-02a21d568670",
 CellID->850194432],
Cell[16003, 461, 359, 12, 35, "Output",ExpressionUUID->"b83b0cb8-32aa-4f98-bcfe-b44e45634080",
 CellID->296634802]
}, Open  ]],
Cell[16377, 476, 178, 3, 70, "ExampleText",ExpressionUUID->"7c7cd411-9a29-4723-a272-d4403e7423e5",
 CellID->864924527],
Cell[CellGroupData[{
Cell[16580, 483, 403, 12, 70, "Input",ExpressionUUID->"8c6718a9-8134-492b-9593-b31ed178c998",
 CellID->587792993],
Cell[16986, 497, 143, 3, 35, "Output",ExpressionUUID->"684bd0d3-bf75-48bb-b3a3-18f61f18d69a",
 CellID->288061771]
}, Open  ]]
}, Open  ]],
Cell[17156, 504, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"62428bf5-99b4-475d-8a01-be575aa112dd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17279, 509, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"a008ac7c-6d43-4179-b350-9eeb1ef9adc4",
 CellID->1255426704],
Cell[17542, 518, 749, 18, 70, "SeeAlso",ExpressionUUID->"c9f904f8-3a32-46af-a6b1-0aa6c9091a19",
 CellID->302395502]
}, Open  ]],
Cell[CellGroupData[{
Cell[18328, 541, 262, 7, 70, "TutorialsSection",ExpressionUUID->"5b86c072-5007-4085-93c8-831924e6b027",
 CellID->250839057],
Cell[18593, 550, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"3a2e56f1-f0aa-496d-b92c-ad33cd8fc372"],
Cell[18682, 552, 241, 5, 70, "Tutorials",ExpressionUUID->"7dd45edd-2b97-46a9-af12-c5124e818ee0",
 CellID->341631938]
}, Open  ]],
Cell[18938, 560, 78, 0, 70, "FooterCell",ExpressionUUID->"af76c877-e948-4807-b524-c3de5b68a187"]
}
]
*)

(* End of internal cache information *)

