(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     44017,        999]
NotebookOptionsPosition[     36513,        837]
NotebookOutlinePosition[     38911,        896]
CellTagsIndexPosition[     38826,        891]
WindowTitle->DynkinIndex
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "61c8296f-b7d2-4142-ae67-10e14bde1edb"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"0938f167-8cb1-40ca-9293-e54f7a77b614"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "cfde8fb1-ab04-4cd6-8664-7b19e866f51f"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"1a54b5f9-270a-4eaa-a562-faa6beae1aae"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"Adjoint\"\>":>Documentation`HelpLookup[
       "paclet:GroupMath/ref/Adjoint"], "\<\"Casimir\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/ref/Casimir"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "33426519-6e64-448b-a7c4-33dddcbe9e40"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"48524880-0dab-4e5a-ae5c-a0506fbe8e21"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/DynkinIndex\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/DynkinIndex"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
DynkinIndex.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$16057], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/DynkinIndex", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "63ca94d4-211f-44d9-b293-1d5c4e66f54a"]
    }], "AnchorBar",ExpressionUUID->"ab6bef82-12c3-4c6c-959f-210ea2008e74"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"9a59a867-72a4-4737-b74a-0b2a374b08b3"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["DynkinIndex", "ObjectName",ExpressionUUID->
  "790571c8-ae63-4bcc-aa94-52f785569aea"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"a5b0c90d-b625-4d5f-a8e1-a317d2af8248"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "bfd946cf-e5ff-4eb0-8355-afb67061a276"]
}], "ObjectNameGrid",ExpressionUUID->"36a38a18-24cc-4f41-b5d8-c24af7d38956"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DynkinIndex", "[", 
       RowBox[{"group", ",", " ", "rep"}], "]"}]], "InlineFormula",
      ExpressionUUID->"849dc505-2071-4f90-821d-fe7fec70fa62"],
     " \[LineSeparator]Computes the Dynkin index of representation ",
     Cell[BoxData[
     "rep"], "InlineFormula",ExpressionUUID->
      "99544333-4ebc-4085-9d02-c42e2b2b16c1"],
     " of ",
     Cell[BoxData[
     "group"], "InlineFormula",ExpressionUUID->
      "d774099b-b6d8-4352-a18d-3092dee2a2bd"]
    }],ExpressionUUID->"24415263-a5b1-4fc6-b673-72cbe81a8a71"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"9310f3eb-34a1-45c5-a64d-085115a32b72"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"2da46371-a6c1-4d5a-b355-96966c0f38d7"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"7a46c5f3-21a1-43a1-963a-0f418e911b8a"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"d40d1255-8f06-484c-ae54-53da61266503"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1663638,ExpressionUUID->"3c623dc3-c797-4909-955d-2e2e4b79c065"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"28f420fa-d402-4a29-b345-434398d66d13"],

Cell[TextData[{
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "0ff14137-b15a-4508-b2fa-e5379f146f40"],
 " should be a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/ref/CartanMatrix"],
 "."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"2a7cd6de-efcd-4e55-a779-8d43d95935d0"],

Cell[TextData[{
 "Each representation ",
 Cell[BoxData[
 "rep"], "InlineFormula",ExpressionUUID->
  "bc4d4e9f-4e19-4c0c-b3a1-8182c23989b9"],
 " should be a list of non-negative integers (Dynkin coefficients). It is \
also possible to use the simplified input format for representations (see the \
",
 ButtonBox["GroupMath tutorial",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/tutorial/GroupMathDoc"],
 " page)."
}], "Notes",
 CellID->638839415,ExpressionUUID->"402aa7ad-20a6-44fb-8513-57d51de1311b"],

Cell[TextData[{
 "This the same as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Casimir", "[", 
    RowBox[{"group", ",", " ", "rep"}], "]"}], " ", 
   RowBox[{
    RowBox[{"DimR", "[", 
     RowBox[{"group", ",", " ", "rep"}], "]"}], "/", 
    RowBox[{"DimR", "[", 
     RowBox[{"group", ",", " ", 
      RowBox[{"Adjoint", "[", "group", "]"}]}], "]"}]}]}]], "InlineFormula",
  ExpressionUUID->"c6b69024-07d5-4eb6-98d9-a695c288b17e"],
 "."
}], "Notes",
 CellID->110993762,ExpressionUUID->"7ef7aeb1-7f1d-4599-86c9-971bc078e994"],

Cell[TextData[{
 "Assuming that ",
 Cell[BoxData[
  SuperscriptBox["T", "a"]], "InlineFormula",ExpressionUUID->
  "8f87f89e-ecdd-49db-8e10-8f924d763cd1"],
 " are the representation matrices, then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Tr", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["T", "a"], 
      SuperscriptBox["T", "b"]}], ")"}]}], "="}]], "InlineFormula",
  ExpressionUUID->"30810cce-8ead-4a6b-8bb0-64170416ee83"],
 "S(rep) ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Delta]", "ab"], " "}]], "InlineFormula",ExpressionUUID->
  "976b3a8a-d778-48bd-8006-c7b2d3c628a7"],
 " , where the number S(rep) is the Dynkin index of the representation."
}], "Notes",
 CellID->634968245,ExpressionUUID->"b18b78e3-ec6a-4b57-bafb-4b06bd73afc3"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"512bd774-625c-48fa-a8ab-86392767b89f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"39b36d4f-2612-43db-8d46-50e695d9516f"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "f09b48c7-0527-4575-b347-b06e79ebdcf4"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->486914655,ExpressionUUID->"e4c7fdb5-9b85-400e-940f-912b3118b9d4"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "05b9fcd2-4e50-4e8a-9145-880a47745ae0"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->300412653,ExpressionUUID->"b849794a-4bc2-425b-a3a4-54c28b3f3aee"],

Cell[TextData[{
 "The usual convention of having the fundamental of SU(n) with a Dynkin index \
",
 Cell[BoxData[
  FractionBox["1", "2"]], "InlineFormula",ExpressionUUID->
  "0b6c04f6-2675-4bbf-b0f5-3b6fae320b72"],
 " is respected by this method:"
}], "ExampleText",
 CellID->4632706,ExpressionUUID->"245c279e-6540-4232-9f6b-d993268f8f0e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Dynkin index of the fundamental of SU(2): \>\"", ",", 
    RowBox[{"DynkinIndex", "[", 
     RowBox[{"SU2", ",", "2"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Dynkin index of the fundamental of SU(3): \>\"", ",", 
    RowBox[{"DynkinIndex", "[", 
     RowBox[{"SU3", ",", "3"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Dynkin index of the fundamental of SU(4): \>\"", ",", 
    RowBox[{"DynkinIndex", "[", 
     RowBox[{"SU4", ",", "4"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Dynkin index of the fundamental of SU(5): \>\"", ",", 
    RowBox[{"DynkinIndex", "[", 
     RowBox[{"SU5", ",", "5"}], "]"}]}], "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->198201436,ExpressionUUID->"db582094-1651-454e-8df7-dcb7813b8ad9"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dynkin index of the fundamental of SU(2): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "2"]}],
  SequenceForm["Dynkin index of the fundamental of SU(2): ", 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->16171692,ExpressionUUID->"6af1f81e-c435-4ad6-a053-357f1c5c9fea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dynkin index of the fundamental of SU(3): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "2"]}],
  SequenceForm["Dynkin index of the fundamental of SU(3): ", 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->33545871,ExpressionUUID->"88858654-dded-4164-9c57-54ab07e838cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dynkin index of the fundamental of SU(4): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "2"]}],
  SequenceForm["Dynkin index of the fundamental of SU(4): ", 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->32003834,ExpressionUUID->"ae13be6d-2454-4a2f-ae79-4bfe72fb9910"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dynkin index of the fundamental of SU(5): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "2"]}],
  SequenceForm["Dynkin index of the fundamental of SU(5): ", 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->54632386,ExpressionUUID->"280874d9-2a8f-412c-bb74-805067ade10c"]
}, Open  ]]
}, Open  ]],

Cell["\<\
In the above code, the simplified input format for representations was used. \
The following code computes the same thing:\
\>", "ExampleText",
 CellID->96642750,ExpressionUUID->"e4aa1a94-c20b-427d-8276-b4a8c2d2e952"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Dynkin index of the fundamental of SU(2): \>\"", ",", 
    RowBox[{"DynkinIndex", "[", 
     RowBox[{"SU2", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Dynkin index of the fundamental of SU(3): \>\"", ",", 
    RowBox[{"DynkinIndex", "[", 
     RowBox[{"SU3", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Dynkin index of the fundamental of SU(4): \>\"", ",", 
    RowBox[{"DynkinIndex", "[", 
     RowBox[{"SU4", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Dynkin index of the fundamental of SU(5): \>\"", ",", 
    RowBox[{"DynkinIndex", "[", 
     RowBox[{"SU5", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "]"}], 
  ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->126609898,ExpressionUUID->"bb0e84bd-41b0-447d-97f6-81dee114d408"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dynkin index of the fundamental of SU(2): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "2"]}],
  SequenceForm["Dynkin index of the fundamental of SU(2): ", 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[22]:=",
 CellID->374147891,ExpressionUUID->"d7ced718-996f-4ac3-8acd-48342d142750"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dynkin index of the fundamental of SU(3): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "2"]}],
  SequenceForm["Dynkin index of the fundamental of SU(3): ", 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[22]:=",
 CellID->141311577,ExpressionUUID->"bc7e2e95-8aee-4ecc-b8c9-5d9031b8cc64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dynkin index of the fundamental of SU(4): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "2"]}],
  SequenceForm["Dynkin index of the fundamental of SU(4): ", 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[22]:=",
 CellID->466670959,ExpressionUUID->"532f3dd8-326a-47b6-b8ea-6e31a41b13d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dynkin index of the fundamental of SU(5): \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "2"]}],
  SequenceForm["Dynkin index of the fundamental of SU(5): ", 
   Rational[1, 2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[22]:=",
 CellID->230418556,ExpressionUUID->"003ae4ed-37f5-47c0-a97e-8f8248808538"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "dafe3af0-c94e-4736-85b7-c7bb7bd2e4bc"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51641276,ExpressionUUID->"9354133a-4711-4bd0-9d38-cab0b78eca3d"],

Cell[TextData[{
 "We can check that the results of the ",
 Cell[BoxData[
 "DynkinIndex"], "InlineFormula",ExpressionUUID->
  "83a804c8-9274-4644-94d7-7aee4ef195d9"],
 " function match the ones obtained by calculating the result directly for \
the formula ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Tr", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["T", "a"], 
      SuperscriptBox["T", "b"]}], ")"}]}], "="}]], "InlineFormula",
  ExpressionUUID->"007baec7-f7f1-4998-93a6-b151d78df8fe"],
 "S(rep) ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Delta]", "ab"], " "}]], "InlineFormula",ExpressionUUID->
  "a246a205-7b42-4bb7-ac7e-87c9fd21e529"],
 ". Consider for example the 27-dimensional representation of F4:"
}], "Notes",
 CellID->26871987,ExpressionUUID->"eb744c3b-68b7-423c-82b6-7969262e6f3f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynkinIndex", "[", 
  RowBox[{"F4", ",", "26"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->638777469,ExpressionUUID->"97ae8ba8-7d00-4151-bad4-2882af705499"],

Cell[BoxData["3"], "Output",
 CellLabel->"Out[1]=",
 CellID->435726647,ExpressionUUID->"4b8d65ba-f51c-4082-bac0-67ba964378a4"]
}, Open  ]],

Cell["\<\
The group algebra is 52-dimensional, so 'matrices' below is a list of 52 \
matrices, with dimensions 26 x 26:\
\>", "Notes",
 CellID->206561630,ExpressionUUID->"c73959e6-2b7e-48f5-ab6c-5122b0ecd748"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"matrices", "=", 
   RowBox[{"RepMatrices", "[", 
    RowBox[{"F4", ",", "26"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"matrices", "//", "Dimensions"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->109344574,ExpressionUUID->"9b263be6-5355-4cab-b8ad-3a8e8bf2403a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"52", ",", "26", ",", "26"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->100571087,ExpressionUUID->"98d4c8f8-eaec-40a9-8eb8-0271c697df60"]
}, Open  ]],

Cell[TextData[{
 "We can then check that  ",
 Cell[BoxData[
  RowBox[{"Tr", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["T", "a"], 
     SuperscriptBox["T", "b"]}], ")"}]}]], "InlineFormula",ExpressionUUID->
  "61811b3e-53f0-4764-99e6-3a5fe96e3454"],
 " is a matrix proportional to ",
 Cell[BoxData[
  SubscriptBox["\[Delta]", "ab"]], "InlineFormula",ExpressionUUID->
  "91c449cd-81b9-4a33-b5e6-7cb87b947b61"],
 ", and indeed the proportionality factor is DynkinIndex[F4,26]=3:"
}], "Notes",
 CellID->284108355,ExpressionUUID->"f76fcb5d-eae2-4458-965d-460d4af4e8ce"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Tr", "[", 
     RowBox[{"matrixA", ".", "matrixB"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"matrixA", ",", "matrices"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"matrixB", ",", "matrices"}], "}"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->482268689,ExpressionUUID->"d2b66c46-bd99-4f18-8d73-2db4728fc97e"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "3", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "3", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "3", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "3", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "3", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "3", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "3", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "3", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "3", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "3", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "3", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "3", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "3", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "3", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "3", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "3", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "3", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "3", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "3", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "3", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "3", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "3", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "3", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "3", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "3", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "3", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "3", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "3", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "3", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "3", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "3", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "3", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "3", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "3", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "3", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "3", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "3"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[3]//MatrixForm=",
 CellID->753864196,ExpressionUUID->"f0ba3ce3-8779-4771-96e5-e29a6e8e2d99"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"8f941dc1-fb2f-45ef-ba5a-5938cd9a13dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"6d7bf558-d332-43d3-85ac-d3f22061c94f"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"9b97cb9f-a9bf-4d4f-9339-b14149d4ba13"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["Adjoint"]],"paclet:GroupMath/ref/Adjoint"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"acc739e3-2843-45a4-af3d-786c54b61610"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["Casimir"]],"paclet:GroupMath/ref/Casimir"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"338c431f-47c4-4918-8808-508380b1929a"]
}], "SeeAlso",
 CellID->1038487239,ExpressionUUID->"6a11678c-baf8-4be4-843d-2fafe8c085b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"46b7ea96-f33c-4aa1-b262-ab87677b1484"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"54851f80-a71d-499f-9104-ea04b04e8035"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"5183027e-8c39-4724-8d77-e7ac67076b39"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"35ef4674-97a8-4e8d-8507-13afb1ab4f3f"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"d89e7bfd-4542-4bc0-bfd6-311f453ce915"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DynkinIndex",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 13, 14.9036866}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "DynkinIndex[group, rep] Computes the Dynkin index of representation rep \
of group", "synonyms" -> {}, "tabletags" -> {}, "title" -> "DynkinIndex", 
    "titlemodifier" -> "", "windowtitle" -> "DynkinIndex", "type" -> "Symbol",
     "uri" -> "GroupMath/ref/DynkinIndex", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9175, 250, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"e4c7fdb5-9b85-400e-940f-912b3118b9d4",
   CellTags->"PrimaryExamplesSection",
   CellID->486914655]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38628, 884}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[583, 21, 4157, 94, 53, "AnchorBarGrid",ExpressionUUID->"9a59a867-72a4-4737-b74a-0b2a374b08b3",
 CellID->1],
Cell[CellGroupData[{
Cell[4765, 119, 396, 9, 52, "ObjectNameGrid",ExpressionUUID->"36a38a18-24cc-4f41-b5d8-c24af7d38956"],
Cell[5164, 130, 779, 18, 110, "Usage",ExpressionUUID->"9310f3eb-34a1-45c5-a64d-085115a32b72",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5980, 153, 853, 21, 37, "NotesSection",ExpressionUUID->"3c623dc3-c797-4909-955d-2e2e4b79c065",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1663638],
Cell[6836, 176, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"28f420fa-d402-4a29-b345-434398d66d13"],
Cell[6925, 178, 330, 10, 70, "Notes",ExpressionUUID->"2a7cd6de-efcd-4e55-a779-8d43d95935d0",
 CellID->1067943069],
Cell[7258, 190, 509, 13, 70, "Notes",ExpressionUUID->"402aa7ad-20a6-44fb-8513-57d51de1311b",
 CellID->638839415],
Cell[7770, 205, 524, 15, 70, "Notes",ExpressionUUID->"7ef7aeb1-7f1d-4599-86c9-971bc078e994",
 CellID->110993762],
Cell[8297, 222, 752, 21, 70, "Notes",ExpressionUUID->"b18b78e3-ec6a-4b57-bafb-4b06bd73afc3",
 CellID->634968245],
Cell[9052, 245, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"512bd774-625c-48fa-a8ab-86392767b89f"]
}, Closed]],
Cell[CellGroupData[{
Cell[9175, 250, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"e4c7fdb5-9b85-400e-940f-912b3118b9d4",
 CellTags->"PrimaryExamplesSection",
 CellID->486914655],
Cell[CellGroupData[{
Cell[9635, 265, 308, 7, 29, "ExampleSection",ExpressionUUID->"b849794a-4bc2-425b-a3a4-54c28b3f3aee",
 CellID->300412653],
Cell[9946, 274, 340, 8, 63, "ExampleText",ExpressionUUID->"245c279e-6540-4232-9f6b-d993268f8f0e",
 CellID->4632706],
Cell[CellGroupData[{
Cell[10311, 286, 971, 22, 75, "Input",ExpressionUUID->"db582094-1651-454e-8df7-dcb7813b8ad9",
 CellID->198201436],
Cell[CellGroupData[{
Cell[11307, 312, 382, 9, 40, "Print",ExpressionUUID->"6af1f81e-c435-4ad6-a053-357f1c5c9fea",
 CellID->16171692],
Cell[11692, 323, 382, 9, 40, "Print",ExpressionUUID->"88858654-dded-4164-9c57-54ab07e838cd",
 CellID->33545871],
Cell[12077, 334, 382, 9, 40, "Print",ExpressionUUID->"ae13be6d-2454-4a2f-ae79-4bfe72fb9910",
 CellID->32003834],
Cell[12462, 345, 382, 9, 40, "Print",ExpressionUUID->"280874d9-2a8f-412c-bb74-805067ade10c",
 CellID->54632386]
}, Open  ]]
}, Open  ]],
Cell[12871, 358, 227, 4, 57, "ExampleText",ExpressionUUID->"e4aa1a94-c20b-427d-8276-b4a8c2d2e952",
 CellID->96642750],
Cell[CellGroupData[{
Cell[13123, 366, 1202, 32, 75, "Input",ExpressionUUID->"bb0e84bd-41b0-447d-97f6-81dee114d408",
 CellID->126609898],
Cell[CellGroupData[{
Cell[14350, 402, 383, 9, 70, "Print",ExpressionUUID->"d7ced718-996f-4ac3-8acd-48342d142750",
 CellID->374147891],
Cell[14736, 413, 383, 9, 70, "Print",ExpressionUUID->"bc7e2e95-8aee-4ecc-b8c9-5d9031b8cc64",
 CellID->141311577],
Cell[15122, 424, 383, 9, 70, "Print",ExpressionUUID->"532f3dd8-326a-47b6-b8ea-6e31a41b13d4",
 CellID->466670959],
Cell[15508, 435, 383, 9, 70, "Print",ExpressionUUID->"003ae4ed-37f5-47c0-a97e-8f8248808538",
 CellID->230418556]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15940, 450, 241, 5, 70, "ExampleDelimiter",ExpressionUUID->"9354133a-4711-4bd0-9d38-cab0b78eca3d",
 CellID->51641276],
Cell[16184, 457, 804, 22, 70, "Notes",ExpressionUUID->"eb744c3b-68b7-423c-82b6-7969262e6f3f",
 CellID->26871987],
Cell[CellGroupData[{
Cell[17013, 483, 187, 4, 70, "Input",ExpressionUUID->"97ae8ba8-7d00-4151-bad4-2882af705499",
 CellID->638777469],
Cell[17203, 489, 126, 2, 35, "Output",ExpressionUUID->"4b8d65ba-f51c-4082-bac0-67ba964378a4",
 CellID->435726647]
}, Open  ]],
Cell[17344, 494, 209, 4, 70, "Notes",ExpressionUUID->"c73959e6-2b7e-48f5-ab6c-5122b0ecd748",
 CellID->206561630],
Cell[CellGroupData[{
Cell[17578, 502, 307, 7, 70, "Input",ExpressionUUID->"9b263be6-5355-4cab-b8ad-3a8e8bf2403a",
 CellID->109344574],
Cell[17888, 511, 184, 4, 35, "Output",ExpressionUUID->"98d4c8f8-eaec-40a9-8eb8-0271c697df60",
 CellID->100571087]
}, Open  ]],
Cell[18087, 518, 573, 15, 70, "Notes",ExpressionUUID->"f76fcb5d-eae2-4458-965d-460d4af4e8ce",
 CellID->284108355],
Cell[CellGroupData[{
Cell[18685, 537, 423, 12, 70, "Input",ExpressionUUID->"d2b66c46-bd99-4f18-8d73-2db4728fc97e",
 CellID->482268689],
Cell[19111, 551, 15534, 223, 798, "Output",ExpressionUUID->"f0ba3ce3-8779-4771-96e5-e29a6e8e2d99",
 CellID->753864196]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[34684, 779, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"8f941dc1-fb2f-45ef-ba5a-5938cd9a13dd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34807, 784, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"9b97cb9f-a9bf-4d4f-9339-b14149d4ba13",
 CellID->1255426704],
Cell[35070, 793, 714, 18, 70, "SeeAlso",ExpressionUUID->"6a11678c-baf8-4be4-843d-2fafe8c085b1",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[35821, 816, 262, 7, 70, "TutorialsSection",ExpressionUUID->"54851f80-a71d-499f-9104-ea04b04e8035",
 CellID->250839057],
Cell[36086, 825, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"5183027e-8c39-4724-8d77-e7ac67076b39"],
Cell[36175, 827, 241, 5, 70, "Tutorials",ExpressionUUID->"35ef4674-97a8-4e8d-8507-13afb1ab4f3f",
 CellID->341631938]
}, Open  ]],
Cell[36431, 835, 78, 0, 70, "FooterCell",ExpressionUUID->"d89e7bfd-4542-4bc0-bfd6-311f453ce915"]
}
]
*)

(* End of internal cache information *)

