(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     30741,        888]
NotebookOptionsPosition[     24840,        761]
NotebookOutlinePosition[     27292,        821]
CellTagsIndexPosition[     27207,        816]
WindowTitle->DominantWeights
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "7c0465c6-2a99-4f82-9140-15bbeab269ac"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"af4ed456-6c10-40cf-82b2-cf4adc65a736"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ed565f85-2517-4569-bfab-7cc46ad2686e"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"9957a7e4-6702-4daa-94a2-1e6053463eef"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"Weights\"\>":>Documentation`HelpLookup[
       "paclet:GroupMath/ref/Weights"], "\<\"DominantConjugate\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/DominantConjugate"], "\<\"ReflectWeight\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/ReflectWeight"], "\<\"WeylOrbit\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/ref/WeylOrbit"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "924f4c03-a74f-43cd-84da-cf88d3d6c5b7"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"be9130ca-387a-4839-8be7-3cf82bec4466"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/DominantWeights\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/DominantWeights"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
DominantWeights.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$15530], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/DominantWeights", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "202828d8-a23c-4ee0-8c51-35eb9e5785d9"]
    }], "AnchorBar",ExpressionUUID->"985af5c7-ab96-4d08-8aef-59d5d11f1e2f"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"7d7cc6ea-5c41-431f-8fee-9632cc2ae9e8"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["DominantWeights", "ObjectName",ExpressionUUID->
  "4360a77e-cb24-4568-972a-37100654c9e6"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"ad6e4aec-fabc-4d23-b353-442fe442b033"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "977aa5d9-2602-472c-be63-4dbec04f8d10"]
}], "ObjectNameGrid",ExpressionUUID->"5889ef0f-97a3-4b50-8c4b-d18660c7ca57"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DominantWeights", "[", 
       RowBox[{"group", ",", " ", "representation"}], "]"}]], "InlineFormula",
      ExpressionUUID->"495257bc-d769-4a2d-aaa2-f444c1927923"],
     " \[LineSeparator]Calculates the dominant weights of the representation \
of a simple Lie group"
    }],ExpressionUUID->"2124763c-b461-4198-8a64-0282c24d1836"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"9fd20cd0-c1a3-4ab6-ac66-25c20706b41d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"037b700b-dc23-43a4-a448-19e625469444"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"6cdb9ae4-1c63-40d2-a1a3-47714828820d"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"4c688ff4-7169-4653-91dd-f30abe268a14"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->8633518,ExpressionUUID->"95ed9224-4892-4dbb-b677-92aaf128e965"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"18aeba47-4f3e-42dc-977d-ae6a9eb0cc18"],

Cell[TextData[{
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "20b04868-98f7-4f11-bfc8-8313e4e5fd98"],
 " should a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/ref/CartanMatrix"],
 ButtonBox[".",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"]
}], "Notes",
 CellID->389226166,ExpressionUUID->"d1bc7317-7067-454e-ab2f-07215bb44774"],

Cell[TextData[{
 "The input ",
 Cell[BoxData[
 "representation"], "InlineFormula",ExpressionUUID->
  "8cd49379-a20a-48e4-b081-0233a6f4b985"],
 " should be a list of non-negative integers (Dynkin coefficients).  It is \
also possible to use the simplified input format for representations (see the \
",
 ButtonBox["GroupMath tutorial",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/tutorial/GroupMathDoc"],
 " page)."
}], "Notes",
 CellID->702908051,ExpressionUUID->"9e473e98-9021-4742-b188-2be92d514e80"],

Cell["\<\
The dominant weights are those whose Dynkin coefficients are all non-negative.\
\>", "Notes",
 CellID->1067943069,ExpressionUUID->"efac4fc8-4d34-4998-9e25-a94d7d207010"],

Cell[TextData[{
 "Ignoring the ordering of the list elements in the result, the output of The \
result of ",
 Cell[BoxData[
 "DominantWeights"], "InlineFormula",ExpressionUUID->
  "ca45eb7d-af30-4e8b-b80e-fd841297cb89"],
 " is the same as ",
 Cell[BoxData[
  RowBox[{"Cases", "[", 
   RowBox[{
    RowBox[{"Weights", "[", 
     RowBox[{"group", ",", "representation"}], "]"}], ",", 
    RowBox[{"x_", "/;", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
      RowBox[{"Abs", "[", 
       RowBox[{"x", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}]}], "]"}]], "InlineFormula",
  ExpressionUUID->"9645497a-64f7-4c85-87aa-a4761aea5518"],
 "."
}], "Notes",
 CellID->185850537,ExpressionUUID->"a5d0a2fc-3db6-456b-8995-361e13371bda"],

Cell["\<\
The output consists of a list with the dominant weights and their \
multiplicity.\
\>", "Notes",
 CellID->110302253,ExpressionUUID->"d69149ab-5d8c-4fd1-9b2a-0dd8abe89ad1"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"0b4ef700-6eeb-42e7-aea2-2a8b2923df21"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"af27e5b0-f506-4ebb-b5e7-15e7c40d24a9"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "9191da36-c6cc-4a3d-a603-d484dd34a9e7"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->19979005,ExpressionUUID->"64e273bf-5242-4ea8-873d-f3bd13834a7d"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "ac85b378-8b07-4236-abb8-d17a7f3a4ad2"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->95333941,ExpressionUUID->"70002472-9a8a-49d6-bcc8-191524db7769"],

Cell["\<\
Calculate all dominant weights (including multiplicity) of the representation \
{0,1,2,0,1} of SO(10):\
\>", "ExampleText",
 CellID->615511182,ExpressionUUID->"4baf41ca-0d93-4b7e-b5f7-db769c1c60d8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dominantWeights1", "=", 
  RowBox[{"DominantWeights", "[", 
   RowBox[{"SO10", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "0", ",", "1"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->551940360,ExpressionUUID->"fc520083-5885-442f-a4f6-fcba749548bc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2", ",", "0", ",", "1"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0", ",", "1", ",", "2"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
     "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "2"}], "}"}], ",", 
     "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "2", ",", "1", ",", "0"}], "}"}], ",", 
     "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "2", ",", "1"}], "}"}], ",", 
     "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "3"}], "}"}], ",", 
     "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
     "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
     "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0", ",", "1", ",", "2"}], "}"}], ",", 
     "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
     "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     "57"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "3"}], "}"}], ",", 
     "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
     "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "3"}], "}"}], ",", 
     "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2", ",", "0", ",", "1"}], "}"}], ",", 
     "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
     "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "1", ",", "2"}], "}"}], ",", 
     "30"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
     "47"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     "73"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "2", ",", "1"}], "}"}], ",", 
     "70"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "3"}], "}"}], ",", 
     "48"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
     "116"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     "174"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     "268"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
     "106"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "2"}], "}"}], ",", 
     "181"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
     "271"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     "412"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     "616"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     "910"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->225379626,ExpressionUUID->"ee91138b-fcae-41c4-8bbc-6a1bce77677f"]
}, Open  ]],

Cell["\<\
The results should coincide with the following code which calculates all \
weights, and selects only those with non-negative Dynkin coefficients.\
\>", "ExampleText",
 CellID->572757462,ExpressionUUID->"44bc4640-09f5-4eb4-8239-ca9ea921455e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dominantWeights2", "=", 
  RowBox[{"Cases", "[", 
   RowBox[{
    RowBox[{"Weights", "[", 
     RowBox[{"SO10", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "2", ",", "0", ",", "1"}], "}"}]}], "]"}], 
    ",", 
    RowBox[{"x_", "/;", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
      RowBox[{"Abs", "[", 
       RowBox[{"x", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9155974,ExpressionUUID->"6f959f1f-0123-4ddb-af3b-d064caf836e7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     "910"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     "616"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     "412"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
     "271"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "2"}], "}"}], ",", 
     "181"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
     "106"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     "268"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     "174"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
     "116"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "3"}], "}"}], ",", 
     "48"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "2", ",", "1"}], "}"}], ",", 
     "70"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     "73"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
     "47"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "1", ",", "2"}], "}"}], ",", 
     "30"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
     "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2", ",", "0", ",", "1"}], "}"}], ",", 
     "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "3"}], "}"}], ",", 
     "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
     "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "3"}], "}"}], ",", 
     "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     "57"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
     "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0", ",", "1", ",", "2"}], "}"}], ",", 
     "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
     "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
     "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "3"}], "}"}], ",", 
     "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "2", ",", "1"}], "}"}], ",", 
     "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "2", ",", "1", ",", "0"}], "}"}], ",", 
     "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "2"}], "}"}], ",", 
     "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
     "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0", ",", "1", ",", "2"}], "}"}], ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2", ",", "0", ",", "1"}], "}"}], ",", 
     "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->247962231,ExpressionUUID->"abdc7a8e-e3c7-4b8b-806b-c5530093a002"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sort", "[", "dominantWeights1", "]"}], "\[Equal]", 
  RowBox[{"Sort", "[", "dominantWeights2", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->518829619,ExpressionUUID->"71ee0282-64c3-4d8c-889c-887f9ad12e01"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[3]=",
 CellID->18855166,ExpressionUUID->"430c977e-bed4-4f73-9254-8332c6eb51bf"]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"de5fab39-a204-44f0-91bd-9bd4ef41ee00"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"fd39b01d-5f0c-4de7-9be9-b784f610d2a2"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"aa2f6335-228d-450f-b637-8d2a64fc77c1"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["Weights"]],"paclet:GroupMath/ref/Weights"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"c7461ec5-aca3-4b5f-938a-a30b3372d3f3"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["DominantConjugate"]],"paclet:GroupMath/ref/DominantConjugate"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"a1e8cb73-94eb-40b3-b8ce-f93e29258eed"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ReflectWeight"]],"paclet:GroupMath/ref/ReflectWeight"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"e5613d85-feb1-4b52-8b28-0bf1d4eb6ec3"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["WeylOrbit"]],"paclet:GroupMath/ref/WeylOrbit"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"6dc439ba-3360-40ce-afb6-8fa08d70c8c6"]
}], "SeeAlso",
 CellID->1038487239,ExpressionUUID->"42ea172e-d6d5-433c-82a9-d1f6c0eb6284"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"ef3a4571-f8a4-4ee1-b93d-991a20c539d0"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"6512f60a-a04b-4f65-b477-25815ad8cab3"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"38a5c0e9-b639-4442-afdc-bf84ee15da03"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"f08943ed-f726-4b93-a457-cbe485302630"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"bb50663f-f4d7-449c-84b6-50ab44807b41"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DominantWeights",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 13, 12.8686657}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "DominantWeights[group, representation] Calculates the dominant weights \
of the representation of a simple Lie group", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "DominantWeights", "titlemodifier" -> "", 
    "windowtitle" -> "DominantWeights", "type" -> "Symbol", "uri" -> 
    "GroupMath/ref/DominantWeights", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9176, 245, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"64e273bf-5242-4ea8-873d-f3bd13834a7d",
   CellTags->"PrimaryExamplesSection",
   CellID->19979005]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27010, 809}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[587, 21, 4395, 98, 53, "AnchorBarGrid",ExpressionUUID->"7d7cc6ea-5c41-431f-8fee-9632cc2ae9e8",
 CellID->1],
Cell[CellGroupData[{
Cell[5007, 123, 400, 9, 52, "ObjectNameGrid",ExpressionUUID->"5889ef0f-97a3-4b50-8c4b-d18660c7ca57"],
Cell[5410, 134, 588, 12, 110, "Usage",ExpressionUUID->"9fd20cd0-c1a3-4ab6-ac66-25c20706b41d",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6035, 151, 853, 21, 37, "NotesSection",ExpressionUUID->"95ed9224-4892-4dbb-b677-92aaf128e965",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->8633518],
Cell[6891, 174, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"18aeba47-4f3e-42dc-977d-ae6a9eb0cc18"],
Cell[6980, 176, 406, 12, 70, "Notes",ExpressionUUID->"d1bc7317-7067-454e-ab2f-07215bb44774",
 CellID->389226166],
Cell[7389, 190, 511, 13, 70, "Notes",ExpressionUUID->"9e473e98-9021-4742-b188-2be92d514e80",
 CellID->702908051],
Cell[7903, 205, 179, 3, 70, "Notes",ExpressionUUID->"efac4fc8-4d34-4998-9e25-a94d7d207010",
 CellID->1067943069],
Cell[8085, 210, 781, 22, 70, "Notes",ExpressionUUID->"a5d0a2fc-3db6-456b-8995-361e13371bda",
 CellID->185850537],
Cell[8869, 234, 181, 4, 70, "Notes",ExpressionUUID->"d69149ab-5d8c-4fd1-9b2a-0dd8abe89ad1",
 CellID->110302253],
Cell[9053, 240, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"0b4ef700-6eeb-42e7-aea2-2a8b2923df21"]
}, Closed]],
Cell[CellGroupData[{
Cell[9176, 245, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"64e273bf-5242-4ea8-873d-f3bd13834a7d",
 CellTags->"PrimaryExamplesSection",
 CellID->19979005],
Cell[CellGroupData[{
Cell[9635, 260, 307, 7, 29, "ExampleSection",ExpressionUUID->"70002472-9a8a-49d6-bcc8-191524db7769",
 CellID->95333941],
Cell[9945, 269, 208, 4, 38, "ExampleText",ExpressionUUID->"4baf41ca-0d93-4b7e-b5f7-db769c1c60d8",
 CellID->615511182],
Cell[CellGroupData[{
Cell[10178, 277, 316, 8, 26, "Input",ExpressionUUID->"fc520083-5885-442f-a4f6-fcba749548bc",
 CellID->551940360],
Cell[10497, 287, 5214, 174, 180, "Output",ExpressionUUID->"ee91138b-fcae-41c4-8bbc-6a1bce77677f",
 CellID->225379626]
}, Open  ]],
Cell[15726, 464, 251, 4, 57, "ExampleText",ExpressionUUID->"44bc4640-09f5-4eb4-8239-ca9ea921455e",
 CellID->572757462],
Cell[CellGroupData[{
Cell[16002, 472, 587, 17, 26, "Input",ExpressionUUID->"6f959f1f-0123-4ddb-af3b-d064caf836e7",
 CellID->9155974],
Cell[16592, 491, 5214, 174, 180, "Output",ExpressionUUID->"abdc7a8e-e3c7-4b8b-806b-c5530093a002",
 CellID->247962231]
}, Open  ]],
Cell[CellGroupData[{
Cell[21843, 670, 246, 5, 70, "Input",ExpressionUUID->"71ee0282-64c3-4d8c-889c-887f9ad12e01",
 CellID->518829619],
Cell[22092, 677, 128, 2, 35, "Output",ExpressionUUID->"430c977e-bed4-4f73-9254-8332c6eb51bf",
 CellID->18855166]
}, Open  ]]
}, Open  ]],
Cell[22247, 683, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"de5fab39-a204-44f0-91bd-9bd4ef41ee00"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22370, 688, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"aa2f6335-228d-450f-b637-8d2a64fc77c1",
 CellID->1255426704],
Cell[22633, 697, 1478, 38, 70, "SeeAlso",ExpressionUUID->"42ea172e-d6d5-433c-82a9-d1f6c0eb6284",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[24148, 740, 262, 7, 70, "TutorialsSection",ExpressionUUID->"6512f60a-a04b-4f65-b477-25815ad8cab3",
 CellID->250839057],
Cell[24413, 749, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"38a5c0e9-b639-4442-afdc-bf84ee15da03"],
Cell[24502, 751, 241, 5, 70, "Tutorials",ExpressionUUID->"f08943ed-f726-4b93-a457-cbe485302630",
 CellID->341631938]
}, Open  ]],
Cell[24758, 759, 78, 0, 70, "FooterCell",ExpressionUUID->"bb50663f-f4d7-449c-84b6-50ab44807b41"]
}
]
*)

(* End of internal cache information *)

