(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     25038,        677]
NotebookOptionsPosition[     18053,        528]
NotebookOutlinePosition[     20603,        590]
CellTagsIndexPosition[     20518,        585]
WindowTitle->DominantConjugate
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["GROUP MATH SYMBOL", "PacletNameCell",ExpressionUUID->
     "0b77379e-47d7-40e5-ae92-c8ba9da0d3d3"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Tutorials",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"03430bc0-f80d-46b5-8908-e873f13b7527"],
         TextCell[
          Row[{"Tutorials", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath Tutorial\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/tutorial/GroupMathDoc"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"Tutorials"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "e1c4ee7b-442e-40c1-86f1-c0157ed4a265"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"22454bc2-8850-471c-a390-6dc8a5bcb27e"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"CartanMatrix\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/CartanMatrix"], "\<\"DominantWeights\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/DominantWeights"], "\<\"ReflectWeights\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/ReflectWeights"], "\<\"WeylOrbit\"\>":>
       Documentation`HelpLookup[
       "paclet:GroupMath/ref/WeylOrbit"], "\<\"Weights\"\>":>
       Documentation`HelpLookup["paclet:GroupMath/ref/Weights"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "138e2b77-a77b-4b11-941c-cc1050233a53"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"2587795f-ab10-4be9-b1a0-a67eba50dab2"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"GroupMath/ref/DominantConjugate\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["GroupMath/ref/DominantConjugate"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/GroupMath/ref/\
DominantConjugate.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$14995], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "GroupMath/ref/DominantConjugate", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "86ea9352-8476-461b-9124-b2d2c6f7bdec"]
    }], "AnchorBar",ExpressionUUID->"482c11d9-8053-410c-8424-dd5ae185abf3"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"903501ad-f644-4881-9d5c-d17250c95d88"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["DominantConjugate", "ObjectName",ExpressionUUID->
  "9169831f-d9f5-49d7-b516-2a50db5e5ff5"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"75848c42-a321-46c2-a745-5ab04c85a8bb"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "853084ab-eedb-4200-8f5e-1bcaa24bc4bc"]
}], "ObjectNameGrid",ExpressionUUID->"a571bd6e-43fb-4907-abc9-a80ff39672e8"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DominantConjugate", "[", 
       RowBox[{"group", ",", " ", "weight"}], "]"}]], "InlineFormula",
      ExpressionUUID->"a907763e-4885-4101-9e82-edb9e691f99d"],
     " \[LineSeparator]Calculates the dominant weight associated with a ",
     Cell[BoxData[
     "weight"], "InlineFormula",ExpressionUUID->
      "7dfe7294-012e-4482-b725-097f76b33f06"],
     " of a simple Lie group representation by Weyl reflections, as well as \
the minimum number of such reflections"
    }],ExpressionUUID->"9a0e3fde-eb7e-4995-aa82-bc4906d398eb"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"57361aa6-e68e-4124-8da1-85958abdedf7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"acb2490d-5887-474b-8ebf-fa875fe3be63"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"04f72bac-6103-49dd-af37-3edec2f8e8bf"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"1cd0b510-fa8d-4b51-bbd1-3c0c15152a71"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->147782174,ExpressionUUID->"a0adee54-2af5-4157-8182-8bac32e37109"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"d23dadd5-aada-48ef-8357-930669058599"],

Cell[TextData[{
 Cell[BoxData[
 "group"], "InlineFormula",ExpressionUUID->
  "9ec5c312-baf1-446f-b641-cfea9b653017"],
 " should a ",
 ButtonBox["Cartan matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:GroupMath/ref/CartanMatrix"],
 ButtonBox[".",
  BaseStyle->"Link",
  ButtonData->"paclet:Susyno/ref/CartanMatrix"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"8aafacdd-c0fb-4599-bef0-a73dfbe171bb"],

Cell[TextData[{
 "The dominant weights are those whose Dynkin coefficients are all \
non-negative (see ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["DominantWeights"]],"paclet:GroupMath/ref/DominantWeights"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "7f0f51f3-75ff-43b0-9eaa-fc2c8760a99a"],
 ")."
}], "Notes",
 CellID->344864045,ExpressionUUID->"865aaf92-1e2f-456e-a750-94477b8e1d9f"],

Cell[TextData[{
 "Through a sequence of Weyl reflections (see ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ReflectWeight"]],"paclet:GroupMath/ref/ReflectWeight"},
   "RefLink",
   BaseStyle->{"InlineFormula"}]], "InlineFormula",ExpressionUUID->
  "0b033a00-ac90-4911-8ceb-8b42290530ea"],
 "), it is possible to transform any weight into a dominant one. This \
function returns ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"dominant", " ", "weight"}], ",", " ", "level"}], "}"}]], 
  "InlineFormula",ExpressionUUID->"0055998c-e8ae-4621-87d8-c65a22f20fa3"],
 ", where ",
 Cell[BoxData[
 "level"], "InlineFormula",ExpressionUUID->
  "3cbd9feb-6cea-41c5-8983-0b54cc4e447d"],
 " is the minimum number of reflections required."
}], "Notes",
 CellID->5853894,ExpressionUUID->"97b9add6-93f4-499c-9a33-7c51b3322b7e"],

Cell[TextData[{
 "This function follows the algorithm in \"",
 StyleBox["D. Snow, Weyl group orbits, ACM Trans. Math. Software 16 (1990), \
94-108.", "TI"],
 "\""
}], "Notes",
 CellID->57185730,ExpressionUUID->"4470c551-c262-4e72-b5ac-9973131665b6"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"cf96c975-fd43-43d4-943c-64654323b66b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"5b06608c-7789-47e5-9f80-076005e71b15"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "60416133-c8d0-4c68-a3ef-558da2c62c09"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->152537207,ExpressionUUID->"2e0ddbce-bf4d-42a9-b157-6da431b849e9"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "15a11359-3638-4b4c-baa9-c4878cb27296"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->188601814,ExpressionUUID->"98b2c82d-24fc-480c-b76a-ea03376e04d2"],

Cell["\<\
Consider the non-dominant weight {3,-1}, which is conjugate to the dominant \
weight {1,2}:\
\>", "ExampleText",
 CellID->344054462,ExpressionUUID->"e921d5da-57af-4b64-be82-934c595cc0f6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DominantConjugate", "[", 
  RowBox[{"SU3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51795859,ExpressionUUID->"239de1cb-40d1-41f8-b742-f1035828a826"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->24593025,ExpressionUUID->"3b50ea6b-a8ff-4281-822a-04ba389bba12"]
}, Open  ]],

Cell["\<\
It takes 2 Weyl reflections to get from w={-3,1} to w'={1,2}. Given that the \
rank of SU(3) is 2, we can have two reflections, R1 and R2, so there are 4 \
possibilities: R1(R1(w)), R1(R2(w)), R2(R1(w)) and R2(R2(w)).\
\>", "ExampleText",
 CellID->17175475,ExpressionUUID->"cf8b8fe7-d9f6-47c2-b7a7-83b22bb691f8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"possibility", " ", "1"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "1"}], "}"}], ",", "1"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", "%", ",", "1"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->371016001,ExpressionUUID->"7588fb93-8cc0-4d99-9f5b-6c9f82ae31b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"-", "2"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->25362818,ExpressionUUID->"4ab08649-18fd-4062-a189-40b68fbb8f3a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3"}], ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->123667056,ExpressionUUID->"51fc4c07-90f1-4c4e-a158-2f94a9962b20"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"possibility", " ", "2"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "1"}], "}"}], ",", "1"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", "%", ",", "2"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->489344400,ExpressionUUID->"8d49a972-a460-4f1d-82e4-c9ea7cc19fe3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"-", "2"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->221592782,ExpressionUUID->"3b3e271a-ec9b-45e9-820e-3a8985b56ede"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->215537425,ExpressionUUID->"9f9761e0-0071-4cfa-8e20-526488b02f0c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"possibility", " ", "3"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "1"}], "}"}], ",", "2"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", "%", ",", "1"}], "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->37169474,ExpressionUUID->"864db86a-d6f9-4cca-bd83-0b97c91f206c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->577413977,ExpressionUUID->"752ee104-7527-4486-95b4-9af9ccccc825"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->40667243,ExpressionUUID->"0cdb2dff-c278-4864-841b-f61c8e5e1ab7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"possibility", " ", "4"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "1"}], "}"}], ",", "2"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ReflectWeight", "[", 
    RowBox[{"SU3", ",", "%", ",", "2"}], "]"}]}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->550882064,ExpressionUUID->"2c8a118a-8447-448c-b008-06e50728073f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->152410159,ExpressionUUID->"8bac8f78-73ca-4655-a0fb-da9fef3820e8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3"}], ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->636169064,ExpressionUUID->"6cc4647e-1ee1-4525-b30d-d7ed09edd74b"]
}, Open  ]],

Cell["We see that w'=R1(R2(w)).", "ExampleText",
 CellID->807442745,ExpressionUUID->"c0e19098-1222-4c53-a04c-43ceebd42a39"]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"44bf4418-a4be-4b2a-9586-aa06f70e956e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"30804bea-b9b2-4b83-8ba2-5c9be727dda4"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"d1f5273c-e37f-46b7-b8f3-fea75319e348"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["CartanMatrix"]],"paclet:GroupMath/ref/CartanMatrix"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"e226476c-53ef-4f36-8648-ae1136369b8a"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["DominantWeights"]],"paclet:GroupMath/ref/DominantWeights"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"7bdad77d-035a-4494-b860-621b61deaf52"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["ReflectWeights"]],"paclet:GroupMath/ref/ReflectWeights"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"ad9874d8-dedd-4911-b385-ec4d27aa905e"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["WeylOrbit"]],"paclet:GroupMath/ref/WeylOrbit"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"a66e1ded-5d7d-4e10-bc0c-95fab9b8d61e"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{Cell[
     TextData["Weights"]],"paclet:GroupMath/ref/Weights"},
   "RefLink",
   BaseStyle->{"InlineFormula", FontFamily -> "Verdana"}]], "InlineFormula",
  ExpressionUUID->"56397d1c-a470-40b1-baf6-55725db8a9b7"]
}], "SeeAlso",
 CellID->1038487239,ExpressionUUID->"1c6aa2a3-6e14-4cdb-9358-ee7bff83adcf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"0ac18eeb-d222-44a4-855d-da197473e162"],
 "Tutorials"
}], "TutorialsSection",
 WholeCellGroupOpener->True,
 CellID->250839057,ExpressionUUID->"5ee7cf2e-000d-44fe-a2ec-a8f760fd9f41"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"909514c8-f81b-4150-a2f7-3a238e4b35ff"],

Cell[BoxData[
 TemplateBox[{Cell[
    TextData["GroupMath Tutorial"]],"paclet:GroupMath/tutorial/GroupMathDoc"},
  "RefLink",
  BaseStyle->"Tutorials"]], "Tutorials",
 CellID->341631938,ExpressionUUID->"4263e1d0-7a75-4322-811f-36c25f308fc7"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"ec11c268-336b-4348-835a-9d304a5d52c9"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DominantConjugate",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Mathematica", ButtonData -> "paclet:GroupMath/guide/GroupMath", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2020, 10, 29, 13, 13, 10.6314641}", 
    "history" -> {"1.0", "", "", ""}, "context" -> "GroupMath`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Group Math Symbol", "language" -> "en", "paclet" -> "GroupMath", 
    "status" -> "None", "summary" -> 
    "DominantConjugate[group, weight] Calculates the dominant weight \
associated with a weight of a simple Lie group representation by Weyl \
reflections, as well as the minimum number of such reflections", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "DominantConjugate", 
    "titlemodifier" -> "", "windowtitle" -> "DominantConjugate", "type" -> 
    "Symbol", "uri" -> "GroupMath/ref/DominantConjugate", 
    "WorkflowDockedCell" -> ""}, "SearchTextTranslated" -> "", "NewStyles" -> 
  False},
CellContext->"Global`",
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> {"NewStyles" -> False}, FrontEndVersion -> 
  "12.0 for Microsoft Windows (64-bit) (April 8, 2019)", StyleDefinitions -> 
  FrontEnd`FileName[{$RootDirectory, "C:", "Program Files", 
     "Wolfram Research", "Mathematica", "12.0", "AddOns", "Applications"}, 
    "Default_Style_MyVersion9.nb", CharacterEncoding -> "UTF-8"]]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9358, 246, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"2e0ddbce-bf4d-42a9-b157-6da431b849e9",
   CellTags->"PrimaryExamplesSection",
   CellID->152537207]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20320, 578}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[589, 21, 4512, 101, 53, "AnchorBarGrid",ExpressionUUID->"903501ad-f644-4881-9d5c-d17250c95d88",
 CellID->1],
Cell[CellGroupData[{
Cell[5126, 126, 402, 9, 52, "ObjectNameGrid",ExpressionUUID->"a571bd6e-43fb-4907-abc9-a80ff39672e8"],
Cell[5531, 137, 788, 16, 131, "Usage",ExpressionUUID->"57361aa6-e68e-4124-8da1-85958abdedf7",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6356, 158, 855, 21, 37, "NotesSection",ExpressionUUID->"a0adee54-2af5-4157-8182-8bac32e37109",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->147782174],
Cell[7214, 181, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"d23dadd5-aada-48ef-8357-930669058599"],
Cell[7303, 183, 407, 12, 70, "Notes",ExpressionUUID->"8aafacdd-c0fb-4599-bef0-a73dfbe171bb",
 CellID->1067943069],
Cell[7713, 197, 435, 11, 70, "Notes",ExpressionUUID->"865aaf92-1e2f-456e-a750-94477b8e1d9f",
 CellID->344864045],
Cell[8151, 210, 829, 21, 70, "Notes",ExpressionUUID->"97b9add6-93f4-499c-9a33-7c51b3322b7e",
 CellID->5853894],
Cell[8983, 233, 249, 6, 70, "Notes",ExpressionUUID->"4470c551-c262-4e72-b5ac-9973131665b6",
 CellID->57185730],
Cell[9235, 241, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"cf96c975-fd43-43d4-943c-64654323b66b"]
}, Closed]],
Cell[CellGroupData[{
Cell[9358, 246, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"2e0ddbce-bf4d-42a9-b157-6da431b849e9",
 CellTags->"PrimaryExamplesSection",
 CellID->152537207],
Cell[CellGroupData[{
Cell[9818, 261, 308, 7, 29, "ExampleSection",ExpressionUUID->"98b2c82d-24fc-480c-b76a-ea03376e04d2",
 CellID->188601814],
Cell[10129, 270, 197, 4, 38, "ExampleText",ExpressionUUID->"e921d5da-57af-4b64-be82-934c595cc0f6",
 CellID->344054462],
Cell[CellGroupData[{
Cell[10351, 278, 262, 7, 26, "Input",ExpressionUUID->"239de1cb-40d1-41f8-b742-f1035828a826",
 CellID->51795859],
Cell[10616, 287, 219, 6, 35, "Output",ExpressionUUID->"3b50ea6b-a8ff-4281-822a-04ba389bba12",
 CellID->24593025]
}, Open  ]],
Cell[10850, 296, 322, 5, 76, "ExampleText",ExpressionUUID->"cf8b8fe7-d9f6-47c2-b7a7-83b22bb691f8",
 CellID->17175475],
Cell[CellGroupData[{
Cell[11197, 305, 511, 14, 59, "Input",ExpressionUUID->"7588fb93-8cc0-4d99-9f5b-6c9f82ae31b2",
 CellID->371016001],
Cell[11711, 321, 189, 5, 35, "Output",ExpressionUUID->"4ab08649-18fd-4062-a189-40b68fbb8f3a",
 CellID->25362818],
Cell[11903, 328, 190, 5, 35, "Output",ExpressionUUID->"51fc4c07-90f1-4c4e-a158-2f94a9962b20",
 CellID->123667056]
}, Open  ]],
Cell[CellGroupData[{
Cell[12130, 338, 511, 14, 59, "Input",ExpressionUUID->"8d49a972-a460-4f1d-82e4-c9ea7cc19fe3",
 CellID->489344400],
Cell[12644, 354, 190, 5, 35, "Output",ExpressionUUID->"3b3e271a-ec9b-45e9-820e-3a8985b56ede",
 CellID->221592782],
Cell[12837, 361, 171, 4, 35, "Output",ExpressionUUID->"9f9761e0-0071-4cfa-8e20-526488b02f0c",
 CellID->215537425]
}, Open  ]],
Cell[CellGroupData[{
Cell[13045, 370, 533, 14, 70, "Input",ExpressionUUID->"864db86a-d6f9-4cca-bd83-0b97c91f206c",
 CellID->37169474],
Cell[13581, 386, 209, 6, 35, "Output",ExpressionUUID->"752ee104-7527-4486-95b4-9af9ccccc825",
 CellID->577413977],
Cell[13793, 394, 189, 5, 35, "Output",ExpressionUUID->"0cdb2dff-c278-4864-841b-f61c8e5e1ab7",
 CellID->40667243]
}, Open  ]],
Cell[CellGroupData[{
Cell[14019, 404, 511, 14, 70, "Input",ExpressionUUID->"2c8a118a-8447-448c-b008-06e50728073f",
 CellID->550882064],
Cell[14533, 420, 209, 6, 35, "Output",ExpressionUUID->"8bac8f78-73ca-4655-a0fb-da9fef3820e8",
 CellID->152410159],
Cell[14745, 428, 190, 5, 35, "Output",ExpressionUUID->"6cc4647e-1ee1-4525-b30d-d7ed09edd74b",
 CellID->636169064]
}, Open  ]],
Cell[14950, 436, 123, 1, 70, "ExampleText",ExpressionUUID->"c0e19098-1222-4c53-a04c-43ceebd42a39",
 CellID->807442745]
}, Open  ]],
Cell[15088, 440, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"44bf4418-a4be-4b2a-9586-aa06f70e956e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15211, 445, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"d1f5273c-e37f-46b7-b8f3-fea75319e348",
 CellID->1255426704],
Cell[15474, 454, 1850, 48, 70, "SeeAlso",ExpressionUUID->"1c6aa2a3-6e14-4cdb-9358-ee7bff83adcf",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[17361, 507, 262, 7, 70, "TutorialsSection",ExpressionUUID->"5ee7cf2e-000d-44fe-a2ec-a8f760fd9f41",
 CellID->250839057],
Cell[17626, 516, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"909514c8-f81b-4150-a2f7-3a238e4b35ff"],
Cell[17715, 518, 241, 5, 70, "Tutorials",ExpressionUUID->"4263e1d0-7a75-4322-811f-36c25f308fc7",
 CellID->341631938]
}, Open  ]],
Cell[17971, 526, 78, 0, 70, "FooterCell",ExpressionUUID->"ec11c268-336b-4348-835a-9d304a5d52c9"]
}
]
*)

(* End of internal cache information *)

